/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import com.ibm.ws.management.util.RasUtils;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBDeployOptionsHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static final TraceComponent tc = Tr.register(EJBDeployOptionsHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    @Override
    public AppDeploymentTask createTask(AppDeploymentController controller, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask", new String[]{"controller=" + controller, "taskName=" + taskName});
        }
        AppDeploymentTask task = null;
        try {
            String helperClassName = this.getClass().getName();
            int index = helperClassName.lastIndexOf("Helper");
            String taskClassName = helperClassName.substring(0, index);
            Class<?> taskClass = Class.forName(taskClassName);
            Class[] parameterTypes = new Class[]{AppDeploymentController.class};
            Constructor<?> constructor = taskClass.getDeclaredConstructor(parameterTypes);
            Object[] arguments = new Object[]{controller};
            task = (AppDeploymentTask)constructor.newInstance(arguments);
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "createTask", "83", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTask", task);
        }
        return task;
    }

    @Override
    public void prepareTask(AppDeploymentInfo installInfo, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask", new String[]{"installInfo=" + installInfo, "task=" + task});
        }
        if (task.getTaskData() == null) {
            String[] columnNames;
            Vector<String> data = new Vector<String>();
            for (String columnName : columnNames = task.getColumnNames()) {
                data.addElement(columnName);
            }
            Hashtable appOptions = installInfo.getAppOptions();
            Hashtable deployEjbOptions = (Hashtable)appOptions.get("deployejb.options");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prepareTask", "deployEjbOptions=" + deployEjbOptions);
            }
            for (String columnName : columnNames) {
                String value = "";
                Object option = null;
                if (deployEjbOptions != null) {
                    option = deployEjbOptions.get(columnName);
                }
                if (option != null) {
                    value = option instanceof Boolean ? (((Boolean)option).booleanValue() ? "AppDeploymentOption.Yes" : "AppDeploymentOption.No") : (option instanceof String ? (String)option : option.toString());
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prepareTask", "no value specified for " + columnName);
                }
                data.addElement(value);
            }
            String[][] taskData = util.buildTaskData(data, columnNames.length);
            task.setTaskData(taskData);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "prepareTask", "task data already exists");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    @Override
    public void completeTask(AppDeploymentInfo installInfo, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask", new String[]{"installInfo=" + installInfo, "task=" + task});
        }
        if (!task.isTaskEmpty() && !task.isTaskDisabled()) {
            String[][] taskData = task.getTaskData();
            Hashtable<String, Object> deployEjbOptions = new Hashtable<String, Object>();
            for (int i = 0; i < taskData[0].length; ++i) {
                if (taskData[1][i] != null) {
                    if (taskData[1][i].equals("AppDeploymentOption.Yes")) {
                        deployEjbOptions.put(taskData[0][i], Boolean.TRUE);
                        continue;
                    }
                    if (taskData[1][i].equals("AppDeploymentOption.No")) {
                        deployEjbOptions.put(taskData[0][i], Boolean.FALSE);
                        continue;
                    }
                    String value = taskData[1][i];
                    if (value.equals("\"\"") || value.trim().equals("") || value.equalsIgnoreCase("null")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "completeTask", "taskData[1][" + i + "]: replace \"" + value + "\" with null");
                        }
                        value = null;
                    }
                    if (value == null) continue;
                    deployEjbOptions.put(taskData[0][i], value);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "completeTask", "taskData[1][" + i + "] is null");
            }
            Hashtable appOptions = installInfo.getAppOptions();
            appOptions.put("deployejb.options", deployEjbOptions);
            installInfo.setAppOptions(appOptions);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "completeTask", "task is empty or disabled");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    @Override
    public Hashtable<String, String> getXPathInfo(Vector allTypes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXPathInfo", "allTypes=" + allTypes);
        }
        Hashtable<String, String> xpathInfo = null;
        if (allTypes.contains(ModuleType.EJB)) {
            xpathInfo = new Hashtable<String, String>();
            ModuleType moduleType = allTypes.contains(ModuleType.EAR) ? ModuleType.EAR : ModuleType.EJB;
            xpathInfo.put(moduleType.toString(), "/");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXPathInfo", xpathInfo);
        }
        return xpathInfo;
    }

    @Override
    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcBeanImpl, String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "taskData2DCBean", new String[]{"task=" + task, "dcBeanImpl=" + dcBeanImpl, "uri=" + uri});
        }
        J2EEDeployUtil.allTaskData2DC(task, dcBeanImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "taskData2DCBean");
        }
    }

    @Override
    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dcBean2TaskData", new String[]{"task=" + task, "keys=" + keys, "props=" + props});
        }
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dcBean2TaskData");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/client/EJBDeployOptionsHelper.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.12");
        }
        CLASS_NAME = EJBDeployOptionsHelper.class.getName();
    }
}

