/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployOptions;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.client.util;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Vector;

public class EJBDeployOptions
extends AppDeploymentTask {
    private static final long serialVersionUID = 7102233199234937176L;
    public static final String TASK_NAME = "EJBDeployOptions";
    public static final int COLUMN_INDEX_CLASSPATH = 0;
    public static final int COLUMN_INDEX_RMIC = 1;
    public static final int COLUMN_INDEX_DB_TYPE = 2;
    public static final int COLUMN_INDEX_DB_SCHEMA = 3;
    public static final int TOTAL_COLUMNS_PRE_V7 = 4;
    public static final int COLUMN_INDEX_COMPLIANCE_LEVEL = 4;
    public static final int COLUMN_INDEX_DB_ACCESS_TYPE = 5;
    public static final int COLUMN_INDEX_SQLJ_CLASSPATH = 6;
    public static final int TOTAL_COLUMNS = 7;
    private static final TraceComponent tc = Tr.register(EJBDeployOptions.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    public EJBDeployOptions(AppDeploymentController controller) {
        super(controller);
        int totalColumns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", "controller=" + controller);
        }
        this.name = TASK_NAME;
        int clientMajorVersion = this.getClientMajorVersion();
        int n = totalColumns = clientMajorVersion >= 7 ? 7 : 4;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", "totalColumns=" + totalColumns);
        }
        this.colNames = new String[totalColumns];
        this.colNames[0] = "deployejb.classpath";
        this.colNames[1] = "deployejb.rmic";
        this.colNames[2] = "deployejb.dbtype";
        this.colNames[3] = "deployejb.dbschema";
        if (this.colNames.length > 4) {
            this.colNames[4] = "deployejb.complianceLevel";
            this.colNames[5] = "deployejb.dbaccesstype";
            this.colNames[6] = "deployejb.sqljclasspath";
        }
        this.mutables = new boolean[totalColumns];
        this.mutables[0] = true;
        this.mutables[1] = true;
        this.mutables[2] = true;
        this.mutables[3] = true;
        if (this.mutables.length > 4) {
            this.mutables[4] = true;
            this.mutables[5] = true;
            this.mutables[6] = true;
        }
        this.requiredColumns = new boolean[totalColumns];
        this.requiredColumns[0] = false;
        this.requiredColumns[1] = false;
        this.requiredColumns[2] = false;
        this.requiredColumns[3] = false;
        if (this.requiredColumns.length > 4) {
            this.requiredColumns[4] = false;
            this.requiredColumns[5] = false;
            this.requiredColumns[6] = false;
        }
        assert (this.colNames.length == this.mutables.length) : "column length mismatch";
        assert (this.colNames.length == this.requiredColumns.length) : "column length mismatch";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public boolean isDBTypeSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDBTypeSet");
        }
        boolean dbTypeSet = false;
        if (this.taskData != null && !this.isTaskEmpty) {
            String dbType = this.taskData[1][2];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isDBTypeSet", "dbType=" + dbType);
            }
            if (!(dbType == null || dbType.equals("\"\"") || dbType.trim().equals("") || dbType.equalsIgnoreCase("null"))) {
                dbTypeSet = true;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isDBTypeSet", "no task data or task is empty");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDBTypeSet", Boolean.toString(dbTypeSet));
        }
        return dbTypeSet;
    }

    public String[] validate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        this.taskValidateErrorMessages = null;
        if (this.taskData != null && !this.isTaskEmpty) {
            String message;
            String[] supportedValues;
            Vector<String> messages = new Vector<String>();
            if (!this.isNullOrEmpty(this.taskData[1][2])) {
                boolean validType;
                String dbType = this.taskData[1][2];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validate", "dbType=" + dbType);
                }
                if (!(validType = this.contains(dbType, supportedValues = DeployOptions.getDatabaseTypes()))) {
                    String pattern = util.getMessage(this, "ADMA0018W");
                    String message2 = MessageFormat.format(pattern, dbType, this.arrayToDisplayString(supportedValues));
                    messages.addElement(message2);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate", "dbtype not specified");
            }
            if (this.taskData[1].length > 4) {
                if (!this.isNullOrEmpty(this.taskData[1][4])) {
                    String complianceLevel = this.taskData[1][4];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "validate", "complianceLevel=" + complianceLevel);
                    }
                    if (!this.contains(complianceLevel, supportedValues = DeployOptions.getJdkComplianceLevels())) {
                        String pattern = util.getMessage(this, "ADMA0039W");
                        message = MessageFormat.format(pattern, complianceLevel, this.arrayToDisplayString(supportedValues));
                        messages.addElement(message);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validate", "complianceLevel not specified");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate", "complianceLevel not available");
            }
            if (this.taskData[1].length > 5) {
                if (!this.isNullOrEmpty(this.taskData[1][5])) {
                    String dbAccessType = this.taskData[1][5];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "validate", "dbAccessType=" + dbAccessType);
                    }
                    if (!this.contains(dbAccessType, supportedValues = DeployOptions.getDeployEJBOptions())) {
                        String pattern = util.getMessage(this, "ADMA0032W");
                        message = MessageFormat.format(pattern, dbAccessType, this.arrayToDisplayString(supportedValues));
                        messages.addElement(message);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validate", "dbaccesstype not specified");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validate", "dbaccesstype not available");
            }
            this.buildErrorMessages(messages);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validate", "no task data or task is empty");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate", Arrays.toString(this.taskValidateErrorMessages));
        }
        return this.taskValidateErrorMessages;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private boolean contains(String value, String[] values) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains", new String[]{"value=" + value, "values=" + Arrays.toString(values)});
        }
        boolean result = false;
        String normalizedValue = value.trim().toLowerCase();
        for (String s : values) {
            if (!normalizedValue.equals(s.trim().toLowerCase())) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contains", Boolean.toString(result));
        }
        return result;
    }

    private String arrayToDisplayString(String[] array) {
        StringBuilder stringBuilder = new StringBuilder(128);
        for (int i = 0; i < array.length; ++i) {
            stringBuilder.append(array[i]);
            if (i >= array.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private boolean isNullOrEmpty(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNullOrEmpty", "string=" + string);
        }
        boolean result = true;
        if (string != null && !string.trim().equals("") && !string.toLowerCase().trim().equals("null")) {
            result = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNullOrEmpty", Boolean.toString(result));
        }
        return result;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/client/EJBDeployOptions.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.19");
        }
        CLASS_NAME = EJBDeployOptions.class.getName();
    }
}

