/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndPackage;
import com.ibm.ejs.models.base.bindings.commonbnd.Property;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.DataSourceFor10EJBModules;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class DataSourceFor10EJBModulesHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register(DataSourceFor10EJBModulesHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        int appVersion = ((XMLResource)appInstallInfo.getApplication().eResource()).getVersionID();
        for (int i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            if (jar.getContainerManagedBeans().size() <= 0) continue;
            boolean found1XCMP = false;
            if (((XMLResource)jar.eResource()).getVersionID() >= 13) {
                EList ejbBindings = ejbJarBinding.getEjbBindings();
                for (int j = 0; j < ejbBindings.size(); ++j) {
                    EnterpriseBean ejb = ((EnterpriseBeanBinding)ejbBindings.get(j)).getEnterpriseBean();
                    if (ejb == null) continue;
                    if (ejb.eIsProxy()) {
                        Tr.warning(tc, "ADMA0091E", new String[]{ejbBindings.get(j).toString(), ejbJarBinding.eResource().getURI().toString(), appInstallInfo.getModuleFileForDD(jar).getURI(), ejb.toString()});
                        continue;
                    }
                    if (ejb == null || ejb.getVersionID() != 11 || !ejb.isContainerManagedEntity()) continue;
                    found1XCMP = true;
                    break;
                }
            } else {
                found1XCMP = true;
            }
            if (!found1XCMP) continue;
            this.GetEJB1_0DataSource(appInstallInfo, ejbJarBinding, jar, data, appVersion, t.getCallerVersion());
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void GetEJB1_0DataSource(AppDeploymentInfo appInstallInfo, EJBJarBinding ejbJarBinding, EJBJar jar, Vector data, int appVersion, String callerVersion) throws AppDeploymentException {
        ResourceRefBinding defaultDataSource;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "GetEJB1_0DataSource");
        }
        if ((defaultDataSource = ejbJarBinding.getDefaultDatasource()) != null) {
            this.addTaskData(appInstallInfo, jar, defaultDataSource, data, appVersion, callerVersion);
        } else if (jar.getContainerManagedBeans().size() > 0) {
            this.addTaskData(appInstallInfo, jar, defaultDataSource, data, appVersion, callerVersion);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "GetEJB1_0DataSource");
        }
    }

    private void addTaskData(AppDeploymentInfo appInfo, EJBJar jar, ResourceRefBinding defaultDataSource, Vector data, int appVersion, String callerVersion) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTask");
        }
        data.addElement(Integer.toString(appVersion));
        data.addElement(util.getModuleName(appInfo, jar));
        data.addElement(util.formUriString(appInfo, jar));
        data.addElement(defaultDataSource.getJndiName());
        if (defaultDataSource.getDefaultAuth() != null) {
            data.addElement(((BasicAuthData)defaultDataSource.getDefaultAuth()).getUserId());
            data.addElement(((BasicAuthData)defaultDataSource.getDefaultAuth()).getPassword());
        } else {
            data.addElement("");
            data.addElement("");
        }
        if (!"5".equals(callerVersion)) {
            String lc = defaultDataSource.getLoginConfigurationName();
            data.addElement(lc);
            EList props = defaultDataSource.getProperties();
            Object prop = null;
            String pp = "";
            if (props != null && props.size() != 0) {
                pp = lc != null && lc.equals("DefaultPrincipalMapping") ? ((Property)props.get(0)).getValue() : util.getPropertiesInString(props);
            }
            data.addElement(pp);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            CommonbndPackage commonPkg = (CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi");
            CommonbndFactory commonFact = commonPkg.getCommonbndFactory();
            Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
            Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
            for (int i = 0; i < ejbJars.size(); ++i) {
                EJBJar ejbJar = (EJBJar)ejbJars.elementAt(i);
                String[] matchingTaskData = null;
                String[][] taskData = t.getTaskData();
                for (int j = 0; j < taskData.length; ++j) {
                    DataSourceFor10EJBModules cfr_ignored_0 = (DataSourceFor10EJBModules)t;
                    if (taskData[j].length <= 1) continue;
                    DataSourceFor10EJBModules cfr_ignored_1 = (DataSourceFor10EJBModules)t;
                    if (!util.getModuleName(appInstallInfo, ejbJar).equals(taskData[j][1])) continue;
                    DataSourceFor10EJBModules cfr_ignored_2 = (DataSourceFor10EJBModules)t;
                    if (!util.compareUriString(appInstallInfo, ejbJar, taskData[j][2])) continue;
                    matchingTaskData = taskData[j];
                    break;
                }
                if (matchingTaskData == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No matching task data for ejb module " + util.getModuleName(appInstallInfo, ejbJar));
                    continue;
                }
                EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
                DataSourceFor10EJBModules cfr_ignored_3 = (DataSourceFor10EJBModules)t;
                if (matchingTaskData.length <= 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Wrong task data format " + taskData);
                    }
                    Object[] objectArray = new Object[1];
                    DataSourceFor10EJBModules cfr_ignored_4 = (DataSourceFor10EJBModules)t;
                    objectArray[0] = matchingTaskData[1];
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0056E"), objectArray), null);
                }
                DataSourceFor10EJBModules cfr_ignored_5 = (DataSourceFor10EJBModules)t;
                ejbJarBinding.getDefaultDatasource().setJndiName((String)matchingTaskData[3]);
                DataSourceFor10EJBModules cfr_ignored_6 = (DataSourceFor10EJBModules)t;
                if (matchingTaskData.length > 5) {
                    if (ejbJarBinding.getDefaultDatasource().getDefaultAuth() != null) {
                        DataSourceFor10EJBModules cfr_ignored_7 = (DataSourceFor10EJBModules)t;
                        ((BasicAuthData)ejbJarBinding.getDefaultDatasource().getDefaultAuth()).setUserId(matchingTaskData[4]);
                        DataSourceFor10EJBModules cfr_ignored_8 = (DataSourceFor10EJBModules)t;
                        ((BasicAuthData)ejbJarBinding.getDefaultDatasource().getDefaultAuth()).setPassword(matchingTaskData[5]);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Wrong task data format " + matchingTaskData);
                    }
                    Object[] objectArray = new Object[1];
                    DataSourceFor10EJBModules cfr_ignored_9 = (DataSourceFor10EJBModules)t;
                    objectArray[0] = matchingTaskData[1];
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0057E"), objectArray), null);
                }
                if ("5".equals(t.getCallerVersion())) continue;
                String lName = null;
                String prop = null;
                DataSourceFor10EJBModules cfr_ignored_10 = (DataSourceFor10EJBModules)t;
                if (matchingTaskData.length > DataSourceFor10EJBModules.loginConfigColumn) {
                    DataSourceFor10EJBModules cfr_ignored_11 = (DataSourceFor10EJBModules)t;
                    lName = matchingTaskData[DataSourceFor10EJBModules.loginConfigColumn];
                    if (lName != null && !lName.trim().equals("")) {
                        ejbJarBinding.getDefaultDatasource().setLoginConfigurationName(lName);
                    } else {
                        ejbJarBinding.getDefaultDatasource().unsetLoginConfigurationName();
                        EList props = ejbJarBinding.getDefaultDatasource().getProperties();
                        if (props.size() > 0) {
                            props.clear();
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Wrong task data format " + taskData);
                }
                DataSourceFor10EJBModules cfr_ignored_12 = (DataSourceFor10EJBModules)t;
                if (matchingTaskData.length > DataSourceFor10EJBModules.authPropsColumn) {
                    DataSourceFor10EJBModules cfr_ignored_13 = (DataSourceFor10EJBModules)t;
                    prop = matchingTaskData[DataSourceFor10EJBModules.authPropsColumn];
                    if (prop == null || prop.trim().equals("")) continue;
                    this.setUpProps(commonFact, ejbJarBinding.getDefaultDatasource(), lName, prop);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Wrong task data format " + taskData);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        if (!allTypes.contains(ModuleType.EJB)) {
            return null;
        }
        Hashtable<String, String> tbl = new Hashtable<String, String>();
        tbl.put(ModuleType.EJB.toString(), "/ejb-jar[enterprise-beans/entity/cmp-version='1.x']");
        return tbl;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        J2EEDeployUtil.moduleTask2DC(task, dcImpl, uri, 2);
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }

    private void setUpProps(CommonbndFactory commonFact, ResourceRefBinding rrb, String loginConfig, String auth) {
        EList props = rrb.getProperties();
        if (props.size() > 0) {
            props.clear();
        }
        Property prop = null;
        Object attrList = null;
        if (loginConfig != null && loginConfig.equals("DefaultPrincipalMapping")) {
            prop = commonFact.createProperty();
            prop.setName("com.ibm.mapping.authDataAlias");
            prop.setValue(auth);
            prop.setDescription("description");
            props.add(prop);
            return;
        }
        String pStr = auth;
        String[] ps = new String[]{pStr};
        if (pStr.indexOf(43) != -1) {
            ps = pStr.split("\\+");
        }
        for (int ii = 0; ii < ps.length; ++ii) {
            prop = commonFact.createProperty();
            ObjectName o = null;
            try {
                o = new ObjectName(ps[ii]);
                String w = null;
                w = o.getKeyProperty("name");
                prop.setName(w);
                w = o.getKeyProperty("value");
                if (w.equals("\"\"")) {
                    w = "";
                }
                prop.setValue(w);
                w = o.getKeyProperty("description");
                prop.setDescription(w);
                props.add(prop);
                continue;
            }
            catch (MalformedObjectNameException ex) {
                // empty catch block
            }
        }
    }
}

