/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import com.ibm.ws.management.util.RasUtils;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtxRootForWebModHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register(CtxRootForWebModHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String TASK_NAME = "CtxRootForWebMod";
    private static final String[] COLUMNS;
    public static final int COLUMN_INDEX_WEB_MODULE = 0;
    public static final int COLUMN_INDEX_URI = 1;
    public static final int COLUMN_INDEX_CONTEXT_ROOT = 2;
    public static final String DEFAULT_CONTEXT_ROOT = "/";
    private String[] taskValidateErrorMessages = null;

    @Override
    public AppDeploymentTask createTask(AppDeploymentController controller, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask", new String[]{"controller=" + controller, "taskName=" + taskName});
        }
        assert (TASK_NAME.equals(taskName)) : "unexpected task name " + taskName;
        WASDeploymentTask task = null;
        try {
            task = new WASDeploymentTask(controller, TASK_NAME, COLUMNS, new boolean[]{false, false, false}, new boolean[]{false, false, true}, new boolean[]{false, false, false}, true);
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "createTask", "106", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTask", task);
        }
        return task;
    }

    @Override
    public void prepareTask(AppDeploymentInfo installInfo, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask", new String[]{"installInfo=" + installInfo, "task=" + task});
        }
        if (task.getTaskData() == null) {
            String[] columnNames;
            Vector<String> data = new Vector<String>();
            for (String columnName : columnNames = task.getColumnNames()) {
                data.addElement(columnName);
            }
            Map<String, WebApp> map = this.buildWebAppMap(installInfo);
            Application application = installInfo.getApplication();
            EList modules = application.getModules();
            for (Module module : modules) {
                if (!module.isWebModule()) continue;
                WebModule webModule = (WebModule)module;
                String moduleUri = this.formModuleUri(module);
                WebApp webApp = map.get(moduleUri);
                if (webApp != null) {
                    String moduleName = util.getModuleName(installInfo, webApp);
                    String contextRoot = webModule.getContextRoot();
                    data.addElement(moduleName);
                    data.addElement(moduleUri);
                    data.addElement(contextRoot);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prepareTask", "web app not found for uri " + moduleUri);
                }
                assert (false) : "web app not found for uri " + moduleUri;
            }
            String[][] taskData = util.buildTaskData(data, columnNames.length);
            task.setTaskData(taskData);
            this.checkIfSufficientlyDone(installInfo, task);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "prepareTask", "task data already exists");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    @Override
    public void completeTask(AppDeploymentInfo installInfo, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask", new String[]{"installInfo=" + installInfo, "task=" + task});
        }
        if (!task.isTaskEmpty() && !task.isTaskDisabled()) {
            String[][] taskData = task.getTaskData();
            Map<String, WebModule> map = this.buildWebModuleMap(installInfo);
            for (int i = 1; i < taskData.length; ++i) {
                String moduleName = taskData[i][0];
                String uri = taskData[i][1];
                String contextRoot = taskData[i][2];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask", new String[]{"moduleName=" + moduleName, "uri=" + uri, "contextRoot=" + contextRoot});
                }
                if (AppUtils.isEmpty(contextRoot)) continue;
                WebModule webModule = map.get(uri);
                if (webModule != null) {
                    if (!contextRoot.equals(webModule.getContextRoot())) {
                        webModule.setContextRoot(contextRoot);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "completeTask", "webModule=" + webModule);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "completeTask", "context root unchanged");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "completeTask", "web module not found for uri " + uri);
                }
                assert (false) : "web module not found for uri " + uri;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "completeTask", "task is empty or disabled");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    @Override
    public Hashtable<String, String> getXPathInfo(Vector allTypes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXPathInfo", "allTypes=" + allTypes);
        }
        Hashtable<String, String> xpathInfo = null;
        if (allTypes.contains(ModuleType.WAR)) {
            xpathInfo = new Hashtable<String, String>();
            xpathInfo.put(ModuleType.WAR.toString(), DEFAULT_CONTEXT_ROOT);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXPathInfo", xpathInfo);
        }
        return xpathInfo;
    }

    @Override
    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcBeanImpl, String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "taskData2DCBean", new String[]{"task=" + task, "dcBeanImpl=" + dcBeanImpl, "uri=" + uri});
        }
        J2EEDeployUtil.moduleTask2DC(task, dcBeanImpl, uri, 1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "taskData2DCBean");
        }
    }

    @Override
    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dcBean2TaskData", new String[]{"task=" + task, "keys=" + keys, "props=" + props});
        }
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dcBean2TaskData");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private String formModuleUri(Module module) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formModuleUri", "module=" + module);
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(module.getUri());
        stringBuilder.append(',');
        String altDD = module.getAltDD();
        if (altDD != null) {
            stringBuilder.append(altDD);
        } else {
            stringBuilder.append("WEB-INF/web.xml");
        }
        String moduleUri = stringBuilder.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formModuleUri", moduleUri);
        }
        return moduleUri;
    }

    private Map<String, WebApp> buildWebAppMap(AppDeploymentInfo installInfo) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildWebAppMap", "installInfo=" + installInfo);
        }
        HashMap<String, WebApp> map = new HashMap<String, WebApp>();
        Vector wars = installInfo.getModuleConfig("WAR_DD");
        for (WebApp webApp : wars) {
            try {
                String webAppUri = util.formUriString(installInfo, webApp);
                map.put(webAppUri, webApp);
            }
            catch (Exception e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "buildWebAppMap", "349", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildWebAppMap", map);
        }
        return map;
    }

    private Map<String, WebModule> buildWebModuleMap(AppDeploymentInfo installInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildWebModuleMap", "installInfo=" + installInfo);
        }
        HashMap<String, WebModule> map = new HashMap<String, WebModule>();
        Application application = installInfo.getApplication();
        EList modules = application.getModules();
        for (Module module : modules) {
            if (!module.isWebModule()) continue;
            String moduleUri = this.formModuleUri(module);
            WebModule webModule = (WebModule)module;
            map.put(moduleUri, webModule);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildWebModuleMap", map);
        }
        return map;
    }

    private void checkIfSufficientlyDone(AppDeploymentInfo installInfo, AppDeploymentTask task) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfSufficientlyDone", new String[]{"installInfo=" + installInfo, "task=" + task});
        }
        boolean standaloneWebModule = installInfo.containsURI(null, "META-INF/was.webmodule");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checkIfSufficientlyDone", "standaloneWebModule=" + standaloneWebModule);
        }
        if (standaloneWebModule) {
            Hashtable options;
            Application application = installInfo.getApplication();
            EList modules = application.getModules();
            assert (modules.size() == 1) : "standalone web module should only contain 1 module";
            WebModule webModule = (WebModule)modules.get(0);
            String contextRoot = webModule.getContextRoot();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkIfSufficientlyDone", "contextRoot=" + contextRoot);
            }
            boolean defaultContextRoot = contextRoot == null || DEFAULT_CONTEXT_ROOT.equals(contextRoot);
            AppDeploymentController controller = task.getAppDeploymentController();
            Hashtable hashtable = options = controller != null ? controller.getAppOptions() : new Hashtable();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkIfSufficientlyDone", "options=" + options);
            }
            boolean contextRootInOptions = options.containsKey("contextroot");
            if (defaultContextRoot && !contextRootInOptions) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checkIfSufficientlyDone", "setting isSufficientlyDone to false");
                }
                task.setIsSufficientlyDone(false);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checkIfSufficientlyDone", "isSufficientlyDone=" + task.isSufficientlyDone());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfSufficientlyDone");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/client/CtxRootForWebModHelper.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.17");
        }
        CLASS_NAME = CtxRootForWebModHelper.class.getName();
        COLUMNS = new String[]{"webModule", "uri", "web.contextroot"};
    }
}

