/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import java.text.MessageFormat;
import java.util.Vector;

public class BindJndiForEJBNonMessageBinding
extends AppDeploymentTask {
    private static final long serialVersionUID = 859249300126679073L;
    private static TraceComponent tc = Tr.register(BindJndiForEJBNonMessageBinding.class);
    private static final int totalColumns = 7;
    private static final int prev7TotalColumns = 4;
    public static final int ejbModuleColumn = 0;
    public static final int ejbColumn = 1;
    public static final int uriColumn = 2;
    public static final int jndiColumn = 3;
    public static final int moduleVersionColumn = 4;
    public static final int localHomeJndiColumn = 5;
    public static final int remoteHomeJndiColumn = 6;
    public static final String TaskName = "BindJndiForEJBNonMessageBinding";

    public BindJndiForEJBNonMessageBinding(AppDeploymentController flowController) {
        super(flowController);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, TaskName);
        }
        this.name = TaskName;
        String clientVersion = this.getCallerVersion();
        if ("5".equals(clientVersion) || "6".equals(clientVersion)) {
            this.colNames = new String[4];
            this.mutables = new boolean[4];
            this.requiredColumns = new boolean[4];
            this.hiddenColumns = new boolean[4];
        } else {
            this.colNames = new String[7];
            this.mutables = new boolean[7];
            this.requiredColumns = new boolean[7];
            this.hiddenColumns = new boolean[7];
        }
        this.colNames[0] = "EJBModule";
        this.colNames[1] = "EJB";
        this.colNames[2] = "uri";
        this.colNames[3] = "JNDI";
        this.mutables[0] = false;
        this.mutables[1] = false;
        this.mutables[2] = false;
        this.mutables[3] = true;
        this.requiredColumns[0] = false;
        this.requiredColumns[1] = false;
        this.requiredColumns[2] = false;
        this.hiddenColumns[0] = false;
        this.hiddenColumns[1] = false;
        this.hiddenColumns[2] = false;
        this.hiddenColumns[3] = false;
        if (!"5".equals(clientVersion) && !"6".equals(clientVersion)) {
            this.colNames[4] = "ModuleVersion";
            this.colNames[5] = "localHomeJndi";
            this.colNames[6] = "remoteHomeJndi";
            this.mutables[4] = false;
            this.mutables[5] = true;
            this.mutables[6] = true;
            this.requiredColumns[3] = false;
            this.requiredColumns[4] = false;
            this.requiredColumns[5] = false;
            this.requiredColumns[6] = false;
            this.hiddenColumns[4] = true;
            this.hiddenColumns[5] = false;
            this.hiddenColumns[6] = false;
            this.hasHiddenColumns = true;
        } else {
            this.requiredColumns[3] = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, TaskName);
        }
    }

    public String[] validate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Vector<String> errorMessages = new Vector<String>();
        this.taskValidateErrorMessages = null;
        if (this.taskData != null && this.colNames.length > 4) {
            for (int i = 1; i < this.taskData.length; ++i) {
                int moduleVersion = Integer.valueOf(this.taskData[i][4]);
                if (AppUtils.isEmpty(this.taskData[i][3])) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "module version is " + moduleVersion);
                    }
                    if (moduleVersion < 30) {
                        String error = MessageFormat.format(util.getMessage(this, "ADMA0002E"), util.getGoalTitle(this, this.name), this.taskData[i][1], this.taskData[i][0]);
                        errorMessages.addElement(error);
                    }
                }
                if (moduleVersion < 30) continue;
                String localJndi = this.taskData[i][5];
                String remoteJndi = this.taskData[i][6];
                if (AppUtils.isEmpty(this.taskData[i][3]) || AppUtils.isEmpty(this.taskData[i][5]) && AppUtils.isEmpty(this.taskData[i][6])) continue;
                String error = MessageFormat.format(util.getMessage(this, "ADMA0205E"), util.getGoalTitle(this, this.name), this.taskData[i][1], this.taskData[i][0]);
                errorMessages.addElement(error);
            }
            this.buildErrorMessages(errorMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return this.taskValidateErrorMessages;
    }

    public void setTaskData(String[][] data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTaskData for BindJndiForEJBNonMessageBinding");
        }
        super.setTaskData(data);
        if (this.taskData != null && this.colNames.length > 4) {
            this.isSufficientlyDone = true;
            for (int i = 1; i < this.taskData.length; ++i) {
                int moduleVersion = Integer.valueOf(this.taskData[i][4]);
                if (moduleVersion >= 30 || !AppUtils.isEmpty(this.taskData[i][3])) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "missing jndi for non ejb3 module, set isSufficientlyDone to false");
                }
                this.isSufficientlyDone = false;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTaskData");
        }
    }
}

