/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.cdfj2eebridge.CDFBridgeExtensionHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.wsspi.management.bla.model.AssetFactory;
import com.ibm.wsspi.management.bla.model.AssetInFactory;
import com.ibm.wsspi.management.bla.model.AssetSpec;
import com.ibm.wsspi.management.bla.model.BLASpec;
import com.ibm.wsspi.management.bla.model.CompositionUnitSpec;
import com.ibm.wsspi.management.bla.op.OperationContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.CompatibilityDescriptionGroup;
import org.eclipse.jst.j2ee.common.DisplayName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppInstallHelper {
    private static final TraceComponent tc = Tr.register(AppInstallHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    public static final String STANDALONE_WEB_MARKER = "META-INF/was.webmodule";
    public static final String STANDALONE_EJB_MARKER = "META-INF/was.ejbmodule";
    public static final String DEFAULT_CONTEXT_ROOT = "/";
    private static final String MOF_PATH_SEPERATOR = "/";
    public static boolean _tempDirCreated;

    public static EARFile getEarFile(String filePath, boolean useReflection, ResourceBundle resBundle) throws AppDeploymentException {
        return AppInstallHelper.getEarFile(filePath, useReflection, false, resBundle);
    }

    public static EARFile getEarFile(String filePath, boolean useReflection, boolean readOnly, ResourceBundle resBundle) throws AppDeploymentException {
        return (EARFile)AppInstallHelper.getArchive(filePath, useReflection, readOnly, resBundle, true, null, null);
    }

    public static EARFile getEarFile(String filePath, boolean useReflection, boolean readOnly, ResourceBundle resBundle, String binariesURL, String binariesLocation) throws AppDeploymentException {
        return (EARFile)AppInstallHelper.getArchive(filePath, useReflection, readOnly, resBundle, true, binariesURL, binariesLocation);
    }

    public static Archive getArchive(String filePath, boolean useReflection, boolean isReadOnly, ResourceBundle resBundle, boolean isEar) throws AppDeploymentException {
        return AppInstallHelper.getArchive(filePath, useReflection, isReadOnly, resBundle, isEar, null, null);
    }

    public static Archive getArchive(String filePath, boolean useReflection, boolean isReadOnly, ResourceBundle resBundle, boolean isEar, String binariesURL, String binariesLocation) throws AppDeploymentException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getArchive " + filePath);
            }
            Archive archive = null;
            CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
            ArchiveOptions opt = new ArchiveOptions();
            opt.setUseJavaReflection(useReflection);
            opt.setIsReadOnly(isReadOnly);
            opt.setParentClassLoader(ExtClassLoader.getInstance());
            String tempDir = null;
            if (!_tempDirCreated) {
                _tempDirCreated = true;
                tempDir = System.getProperty("user.install.root");
                if (tempDir != null) {
                    tempDir = tempDir + "/wstemp/appdepl" + Long.toHexString(System.currentTimeMillis());
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Right before setting temp directory name.");
                        }
                        ArchiveUtil.setTempDirectoryName(tempDir);
                    }
                    catch (ArchiveException ae) {
                        RasUtils.logException(ae, tc, CLASS_NAME, "getArchive", "227", null, new Object[]{"tempDir=" + tempDir});
                    }
                }
            }
            tempDir = ArchiveUtil.getTempDirectoryName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "temp is:  " + (tempDir != null ? tempDir : "using default temp"));
            }
            if (isEar) {
                AppInstallHelper.registerIfLoose(binariesURL, binariesLocation);
                if (binariesLocation != null) {
                    opt.setAltBinariesPath(binariesURL);
                } else if (binariesURL != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting altBinariesPath to " + binariesURL);
                    }
                    opt.setAltBinariesPath(binariesURL);
                } else if (LooseConfigRegister.singleton().isLooselyMapped(filePath)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "keep the loose configuration, not setting altBinariesPath");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting altBinariesPath to null");
                    }
                    opt.setAltBinariesPath(null);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "binariesURL: " + binariesURL);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "opt: " + opt.toString());
                }
                archive = factory.openEARFile(opt, filePath);
            } else {
                archive = factory.openArchive(opt, filePath);
            }
            if (archive instanceof EARFile && new File(filePath).isFile() && archive.containsFile("META-INF/ibm-application-sa.props")) {
                throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0211E", null), null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getArchive " + archive);
            }
            return archive;
        }
        catch (OpenFailureException ex) {
            RasUtils.logException(ex, tc, CLASS_NAME, "getArchive", "298");
            throw new AppDeploymentException("", ex);
        }
    }

    public static void checkForEE5Restrictions(Archive archive) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForEE5Restrictions: " + archive);
        }
        if (AppInstallHelper.preEE5AppBindingsXmiExist(archive) && AppInstallHelper.ee5AppBindingsXmlExist(archive)) {
            throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0212E", null), null);
        }
        AppInstallHelper.checkIfEE5ModulesContainXMIBindings(archive);
        AppInstallHelper.checkIfEE5ContainsCMPorBMP(archive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForEE5Restrictions");
        }
    }

    public static String normalize(String path) {
        if ((path = LooseConfigRegister.normalize(path)).startsWith(File.separator)) {
            path = path.substring(1);
        }
        return path;
    }

    private static void registerIfLoose(String binariesURL, String binariesLocation) {
        if (binariesURL != null && binariesLocation != null) {
            LooseConfigRegister.singleton().addLooseMapping(binariesURL, binariesLocation);
        }
    }

    public static AppDeploymentInfo getAppDeploymentInfo(String filePath, Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentInfo");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive is: " + filePath);
        }
        EARFile ear = null;
        try {
            if (prefs.get("earfile") != null) {
                ear = (EARFile)prefs.get("earfile");
            } else {
                ear = AppInstallHelper.getEarFile(filePath, true, false, AppUtils.getBundle(prefs));
                AppInstallHelper.checkForEE5Restrictions(ear);
            }
            if (prefs.get("jsr88") != null) {
                List wars = ear.getWebModuleRefs();
                for (int i = 0; i < wars.size(); ++i) {
                    ArchiveValidator v = new ArchiveValidator((ModuleRef)wars.get(i));
                    v.validate(true);
                }
            }
            AppDeploymentInfo info = AppInstallHelper.getAppDeploymentInfo(ear, prefs);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentInfo");
            }
            return info;
        }
        catch (AppDeploymentException ex) {
            RasUtils.logException(ex, tc, CLASS_NAME, "getAppDeploymentInfo", "386");
            if (ear != null) {
                ear.close();
            }
            throw ex;
        }
    }

    public static AppDeploymentInfo getAppDeploymentInfo(EARFile archive) throws AppDeploymentException {
        return AppInstallHelper.getAppDeploymentInfo(archive, new Hashtable());
    }

    public static AppDeploymentInfo getAppDeploymentInfo(EARFile archive, Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentInfo");
        }
        ArchiveDeploymentInfo info = new ArchiveDeploymentInfo(archive, prefs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppDeploymentInfo");
        }
        return info;
    }

    public static AppDeploymentInfo getPartialDeploymentInfo(EARFile archive, Hashtable prefs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPartialDeploymentInfo");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive is: " + archive);
        }
        PartialDeploymentInfo info = new PartialDeploymentInfo(archive, prefs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPartialDeploymentInfo");
        }
        return info;
    }

    public static AppDeploymentInfo getAppDeploymentInfoForUpdate(String path, String uri, Hashtable prefs, boolean isEAR) throws AppDeploymentException {
        if (isEAR) {
            return AppInstallHelper.getAppDeploymentInfo(path, prefs);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAppDeploymentInfoForUpdate");
            }
            File tempFile = File.createTempFile("ibm-app", "wrap");
            String earName = AppInstallHelper.createEarWrapper(path, tempFile.getPath(), uri, (String)prefs.get("contextroot"));
            prefs.put("ibm.update.mod.path", path);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentInfoForUpdate");
            }
            return AppInstallHelper.getAppDeploymentInfo(earName, prefs);
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "getAppDeploymentInfoForUpdate", "436");
            if (th instanceof AppDeploymentException) {
                throw (AppDeploymentException)th;
            }
            throw new AppDeploymentException(null, th);
        }
    }

    public static AppDeploymentInfo getAppDeploymentInfoGenericRead(String path, String uri, Hashtable prefs) throws AppDeploymentException {
        boolean exThrown;
        Archive a;
        block13: {
            a = null;
            exThrown = false;
            if (prefs == null) {
                prefs = new Hashtable<String, String>();
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAppDeploymentInfoGeneric");
            }
            if (!((a = AppInstallHelper.getArchive(path, false, true, null, false)) instanceof EARFile)) break block13;
            AppInstallHelper.checkForEE5Restrictions(a);
            AppDeploymentInfo appDeploymentInfo = AppInstallHelper.getAppDeploymentInfo((EARFile)a, prefs);
            Object var9_8 = null;
            if (exThrown && a != null) {
                a.close();
            }
            return appDeploymentInfo;
        }
        try {
            if (!(a instanceof ModuleFile)) {
                throw new Throwable("The archive is not supported or archive is not a valid EAR or Module file.");
            }
            File tempFile = File.createTempFile("ibm-app", "wrap");
            String earName = AppInstallHelper.createEarWrapper((ModuleFile)a, tempFile.getPath(), uri, (String)prefs.get("contextroot"));
            if (!prefs.containsKey("bla.no.save")) {
                prefs.put("ibm.update.mod.path", path);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentInfoForUpdate");
            }
            AppDeploymentInfo appDeploymentInfo = AppInstallHelper.getAppDeploymentInfo(earName, prefs);
            Object var9_9 = null;
            if (exThrown && a != null) {
                a.close();
            }
            return appDeploymentInfo;
        }
        catch (Throwable th) {
            try {
                RasUtils.logException(th, tc, CLASS_NAME, "getAppDeploymentInfoGenericRead", "470");
                exThrown = true;
                if (th instanceof AppDeploymentException) {
                    throw (AppDeploymentException)th;
                }
                throw new AppDeploymentException(null, th);
            }
            catch (Throwable throwable) {
                block14: {
                    Object var9_10 = null;
                    if (!exThrown || a == null) break block14;
                    a.close();
                }
                throw throwable;
            }
        }
    }

    public static String createEarWrapper(String jarFile, String newFileName, String contextRoot) throws AppDeploymentException {
        return AppInstallHelper.createEarWrapper(jarFile, newFileName, null, contextRoot);
    }

    public static String createEarWrapper(String jarFile, String newFileName, String newModuleURI, String contextRoot) throws AppDeploymentException {
        Hashtable<String, String> p = new Hashtable<String, String>();
        if (contextRoot != null) {
            p.put("contextroot", contextRoot);
        }
        return AppInstallHelper.createEarWrapper(jarFile, newFileName, newModuleURI, p);
    }

    public static String createEarWrapper(String jarFile, String newFileName, String newModuleURI, Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEarWrapper");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleFile: " + jarFile + ", earName: " + newFileName + ", prefs: " + prefs);
        }
        CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
        Archive archive = null;
        try {
            ArchiveOptions opt = new ArchiveOptions();
            opt.setUseJavaReflection(true);
            opt.setIsReadOnly(true);
            archive = factory.openArchive(opt, jarFile);
            String ret = AppInstallHelper.createEarWrapperExtension(archive, newFileName, newModuleURI, prefs);
            if (ret == null && archive.isModuleFile()) {
                ret = AppInstallHelper.createEarWrapper((ModuleFile)archive, newFileName, newModuleURI, prefs);
            }
            if (ret == null) {
                throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0157E"), null);
            }
            AppUtils.dbg(tc, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0155I", new String[]{ret}));
            String string = ret;
            Object var10_10 = null;
            if (archive != null) {
                archive.close();
            }
            return string;
        }
        catch (OpenFailureException ex) {
            try {
                RasUtils.logException(ex, tc, CLASS_NAME, "createEarWrapper", "567");
                throw new AppDeploymentException("", ex);
            }
            catch (Throwable throwable) {
                block9: {
                    Object var10_11 = null;
                    if (archive == null) break block9;
                    archive.close();
                }
                throw throwable;
            }
        }
    }

    public static String createEarWrapper(ModuleFile moduleFile, String newFileName, String newModuleURI, String contextRoot) throws AppDeploymentException {
        Hashtable<String, String> prefs = new Hashtable<String, String>();
        if (contextRoot != null) {
            prefs.put("contextroot", contextRoot);
        }
        return AppInstallHelper.createEarWrapper(moduleFile, newFileName, newModuleURI, prefs);
    }

    public static String createEarWrapperExtension(Archive archive, String newFileName, String newModuleURI, Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEarWrapperExtension");
        }
        String earFilePath = null;
        Vector earWrapperTasks = new Vector();
        earWrapperTasks = ExtensionHelper.processEarWrapperExtensions(earWrapperTasks, archive, newFileName, newModuleURI, prefs);
        CDFBridgeExtensionHelper.processEarWrapperExtension(earWrapperTasks, archive, newFileName, newModuleURI, prefs);
        earFilePath = CDFBridgeExtensionHelper.executeEarWrapperExtension(earWrapperTasks, archive, newFileName, newModuleURI, prefs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEarWrapperExtension");
        }
        return earFilePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static String createEarWrapper(ModuleFile moduleFile, String newFileName, String newModuleURI, Hashtable prefs) throws AppDeploymentException {
        ModuleRef moduleRef;
        EARFile earFile;
        String earFileName;
        block50: {
            String displayName;
            if (!(moduleFile.isEJBJarFile() || moduleFile.isWARFile() || moduleFile.isApplicationClientFile() || moduleFile.isRARFile())) {
                throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0084E", new String[]{moduleFile.getURI()}), null);
            }
            String contextRoot = prefs != null ? (String)prefs.get("contextroot") : null;
            CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
            earFileName = newFileName;
            if (earFileName == null) {
                File f = new File(moduleFile.getURI());
                earFileName = f.getName().replace('.', '_') + ".ear";
                if (f.getParent() != null) {
                    earFileName = f.getParent() + (f.getParent().endsWith(File.separator) ? "" : File.separator) + earFileName;
                }
            }
            if ((displayName = earFileName.substring(earFileName.lastIndexOf(File.separator) + 1, earFileName.length())).lastIndexOf(".") > 0) {
                displayName = displayName.substring(0, displayName.lastIndexOf("."));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "earFileName: " + earFileName + ", appDisplayName: " + displayName);
            }
            earFile = factory.createEARFileInitialized(earFileName);
            Application appl = earFile.getDeploymentDescriptor();
            XMLResource appResource = (XMLResource)appl.eResource();
            int moduleJ2EEVersionID = 14;
            try {
                CompatibilityDescriptionGroup dd;
                if (moduleFile.isEJBJarFile()) {
                    EJBJarFile ejbJarFile = (EJBJarFile)moduleFile;
                    dd = ejbJarFile.getDeploymentDescriptor();
                    moduleJ2EEVersionID = dd != null ? dd.getJ2EEVersionID() : 50;
                } else if (moduleFile.isWARFile()) {
                    WARFile warFile = (WARFile)moduleFile;
                    dd = warFile.getDeploymentDescriptor();
                    moduleJ2EEVersionID = dd != null ? dd.getJ2EEVersionID() : 50;
                } else if (moduleFile.isApplicationClientFile()) {
                    ApplicationClientFile appClientFile = (ApplicationClientFile)moduleFile;
                    dd = appClientFile.getDeploymentDescriptor();
                    moduleJ2EEVersionID = dd != null ? dd.getJ2EEVersionID() : 50;
                } else if (moduleFile.isRARFile()) {
                    RARFile rarFile = (RARFile)moduleFile;
                    dd = rarFile.getDeploymentDescriptor();
                    moduleJ2EEVersionID = dd.getJ2EEVersionID();
                }
                appResource.setJ2EEVersionID(moduleJ2EEVersionID);
            }
            catch (Throwable ex) {
                RasUtils.logException(ex, tc, CLASS_NAME, "createEarWrapper", "744");
                appResource.setJ2EEVersionID(moduleJ2EEVersionID);
            }
            if (moduleJ2EEVersionID < 14) {
                appl.setDisplayName(displayName);
            } else {
                DisplayName dsName = CommonPackage.eINSTANCE.getCommonFactory().createDisplayName();
                dsName.setValue(displayName);
                appl.getDisplayNames().add(dsName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Ear file opened and display name of app is set.");
            }
            moduleRef = null;
            String name = newModuleURI;
            if (name == null) {
                name = new File(moduleFile.getURI()).getName();
            }
            try {
                moduleRef = earFile.addCopyRef(moduleFile);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added copy of module file to the ear.");
                }
            }
            catch (DuplicateObjectException ex) {
                RasUtils.logException(ex, tc, CLASS_NAME, "createEarWrapper", "773");
                throw new AppDeploymentException("", ex);
            }
            moduleRef.setURI(name);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New URI for module file is set to " + name);
            }
            try {
                if (moduleRef.isWeb()) {
                    WebModule webModule = (WebModule)moduleRef.getModule();
                    if (contextRoot == null && moduleFile instanceof WARFile) {
                        WebAppExtension webAppExtension = ((WARFile)moduleFile).getExtensions();
                        contextRoot = webAppExtension.getContextRoot();
                    }
                    if (contextRoot == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Null Context root. Setting to default");
                        }
                        contextRoot = "/";
                    }
                    webModule.setContextRoot(contextRoot);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New context root for web module set.");
                    }
                    break block50;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Module is not a web module, so can not set context root.");
                }
            }
            catch (Exception ex) {
                RasUtils.logException(ex, tc, CLASS_NAME, "createEarWrapper", "806");
                throw new AppDeploymentException("", ex);
            }
        }
        ClassLoader loader = AppInstallHelper.class.getClassLoader();
        InputStream inStream = loader.getResourceAsStream("was.policy");
        String tempDir = null;
        if (inStream != null) {
            tempDir = ArchiveDeploymentInfo.saveAsFile(earFile, null, "META-INF/was.policy", inStream);
        }
        String fileName = moduleRef.isWeb() ? STANDALONE_WEB_MARKER : STANDALONE_EJB_MARKER;
        ByteArrayInputStream is = new ByteArrayInputStream(fileName.getBytes());
        String tempDir1 = ArchiveDeploymentInfo.saveAsFile(earFile, null, fileName, is);
        earFile.rollUpRoles();
        SaveStrategy save = earFile.getSaveStrategy();
        try {
            try {
                FileOutputStream outputStream = new FileOutputStream(earFileName);
                ZipStreamSaveStrategyImpl saveStrategy = new ZipStreamSaveStrategyImpl(outputStream);
                earFile.save(saveStrategy);
            }
            catch (Exception ex) {
                RasUtils.logException(ex, tc, CLASS_NAME, "createEarWrapper", "834");
                throw new AppDeploymentException("", ex);
            }
            Object var24_27 = null;
            try {
                block51: {
                    try {
                        if (!AppUtils.isEntitled()) break block51;
                        AppUtils.signEntitledApplication(earFile.getURI());
                    }
                    catch (Exception e) {
                        RasUtils.logException(e, tc, CLASS_NAME, "createEarWrapper", "847");
                        throw new AppDeploymentException("Error re-signing entitled application", e);
                    }
                }
                Object var27_29 = null;
                if (moduleFile != null) {
                    moduleFile.close();
                }
                if (earFile != null) {
                    earFile.close();
                }
                AppInstallHelper.deleteDirTree(tempDir);
                AppInstallHelper.deleteDirTree(tempDir1);
            }
            catch (Throwable throwable) {
                Object var27_30 = null;
                if (moduleFile != null) {
                    moduleFile.close();
                }
                if (earFile != null) {
                    earFile.close();
                }
                AppInstallHelper.deleteDirTree(tempDir);
                AppInstallHelper.deleteDirTree(tempDir1);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var24_28 = null;
            try {}
            catch (Throwable throwable2) {
                Object var27_32 = null;
                if (moduleFile != null) {
                    moduleFile.close();
                }
                if (earFile != null) {
                    earFile.close();
                }
                AppInstallHelper.deleteDirTree(tempDir);
                AppInstallHelper.deleteDirTree(tempDir1);
                throw throwable2;
            }
            try {}
            catch (Exception e) {
                RasUtils.logException(e, tc, CLASS_NAME, "createEarWrapper", "847");
                throw new AppDeploymentException("Error re-signing entitled application", e);
            }
            if (AppUtils.isEntitled()) {
                AppUtils.signEntitledApplication(earFile.getURI());
            }
            Object var27_31 = null;
            if (moduleFile != null) {
                moduleFile.close();
            }
            if (earFile != null) {
                earFile.close();
            }
            AppInstallHelper.deleteDirTree(tempDir);
            AppInstallHelper.deleteDirTree(tempDir1);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return earFileName;
        Tr.exit(tc, "createEarWrapper");
        return earFileName;
    }

    public static Hashtable createDefaultDeployEJBOptions() {
        Hashtable<String, Object> deployOptions = new Hashtable<String, Object>();
        deployOptions.put("deployejb.codegen", AppConstants.APPDEPL_DEPLOYEJB_CODEGEN_OPTION_DEFAULT);
        deployOptions.put("deployejb.validate", AppConstants.APPDEPL_DEPLOYEJB_VALIDATE_OPTION_DEFAULT);
        deployOptions.put("deployejb.rmic", "");
        deployOptions.put("deployejb.dbtype", AppConstants.APPDEPL_DEPLOYEJB_DBTYPE_OPTION_DEFAULT);
        deployOptions.put("deployejb.dbname", "");
        deployOptions.put("deployejb.dbschema", "");
        deployOptions.put("deployejb.classpath", "");
        deployOptions.put("deployejb.complianceLevel", "");
        return deployOptions;
    }

    public static String getAppDisplayName(EARFile archive, Hashtable options) {
        String appDisplayName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDisplayName");
        }
        if ((appDisplayName = archive.getDeploymentDescriptor().getDisplayName()) == null || appDisplayName.trim().length() == 0) {
            int fileExt;
            String origUri = (String)options.get("app.original.uri");
            if (origUri == null || origUri.trim().length() == 0) {
                origUri = archive.getURI();
            }
            if ((fileExt = (appDisplayName = new File(origUri).getName()).lastIndexOf(46)) > 0) {
                appDisplayName = appDisplayName.substring(0, fileExt);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppDisplayName - " + appDisplayName);
        }
        return appDisplayName;
    }

    public static String copyToServer(AdminClient client, String fileName) throws TransferFailedException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyToServer: " + fileName);
        }
        String ret = new String();
        FileTransferClient transfer = FileTransferFactory.getFileTransferClient(client);
        File f = new File(fileName);
        String targetName = "upload" + File.separator + Long.toHexString(System.currentTimeMillis()) + f.getName();
        transfer.uploadFile(f, targetName);
        String remDir = transfer.getServerStagingLocation();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Staging location: " + remDir);
        }
        if (remDir.indexOf("/") >= 0) {
            if (!remDir.endsWith("/")) {
                remDir = remDir + "/";
            }
            ret = remDir + targetName.replace('\\', '/');
        } else {
            if (!remDir.endsWith("\\")) {
                remDir = remDir + "\\";
            }
            ret = remDir + targetName.replace('/', '\\');
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyToServer: " + ret);
        }
        return ret;
    }

    public static boolean isHiddenApp(String earPath) throws AppDeploymentException {
        if (earPath == null) {
            return false;
        }
        boolean retVal = false;
        File f = new File(earPath);
        if (f.isDirectory()) {
            retVal = f.exists() && new File(earPath + "/" + "META-INF/ibm-application-ha.props").exists();
        } else {
            EARFile archive = AppInstallHelper.getEarFile(earPath, true, true, null);
            retVal = AppInstallHelper.isHiddenApp(archive);
            archive.close();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isHiddenApp = " + retVal);
        }
        return retVal;
    }

    public static boolean isHiddenApp(EARFile earFile) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHiddenApp", new Object[]{earFile});
        }
        boolean retVal = earFile.containsFile("META-INF/ibm-application-ha.props");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isHiddenApp", Boolean.toString(retVal));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkIfEE5ModulesContainXMIBindings(Archive archive) throws AppDeploymentException {
        boolean result;
        block27: {
            block31: {
                WARFile warFile;
                block30: {
                    EJBJarFile ejbJarFile;
                    block29: {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "checkIfEE5ModulesContainXMIBindings", new Object[]{archive});
                        }
                        result = false;
                        EARFile ef = null;
                        if (!(archive instanceof EARFile)) break block29;
                        ef = (EARFile)archive;
                        List moduleFiles = ef.getModuleFiles();
                        if (moduleFiles != null && moduleFiles.size() > 0) {
                            for (ModuleFile moduleFile : moduleFiles) {
                                result = AppInstallHelper.checkIfEE5ModulesContainXMIBindings(moduleFile);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, moduleFile.getName() + " contains xmi bindings files : " + result);
                                }
                                if (!result) continue;
                                throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0207E", new String[]{moduleFile.getName()}), null);
                            }
                            break block27;
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EAR file doesn't have any ejb/web modules.");
                        }
                        break block27;
                    }
                    if (!(archive instanceof EJBJarFile)) break block30;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EJB Module" + archive.getName());
                    }
                    if (AppDeploymentUtil.isEE5SchemaDD(ejbJarFile = (EJBJarFile)archive)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EE5 ejb module");
                        }
                        InputStream is = null;
                        try {
                            block26: {
                                try {
                                    is = ejbJarFile.getInputStream("META-INF/ibm-ejb-jar-bnd.xmi");
                                    if (is == null) break block26;
                                    result = true;
                                }
                                catch (FileNotFoundException fnfx) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "ejb jar xmi bindings file not found");
                                    }
                                    Object var7_15 = null;
                                    AppUtils.closeInputStream(is);
                                    break block27;
                                }
                                catch (IOException iox) {
                                    RasUtils.logException(iox, tc, CLASS_NAME, "checkIfEE5ModulesContainXMIBindings", "1009");
                                    Object var7_16 = null;
                                    AppUtils.closeInputStream(is);
                                    break block27;
                                }
                            }
                            Object var7_14 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_17 = null;
                            AppUtils.closeInputStream(is);
                            throw throwable;
                        }
                        AppUtils.closeInputStream(is);
                    }
                    break block27;
                }
                if (!(archive instanceof WARFile)) break block31;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Web Module " + archive.getName());
                }
                if (AppDeploymentUtil.isEE5SchemaDD(warFile = (WARFile)archive)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EE5 Web Module");
                    }
                    InputStream is = null;
                    try {
                        block28: {
                            try {
                                is = warFile.getInputStream("WEB-INF/ibm-web-bnd.xmi");
                                if (is == null) break block28;
                                result = true;
                            }
                            catch (FileNotFoundException fnfx) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "war xmi bindings file not found");
                                }
                                Object var9_20 = null;
                                AppUtils.closeInputStream(is);
                                break block27;
                            }
                            catch (IOException iox) {
                                RasUtils.logException(iox, tc, CLASS_NAME, "checkIfEE5ModulesContainXMIBindings", "1031");
                                Object var9_21 = null;
                                AppUtils.closeInputStream(is);
                                break block27;
                            }
                        }
                        Object var9_19 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_22 = null;
                        AppUtils.closeInputStream(is);
                        throw throwable;
                    }
                    AppUtils.closeInputStream(is);
                }
                break block27;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Archive is not ear, ejb or web module file", new Object[]{archive});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfEE5ModulesContainXMIBindings", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean preEE5AppBindingsXmiExist(Archive archive) {
        boolean ret;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "preEE5AppBindingsXmiExist", new Object[]{archive});
            }
            ret = false;
            InputStream is = null;
            try {
                block9: {
                    try {
                        is = archive.getInputStream("META-INF/ibm-application-bnd.xmi");
                        if (is == null) break block9;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "application xmi bindings file found");
                        }
                        ret = true;
                    }
                    catch (FileNotFoundException fnfx) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "application xmi bindings file not found");
                        }
                        Object var5_4 = null;
                        AppUtils.closeInputStream(is);
                        break block10;
                    }
                    catch (IOException iox) {
                        RasUtils.logException(iox, tc, CLASS_NAME, "preEE5AppBindingsXmiExist", "1058");
                        Object var5_5 = null;
                        AppUtils.closeInputStream(is);
                        break block10;
                    }
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                AppUtils.closeInputStream(is);
                throw throwable;
            }
            AppUtils.closeInputStream(is);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preEE5AppBindingsXmiExist", Boolean.toString(ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ee5AppBindingsXmlExist(Archive archive) {
        boolean ret;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ee5AppBindingsXmlExist", new Object[]{archive});
            }
            ret = false;
            InputStream is = null;
            try {
                block9: {
                    try {
                        is = archive.getInputStream("META-INF/ibm-application-bnd.xml");
                        if (is == null) break block9;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "application xml bindings file found");
                        }
                        ret = true;
                    }
                    catch (FileNotFoundException fnfx) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "application new format xml bindings file not found");
                        }
                        Object var5_4 = null;
                        AppUtils.closeInputStream(is);
                        break block10;
                    }
                    catch (IOException iox) {
                        RasUtils.logException(iox, tc, CLASS_NAME, "ee5AppBindingsXmlExist", "1081");
                        Object var5_5 = null;
                        AppUtils.closeInputStream(is);
                        break block10;
                    }
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                AppUtils.closeInputStream(is);
                throw throwable;
            }
            AppUtils.closeInputStream(is);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ee5AppBindingsXmlExist", Boolean.toString(ret));
        }
        return ret;
    }

    private static boolean checkIfEE5ContainsCMPorBMP(Archive archive) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfEE5ContainsCMPorBMP", new Object[]{archive});
        }
        boolean ret = false;
        if (archive instanceof EARFile) {
            EARFile earFile = (EARFile)archive;
            List moduleFiles = earFile.getModuleFiles();
            if (moduleFiles != null && moduleFiles.size() > 0) {
                for (ModuleFile moduleFile : moduleFiles) {
                    ret = AppInstallHelper.checkIfEE5ContainsCMPorBMP(moduleFile);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, moduleFile.getName() + " contains CMP or BMP : " + ret);
                    }
                    if (!ret) continue;
                    throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0207E", new String[]{moduleFile.getName()}), null);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EAR file doesn't have any ejb/web modules.");
            }
        } else if (archive instanceof EJBJarFile) {
            EJBJarFile ejbJarFile;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EJB Module" + archive.getName());
            }
            if (AppDeploymentUtil.isEE5SchemaDD(ejbJarFile = (EJBJarFile)archive)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EE5 ejb module");
                }
                if (ejbJarFile.getDeploymentDescriptor().getContainerManagedBeans().size() > 0) {
                    String beanNames = "";
                    List cmpBeans = ejbJarFile.getDeploymentDescriptor().getContainerManagedBeans();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CMP beans: " + cmpBeans);
                    }
                    for (int i = 0; i < cmpBeans.size(); ++i) {
                        if (!AppUtils.isEmpty(beanNames)) {
                            beanNames = beanNames + ", ";
                        }
                        beanNames = beanNames + ((ContainerManagedEntity)cmpBeans.get(i)).getName();
                    }
                    throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0208E", new String[]{beanNames, ejbJarFile.getName()}), null);
                }
                if (ejbJarFile.getDeploymentDescriptor().getBeanManagedBeans().size() > 0) {
                    String beanNames = "";
                    List bmpBeans = ejbJarFile.getDeploymentDescriptor().getBeanManagedBeans();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "BMP beans: " + bmpBeans);
                    }
                    for (int i = 0; i < bmpBeans.size(); ++i) {
                        if (!AppUtils.isEmpty(beanNames)) {
                            beanNames = beanNames + ", ";
                        }
                        beanNames = beanNames + ((Entity)bmpBeans.get(i)).getName();
                    }
                    throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0209E", new String[]{beanNames, ejbJarFile.getName()}), null);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfEE5ContainsCMPorBMP", Boolean.toString(ret));
        }
        return ret;
    }

    public static String copyAsset(String assetId, String workspaceID) throws AppDeploymentException {
        String assetPath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyAsset", new Object[]{assetId, workspaceID});
        }
        if ((assetPath = AppInstallHelper.getAssetPath(assetId, workspaceID)) != null) {
            try {
                assetPath = AppUtils.copyFile(assetPath);
            }
            catch (Exception ex) {
                RasUtils.logException(ex, tc, CLASS_NAME, "copyAsset", "1155");
                throw new AppDeploymentException("error copying asset into a tempoary location ", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyAsset", new Object[]{assetPath});
        }
        return assetPath;
    }

    /*
     * Unable to fully structure code
     */
    public static String getAssetPath(String assetId, String workspaceID) throws AppDeploymentException {
        block16: {
            if (AppInstallHelper.tc.isEntryEnabled()) {
                Tr.entry(AppInstallHelper.tc, "getAssetPath", new Object[]{assetId, workspaceID});
            }
            assetPath = null;
            dO = null;
            try {
                block15: {
                    assetFactory = AssetFactory.getSingleton();
                    asset = assetFactory.readAssetFromAssetSpec(new AssetSpec(assetId), workspaceID);
                    if (asset == null || (assetIn = (assetInFactory = AssetInFactory.getSingleton()).readAssetInFromAssetDeployed(asset, opCtx = new OperationContext(new Session(workspaceID, true), null, Locale.getDefault()))) == null) break block15;
                    assetPath = assetIn.getAssetInURI();
                    dO = assetIn.getDOForContents();
                }
                var10_10 = null;
                ** if (dO == null) goto lbl-1000
            }
            catch (Throwable var9_14) {
                block17: {
                    var10_11 = null;
                    if (dO != null) {
                        if (AppInstallHelper.tc.isDebugEnabled()) {
                            Tr.debug(AppInstallHelper.tc, "closing DO " + dO);
                        }
                        try {
                            dO.close();
                        }
                        catch (Exception e) {
                            RasUtils.logException(e, AppInstallHelper.tc, AppInstallHelper.CLASS_NAME, "getAssetPath", "1199");
                            if (!AppInstallHelper.tc.isDebugEnabled()) break block17;
                            Tr.debug(AppInstallHelper.tc, "Exception closing DO from AppInstallHelper.getAssetPath()");
                        }
                    }
                }
                throw var9_14;
            }
lbl-1000:
            // 1 sources

            {
                if (AppInstallHelper.tc.isDebugEnabled()) {
                    Tr.debug(AppInstallHelper.tc, "closing DO " + dO);
                }
                try {
                    dO.close();
                }
                catch (Exception e) {
                    RasUtils.logException(e, AppInstallHelper.tc, AppInstallHelper.CLASS_NAME, "getAssetPath", "1199");
                    if (AppInstallHelper.tc.isDebugEnabled()) {
                        Tr.debug(AppInstallHelper.tc, "Exception closing DO from AppInstallHelper.getAssetPath()");
                    }
                }
            }
lbl-1000:
            // 4 sources

            {
                break block16;
                catch (Exception ex) {
                    RasUtils.logException(ex, AppInstallHelper.tc, AppInstallHelper.CLASS_NAME, "getAssetPath", "1187");
                    if (ex instanceof AppDeploymentException) {
                        throw (AppDeploymentException)ex;
                    }
                    throw new AppDeploymentException("error geeting asset info ", ex);
                }
            }
        }
        if (AppInstallHelper.tc.isEntryEnabled()) {
            Tr.exit(AppInstallHelper.tc, "getAssetPath", new Object[]{assetPath});
        }
        return assetPath;
    }

    private static void deleteDirTree(String directory) {
        if (directory != null) {
            try {
                AppUtils.deleteDirTree(directory);
            }
            catch (IOException e) {
                RasUtils.logException(e, tc, CLASS_NAME, "deleteDirTree", "1221", null, new Object[]{"directory=" + directory});
            }
        }
    }

    public static String getSpecString(CompositionUnitSpec cuSpec, String sessionId) throws Exception {
        String specStr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSpecString", new Object[]{cuSpec});
        }
        if (AppInstallHelper.isMultipleEditions(specStr = cuSpec.toStringSkipVersion(), sessionId, "cuname")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "return full spec");
            }
            specStr = cuSpec.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSpecString", new Object[]{specStr});
        }
        return specStr;
    }

    public static String getSpecString(BLASpec blaSpec, String sessionId) throws Exception {
        String specStr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSpecString", new Object[]{blaSpec});
        }
        if (AppInstallHelper.isMultipleEditions(specStr = blaSpec.toStringSkipVersion(), sessionId, "blaname")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "return full spec");
            }
            specStr = blaSpec.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSpecString", new Object[]{specStr});
        }
        return specStr;
    }

    private static boolean isMultipleEditions(String specStr, String sessionId, String specType) throws Exception {
        ObjectName objName;
        List<RepositoryContext> repoCtxList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_isMultipleEditions", new Object[]{specStr, sessionId, specType});
        }
        boolean multipleEditions = false;
        if (sessionId != null && (repoCtxList = AppInstallHelper.getMatchingContexts(sessionId, objName = new ObjectName(specStr))) != null && repoCtxList.size() > 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found multiple editions");
            }
            multipleEditions = true;
        }
        if (!multipleEditions && EditionHelper.isEditionSupportEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "XD enable");
            }
            multipleEditions = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_isMultipleEditions", new Object[]{new Boolean(multipleEditions)});
        }
        return multipleEditions;
    }

    private static RepositoryContext findCellContext(String sessionId) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findCellContext", new Object[]{sessionId});
        }
        RepositoryContext cellContext = null;
        try {
            WorkSpace workspace = ConfigRepoHelper.getWorkSpace(sessionId);
            cellContext = (RepositoryContext)workspace.findContext(AppUtils.getContextType("cells")).toArray()[0];
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findCellContext", e);
            }
            throw new Exception(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findCellContext", new Object[]{cellContext});
        }
        return cellContext;
    }

    private static List<RepositoryContext> getMatchingContexts(String sessionId, ObjectName on) throws Exception {
        ArrayList<RepositoryContext> retVal;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMatchingContexts: " + on);
            }
            retVal = new ArrayList<RepositoryContext>();
            boolean done = false;
            try {
                String key2;
                ArrayList parentList;
                String val1;
                RepositoryContext cellC = AppInstallHelper.findCellContext(sessionId);
                if (cellC != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "cellC: " + cellC.getPath());
                }
                if ((val1 = on.getKeyProperty("assetname")) != null) {
                    parentList = new ArrayList();
                    if (val1.equals("__ibm__repoctx__all__")) {
                        parentList.addAll(cellC.findContext(AppUtils.getContextType("assets")));
                    } else {
                        parentList.addAll(cellC.findContext("assets", val1));
                    }
                    key2 = on.getKeyProperty("assetversion");
                    for (RepositoryContext pCtx : parentList) {
                        if (key2 == null || "__ibm__repoctx__all__".equals(key2)) {
                            retVal.addAll(pCtx.findContext(AppUtils.getContextType("aver")));
                            continue;
                        }
                        retVal.addAll(pCtx.findContext("aver", key2));
                    }
                    done = true;
                }
                val1 = on.getKeyProperty("cuname");
                if (!done && val1 != null) {
                    parentList = new ArrayList();
                    if (val1.equals("__ibm__repoctx__all__")) {
                        parentList.addAll(cellC.findContext(AppUtils.getContextType("cus")));
                    } else {
                        parentList.addAll(cellC.findContext("cus", val1));
                    }
                    key2 = on.getKeyProperty("cuedition");
                    for (RepositoryContext pCtx : parentList) {
                        if (key2 == null || "__ibm__repoctx__all__".equals(key2)) {
                            retVal.addAll(pCtx.findContext(AppUtils.getContextType("cver")));
                            continue;
                        }
                        retVal.addAll(pCtx.findContext("cver", key2));
                    }
                    done = true;
                }
                val1 = on.getKeyProperty("blaname");
                if (!done && val1 != null) {
                    parentList = new ArrayList();
                    if (val1.equals("__ibm__repoctx__all__")) {
                        parentList.addAll(cellC.findContext(AppUtils.getContextType("blas")));
                    } else {
                        parentList.addAll(cellC.findContext("blas", val1));
                    }
                    key2 = on.getKeyProperty("blaedition");
                    for (RepositoryContext pCtx : parentList) {
                        if (key2 == null || "__ibm__repoctx__all__".equals(key2)) {
                            retVal.addAll(pCtx.findContext(AppUtils.getContextType("bver")));
                            continue;
                        }
                        retVal.addAll(pCtx.findContext("bver", key2));
                    }
                    done = true;
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"getMatchingContexts", (String)"1466");
                if (!tc.isDebugEnabled()) break block20;
                Tr.debug(tc, "exception in getMatchingContexts: " + th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchingContexts: " + retVal);
        }
        return retVal;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/client/AppInstallHelper.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.56.2.2");
        }
        CLASS_NAME = AppInstallHelper.class.getName();
        _tempDirCreated = false;
    }

    private static class ArchiveValidator {
        private static TraceComponent tc = Tr.register(ArchiveValidator.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
        ModuleRef moduleRef;
        ArrayList msgs;

        public ArchiveValidator(ModuleRef mRef) {
            this.moduleRef = mRef;
            this.msgs = new ArrayList();
        }

        public void validate(boolean throwExForSev1) throws AppDeploymentException {
            try {
                if (this.moduleRef.isWeb()) {
                    WebApp dd = (WebApp)this.moduleRef.getDeploymentDescriptor();
                    EList maps = dd.getServletMappings();
                    for (int i = 0; i < maps.size(); ++i) {
                        String url;
                        ServletMapping map = (ServletMapping)maps.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "servlet map: " + map.getName() + " pat=" + map.getUrlPattern());
                        }
                        if ((url = map.getUrlPattern()).indexOf("\r") == -1 && url.indexOf("\n") == -1) continue;
                        this.msgs.add("Invalid servlet mapping name:" + map.getName() + " as url pattern: " + map.getUrlPattern() + " has a newline character");
                    }
                    if (this.msgs.size() > 0) {
                        StringBuffer buf = new StringBuffer();
                        for (int i = 0; i < this.msgs.size(); ++i) {
                            buf.append("\n" + this.msgs.get(i));
                        }
                        throw new AppDeploymentException("WAR validation failed: " + buf.toString(), null);
                    }
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "validate", "1270", this);
                if (th instanceof AppDeploymentException) {
                    throw (AppDeploymentException)th;
                }
                throw new AppDeploymentException("Unexpected exception from validation: ", th);
            }
        }
    }
}

