/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationextPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentProfile;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.AppcfgFactory;
import com.ibm.websphere.models.config.appcfg.AppcfgPackage;
import com.ibm.websphere.models.config.appcfg.ApplicationConfig;
import com.ibm.websphere.models.config.appcfg.impl.AppcfgPackageImpl;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.AsyncRequestDispatchType;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.classloader.ClassLoaderPolicy;
import com.ibm.websphere.models.config.classloader.ClassLoadingMode;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.models.config.classloader.ClassloaderFactory;
import com.ibm.websphere.models.config.classloader.ClassloaderPackage;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.ServiceContext;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.wsspi.management.bla.model.BLASpec;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class AppDeploymentOptionsHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register(AppDeploymentOptionsHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static ClassloaderFactory _gClassloaderFactory;
    private static AppcfgFactory _appCfgFactory;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector v = AppDeploymentProfile.getProfile(t.getAppDeploymentController().getDeploymentMode());
        if (v.size() == 0) {
            t.setIsTaskDisabled(true);
            t.setTaskData(null);
            return;
        }
        String sessionId = null;
        if (t.getAppDeploymentController().getConfigSession() != null) {
            sessionId = t.getAppDeploymentController().getConfigSession().getUserName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sessionId: " + sessionId);
        }
        String[][] data = new String[2][v.size()];
        ApplicationDeployment appDepl = ((ArchiveDeploymentInfo)appInstallInfo).getAppDeploymentObject(true);
        Hashtable props = t.getAppDeploymentController().getAppOptions();
        for (int i = 0; i < v.size(); ++i) {
            AppDeploymentProfile.DeplOption opt = (AppDeploymentProfile.DeplOption)v.elementAt(i);
            String sval = "";
            Object val = this.getOptionValue(appInstallInfo, props, appDepl, opt, t.getAppDeploymentController().getDeploymentMode(), sessionId);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "final val: " + val);
            }
            sval = Boolean.TRUE.equals(val) ? "AppDeploymentOption.Yes" : (Boolean.FALSE.equals(val) ? "AppDeploymentOption.No" : sval + val);
            data[0][i] = opt.name;
            data[1][i] = sval;
        }
        t.setTaskData(data);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private Object getOptionValue(AppDeploymentInfo appInstallInfo, Hashtable props, ApplicationDeployment appDepl, AppDeploymentProfile.DeplOption opt, long deplMode, String sessionId) {
        Object val;
        block93: {
            ContextResourceSet ctxResSet;
            Resource res;
            block92: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getOptionValue", new Object[]{appInstallInfo, props, appDepl, opt});
                }
                val = props.get(opt.name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "opt.name: " + opt.name);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "opt.val: " + val);
                }
                if (opt.name.equals("blaname")) {
                    String blaname;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "blaname option");
                    }
                    if (!AppUtils.isEmpty(blaname = (String)val)) {
                        try {
                            BLASpec blaSpec = new BLASpec(blaname);
                            val = AppInstallHelper.getSpecString(blaSpec, sessionId);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "val: " + val);
                            }
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block92;
                            Tr.debug(tc, "invalid name: " + blaname);
                        }
                    }
                }
            }
            if (val != null) {
                return val;
            }
            if (opt.name.equals("installed.ear.destination")) {
                val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "val: " + val);
                }
                if ((deplMode & 0x110L) != 0L) {
                    String appNameEarSuffix = appInstallInfo.getAppDisplayName() + ".ear";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "appNameEarSuffix: " + appNameEarSuffix);
                    }
                    if (val != null && ((String)val).endsWith(appNameEarSuffix)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " .... STRIPPING the appname.ear portion");
                        }
                        val = AppUtils.getInstallDirFromBinariesURL(appDepl);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, ".... VAL read is " + val);
                        }
                    }
                }
            }
            if (opt.name.equals("appname")) {
                val = appInstallInfo.getAppDisplayName();
            } else if (opt.name.equals("edition")) {
                if (appDepl == null) {
                    val = "";
                } else {
                    res = appDepl.eResource();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resource: " + res);
                    }
                    ctxResSet = (ContextResourceSet)((Object)res.getResourceSet());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ContextResourceSet: " + ctxResSet);
                    }
                    if (ctxResSet != null) {
                        RepositoryContext rc = ctxResSet.getContext();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "RepositoryContext: " + rc);
                        }
                        if (rc != null) {
                            String name = rc.getName();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "name: " + name);
                            }
                            val = EditionHelper.getAppAndEdition(name)[1];
                        } else {
                            val = "";
                        }
                    } else {
                        val = "";
                    }
                }
            } else {
                ApplicationExtension appExt;
                if (opt.name.equals("edition.desc")) {
                    try {
                        if (appDepl != null) {
                            res = appDepl.eResource();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Resource: " + res);
                            }
                            ctxResSet = (ContextResourceSet)((Object)res.getResourceSet());
                            Tr.debug(tc, "ContextResourceSet: " + ctxResSet);
                            if (ctxResSet != null) {
                                RepositoryContext rc = ctxResSet.getContext();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "RepositoryContext: " + rc);
                                }
                                if (rc != null) {
                                    Properties p = AppUtils.getEditionProps(rc);
                                    val = p.getProperty(EditionHelper.getEditionDescPropName(rc.getName()), "");
                                } else {
                                    val = "";
                                }
                            } else {
                                val = "";
                            }
                            break block93;
                        }
                        val = "";
                    }
                    catch (AdminException ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error reading edition props: " + ex);
                        }
                        break block93;
                    }
                }
                if (opt.name.equals("distributeApp")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                } else if (opt.name.equals("useMetaDataFromBinary")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                } else if (opt.name.equals("createMBeansForResources")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                } else if (opt.name.equals("reloadEnabled")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                    if (val == null && (appExt = appInstallInfo.getApplicationExtensions()) != null && appExt.eIsSet(ApplicationextPackage.eINSTANCE.getApplicationExtension_ReloadInterval())) {
                        val = Boolean.TRUE;
                    }
                } else if (opt.name.equals("reloadInterval")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                    if (val == null && (appExt = appInstallInfo.getApplicationExtensions()) != null && appExt.eIsSet(ApplicationextPackage.eINSTANCE.getApplicationExtension_ReloadInterval())) {
                        val = appExt.eGet(ApplicationextPackage.eINSTANCE.getApplicationExtension_ReloadInterval());
                    }
                } else if (opt.name.equals("processEmbeddedConfig")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "the option sought is processEmbeddedConfig");
                    }
                    val = AppConstants.APPDEPL_PROCESS_EMBEDDEDCFG_INSTALL_DEFAULT;
                    if (!AppUtils.getGlobalEmbededConfig()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "globally processEmbeddedConfigGlobal is set as False");
                        }
                        val = Boolean.FALSE;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "globally processEmbeddedConfigGlobal is NOT set checking if the EAR is Enhanced EAR");
                        }
                        if (!((ArchiveDeploymentInfo)appInstallInfo).checkIfEnhancedEar()) {
                            val = Boolean.FALSE;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "the final value of processEmbeddedConfig is " + val);
                    }
                } else if (opt.name.equals("zeroEarCopy")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                } else if (opt.name.equals("zeroBinaryCopy")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                } else if (opt.name.equals("deployejb")) {
                    val = new Boolean(!((ArchiveDeploymentInfo)appInstallInfo).checkIfEarDeployed());
                } else if (opt.name.equals("buildVersion")) {
                    val = AppUtils.getAttrValueFromManifest(AppConstants.APPDEPL_BUILDVERSION_ATTRKEY, ((ArchiveDeploymentInfo)appInstallInfo).getEarManifest());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, AppConstants.APPDEPL_BUILDVERSION_ATTRKEY + " value =" + val);
                    }
                } else if (opt.name.equals("allowDispatchRemoteInclude")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                } else if (opt.name.equals("allowServiceRemoteInclude")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                } else if (opt.name.equals("filepermission")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                } else if (opt.name.equals("asyncRequestDispatchType")) {
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                    if (val instanceof AsyncRequestDispatchType) {
                        if (((AsyncRequestDispatchType)val).equals(AsyncRequestDispatchType.DISABLED_LITERAL)) {
                            val = "DISABLED";
                        } else if (((AsyncRequestDispatchType)val).equals(AsyncRequestDispatchType.CLIENT_SIDE_LITERAL)) {
                            val = "CLIENT_SIDE";
                        } else if (((AsyncRequestDispatchType)val).equals(AsyncRequestDispatchType.SERVER_SIDE_LITERAL)) {
                            val = "SERVER_SIDE";
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "asyncRequestDispatchType value =" + val + " is invalid!!");
                        }
                    }
                } else if (opt.name.equals("useAutoLink")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "useAutolink option");
                    }
                    val = AppDeploymentOptionsHelper.readFromAppDepl(appDepl, opt.attr);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "val: " + val);
                    }
                }
            }
        }
        if (val != null) {
            return val;
        }
        return opt.defaultVal;
    }

    private static Object readFromAppDepl(ApplicationDeployment appDepl, EAttribute eAttr) {
        if (appDepl == null) {
            return null;
        }
        if (appDepl.eIsSet(eAttr)) {
            return appDepl.eGet(eAttr);
        }
        return null;
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (t.isTaskDisabled()) {
            return;
        }
        if (!t.isTaskEmpty()) {
            String[][] data = t.getTaskData();
            Hashtable appOptions = t.getAppDeploymentController().getAppOptions();
            for (int i = 0; i < data[0].length; ++i) {
                Object o = data[1][i];
                if (o == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "NULL data for col : " + data[0][i]);
                    continue;
                }
                if ("AppDeploymentOption.Yes".equals(o)) {
                    o = Boolean.TRUE;
                } else if ("AppDeploymentOption.No".equals(o)) {
                    o = Boolean.FALSE;
                }
                if ("useAutoLink".equals(data[0][i]) && "AppDeploymentOption.Yes".equals(data[1][i])) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checking autolink support");
                    }
                    this.validateCommonTarget(appInstallInfo, t);
                }
                appOptions.put(data[0][i], o);
            }
            appOptions.put("appdeploy.with.client", new Boolean(Boolean.TRUE));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void validateAutoLinkForEJB3App(AppDeploymentInfo appInstallInfo, AppDeploymentTask task) throws AppDeploymentException {
        Vector ejb3Jars;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAutoLinkForEJB3App", new Object[]{appInstallInfo, task});
        }
        if ((ejb3Jars = appInstallInfo.getModuleConfig("EJB3JAR_DD")) == null || ejb3Jars.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "autolink option is only supported for application containing EJB 3.0 module");
            }
            throw new AppDeploymentException(MessageFormat.format(util.getMessage(task, "ADMA0198E"), new Object[0]), null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAutoLinkForEJB3App");
        }
    }

    private void validateCommonTarget(AppDeploymentInfo appInstallInfo, AppDeploymentTask task) throws AppDeploymentException {
        Hashtable serverTbl;
        Collection values;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateCommonTarget", new Object[]{appInstallInfo, task});
        }
        if ((values = (serverTbl = task.getAppDeploymentController().getServerTable()).values()).size() > 1) {
            Iterator iter = values.iterator();
            String s = (String)iter.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "s: " + s);
            }
            Object[] matchingUrls = AppUtils.convertToURL(s, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "matchingURLs: " + matchingUrls);
            }
            while (iter.hasNext()) {
                String str = (String)iter.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "str: " + str);
                }
                Object[] urls = AppUtils.convertToURL(str, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "urls: " + urls);
                }
                boolean found = false;
                block1: for (int i = 0; i < matchingUrls.length && !found; ++i) {
                    for (int j = 0; j < urls.length; ++j) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "comparing " + matchingUrls[i] + " with " + urls[j]);
                        }
                        if (!((String)matchingUrls[i]).equals((String)urls[j])) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "found a match");
                        }
                        found = true;
                        continue block1;
                    }
                }
                if (found) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no match is found");
                }
                throw new AppDeploymentException(MessageFormat.format(util.getMessage(task, "ADMA0199E"), new Object[0]), null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateCommonTarget");
        }
    }

    private static boolean valueIsEmpty(Object val) {
        if (val instanceof String) {
            return AppUtils.isEmpty((String)val);
        }
        return val == null;
    }

    public static void saveAppOptions(long op, Scheduler sch, ApplicationDeployment appDepl, RepositoryContext appC) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveAppOptions");
        }
        Hashtable tbl = sch.getProperties();
        Vector v = AppDeploymentProfile.getProfile(op);
        v.addAll(AppDeploymentProfile.getHidden(op));
        for (int i = 0; i < v.size(); ++i) {
            Object p;
            AppDeploymentProfile.DeplOption opt = (AppDeploymentProfile.DeplOption)v.elementAt(i);
            Object val = tbl.get(opt.name);
            if (AppDeploymentOptionsHelper.valueIsEmpty(val) && (op & 0x110L) != 0L) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Option " + opt.name + " not found in options table and hence not set in ApplicationDeployment");
                continue;
            }
            if (AppDeploymentOptionsHelper.valueIsEmpty(val) && opt.attr != null && appDepl.eIsSet(opt.attr)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Value for " + opt.name + " not passed in but already set in deployment.xml");
                }
                if (!opt.name.equals("installed.ear.destination") || !AppDeploymentOptionsHelper.valueIsEmpty(appDepl.getBinariesURL())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "opt.name is installpath, and enhanced ear DD has empty binariesURL, keeping going to next code to calculate the ear install path");
                }
            }
            Object origVal = val;
            if (opt.bHidden && val != null && opt.defaultVal != null && opt.defaultVal.getClass().equals(Boolean.class) && !"false".equals(val) && !Boolean.FALSE.equals(val)) {
                val = Boolean.TRUE;
            }
            if (AppDeploymentOptionsHelper.valueIsEmpty(val)) {
                val = opt.defaultVal;
            } else if (!opt.defaultVal.getClass().equals(val.getClass())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "XXXX " + val + " is not a valid value " + " for " + opt.name + " .. ignoring and using default " + opt.defaultVal + ".!");
                }
                val = opt.defaultVal;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing to file - " + opt.name + " = " + val);
            }
            if (opt.name.equals("installed.ear.destination")) {
                boolean shouldAddEarSuffix = true;
                String dir = (String)sch.getProperties().get("installed.ear.destination");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dir retreived from scheduler: " + dir);
                }
                String appEarName = EditionHelper.getAppEarName(sch.getAppName(), tbl);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "appEarName: " + appEarName);
                }
                if ((op & 0x110L) == 0L) {
                    if (appDepl.eIsSet(AppdeploymentPackage.eINSTANCE.getApplicationDeployment_BinariesURL())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "enhanced ear case!!", appDepl.getBinariesURL());
                        }
                        if ((op & 0x111000L) == 0L && !AppDeploymentOptionsHelper.valueIsEmpty(dir) && dir.equals(appDepl.getBinariesURL())) {
                            shouldAddEarSuffix = false;
                        }
                    } else if (appDepl.getBinariesURL() != null && appDepl.getBinariesURL().endsWith(appEarName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "other scenario where bin url has app name in it!!", appDepl.getBinariesURL());
                        }
                        shouldAddEarSuffix = false;
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "binaryURL from appDepl: " + appDepl.getBinariesURL());
                    }
                    if (!appDepl.getBinariesURL().endsWith(appEarName) && !AppDeploymentOptionsHelper.valueIsEmpty(dir) && dir.equals(appDepl.getBinariesURL())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Edit ehanced ear scenario where binUrl doesn't match with  appName.ear at the end. And user hasn't change the binaryURL");
                        }
                        shouldAddEarSuffix = false;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "shouldAddEarSuffix " + shouldAddEarSuffix);
                }
                val = AppUtils.getAppInstallDir(sch, appC, shouldAddEarSuffix);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " val obtained in saveAppOptions is " + val);
                }
                appDepl.setBinariesURL((String)val);
                continue;
            }
            if (opt.name.equals("distributeApp")) {
                appDepl.setEnableDistribution((Boolean)val);
                continue;
            }
            if (opt.name.equals("useMetaDataFromBinary")) {
                appDepl.setUseMetadataFromBinaries((Boolean)val);
                continue;
            }
            if (opt.name.equals("createMBeansForResources")) {
                appDepl.setCreateMBeansForResources((Boolean)val);
                continue;
            }
            if (opt.name.equals("reloadEnabled")) {
                appDepl.setReloadEnabled((Boolean)val);
                continue;
            }
            if (opt.name.equals("edition")) {
                try {
                    RepositoryContext rc = appC;
                    p = AppUtils.getEditionProps(rc);
                    String defaultState = "INACTIVE";
                    if (((Properties)p).isEmpty()) {
                        defaultState = "ACTIVE";
                    }
                    ((Properties)p).put(EditionHelper.getEditionStatePropName(rc.getName()), defaultState);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting config.state(" + rc.getName() + ")=" + defaultState);
                    }
                    AppUtils.setEditionProps(rc, (Properties)p);
                }
                catch (AdminException ex) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Error saving active property for edition: " + ex);
                }
                continue;
            }
            if (opt.name.equals("edition.desc")) {
                if (AppUtils.isEmpty((String)val)) continue;
                try {
                    RepositoryContext rc = appC;
                    p = AppUtils.getEditionProps(rc);
                    ((Properties)p).put(EditionHelper.getEditionDescPropName(rc.getName()), (String)val);
                    AppUtils.setEditionProps(rc, (Properties)p);
                }
                catch (AdminException ex) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Error saving desc for edition: " + ex);
                }
                continue;
            }
            if (opt.name.equals("reloadInterval")) {
                if (!appDepl.isReloadEnabled() || AppUtils.isEmpty((String)val)) continue;
                Tr.debug(tc, "Class reloading is enabled ");
                try {
                    appDepl.setReloadInterval(Long.parseLong((String)val));
                }
                catch (Throwable th) {
                    Tr.warning(tc, "ADMA5050E", new Object[]{val});
                }
                continue;
            }
            if (opt.name.equals("classLoaderPolicy")) {
                if (!AppConstants.APPDEPL_CLASSLOADERPOLICY_MULTIPLE.equals(val) && !AppConstants.APPDEPL_CLASSLOADERPOLICY_SINGLE.equals(val)) {
                    if (AppDeploymentOptionsHelper.valueIsEmpty(val)) {
                        Tr.warning(tc, "ADMA5051W", new Object[]{val});
                    }
                    val = opt.defaultVal;
                }
                appDepl.setWarClassLoaderPolicy(AppConstants.APPDEPL_CLASSLOADERPOLICY_SINGLE.equals(val) ? ClassLoaderPolicy.SINGLE_LITERAL : ClassLoaderPolicy.MULTIPLE_LITERAL);
                continue;
            }
            if (opt.name.equals("classLoadingMode")) {
                Classloader clsLoader;
                if (!AppConstants.APPDEPL_CLASSLOADINGMODE_PARENTFIRST.equals(val) && !AppConstants.APPDEPL_CLASSLOADINGMODE_PARENTLAST.equals(val)) {
                    if (AppDeploymentOptionsHelper.valueIsEmpty(val)) {
                        Tr.warning(tc, "ADMA5052W", new Object[]{val});
                    }
                    val = opt.defaultVal;
                }
                if ((clsLoader = appDepl.getClassloader()) == null) {
                    clsLoader = AppDeploymentOptionsHelper.getClassloaderFactory().createClassloader();
                    appDepl.setClassloader(clsLoader);
                } else if (AppDeploymentOptionsHelper.valueIsEmpty(origVal) && clsLoader.eIsSet(ClassloaderPackage.eINSTANCE.getClassloader_Mode())) continue;
                clsLoader.setMode(AppConstants.APPDEPL_CLASSLOADINGMODE_PARENTFIRST.equals(val) ? ClassLoadingMode.PARENT_FIRST_LITERAL : ClassLoadingMode.PARENT_LAST_LITERAL);
                continue;
            }
            if (opt.name.equals("zeroBinaryCopy")) {
                if (!Boolean.TRUE.equals(val)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "!! Zero bin copy mode set.");
                }
                appDepl.setUseMetadataFromBinaries(true);
                appDepl.setEnableDistribution(false);
                appDepl.setZeroBinaryCopy(true);
                continue;
            }
            if (opt.name.equals("zeroEarCopy")) {
                if (!Boolean.TRUE.equals(val)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "!! Zero ear copy mode set.");
                }
                appDepl.setEnableDistribution(false);
                appDepl.setZeroEarCopy(true);
                continue;
            }
            if (opt.name.equals("copy.sessionmgr.servername")) {
                if (AppUtils.isEmpty((String)val)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "!! Copy session mgr settings.");
                }
                AppDeploymentOptionsHelper.copySessionMgr(appDepl, (String)val, appC);
                continue;
            }
            if (opt.name.equals("was.loose.config")) {
                if (AppUtils.isEmpty((String)val)) continue;
                EList props = appDepl.getProperties();
                for (int lcv = 0; lcv < props.size(); ++lcv) {
                    Property p2 = (Property)props.get(lcv);
                    if (!"was.loose.config".equals(p2.getName())) continue;
                    props.remove(p2);
                    break;
                }
                p = PropertiesFactory.eINSTANCE.createProperty();
                p.setName("was.loose.config");
                p.setValue((String)val);
                props.add(p);
                continue;
            }
            if (opt.name.equals("asyncRequestDispatchType")) {
                if (AppUtils.isEmpty((String)val)) continue;
                if (((String)val).trim().toUpperCase().equals("DISABLED")) {
                    appDepl.setAsyncRequestDispatchType(AsyncRequestDispatchType.DISABLED_LITERAL);
                } else if (((String)val).trim().toUpperCase().equals("CLIENT_SIDE")) {
                    appDepl.setAsyncRequestDispatchType(AsyncRequestDispatchType.CLIENT_SIDE_LITERAL);
                } else if (((String)val).trim().toUpperCase().equals("SERVER_SIDE")) {
                    appDepl.setAsyncRequestDispatchType(AsyncRequestDispatchType.SERVER_SIDE_LITERAL);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid async request dispatch type set.  Ignoring the options!!");
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "AsyncRequestDispatch set.");
                continue;
            }
            if (opt.name.equals("filepermission")) {
                if (AppUtils.isEmpty((String)val)) continue;
                appDepl.setFilePermission((String)val);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ttt filepermission set.");
                continue;
            }
            if (opt.name.equals("allowDispatchRemoteInclude")) {
                appDepl.setAllowDispatchRemoteInclude((Boolean)val);
                continue;
            }
            if (opt.name.equals("allowServiceRemoteInclude")) {
                appDepl.setAllowServiceRemoteInclude((Boolean)val);
                continue;
            }
            if (opt.name.equals("useAutoLink")) {
                appDepl.setAutoLink((Boolean)val);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "XXXXXX Unexpected attr " + opt.name + " in hash2Files()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hash2Files");
        }
    }

    private static ClassloaderFactory getClassloaderFactory() {
        if (_gClassloaderFactory == null) {
            ClassloaderPackage clsPkg = (ClassloaderPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/classloader.xmi");
            _gClassloaderFactory = clsPkg.getClassloaderFactory();
        }
        return _gClassloaderFactory;
    }

    private static void copySessionMgr(ApplicationDeployment appDepl, String val, RepositoryContext appC) {
        try {
            EObject o;
            RepositoryContext rc;
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "copySessionMgr");
            }
            if ((rc = AppUtils.findContext("servers", val, null, appC.getParent().getParent(), appC.getWorkSpace(), false)) == null) {
                Tr.warning(tc, "ADMA5034W", new Object[]{val});
                return;
            }
            URI uri = URI.createURI("server.xml");
            Resource res = rc.getResourceSet().createResource(uri);
            HashMap options = new HashMap();
            res.load(options);
            Server s = (Server)res.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server: " + s);
            }
            Component appServer = null;
            EList l = s.getComponents();
            for (int i = 0; i < l.size(); ++i) {
                if (!(l.get(i) instanceof ApplicationServer)) continue;
                appServer = (ApplicationServer)l.get(i);
                break;
            }
            if (appServer == null) {
                Tr.exit(tc, "No app server in " + val);
                return;
            }
            ServiceContext wc2 = null;
            l = appServer.getComponents();
            for (int i = 0; i < l.size(); ++i) {
                if (!(l.get(i) instanceof WebContainer)) continue;
                wc2 = (WebContainer)l.get(i);
                break;
            }
            if (wc2 == null) {
                Tr.exit(tc, "No web container in " + appServer);
                return;
            }
            l = wc2.getServices();
            SessionManager ss = null;
            for (int i = 0; i < l.size(); ++i) {
                if (!(l.get(i) instanceof SessionManager)) continue;
                ss = (SessionManager)l.get(i);
                break;
            }
            if (ss == null) {
                Tr.exit(tc, "No session mgr in " + wc2);
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "session mgr: " + ss);
            }
            if (!((o = EtoolsCopyUtility.createCopy(ss)) instanceof SessionManager)) {
                Tr.warning(tc, "ADMA5035E", new Object[]{val, o});
                return;
            }
            if (_appCfgFactory == null) {
                ConfigInit.init();
                AppdeploymentPackageImpl.init();
                AppcfgPackageImpl.init();
                AppcfgPackage cfgpkg = (AppcfgPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appcfg.xmi");
                _appCfgFactory = cfgpkg.getAppcfgFactory();
            }
            ApplicationConfig cfg = _appCfgFactory.createApplicationConfig();
            cfg.setSessionManagement((SessionManager)o);
            appDepl.getConfigs().add(cfg);
            EList dtms = appDepl.getTargetMappings();
            for (int j = 0; j < dtms.size(); ++j) {
                ((DeploymentTargetMapping)dtms.get(j)).setConfig(cfg);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Set session mgr for DTM: " + dtms.get(j));
            }
        }
        catch (Throwable th) {
            Tr.warning(tc, "ADMA5036E", new Object[]{th, val});
            RasUtils.logException(th, tc, CLASS_NAME, "copySessionMgr", "1233");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "copySessionMgr");
        }
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        ModuleType t = allTypes.contains(ModuleType.EAR) ? ModuleType.EAR : (ModuleType)allTypes.elementAt(0);
        Hashtable<String, String> tbl = new Hashtable<String, String>();
        tbl.put(t.toString(), "/");
        return tbl;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        J2EEDeployUtil.allTaskData2DC(task, dcImpl);
        Vector v = dcImpl.allProps();
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            Hashtable tbl = (Hashtable)v.elementAt(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "root dcImpl prop table from: " + tbl.get("taskName"));
            }
            if (!"AppDeploymentOptions".equals(tbl.get("taskName"))) continue;
            tbl.put("enableEndpoint", "AppDeploymentOption.No");
            tbl.put("enableHttpRouterSecurity", "AppDeploymentOption.No");
            tbl.put("endpointEnableProps", "");
        }
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        Object answer = props.remove("enableEndpoint");
        if (answer != null && "AppDeploymentOption.Yes".equals(answer)) {
            task.getAppDeploymentController().getAppOptions().put("enableEndpoint", Boolean.TRUE);
        } else {
            task.getAppDeploymentController().getAppOptions().put("enableEndpoint", Boolean.FALSE);
        }
        answer = props.remove("enableHttpRouterSecurity");
        if (answer != null && "AppDeploymentOption.Yes".equals(answer)) {
            task.getAppDeploymentController().getAppOptions().put("enableHttpRouterSecurity", Boolean.TRUE);
        } else {
            task.getAppDeploymentController().getAppOptions().put("enableHttpRouterSecurity", Boolean.FALSE);
        }
        answer = props.remove("endpointEnableProps");
        if (answer != null && answer instanceof String && !AppUtils.isEmpty((String)answer)) {
            task.getAppDeploymentController().getAppOptions().put("endpointEnableProps", answer);
        }
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/client/AppDeploymentOptionsHelper.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.74.1.3");
        }
        CLASS_NAME = AppDeploymentOptionsHelper.class.getName();
    }
}

