/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentProfile;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import java.text.MessageFormat;
import java.util.Vector;

public class AppDeploymentOptions
extends AppDeploymentTask {
    private static final long serialVersionUID = -8352120549891343541L;
    private static TraceComponent tc = Tr.register(AppDeploymentOptions.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String TaskName = "AppDeploymentOptions";

    public AppDeploymentOptions(AppDeploymentController flowController) {
        super(flowController);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, TaskName);
        }
        this.name = TaskName;
        long mode = flowController.getDeploymentMode();
        Vector v = AppDeploymentProfile.getProfile(mode);
        this.colNames = new String[v.size()];
        this.mutables = new boolean[v.size()];
        this.requiredColumns = new boolean[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            AppDeploymentProfile.DeplOption opt = (AppDeploymentProfile.DeplOption)v.elementAt(i);
            this.colNames[i] = opt.name;
            this.mutables[i] = (opt.mutable & mode) != 0L;
            this.requiredColumns[i] = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, TaskName);
        }
    }

    public boolean isEJBDeployEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEJBDeployEnabled");
        }
        if (this.taskData == null || this.isTaskEmpty) {
            return false;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("deployejb")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isEJBDeployEnabled: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i]));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEJBDeployEnabled: no col found");
        }
        return false;
    }

    public boolean isWSDeployEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWSDeployEnabled");
        }
        if (this.taskData == null || this.isTaskEmpty) {
            return false;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("deployws")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isWSDeployEnabled: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i]));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isWSDeployEnabled: no col found");
        }
        return false;
    }

    public boolean isPreCompileJSPEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPreCompileJSPEnabled");
        }
        boolean ret = false;
        if (this.taskData == null || this.isTaskEmpty) {
            return ret;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("preCompileJSPs")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isPreCompileJSPEnabled: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i]));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPreCompileJSPEnabled - " + ret);
        }
        return ret;
    }

    public boolean isUseBinaryConfigEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUseBinaryConfigEnabled");
        }
        if (this.taskData == null || this.isTaskEmpty) {
            return false;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("useMetaDataFromBinary")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isUseBinaryConfigEnabled: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i]));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUseBinaryConfigEnabled: no col found");
        }
        return false;
    }

    public boolean isProcessEmbeddedCFG() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUseBinaryConfigEnabled");
        }
        if (this.taskData == null || this.isTaskEmpty) {
            return false;
        }
        if (!AppUtils.getGlobalEmbededConfig()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isUseBinaryConfigEnabled globally processEmbeddedConfigGlobal is set False");
            }
            return false;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("processEmbeddedConfig")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isProcessEmbeddedCFG: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i]));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isProcessEmbeddedCFG: no col found");
        }
        return false;
    }

    public String[] validate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Vector<String> errorMessages = new Vector<String>();
        this.taskValidateErrorMessages = null;
        if (this.taskData == null || this.taskData.length < 2) {
            return this.taskValidateErrorMessages;
        }
        for (int i = 0; i < this.taskData[0].length; ++i) {
            String value;
            String error;
            String error2;
            if ("appname".equals(this.taskData[0][i])) {
                if (!ConfigServiceHelper.checkIfNameValid(this.taskData[1][i])) {
                    error2 = MessageFormat.format(util.getMessage(this, "ADMA0085E"), util.getGoalTitle(this, this.name), this.taskData[1][i]);
                    errorMessages.addElement(error2);
                    this.buildErrorMessages(errorMessages);
                }
            } else if ("edition".equals(this.taskData[0][i]) && !AppUtils.isEmpty(this.taskData[1][i])) {
                if (!EditionHelper.checkIfEditionValid(this.taskData[1][i])) {
                    error2 = MessageFormat.format(util.getMessage(this, "ADMA0140E"), util.getGoalTitle(this, this.name), this.taskData[1][i]);
                    errorMessages.addElement(error2);
                    this.buildErrorMessages(errorMessages);
                }
            } else if ("reloadInterval".equals(this.taskData[0][i]) && !AppUtils.isEmpty(this.taskData[1][i])) {
                try {
                    Long tmp = Long.parseLong(this.taskData[1][i]);
                    if (tmp < 0L) {
                        error = MessageFormat.format(util.getMessage(this, "ADMA7100E"), util.getGoalTitle(this, this.name), this.taskData[1][i]);
                        errorMessages.addElement(error);
                        this.buildErrorMessages(errorMessages);
                    }
                }
                catch (NumberFormatException e) {
                    error = MessageFormat.format(util.getMessage(this, "ADMA7100E"), util.getGoalTitle(this, this.name), this.taskData[1][i]);
                    errorMessages.addElement(error);
                    this.buildErrorMessages(errorMessages);
                }
            }
            if ("validateinstall".equals(this.taskData[0][i]) && !(value = this.taskData[1][i]).equals("off") && !value.equals("warn") && !value.equals("fail")) {
                error = MessageFormat.format(util.getMessage(this, "ADMA0109W"), this.taskData[1][i]);
                errorMessages.addElement(error);
                this.buildErrorMessages(errorMessages);
            }
            if ("asyncRequestDispatchType".equals(this.taskData[0][i]) && !AppUtils.isEmpty(this.taskData[1][i]) && !AppUtils.validateAsyncRequestDispatchString(value = this.taskData[1][i])) {
                error = MessageFormat.format(util.getMessage(this, "ADMA0175E"), this.taskData[1][i]);
                errorMessages.addElement(error);
                this.buildErrorMessages(errorMessages);
            }
            if (!"filepermission".equals(this.taskData[0][i]) || AppUtils.isEmpty(this.taskData[1][i]) || AppUtils.validateFilePermissionString(value = this.taskData[1][i])) continue;
            error = MessageFormat.format(util.getMessage(this, "ADMA0174E"), this.taskData[1][i]);
            errorMessages.addElement(error);
            this.buildErrorMessages(errorMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return this.taskValidateErrorMessages;
    }

    public String getAppName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppName");
        }
        String appName = null;
        if (this.taskData == null || this.isTaskEmpty) {
            return appName;
        }
        int appNameColIndex = -1;
        String[] cols = this.taskData[0];
        for (int i = 0; i < cols.length; ++i) {
            if (!"appname".equals(cols[i])) continue;
            appNameColIndex = i;
            break;
        }
        if (appNameColIndex != -1 && this.taskData.length > 1) {
            appName = this.taskData[1][appNameColIndex];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppName", new Object[]{appName});
        }
        return appName;
    }

    public boolean getAutoLinkOption() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAutoLinkOption");
        }
        if (this.taskData == null || this.isTaskEmpty) {
            return false;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("useAutoLink")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAutoLinkOption: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i]));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAutoLinkOption: no col found, return false");
        }
        return false;
    }
}

