/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.SchedulerImpl;
import com.ibm.ws.management.application.cdfj2eebridge.CDFBridgeExtensionHelper;
import com.ibm.ws.management.util.RasUtils;
import java.util.Hashtable;
import java.util.Vector;

public class UninstallSchedulerImpl
extends SchedulerImpl {
    private static TraceComponent tc = Tr.register(UninstallSchedulerImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    public UninstallSchedulerImpl(String aName, Hashtable tbl, AppManagement appM, AppNotification.Listener notf) {
        super(aName, tbl, appM, notf);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UninstallSchedulerImpl");
        }
        this.appTaskName = "UninstallApplication";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UninstallSchedulerImpl");
        }
    }

    protected void setupTasks() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupTasks");
        }
        Object oExists = null;
        try {
            EditApplication ed = new EditApplication(this.appName, this.properties, null, this.getWorkSpace().getUserName(), this.appManagement);
            oExists = ed.checkIfAppExists();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App " + this.appName + " exists: " + oExists);
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "setupTasks", "79", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in checking app existence: " + this.appName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, th.toString());
            }
            if (this.resBundle != null) {
                throw new AdminException(th, AppUtils.getMessage(this.resBundle, "ADMA0054E", new Object[]{this.appName}));
            }
            throw new AdminException(th);
        }
        if (oExists == null) {
            String msg = AppUtils.getMessage(this.resBundle, "ADMA5108E", new String[]{this.appName});
            throw new AdminException(msg);
        }
        boolean isSystemApp = this.appName.equals(oExists);
        if (isSystemApp) {
            boolean isSystemAppCluster = this.getProperties().get("cluster.name") != null && isSystemApp;
            AppUtils.dbg(tc, "isSystemAppCluster = " + isSystemAppCluster);
            if (isSystemAppCluster) {
                Tr.debug(tc, "Detected system app uninstall on cluster - ");
                if (this.getProperties().get("cell.name") == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0125E", new String[]{this.appName}));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Detected system app uninstall: " + this.appName);
                }
                if (this.getProperties().get("cell.name") == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0125", new String[]{this.appName}));
                }
                if (this.getProperties().get("node.name") == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0126", new String[]{this.appName}));
                }
            }
            this.getProperties().put("META-INF/ibm-application-sa.props", Boolean.TRUE);
        }
        this.tasks = new Vector();
        new DefaultTaskProvider().provideServerUninstallExtensions(this.tasks, this);
        if (!isSystemApp) {
            this.tasks = ExtensionHelper.processServerUninstallExtensions(this.properties, this.tasks, this);
            CDFBridgeExtensionHelper.processServerUninstallExtensions(this.properties, this.tasks, this);
        }
        Tr.debug(tc, "The tasks are: " + this.tasks);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupTasks");
        }
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.uninstall";
    }

    protected AppNotification createCompletionEvent(boolean bSuccess) {
        String msg = "";
        if (this.resBundle != null) {
            msg = AppUtils.getMessage(this.resBundle, bSuccess ? "ADMA5106I" : "ADMA5107E", new String[]{this.appName});
        }
        AppNotification notf = new AppNotification("UninstallApplication", "", bSuccess ? "Completed" : "Failed", "", msg);
        return notf;
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStartEvent");
        }
        String msg = "";
        if (this.resBundle != null) {
            msg = AppUtils.getMessage(this.resBundle, "ADMA5017I", new String[]{this.appName});
        }
        AppNotification notf = new AppNotification("UninstallApplication", "", "InProgress", "", msg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStartEvent");
        }
        return notf;
    }

    protected void performCleanup(boolean bSuccess) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performCleanup");
        }
        if (!bSuccess && !this.amIWorkSpaceOwner) {
            String msg = "An uninstall application operation failed and the configuration session could not be restored to its state before the operation was initiated. The configuration session is in an inconsistent state, and changes made in the session should be discarded.";
            if (this.resBundle != null) {
                msg = AppUtils.getMessage(this.resBundle, "ADMA0186W");
            }
            AppNotification appNotification = new AppNotification("UninstallApplication", "", "Warning", "", msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performCleanup");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/UninstallSchedulerImpl.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.29");
        }
        CLASS_NAME = UninstallSchedulerImpl.class.getName();
    }
}

