/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class PartialDeploymentInfo
extends ArchiveDeploymentInfo {
    private static TraceComponent tc = Tr.register(PartialDeploymentInfo.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    boolean isApp;
    ModuleRef moduleRef;
    ResourceBundle resBundle;

    public PartialDeploymentInfo(EARFile ear, Hashtable prefs) throws Exception {
        super(ear, prefs);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PartialDeploymentInfo");
        }
        this.resBundle = AppUtils.getBundle(prefs);
        if (prefs.get("EditAppOnly") != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Edit the app");
            }
            this.isApp = true;
            this.setApplication(ear.getDeploymentDescriptor());
            this.setApplicationBindings(ear.getBindings());
            this.setApplicationExtensions(ear.getExtensions());
        } else {
            this.isApp = false;
            String s = (String)prefs.get("EditModuleOnly");
            this.moduleRef = this.findModuleRef(s);
            if (this.moduleRef == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0048E", new Object[]{s}));
            }
            if (this.moduleRef.isEJB()) {
                this.fluffConfig(this.moduleRef, "JAR_DD", "JAR_BND", "JAR_EXT");
            } else if (this.moduleRef.isWeb()) {
                this.fluffConfig(this.moduleRef, "WAR_DD", "WAR_BND", "WAR_EXT");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PartialDeploymentInfo");
        }
    }

    public boolean isApp() {
        return this.isApp;
    }

    private ModuleRef findModuleRef(String unique) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findModuleRef: " + unique);
        }
        EList l = this.archive.getModuleRefs();
        String mURI = util.getModuleURIFromUniqueName(unique);
        String dURI = util.getDDURIFromUniqueName(unique);
        for (int i = 0; i < l.size(); ++i) {
            ModuleRef mRef = (ModuleRef)l.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modRef: " + mRef);
            }
            if (!this.matchModuleRef(dURI, mURI, mRef)) continue;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "findModuleRef: " + mRef);
            }
            return mRef;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findModuleRef: null");
        }
        return null;
    }

    private boolean matchModuleRef(String dURI, String mURI, ModuleRef mRef) throws Exception {
        if (!mURI.equals(mRef.getUri())) {
            return false;
        }
        EObject altDD = mRef.getAltDeploymentDescriptor();
        if (altDD != null) {
            if (altDD.eResource().getURI().toString().equals(dURI)) {
                return true;
            }
        } else {
            if (AppUtils.isEmpty(dURI)) {
                return true;
            }
            if (ConfigRepoHelper.getDDUri(mRef).equals(dURI)) {
                return true;
            }
        }
        return false;
    }

    private void fluffConfig(ModuleRef mRef, String dS, String bS, String eS) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fluffConfig: " + mRef + ", " + dS);
        }
        Vector<EObject> v = null;
        EObject dd = mRef.getDeploymentDescriptor();
        v = new Vector<EObject>();
        v.addElement(dd);
        this.setModuleConfig(dS, v);
        EObject bnd = mRef.getBindings();
        v = new Vector();
        v.addElement(bnd);
        this.setModuleConfig(bS, v);
        EObject ext = mRef.getExtensions();
        v = new Vector();
        v.addElement(ext);
        this.setModuleConfig(eS, v);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fluffConfig: " + bS + ", " + eS);
        }
    }

    protected Vector createModuleConfig(String configType) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createModuleConfig");
        }
        if (this.isApp) {
            return super.createModuleConfig(configType);
        }
        Vector ret = new Vector();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createModuleConfig");
        }
        return ret;
    }

    public Module getModuleForDD(EObject obj) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleForDD");
        }
        if (this.isApp) {
            return super.getModuleForDD(obj);
        }
        try {
            if (this.moduleRef.getDeploymentDescriptor() == obj) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getModuleForDD");
                }
                return this.moduleRef.getModule();
            }
        }
        catch (ArchiveWrappedException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getModuleForDD: " + this.moduleRef + ", dd: " + obj + " " + ex);
            }
            throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0049E", new Object[]{obj}), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleForDD: BADDD: return null");
        }
        return null;
    }

    public void saveAndClose() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveAndClose");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveAndClose");
        }
    }

    public Hashtable getSavedResults() {
        return super.getSavedResults();
    }

    public String getSecurityPolicyData() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityPolicyData");
        }
        String retVal = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityPolicyData");
        }
        return retVal;
    }

    public String getJ2EEAppVersion() {
        Application appDD;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2EEAppVersion");
        }
        if ((appDD = this.app) == null) {
            appDD = this.archive.getDeploymentDescriptor();
        }
        String ret = "";
        if (appDD == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null Application DD");
            }
        } else {
            XMLResource xmlResource = (XMLResource)appDD.eResource();
            if (xmlResource == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AppDD has no XML Resource: " + appDD);
                }
            } else {
                String strPublicId = xmlResource.getPublicId();
                if (strPublicId == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AppDD has no XML Resource Id: " + appDD);
                    }
                } else if (strPublicId.equalsIgnoreCase("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN")) {
                    ret = AppConstants.APPDEPL_APP_VERSION_1_2;
                } else if (strPublicId.equalsIgnoreCase("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN")) {
                    ret = AppConstants.APPDEPL_APP_VERSION_1_3;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Return J2EE version: " + ret);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2EEAppVersion");
        }
        return ret;
    }

    public String getURI() {
        return null;
    }
}

