/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementHelper;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ArchiveSchedulerImpl;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.cdfj2eebridge.CDFBridgeExtensionHelper;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ActivationPlan;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.ValidateEE5RestrictionTask;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class InstallSchedulerImpl
extends ArchiveSchedulerImpl
implements InstallScheduler {
    private static final TraceComponent tc = Tr.register(InstallSchedulerImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    public InstallSchedulerImpl(String earFilePath, String aName, Hashtable tbl, AppManagement appM, AppNotification.Listener notf) {
        super(earFilePath, aName, tbl, appM, notf);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "InstallSchedulerImpl");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Ear: " + earFilePath + ", appName: " + aName + ", options: " + tbl);
        }
        this.appTaskName = "InstallApplication";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unique id: " + this.id);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "InstallSchedulerImpl");
        }
    }

    public String getEarPath() {
        return this.getArchivePath();
    }

    public void setEarPath(String path) throws AdminException {
        this.setArchivePath(path, true);
    }

    public void setEarPath(String path, boolean close) throws AdminException {
        this.setArchivePath(path, close);
    }

    public EARFile getEarFile() throws AdminException {
        return (EARFile)this.getArchive(false, false);
    }

    public EARFile getEarFile(boolean useReflection, boolean readOnly) throws AdminException {
        return (EARFile)this.getArchive(useReflection, readOnly);
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.install";
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStartEvent");
        }
        String msg = "";
        if (this.resBundle != null) {
            msg = AppUtils.getMessage(this.resBundle, "ADMA5016I", new String[]{this.getCompositeAppName()});
        }
        AppNotification notf = new AppNotification("InstallApplication", "", "InProgress", "", msg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStartEvent");
        }
        return notf;
    }

    protected AppNotification createCompletionEvent(boolean bSuccess) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCompletionEvent");
        }
        String msg = "";
        if (this.resBundle != null) {
            msg = AppUtils.getMessage(this.resBundle, bSuccess ? "ADMA5013I" : ("app".equals(this.getProperties().get("contenttype")) ? "ADMA5069E" : "ADMA5014E"), new String[]{this.getCompositeAppName()});
        }
        AppNotification notf = new AppNotification("InstallApplication", "", bSuccess ? "Completed" : "Failed", "", msg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCompletionEvent");
        }
        return notf;
    }

    private String getCompositeAppName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompositeAppName");
        }
        String compositeName = EditionHelper.getCompositeName(this.appName, this.properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompositeAppName: " + compositeName);
        }
        return compositeName;
    }

    protected void setupTasks() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupTasks");
        }
        this.updateAppAndCellName();
        Object oExists = null;
        try {
            if (this.properties.get("original.ear.location") == null) {
                this.properties.put("original.ear.location", this._origPathToContent);
            }
            EditApplication ed = new EditApplication(this.appName, this.properties, null, this.getWorkSpace().getUserName(), this.appManagement);
            oExists = ed.checkIfAppExists();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App " + this.appName + " exists: " + oExists);
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "setupTasks", "205", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in checking app existence: " + this.appName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, th.toString());
            }
            if (this.resBundle != null) {
                throw new AdminException(th, AppUtils.getMessage(this.resBundle, "ADMA0054E", new Object[]{this.appName}));
            }
            throw new AdminException(th);
        }
        if (oExists != null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5015E", new String[]{this.appName}));
        }
        boolean isSystemApp = AppManagementHelper.isSystemAppV6(this.getEarPath());
        if (isSystemApp) {
            this.getProperties().put("META-INF/ibm-application-sa.props", Boolean.TRUE);
        }
        boolean isSystemAppOption = AppUtils.isSystemAppOption(this.getProperties());
        if (isSystemApp || isSystemAppOption) {
            boolean isSystemAppCluster = this.getProperties().get("cluster.name") != null && (isSystemApp || isSystemAppOption);
            AppUtils.dbg(tc, "isSystemAppCluster = " + isSystemAppCluster);
            if (isSystemAppCluster) {
                Tr.debug(tc, "Detected system app install on cluster - ");
                if (this.getProperties().get("cell.name") == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0125E", new String[]{this.appName}));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Detected system app install - From APPDEPL_SYSTEM_APP_FLAG = " + isSystemApp + ", From APPDEPL_SYSTEM_APP_OPTION = " + isSystemAppOption);
                }
                if (this.getProperties().get("cell.name") == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0125E", new String[]{this.appName}));
                }
                if (this.getProperties().get("node.name") == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0126E", new String[]{this.appName}));
                }
                if (this.getProperties().get("server.name") == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0127E", new String[]{this.appName}));
                }
            }
        }
        this.tasks = new Vector();
        new DefaultTaskProvider().provideServerInstallExtensions(this.tasks, this);
        if (!isSystemApp && !isSystemAppOption) {
            AppUtils.dbg(tc, "not system app...");
            this.tasks = ExtensionHelper.processServerInstallExtensions(this.properties, this.tasks, this);
            CDFBridgeExtensionHelper.processServerInstallExtensions(this.properties, this.tasks, this);
            this.tasks.addElement(new ActivationPlan());
            this.tasks.add(0, new ValidateEE5RestrictionTask());
        }
        AppUtils.dbg(tc, AppUtils.getMessage(this.resBundle, "ADMA6010I", new Object[]{this.tasks}));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupTasks");
        }
    }

    private void updateAppAndCellName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAppAndCellName");
        }
        if (this.appName == null) {
            this.appName = (String)this.getProperties().get("appname");
            if (AppUtils.isEmpty(this.appName)) {
                this.appName = AppInstallHelper.getAppDisplayName(this.getEarFile(false, true), this.properties);
            }
            if (this.appName != null) {
                this.appName = this.appName.trim();
            }
        }
        if (!ConfigServiceHelper.checkIfNameValid(this.appName)) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA5019E", new Object[]{this.appName}));
        }
        if (EditionHelper.isEditionSupportEnabled()) {
            if (this.appName.indexOf("-edition") != -1) {
                throw new AdminException(null, "AppName can not contain -edition.  Invalid app name: " + this.appName);
            }
            Object o = this.getProperties().get("edition");
            if (o != null && !(o instanceof String)) {
                throw new AdminException(null, "Edition must be a string: " + o);
            }
        }
        String cellName = null;
        Hashtable tbl = (Hashtable)this.getProperties().get("moduleToServer");
        if (tbl == null) {
            tbl = new Hashtable();
            this.getProperties().put("moduleToServer", tbl);
        }
        Iterator ee = tbl.values().iterator();
        String remDelim = "-WebSphere:";
        String addDelim = "+WebSphere:";
        while (ee.hasNext()) {
            String s = (String)ee.next();
            List<String> strTokens = Arrays.asList(s.split("\\" + addDelim + "|" + remDelim));
            Iterator<String> st = strTokens.iterator();
            while (st.hasNext()) {
                String token = st.next().trim();
                if (AppUtils.isEmpty(token)) continue;
                ObjectName on = null;
                try {
                    if (token.indexOf("WebSphere:") < 0) {
                        token = "WebSphere:" + token;
                    }
                    AppUtils.dbg(tc, "token = " + token);
                    on = new ObjectName(token);
                    cellName = on.getKeyProperty("cell");
                    if (cellName == null) continue;
                    break;
                }
                catch (MalformedObjectNameException ex) {
                    RasUtils.logException(ex, tc, CLASS_NAME, "updateAppAndCellName", "360", this, new Object[]{"Bad token: " + token});
                    throw new AdminException(ex, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5025E", new Object[]{token}));
                }
            }
            if (cellName == null) continue;
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellName " + cellName);
        }
        if (cellName != null) {
            this.getProperties().put("cell.name", cellName);
        }
        if ((cellName = (String)this.getProperties().get("cell.name")) == null) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA5046E", new Object[0]));
        }
        this.cellContext = AppUtils.findContext("cells", cellName, null, null, this.getWorkSpace(), true);
        if (this.cellContext == null) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA0128E", new String[]{this.appName}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAppAndCellName:" + this.appName + ", " + cellName);
        }
    }

    protected void performCleanup(boolean bSuccess) throws Exception {
        super.performCleanup(bSuccess);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performCleanup");
        }
        if (!this.setupDone || bSuccess) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performCleanup:  nosetupDone or success");
            }
            return;
        }
        RepositoryContext applC = AppUtils.findAppContextFromConfig(this.getAppName(), this.getWorkSpace(), this.getProperties());
        RepositoryContext binCtx = null;
        try {
            if (applC != null && applC.isAvailable("deployment.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Install failed. Found deployment.xml");
                }
                ApplicationDeployment appdepl = ConfigRepoHelper.getAppDeploymentForApp(applC);
                Vector v = ConfigRepoHelper.getServersForAppDeployment(appdepl, null, this.getCellContext(), this.getWorkSpace(), false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "App was to be installed on: " + v);
                }
                Hashtable retTable = ConfigRepoHelper.updateServerIndexDocs(applC, this.getWorkSpace(), v, false, this.resBundle);
                this.getProperties().remove("nodesvr.added");
                this.getProperties().remove("nodesvr.removed");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed entry from: " + retTable);
                }
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "performCleanup", "439", this);
        }
        if (applC != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting application ctx " + applC + " after install failed.");
            }
            binCtx = applC.getParent();
            applC.delete(true);
        }
        if (binCtx != null && binCtx.getChildren().size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting backup ctx " + binCtx + " after install failed.");
            }
            binCtx.delete(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performCleanup");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/InstallSchedulerImpl.java, WAS.admin.appmgmt.server, WAS70.SERV1, cf050925.09, ver. 1.76");
        }
        CLASS_NAME = InstallSchedulerImpl.class.getName();
    }
}

