/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.applicationbnd.Subject;
import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBBindingsHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.EditionInfo;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.AppcfgFactory;
import com.ibm.websphere.models.config.appcfg.AppcfgPackage;
import com.ibm.websphere.models.config.appcfg.impl.AppcfgPackageImpl;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentFactory;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditSchedulerImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.ListModules;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ActivationPlan;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.SetApplicationInfoTask;
import com.ibm.ws.management.configarchive.EnhancedEarConfigurator;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class EditApplication {
    private static TraceComponent tc = Tr.register(EditApplication.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    public static final String TableDDL = "META-INF/Table.ddl";
    public static final String BackendDir = "META-INF/backends/";
    private static AppdeploymentFactory appFactory;
    private static AppcfgFactory appCfgFactory;
    private static final String APP_XML_DD = "META-INF/application.xml";
    private static final String JAR_XML_DD = "META-INF/ejb-jar.xml";
    private static final String WEB_XML_DD = "WEB-INF/web.xml";
    private static final String ee5DeplymentDescriptorsURI = "META-INF/application.xml|.*[/]META-INF/ejb-jar.xml|.*[/]WEB-INF/web.xml";
    private String appName;
    private Hashtable prefs;
    private String uniqueModuleURI;
    private String workspaceID;
    private AppManagement appM;
    boolean isApp = false;
    ResourceBundle resBundle = null;

    private static AppdeploymentFactory getAppFactory() {
        if (appFactory != null) {
            return appFactory;
        }
        ArchiveInit.init();
        CommonarchiveFactoryImpl.getActiveFactory();
        ConfigInit.init();
        AppdeploymentPackageImpl.init();
        AppdeploymentPackage apppkg = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
        appFactory = apppkg.getAppdeploymentFactory();
        return appFactory;
    }

    private static AppcfgFactory getAppcfgFactory() {
        if (appCfgFactory != null) {
            return appCfgFactory;
        }
        ArchiveInit.init();
        CommonarchiveFactoryImpl.getActiveFactory();
        ConfigInit.init();
        AppcfgPackageImpl.init();
        AppcfgPackage cfgpkg = (AppcfgPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appcfg.xmi");
        appCfgFactory = cfgpkg.getAppcfgFactory();
        return appCfgFactory;
    }

    public EditApplication(String aName, Hashtable prf, String mod, String wID, AppManagement mgmt) {
        this.appName = aName;
        this.prefs = prf;
        this.uniqueModuleURI = mod;
        this.workspaceID = wID;
        this.appM = mgmt;
        if (this.prefs == null) {
            this.prefs = new Hashtable();
        }
        this.isApp = this.uniqueModuleURI == null;
        this.resBundle = AppUtils.getBundle(this.prefs);
    }

    private void doFinally(WorkSpace ws, EARFile earFile, boolean sync2) {
        EditApplication.doFinally(ws, this.workspaceID, earFile, sync2);
    }

    public static void doFinally(WorkSpace ws, String workspaceID, EARFile earFile, boolean sync2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doFinally", new String[]{"ws=" + ws, "workspaceID=" + workspaceID, "earFile=" + earFile, "sync=" + sync2});
        }
        if (earFile != null) {
            earFile.close();
        }
        if (ws != null && workspaceID == null) {
            try {
                ConfigRepoHelper.removeWorkSpace(sync2, ws);
            }
            catch (Throwable th1) {
                RasUtils.logException(th1, tc, CLASS_NAME, "doFinally", "228", null, new Object[]{"workspaceID=" + workspaceID});
                Tr.warning(tc, "ADMA0077W", th1);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doFinally");
        }
    }

    public Object checkIfAppExists() throws AdminException {
        Object var3_7;
        WorkSpace ws;
        block18: {
            block17: {
                block16: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "checkIfAppExists: " + this.appName);
                    }
                    if (this.appName == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0045E"));
                    }
                    ws = null;
                    ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                    RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, ws, this.prefs);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "App " + this.appName + " exists: " + rc);
                    }
                    if (rc == null) break block16;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfAppExists");
                    }
                    RepositoryContext repositoryContext = rc;
                    Object var5_8 = null;
                    EditApplication.doFinally(ws, this.workspaceID, null, false);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfAppExists: " + this.appName);
                    }
                    return repositoryContext;
                }
                if (this.prefs.get("cluster.name") == null || !AppUtils.isAnInstalledSystemAppOnCluster(this.appName, ws, this.prefs)) break block17;
                String string = this.appName;
                Object var5_9 = null;
                EditApplication.doFinally(ws, this.workspaceID, null, false);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfAppExists: " + this.appName);
                }
                return string;
            }
            if (!AppUtils.isAnInstalledSystemApp(this.appName, ws, this.prefs, false)) break block18;
            String string = this.appName;
            Object var5_10 = null;
            EditApplication.doFinally(ws, this.workspaceID, null, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkIfAppExists: " + this.appName);
            }
            return string;
        }
        try {
            var3_7 = null;
            Object var5_11 = null;
        }
        catch (Throwable th) {
            try {
                RasUtils.logException(th, tc, CLASS_NAME, "checkIfAppExists", "272", this);
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, "");
            }
            catch (Throwable throwable) {
                block19: {
                    Object var5_12 = null;
                    EditApplication.doFinally(ws, this.workspaceID, null, false);
                    if (!tc.isEntryEnabled()) break block19;
                    Tr.exit(tc, "checkIfAppExists: " + this.appName);
                }
                throw throwable;
            }
        }
        EditApplication.doFinally(ws, this.workspaceID, null, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfAppExists: " + this.appName);
        }
        return var3_7;
    }

    public Vector getApplicationInfo() throws AdminException {
        Vector<AppDeploymentTask> vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationInfo: " + this.appName + ", " + this.uniqueModuleURI);
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        boolean perm = AppUtils.checkAdminAccessApp(this.prefs, "monitor", this.appName);
        if (!perm) {
            ResourceBundle resBundle = AppUtils.getBundle(this.prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0190E", new Object[]{this.appName}));
        }
        Vector<AppDeploymentTask> retVal = new Vector<AppDeploymentTask>();
        WorkSpace ws = null;
        EARFile earFile = null;
        try {
            ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, ws, this.prefs);
            if (rc == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            if (this.uniqueModuleURI == null) {
                this.prefs.put("EditAppOnly", "");
            } else {
                this.prefs.put("EditModuleOnly", this.uniqueModuleURI);
            }
            this.prefs.put("configsession", new Session(ws.getUserName(), true));
            if (AppManagementImpl.isLocalMode()) {
                ConfigService cs = EditApplication.getLocalConfigService();
                if (cs != null) {
                    this.prefs.put("configservice", cs);
                }
            } else if (AdminServiceFactory.getAdminService() != null) {
                this.prefs.put("configservice", ConfigServiceFactory.getConfigService());
            }
            ApplicationDeployment ad = ConfigRepoHelper.getAppDeploymentForApp(rc);
            earFile = ConfigRepoHelper.getEarFileForApp(ws, rc, this.resBundle, true);
            this.prefs.put("ClientVersion", AppUtils.getClientVersion());
            AppDeploymentController ctrl = AppManagementFactory.readPartialArchive(earFile, this.prefs);
            ctrl.getAppOptions().put("cell.name", rc.getParent().getParent().getName());
            ctrl.getAppOptions().put("appname", this.appName);
            ctrl.getAppOptions().put("edit.deplresource", ad.eResource());
            ctrl.getAppOptions().put("META-INF/ibm-application-runtime.props", ActivationPlan.loadPlan(rc));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created partial controller: " + ctrl);
            }
            AppDeploymentTask task = ctrl.getFirstTask();
            while (task != null) {
                retVal.add(task);
                task = ctrl.getNextTask();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Read tasks from controller: " + retVal.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getApplicationInfo");
            }
            vector = retVal;
            Object var11_12 = null;
            this.doFinally(ws, earFile, false);
        }
        catch (Throwable th) {
            try {
                RasUtils.logException(th, tc, CLASS_NAME, "getApplicationInfo", "362", this);
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, "");
            }
            catch (Throwable throwable) {
                block20: {
                    Object var11_13 = null;
                    this.doFinally(ws, earFile, false);
                    if (!tc.isEntryEnabled()) break block20;
                    Tr.exit(tc, "getApplicationInfo: " + this.appName + ", " + this.uniqueModuleURI);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationInfo: " + this.appName + ", " + this.uniqueModuleURI);
        }
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setApplicationInfo(Vector tasks) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setApplicationInfo: " + this.appName + ", " + this.uniqueModuleURI);
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Object ws = null;
        try {
            try {
                EditSchedulerImpl sch = new EditSchedulerImpl(this.appName, this.prefs, this.appM, tasks, this.uniqueModuleURI);
                sch.setWorkSpaceID(this.workspaceID);
                String pKey = AdminContext.peek();
                sch.setProfileKey(pKey);
                sch.run();
                if (sch.getLastEx() != null) {
                    throw sch.getLastEx();
                }
                Object var7_7 = null;
                Thread.currentThread().setContextClassLoader(cl);
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "setApplicationInfo", "410", this);
                if (!(th instanceof AdminException)) throw new AdminException(th, "");
                throw (AdminException)th;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Thread.currentThread().setContextClassLoader(cl);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "setApplicationInfo: " + this.appName + ", " + this.uniqueModuleURI);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "setApplicationInfo: " + this.appName + ", " + this.uniqueModuleURI);
    }

    /*
     * Loose catch block
     */
    public void exportApplication(String pathName) throws AdminException {
        block24: {
            String absolutePath;
            java.io.File newD;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "exportApplication: " + pathName);
            }
            if (this.appName == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
            }
            WorkSpace ws = null;
            EARFile earFile = null;
            String exDir = null;
            EnhancedEarConfigurator enc = null;
            ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, ws, this.prefs);
            if (rc == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
            earFile = ConfigRepoHelper.getEarFileFromBinaries(rc, ws, this.resBundle, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ear from binaries: " + earFile);
            }
            exDir = AppUtils.getAppTempExportDir(this.appName, this.appM.getGlobalSettings());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Temp export at: " + exDir);
            }
            EarUtils.extractEar((EARFile)earFile, (String)exDir, (boolean)true, (int)94);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Ear file extracted to: " + exDir);
            }
            earFile.close();
            if (!appDepl.isUseMetadataFromBinaries()) {
                Vector<String> excludes = new Vector<String>();
                excludes.add("deployment.xml");
                excludes.add("variables.xml");
                excludes.add("resources.xml");
                AppUtils.xcopy(rc, exDir, excludes);
            }
            String binName = AppUtils.getAppBinDirName(null, this.appName);
            enc = new EnhancedEarConfigurator(ws, exDir, rc.getParent().getParent().getName(), this.appName, binName);
            enc.exportApplicationConfiguration();
            java.io.File dest = new java.io.File(pathName);
            if (dest.getParentFile() != null) {
                dest.getParentFile().mkdirs();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Export path: " + pathName);
            }
            if (!(newD = new java.io.File(absolutePath = dest.getAbsolutePath())).getParentFile().canWrite()) {
                String parent = newD.getParent();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The export directory: " + parent + " is read only");
                }
                throw new AdminException("The application can not be exported. The export directory: " + parent + " has read only permission");
            }
            earFile = AppInstallHelper.getEarFile(exDir, false, this.resBundle);
            earFile.saveAs(absolutePath);
            Object var14_14 = null;
            this.doFinally(ws, earFile, false);
            try {
                if (enc != null) {
                    enc.cleanup();
                }
                AppUtils.deleteDirTree(exDir);
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "exportApplication", "520", this, new Object[]{"Error deleting temp dir " + exDir});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportApplication: " + pathName);
            }
            break block24;
            {
                catch (Throwable th) {
                    RasUtils.logException(th, tc, CLASS_NAME, "exportApplication", "504", this);
                    if (th instanceof AdminException) {
                        throw (AdminException)th;
                    }
                    throw new AdminException(th, "");
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                this.doFinally(ws, earFile, false);
                try {
                    if (enc != null) {
                        enc.cleanup();
                    }
                    AppUtils.deleteDirTree(exDir);
                }
                catch (Throwable th) {
                    RasUtils.logException(th, tc, CLASS_NAME, "exportApplication", "520", this, new Object[]{"Error deleting temp dir " + exDir});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "exportApplication: " + pathName);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractDDL(String ddlPrefix, String dirName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractDDL: " + dirName);
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace ws = null;
        EARFile earFile = null;
        try {
            try {
                ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, ws, this.prefs);
                if (rc == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
                earFile = ConfigRepoHelper.getEarFileForApp(ws, rc, this.resBundle, true);
                if (earFile == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{earFile}));
                }
                HashMap<String, String> ids = new HashMap<String, String>(20);
                List l = earFile.getEJBJarFiles();
                for (int i = 0; i < l.size(); ++i) {
                    EJBJarFile f = (EJBJarFile)l.get(i);
                    EJBJar jar = f.getDeploymentDescriptor();
                    String backend_id = EJBBindingsHelper.getEJBJarBinding(jar).getCurrentBackendId();
                    String index = f.getName();
                    ids.put(index, backend_id);
                }
                if (!appDepl.isUseMetadataFromBinaries()) {
                    earFile.close();
                    earFile = ConfigRepoHelper.getEarFileFromBinaries(rc, ws, this.resBundle, true);
                    if (earFile == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{earFile}));
                    }
                }
                java.io.File destfile = new java.io.File(dirName);
                destfile.mkdirs();
                String dest = destfile.getAbsolutePath();
                l = earFile.getEJBJarFiles();
                for (int i = 0; i < l.size(); ++i) {
                    EJBJarFile f = (EJBJarFile)l.get(i);
                    String jarName = f.getName();
                    String id = (String)ids.get(jarName);
                    if (id != null) {
                        String tblName = BackendDir + id + "/Table.ddl";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "backend Table ddl name for " + id + " is " + tblName);
                        }
                        if (f.containsFile(tblName)) {
                            File file1 = f.getFile(tblName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Table ddl for " + jarName + " is " + tblName);
                            }
                            String ddl = dest + java.io.File.separator + (ddlPrefix == null ? "" : ddlPrefix) + "_" + jarName + "_" + id + "_" + "Table.ddl";
                            InputStream is = file1.getInputStream();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Copying Table.ddl to " + ddl);
                            }
                            AppUtils.copyFile(is, ddl);
                            is.close();
                        } else {
                            id = null;
                            Tr.warning(tc, "ADMA0095W", new Object[]{tblName, jarName});
                        }
                    }
                    if (id != null || !f.containsFile(TableDDL)) continue;
                    File file1 = f.getFile(TableDDL);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Table ddl for " + f.getName() + " is " + file1);
                    }
                    String ddl = dest + java.io.File.separator + (ddlPrefix == null ? "" : ddlPrefix) + "_" + f.getName() + "_" + "Table.ddl";
                    InputStream is = file1.getInputStream();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Copying Table.ddl to " + ddl);
                    }
                    AppUtils.copyFile(is, ddl);
                    is.close();
                }
                Object var20_22 = null;
                this.doFinally(ws, earFile, false);
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "extractDDL", "644", this);
                if (!(th instanceof AdminException)) throw new AdminException(th, "");
                throw (AdminException)th;
            }
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            this.doFinally(ws, earFile, false);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "extractDDL: " + dirName);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "extractDDL: " + dirName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publishWSDL(String pathName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publishWSDL " + pathName);
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace ws = null;
        try {
            try {
                ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, ws, this.prefs);
                if (rc == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                Class<?> deployUtilsClass = Class.forName("com.ibm.ws.webservices.deploy.DeployUtils");
                Class[] paramTypes = new Class[]{RepositoryContext.class, String.class, AttributeList.class};
                Method publishWSDLFileMethod = deployUtilsClass.getMethod("publishWSDLFiles", paramTypes);
                AttributeList prefixes = (AttributeList)this.prefs.get("PREFIXES");
                Object[] paramArray = new Object[]{rc, pathName, prefixes};
                try {
                    publishWSDLFileMethod.invoke(null, paramArray);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
                Object var11_11 = null;
                this.doFinally(ws, null, false);
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "publishWSDL", "700", this);
                if (!(th instanceof AdminException)) throw new AdminException(th, "");
                throw (AdminException)th;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.doFinally(ws, null, false);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "publishWSDL: " + pathName);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "publishWSDL: " + pathName);
    }

    public static Vector listApplications(Hashtable prefs, String wID) throws AdminException {
        return EditApplication.listApplications(prefs, wID, true);
    }

    public static Vector listApplications(Hashtable prefs, String wID, boolean bShowHidden) throws AdminException {
        return EditApplication.listApplications(null, prefs, wID, bShowHidden);
    }

    public AppDeploymentTask listModules() throws AdminException {
        ListModules listModules;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listModules: " + this.appName);
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace ws = null;
        EARFile earFile = null;
        ListModules task = null;
        try {
            ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, ws, this.prefs);
            if (rc == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            earFile = ConfigRepoHelper.getEarFileForApp(ws, rc, this.resBundle, true);
            if (earFile == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{earFile}));
            }
            ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
            Hashtable tbl = ConfigRepoHelper.getCNP(null, appDepl, rc.getParent().getParent().getName());
            task = new ListModules(null);
            Vector<String> data = new Vector<String>();
            String[] col = task.getColumnNames();
            for (int i = 0; i < col.length; ++i) {
                data.addElement(col[i]);
            }
            EList l = earFile.getModuleRefs();
            int appV = ((XMLResource)earFile.getDeploymentDescriptor().eResource()).getVersionID();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "app version: " + appV);
            }
            String appVStr = Integer.toString(appV);
            for (int i = 0; i < l.size(); ++i) {
                ModuleRef mRef = (ModuleRef)l.get(i);
                if (!ConfigRepoHelper.isDeployable(mRef)) continue;
                String displayName = null;
                if (mRef.isEJB()) {
                    displayName = ((EJBJar)mRef.getDeploymentDescriptor()).getDisplayName();
                }
                if (mRef.isWeb()) {
                    displayName = ((WebApp)mRef.getDeploymentDescriptor()).getDisplayName();
                }
                if (AppUtils.isEmpty(displayName)) {
                    displayName = mRef.getUri();
                }
                data.addElement(displayName);
                String key = util.createUniqueModuleName(ConfigRepoHelper.getDDUri(mRef), mRef.getModule().getUri());
                data.addElement(key);
                String t = (String)tbl.get(key);
                data.addElement(t == null ? "" : t);
                data.addElement(appVStr);
                int modV = ((XMLResource)mRef.getDeploymentDescriptor().eResource()).getVersionID();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mod version: " + modV);
                }
                data.addElement(Integer.toString(modV));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Data is: " + data);
            }
            task.setTaskData(util.buildTaskData(data, col.length));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task is: " + task);
            }
            listModules = task;
            Object var19_21 = null;
            this.doFinally(ws, earFile, false);
        }
        catch (Throwable th) {
            try {
                RasUtils.logException(th, tc, CLASS_NAME, "listModules", "834", this);
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, "");
            }
            catch (Throwable throwable) {
                block19: {
                    Object var19_22 = null;
                    this.doFinally(ws, earFile, false);
                    if (!tc.isEntryEnabled()) break block19;
                    Tr.exit(tc, "listModules: " + this.appName);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listModules: " + this.appName);
        }
        return listModules;
    }

    public List listURIs() throws AdminException {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listURIs: " + this.appName);
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace ws = null;
        EARFile earFile = null;
        Object task = null;
        try {
            ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, ws, this.prefs);
            if (rc == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            earFile = ConfigRepoHelper.getEarFileFromBinaries(rc, ws, this.resBundle, true);
            if (earFile == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{earFile}));
            }
            EARFile ar = earFile;
            if (this.uniqueModuleURI != null) {
                String modURI = this.uniqueModuleURI;
                if (modURI.indexOf(43) != -1) {
                    modURI = modURI.substring(0, modURI.indexOf(43));
                }
                List mods = earFile.getModuleFiles();
                ModuleFile mod = null;
                for (int i = 0; i < mods.size(); ++i) {
                    if (!((ModuleFile)mods.get(i)).getURI().equals(modURI)) continue;
                    mod = (ModuleFile)mods.get(i);
                    break;
                }
                if (mod == null) {
                    throw new AdminException("Invalid module.  Module URI " + this.uniqueModuleURI + " does not exist in the application.");
                }
                ar = mod;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archive to look into: " + ar);
            }
            ArrayList retVal = new ArrayList();
            this.listURIs(ar, "", retVal);
            arrayList = retVal;
            Object var11_11 = null;
            this.doFinally(ws, earFile, false);
        }
        catch (Throwable th) {
            try {
                RasUtils.logException(th, tc, CLASS_NAME, "listURIs", "902", this);
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, "");
            }
            catch (Throwable throwable) {
                block15: {
                    Object var11_12 = null;
                    this.doFinally(ws, earFile, false);
                    if (!tc.isEntryEnabled()) break block15;
                    Tr.exit(tc, "listURIs: " + this.appName);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listURIs: " + this.appName);
        }
        return arrayList;
    }

    private void listURIs(Container c, String root, List l) {
        boolean dirFlag = false;
        String strExcludeDir = "excludeDir";
        if (this.prefs != null && this.prefs.containsKey(strExcludeDir) && this.prefs.get(strExcludeDir).equals("true")) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Directories to be excluded: " + this.prefs.get(strExcludeDir));
            }
            dirFlag = true;
        }
        EList files = c.getFiles();
        for (int i = 0; i < files.size(); ++i) {
            File f = (File)files.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file uri: " + f.getURI());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file uri is directory? " + f.isDirectoryEntry());
            }
            if (f instanceof ModuleFile || dirFlag && f.isDirectoryEntry()) continue;
            l.add(root + f.getURI());
            if (!(f instanceof Container)) continue;
            this.listURIs((Container)f, f.getURI() + "/", l);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "final list: " + l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAccessIDs(Boolean bAll) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAccessIDs: " + this.appName + "bAll: " + bAll);
        }
        if (AppManagementImpl.isLocalMode()) {
            if (!tc.isDebugEnabled()) throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0090E", new Object[]{"updateAccessIDs"}));
            Tr.debug(tc, "Local mode: no-op");
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0090E", new Object[]{"updateAccessIDs"}));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace ws = null;
        EARFile earFile = null;
        boolean bEx = false;
        boolean all = Boolean.TRUE.equals(bAll);
        try {
            try {
                boolean bUse;
                ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, ws, this.prefs);
                if (rc == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                ApplicationDeployment depl = ConfigRepoHelper.getAppDeploymentForApp(rc);
                if (!ConfigRepoHelper.isEditAllowed(depl)) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0173E", new Object[]{this.appName, "updateAccessIDs"}));
                }
                Iterator itr = AdminServiceFactory.getAdminService().queryNames(new ObjectName("WebSphere:type=SecurityAdmin,process=" + AdminServiceFactory.getAdminService().getProcessName() + ",*"), null).iterator();
                ObjectName mBean = (ObjectName)itr.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MBean: " + mBean);
                }
                earFile = (bUse = depl.isUseMetadataFromBinaries()) ? ConfigRepoHelper.getEarFileFromBinaries(rc, ws, this.resBundle, (String)this.appM.getGlobalSettings().get("Config Root for variable map")) : ConfigRepoHelper.getEarFileFromDeployment(ws, rc);
                ApplicationBinding bnds = earFile.getBindings();
                AuthorizationTable tbl = bnds.getAuthorizationTable();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Table: " + tbl);
                }
                if (tbl != null) {
                    for (RoleAssignment auth : tbl.getAuthorizations()) {
                        this.updateID(auth.getUsers(), mBean, true, all);
                        this.updateID(auth.getGroups(), mBean, false, all);
                    }
                }
                if (bUse) {
                    earFile.save();
                }
                SetApplicationInfoTask.saveEarFileToDeployment(earFile, rc);
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "updateAccessIDs", "1017", this);
                bEx = true;
                if (!(th instanceof AdminException)) throw new AdminException(th, "");
                throw (AdminException)th;
            }
            Object var16_16 = null;
            this.doFinally(ws, earFile, !bEx);
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.doFinally(ws, earFile, !bEx);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "updateAccessIDs: " + this.appName);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "updateAccessIDs: " + this.appName);
    }

    private void updateID(List l, ObjectName mBean, boolean isUser, boolean all) throws Exception {
        for (int i = 0; i < l.size(); ++i) {
            Subject sub = (Subject)l.get(i);
            if (!all && sub.getAccessId() != null) continue;
            String id = (String)AdminServiceFactory.getAdminService().invoke(mBean, "getAccessIds", new Object[]{new Boolean(isUser), sub.getName(), null}, new String[]{Boolean.TYPE.getName(), String.class.getName(), Properties.class.getName()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name: " + sub.getName() + " --> id: " + id);
            }
            if (id == null) continue;
            sub.setAccessId(id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteUserAndGroupEntries() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteUserAndGroupEntries");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deleteUserAndGroupEntries", "appName=" + this.appName);
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile earFile = null;
        boolean sync2 = true;
        try {
            try {
                workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
                if (rc == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                ApplicationDeployment depl = ConfigRepoHelper.getAppDeploymentForApp(rc);
                if (!ConfigRepoHelper.isEditAllowed(depl)) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0173E", new Object[]{this.appName, "deleteUserAndGroupEntries"}));
                }
                boolean bUse = depl.isUseMetadataFromBinaries();
                earFile = bUse ? ConfigRepoHelper.getEarFileFromBinaries(rc, workSpace, this.resBundle, (String)this.appM.getGlobalSettings().get("Config Root for variable map")) : ConfigRepoHelper.getEarFileFromDeployment(workSpace, rc);
                boolean modified = false;
                ApplicationBinding applicationBinding = earFile.getBindings();
                AuthorizationTable authorizationTable = applicationBinding.getAuthorizationTable();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleteUserAndGroupEntries", "authorizationTable=" + authorizationTable);
                }
                if (authorizationTable != null) {
                    EList authorizations = authorizationTable.getAuthorizations();
                    for (RoleAssignment roleAssignment : authorizations) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "deleteUserAndGroupEntries", "roleAssignment=" + roleAssignment);
                        }
                        EList users = roleAssignment.getUsers();
                        users.clear();
                        EList groups = roleAssignment.getGroups();
                        groups.clear();
                        EList specialSubjects = roleAssignment.getSpecialSubjects();
                        specialSubjects.clear();
                        modified = true;
                    }
                }
                RunAsMap runAsMap = applicationBinding.getRunAsMap();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleteUserAndGroupEntries", "runAsMap=" + runAsMap);
                }
                if (runAsMap != null) {
                    EList runAsBindings = runAsMap.getRunAsBindings();
                    for (RunAsBinding runAsBinding : runAsBindings) {
                        AbstractAuthData abstractAuthData;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "deleteUserAndGroupEntries", "runAsBinding=" + runAsBinding);
                        }
                        if ((abstractAuthData = runAsBinding.getAuthData()) instanceof BasicAuthData) {
                            BasicAuthData basicAuthData = (BasicAuthData)abstractAuthData;
                            basicAuthData.setUserId(null);
                            basicAuthData.setPassword(null);
                            modified = true;
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "deleteUserAndGroupEntries", "abstractAuthData=" + abstractAuthData + (abstractAuthData != null ? " (class=" + abstractAuthData.getClass().getName() + ")" : ""));
                    }
                }
                if (modified) {
                    Resource resource = applicationBinding.eResource();
                    resource.setModified(true);
                }
                if (bUse) {
                    earFile.save();
                }
                SetApplicationInfoTask.saveEarFileToDeployment(earFile, rc);
            }
            catch (Throwable t) {
                RasUtils.logException(t, tc, CLASS_NAME, "deleteUserAndGroupEntries", "1163", this);
                sync2 = false;
                if (!(t instanceof AdminException)) throw new AdminException(t, "");
                throw (AdminException)t;
            }
            Object var17_17 = null;
            this.doFinally(workSpace, earFile, sync2);
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            this.doFinally(workSpace, earFile, sync2);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "deleteUserAndGroupEntries");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "deleteUserAndGroupEntries");
    }

    public static ConfigService getLocalConfigService() {
        if (ConfigServiceFactory.getConfigService() != null) {
            return ConfigServiceFactory.getConfigService();
        }
        Properties prop = new Properties();
        prop.setProperty("location", "local");
        try {
            return ConfigServiceFactory.createConfigService(true, prop);
        }
        catch (AdminException ex) {
            RasUtils.logException(ex, tc, CLASS_NAME, "getLocalConfigService", "1187");
            return null;
        }
    }

    public byte[] getApplicationContents(String arg_uri) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationContents: " + arg_uri);
        }
        if (arg_uri == null) {
            return null;
        }
        String uri = arg_uri.replace('\\', '/');
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace ws = null;
        byte[] fileContents = null;
        try {
            ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, ws, this.prefs);
            if (rc == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
            fileContents = ConfigRepoHelper.isMetadataComplete(appDepl) || !uri.matches(ee5DeplymentDescriptorsURI) ? this.getApplicationContentsForMetadataComplete(uri, appDepl, rc, ws) : this.getApplicationContentsForMetadataIncomplete(uri, appDepl, rc, ws);
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "getApplicationContents", "1231", this);
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, "");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationContents", new Object[]{fileContents});
        }
        return fileContents;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getApplicationContentsForMetadataComplete(String uri, ApplicationDeployment appDepl, RepositoryContext rc, WorkSpace ws) throws AdminException {
        void var6_9;
        byte[] byArray;
        EARFile earFile;
        block18: {
            byte[] byArray2;
            InputStream inputStream;
            block17: {
                byte[] byArray3;
                FileInputStream fileInputStream;
                block16: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "getApplicationContentsForMetadataComplete", new Object[]{uri, appDepl, rc});
                    }
                    earFile = null;
                    InputStream inputStream2 = null;
                    try {
                        try {
                            Object[] c_o;
                            if (rc.isAvailable(uri)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Metadata uri: " + uri);
                                }
                                boolean use = appDepl.isUseMetadataFromBinaries();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "useMetadataFromBinaries = " + use);
                                }
                                if (!use) {
                                    rc.extract(uri, false);
                                    fileInputStream = new FileInputStream(rc.getPath() + "/" + uri);
                                    byArray3 = AppUtils.getFileContents(fileInputStream);
                                    Object var10_16 = null;
                                    break block16;
                                }
                            }
                            earFile = ConfigRepoHelper.getEarFileFromBinaries(rc, ws, this.resBundle, true);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "ear from bin: " + earFile);
                            }
                            if (((Container)(c_o = AppUtils.getContainerAndOffset(earFile, uri))[0]).containsFile((String)c_o[1])) {
                                inputStream = ((Container)c_o[0]).getInputStream((String)c_o[1]);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "input stream from ear: " + inputStream);
                                }
                                if (inputStream != null) {
                                    byArray2 = AppUtils.getFileContents(inputStream);
                                    break block17;
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, uri + " does not exist in ear");
                            }
                            byArray = null;
                            break block18;
                        }
                        catch (Throwable th) {
                            RasUtils.logException(th, tc, CLASS_NAME, "getApplicationContentsForMetadataComplete", "1283", this);
                            if (!(th instanceof AdminException)) throw new AdminException(th, "");
                            throw (AdminException)th;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_19 = null;
                        AppUtils.closeInputStream(inputStream2);
                        this.doFinally(ws, earFile, false);
                        if (!tc.isEntryEnabled()) throw throwable;
                        Tr.exit(tc, "getApplicationContentsForMetadataComplete: " + uri);
                        throw throwable;
                    }
                }
                AppUtils.closeInputStream(fileInputStream);
                this.doFinally(ws, earFile, false);
                if (!tc.isEntryEnabled()) return byArray3;
                Tr.exit(tc, "getApplicationContentsForMetadataComplete: " + uri);
                return byArray3;
            }
            Object var10_17 = null;
            AppUtils.closeInputStream(inputStream);
            this.doFinally(ws, earFile, false);
            if (!tc.isEntryEnabled()) return byArray2;
            Tr.exit(tc, "getApplicationContentsForMetadataComplete: " + uri);
            return byArray2;
        }
        Object var10_18 = null;
        AppUtils.closeInputStream((InputStream)var6_9);
        this.doFinally(ws, earFile, false);
        if (!tc.isEntryEnabled()) return byArray;
        Tr.exit(tc, "getApplicationContentsForMetadataComplete: " + uri);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getApplicationContentsForMetadataIncomplete(String uri, ApplicationDeployment appDepl, RepositoryContext rc, WorkSpace ws) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationContentsForMetadataIncomplete", new Object[]{uri, appDepl, rc});
        }
        EARFile earFile = null;
        java.io.File ddFile = null;
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        byte[] bytes = null;
        try {
            try {
                earFile = ConfigRepoHelper.getEarFileForApp(ws, rc, this.resBundle, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear from app: " + earFile);
                }
                Resource ddResource = null;
                if (APP_XML_DD.equals(uri)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "app DD");
                    }
                    ddResource = earFile.getDeploymentDescriptor().eResource();
                } else {
                    Object[] containerAndOffset = AppUtils.getContainerAndOffset(earFile, uri);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "container: " + containerAndOffset[0]);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "offset: " + containerAndOffset[1]);
                    }
                    if (JAR_XML_DD.equals(containerAndOffset[1]) || WEB_XML_DD.equals(containerAndOffset[1])) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "module DD");
                        }
                        if (containerAndOffset[0] instanceof EJBJarFile) {
                            ddResource = ((EJBJarFile)containerAndOffset[0]).getDeploymentDescriptor().eResource();
                        } else if (containerAndOffset[0] instanceof WARFile) {
                            ddResource = ((WARFile)containerAndOffset[0]).getDeploymentDescriptor().eResource();
                        }
                    }
                }
                if (ddResource != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "saving DD in a temp file");
                    }
                    ddFile = java.io.File.createTempFile("tempDD", "xml");
                    outputStream = new FileOutputStream(ddFile.getCanonicalPath());
                    ddResource.save(outputStream, new HashMap());
                    outputStream.flush();
                    inputStream = new FileInputStream(ddFile.getCanonicalPath());
                    bytes = AppUtils.getFileContents(inputStream);
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "getApplicationContentsForMetadataIncomplete", "1345", this);
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, "");
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            AppUtils.closeInputStream(inputStream);
            AppUtils.closeOutputStream(outputStream);
            if (ddFile != null && ddFile.exists()) {
                ddFile.delete();
            }
            this.doFinally(ws, earFile, false);
            throw throwable;
        }
        AppUtils.closeInputStream(inputStream);
        AppUtils.closeOutputStream(outputStream);
        if (ddFile != null && ddFile.exists()) {
            ddFile.delete();
        }
        this.doFinally(ws, earFile, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationContentsForMetadataIncomplete: " + bytes);
        }
        return bytes;
    }

    public EditionInfo[] getEditionInfo(String edition) throws AdminException {
        EditionInfo[] editionInfoArray;
        ArrayList<RepositoryContext> apps;
        WorkSpace ws;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEditionInfo: " + this.appName + ", " + edition);
            }
            if (this.appName == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
            }
            ws = null;
            ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            apps = new ArrayList<RepositoryContext>();
            String cName = (String)this.prefs.get("cell.name");
            Object[] cells = null;
            if (cName == null) {
                cells = AppUtils.getContextArray("cells", null, ws);
            } else {
                RepositoryContext rc = AppUtils.findContext("cells", cName, null, null, ws, false);
                cells = new RepositoryContext[]{rc};
            }
            for (int lcv = 0; lcv < cells.length; ++lcv) {
                if (!"*".equals(edition)) {
                    String compName = EditionHelper.getCompositeName(this.appName, edition);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "comp name: " + compName);
                    }
                    RepositoryContext rc = AppUtils.findAppContextFromConfig(compName, ws, this.prefs);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "rc = " + rc);
                    }
                    if (rc == null) continue;
                    apps.add(rc);
                    continue;
                }
                String aName = EditionHelper.getAppAndEdition(this.appName)[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "app name is: " + aName);
                }
                if (aName == null) break;
                Object[] ar = AppUtils.getContextArray("deployments", (RepositoryContext)cells[lcv], ws);
                if (ar == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "ar is null for " + cells[lcv]);
                    continue;
                }
                for (int i = 0; i < ar.length; ++i) {
                    RepositoryContext ac = (RepositoryContext)ar[i];
                    if (!EditionHelper.getAppAndEdition(ac.getName())[0].equals(aName)) continue;
                    apps.add(ac);
                }
            }
            if (apps.size() != 0) break block21;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no editions for this name");
            }
            EditionInfo[] lcv = new EditionInfo[]{};
            Object var12_19 = null;
            this.doFinally(ws, null, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getEditionInfo: " + this.appName);
            }
            return lcv;
        }
        try {
            Properties eProps = AppUtils.getEditionProps((RepositoryContext)apps.get(0));
            EditionInfo[] array = new EditionInfo[apps.size()];
            for (int i = 0; i < apps.size(); ++i) {
                RepositoryContext app = (RepositoryContext)apps.get(i);
                array[i] = new EditionInfo(app.getName(), app.getParent().getParent().getName());
                this.props2Info(array[i], app, eProps);
            }
            editionInfoArray = array;
            Object var12_20 = null;
            this.doFinally(ws, null, false);
        }
        catch (Throwable th) {
            try {
                RasUtils.logException(th, tc, CLASS_NAME, "getEditionInfo", "1447", this);
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, "");
            }
            catch (Throwable throwable) {
                block22: {
                    Object var12_21 = null;
                    this.doFinally(ws, null, false);
                    if (!tc.isEntryEnabled()) break block22;
                    Tr.exit(tc, "getEditionInfo: " + this.appName);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEditionInfo: " + this.appName);
        }
        return editionInfoArray;
    }

    private void props2Info(EditionInfo info, RepositoryContext appC, Properties eProps) {
        info.setDescription(eProps.getProperty(EditionHelper.getEditionDescPropName(appC.getName()), ""));
        String stateVal = eProps.getProperty(EditionHelper.getEditionStatePropName(appC.getName()), "");
        if (stateVal != null && stateVal.length() > 0) {
            info.setEditionState(stateVal);
        } else if (eProps.isEmpty() && info.getEdition().equals("")) {
            info.setEditionState("ACTIVE");
        } else {
            info.setEditionState("INACTIVE");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEditionInfo(EditionInfo[] info) throws AdminException {
        boolean bEx;
        WorkSpace ws;
        block11: {
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setEditionInfo");
                }
                ws = null;
                bEx = false;
                try {
                    try {
                        ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                        if (info == null) {
                            Object var9_4 = null;
                            this.doFinally(ws, null, !bEx);
                            break block10;
                        }
                        for (int i = 0; i < info.length; ++i) {
                            RepositoryContext cellC = AppUtils.findContext("cells", info[i].getCellName(), null, null, ws, false);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cellc " + cellC);
                            }
                            if (cellC == null) continue;
                            this.prefs.put("cell.name", cellC.getName());
                            RepositoryContext appC = AppUtils.findAppContextFromConfig(EditionHelper.getCompositeName(info[i].getAppName(), info[i].getEdition()), ws, this.prefs);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "appC = " + appC);
                            }
                            if (appC == null) continue;
                            Properties eProps = AppUtils.getEditionProps(appC);
                            this.info2Props(info[i], eProps, appC);
                            AppUtils.setEditionProps(appC, eProps);
                        }
                        break block11;
                    }
                    catch (Throwable th) {
                        RasUtils.logException(th, tc, CLASS_NAME, "setEditionInfo", "1513", this);
                        bEx = true;
                        if (!(th instanceof AdminException)) throw new AdminException(th, "");
                        throw (AdminException)th;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    this.doFinally(ws, null, !bEx);
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit(tc, "setEditionInfo: " + this.appName);
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "setEditionInfo: " + this.appName);
            return;
        }
        Object var9_5 = null;
        this.doFinally(ws, null, !bEx);
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "setEditionInfo: " + this.appName);
    }

    private void info2Props(EditionInfo info, Properties props, RepositoryContext appC) {
        String desc = info.getDescription();
        props.setProperty(EditionHelper.getEditionDescPropName(appC.getName()), desc == null ? "" : desc);
        props.setProperty(EditionHelper.getEditionStatePropName(appC.getName()), info.getEditionState());
    }

    public String[] getAppAssociation(String scope, String retVal) throws AdminException {
        String[] cName2;
        WorkSpace ws;
        block25: {
            block23: {
                Vector v;
                block24: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "getAppAssociation");
                    }
                    ws = null;
                    boolean bEx = false;
                    ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                    if (!"server.name".equals(retVal) && !"node.name".equals(retVal)) break block23;
                    this.appName = scope;
                    RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, ws, this.prefs);
                    if (rc == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                    }
                    RepositoryContext cellC = rc.getParent().getParent();
                    ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
                    v = ConfigRepoHelper.getServersForAppDeployment(appDepl, null, cellC, ws, false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "All targets: " + v);
                    }
                    v = ConfigRepoHelper.getAllServers(ws, v);
                    if (!"server.name".equals(retVal)) break block24;
                    String[] ar = new String[v.size()];
                    for (int i = 0; i < v.size(); ++i) {
                        ar[i] = ConfigRepoHelper.getTargetString((RepositoryContext)v.elementAt(i), (String)null);
                    }
                    String[] i = ar;
                    Object var14_23 = null;
                    this.doFinally(ws, null, false);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getAppAssociation: " + this.appName);
                    }
                    return i;
                }
                Vector<String> l = new Vector<String>();
                for (int i = 0; i < v.size(); ++i) {
                    String t = ConfigRepoHelper.getTargetString((RepositoryContext)v.elementAt(i), (String)null);
                    ObjectName on = new ObjectName(t);
                    t = "WebSphere:cell=" + on.getKeyProperty("cell") + ",node=" + on.getKeyProperty("node");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying to add: " + t);
                    }
                    if (l.contains(t)) continue;
                    l.add(t);
                }
                Object[] ar = new String[l.size()];
                l.copyInto(ar);
                Object[] objectArray = ar;
                Object var14_24 = null;
                this.doFinally(ws, null, false);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getAppAssociation: " + this.appName);
                }
                return objectArray;
            }
            if (!"cell.name".equals(retVal)) break block25;
            this.appName = scope;
            String cName2 = (String)this.prefs.get("cell.name");
            Object[] cells = null;
            if (cName2 == null) {
                cells = AppUtils.getContextArray("cells", null, ws);
            } else {
                RepositoryContext rc = AppUtils.findContext("cells", cName2, null, null, ws, false);
                cells = new RepositoryContext[]{rc};
            }
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < cells.length; ++i) {
                RepositoryContext app = AppUtils.findContext("deployments", this.appName, null, (RepositoryContext)cells[i], ws, true);
                if (app == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Tring to add cell: " + app.getParent().getName());
                }
                v.add("WebSphere:cell=" + app.getParent().getName());
            }
            Object[] ar = new String[v.size()];
            v.copyInto(ar);
            Object[] objectArray = ar;
            Object var14_25 = null;
            this.doFinally(ws, null, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppAssociation: " + this.appName);
            }
            return objectArray;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nothing to process .. returning empty array");
            }
            cName2 = new String[]{};
            Object var14_26 = null;
            this.doFinally(ws, null, false);
        }
        catch (Throwable th) {
            try {
                RasUtils.logException(th, tc, CLASS_NAME, "getAppAssociation", "1625", this);
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, "");
            }
            catch (Throwable throwable) {
                block26: {
                    Object var14_27 = null;
                    this.doFinally(ws, null, false);
                    if (!tc.isEntryEnabled()) break block26;
                    Tr.exit(tc, "getAppAssociation: " + this.appName);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppAssociation: " + this.appName);
        }
        return cName2;
    }

    public static Vector listApplications(String targetScope, Hashtable props, String sessionID) throws AdminException {
        return EditApplication.listApplications(targetScope, props, sessionID, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector listApplications(String targetScope, Hashtable props, String sessionID, boolean bShowHidden) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listApplications: targetScope:" + targetScope + " props: " + props + "  sessionID: " + sessionID + " bShowHidden:  " + bShowHidden);
        }
        ResourceBundle resBundle = AppUtils.getBundle(props);
        String cellName = null;
        String nodeName = null;
        String serverName = null;
        String clusterName = null;
        ObjectName on = null;
        WorkSpace ws = null;
        Vector<String> v = new Vector<String>();
        if (props == null) {
            props = new Hashtable();
        }
        try {
            try {
                RepositoryContext cellC;
                boolean perm;
                block28: {
                    ws = ConfigRepoHelper.getWorkSpace(sessionID);
                    if (targetScope != null) {
                        try {
                            on = new ObjectName(targetScope);
                            cellName = on.getKeyProperty("cell");
                            nodeName = on.getKeyProperty("node");
                            serverName = on.getKeyProperty("server");
                            clusterName = on.getKeyProperty("cluster");
                            if (cellName == null) {
                                throw new MalformedObjectNameException("listApplications - null cell name");
                            }
                            if (serverName != null && nodeName == null) {
                                throw new MalformedObjectNameException("listApplications - null node name for server");
                            }
                            if (serverName != null && clusterName != null) {
                                throw new MalformedObjectNameException("listApplications - can only have server or cluster");
                            }
                            break block28;
                        }
                        catch (MalformedObjectNameException mex) {
                            RasUtils.logException(mex, tc, CLASS_NAME, "listApplications", "1684");
                            Tr.error(tc, "ADMA0160E", targetScope);
                            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0160E", new Object[]{targetScope}));
                        }
                    }
                    cellName = (String)props.get("cell.name");
                    if (cellName == null) {
                        Object[] cells = AppUtils.getContextArray("cells", null, ws);
                        cellName = ((RepositoryContext)cells[0]).getName();
                    }
                }
                if (!(perm = AppUtils.checkCellLevelAdminAccess(cellName))) {
                    String uri = "cells/" + cellName;
                    if (nodeName != null) {
                        uri = uri + "/nodes/" + nodeName;
                        if (serverName != null) {
                            uri = uri + "/servers/" + serverName;
                        }
                    } else {
                        uri = uri + "/clusters/" + clusterName;
                    }
                    if (!(perm = AppUtils.checkAdminAccess("monitor", uri))) {
                        throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "deployer"}));
                    }
                }
                if ((cellC = AppUtils.findContext("cells", cellName, null, null, ws, true)) == null) {
                    throw new AdminException(AppUtils.getMessage(resBundle, "ADMA5047E", new Object[]{cellName}));
                }
                if (nodeName != null) {
                    EditApplication.listAppsOnNode(v, nodeName, serverName, cellC, ws, resBundle, bShowHidden);
                } else if (clusterName != null) {
                    RepositoryContext clusterCtx = AppUtils.findContext("clusters", clusterName, null, cellC, ws, false);
                    if (clusterCtx == null) {
                        throw new AdminException(AppUtils.getMessage(resBundle, "ADMA5027E", new String[]{clusterName}));
                    }
                    URI uri = URI.createURI("cluster.xml");
                    Resource res = clusterCtx.getResourceSet().getResource(uri, true);
                    ServerCluster top = (ServerCluster)res.getContents().get(0);
                    EList members = top.getMembers();
                    if (members.size() > 0) {
                        ClusterMember member = (ClusterMember)members.get(0);
                        String nName = member.getNodeName();
                        String memberName = member.getMemberName();
                        EditApplication.listAppsOnNode(v, nName, memberName, cellC, ws, resBundle, bShowHidden);
                    }
                } else {
                    Object[] ar = AppUtils.getContextArray("deployments", cellC, ws);
                    if (ar != null) {
                        for (int i = 0; i < ar.length; ++i) {
                            if (!bShowHidden && ((RepositoryContext)ar[i]).isAvailable("META-INF/ibm-application-ha.props")) continue;
                            v.addElement(((RepositoryContext)ar[i]).getName());
                        }
                    }
                }
                Object var23_27 = null;
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "listApplications", "1763");
                if (!(th instanceof AdminException)) throw new AdminException(th, "");
                throw (AdminException)th;
            }
        }
        catch (Throwable throwable) {
            Object var23_28 = null;
            EditApplication.doFinally(ws, sessionID, null, false);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "listApplications");
            throw throwable;
        }
        EditApplication.doFinally(ws, sessionID, null, false);
        if (!tc.isEntryEnabled()) return v;
        Tr.exit(tc, "listApplications");
        return v;
    }

    public static void listAppsOnNode(Vector v, String nodeName, String serverName, RepositoryContext cellC, WorkSpace ws, ResourceBundle resBundle, boolean showHidden) throws Exception {
        RepositoryContext nodeCtx;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAppsOnNode: " + nodeName + " serverName =: " + serverName);
        }
        if ((nodeCtx = AppUtils.findContext("nodes", nodeName, null, cellC, ws, false)) == null) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA5040E", new String[]{nodeName}));
        }
        URI uri = URI.createURI("serverindex.xml");
        Resource res = nodeCtx.getResourceSet().getResource(uri, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found for node " + nodeCtx + " SI doc res: " + res);
        }
        ServerIndex top = (ServerIndex)res.getContents().get(0);
        EList entries = top.getServerEntries();
        boolean foundServer = false;
        for (int i = 0; i < entries.size(); ++i) {
            ServerEntry entry = (ServerEntry)entries.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server name =" + entry.getServerName());
            }
            if (serverName != null && !entry.getServerName().equals(serverName)) continue;
            foundServer = true;
            EList apps = entry.getDeployedApplications();
            for (int k = 0; k < apps.size(); ++k) {
                String deploymentName = (String)apps.get(k);
                String appName = deploymentName.substring(deploymentName.lastIndexOf("/") + 1);
                RepositoryContext appCtx = AppUtils.findAppContextFromConfig(appName, ws, null);
                if (!showHidden && appCtx.isAvailable("META-INF/ibm-application-ha.props") || v.contains(appCtx.getName())) continue;
                v.addElement(appCtx.getName());
            }
        }
        if (!foundServer && serverName != null) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0184E", new Object[]{serverName}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAppsOnNode returns: " + v);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/EditApplication.java, WAS.admin.appmgmt, WAS70.SERV1, cf050925.09, ver. 1.104.1.12");
        }
        CLASS_NAME = EditApplication.class.getName();
        appFactory = null;
        appCfgFactory = null;
    }
}

