/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import com.ibm.ws.management.util.RasUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMImplementation;

public class DeltaFile
extends XMLDocument {
    private static TraceComponent tc = Tr.register(DeltaFile.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    public static final String ROOTELEMENT = "app-delta";
    public static final String FILES = "files";
    public static final String FILE = "file";
    public static final String URI = "uri";
    public static final String UPDATE_INPUT = "change_input";
    private String _rootPath;
    private String fileName = null;

    public DeltaFile() throws Exception {
        this.xmlDoc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setValidating(false);
            DocumentBuilder dataDocBuilder = docBuilderFactory.newDocumentBuilder();
            this.xmlDoc = dataDocBuilder.newDocument();
            DOMImplementation domImpl = this.xmlDoc.getImplementation();
            this.xmlDoc = domImpl.createDocument(null, ROOTELEMENT, null);
            this.fileName = "delta-" + System.currentTimeMillis();
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "<init>", "79", (Object)this);
            this.xmlDoc = null;
            throw e;
        }
        AppUtils.dbg(tc, "xmlDoc: " + this.xmlDoc);
        AppUtils.dbg(tc, "root element: " + this.xmlDoc.getDocumentElement());
    }

    public DeltaFile(String rootPath) throws Exception {
        this();
        this._rootPath = rootPath;
    }

    public DeltaFile(InputStream i) throws Exception {
        super(i);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void writeToDisk() throws Exception {
        String filename = this._rootPath + "/" + this.fileName;
        AppUtils.dbg(tc, "****** delta file name: " + filename);
        File file = new File(filename);
        file.getParentFile().mkdirs();
        FileOutputStream outStream = new FileOutputStream(file);
        this.sendToStream(outStream);
        if (outStream != null) {
            outStream.flush();
            outStream.close();
        }
    }

    public void sendToStream(OutputStream stream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendToStream");
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));
        this.sendToWriter(out);
        ((Writer)out).flush();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendToStream");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/DeltaFile.java, WAS.admin.appmgmt, WAS70.SERV1, cf050925.09, ver. 1.6");
        }
        CLASS_NAME = DeltaFile.class.getName();
    }
}

