/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.AppManagementBaseFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.classloader.ClassloaderFactory;
import com.ibm.websphere.models.config.classloader.ClassloaderPackage;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.registrar.registrar;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.Fence;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.MapModulesToServersHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.transform.RepositoryAdapter;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppUtils {
    private static TraceComponent tc = Tr.register(AppUtils.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String systemAppsFileName = "systemapps.xml";
    private static ClassloaderFactory classloaderFactory;
    private static Boolean _entitled;
    private static PublicKey _entitledKey;
    private static String productName;
    public static final String MARKER_FILE_DELETE_ACTION = "delete.merker.file";
    public static final String MARKER_FILE_CREATE_ACTION = "create.merker.file";

    public static synchronized boolean isEntitled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEntitled");
        }
        boolean entitled = true;
        if (_entitled == null) {
            try {
                String key = new String("GjSl6k4j76jW6j3FsGNhNsrjY3p762eM");
                boolean fenceActive = false;
                try {
                    key = Fence.getKey();
                    fenceActive = true;
                }
                catch (NoClassDefFoundError ncd) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Server entitlement class not found", new Boolean(fenceActive));
                    }
                }
                catch (Throwable t) {
                    Tr.event(tc, "Server entitlement class not found", t);
                }
                InputStream keyStream = AppUtils.class.getClassLoader().getResourceAsStream("jarsign/zruntime_keystore");
                if (keyStream == null) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Server entitlement keystore not found");
                    }
                } else {
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(keyStream, key.toCharArray());
                    Certificate cert = ks.getCertificate("zruntime");
                    if (cert == null) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Server entitlement keystore is incomplete");
                        }
                    } else {
                        _entitledKey = cert.getPublicKey();
                    }
                }
                if (_entitledKey != null && fenceActive) {
                    entitled = false;
                }
                _entitled = new Boolean(entitled);
            }
            catch (Throwable t) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Server entitlement check failed", t);
                }
                _entitled = new Boolean(true);
            }
        } else {
            entitled = _entitled;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEntitled", new Boolean(entitled));
        }
        return entitled;
    }

    public static boolean isAppEntitled(String earPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAppEntitled", earPath);
        }
        boolean entitled = true;
        if (_entitledKey != null) {
            try {
                JarFile jar = new JarFile(earPath, true);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements() && entitled) {
                    JarEntry je = e.nextElement();
                    String jeName = je.getName();
                    InputStream is = jar.getInputStream(je);
                    while (is.read() != -1) {
                    }
                    Certificate[] c = je.getCertificates();
                    boolean foundCert = false;
                    if (c != null && c.length > 0) {
                        for (int i = 0; i < c.length; ++i) {
                            try {
                                c[i].verify(_entitledKey);
                                foundCert = true;
                                continue;
                            }
                            catch (Throwable t) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Exception verifying certificate signature for file " + jeName + " in application " + earPath + ", this may not be fatal", t);
                            }
                        }
                    }
                    if (foundCert || !jeName.endsWith(".class") && !jeName.endsWith(".jar") && !jeName.endsWith(".ear") && !jeName.endsWith(".war")) continue;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Application " + earPath + " failed certificate " + "verification on file " + jeName);
                    }
                    entitled = false;
                }
            }
            catch (Throwable t) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Error during app entitlement verification", t);
                }
                entitled = false;
            }
        } else {
            entitled = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAppEntitled", new Boolean(entitled));
        }
        return entitled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signEntitledApplication(String earPath) throws Exception {
        block12: {
            boolean entitled;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "signEntitledApplication", earPath);
            }
            if (entitled = AppUtils.isEntitled()) {
                String key = new String("GjSl6k4j76jW6j3FsGNhNsrjY3p762eM");
                InputStream keyStream = AppUtils.class.getClassLoader().getResourceAsStream("jarsign/zruntime_keystore");
                if (keyStream == null) {
                    throw new Exception("Server entitlement keystore not found");
                }
                java.io.File tempKeystoreFile = null;
                try {
                    java.io.File tempDir = new java.io.File(AppUtils.getTempDir());
                    tempDir.mkdirs();
                    tempDir.deleteOnExit();
                    tempKeystoreFile = java.io.File.createTempFile("zrun_keystore", null, tempDir);
                    tempKeystoreFile.deleteOnExit();
                    FileOutputStream fos = new FileOutputStream(tempKeystoreFile);
                    byte[] buffer = new byte[16];
                    int bytesRead = keyStream.read(buffer);
                    while (bytesRead > 0) {
                        fos.write(buffer, 0, bytesRead);
                        bytesRead = keyStream.read(buffer);
                    }
                    fos.close();
                    String javaHome = System.getProperty("java.home");
                    if (javaHome == null) {
                        throw new Exception("Could not find java.home property");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Using Java home", javaHome);
                    }
                    String command = new String(javaHome + java.io.File.separator + "bin" + java.io.File.separator + "jarsigner -keystore " + tempKeystoreFile.getPath() + " -storepass " + key + " " + earPath + " " + "zruntime");
                    Runtime r = Runtime.getRuntime();
                    Process jarSigner = r.exec(command);
                    int rc = jarSigner.waitFor();
                    InputStream out = jarSigner.getInputStream();
                    InputStream err = jarSigner.getErrorStream();
                    int outBytes = out.available();
                    if (outBytes > 0) {
                        byte[] bytes = new byte[outBytes];
                        out.read(bytes);
                        throw new Exception("Error signing application: " + earPath + ". " + new String(bytes));
                    }
                    int errBytes = err.available();
                    if (errBytes > 0) {
                        byte[] bytes = new byte[errBytes];
                        out.read(bytes);
                        throw new Exception("Error signing application: " + earPath + ". " + new String(bytes));
                    }
                    Object var20_20 = null;
                    if (tempKeystoreFile == null) break block12;
                    tempKeystoreFile.delete();
                }
                catch (Throwable throwable) {
                    Object var20_21 = null;
                    if (tempKeystoreFile != null) {
                        tempKeystoreFile.delete();
                    }
                    throw throwable;
                }
                {
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signEntitledApplication");
        }
    }

    public static void printEntitleServerMessage() {
        Tr.info(tc, "ADMA9007I", AppUtils.getProductName());
    }

    public static String getProductName() {
        if (productName.equals("")) {
            registrar baseReg = null;
            WASProduct prod = new WASProduct();
            Iterator regs = prod.getRegistrars();
            if (regs.hasNext() && (baseReg = (registrar)regs.next()).getId().equals("BASE")) {
                productName = baseReg.getProductName();
            }
        }
        return productName;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void printEx(Throwable ex) {
        AppUtils.printEx(ex, true);
    }

    public static boolean validateMultiDomain(Hashtable<String, String> data) throws Throwable {
        String exp;
        boolean result = false;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validateMultiDomain()", data);
        }
        if ((exp = data.get("expected")).equals(Throwable.class.getName())) {
            throw new Throwable("ERROR in validation!!!!!");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validateMultiDomain()", result);
        }
        return new Boolean(exp);
    }

    private static ClassloaderFactory getClassloaderFactory() {
        if (classloaderFactory == null) {
            ClassloaderPackage clsPkg = (ClassloaderPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/classloader.xmi");
            classloaderFactory = clsPkg.getClassloaderFactory();
        }
        return classloaderFactory;
    }

    public static void printEx(Throwable ex, boolean showEx) {
        if (ex instanceof AdminException && ((AdminException)ex).getCause() != null) {
            AppUtils.printEx(((AdminException)ex).getCause(), showEx);
        } else if (ex instanceof MBeanException && ((MBeanException)ex).getTargetException() != null) {
            AppUtils.printEx(((MBeanException)ex).getTargetException(), showEx);
        } else if (ex instanceof AppDeploymentException && ((AppDeploymentException)ex).getEmbeddedEx() != null) {
            AppUtils.printEx(((AppDeploymentException)ex).getEmbeddedEx(), showEx);
        } else {
            AppUtils.dbg(tc, "Exception: " + ex);
            if (showEx) {
                ex.printStackTrace();
            }
        }
    }

    public static ResourceBundle getBundle(String bName, Locale loc) {
        Locale locale = loc;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(bName, locale);
        }
        catch (MissingResourceException e) {
            RasUtils.logException(e, tc, CLASS_NAME, "getBundle", "574");
            AppUtils.dbg(tc, "Error loading class: " + bName + ", locale " + locale + ", " + e);
            return null;
        }
    }

    public static ResourceBundle getBundle(Hashtable prefs) {
        Locale locale = null;
        if (prefs != null) {
            locale = (Locale)prefs.get("app.client.locale");
        }
        ResourceBundle resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", locale);
        return resBundle;
    }

    public static String getMessage(ResourceBundle bundle, String s) {
        if (bundle == null) {
            return s;
        }
        try {
            String ret = bundle.getString(s);
            if (ret == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Translation key not found: " + s);
                }
                return s;
            }
            return ret;
        }
        catch (MissingResourceException e) {
            RasUtils.logException(e, tc, CLASS_NAME, "getMessage", "608");
            return s;
        }
    }

    public static String getMessage(ResourceBundle b, String s, Object[] args) {
        String m = AppUtils.getMessage(b, s);
        if (args == null) {
            return m;
        }
        return MessageFormat.format(m, args);
    }

    public static void dbg(TraceComponent tc1, String s, Object o) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc1, s, o);
        }
    }

    public static void dbg(TraceComponent tc1, String s) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc1, s);
        }
    }

    public static String validateInstall(Scheduler scheduler) {
        return (String)scheduler.getProperties().get("validateinstall");
    }

    public static boolean isPreCompileJSPs(Scheduler scheduler) {
        return scheduler.getProperties().get("preCompileJSPs") != null && scheduler.getProperties().get("preCompileJSPs").equals(Boolean.TRUE);
    }

    public static boolean isDeployEJBs(Scheduler scheduler) {
        return scheduler.getProperties().get("deployejb") != null && scheduler.getProperties().get("deployejb").equals(Boolean.TRUE);
    }

    public static RepositoryContextType getContextType(String type) throws Exception {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType(type);
    }

    public static RepositoryContext getContextFromArray(Object[] a, String n, String parent, boolean returnFirstForNullParent) throws Exception {
        RepositoryContext firstMatch = null;
        for (int i = 0; i < a.length; ++i) {
            RepositoryContext rc = (RepositoryContext)a[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "aaa: " + rc.getName());
            }
            if (!rc.getName().equals(n)) continue;
            if (parent != null) {
                if (!rc.getParent().getName().equals(parent)) continue;
                return rc;
            }
            if (returnFirstForNullParent) {
                return rc;
            }
            if (firstMatch == null) {
                firstMatch = rc;
                continue;
            }
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5023E", new Object[]{firstMatch.getName(), firstMatch.getParent().getName(), rc.getParent().getName(), rc.getParent().getType().getName()}));
        }
        return firstMatch;
    }

    public static Object[] getContextArray(String type, RepositoryContext cellC, WorkSpace ws) throws Exception {
        if (type.equals("cells")) {
            return ws.findContext(AppUtils.getContextType("cells")).toArray();
        }
        return cellC.findContext(AppUtils.getContextType(type)).toArray();
    }

    public static RepositoryContext findContext(String type, String name, String parent, RepositoryContext cellC, WorkSpace ws, boolean returnFirstForNullParent) throws Exception {
        Object[] ar = AppUtils.getContextArray(type, cellC, ws);
        if (ar == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ar is null: type: " + type);
            }
            return null;
        }
        return AppUtils.getContextFromArray(ar, name, parent, returnFirstForNullParent);
    }

    public static Vector listSystemApps(Hashtable prefs, String wID) throws Exception {
        WorkSpace ws = ConfigRepoHelper.getWorkSpace(wID);
        Object[] cellContext = AppUtils.getContextArray("cells", null, ws);
        Vector v = new Vector();
        for (int iii = 0; iii < cellContext.length; ++iii) {
            WorkSpaceFile wsf;
            Object[] nodeContext = AppUtils.getContextArray("nodes", (RepositoryContext)cellContext[iii], ws);
            for (int kkk = 0; kkk < nodeContext.length && (wsf = ((RepositoryContext)nodeContext[kkk]).getFile(systemAppsFileName)) != null; ++kkk) {
                ((RepositoryContext)nodeContext[kkk]).extract(systemAppsFileName, false);
                Resource resource = ((RepositoryContext)nodeContext[kkk]).getResourceSet().createResource(URI.createURI(systemAppsFileName));
                resource.load(new HashMap());
                v.addAll(AppUtils.listSystemApps(resource));
            }
        }
        return v;
    }

    public static Vector listSystemApps(Resource res) {
        Vector<String> v = new Vector<String>();
        ServerIndex systemApps = (ServerIndex)res.getContents().get(0);
        EList list = systemApps.getServerEntries();
        for (int ii = 0; ii < list.size(); ++ii) {
            ServerEntry serverEntry = (ServerEntry)list.get(ii);
            EList deployedApps = serverEntry.getDeployedApplications();
            for (int k = 0; k < deployedApps.size(); ++k) {
                String deploymentName = (String)deployedApps.get(k);
                if (!deploymentName.endsWith(".ear")) continue;
                String deployedAppName = deploymentName.substring(deploymentName.lastIndexOf("/") + 1);
                deployedAppName = deployedAppName.substring(0, deployedAppName.lastIndexOf(".ear"));
                v.add(deployedAppName);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sys apps: " + v);
        }
        return v;
    }

    public static Vector listSystemApps(List sysAppCofigObj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSystemApps", sysAppCofigObj);
        }
        Vector<String> v = new Vector<String>();
        List list = ((ConfigObject)sysAppCofigObj.get(0)).getObjectList("serverEntries");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "systemapps.xml  entires : " + list);
        }
        for (int ii = 0; ii < list.size(); ++ii) {
            ConfigObject entry = (ConfigObject)list.get(ii);
            List deployedApps = entry.getStringList("deployedApplications");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deployedApplications list : " + deployedApps);
            }
            for (int k = 0; k < deployedApps.size(); ++k) {
                String deploymentName = (String)deployedApps.get(k);
                if (!deploymentName.endsWith(".ear")) continue;
                String deployedAppName = deploymentName.substring(deploymentName.lastIndexOf("/") + 1);
                deployedAppName = deployedAppName.substring(0, deployedAppName.lastIndexOf(".ear"));
                v.add(deployedAppName);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sys apps: " + v);
        }
        return v;
    }

    public static boolean isAnInstalledSystemApp(String appName, WorkSpace workSpace, Hashtable props, boolean doUninstallFlag) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAnInstalledSystemApp" + appName);
        }
        String cellName = props == null ? null : (String)props.get("cell.name");
        String nodeName = (String)props.get("node.name");
        String serverName = (String)props.get("server.name");
        if (!doUninstallFlag) {
            String earFile = (String)props.get("original.ear.location");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " ear file " + earFile);
            }
            if (earFile != null) {
                String systemApp = earFile.replace('\\', '/');
                String systemAppName = systemApp.substring(systemApp.lastIndexOf("/") + 1);
                if (systemAppName.endsWith(".ear")) {
                    systemAppName = systemAppName.substring(0, systemAppName.lastIndexOf(".ear"));
                }
                appName = systemAppName;
            }
        }
        RepositoryContext nodeContext = workSpace.findContext("cells/" + cellName + "/nodes/" + nodeName);
        WorkSpaceFile wsf = null;
        if (nodeName != null) {
            try {
                wsf = nodeContext.getFile(systemAppsFileName);
            }
            catch (Throwable t) {
                Tr.warning(tc, "ADMA0164W", new Object[]{cellName, nodeName});
                return false;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wsf = " + wsf);
        }
        if (wsf == null) {
            return false;
        }
        nodeContext.extract(systemAppsFileName, false);
        Resource resource = nodeContext.getResourceSet().createResource(URI.createURI(systemAppsFileName));
        resource.load(new HashMap());
        ServerIndex systemApps = (ServerIndex)resource.getContents().get(0);
        EList list = systemApps.getServerEntries();
        for (int i = 0; i < list.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)list.get(i);
            EList deployedApps = serverEntry.getDeployedApplications();
            for (int k = 0; k < deployedApps.size(); ++k) {
                String deploymentName = (String)deployedApps.get(k);
                if (!deploymentName.endsWith(".ear")) continue;
                String deployedAppName = deploymentName.substring(deploymentName.lastIndexOf("/") + 1);
                if (!(deployedAppName = deployedAppName.substring(0, deployedAppName.lastIndexOf(".ear"))).equals(appName)) continue;
                if (doUninstallFlag) {
                    serverEntry.getDeployedApplications().remove(k);
                    serverEntry.eResource().save(new HashMap());
                }
                if (!serverEntry.getServerName().equals(serverName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isAnInstalledSystemApp" + appName + ", " + cellName + ", " + serverName + ": true");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAnInstalledSystemApp" + appName + ", " + cellName);
        }
        return false;
    }

    public static boolean isAnInstalledSystemAppOnCluster(String appName, WorkSpace ws, Hashtable props) throws Exception {
        Hashtable allNodes;
        Hashtable indexDocs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAnInstalledSystemAppOnCluster");
        }
        String cellName = props == null ? null : (String)props.get("cell.name");
        String earFile = (String)props.get("original.ear.location");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " ear file " + earFile);
        }
        if (earFile != null) {
            String systemApp = earFile.replace('\\', '/');
            String systemAppName = systemApp.substring(systemApp.lastIndexOf("/") + 1);
            if (systemAppName.endsWith(".ear")) {
                systemAppName = systemAppName.substring(0, systemAppName.lastIndexOf(".ear"));
            }
            appName = systemAppName;
        }
        RepositoryContext cellC = ws.findContext("cells/" + cellName);
        Vector svrs = ConfigRepoHelper.getServerNames(AppUtils.getTargetStr(props), AppUtils.getTargetStr(props), false, cellC, ws);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAnInstalledSystemAppOnCluster: " + svrs);
        }
        if ((indexDocs = AppUtils.getSystemAppsXMLDocs(ws, (allNodes = ConfigRepoHelper.getNodeServerRelation(ws, svrs)).keys())) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server index docs not found!!");
            }
            return false;
        }
        Enumeration en = allNodes.keys();
        Hashtable retVal = new Hashtable();
        String lastNode = "";
        try {
            while (en.hasMoreElements()) {
                RepositoryContext nc = (RepositoryContext)en.nextElement();
                Vector sc = (Vector)allNodes.get(nc);
                Vector<String> servers = new Vector<String>();
                for (int i = 0; i < sc.size(); ++i) {
                    servers.addElement(((RepositoryContext)sc.elementAt(i)).getName());
                }
                Resource res = (Resource)indexDocs.get(nc);
                if (res == null || res.getContents().size() == 0) continue;
                ServerIndex top = (ServerIndex)res.getContents().get(0);
                ArrayList retS = new ArrayList();
                retVal.put(nc.getName(), retS);
                lastNode = nc.getName();
                EList entries = top.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "servers for " + nc.getName() + " are " + servers);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serversEntries for " + nc.getName() + " are " + entries);
                }
                for (int i = 0; i < entries.size(); ++i) {
                    ServerEntry entry = (ServerEntry)entries.get(i);
                    if (!servers.contains(entry.getServerName())) continue;
                    EList deployedApps = entry.getDeployedApplications();
                    for (int k = 0; k < deployedApps.size(); ++k) {
                        String deploymentName = (String)deployedApps.get(k);
                        String deploymentAppName = deploymentName.substring(deploymentName.lastIndexOf("/") + 1);
                        if (!appName.equals(deploymentAppName = deploymentAppName.substring(0, deploymentAppName.lastIndexOf(".ear")))) continue;
                        AppUtils.dbg(tc, "System Application found " + deploymentAppName + ", with binUrl = " + deploymentName);
                        return true;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isAnInstalledSystemAppOnCluster");
            }
            return false;
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "updateServerIndexDocs", "1032");
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, "Server Index update failed at  the last node of " + lastNode);
        }
    }

    private static Hashtable getSystemAppsXMLDocs(WorkSpace ws, Enumeration en) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemAppsXMLDocs");
        }
        Hashtable<RepositoryContext, Resource> retVal = new Hashtable<RepositoryContext, Resource>();
        while (en.hasMoreElements()) {
            RepositoryContext rCtx = (RepositoryContext)en.nextElement();
            URI uri = URI.createURI(systemAppsFileName);
            WorkSpaceFile wsf = rCtx.getFile(systemAppsFileName);
            if (wsf == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "No systemapps.xml on node " + rCtx.getName());
                continue;
            }
            rCtx.extract(systemAppsFileName, false);
            Resource res = rCtx.getResourceSet().createResource(uri);
            res.load(new HashMap());
            if (res != null) {
                retVal.put(rCtx, res);
                continue;
            }
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5031E", new Object[]{systemAppsFileName, rCtx}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "retVal: " + retVal);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemAppsXMLDocs");
        }
        return retVal;
    }

    public static String getTargetStr(Hashtable props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetStr", new Object[]{props});
        }
        String ret = null;
        if (props.get("cluster.name") != null) {
            String clusterName = (String)props.get("cluster.name");
            String cellName = (String)props.get("cell.name");
            ret = "WebSphere:cell=" + cellName + ",cluster=" + clusterName;
        } else if (props.get("cell.name") != null && props.get("node.name") != null && props.get("server.name") != null) {
            String cellName = (String)props.get("cell.name");
            String nodeName = (String)props.get("node.name");
            String serverName = (String)props.get("server.name");
            ret = "WebSphere:cell=" + cellName + ",node=" + nodeName + ",server=" + serverName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetStr - " + ret);
        }
        return ret;
    }

    public static RepositoryContext findAppContextFromConfig(String appName, WorkSpace ws, Hashtable props) throws Exception {
        String cName;
        String binName = AppUtils.getAppBinDirName(props, appName);
        String deplName = EditionHelper.getCompositeName(appName, props);
        String string = cName = props == null ? null : (String)props.get("cell.name");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findAppContextFromConfig:" + appName + ", " + cName + ", " + binName);
        }
        Object[] cells = AppUtils.getContextArray("cells", null, ws);
        RepositoryContext cellC = null;
        if (cName != null) {
            cellC = AppUtils.getContextFromArray(cells, cName, null, true);
        }
        if (cellC == null && cells.length == 1) {
            cellC = (RepositoryContext)cells[0];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell context: " + cellC);
        }
        if (binName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting bin name to appname.ear");
            }
            binName = appName + ".ear";
        }
        if (cellC != null) {
            RepositoryContext binC = cellC.getChild(AppUtils.getContextType("applications"), binName);
            if (binC == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No binC : " + binName);
                }
                return null;
            }
            RepositoryContext appC = binC.getChild(AppUtils.getContextType("deployments"), deplName);
            return appC;
        }
        Object[] ar = ws.findContext(AppUtils.getContextType("applications")).toArray();
        RepositoryContext binC = AppUtils.getContextFromArray(ar, binName, null, false);
        if (binC == null) {
            return null;
        }
        return binC.getChild(AppUtils.getContextType("deployments"), deplName);
    }

    public static boolean isCluster(RepositoryContext rc) {
        if (rc == null) {
            return false;
        }
        return rc.getType().getName().equals("clusters");
    }

    public static RepositoryContext getClusterFromMember(RepositoryContext rc, WorkSpace ws) throws Exception {
        ResourceBundle resBundle = AppUtils.getBundle(null);
        final RepositoryContext rcFinal = rc;
        final WorkSpace wsFinal = ws;
        Object retVal = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            retVal = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AppUtils.getClusterFromMemberAsSystem(rcFinal, wsFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            RasUtils.logException(ex, tc, CLASS_NAME, "getClusterFromMember", "1190");
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "getClusterFromMember", "1192");
        }
        return (RepositoryContext)retVal;
    }

    public static RepositoryContext getClusterFromMemberAsSystem(RepositoryContext rc, WorkSpace ws) throws Exception {
        Object[] ar;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterFromMember: " + rc.getName());
        }
        if ((ar = AppUtils.getContextArray("clusters", rc.getParent().getParent(), ws)) == null || ar.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterFromMember:none");
            }
            return null;
        }
        URI uri = URI.createURI("server.xml");
        Resource res = rc.getResourceSet().createResource(uri);
        HashMap options = new HashMap();
        res.load(options);
        Server s = (Server)res.getContents().get(0);
        String clusterName = s.getClusterName();
        if (clusterName == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterFromMember:null");
            }
            return null;
        }
        RepositoryContext clContext = AppUtils.getContextFromArray(ar, clusterName, null, false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "For server: " + rc.getName() + ", clusterName: " + clusterName + ", clContext: " + clContext);
        }
        if (clContext == null) {
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5029E", new Object[]{rc.getName(), clusterName}));
        }
        return clContext;
    }

    public static boolean isServer(RepositoryContext rc) {
        if (rc == null) {
            return false;
        }
        return rc.getType().getName().equals("servers");
    }

    public static String getAppDir(String a) {
        String appName = a;
        appName = appName.replace(' ', '_');
        appName = appName.replace('.', '_');
        return appName;
    }

    public static String getAppDir(Scheduler sch) {
        return AppUtils.getAppDir(sch.getAppName());
    }

    public static String getAppTempDir(Scheduler sch) {
        String str = AppUtils.getTempDir(sch);
        str = str + AppUtils.getAppDir("app." + sch.getID());
        return str;
    }

    public static String getTempDir() {
        return AppUtils.getTempDir(null);
    }

    public static String getTempDir(Scheduler sch) {
        String str = "";
        str = sch == null ? AppManagementBaseFactory.getTempExtractDir() : (String)sch.getAppManagement().getGlobalSettings().get("Temp extraction dir for multiserver");
        if (!str.endsWith(java.io.File.separator)) {
            str = str + java.io.File.separator;
        }
        return str;
    }

    public static String getAppTempDeployDir(Scheduler sch) throws AdminException {
        return AppUtils.getAppTempDir(sch) + java.io.File.separator + "dpl";
    }

    public static String getAppTempExtractDir(Scheduler sch) throws AdminException {
        return AppUtils.getAppTempDir(sch) + java.io.File.separator + "ext";
    }

    public static String getAppTempLibraryDir(Scheduler sch) throws AdminException {
        return AppUtils.getAppTempDir(sch) + java.io.File.separator + "libDir";
    }

    public static String getAppTempMergeDir(Scheduler sch) throws AdminException {
        return AppUtils.getAppTempDir(sch) + java.io.File.separator + "mrg";
    }

    public static String getAppDeployFileName(String appName) {
        return "dpl_" + AppUtils.getAppDir(appName);
    }

    public static String getPreAppDeployFileName(String appName) {
        return "predpl_" + AppUtils.getAppDir(appName) + ".ear";
    }

    public static String getAppTempExportDir(String appName, Hashtable gSet) {
        String str = (String)gSet.get("Temp extraction dir for multiserver");
        if (!str.endsWith(java.io.File.separator)) {
            str = str + java.io.File.separator;
        }
        str = str + "tmp." + System.currentTimeMillis();
        return str;
    }

    public static boolean isSystemApp(Scheduler scheduler) {
        if (Boolean.TRUE.equals(scheduler.getProperties().get("META-INF/ibm-application-sa.props")) || AppUtils.isSystemAppOption(scheduler.getProperties())) {
            return true;
        }
        Tr.debug(tc, "ttt isSystemApp return false");
        return false;
    }

    public static boolean isSystemAppOption(Hashtable props) {
        Tr.entry(tc, "isSystemAppOption", new Object[]{props});
        if (props.containsKey("systemApp")) {
            return true;
        }
        Tr.exit(tc, "isSystemAppOption");
        return false;
    }

    public static String getAppInstallDir(Scheduler scheduler, RepositoryContext appC) throws Exception {
        return AppUtils.getAppInstallDir(scheduler, appC, true);
    }

    public static String getAppInstallDir(Scheduler scheduler, RepositoryContext appC, boolean shouldAddEarSuffix) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppInstallDir", new Object[]{scheduler, appC, new Boolean(shouldAddEarSuffix)});
        }
        Object finalDir = scheduler.getProperties().get("installed.ear.destination.final");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "INSTALL_DIR_FINAL= " + finalDir);
        }
        if (finalDir != null) {
            return finalDir.toString();
        }
        String dir = (String)scheduler.getProperties().get("installed.ear.destination");
        if (AppUtils.isEmpty(dir)) {
            dir = "$(APP_INSTALL_ROOT)/" + appC.getParent().getParent().getName() + "/";
        } else if (!(dir = dir.trim().replace(java.io.File.separatorChar, '/')).endsWith("/") && shouldAddEarSuffix) {
            dir = dir + "/";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dir before checking for addearsuffix or not: " + dir);
        }
        if (shouldAddEarSuffix) {
            dir = dir + EditionHelper.getAppEarName(scheduler.getAppName(), scheduler.getProperties());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppInstalldir", new Object[]{dir});
        }
        return dir;
    }

    public static String getAppBinDirName(Scheduler sch) {
        return AppUtils.getAppBinDirName(sch.getProperties(), sch.getAppName());
    }

    public static String getAppBinDirName(Hashtable props, String appName) {
        String binName = null;
        if (props != null) {
            binName = (String)props.get("appbinary.name");
        }
        if (binName != null) {
            return binName;
        }
        String aName = EditionHelper.getAppAndEdition(appName, props)[0];
        return aName + ".ear";
    }

    public static String convert2AbsPath(String dir, VariableMap map) throws Exception {
        if (dir.indexOf("$(") == -1 && dir.indexOf("${") == -1) {
            return dir;
        }
        if (map == null) {
            return dir;
        }
        String ret = map.expand(dir);
        ret = ret.replace('/', java.io.File.separatorChar);
        ret = ret.replace('\\', java.io.File.separatorChar);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "convert2AbsPath: " + dir + " = " + ret);
        }
        return ret;
    }

    public static VariableMap createVarMap(RepositoryContext rc, String configRoot) throws Exception {
        if (AppManagementImpl.isLocalMode()) {
            String cName = rc.getParent().getParent().getName();
            String nName = rc.getParent().getName();
            return AppUtils.createVarMap(configRoot, cName, nName, null);
        }
        String cellName = rc.getParent().getParent().getName();
        String nodeName = rc.getParent().getName();
        String serverName = rc.getName();
        Tr.debug(tc, " cellName => " + cellName);
        Tr.debug(tc, " nodeName => " + nodeName);
        Tr.debug(tc, " server   => " + serverName);
        return AppUtils.createVarMap(configRoot, cellName, nodeName, serverName);
    }

    public static VariableMap createVarMap(String configRoot, String cellName, String nodeName, String processName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVarMap");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConfigRoot: " + configRoot + ", " + "CellName: " + cellName + ", " + "NodeName: " + nodeName + ", " + "ProcName: " + processName);
        }
        Repository repository2 = RepositoryFactory.createRepository("ws-server", configRoot, cellName, nodeName, processName);
        VariableMap map = VariableMapFactory.createVariableMap(repository2);
        map.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + map);
        }
        return map;
    }

    public static synchronized void deleteDirTree(String dir) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        AppUtils._deleteDirTree(new java.io.File(dir).getCanonicalFile(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(String dir, boolean followLink) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        AppUtils._deleteDirTree(new java.io.File(dir).getCanonicalFile(), followLink);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(java.io.File dir) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        AppUtils._deleteDirTree(dir.getCanonicalFile(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(java.io.File dir, boolean followLink) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        AppUtils._deleteDirTree(dir.getCanonicalFile(), followLink);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    private static synchronized void _deleteDirTree(java.io.File dir, boolean followLink) throws IOException {
        if (!dir.exists()) {
            Tr.event(tc, "directory does not exist");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteDirTree");
            }
            return;
        }
        String osName = System.getProperty("os.name");
        boolean notSymLink = true;
        if (!followLink && !osName.startsWith("Windows")) {
            notSymLink = osName.equals("OS/400") ? dir.getAbsolutePath().equalsIgnoreCase(dir.getCanonicalPath()) : dir.getAbsolutePath().equals(dir.getCanonicalPath());
        }
        if (!notSymLink) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "file/dir a symlink: " + dir);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteDirTree");
            }
            return;
        }
        if (dir.isDirectory()) {
            String[] entries = dir.list();
            for (int i = 0; i < entries.length; ++i) {
                java.io.File f = new java.io.File(dir.getPath(), entries[i]);
                AppUtils._deleteDirTree(f, followLink);
            }
        }
        if (!dir.delete()) {
            Tr.warning(tc, "ADMA0078W", dir);
        }
    }

    public static void xcopy(RepositoryContext rc, String dest, Vector excludes) throws Exception {
        int i;
        java.io.File dFile = new java.io.File(dest);
        String destPath = dFile.getAbsolutePath();
        dFile.mkdirs();
        rc.extract(false);
        String cPath = rc.getPath();
        List l = new ArrayList(rc.getFiles());
        for (i = 0; i < l.size(); ++i) {
            String n = (String)l.get(i);
            if (excludes.contains(n)) continue;
            if (java.io.File.separatorChar != '/') {
                n = n.replace('/', java.io.File.separatorChar);
            }
            String full = cPath + java.io.File.separator + n;
            AppUtils.copyFile(new java.io.File(full), destPath + java.io.File.separator + n);
        }
        l = rc.getChildren();
        for (i = 0; i < l.size(); ++i) {
            RepositoryContext child = (RepositoryContext)l.get(i);
            AppUtils.xcopy(child, dest + java.io.File.separator + child.getName(), excludes);
        }
    }

    public static String copyFile(String sourcePath) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile", new Object[]{sourcePath});
        }
        String suffix = null;
        if (sourcePath.lastIndexOf(".") > 0) {
            suffix = sourcePath.substring(sourcePath.lastIndexOf("."));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "suffix: " + suffix);
        }
        java.io.File tempFile = java.io.File.createTempFile("app", suffix);
        String tempPath = tempFile.getCanonicalPath();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "temp path: " + tempPath);
        }
        tempFile.delete();
        AppUtils.copyFile(new java.io.File(sourcePath), tempPath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile", new Object[]{tempPath});
        }
        return tempPath;
    }

    public static void copyFile(java.io.File s, String d) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Copying..: " + s.getAbsolutePath() + " to " + d);
        }
        FileInputStream in = new FileInputStream(s);
        AppUtils.copyFile(in, d);
        in.close();
    }

    public static void copyFile(InputStream in, String d) throws Exception {
        java.io.File f = new java.io.File(d);
        f.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(f);
        byte[] bar = new byte[4096];
        int bytesRead = in.read(bar);
        while (bytesRead != -1) {
            out.write(bar, 0, bytesRead);
            bytesRead = in.read(bar);
        }
        out.flush();
        out.close();
    }

    public static void copyFile(File file, String fileName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile", new String[]{"file=" + file, "fileName=" + fileName});
        }
        InputStream inputStream = null;
        try {
            try {
                inputStream = file.getInputStream();
                AppUtils.copyFile(inputStream, fileName);
            }
            catch (Exception e) {
                RasUtils.logException(e, tc, CLASS_NAME, "copyFile", "1687");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "copyFile", e.toString());
                }
                throw e;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            AppUtils.closeInputStream(inputStream);
            throw throwable;
        }
        AppUtils.closeInputStream(inputStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static byte[] getFileContents(InputStream in) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileContents");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bar = new byte[4096];
        int bytesRead = in.read(bar);
        while (bytesRead != -1) {
            bos.write(bar, 0, bytesRead);
            bytesRead = in.read(bar);
        }
        bos.flush();
        byte[] o_bar = bos.toByteArray();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileContents: " + o_bar.length);
        }
        return o_bar;
    }

    public static String getInstallDirFromBinariesURL(ApplicationDeployment appDepl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstallDirFromBinariesURL " + appDepl);
        }
        String dir = appDepl.getBinariesURL();
        int l1 = dir.lastIndexOf(47);
        int l2 = dir.lastIndexOf(92);
        if (l2 > l1) {
            l1 = l2;
        }
        if (l1 == -1) {
            return dir;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstallDirFromBinariesURL " + dir);
        }
        return dir.substring(0, l1);
    }

    public static String getBinaryContextFromBinariesURL(ApplicationDeployment appDepl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBinaryContextFromBinariesURL " + appDepl);
        }
        String dir = appDepl.getBinariesURL();
        int l1 = dir.lastIndexOf(47);
        int l2 = dir.lastIndexOf(92);
        if (l2 > l1) {
            l1 = l2;
        }
        if (l1 == -1) {
            return dir;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBinaryContextFromBinariesURL " + dir);
        }
        return dir.substring(l1 + 1);
    }

    public static List getURIs(String dirName) {
        return AppUtils.getFiles(dirName, "");
    }

    public static List getFiles(String dirName, String parent) {
        ArrayList v = new ArrayList();
        AppUtils.getFiles(v, new java.io.File(dirName), parent);
        return v;
    }

    public static void getFiles(List v, java.io.File dir, String parent) {
        if (!dir.isDirectory()) {
            return;
        }
        if (!dir.exists()) {
            return;
        }
        java.io.File[] l = dir.listFiles();
        for (int i = 0; i < l.length; ++i) {
            String fName = l[i].getName();
            if (fName.equals(".") || fName.equals("..")) continue;
            if (l[i].isDirectory()) {
                AppUtils.getFiles(v, l[i], parent + fName + "/");
                continue;
            }
            v.add((parent + fName).replace('\\', '/'));
        }
    }

    public static Object[] getContainerAndOffset(Container parent, String uri) throws Exception {
        uri.replace('\\', '/');
        EList l = parent.getFiles();
        for (int i = 0; i < l.size(); ++i) {
            File f = (File)l.get(i);
            if (f.getURI().equals(uri)) {
                return new Object[]{parent, uri};
            }
            if (!uri.startsWith(f.getURI() + "/") || !(f instanceof Container)) continue;
            return AppUtils.getContainerAndOffset((Container)f, uri.substring(uri.indexOf(f.getURI()) + f.getURI().length() + 1));
        }
        return new Object[]{parent, uri};
    }

    public static String getNodeMajorVersion(String cellName, String nodeName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeMajorVersion");
        }
        try {
            Properties inProps = new Properties();
            if (!AppUtils.isEmpty(cellName)) {
                inProps.setProperty("local.cell", cellName);
            }
            ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(inProps));
            String nodeVersion = helper.getNodeMajorVersion(nodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeMajorVersion: " + nodeVersion + ", node: " + nodeName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeMajorVersion");
            }
            return nodeVersion;
        }
        catch (Throwable th) {
            throw new AdminException(th, "");
        }
    }

    public static String getNodeMajorVersion(Session session, String cellName, String nodeName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeMajorVersion");
        }
        try {
            Properties inProps = new Properties();
            inProps.setProperty("local.cell", cellName);
            inProps.setProperty("CONFIG_SESSION", session.toString());
            ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(inProps));
            String nodeVersion = helper.getNodeMajorVersion(nodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeMajorVersion: " + nodeVersion + ", node: " + nodeName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeMajorVersion");
            }
            return nodeVersion;
        }
        catch (Throwable th) {
            throw new AdminException(th, "");
        }
    }

    public static String getNodeMinorVersion(Session session, String cellName, String nodeName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeMinorVersion");
        }
        try {
            Properties inProps = new Properties();
            inProps.setProperty("local.cell", cellName);
            inProps.setProperty("CONFIG_SESSION", session.toString());
            ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(inProps));
            String nodeVersion = helper.getNodeMinorVersion(nodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeMinorVersion: " + nodeVersion + ", node: " + nodeName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeMinorVersion");
            }
            return nodeVersion;
        }
        catch (Throwable th) {
            throw new AdminException(th, "");
        }
    }

    public static String getNodeEJB3FeaturePackProductShortName(Session session, String cellName, String nodeName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeEJB3FeaturePackProductShortName");
        }
        try {
            Properties inProps = new Properties();
            if (!AppUtils.isEmpty(cellName)) {
                inProps.setProperty("CELL_NAME", cellName);
            }
            inProps.setProperty("CONFIG_SESSION", session.toString());
            ManagedObjectMetadataAccessor moma = ManagedObjectMetadataAccessorFactory.createAccessor(inProps);
            String prodName = moma.getMetadataProperty(nodeName, "com.ibm.websphere.EJB3FeaturePackProductShortName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prodName: " + prodName + ", node: " + nodeName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeEJB3FeaturePackProductShortName");
            }
            return prodName;
        }
        catch (Throwable th) {
            throw new AdminException(th, "");
        }
    }

    public static String[][] getResourceTable() {
        String[] server = new String[]{"server", "MapModulesToServers", "Server", "name"};
        String[] vhost = new String[]{"virtualHost", "MapWebModToVH", "VirtualHost", "name"};
        String[] jndi1 = new String[]{"JNDI", "BindJndiForEJBMessageBinding", "J2EEResourceFactory", "jndiName"};
        String[] jndi2 = new String[]{"JNDI", "DataSourceFor10CMPBeans", "J2EEResourceFactory", "jndiName"};
        String[] jndi3 = new String[]{"JNDI", "DataSourceFor10EJBModules", "J2EEResourceFactory", "jndiName"};
        String[] jndi4 = new String[]{"JNDI", "DataSourceFor20CMPBeans", "J2EEResourceFactory", "jndiName"};
        String[] jndi5 = new String[]{"JNDI", "DataSourceFor20EJBModules", "J2EEResourceFactory", "jndiName"};
        String[] jndi6 = new String[]{"JNDI", "BindJndiForEJBNonMessageBinding", "J2EEResourceFactory", "jndiName"};
        String[] jndi7 = new String[]{"JNDI", "MapResRefToEJB", "J2EEResourceFactory", "jndiName"};
        String[] jndi8 = new String[]{"JNDI", "MapResEnvRefToRes", "J2EEResourceFactory", "jndiName"};
        String[] actspec1 = new String[]{"JNDI", "BindJndiForEJBMessageBinding", "J2CActivationSpec", "destinationJndiName"};
        String[] actspec2 = new String[]{"JNDI", "BindJndiForEJBMessageBinding", "J2CActivationSpec", "jndiName"};
        String[] adminobj1 = new String[]{"jndi.dest", "BindJndiForEJBMessageBinding", "J2CAdminObject", "jndiName"};
        String[] jaasAuth = new String[]{"jndi.dest", "MapRunAsRolesToUsers", "JAASAuthData", "authData"};
        String[][] restbl = new String[][]{server, vhost, jndi1, jndi2, jndi2, jndi4, jndi5, jndi6, jndi7, jndi8, actspec1, actspec2, adminobj1, jaasAuth};
        return restbl;
    }

    public static String getClientVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientVersion ");
        }
        if (AppManagementImpl.isLocalMode()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClientVersion: " + AppDeploymentTask.HIGHEST_VERSION);
            }
            return AppDeploymentTask.HIGHEST_VERSION;
        }
        JMXVersionValidation JMXValidation = new JMXVersionValidation();
        String clientVersion = JMXValidation.getClientVersion();
        if (clientVersion == null) {
            clientVersion = AppDeploymentTask.HIGHEST_VERSION;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientVersion: " + clientVersion);
        }
        return clientVersion;
    }

    public static String getClientVersion(Hashtable prefs, boolean create) {
        if (create) {
            return AppDeploymentTask.HIGHEST_VERSION;
        }
        return AppUtils.getClientVersion();
    }

    public static Properties getEditionProps(RepositoryContext appC) throws AdminException {
        if (!appC.getParent().isAvailable("ibm-edition-metadata.props")) {
            return new Properties();
        }
        try {
            appC.getParent().extract("ibm-edition-metadata.props", false);
            Properties props = new Properties();
            FileInputStream fin = new FileInputStream(appC.getParent().getPath() + "/" + "ibm-edition-metadata.props");
            props.load(fin);
            fin.close();
            return props;
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "getEditionProps", "2019");
            AppUtils.dbg(tc, "Error loading edition props: " + appC);
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, null);
        }
    }

    public static void setEditionProps(RepositoryContext appC, Properties props) throws AdminException {
        try {
            if (props == null) {
                return;
            }
            boolean isAvailable = appC.getParent().isAvailable("ibm-edition-metadata.props");
            OutputStream os2 = appC.getParent().getOutputStream("ibm-edition-metadata.props");
            props.store(os2, "File contains metadata for all editions of the application");
            os2.flush();
            os2.close();
            appC.getParent().notifyChanged(isAvailable ? 0 : 1, "ibm-edition-metadata.props");
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "setEditionProps", "2042");
            AppUtils.dbg(tc, "Error saving edition props: " + appC);
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, null);
        }
    }

    public static String getAttrValueFromManifest(String key, ArchiveManifest manifest) {
        String value = "";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttrValueFromManifest: key=" + key);
        }
        Attributes attr = manifest.getMainAttributes();
        value = attr.getValue(key);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttrValueFromManifest: value=" + value);
        }
        return value;
    }

    public static boolean checkAdminAccessApp(Hashtable props, String role, String appName) {
        String uri = AppUtils.getAppUri(props, appName);
        boolean ret = AppUtils.checkAdminAccess(role, uri);
        return ret;
    }

    public static boolean checkAdminAccess(String role, String docUri) {
        AdminAuthorizer aa = null;
        aa = SecurityHelper.getHelper().getAdminAuthorizer();
        return aa == null || aa.checkAccess(docUri, role);
    }

    public static String getAppUri(Hashtable props, String appName) {
        String cellName = AppManagementImpl.getCellName();
        String binName = AppUtils.getAppBinDirName(props, appName);
        String deplName = EditionHelper.getCompositeName(appName, props);
        String uri = "config/cells/" + cellName + "/applications/" + binName;
        return uri;
    }

    public static boolean checkAdminAccessNewTarget(Hashtable props, String role, String cName, String wid, Vector uris, Vector tasks) {
        boolean perm = false;
        String uri = null;
        for (int j = 0; j < tasks.size(); ++j) {
            AppDeploymentTask mapMToS = (AppDeploymentTask)tasks.get(j);
            if (!mapMToS.getName().equals("MapModulesToServers")) continue;
            String[][] data = mapMToS.getTaskData();
            for (int k = 1; k < data.length; ++k) {
                String target = data[k][2];
                Object[] urls = AppUtils.convertToURL(target);
                for (int i = 0; i < urls.length; ++i) {
                    uri = (String)urls[i];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new target = " + target);
                    }
                    if (perm = AppUtils.checkAdminAccess(role, uri)) continue;
                    uris.add(uri);
                    return perm;
                }
            }
            break;
        }
        return true;
    }

    public static boolean checkAdminAccessTarget(Hashtable props, String role, String cName, String wid, Vector uris) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAdminAccessTarget", new Object[]{"props=" + props, "role=" + role, "cName=" + cName, "wid=" + wid, "uris=" + uris});
        }
        boolean perm = false;
        String uri = null;
        if (props.containsKey("moduleToServer")) {
            Object tbl = props.get("moduleToServer");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MODULE TO SERVER:", tbl);
            }
            if (tbl == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAdminAccessTarget", Boolean.TRUE.toString());
                }
                return true;
            }
            Enumeration en = ((Hashtable)tbl).keys();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Keys:", en);
            }
            while (en.hasMoreElements()) {
                String module = (String)en.nextElement();
                String target = (String)((Hashtable)tbl).get(module);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module & target:", new Object[]{module, target});
                }
                Object[] urls = AppUtils.convertToURL(target);
                for (int i = 0; i < urls.length; ++i) {
                    uri = (String)urls[i];
                    perm = AppUtils.checkAdminAccess(role, uri);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "uri & perm:", new Object[]{uri, perm});
                    }
                    if (perm) continue;
                    uris.add(uri);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkAdminAccessTarget", Boolean.toString(perm));
                    }
                    return perm;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "After while loop.");
            }
        } else {
            String target = AppUtils.getTargetStr(props);
            Object[] urls = AppUtils.convertToURL(target);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target info:", target);
            }
            for (int i = 0; i < urls.length; ++i) {
                uri = (String)urls[i];
                perm = AppUtils.checkAdminAccess(role, uri);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uri & perm:", new Object[]{uri, perm});
                }
                if (perm) continue;
                uris.add(uri);
                return perm;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAdminAccessTarget", Boolean.TRUE.toString());
        }
        return true;
    }

    public static Object[] convertToURL(String target) {
        if (target == null) {
            return new Object[0];
        }
        String url = "cells/";
        Vector<String> result = new Vector<String>(3);
        String cell = null;
        String node = null;
        String server = null;
        String cluster = null;
        String[] ts = target.split("\\+");
        ObjectName o = null;
        for (int i = 0; i < ts.length; ++i) {
            try {
                o = new ObjectName(ts[i]);
            }
            catch (Exception ex) {
                continue;
            }
            node = o.getKeyProperty("node");
            if (node != null) {
                cell = o.getKeyProperty("cell");
                server = o.getKeyProperty("server");
                if (server == null || cell == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "bad target format :" + ts[i]);
                    continue;
                }
                url = "cells/" + cell + "/nodes/" + node + "/servers/" + server;
            } else {
                cell = o.getKeyProperty("cell");
                cluster = o.getKeyProperty("cluster");
                if (cluster == null || cell == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "bad target format :" + ts[i]);
                    continue;
                }
                url = "cells/" + cell + "/clusters/" + cluster;
            }
            result.add(url);
        }
        return result.toArray();
    }

    public static Object[] convertToURL(String target, boolean ignoreCell) {
        if (target == null) {
            return new Object[0];
        }
        if (!ignoreCell) {
            return AppUtils.convertToURL(target);
        }
        String url = "cells/";
        Vector<String> result = new Vector<String>(3);
        Object cell = null;
        String node = null;
        String server = null;
        String cluster = null;
        String[] ts = target.split("\\+");
        ObjectName o = null;
        for (int i = 0; i < ts.length; ++i) {
            try {
                o = new ObjectName(ts[i]);
            }
            catch (Exception ex) {
                continue;
            }
            node = o.getKeyProperty("node");
            if (node != null) {
                server = o.getKeyProperty("server");
                if (server == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "bad target format :" + ts[i]);
                    continue;
                }
                url = "/nodes/" + node + "/servers/" + server;
            } else {
                cluster = o.getKeyProperty("cluster");
                if (cluster == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "bad target format :" + ts[i]);
                    continue;
                }
                url = "/clusters/" + cluster;
            }
            result.add(url);
        }
        return result.toArray();
    }

    private static Vector processTargets(String ntarget, String key, RepositoryContext appC, WorkSpace ws) {
        Vector ret;
        Vector all = null;
        RepositoryContext cellC = appC.getParent().getParent();
        try {
            ret = ConfigRepoHelper.getAddRemoveServerNames(ntarget, key, true, cellC, ws);
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "processTargets", "2305");
            return all;
        }
        Vector targetsAdded = (Vector)ret.elementAt(0);
        Vector targetsRemoved = (Vector)ret.elementAt(1);
        all = targetsAdded;
        all.addAll(targetsRemoved);
        return all;
    }

    private static AppDeploymentTask getMapModuleToServerTaskData(RepositoryContext rc, WorkSpace ws, Hashtable props) throws Exception {
        AppDeploymentTask task = null;
        try {
            ResourceBundle resBundle = AppUtils.getBundle(props);
            EARFile earFile = ConfigRepoHelper.getEarFileForApp(ws, rc, resBundle, true);
            AppDeploymentInfo info = AppInstallHelper.getAppDeploymentInfo(earFile);
            MapModulesToServersHelper helper = new MapModulesToServersHelper();
            task = helper.createTask(null, "MapModulesToServers");
            helper.prepareTask(info, task);
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "getMapModuleToServerTaskData", "2331");
            throw e;
        }
        return task;
    }

    private static boolean compareTargets(String role, String ntarget, String otarget, Vector<String> failedUrl) {
        int jj;
        String n;
        int j;
        Object[] nurls = AppUtils.convertToURL(ntarget);
        Object[] ourls = AppUtils.convertToURL(otarget);
        boolean found = false;
        boolean perm = false;
        for (j = 0; j < ourls.length; ++j) {
            n = (String)ourls[j];
            if (!tc.isDebugEnabled()) continue;
            Tr.entry(tc, "------- old --- " + n);
        }
        for (j = 0; j < nurls.length; ++j) {
            n = (String)nurls[j];
            if (!tc.isDebugEnabled()) continue;
            Tr.entry(tc, "------- new --- " + n);
        }
        for (j = 0; j < nurls.length; ++j) {
            found = false;
            n = (String)nurls[j];
            for (jj = 0; jj < ourls.length; ++jj) {
                String o = (String)ourls[jj];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "comparetarget o=" + o + " n=" + n);
                }
                if (!o.equals(n)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "added new  target: " + n);
            }
            if (perm = AppUtils.checkAdminAccess(role, n)) continue;
            failedUrl.add(n);
            return perm;
        }
        for (j = 0; j < ourls.length; ++j) {
            found = false;
            String o = (String)ourls[j];
            for (jj = 0; jj < nurls.length; ++jj) {
                String n2 = (String)nurls[jj];
                if (!o.equals(n2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removed old  target: " + o);
            }
            if (perm = AppUtils.checkAdminAccess(role, o)) continue;
            failedUrl.add(o);
            return perm;
        }
        return true;
    }

    public static boolean checkAdminAccessChangedTarget(String appName, Hashtable props, String role, String cName, String wid, Vector<String> failedUrl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAdminAccessChangedTarget " + appName + " : " + role + " : " + cName);
        }
        Object tbl = props.get("moduleToServer");
        boolean perm = false;
        WorkSpace ws = null;
        RepositoryContext rc = null;
        try {
            ws = ConfigRepoHelper.getWorkSpace(wid);
            rc = AppUtils.findAppContextFromConfig(appName, ws, props);
            if (rc == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to get application repository context =" + rc);
                }
                failedUrl.add("");
                return false;
            }
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "checkAdminAccessChangedTarget", "2423");
            failedUrl.add("");
            return false;
        }
        AppDeploymentTask task = null;
        try {
            task = AppUtils.getMapModuleToServerTaskData(rc, ws, props);
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "checkAdminAccessChangedTarget", "2433");
            failedUrl.add("");
            return false;
        }
        String[][] dataOrg = task.getTaskData();
        if (dataOrg == null) {
            Enumeration en = ((Hashtable)tbl).keys();
            while (en.hasMoreElements()) {
                String module = (String)en.nextElement();
                String target = (String)((Hashtable)tbl).get(module);
                Object[] urls = AppUtils.convertToURL(target);
                for (int j = 0; j < urls.length; ++j) {
                    perm = AppUtils.checkAdminAccess(role, (String)urls[j]);
                    if (perm) continue;
                    failedUrl.add((String)urls[j]);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkAdminAccessChangedTarget returns false for " + failedUrl);
                    }
                    return perm;
                }
            }
        } else if (tbl == null) {
            perm = AppUtils.checkAccessForTask(dataOrg, role, failedUrl);
            if (!perm) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAdminAccessChangedTarget returns false for " + failedUrl);
                }
                return perm;
            }
        } else {
            for (int i = 1; i < dataOrg.length; ++i) {
                String otarget;
                Vector changedTargets;
                String ourl = dataOrg[i][1];
                String key = ourl.replace(',', '+');
                String ntarget = (String)((Hashtable)tbl).get(key);
                if (ntarget != null && (ntarget.startsWith("+") || ntarget.startsWith("-")) && (changedTargets = AppUtils.processTargets(ntarget, key, rc, ws)) != null) {
                    for (int ii = 0; ii < changedTargets.size(); ii += 2) {
                        RepositoryContext rr = (RepositoryContext)changedTargets.elementAt(ii);
                        String uri = rr.getURI();
                        perm = AppUtils.checkAdminAccess(role, uri);
                        if (perm) continue;
                        failedUrl.add(uri);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "checkAdminAccessChangedTarget returns false for " + uri);
                        }
                        return perm;
                    }
                    continue;
                }
                if (ntarget == null || (perm = AppUtils.compareTargets(role, ntarget, otarget = dataOrg[i][2], failedUrl))) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAdminAccessChangedTarget returns false for " + failedUrl);
                }
                return perm;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAdminAccessChangedTarget  returns true");
        }
        return true;
    }

    private static boolean checkAccessForTask(String[][] taskData, String role, Vector<String> failedUrl) {
        for (int i = 1; i < taskData.length; ++i) {
            boolean perm = false;
            String targets = taskData[i][2];
            Object[] urls = AppUtils.convertToURL(targets);
            for (int l = 0; l < urls.length; ++l) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "url=" + urls[l]);
                }
                if (perm = AppUtils.checkAdminAccess(role, (String)urls[l])) continue;
                failedUrl.add((String)urls[l]);
                return perm;
            }
        }
        return true;
    }

    public static boolean checkAdminAccessChangedTarget(String appName, Hashtable props, String role, String cName, String wid, Vector<String> failedUrl, Vector tasks) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAdminAccessChangedTarget " + appName + " : " + role + " : " + cName);
        }
        boolean perm = false;
        WorkSpace ws = null;
        RepositoryContext rc = null;
        try {
            ws = ConfigRepoHelper.getWorkSpace(wid);
            rc = AppUtils.findAppContextFromConfig(appName, ws, props);
            if (rc == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to get application repository context =" + rc);
                }
                failedUrl.add("");
                return false;
            }
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "checkAdminAccessChangedTarget", "2547");
            failedUrl.add("");
            return false;
        }
        AppDeploymentTask task = null;
        try {
            task = AppUtils.getMapModuleToServerTaskData(rc, ws, props);
        }
        catch (Exception e) {
            failedUrl.add("");
            return false;
        }
        String[][] dataOrg = task.getTaskData();
        String[][] dataChanged = null;
        for (int j = 0; j < tasks.size(); ++j) {
            AppDeploymentTask mapMToS = (AppDeploymentTask)tasks.get(j);
            if (!mapMToS.getName().equals("MapModulesToServers")) continue;
            dataChanged = mapMToS.getTaskData();
            break;
        }
        if (dataOrg == null) {
            if (dataChanged == null) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "checkAdminAccessChangedTarget  no change returns true");
                }
                return true;
            }
            perm = AppUtils.checkAccessForTask(dataChanged, role, failedUrl);
            if (!perm) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "checkAdminAccessChangedTarget  returns false for  datachangted " + dataChanged);
                }
                return perm;
            }
        } else if (dataChanged == null) {
            perm = AppUtils.checkAccessForTask(dataOrg, role, failedUrl);
            if (!perm) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "checkAdminAccessChangedTarget  return false for dataorg " + dataOrg);
                }
                return perm;
            }
        } else {
            for (int i = 1; i < dataOrg.length; ++i) {
                String ourl = dataOrg[i][1];
                String otarget = dataOrg[i][2];
                String curl = null;
                String ntarget = null;
                boolean found = false;
                for (int j = 1; j < dataChanged.length; ++j) {
                    curl = dataChanged[j][1];
                    if (!curl.equals(ourl)) continue;
                    ntarget = dataChanged[j][2];
                    found = true;
                    break;
                }
                if (!found) continue;
                if (otarget != null && otarget.equals(ntarget)) break;
                String key = curl.replace(',', '+');
                Vector changedTargets = null;
                if (ntarget != null && (ntarget.startsWith("+") || ntarget.startsWith("-")) && (changedTargets = AppUtils.processTargets(ntarget, key, rc, ws)) != null) {
                    for (int ii = 0; ii < changedTargets.size(); ii += 2) {
                        RepositoryContext rr = (RepositoryContext)changedTargets.elementAt(ii);
                        String uri = rr.getURI();
                        perm = AppUtils.checkAdminAccess(role, uri);
                        if (perm) continue;
                        failedUrl.add(uri);
                        if (tc.isDebugEnabled()) {
                            Tr.exit(tc, "checkAdminAccessChangedTarget  returns false for " + uri);
                        }
                        return perm;
                    }
                    continue;
                }
                perm = AppUtils.compareTargets(role, ntarget, otarget, failedUrl);
                if (perm) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAdminAccessChangedTarget  returns false for   failed  " + failedUrl);
                }
                return perm;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAdminAccessChangedTarget  returns true in the last ");
        }
        return true;
    }

    public static void loadDeploymentsToWorkSpace(String appName, Hashtable props, String wid) {
        WorkSpace ws;
        try {
            ws = ConfigRepoHelper.getWorkSpace(wid);
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "loadDeploymentsToWorkSpace", "2662");
            return;
        }
        Vector v = null;
        try {
            RepositoryContext rc = AppUtils.findAppContextFromConfig(appName, ws, props);
            if (rc == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to get application repository context =" + rc);
                }
                return;
            }
            RepositoryContext cellC = rc.getParent().getParent();
            ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
            v = ConfigRepoHelper.getServersForAppDeployment(appDepl, null, cellC, ws, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All targets: " + v);
            }
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "loadDeploymentsToWorkSpace", "2680");
        }
    }

    public static boolean checkAdminAccessRemovedTarget(String appName, Hashtable props, String role, String cName, String wid, Vector uris) {
        WorkSpace ws;
        boolean perm = false;
        String uri = null;
        try {
            ws = ConfigRepoHelper.getWorkSpace(wid);
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "checkAdminAccessRemovedTarget", "2691");
            return false;
        }
        Vector v = null;
        try {
            RepositoryContext rc = AppUtils.findAppContextFromConfig(appName, ws, props);
            if (rc == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to get application repository context =" + rc);
                }
                return false;
            }
            RepositoryContext cellC = rc.getParent().getParent();
            ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
            v = ConfigRepoHelper.getServersForAppDeployment(appDepl, null, cellC, ws, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All targets: " + v);
            }
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "checkAdminAccessRemovedTarget", "2709");
            return false;
        }
        for (int i = 0; i < v.size(); ++i) {
            RepositoryContext rc = (RepositoryContext)v.elementAt(i);
            uri = rc.getURI();
            perm = AppUtils.checkAdminAccess(role, uri);
            if (perm) continue;
            uris.add(uri);
            return perm;
        }
        return perm;
    }

    public static boolean checkAdminAccessRemovedTargetForModule(String appName, Hashtable props, String role, String cName, String wid, Vector uris, String moduleuri) {
        WorkSpace ws;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appName=" + appName + "cellName = " + cName + " module=" + moduleuri);
        }
        boolean perm = false;
        String uri = null;
        try {
            ws = ConfigRepoHelper.getWorkSpace(wid);
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "checkAdminAccessRemovedTargetForModule", "2734");
            return false;
        }
        Vector v = null;
        try {
            RepositoryContext rc = AppUtils.findAppContextFromConfig(appName, ws, props);
            if (rc == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to get application repository context =" + rc);
                }
                return false;
            }
            RepositoryContext cellC = rc.getParent().getParent();
            ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
            v = ConfigRepoHelper.getServersForAppDeploymentModule(appDepl, null, cellC, ws, false, moduleuri);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All targets: " + v);
            }
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "checkAdminAccessRemovedTargetForModule", "2752");
            return false;
        }
        for (int i = 0; i < v.size(); ++i) {
            RepositoryContext rc = (RepositoryContext)v.elementAt(i);
            uri = rc.getURI();
            perm = AppUtils.checkAdminAccess(role, uri);
            if (perm) continue;
            uris.add(uri);
            return perm;
        }
        return perm;
    }

    public static boolean checkCellLevelAdminAccess(String cellName) {
        String uri = "cells/" + cellName;
        boolean perm = AppUtils.checkAdminAccess("configurator", uri);
        if (!perm) {
            perm = AppUtils.checkAdminAccess("deployer", uri);
            return perm;
        }
        return true;
    }

    public static Hashtable getSharedLibData(String data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSharedLibData", new Object[]{data});
        }
        Hashtable<String, Boolean> tbl = new Hashtable<String, Boolean>();
        if (data != null) {
            StringTokenizer tokens = new StringTokenizer(data, "+");
            while (tokens.hasMoreTokens()) {
                boolean isShared;
                String name;
                boolean defaultShared = AppConstants.APPDEPL_ISSHARED_DEFAULT;
                String lib = tokens.nextToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing lib string: " + lib);
                }
                if (AppUtils.isEmpty(lib)) break;
                int domainIndex = lib.indexOf("WebSphere:");
                if (domainIndex == -1) {
                    name = lib;
                    isShared = defaultShared;
                } else {
                    ObjectName on;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Construting lib string into an object name");
                    }
                    try {
                        on = new ObjectName(lib);
                    }
                    catch (MalformedObjectNameException ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Bad token: " + lib);
                        }
                        throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5025E", new Object[]{lib}), ex);
                    }
                    name = on.getKeyProperty("name");
                    if (name == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "name is null");
                        }
                        throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5073E", new Object[]{lib}), null);
                    }
                    String isSharedStr = on.getKeyProperty("isSharedClassloader");
                    isShared = isSharedStr == null ? defaultShared : Boolean.TRUE.toString().equalsIgnoreCase(isSharedStr);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding (" + name + ", " + isShared + ") to table");
                }
                tbl.put(name, new Boolean(isShared));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSharedLibData", new Object[]{tbl});
        }
        return tbl;
    }

    public static boolean isSkipPrepOption(Hashtable props) {
        Tr.entry(tc, "isSkipPrepOption", new Object[]{props});
        if (props.containsKey("skipPreparation")) {
            Tr.exit(tc, "isSkipPrepOption: true");
            return true;
        }
        Tr.exit(tc, "isSkipPrepOption: false");
        return false;
    }

    public static void validateFilePermissionStringThrowsException(String permInput) throws AdminException {
        if (!AppUtils.validateFilePermissionString(permInput)) {
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0174E", new Object[]{permInput}));
        }
    }

    public static boolean validateAsyncRequestDispatchString(String input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAsyncRequestDispatchString: input string = " + input);
        }
        boolean result = false;
        if (input.trim().toUpperCase().equals("DISABLED") || input.trim().toUpperCase().equals("SERVER_SIDE") || input.trim().toUpperCase().equals("CLIENT_SIDE")) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAsyncRequestDispatchString: " + result);
        }
        return result;
    }

    public static boolean validateFilePermissionString(String permInput) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFilePermissionString: input string = " + permInput);
        }
        boolean result = true;
        String pattern = ".+=[0-7]{3}#?";
        AppUtils.dbg(tc, "pattern = " + pattern);
        Pattern p = Pattern.compile(pattern);
        String[] sp = permInput.split("#");
        for (int i = 0; i < sp.length; ++i) {
            permInput = sp[i];
            Matcher m = p.matcher(permInput);
            boolean matches = m.matches();
            if (!matches) {
                result = false;
            }
            String[] filePattern = permInput.split("=");
            String fp = filePattern[0];
            AppUtils.dbg(tc, "filePattern = " + fp);
            try {
                Pattern ip = Pattern.compile(fp);
                continue;
            }
            catch (PatternSyntaxException pse) {
                result = false;
                AppUtils.dbg(tc, pse.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFilePermissionString: " + result);
        }
        return result;
    }

    public static String getNewFilePermissions(String orig, String newInput) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNewFilePermissions:  orig = " + orig + ", newInput = " + newInput);
        }
        if (orig == null) {
            return newInput;
        }
        String fpStr = "";
        ArrayList<String> fpArr = new ArrayList<String>();
        String[] input = newInput.split("#");
        for (int i = 0; i < input.length; ++i) {
            if (orig.indexOf(input[i]) != -1) continue;
            fpArr.add(input[i]);
        }
        if (!fpArr.isEmpty()) {
            fpStr = AppUtils.join("#", fpArr.toArray(new String[0]));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNewFilePermissions - " + fpStr);
        }
        return fpStr;
    }

    public static String join(String token, String[] strings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "join - token: " + token + ", strings = " + strings);
        }
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < strings.length - 1; ++x) {
            sb.append(strings[x]);
            sb.append(token);
        }
        sb.append(strings[strings.length - 1]);
        return sb.toString();
    }

    public static boolean isProductInstalled(String wasInstallRoot, String productId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isProductInstalled", new Object[]{wasInstallRoot, productId});
        }
        boolean ret = false;
        if (!AppUtils.isEmpty(wasInstallRoot)) {
            WASDirectory wasDir = new WASDirectory(wasInstallRoot);
            ret = wasDir.isThisProductInstalled("embeddedEXPRESS");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isProductInstalled", new Object[]{new Boolean(ret)});
        }
        return ret;
    }

    public static boolean isAppEditable(String wID, String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAppEditable()", new Object[]{wID, appName});
        }
        boolean result = false;
        try {
            WorkSpace ws = ConfigRepoHelper.getWorkSpace(wID);
            RepositoryContext rc = AppUtils.findAppContextFromConfig(appName, ws, new Hashtable());
            ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
            result = ConfigRepoHelper.isEditAllowed(appDepl);
        }
        catch (Throwable th) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Exception Received: ", th);
            }
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAppEditable()", new Object[]{result});
        }
        return result;
    }

    public static String getServerType(String serverName, String nodeName, Session session) {
        String serverType;
        block4: {
            serverType = "";
            try {
                TaskCommand serverTypeCmd = (TaskCommand)CommandMgr.getCommandMgr().createCommand("getServerType");
                serverTypeCmd.setConfigSession(session);
                serverTypeCmd.setParameter("serverName", serverName);
                serverTypeCmd.setParameter("nodeName", nodeName);
                serverTypeCmd.execute();
                CommandResult cmdResult = serverTypeCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    serverType = (String)cmdResult.getResult();
                }
            }
            catch (Exception ex) {
                if (!tc.isEntryEnabled()) break block4;
                Tr.event(tc, "Exception in getServerType() : " + ex.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType: " + serverType);
        }
        return serverType;
    }

    public static boolean isWebServerType(String targetServer, String sessionId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWebServerType", new Object[]{targetServer, sessionId});
        }
        boolean isWebServer = false;
        Session session = new Session(sessionId, true);
        try {
            String serverType;
            ObjectName objectName = new ObjectName(targetServer);
            String nodeName = objectName.getKeyProperty("node");
            String serverName = objectName.getKeyProperty("server");
            if (nodeName != null && serverName != null && "WEB_SERVER".equals(serverType = AppUtils.getServerType(serverName, nodeName, session))) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "serverType: " + serverType);
                }
                isWebServer = true;
            }
        }
        catch (Exception e) {
            RasUtils.logException(e, tc, CLASS_NAME, "isWebServer", "3055");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isWebServerType", new Object[]{isWebServer});
        }
        return isWebServer;
    }

    public static void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "closeInputStream", "3073", new Object[]{inputStream});
            }
        }
    }

    public static void closeOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "closeOutputStream", "3090", new Object[]{outputStream});
            }
        }
    }

    public static void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "closeReader", "3107", new Object[]{reader});
            }
        }
    }

    public static void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "closeWriter", "3124", new Object[]{writer});
            }
        }
    }

    public static String objectToTerseString(Object object) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(object.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(object.hashCode()));
        return stringBuilder.toString();
    }

    public static String collectionToTerseString(Collection<?> collection) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(collection.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(((Object)collection).hashCode()));
        stringBuilder.append("[size=");
        stringBuilder.append(collection.size());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String mapToTerseString(Map<?, ?> map) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(map.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(((Object)map).hashCode()));
        stringBuilder.append("[size=");
        stringBuilder.append(map.size());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static List<String> extractLibraryDirectoryJars(Scheduler scheduler, EARFile earFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractLibraryDirectoryJars", new String[]{"scheduler=" + scheduler, "earFile=" + earFile});
        }
        ArrayList<String> jars = new ArrayList<String>();
        String libraryDirectoryName = earFile.getLibraryDirectoryName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "extractLibraryDirectoryJars", "libraryDirectoryName=" + libraryDirectoryName);
        }
        if (!AppUtils.isEmpty(libraryDirectoryName)) {
            String directory = AppUtils.getAppTempLibraryDir(scheduler);
            String libraryDirectory = libraryDirectoryName + "/";
            List archiveFiles = earFile.getArchiveFiles();
            for (File file : archiveFiles) {
                String uri = file.getURI();
                if (!uri.startsWith(libraryDirectory) || !uri.endsWith(".jar")) continue;
                String fileName = directory + java.io.File.separator + uri.replace('/', java.io.File.separatorChar);
                jars.add(fileName);
                AppUtils.copyFile(file, fileName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractLibraryDirectoryJars", jars);
        }
        return jars;
    }

    public static Hashtable getAppDocuments(String appName, String nodeName) throws AdminException {
        int i;
        String[] uris;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDocuments");
        }
        Hashtable<String, DocumentDigest> tbl = new Hashtable<String, DocumentDigest>();
        ConfigRepository repo = ConfigRepositoryFactory.getConfigRepository();
        RepositoryAdapter repositoryAdapter = RepositoryAdapter.getRepositoryAdapter((ConfigRepository)repo, (String)nodeName);
        String root = "cells/" + AdminServiceFactory.getAdminService().getCellName() + "/applications/" + appName + ".ear";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "root app dir is  = " + root);
        }
        if ((uris = repo.listResourceNames(root, 1, Integer.MAX_VALUE)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uri is null - so return");
            }
            return tbl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "uris num = " + uris.length);
        }
        DocumentDigest[] dig = new DocumentDigest[uris.length];
        for (i = 0; i < uris.length; ++i) {
            dig[i] = repositoryAdapter.getDigest(uris[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dig num = " + dig.length);
        }
        for (i = 0; i < uris.length; ++i) {
            tbl.put(uris[i], dig[i]);
        }
        return tbl;
    }

    public static void checkForMarkerFileInWebModule(String markerFileAction, List<String> moduleList, String deployCtxRoot) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForMarkerFileInWebModule", new Object[]{markerFileAction, moduleList, deployCtxRoot});
        }
        if (moduleList != null) {
            for (String moduleURI : moduleList) {
                AppUtils.dbg(tc, "moduleURI: " + moduleURI);
                if (!moduleURI.endsWith(".war")) continue;
                String markerFile = "web_module_deleted";
                java.io.File markerFilePath = new java.io.File(deployCtxRoot + moduleURI + "/" + markerFile);
                boolean isMarkerFileThere = markerFilePath.exists();
                AppUtils.dbg(tc, "marker file " + markerFilePath + " exists: " + isMarkerFileThere);
                if (isMarkerFileThere && MARKER_FILE_DELETE_ACTION.equals(markerFileAction)) {
                    boolean isDeleted = markerFilePath.delete();
                    AppUtils.dbg(tc, "marker file " + markerFilePath + " deleted? " + isDeleted);
                    continue;
                }
                if (isMarkerFileThere || !MARKER_FILE_CREATE_ACTION.equals(markerFileAction)) continue;
                boolean isCreated = markerFilePath.createNewFile();
                AppUtils.dbg(tc, "marker file " + markerFilePath + " created? " + isCreated);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFormMarkerFileInWebModule");
        }
    }

    public static List<String> getListWebModulesFromAppCtx(RepositoryContext appContext) throws Exception {
        ArrayList<String> modulesList = new ArrayList<String>();
        String root = appContext.getPath();
        AppUtils.dbg(tc, "app root: " + root);
        java.io.File d = new java.io.File(root);
        java.io.File[] files = d.listFiles();
        if (files != null) {
            for (java.io.File file : files) {
                String fileName = file.getName();
                if (!file.isDirectory() || !fileName.endsWith(".war")) continue;
                AppUtils.dbg(tc, "adding module: " + fileName);
                modulesList.add(fileName);
            }
        }
        AppUtils.dbg(tc, "List of web modules: " + modulesList);
        return modulesList;
    }

    public static boolean getGlobalEmbededConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalEmbededConfig ");
        }
        String strProcessEmbededConfigGlobal = System.getProperty("com.ibm.websphere.management.processEmbeddedConfigGlobal");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "globally processEmbeddedConfigGlobal is set as--" + strProcessEmbededConfigGlobal);
        }
        Boolean bProcessEmbededConfigGlobal = AppConstants.APPDEPL_PROCESS_EMBEDDEDCFG_INSTALL_DEFAULT;
        if ("false".equals(strProcessEmbededConfigGlobal)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGlobalEmbededConfig - false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalEmbededConfig - true");
        }
        return true;
    }

    public static void merge(WorkSpace archiveWS, WorkSpace targetWS) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge");
        }
        Collection archiveWSApps = archiveWS.getRootContext().findContext(AppUtils.getContextType("applications"));
        for (RepositoryContext archiveApp : archiveWSApps) {
            String archiveAppName = archiveApp.getName();
            Collection targetWSApps = targetWS.getRootContext().findContext(AppUtils.getContextType("applications"));
            for (RepositoryContext targetApp : targetWSApps) {
                if (!archiveAppName.equals(targetApp.getName())) continue;
                AppUtils.dbg(tc, "archiveAppName and targetApp name: " + archiveAppName);
                if (!archiveApp.isAvailable("ibm-edition-metadata.props") || !targetApp.isAvailable("ibm-edition-metadata.props")) continue;
                try {
                    Properties archiveAppProps = AppUtils._loadProperties(archiveApp);
                    Properties targetAppProps = AppUtils._loadProperties(targetApp);
                    Properties mergedProps = AppUtils.mergeProps(archiveAppProps, targetAppProps);
                    AppUtils._writeProperties(archiveApp, mergedProps);
                }
                catch (Exception e) {
                    AppUtils.dbg(tc, "Error during merge of edition properties");
                    throw e;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void _writeProperties(RepositoryContext appC, Properties props) throws Exception {
        OutputStream os2;
        block8: {
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "_writeProperties");
                }
                os2 = null;
                try {
                    try {
                        if (props == null) {
                            Object var5_3 = null;
                            break block7;
                        }
                        os2 = appC.getOutputStream("ibm-edition-metadata.props");
                        props.store(os2, "File contains metadata for all editions of the application");
                        os2.flush();
                        break block8;
                    }
                    catch (Exception e) {
                        AppUtils.dbg(tc, "Error writing edition props of " + appC.getName() + " at " + appC.getPath());
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    AppUtils.closeOutputStream(os2);
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit(tc, "_writeProperties");
                    throw throwable;
                }
            }
            AppUtils.closeOutputStream(os2);
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "_writeProperties");
            return;
        }
        Object var5_4 = null;
        AppUtils.closeOutputStream(os2);
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "_writeProperties");
    }

    private static Properties mergeProps(Properties archiveProps, Properties targetProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergProps");
        }
        Properties mergedProps = new Properties();
        mergedProps.putAll((Map<?, ?>)archiveProps);
        mergedProps.putAll((Map<?, ?>)targetProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeProps", "mergedProps: " + mergedProps);
        }
        return mergedProps;
    }

    private static Properties _loadProperties(RepositoryContext appC) throws Exception {
        Properties properties;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_loadProperties");
        }
        FileInputStream fin = null;
        Properties props = new Properties();
        try {
            appC.extract("ibm-edition-metadata.props", false);
            fin = new FileInputStream(appC.getPath() + "/" + "ibm-edition-metadata.props");
            props.load(fin);
            properties = props;
            Object var5_5 = null;
        }
        catch (Exception e) {
            try {
                AppUtils.dbg(tc, "Exception during loading edition properties of : " + appC.getName() + " at " + appC.getPath());
                throw e;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_6 = null;
                    AppUtils.closeInputStream(fin);
                    if (!tc.isEntryEnabled()) break block6;
                    Tr.exit(tc, "_loadProperties", "props: " + props);
                }
                throw throwable;
            }
        }
        AppUtils.closeInputStream(fin);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_loadProperties", "props: " + props);
        }
        return properties;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/AppUtils.java, WAS.admin.appmgmt, WAS70.SERV1, cf050925.09, ver. 1.58.10.1");
        }
        CLASS_NAME = AppUtils.class.getName();
        _entitled = null;
        _entitledKey = null;
        productName = "";
    }
}

