/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.EditionInfo;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.application.AppAssociation;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DistributionStatusSchedulerImpl;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.InstallSchedulerImpl;
import com.ibm.ws.management.application.RedeploymentManager;
import com.ibm.ws.management.application.ResourceLookup;
import com.ibm.ws.management.application.UninstallSchedulerImpl;
import com.ibm.ws.management.application.UpdateClusterScheduler;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.policy.ApplicationPolicyParser;
import com.ibm.ws.security.policy.FilterPolicyParser;
import com.ibm.ws.security.policy.PolicyTemplate;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AppManagementImpl
extends RuntimeCollaborator
implements AppManagement {
    private static TraceComponent tc = Tr.register(AppManagementImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static TraceNLS nls;
    public static final String TEMP_EXTRACT_DIR = "Temp extraction dir for multiserver";
    public static final String CONFIG_ROOT = "Config Root for variable map";
    private static final String PROPERTIES_PATH = "version.properties";
    private static final String PROPERTIES_PATH_EXT = "ibm-was-version.properties";
    private static final String VERSION_KEY = "app.management.roam.key";
    private static final String VERSION_VALUE = "3828436921961863062";
    private Hashtable _props;
    private static ObjectName objectName;
    private static long seqNum;
    private boolean readOnly = false;
    private String readOnlyPath = null;
    private long readOnlyTimeStamp;
    static final String RES_SCOPE = "scope";
    static final String RES_TYPE = "type";
    static final String RES_VALUE = "value";
    static final String RES_INDEX = "index";

    public static AppManagement createLocalImpl() {
        return AppManagementFactory.createLocalAppManagementImpl();
    }

    public static AppManagement createLocalImpl(String wasRoot) {
        return AppManagementFactory.createLocalAppManagementImpl(wasRoot);
    }

    public AppManagementImpl(Hashtable tbl) {
        this._props = tbl;
    }

    public Hashtable getGlobalSettings() {
        return this._props;
    }

    public void setObjectName(ObjectName oName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setObjectName: " + oName);
        }
        super.setObjectName(oName);
        objectName = oName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setObjectName");
        }
    }

    public static boolean isLocalMode() {
        return objectName == null;
    }

    public void sendJMXEvent(Object e) {
        this.sendJMXEvent("websphere.admin.appmgmt", e);
    }

    public void sendJMXEvent(String type, Object e) {
        block5: {
            if (AppManagementImpl.isLocalMode()) {
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendJMXEvent");
            }
            try {
                Notification notf = new Notification("websphere.admin.appmgmt", objectName, ++seqNum);
                notf.setUserData(e);
                this.sendNotification(notf);
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "sendJMXEvent", "178", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception from sending JMX event: " + th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendJMXEvent");
        }
    }

    public boolean checkIfAppExists(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        Tr.entry(tc, "checkIfAppExists: " + appName);
        ResourceBundle resBundle = AppUtils.getBundle(prefs);
        final String appNameFinal = appName;
        final Hashtable prefFinal = prefs;
        final String workspaceIDFinal = workspaceID;
        Object retVal = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            retVal = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AppManagementImpl.this.checkIfAppExistsAsSystem(appNameFinal, prefFinal, workspaceIDFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA0178E", new Object[]{appName}));
        }
        catch (Exception e) {
            throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA0179E", new Object[]{appName, e}));
        }
        boolean b = retVal != null;
        Tr.entry(tc, "checkIfAppExists: " + b);
        return b;
    }

    private Object checkIfAppExistsAsSystem(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        EditApplication ed = new EditApplication(appName, prefs, null, workspaceID, this);
        Object b = ed.checkIfAppExists();
        return b;
    }

    public void installApplication(String localEarPath, Hashtable properties, String workspaceID) throws AdminException {
        this.installApplication(localEarPath, null, properties, workspaceID);
    }

    public void installApplication(String localEarPath, String appName, Hashtable properties, String workspaceID) throws AdminException {
        this._installApplication(localEarPath, appName, properties, null, true, workspaceID);
    }

    public void installApplicationLocal(String localEarPath, String appName, Hashtable properties, AppNotification.Listener notf) throws AdminException {
        this._installApplication(localEarPath, appName, properties, notf, false, null);
    }

    public void installApplicationLocal(String localEarPath, String appName, Hashtable properties, AppNotification.Listener notf, String workspaceID) throws AdminException {
        this._installApplication(localEarPath, appName, properties, notf, false, workspaceID);
    }

    private void _installApplication(String localEarPath, String appName, Hashtable properties, AppNotification.Listener notf, boolean isJMX, String workspaceID) throws AdminException {
        ResourceBundle resBundle = AppUtils.getBundle(properties);
        if (!this.isFullUpdate(properties)) {
            String cellName = AppManagementImpl.getCellName();
            boolean perm = AppUtils.checkCellLevelAdminAccess(cellName);
            Vector uris = new Vector();
            if (!perm && !(perm = AppUtils.checkAdminAccessTarget(properties, "deployer", cellName, workspaceID, uris))) {
                String uri = null;
                if (uris != null && uris.size() > 0) {
                    uri = (String)uris.get(0);
                }
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0187E", new Object[]{uri}));
            }
        }
        final String localEarPathFinal = localEarPath;
        final String appNameFinal = appName;
        final Hashtable propertiesFinal = properties;
        final AppNotification.Listener notfFinal = notf;
        final String workspaceIDFinal = workspaceID;
        final boolean isJMXFinal = isJMX;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AppManagementImpl.this._installApplicationAsSystem(localEarPathFinal, appNameFinal, propertiesFinal, notfFinal, isJMXFinal, workspaceIDFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA0176E", new Object[]{appName, localEarPath}));
        }
        catch (Exception e) {
            throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA0177E", new Object[]{appName, localEarPath, e}));
        }
    }

    private void _installApplicationAsSystem(String localEarPath, String appName, Hashtable properties, AppNotification.Listener notf, boolean isJMX, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_installApplicationAsSystem " + localEarPath + ", " + appName);
        }
        ResourceBundle resBundle = AppUtils.getBundle(properties);
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0094E", new Object[]{"installApplication"}));
        }
        if (localEarPath == null) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0041E"));
        }
        if (properties == null) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0042E"));
        }
        if (!new File(localEarPath).exists() && !AppUtils.isSystemAppOption(properties)) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0043E", new Object[]{localEarPath}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create new installscheduler");
        }
        InstallSchedulerImpl sch = new InstallSchedulerImpl(localEarPath, appName, properties, (AppManagement)this, notf);
        try {
            sch.setWorkSpaceID(workspaceID);
            this.runScheduler(sch);
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "_installApplication", "374", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_installAppliction");
            }
            throw new AdminException(th, AppUtils.getMessage(resBundle, "ADMA0044E", new Object[]{localEarPath}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_installAppliction");
        }
    }

    public void uninstallApplicationLocal(String appName, Hashtable props, AppNotification.Listener notf) throws AdminException {
        this._uninstallApplication(appName, props, notf, false, null);
    }

    public void uninstallApplicationLocal(String appName, Hashtable props, AppNotification.Listener notf, String workspaceID) throws AdminException {
        this._uninstallApplication(appName, props, notf, false, workspaceID);
    }

    public void uninstallApplication(String appName, Hashtable props, String workspaceID) throws AdminException {
        this._uninstallApplication(appName, props, null, true, workspaceID);
    }

    public void _uninstallApplication(String appName, Hashtable props, AppNotification.Listener notf, boolean isJMX, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_uninstallApplication " + appName);
        }
        ResourceBundle resBundle = AppUtils.getBundle(props);
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0094E", new Object[]{"uninstallApplication"}));
        }
        if (appName == null) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0045E"));
        }
        if (!isJMX && props == null) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0046E"));
        }
        final String appNameFinal = appName;
        final Hashtable propertiesFinal = props;
        final String workspaceIDFinal = workspaceID;
        String cellName = AppManagementImpl.getCellName();
        Vector uris = new Vector();
        boolean perm = AppUtils.checkCellLevelAdminAccess(cellName);
        if (!perm) {
            perm = AppUtils.checkAdminAccessApp(props, "deployer", appName);
        }
        if (!perm) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "check the target ");
            }
            try {
                Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        AppUtils.loadDeploymentsToWorkSpace(appNameFinal, propertiesFinal, workspaceIDFinal);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception ex = pae.getException();
                throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA0047E", new Object[]{appName}));
            }
            catch (Exception e) {
                throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA0047E", new Object[]{appName}));
            }
            perm = AppUtils.checkAdminAccessRemovedTarget(appName, props, "deployer", cellName, workspaceID, uris);
            if (!perm) {
                String uri = null;
                if (uris != null && uris.size() > 0) {
                    uri = (String)uris.get(0);
                }
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0188E", new Object[]{uri}));
            }
        }
        final AppNotification.Listener notfFinal = notf;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AppManagementImpl.this._uninstallApplicationAsSystem(appNameFinal, propertiesFinal, notfFinal, workspaceIDFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA0047E", new Object[]{appName}));
        }
        catch (Exception e) {
            throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA0047E", new Object[]{appName}));
        }
    }

    private void _uninstallApplicationAsSystem(String appName, Hashtable props, AppNotification.Listener notf, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_uninstallApplicationAsSystem " + appName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create new uninstallscheduler");
        }
        ResourceBundle resBundle = AppUtils.getBundle(props);
        UninstallSchedulerImpl sch = new UninstallSchedulerImpl(appName, props, this, notf);
        try {
            sch.setWorkSpaceID(workspaceID);
            this.runScheduler(sch);
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "_uninstallApplication", "520", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_uninstallAppliction");
            }
            throw new AdminException(th, AppUtils.getMessage(resBundle, "ADMA0047E", new Object[]{appName}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_uninstallApplicationAsSystem " + appName);
        }
    }

    public void redeployApplicationLocal(String localEarPath, String appName, Hashtable properties, AppNotification.Listener notf, String workspaceID) throws AdminException {
        if (AppUtils.isEntitled()) {
            ResourceBundle resBundle = AppUtils.getBundle(properties);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA9008E", new Object[]{"redeployApplication"}));
        }
        if (this.isReadOnlyMode()) {
            ResourceBundle resBundle = AppUtils.getBundle(properties);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0094E", new Object[]{"redeployApplication"}));
        }
        RedeploymentManager man = new RedeploymentManager(localEarPath, appName, properties, workspaceID, notf, true, this);
        man.performTask();
    }

    public void redeployApplication(String localEarPath, String appName, Hashtable properties, String workspaceID) throws AdminException {
        if (AppUtils.isEntitled()) {
            ResourceBundle resBundle = AppUtils.getBundle(properties);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA9008E", new Object[]{"redeployApplication"}));
        }
        if (this.isReadOnlyMode()) {
            ResourceBundle resBundle = AppUtils.getBundle(properties);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0094E", new Object[]{"redeployApplication"}));
        }
        String cellName = AppManagementImpl.getCellName();
        boolean perm = AppUtils.checkCellLevelAdminAccess(cellName);
        if (!perm) {
            perm = AppUtils.checkAdminAccessApp(properties, "deployer", appName);
            if (!perm) {
                ResourceBundle resBundle = AppUtils.getBundle(properties);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0187E", new Object[]{appName}));
            }
            Vector<String> uris = new Vector<String>();
            perm = AppUtils.checkAdminAccessChangedTarget(appName, properties, "deployer", cellName, workspaceID, uris);
            if (!perm) {
                ResourceBundle resBundle = AppUtils.getBundle(properties);
                String uri = null;
                if (uris != null && uris.size() > 0) {
                    uri = uris.get(0);
                }
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "deployer"}));
            }
        }
        RedeploymentManager man = new RedeploymentManager(localEarPath, appName, properties, workspaceID, null, false, this);
        man.performTask();
    }

    public Vector getApplicationInfo(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        return this._getApplicationInfo(appName, prefs, null, workspaceID);
    }

    public Vector getModuleInfo(String appName, Hashtable prefs, String uniqueModuleURI, String workspaceID) throws AdminException {
        return this._getApplicationInfo(appName, prefs, uniqueModuleURI, workspaceID);
    }

    private Vector _getApplicationInfo(String appName, Hashtable prefs, String uniqueModuleURI, String workspaceID) throws AdminException {
        String version;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationInfo:" + appName + ", " + uniqueModuleURI);
        }
        if (AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isServantJvm() && prefs != null && (version = (String)prefs.get("REQUEST_CLIENT_VERSION")) != null) {
            JMXVersionValidation versionValidation = new JMXVersionValidation();
            Tr.debug(tc, "client version is " + version);
            JMXVersionValidation.setClientVersion(version);
            prefs.remove("REQUEST_CLIENT_VERSION");
        }
        if (prefs == null) {
            prefs = new Hashtable();
        }
        EditApplication edit = new EditApplication(appName, prefs, uniqueModuleURI, workspaceID, this);
        Vector v = edit.getApplicationInfo();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationInfo");
        }
        return v;
    }

    public void setApplicationInfo(String appName, Hashtable prefs, String workspaceID, Vector tasks) throws AdminException {
        this._setApplicationInfo(appName, prefs, null, workspaceID, tasks);
    }

    public void setModuleInfo(String appName, Hashtable prefs, String uniqueModuleURI, String workspaceID, Vector tasks) throws AdminException {
        this._setApplicationInfo(appName, prefs, uniqueModuleURI, workspaceID, tasks);
    }

    private void _setApplicationInfo(String appName, Hashtable prefs, String uniqueModuleURI, String workspaceID, Vector tasks) throws AdminException {
        String cellName;
        boolean perm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_setApplicationInfo: " + appName + ", " + uniqueModuleURI);
        }
        if (!(perm = AppUtils.checkCellLevelAdminAccess(cellName = AppManagementImpl.getCellName()))) {
            perm = AppUtils.checkAdminAccessApp(prefs, "deployer", appName);
            if (!perm) {
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0170E", new Object[]{appName}));
            }
            String uri = "";
            Vector<String> urls = new Vector<String>();
            perm = AppUtils.checkAdminAccessChangedTarget(appName, prefs, "deployer", cellName, workspaceID, urls, tasks);
            if (!perm) {
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                if (urls != null && urls.size() > 0) {
                    uri = urls.get(0);
                }
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "deployer"}));
            }
        }
        EditApplication edit = new EditApplication(appName, prefs, uniqueModuleURI, workspaceID, this);
        edit.setApplicationInfo(tasks);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setApplicationInfo");
        }
    }

    public void moveModule(String appName, Hashtable prefs, String uniqueModuleURI, ObjectName on, String wID) throws AdminException {
    }

    public void exportApplication(String appName, String pathName, Hashtable prefs, String workspaceID) throws AdminException {
        boolean perm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportApplication: " + appName);
        }
        if (!(perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName))) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0190E", new Object[]{appName}));
        }
        EditApplication edit = new EditApplication(appName, prefs, null, workspaceID, this);
        edit.exportApplication(pathName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportApplication: " + appName);
        }
    }

    public void extractDDL(String appName, String ddlPrefix, String dirName, Hashtable prefs, String workspaceID) throws AdminException {
        boolean perm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractDDL: " + appName);
        }
        if (!(perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName))) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0190E", new Object[]{appName}));
        }
        EditApplication edit = new EditApplication(appName, prefs, null, workspaceID, this);
        edit.extractDDL(ddlPrefix, dirName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractDDL: " + appName);
        }
    }

    public void publishWSDL(String appName, String pathName, Hashtable prefs, String workspaceID) throws AdminException {
        boolean perm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publishWSDL: " + appName);
        }
        if (!(perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName))) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0190E", new Object[]{appName}));
        }
        EditApplication edit = new EditApplication(appName, prefs, null, workspaceID, this);
        edit.publishWSDL(pathName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishWSDL: " + appName);
        }
    }

    public Vector listSystemApplications(Hashtable prefs, String wID) throws AdminException {
        Vector v;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listSystemApplications");
            }
            String cellName = AppManagementImpl.getCellName();
            String uri = "cells/" + cellName;
            boolean perm = AppUtils.checkAdminAccess("monitor", uri);
            if (!perm) {
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0192E", new Object[]{uri, "monitor", "System Application"}));
            }
            v = new Vector();
            try {
                v = AppUtils.listSystemApps(prefs, wID);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception from listSystemApps " + e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listSystemApplications: " + v);
        }
        return v;
    }

    public Vector listApplicationsAsSystem(Hashtable prefs, String wID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listApplications");
        }
        Vector v = EditApplication.listApplications(prefs, wID, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listApplications: " + v);
        }
        return v;
    }

    public Vector listApplications(Hashtable prefs, String wID) throws AdminException {
        ResourceBundle resBundle = AppUtils.getBundle(prefs);
        final Hashtable prefFinal = prefs;
        final String workspaceIDFinal = wID;
        Vector v = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            v = (Vector)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AppManagementImpl.this.listApplicationsAsSystem(prefFinal, workspaceIDFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA0044E", new Object[]{null}));
        }
        catch (Exception e) {
            throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA0044E", new Object[]{null}));
        }
        String cellName = AppManagementImpl.getCellName();
        String uri = "cells/" + cellName;
        boolean perm = AppUtils.checkAdminAccess("monitor", uri);
        if (!perm) {
            String appName = null;
            Vector urls = new Vector();
            for (int i = v.size() - 1; i >= 0; --i) {
                final String appNameFinal = appName = (String)v.get(i);
                perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName);
                if (perm) continue;
                try {
                    Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                    ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            AppUtils.loadDeploymentsToWorkSpace(appNameFinal, prefFinal, workspaceIDFinal);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception ex = pae.getException();
                    throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA0047E", new Object[]{appName}));
                }
                catch (Exception e) {
                    throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA0047E", new Object[]{appName}));
                }
                perm = AppUtils.checkAdminAccessRemovedTarget(appName, prefs, "deployer", cellName, wID, urls);
                if (perm) continue;
                v.removeElementAt(i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listApplications: " + v);
        }
        return v;
    }

    public Object listModules(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        boolean perm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listModules: " + appName);
        }
        if (!(perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName))) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0190E", new Object[]{appName}));
        }
        EditApplication edit = new EditApplication(appName, prefs, null, workspaceID, this);
        AppDeploymentTask t = edit.listModules();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listModules: " + appName + ", " + t);
        }
        return t;
    }

    public List listURIs(String appName, String moduleURI, Hashtable prefs, String sessionID) throws AdminException {
        boolean perm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listURIs: " + appName + ", " + moduleURI);
        }
        if (!(perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName))) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0190E", new Object[]{appName}));
        }
        EditApplication edit = new EditApplication(appName, prefs, moduleURI, sessionID, this);
        List l = edit.listURIs();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listURIs");
        }
        return l;
    }

    public void removeAllAppsFromNode(String nodeName, String cellName, Hashtable prefs, String wID) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0094E", new Object[]{"removeAllAppsFromNode"}));
        }
        String uri = "cells/" + cellName;
        boolean perm = AppUtils.checkCellLevelAdminAccess(cellName);
        if (!perm) {
            perm = AppUtils.checkAdminAccess("deployer", uri = uri + "/nodes/" + nodeName);
            if (!perm) {
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "deployer"}));
            }
            Hashtable tbl = new Hashtable(10);
            String target = "WebSphere:cell=" + cellName + ",node=" + nodeName;
            Vector alist = EditApplication.listApplications(target, prefs, wID);
            String appName = null;
            for (int i = 0; i < alist.size(); ++i) {
                appName = (String)alist.get(i);
                perm = AppUtils.checkAdminAccessApp(prefs, "deployer", appName);
                if (perm) continue;
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0170E", new Object[]{appName}));
            }
        }
        AppAssociation aps = new AppAssociation(this, prefs, wID);
        aps.removeAllAppsFromNode(nodeName, cellName);
    }

    public void removeAllAppsFromServer(ObjectName objectName, Hashtable prefs, String wID) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0094E", new Object[]{"removeAllAppsFromServer"}));
        }
        String cName = objectName.getKeyProperty("cell");
        Object ws = null;
        boolean perm = AppUtils.checkCellLevelAdminAccess(cName);
        if (!perm) {
            String nName = objectName.getKeyProperty("node");
            String sName = objectName.getKeyProperty("server");
            String uri = "/cells/" + cName + "/nodes/" + nName + "/servers/" + sName;
            perm = AppUtils.checkAdminAccess("deployer", uri);
            if (!perm) {
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "deployer"}));
            }
            Vector apps = EditApplication.listApplications(uri, prefs, wID);
            for (int i = 0; i < apps.size(); ++i) {
                String appName = (String)apps.get(i);
                perm = AppUtils.checkAdminAccessApp(prefs, "deployer", appName);
                if (perm) continue;
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0170E", new Object[]{appName}));
            }
        }
        AppAssociation aps = new AppAssociation(this, prefs, wID);
        aps.removeAllAppsFromServer(objectName);
    }

    public void removeAllAppsFromCluster(ObjectName objectName, Hashtable prefs, String wID) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0094E", new Object[]{"removeAllAppsFromCluster"}));
        }
        String cName = objectName.getKeyProperty("cell");
        Object ws = null;
        boolean perm = AppUtils.checkCellLevelAdminAccess(cName);
        if (!perm) {
            String clName = objectName.getKeyProperty("cluster");
            String uri = "/cells/" + cName + "/clusters/" + clName;
            Vector apps = EditApplication.listApplications(uri, prefs, wID);
            for (int i = 0; i < apps.size(); ++i) {
                String appName = (String)apps.get(i);
                perm = AppUtils.checkAdminAccessApp(prefs, "deployer", appName);
                if (perm) continue;
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0170E", new Object[]{appName}));
            }
        }
        AppAssociation aps = new AppAssociation(this, prefs, wID);
        aps.removeAllAppsFromCluster(objectName);
    }

    public void changeServerToCluster(ObjectName serverName, ObjectName clusterName, Hashtable prefs, String wID) throws AdminException {
        String cName = serverName.getKeyProperty("cell");
        Object ws = null;
        boolean perm = AppUtils.checkCellLevelAdminAccess(cName);
        if (!perm) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            String uri = "/cell/" + cName;
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "configurator"}));
        }
        AppAssociation aps = new AppAssociation(this, prefs, wID);
        aps.changeServerToCluster(serverName, clusterName);
    }

    public void clusterMemberAdded(ObjectName memberName, ObjectName clusterName, Hashtable prefs, String wID) throws AdminException {
        String cName = memberName.getKeyProperty("cell");
        Object ws = null;
        boolean perm = AppUtils.checkCellLevelAdminAccess(cName);
        if (!perm) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            String uri = "/cell/" + cName;
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "configurator"}));
        }
        AppAssociation aps = new AppAssociation(this, prefs, wID);
        aps.clusterMemberAdded(memberName, clusterName);
    }

    public void updateAccessIDs(String appName, Boolean bAll, Hashtable prefs, String wID) throws AdminException {
        String cellName = AppManagementImpl.getCellName();
        boolean perm = AppUtils.checkCellLevelAdminAccess(cellName);
        if (!perm && !(perm = AppUtils.checkAdminAccessApp(prefs, "deployer", appName))) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0193E", new Object[]{appName}));
        }
        EditApplication edit = new EditApplication(appName, prefs, null, wID, this);
        edit.updateAccessIDs(bAll);
    }

    public void deleteUserAndGroupEntries(String appName, Hashtable prefs, String wID) throws AdminException {
        String cellName = AppManagementImpl.getCellName();
        boolean perm = AppUtils.checkCellLevelAdminAccess(cellName);
        if (!perm && !(perm = AppUtils.checkAdminAccessApp(prefs, "deployer", appName))) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0193E", new Object[]{appName}));
        }
        EditApplication edit = new EditApplication(appName, prefs, null, wID, this);
        edit.deleteUserAndGroupEntries();
    }

    public String startApplication(String appName, Hashtable prefs, String wID) throws AdminException {
        return this.startApplication(appName, null, prefs, wID);
    }

    public String startApplication(String appName, String target, Hashtable prefs, String wID) throws AdminException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startApplication: " + appName);
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"startApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (appName == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        if (!AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess")) {
            AdminHelper.getInstance().audit("ADMN1008I", "ADMN1009I", new Object[]{appName, null});
        }
        WorkSpace ws = null;
        try {
            ws = ConfigRepoHelper.getWorkSpace(wID);
            RepositoryContext rc = AppUtils.findAppContextFromConfig(appName, ws, prefs);
            if (rc == null) {
                throw new AdminException(nls.getFormattedMessage("ADMA0017E", new Object[]{appName}, "Unable to obtain context for {0}, , the application does not appear to be installed."));
            }
            RepositoryContext cellC = rc.getParent().getParent();
            Vector serverRC = null;
            if (target != null) {
                serverRC = ConfigRepoHelper.getServerNames(target, appName, false, cellC, ws);
            } else {
                ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
                serverRC = ConfigRepoHelper.getServersForAppDeployment(appDepl, null, cellC, ws, false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "All targets: " + serverRC);
                }
            }
            string = this._startApplication(appName, serverRC, ws, prefs);
            Object var11_11 = null;
        }
        catch (Throwable th) {
            try {
                RasUtils.logException(th, tc, CLASS_NAME, "startApplication", "1202", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception thrown in startApplication: " + th);
                }
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, "");
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                AppManagementImpl.discardWorkSpace(wID, ws);
                throw throwable;
            }
        }
        AppManagementImpl.discardWorkSpace(wID, ws);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _startApplication(String appName, Vector v, WorkSpace ws, Hashtable pr) throws Exception {
        String string;
        block19: {
            Hashtable prefs;
            RepositoryContext rcApp;
            Properties editionProps;
            String cellName = AppManagementImpl.getCellName();
            String uri = "cells/" + cellName;
            boolean perm = AppUtils.checkAdminAccess("operator", uri);
            if (!(perm || (perm = AppUtils.checkAdminAccess("deployer", uri)) || (perm = AppUtils.checkAdminAccessApp(pr, "operator", appName)) || (perm = AppUtils.checkAdminAccessApp(pr, "deployer", appName)))) {
                ResourceBundle resBundle = AppUtils.getBundle(pr);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0194E", new Object[]{appName}));
            }
            RepositoryContext rc = null;
            v = ConfigRepoHelper.getAllServers(ws, v);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All server targets: " + v);
            }
            if (EditionHelper.isEditionSupportEnabled() && (editionProps = AppUtils.getEditionProps(rcApp = AppUtils.findAppContextFromConfig(appName, ws, prefs = new Hashtable()))) != null) {
                String editionPropName = EditionHelper.getEditionStatePropName(appName);
                String editionState = (String)editionProps.get(editionPropName);
                if (editionState == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "_startApplication");
                    }
                    throw new AdminException("Application " + appName + " is not active");
                }
                if (!editionState.equalsIgnoreCase("ACTIVE")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "_startApplication");
                    }
                    throw new AdminException("Application " + appName + " is not active");
                }
            }
            Subject subject = SecurityHelper.retrieveSubject();
            String started = null;
            if (subject != null) {
                subject = SecurityHelper.pushInvocationSubject(subject);
            }
            try {
                boolean isDetailedStatusEnabled = false;
                if (pr != null && pr.containsKey("provideDetailedAppStatus") && pr.get("provideDetailedAppStatus").equals("true")) {
                    isDetailedStatusEnabled = true;
                }
                for (int i = 0; i < v.size(); ++i) {
                    rc = (RepositoryContext)v.elementAt(i);
                    ObjectName on = new ObjectName("WebSphere:type=ApplicationManager,node=" + rc.getParent().getName() + ",process=" + rc.getName() + ",*");
                    try {
                        Iterator itr = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                        if (itr.hasNext()) {
                            on = (ObjectName)itr.next();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Starting app: " + appName + " using " + on);
                            }
                            AdminServiceFactory.getAdminService().invoke(on, "startApplication", new Object[]{appName}, new String[]{String.class.getName()});
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Started app: " + appName + " using " + on);
                            }
                            started = ConfigRepoHelper.getTargetString(on, started);
                            if (!isDetailedStatusEnabled) continue;
                            started = started + ",status=success";
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No ApplicationManager MBean on: " + rc);
                        }
                        if (!isDetailedStatusEnabled) continue;
                        started = ConfigRepoHelper.getTargetString(on, started) + ",status=" + "unknown";
                        continue;
                    }
                    catch (Throwable th) {
                        Tr.warning(tc, "Unable to start: " + appName + " using: " + on + " exception is: " + th);
                        if (isDetailedStatusEnabled) {
                            Throwable cause = th.getCause();
                            String info = cause == null ? "unknownException" : cause.getLocalizedMessage();
                            started = ConfigRepoHelper.getTargetString(on, started) + ",status=" + "failure" + ",info=" + "\"" + info + "\"";
                        }
                        RasUtils.logException(th, tc, CLASS_NAME, "startApplication", "1332", this);
                    }
                }
                string = started;
                Object var18_22 = null;
                if (subject == null) break block19;
            }
            catch (Throwable throwable) {
                block20: {
                    Object var18_23 = null;
                    if (subject == null) break block20;
                    SecurityHelper.popInvocationSubject(subject);
                }
                throw throwable;
            }
            SecurityHelper.popInvocationSubject(subject);
        }
        return string;
    }

    public String stopApplication(String appName, Hashtable prefs, String wID) throws AdminException {
        return this.stopApplication(appName, null, prefs, wID);
    }

    public String stopApplication(String appName, String target, Hashtable prefs, String wID) throws AdminException {
        String string;
        WorkSpace ws;
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopApplication: " + appName);
            }
            if (AppManagementImpl.isLocalMode()) {
                throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"stopApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
            }
            if (appName == null) {
                throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
            }
            if (!AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess")) {
                AdminHelper.getInstance().audit("ADMN1010I", "ADMN1011I", new Object[]{appName, null});
            }
            ws = null;
            Subject subject = null;
            try {
                ws = ConfigRepoHelper.getWorkSpace(wID);
                RepositoryContext rc = AppUtils.findAppContextFromConfig(appName, ws, prefs);
                if (rc == null) {
                    throw new AdminException(nls.getFormattedMessage("ADMA0017E", new Object[]{appName}, "Unable to obtain context for {0}, the application does not appear to be installed."));
                }
                boolean isDetailedStatusEnabled = false;
                if (prefs != null && prefs.containsKey("provideDetailedAppStatus") && prefs.get("provideDetailedAppStatus").equals("true")) {
                    isDetailedStatusEnabled = true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopApplication: isDetailEnabled = " + isDetailedStatusEnabled);
                }
                HashSet<ObjectName> appsToStop = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopApplication: target = " + target);
                }
                if (target == null && !isDetailedStatusEnabled) {
                    subject = SecurityHelper.retrieveSubject();
                    if (subject != null) {
                        subject = SecurityHelper.pushInvocationSubject(subject);
                    }
                    ObjectName on = new ObjectName("WebSphere:type=Application,name=" + appName + ",*");
                    appsToStop = AdminServiceFactory.getAdminService().queryNames(on, null);
                } else {
                    Vector serverRC = null;
                    RepositoryContext cellC = rc.getParent().getParent();
                    if (isDetailedStatusEnabled && target == null) {
                        ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
                        serverRC = ConfigRepoHelper.getServersForAppDeployment(appDepl, null, cellC, ws, false);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "All server targets with detail: " + serverRC);
                        }
                    } else {
                        cellC = rc.getParent().getParent();
                        serverRC = ConfigRepoHelper.getServerNames(target, appName, false, cellC, ws);
                    }
                    Vector allServers = ConfigRepoHelper.getAllServers(ws, serverRC);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "All server targets: " + allServers);
                    }
                    appsToStop = new HashSet<ObjectName>();
                    for (int i = 0; i < allServers.size(); ++i) {
                        rc = (RepositoryContext)allServers.elementAt(i);
                        ObjectName on = new ObjectName("WebSphere:type=Application,name=" + appName + ",node=" + rc.getParent().getName() + ",process=" + rc.getName() + ",*");
                        appsToStop.add(on);
                    }
                }
                string = this._stopApplication(appName, appsToStop, prefs, wID);
                Object var16_16 = null;
                if (subject == null) break block23;
            }
            catch (Throwable th) {
                try {
                    RasUtils.logException(th, tc, CLASS_NAME, "stopApplication", "1425", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception thrown in stopApplication: " + th);
                    }
                    if (th instanceof AdminException) {
                        throw (AdminException)th;
                    }
                    throw new AdminException(th, "");
                }
                catch (Throwable throwable) {
                    Object var16_17 = null;
                    if (subject != null) {
                        SecurityHelper.popInvocationSubject(subject);
                    }
                    AppManagementImpl.discardWorkSpace(wID, ws);
                    throw throwable;
                }
            }
            SecurityHelper.popInvocationSubject(subject);
        }
        AppManagementImpl.discardWorkSpace(wID, ws);
        return string;
    }

    private String _stopApplication(String appName, Set appsToStop, Hashtable prefs, String wID) throws AdminException {
        String string;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "_stopApplication: " + appName);
            }
            String cellName = AppManagementImpl.getCellName();
            String uri = "cells/" + cellName;
            boolean perm = AppUtils.checkAdminAccess("operator", uri);
            if (!perm && !(perm = AppUtils.checkAdminAccessApp(prefs, "deployer", appName))) {
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0194E", new Object[]{appName}));
            }
            String stopped = null;
            Subject subject = SecurityHelper.retrieveSubject();
            try {
                if (subject != null) {
                    subject = SecurityHelper.pushInvocationSubject(subject);
                }
                for (ObjectName on : appsToStop) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stopping: " + on);
                    }
                    on = new ObjectName("WebSphere:type=ApplicationManager,node=" + on.getKeyProperty("node") + ",process=" + on.getKeyProperty("process") + ",*");
                    boolean isDetailedStatusEnabled = false;
                    if (prefs != null && prefs.containsKey("provideDetailedAppStatus") && prefs.get("provideDetailedAppStatus").equals("true")) {
                        isDetailedStatusEnabled = true;
                    }
                    try {
                        Iterator amItr = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                        if (amItr.hasNext()) {
                            on = (ObjectName)amItr.next();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Stopping app: " + appName + " using " + on);
                            }
                            AdminServiceFactory.getAdminService().invoke(on, "stopApplication", new Object[]{appName}, new String[]{String.class.getName()});
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Stopped app: " + appName + " using " + on);
                            }
                            stopped = ConfigRepoHelper.getTargetString(on, stopped);
                            if (!isDetailedStatusEnabled) continue;
                            stopped = stopped + ",status=success";
                            continue;
                        }
                        Tr.warning(tc, "ADMA0118W", new Object[]{on});
                        if (!isDetailedStatusEnabled) continue;
                        stopped = ConfigRepoHelper.getTargetString(on, stopped) + ",status=" + "unknown";
                    }
                    catch (Throwable th) {
                        Tr.warning(tc, "ADMA0117W", new Object[]{appName, on, th});
                        if (isDetailedStatusEnabled) {
                            Throwable cause = th.getCause();
                            String info = cause == null ? "unknownException" : cause.getLocalizedMessage();
                            stopped = ConfigRepoHelper.getTargetString(on, stopped) + ",status=" + "failure" + ",info=" + "\"" + info + "\"";
                        }
                        RasUtils.logException(th, tc, CLASS_NAME, "stopApplication", "1501", this);
                    }
                }
                string = stopped;
                Object var17_19 = null;
                if (subject == null) break block18;
            }
            catch (Throwable th) {
                try {
                    RasUtils.logException(th, tc, CLASS_NAME, "stopApplication", "1508", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception thrown in stopApplication: " + th);
                    }
                    if (th instanceof AdminException) {
                        throw (AdminException)th;
                    }
                    throw new AdminException(th, "");
                }
                catch (Throwable throwable) {
                    block19: {
                        Object var17_20 = null;
                        if (subject == null) break block19;
                        SecurityHelper.popInvocationSubject(subject);
                    }
                    throw throwable;
                }
            }
            SecurityHelper.popInvocationSubject(subject);
        }
        return string;
    }

    public void installStandaloneRAR(String rarPath, Hashtable props, String workspaceID) throws AdminException {
    }

    public Vector compareSecurityPolicy(String policyData, Hashtable preferences, String workspaceID) throws AdminException {
        ResourceBundle resBundle = AppUtils.getBundle(preferences);
        final String policyDataFinal = policyData;
        final Hashtable preferencesFinal = preferences;
        final String workspaceIDFinal = workspaceID;
        Vector retVal = new Vector();
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            retVal = (Vector)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AppManagementImpl.this.compareSecurityPolicyAsSystem(policyDataFinal, preferencesFinal, workspaceIDFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            retVal.addElement(AppUtils.getMessage(resBundle, "ADMA0180E"));
            if (ex instanceof AdminException) {
                throw (AdminException)ex;
            }
        }
        catch (Exception e) {
            retVal.addElement(AppUtils.getMessage(resBundle, "ADMA0181E", new Object[]{e}));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector compareSecurityPolicyAsSystem(String policyData, Hashtable preferences, String workspaceID) throws AdminException {
        ResourceBundle resBundle;
        Vector<String> customPerms;
        Vector<String> permissionsInFilter;
        Vector<String> retVal;
        block24: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "compareSecurityPolicy");
            }
            retVal = new Vector<String>();
            permissionsInFilter = new Vector<String>();
            customPerms = new Vector<String>();
            resBundle = AppUtils.getBundle(preferences);
            if (policyData != null && !policyData.trim().equals("")) {
                WorkSpace ws;
                block23: {
                    Object cName;
                    block22: {
                        ws = null;
                        try {
                            try {
                                ws = ConfigRepoHelper.getWorkSpace(workspaceID);
                                RepositoryContext context = null;
                                Object[] contexts = AppUtils.getContextArray("cells", null, ws);
                                if (contexts != null) {
                                    cName = (String)preferences.get("cell.name");
                                    context = cName != null ? AppUtils.getContextFromArray(contexts, (String)cName, null, true) : (RepositoryContext)contexts[0];
                                }
                                if (contexts == null || context == null) {
                                    Tr.warning(tc, "ADMA0070W");
                                    retVal.addElement(AppUtils.getMessage(resBundle, "ADMA0070W"));
                                    cName = retVal;
                                    Object var32_13 = null;
                                    break block22;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "context found: " + context);
                                }
                                if (context.isAvailable("filter.policy")) {
                                    context.extract("filter.policy", false);
                                    InputStream inStream = context.getInputStream("filter.policy");
                                    InputStreamReader filterRdr = new InputStreamReader(inStream);
                                    String s = Security.getProperty("policy.expandProperties");
                                    boolean expandProp = false;
                                    if (s != null) {
                                        expandProp = s.equalsIgnoreCase("true");
                                    }
                                    FilterPolicyParser parser2 = new FilterPolicyParser(filterRdr, expandProp);
                                    parser2.parse();
                                    ArrayList filterPermissions = parser2.getFilterPermissions();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Permissions to be filtered: " + filterPermissions);
                                    }
                                    inStream.close();
                                    byte[] barray = policyData.getBytes();
                                    ByteArrayInputStream policyStream = new ByteArrayInputStream(barray);
                                    InputStreamReader policyRdr = new InputStreamReader(policyStream);
                                    ApplicationPolicyParser appParser = new ApplicationPolicyParser(policyRdr, expandProp);
                                    appParser.parse();
                                    PolicyTemplate pTemplate = appParser.getPolicyTemplate();
                                    String[] symbols = pTemplate.getSymbols();
                                    for (int i = 0; i < symbols.length; ++i) {
                                        ArrayList permissions = pTemplate.get(symbols[i]);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Permissions for symbol " + symbols[i] + ": " + permissions);
                                        }
                                        Iterator iter = permissions.iterator();
                                        while (iter.hasNext()) {
                                            boolean notImpliesFlag = true;
                                            Permission permission = (Permission)iter.next();
                                            String permString = permission.toString();
                                            if (!(permString.startsWith("(java") || permString.startsWith("(javax") || permString.startsWith("(unresolved java") || permString.startsWith("(unresolved javax"))) {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Custom permission found: " + permission);
                                                }
                                                customPerms.addElement(permString);
                                                continue;
                                            }
                                            Iterator itr = filterPermissions.iterator();
                                            while (itr.hasNext() && notImpliesFlag) {
                                                Permission fPermission = (Permission)itr.next();
                                                if (!fPermission.implies(permission)) continue;
                                                notImpliesFlag = false;
                                            }
                                            if (notImpliesFlag) continue;
                                            permissionsInFilter.addElement(permString);
                                        }
                                    }
                                }
                                break block23;
                            }
                            catch (Throwable th) {
                                retVal.addElement(AppUtils.getMessage(resBundle, "ADMA0071W", new Object[]{th.toString()}));
                                Tr.warning(tc, "ADMA0071W", th);
                                Object var32_15 = null;
                                AppManagementImpl.discardWorkSpace(workspaceID, ws);
                                break block24;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var32_16 = null;
                            AppManagementImpl.discardWorkSpace(workspaceID, ws);
                            throw throwable;
                        }
                    }
                    AppManagementImpl.discardWorkSpace(workspaceID, ws);
                    return cName;
                }
                Object var32_14 = null;
                AppManagementImpl.discardWorkSpace(workspaceID, ws);
            }
        }
        if (!permissionsInFilter.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "policy file contains filter permissions: " + permissionsInFilter);
            }
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0072E"));
        }
        if (!customPerms.isEmpty()) {
            retVal.addElement(AppUtils.getMessage(resBundle, "ADMA0073W", new Object[]{customPerms}));
            Tr.warning(tc, "ADMA0073W", customPerms);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareSecurityPolicy");
        }
        return retVal;
    }

    private boolean isReadOnlyMode() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.readOnlyPath + ", " + this.readOnly + ", " + this.readOnlyTimeStamp);
        }
        if (this.readOnlyPath == null) {
            this.findReadOnlyFiles(cl);
        } else {
            File file = new File(this.readOnlyPath);
            if (!file.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "File not found: " + this.readOnlyPath + ", so look again");
                }
                this.findReadOnlyFiles(cl);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "File exists: " + this.readOnlyPath);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "readOnlyTimeStamp: " + this.readOnlyTimeStamp);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "file.lastModified: " + file.lastModified());
                    }
                }
                if (file.lastModified() == this.readOnlyTimeStamp) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "lock not changed: " + this.readOnly);
                    }
                } else {
                    this.readOnly = AppManagementImpl.getReadOnlyFlag(file);
                    this.readOnlyTimeStamp = file.lastModified();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "timestamp changed: " + this.readOnly + ", " + this.readOnlyTimeStamp);
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "readOnly: " + this.readOnly);
        }
        return this.readOnly;
    }

    private void findReadOnlyFiles(ClassLoader cl) {
        Enumeration<URL> enumUrl;
        block19: {
            block18: {
                enumUrl = null;
                try {
                    enumUrl = cl.getResources(PROPERTIES_PATH_EXT);
                }
                catch (IOException io) {
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Ignoring exception:  " + io.getMessage());
                }
            }
            if (enumUrl == null || !enumUrl.hasMoreElements()) {
                try {
                    enumUrl = cl.getResources(PROPERTIES_PATH);
                }
                catch (IOException io) {
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "Ignoring exception:  " + io.getMessage());
                }
            }
        }
        if (enumUrl == null || !enumUrl.hasMoreElements()) {
            this.readOnlyTimeStamp = 0L;
            this.readOnly = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enumUrl not found");
            }
        } else {
            while (enumUrl.hasMoreElements()) {
                URL url = enumUrl.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "url: " + url);
                }
                if (url == null) {
                    this.readOnlyTimeStamp = 0L;
                    this.readOnly = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "empty url");
                    continue;
                }
                this.readOnlyPath = url.getFile();
                try {
                    this.readOnlyPath = URLDecoder.decode(this.readOnlyPath, "UTF-8");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Decoded url: " + this.readOnlyPath);
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exception in decoding url: " + ex);
                    }
                    RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "isReadOnlyMode", "1841", this);
                }
                File f = new File(this.readOnlyPath);
                this.readOnly = AppManagementImpl.getReadOnlyFlag(f);
                if (this.readOnly) continue;
                this.readOnlyTimeStamp = f.lastModified();
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "new: " + this.readOnlyPath + ", " + this.readOnly + ", " + this.readOnlyTimeStamp);
                break;
            }
            if (this.readOnly) {
                this.readOnlyTimeStamp = 0L;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "url not found");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "findReadOnlyFiles() readOnly: " + this.readOnly);
            }
        }
    }

    private static boolean getReadOnlyFlag(final File f) {
        boolean flag;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getReadOnlyFlag: " + f.getAbsolutePath());
        }
        Properties props = null;
        try {
            props = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() {
                    Properties properties;
                    Properties versionProps = new Properties();
                    FileInputStream in = null;
                    try {
                        try {
                            in = new FileInputStream(f);
                            if (in != null) {
                                versionProps.load(in);
                            }
                            properties = versionProps;
                            Object var6_5 = null;
                            if (in == null) return properties;
                        }
                        catch (Throwable th) {
                            RasUtils.logException(th, tc, CLASS_NAME, "getReadOnlyFlag", "1889", this);
                            Object var4_11 = null;
                            Object var6_6 = null;
                            if (in == null) return var4_11;
                            try {
                                ((InputStream)in).close();
                                return var4_11;
                            }
                            catch (IOException ioex) {
                                RasUtils.logException((Throwable)ioex, tc, CLASS_NAME, "getReadOnlyFlag", "1901", this);
                            }
                            return var4_11;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (in == null) throw throwable;
                        try {}
                        catch (IOException ioex) {
                            RasUtils.logException((Throwable)ioex, tc, CLASS_NAME, "getReadOnlyFlag", "1901", this);
                            throw throwable;
                        }
                        ((InputStream)in).close();
                        throw throwable;
                    }
                    try {}
                    catch (IOException ioex) {
                        RasUtils.logException((Throwable)ioex, tc, CLASS_NAME, "getReadOnlyFlag", "1901", this);
                        return properties;
                    }
                    ((InputStream)in).close();
                    return properties;
                }
            });
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "getReadOnlyFlag", "1911");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "props: " + props);
        }
        if (props == null) {
            flag = true;
        } else {
            if (!props.containsKey(VERSION_KEY)) {
                Tr.audit(tc, "ADMA0097I");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "props does not contains app.management.roam.key, flag=true");
                }
                return true;
            }
            String value = props.getProperty(VERSION_KEY);
            if (VERSION_VALUE.equals(value)) {
                flag = false;
            } else {
                flag = true;
                Tr.audit(tc, "ADMA0096I");
            }
        }
        if (flag) {
            Tr.audit(tc, "ADMA0097I");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "flag: " + flag);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hashtable searchJNDIReferences(List sList, String nodes, Hashtable prefs, String wID) throws AdminException {
        Hashtable<String, String> appList;
        block39: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "searchJNDIReferences: " + sList + " nodes: " + nodes + " prefs: " + prefs + " wID: " + wID);
            }
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            if (sList == null) {
                return null;
            }
            String cellName = AppManagementImpl.getCellName();
            String uri = "cells/" + cellName;
            boolean perm = AppUtils.checkAdminAccess("monitor", uri);
            if (!perm) {
                String[] tlists = nodes.split("\\+");
                ObjectName o = null;
                for (int i = 0; i < tlists.length; ++i) {
                    try {
                        o = new ObjectName(tlists[i]);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    cellName = o.getKeyProperty("cell");
                    uri = "cells/" + cellName;
                    String nodeName = o.getKeyProperty("node");
                    perm = AppUtils.checkAdminAccess("monitor", uri);
                    if (perm) continue;
                    Hashtable tbl = new Hashtable(10);
                    String target = "WebSphere:cell=" + cellName + ",node=" + nodeName;
                    Vector alist = EditApplication.listApplications(target, prefs, wID);
                    String appName = null;
                    for (int j = 0; j < alist.size(); ++j) {
                        appName = (String)alist.get(j);
                        perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName);
                        if (perm) continue;
                        throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0170E", new Object[]{appName, "monitor"}));
                    }
                }
            }
            appList = new Hashtable<String, String>(5);
            WorkSpace ws = null;
            try {
                try {
                    ws = ConfigRepoHelper.getWorkSpace(wID);
                    if (ws == null) {
                        Tr.error(tc, "ADMA0106E", wID);
                        throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0106E", new Object[]{wID}));
                    }
                    Hashtable pp = prefs;
                    if (pp == null) {
                        pp = new Hashtable();
                    }
                    String appName2222 = null;
                    String tmpStr = nodes;
                    String[] ps = new String[]{tmpStr};
                    if (tmpStr.indexOf(43) != -1) {
                        ps = tmpStr.split("\\+");
                    }
                    for (int j = 0; j < ps.length; ++j) {
                        ObjectName o = null;
                        try {
                            o = new ObjectName(ps[j]);
                            cellName = null;
                            String nodeName = null;
                            String serverName = null;
                            cellName = o.getKeyProperty("cell");
                            nodeName = o.getKeyProperty("node");
                            serverName = o.getKeyProperty("server");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cell =" + cellName + " node = " + nodeName + " server =" + serverName);
                            }
                            Vector apps = null;
                            String target = null;
                            target = nodeName != null ? "WebSphere:cell=" + cellName + ",node=" + nodeName : "WebSphere:cell=" + cellName;
                            apps = EditApplication.listApplications(target, pp, wID);
                            for (String appName2222 : apps) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "appName:" + appName2222);
                                }
                                Vector tasks = null;
                                tasks = this.getApplicationInfo(appName2222, pp, wID);
                                Object moduleURI = null;
                                AppDeploymentTask installTask = null;
                                StringBuffer buf = new StringBuffer();
                                for (int ii = 0; ii < tasks.size(); ++ii) {
                                    installTask = (AppDeploymentTask)tasks.elementAt(ii);
                                    String taskname = installTask.getName();
                                    if (taskname.equals("EmbeddedRar")) continue;
                                    String[] colNames = installTask.getColumnNames();
                                    int col = colNames.length;
                                    int jndiCol = -1;
                                    int djndiCol = -1;
                                    int moduleCol = -1;
                                    for (int mm = 0; mm < col; ++mm) {
                                        if ("module".equals(colNames[mm])) {
                                            moduleCol = mm;
                                        }
                                        if ("EJBModule".equals(colNames[mm])) {
                                            moduleCol = mm;
                                        }
                                        if ("JNDI".equals(colNames[mm])) {
                                            jndiCol = mm;
                                        }
                                        if (!"jndi.dest".equals(colNames[mm])) continue;
                                        djndiCol = mm;
                                    }
                                    if (jndiCol == -1 && djndiCol == -1) continue;
                                    String[][] taskData = installTask.getTaskData();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "jndi column found " + appName2222 + "  task: " + taskname);
                                    }
                                    if (taskData == null) continue;
                                    String str = null;
                                    String jName = null;
                                    String djName = null;
                                    boolean matched = false;
                                    for (int i = 1; i < taskData.length; ++i) {
                                        jName = taskData[i][jndiCol];
                                        if (djndiCol != -1) {
                                            djName = taskData[i][djndiCol];
                                        }
                                        if (tc.isDebugEnabled()) {
                                            if (jName != null) {
                                                Tr.debug(tc, "jndi name  " + jName);
                                            }
                                            if (djName != null) {
                                                Tr.debug(tc, "djndi name  " + djName);
                                            }
                                        }
                                        if (jName != null && sList.contains(jName)) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "data matched" + jName);
                                            }
                                            matched = true;
                                            str = "  " + taskname + " :";
                                            if (moduleCol != -1) {
                                                str = str + taskData[i][moduleCol];
                                            }
                                            str = str + " : [" + jName + "]\n";
                                        }
                                        if (djName == null || !sList.contains(djName)) continue;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "data matched" + djName);
                                        }
                                        matched = true;
                                        str = "  " + taskname + " :";
                                        if (moduleCol != -1) {
                                            str = str + taskData[i][moduleCol];
                                        }
                                        str = str + " : [" + djName + "]\n";
                                    }
                                    if (!matched) continue;
                                    buf.append(str);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "search result " + str);
                                }
                                String tstr = buf.toString();
                                if (tstr != null && tstr.length() != 0) {
                                    appList.put(appName2222, tstr);
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "List:" + appName2222 + " Ref:" + tstr);
                            }
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    Object var40_48 = null;
                }
                catch (Exception e) {
                    Tr.warning(tc, "ADMA0104W", e);
                    Object var40_49 = null;
                    AppManagementImpl.discardWorkSpace(wID, ws);
                    break block39;
                }
            }
            catch (Throwable throwable) {
                Object var40_50 = null;
                AppManagementImpl.discardWorkSpace(wID, ws);
                throw throwable;
            }
            AppManagementImpl.discardWorkSpace(wID, ws);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchJNDIReferences: " + appList);
        }
        return appList;
    }

    private boolean isFullUpdate(Hashtable props) {
        return props != null && "app".equals(props.get("contenttype"));
    }

    public void updateApplication(String appName, String contentURI, String pathToContents, String operation, Hashtable properties, String sessionID) throws AdminException {
        if (this.isFullUpdate(properties)) {
            if (operation != null && !"update".equals(operation)) {
                String message = AppUtils.getMessage(AppUtils.getBundle(properties), "ADMA9012E", new Object[]{operation});
                AppNotification notification = new AppNotification("UpdateApplication", "", "Failed", "", message);
                this.sendJMXEvent(notification);
                throw new AdminException(message);
            }
            this.redeployApplication(pathToContents, appName, properties, sessionID);
        } else {
            this._updateApplication(appName, contentURI, pathToContents, operation, properties, null, sessionID);
        }
    }

    public void updateApplicationLocal(String appName, String contentURI, String pathToContents, String operation, Hashtable properties, AppNotification.Listener notfListener, String sessionID) throws AdminException {
        if (this.isFullUpdate(properties)) {
            if (operation != null && !"update".equals(operation)) {
                String message = AppUtils.getMessage(AppUtils.getBundle(properties), "ADMA9012E", new Object[]{operation});
                AppNotification notification = new AppNotification("UpdateApplication", "", "Failed", "", message);
                notfListener.appEventReceived(notification);
                throw new AdminException(message);
            }
            this.redeployApplicationLocal(pathToContents, appName, properties, notfListener, sessionID);
        } else {
            this._updateApplication(appName, contentURI, pathToContents, operation, properties, notfListener, sessionID);
        }
    }

    public void _updateApplication(String appName, String contentURI, String pathToContents, String operation, Hashtable props, AppNotification.Listener notf, String sessionID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_updateApplication " + appName);
        }
        ResourceBundle resBundle = AppUtils.getBundle(props);
        if (AppUtils.isEntitled() && !appName.equalsIgnoreCase("isclite")) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA9008E", new Object[]{"updateApplication"}));
        }
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0094E", new Object[]{"updateApplication"}));
        }
        if (appName == null) {
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0045E"));
        }
        if (props == null) {
            props = new Hashtable();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create new updatescheduler");
        }
        String cellName = AppManagementImpl.getCellName();
        String uri = "cells/" + cellName;
        boolean perm = AppUtils.checkCellLevelAdminAccess(cellName);
        if (!perm) {
            perm = AppUtils.checkAdminAccessApp(props, "deployer", appName);
            resBundle = AppUtils.getBundle(props);
            if (!perm) {
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0170E", new Object[]{appName}));
            }
            uri = null;
            Vector<String> uris = new Vector<String>();
            if ("add".equals(operation)) {
                perm = AppUtils.checkAdminAccessTarget(props, "deployer", cellName, sessionID, uris);
                if (!perm) {
                    if (uris != null && uris.size() > 0) {
                        uri = uris.get(0);
                    }
                    throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "deployer"}));
                }
            } else if ("delete".equals(operation)) {
                perm = AppUtils.checkAdminAccessRemovedTargetForModule(appName, props, "deployer", cellName, sessionID, uris, contentURI);
                if (!perm) {
                    if (uris != null && uris.size() > 0) {
                        uri = uris.get(0);
                    }
                    throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "deployer"}));
                }
            } else if (("update".equals(operation) || "addupdate".equals(operation)) && !(perm = AppUtils.checkAdminAccessChangedTarget(appName, props, "deployer", cellName, sessionID, uris))) {
                if (uris != null && uris.size() > 0) {
                    uri = uris.get(0);
                }
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "deployer"}));
            }
        }
        UpdateSchedulerImpl sch = new UpdateSchedulerImpl(appName, contentURI, pathToContents, operation, props, this, notf);
        try {
            sch.setWorkSpaceID(sessionID);
            this.runScheduler(sch);
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "updateApplication", "2312", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_updateApplication");
            }
            throw new AdminException(th, AppUtils.getMessage(resBundle, "ADMA0047E", new Object[]{appName}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_updateApplication " + appName);
        }
    }

    public void updateClusterLocal(String[] appNames, Integer timeout, Hashtable props, String wsId, AppNotification.Listener notif) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateClusterLocal " + appNames);
        }
        this._updateCluster(appNames, timeout, props, wsId, notif);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateClusterLocal " + appNames);
        }
    }

    public void updateCluster(String[] appNames, Integer timeout, Hashtable props, String wsId) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCluster " + appNames);
        }
        this._updateCluster(appNames, timeout, props, wsId, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_updateCluster " + appNames);
        }
    }

    private void _updateCluster(String[] appNames, Integer timeout, Hashtable props, String wsId, AppNotification.Listener notif) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_updateCluster " + appNames);
        }
        ResourceBundle resBundle = AppUtils.getBundle(props);
        String cellName = AppManagementImpl.getCellName();
        String uri = "cells/" + cellName;
        boolean perm = AppUtils.checkCellLevelAdminAccess(cellName);
        if (!perm) {
            for (int i = 0; i < appNames.length; ++i) {
                String appName = appNames[i];
                perm = AppUtils.checkAdminAccessApp(props, "deployer", appName);
                if (perm) continue;
                resBundle = AppUtils.getBundle(props);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0170E", new Object[]{appName}));
            }
        }
        String concAppNames = new String();
        for (int i = 0; i < appNames.length; ++i) {
            concAppNames = concAppNames.concat(appNames[i]);
            if (i >= appNames.length - 1) continue;
            concAppNames = concAppNames.concat(";");
        }
        Tr.debug(tc, " in  _updateCluster -> LAUNCH_TIMEOUT " + timeout);
        props.put("LAUNCH_TIMEOUT", timeout);
        UpdateClusterScheduler sch = new UpdateClusterScheduler(appNames, concAppNames, props, this, notif);
        Locale locale = null;
        if (props != null) {
            locale = (Locale)props.get("app.client.locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        sch.setLocale(locale);
        try {
            sch.setWorkSpaceID(wsId);
            String pKey = AdminContext.peek();
            sch.setProfileKey(pKey);
            Thread thread2 = new Thread(sch);
            thread2.start();
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "_updateCluster", "2399", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_updateCluster");
            }
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0094E", new Object[]{"updateCluster"}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_updateCluster " + appNames);
        }
    }

    public List searchResources(String appName, Hashtable prefs, String wID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchResources(" + appName + "," + prefs + "," + wID + ")");
        }
        Hashtable pp = prefs;
        if (prefs == null) {
            pp = new Hashtable();
        }
        Vector tasks = null;
        tasks = this.getApplicationInfo(appName, pp, wID);
        List result = ResourceLookup.searchResources(appName, prefs, wID, tasks);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchResources returns : " + result);
        }
        return result;
    }

    public List convertRefToConfigID(String appName, List resources, Hashtable prefs, String wID) throws AdminException {
        boolean perm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertRefToConfigID(" + appName + "," + resources + "." + wID);
        }
        if (!(perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName))) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0190E", new Object[]{appName}));
        }
        List result = ResourceLookup.convertRefToConfigID(appName, resources, prefs, wID);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertRefToConfigID returns " + result);
        }
        return result;
    }

    public byte[] getApplicationContents(String appName, String uri, Hashtable prefs, String wID) throws AdminException {
        boolean perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName);
        if (!perm) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0190E", new Object[]{appName}));
        }
        EditApplication edit = new EditApplication(appName, prefs, null, wID, this);
        return edit.getApplicationContents(uri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getDistributionStatus(String appName, Hashtable prefs, String wID) throws AdminException {
        boolean perm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDistributionStatus " + appName);
        }
        if (!(perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName))) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0190E", new Object[]{appName}));
        }
        DistributionStatusSchedulerImpl sch = new DistributionStatusSchedulerImpl(appName, prefs, this, null);
        try {
            try {
                sch.setWorkSpaceID(wID);
                String pKey = AdminContext.peek();
                sch.setProfileKey(pKey);
                Thread thread2 = new Thread(sch);
                thread2.start();
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "getDistributionStatus", "2505", this);
                if (!(th instanceof AdminException)) throw new AdminException(th, th.getMessage());
                throw (AdminException)th;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "getDistributionStatus " + appName);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "getDistributionStatus " + appName);
    }

    public String[] getAppAssociation(String scope, String retVal, Hashtable prefs, String wID) throws AdminException {
        String cellName = AppManagementImpl.getCellName();
        String uri = "cells/" + cellName;
        boolean perm = AppUtils.checkAdminAccess("monitor", uri);
        if (!perm) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0171E", new Object[]{uri, "monitor"}));
        }
        EditApplication edit = new EditApplication(null, prefs, null, wID, this);
        return edit.getAppAssociation(scope, retVal);
    }

    public EditionInfo[] getEditionInfo(String appName, String edition, Hashtable prefs, String wID) throws AdminException {
        boolean perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName);
        if (!perm) {
            ResourceBundle resBundle = AppUtils.getBundle(prefs);
            throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0190E", new Object[]{appName}));
        }
        EditApplication edit = new EditApplication(appName, prefs, null, wID, this);
        return edit.getEditionInfo(edition);
    }

    public void setEditionInfo(EditionInfo[] info, Hashtable prefs, String wID) throws AdminException {
        String cellName = AppManagementImpl.getCellName();
        String uri = "cells/" + cellName;
        boolean perm = AppUtils.checkCellLevelAdminAccess(cellName);
        if (!perm) {
            String appName = null;
            for (int i = 0; i < info.length; ++i) {
                appName = info[i].getAppName();
                perm = AppUtils.checkAdminAccessApp(prefs, "deployer", appName);
                if (perm) continue;
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                throw new AdminException(AppUtils.getMessage(resBundle, "ADMA0193E", new Object[]{appName}));
            }
        }
        EditApplication edit = new EditApplication(null, prefs, null, wID, this);
        edit.setEditionInfo(info);
    }

    public Vector listApplications(String targetScope, Hashtable prefs, String wID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listApplications: target:" + targetScope);
        }
        ResourceBundle resBundle = AppUtils.getBundle(prefs);
        final String targetScopeFinal = targetScope;
        final Hashtable prefsFinal = prefs;
        final String workspaceIDFinal = wID;
        Vector v = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            v = (Vector)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AppManagementImpl.this.listApplicationsAsSystem(targetScopeFinal, prefsFinal, workspaceIDFinal);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA0044E", new Object[]{null}));
        }
        catch (Exception e) {
            throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA0044E", new Object[]{null}));
        }
        String cellName = AppManagementImpl.getCellName();
        String uri = "cells/" + cellName;
        boolean perm = AppUtils.checkAdminAccess("monitor", uri);
        if (!perm) {
            String appName = null;
            Vector urls = new Vector();
            for (int i = v.size() - 1; i >= 0; --i) {
                final String appNameFinal = appName = (String)v.get(i);
                perm = AppUtils.checkAdminAccessApp(prefs, "monitor", appName);
                if (perm) continue;
                try {
                    Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                    ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            AppUtils.loadDeploymentsToWorkSpace(appNameFinal, prefsFinal, workspaceIDFinal);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception ex = pae.getException();
                    throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA0047E", new Object[]{appName}));
                }
                catch (Exception e) {
                    throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA0047E", new Object[]{appName}));
                }
                perm = AppUtils.checkAdminAccessRemovedTarget(appName, prefs, "deployer", cellName, wID, urls);
                if (perm) continue;
                v.removeElementAt(i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listApplications: " + v);
        }
        return v;
    }

    public Vector listApplicationsAsSystem(String targetScope, Hashtable prefs, String wID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listApplications");
        }
        Vector v = EditApplication.listApplications(targetScope, prefs, wID, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listApplications: " + v);
        }
        return v;
    }

    public static String getCellName() {
        AdminService admin = AdminServiceFactory.getAdminService();
        String cellName = null;
        if (admin != null) {
            cellName = admin.getCellName();
        }
        if (cellName == null) {
            cellName = System.getProperty("local.cell");
        }
        return cellName;
    }

    private void runScheduler(Scheduler sch) {
        Hashtable props;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runScheduler");
        }
        if ((props = sch.getProperties()).get("J2ee_From_Bla") == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "spinning a new thread");
            }
            String pKey = AdminContext.peek();
            if (sch instanceof InstallSchedulerImpl) {
                ((InstallSchedulerImpl)sch).setProfileKey(pKey);
            } else if (sch instanceof UninstallSchedulerImpl) {
                ((UninstallSchedulerImpl)sch).setProfileKey(pKey);
            } else if (sch instanceof UpdateSchedulerImpl) {
                ((UpdateSchedulerImpl)sch).setProfileKey(pKey);
            }
            Thread thread2 = new Thread(sch);
            thread2.start();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "not spinning a new thread");
            }
            sch.run();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runScheduler");
        }
    }

    private static void discardWorkSpace(String workSpaceID, WorkSpace workSpace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discardWorkSpace", new String[]{"workSpaceID=" + workSpaceID, "workSpace=" + workSpace});
        }
        if (workSpace != null && workSpaceID == null) {
            try {
                ConfigRepoHelper.removeWorkSpace(false, workSpace);
            }
            catch (Throwable t) {
                RasUtils.logException(t, tc, CLASS_NAME, "discardWorkSpace", "2744", null, new Object[]{workSpaceID, workSpace});
                Tr.warning(tc, "ADMA0077W", t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discardWorkSpace");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/AppManagementImpl.java, WAS.admin.appmgmt, WAS70.SERV1, cf050925.09, ver. 1.117.4.2");
        }
        CLASS_NAME = AppManagementImpl.class.getName();
        nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.AppDeploymentMessages");
        seqNum = 0L;
    }
}

