/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.AppcfgFactory;
import com.ibm.websphere.models.config.appcfg.EJBModuleConfiguration;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appcfg.WebModuleConfig;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentFactory;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeployedObject;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.EJBModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.HostFactory;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.ConfigureTask;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class AppAssociation {
    private static TraceComponent tc = Tr.register(AppAssociation.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static AppdeploymentFactory appFactory;
    private static boolean isReg;
    AppManagementImpl appM;
    String workspaceID;
    Hashtable prefs;
    ResourceBundle resBundle;

    private static AppdeploymentFactory getAppFactory() {
        if (appFactory == null) {
            AppdeploymentPackage apppkg = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
            appFactory = apppkg.getAppdeploymentFactory();
        }
        return appFactory;
    }

    public AppAssociation(AppManagementImpl impl, Hashtable props, String wID) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppAssociation: , " + wID);
        }
        this.appM = impl;
        this.workspaceID = wID;
        this.prefs = props;
        this.resBundle = AppUtils.getBundle(this.prefs);
        if (!isReg) {
            ConfigInit.init();
            AppdeploymentPackage apppkg = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
            AppdeploymentPackageImpl.init();
            isReg = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppAssociation");
        }
    }

    public static void handleCatch(Throwable th, String mName, String n, Object o) throws AdminException {
        RasUtils.logException(th, tc, o.getClass().getName(), mName, n, o);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Exception thrown in " + mName + ": " + th);
        }
        if (th instanceof AdminException) {
            throw (AdminException)th;
        }
        throw new AdminException(th, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAllAppsFromNode(String nodeName, String cellName) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllAppsFromNode: " + nodeName + ", " + cellName);
        }
        WorkSpace ws = null;
        boolean bEx = false;
        try {
            block12: {
                try {
                    ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                    RepositoryContext cellC = AppUtils.findContext("cells", cellName, null, null, ws, true);
                    if (cellC == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{cellName}));
                    }
                    RepositoryContext nodeCtx = AppUtils.findContext("nodes", nodeName, null, cellC, ws, false);
                    if (nodeCtx == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5040E", new String[]{nodeName}));
                    }
                    URI uri = URI.createURI("serverindex.xml");
                    Resource res = nodeCtx.getResourceSet().getResource(uri, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found for node " + nodeCtx + " SI doc res: " + res);
                    }
                    if (res != null) {
                        ServerIndex top = (ServerIndex)res.getContents().get(0);
                        Vector<String> v = new Vector<String>();
                        EList entries = top.getServerEntries();
                        for (int i = 0; i < entries.size(); ++i) {
                            v.addElement(((ServerEntry)entries.get(i)).getServerName());
                        }
                        Hashtable<String, Vector<String>> tbl = new Hashtable<String, Vector<String>>();
                        tbl.put(nodeName, v);
                        this.removeAppAssociation(cellName, tbl, new Vector(), ws);
                        break block12;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting serverindex.xml");
                    }
                }
                catch (Throwable th) {
                    bEx = true;
                    AppAssociation.handleCatch(th, "removeAllAppsFromNode", "106", this);
                    Object var14_16 = null;
                    EditApplication.doFinally(ws, this.workspaceID, null, !bEx);
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "removeAllAppsFromNode");
                    return;
                }
            }
            Object var14_15 = null;
            bl = !bEx;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            EditApplication.doFinally(ws, this.workspaceID, null, !bEx);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "removeAllAppsFromNode");
            throw throwable;
        }
        EditApplication.doFinally(ws, this.workspaceID, null, bl);
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "removeAllAppsFromNode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAllAppsFromServer(ObjectName oName) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllAppsFromServer: " + oName);
        }
        WorkSpace ws = null;
        boolean bEx = false;
        try {
            try {
                ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                String cName = oName.getKeyProperty("cell");
                String nName = oName.getKeyProperty("node");
                String sName = oName.getKeyProperty("server");
                Vector<String> v = new Vector<String>();
                v.addElement(sName);
                Hashtable<String, Vector<String>> tbl = new Hashtable<String, Vector<String>>();
                tbl.put(nName, v);
                this.removeAppAssociation(cName, tbl, new Vector(), ws);
            }
            catch (Throwable th) {
                bEx = true;
                AppAssociation.handleCatch(th, "removeAllAppsFromServer", "106", this);
                Object var10_11 = null;
                EditApplication.doFinally(ws, this.workspaceID, null, !bEx);
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "removeAllAppsFromServer");
                return;
            }
            Object var10_10 = null;
            bl = !bEx;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            EditApplication.doFinally(ws, this.workspaceID, null, !bEx);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "removeAllAppsFromServer");
            throw throwable;
        }
        EditApplication.doFinally(ws, this.workspaceID, null, bl);
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "removeAllAppsFromServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAllAppsFromCluster(ObjectName oName) throws AdminException {
        block21: {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "removeAllAppsFromCluster: " + oName);
            }
            WorkSpace ws = null;
            boolean bEx = false;
            try {
                try {
                    ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                    String cName = oName.getKeyProperty("cell");
                    String clName = oName.getKeyProperty("cluster");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cName " + cName);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "clName " + clName);
                    }
                    RepositoryContext cellC = AppUtils.findContext("cells", cName, null, null, ws, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cellC " + cellC);
                    }
                    if (cellC == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{cName}));
                    }
                    Vector<String> v = new Vector<String>();
                    v.addElement(clName);
                    Hashtable<String, Vector<String>> tbl = new Hashtable<String, Vector<String>>();
                    RepositoryContext clusterC = AppUtils.findContext("clusters", clName, cName, cellC, ws, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "clusterC " + clusterC);
                    }
                    if (clusterC == null) {
                        Tr.warning(tc, AppUtils.getMessage(this.resBundle, "ADMA5051W", new Object[]{clName}));
                    } else {
                        EList l;
                        URI uri = URI.createURI("cluster.xml");
                        Resource res = clusterC.getResourceSet().getResource(uri, true);
                        ServerCluster clst = (ServerCluster)res.getContents().get(0);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cluster obj: " + clst);
                        }
                        if ((l = clst.getMembers()).isEmpty()) {
                            this.removeClusterDTFromDeployment(cellC, tbl, v, ws);
                        }
                        for (int lcv = 0; lcv < l.size(); ++lcv) {
                            Vector<String> svrs;
                            ClusterMember member = (ClusterMember)l.get(lcv);
                            String sName = member.getMemberName();
                            String nName = member.getNodeName();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "sName=" + sName + ",nName=" + nName);
                            }
                            if ((svrs = (Vector<String>)tbl.get(nName)) == null) {
                                svrs = new Vector<String>();
                                tbl.put(nName, svrs);
                            }
                            svrs.addElement(sName);
                        }
                    }
                    this.removeAppAssociation(cName, tbl, v, ws);
                }
                catch (Throwable th) {
                    bEx = true;
                    AppAssociation.handleCatch(th, "removeAllAppsFromCluster", "106", this);
                    Object var20_21 = null;
                    EditApplication.doFinally(ws, this.workspaceID, null, !bEx);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "removeAllAppsFromCluster");
                    }
                    break block21;
                }
                Object var20_20 = null;
                bl = !bEx;
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                EditApplication.doFinally(ws, this.workspaceID, null, !bEx);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeAllAppsFromCluster");
                }
                throw throwable;
            }
            EditApplication.doFinally(ws, this.workspaceID, null, bl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeAllAppsFromCluster");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllAppsFromCluster");
        }
    }

    private void removeClusterDTFromDeployment(RepositoryContext cellC, Hashtable node2svr, Vector clsts, WorkSpace ws) throws Exception {
        Object[] rcs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeClusterDTFromDeployment");
        }
        if ((rcs = AppUtils.getContextArray("deployments", cellC, ws)) != null) {
            for (int i = 0; i < rcs.length; ++i) {
                boolean saveDt;
                RepositoryContext rc = (RepositoryContext)rcs[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rc=" + rc);
                    Tr.debug(tc, "appname: " + rc.getName());
                }
                Resource res = ConfigRepoHelper.getAppDeploymentResource(rc);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "res " + res.getURI());
                }
                Deployment d = (Deployment)res.getContents().get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deployment " + d.toString());
                }
                if (!(saveDt = this.removeAppTargets(d, node2svr, clsts))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "saving deployment.xml ");
                }
                res.save(new HashMap(0));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeClusterDTFromDeployment");
        }
    }

    private void removeAppAssociation(String cellName, Hashtable node2svr, Vector clsts, WorkSpace ws) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAppAssociation: node2svr=" + node2svr + ",cellName=" + cellName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusters: " + clsts);
        }
        RepositoryContext cellC = AppUtils.findContext("cells", cellName, null, null, ws, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellC " + cellC);
        }
        Vector depls = new Vector();
        Vector deplsSysApp = new Vector();
        Enumeration en = node2svr.keys();
        HashMap options = new HashMap();
        while (en.hasMoreElements()) {
            RepositoryContext nodeCtx;
            String nName = (String)en.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nName " + nName);
            }
            Vector svrs = (Vector)node2svr.get(nName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "svrs " + svrs);
            }
            if ((nodeCtx = AppUtils.findContext("nodes", nName, null, cellC, ws, false)) == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, nName + " not found.");
                continue;
            }
            URI uri = URI.createURI("serverindex.xml");
            Resource res = nodeCtx.getResourceSet().getResource(uri, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found for node " + nodeCtx + " SI doc res: " + res);
            }
            ServerIndex top = (ServerIndex)res.getContents().get(0);
            EList entries = top.getServerEntries();
            for (int i = 0; i < entries.size(); ++i) {
                ServerEntry entry = (ServerEntry)entries.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerEntry " + entry.getServerName());
                }
                if (!svrs.contains(entry.getServerName())) continue;
                EList apps = entry.getDeployedApplications();
                while (apps.size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "app " + apps.get(0));
                    }
                    if (!depls.contains(apps.get(0))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "add to depls");
                        }
                        depls.add(apps.get(0));
                    }
                    apps.remove(0);
                }
            }
            res.save(new HashMap(0));
            URI uriSysApp = URI.createURI("systemapps.xml");
            Resource resSysApp = nodeCtx.getResourceSet().getResource(uriSysApp, true);
            if (resSysApp == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "systemapps.xml not found.");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found for node " + nodeCtx + " systemapp SI doc res: " + resSysApp);
            }
            ServerIndex topSysApp = (ServerIndex)resSysApp.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerIndex: " + topSysApp);
            }
            EList entriesSysApp = topSysApp.getServerEntries();
            for (int i = 0; i < entriesSysApp.size(); ++i) {
                ServerEntry entry = (ServerEntry)entriesSysApp.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerEntry: " + entry.getServerName());
                }
                if (!svrs.contains(entry.getServerName())) continue;
                EList apps = entry.getDeployedApplications();
                while (apps.size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "app " + apps.get(0));
                    }
                    if (!deplsSysApp.contains(apps.get(0))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "add to deplsSysApps");
                        }
                        deplsSysApp.add(apps.get(0));
                    }
                    apps.remove(0);
                }
                entriesSysApp.remove(entry);
            }
            resSysApp.save(new HashMap(0));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "depls: " + depls);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deplsSysApp: " + deplsSysApp);
        }
        for (int i = 0; i < depls.size(); ++i) {
            RepositoryContext rc = ConfigRepoHelper.getAppContextFromSIEntry((String)depls.elementAt(i), cellC, ws);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rc " + rc);
            }
            if (rc == null) {
                Tr.warning(tc, "ADMA5041E", new Object[]{depls.get(i), ""});
                continue;
            }
            Resource res = ConfigRepoHelper.getAppDeploymentResource(rc);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res " + res.getURI());
            }
            Deployment d = (Deployment)res.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deployment " + d.toString());
            }
            this.removeAppTargets(d, node2svr, clsts);
            res.save(new HashMap(0));
        }
    }

    private boolean removeAppTargets(Deployment d, Hashtable n2s, Vector clsts) throws Exception {
        int i;
        boolean dtChanges = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAppTargets");
        }
        EList dts = d.getDeploymentTargets();
        ArrayList<DeploymentTarget> removeDT = new ArrayList<DeploymentTarget>();
        for (int i2 = 0; i2 < dts.size(); ++i2) {
            DeploymentTarget dt = (DeploymentTarget)dts.get(i2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dt: " + dt.getName());
            }
            if (dt instanceof ClusteredTarget) {
                if (!clsts.contains(dt.getName())) continue;
                removeDT.add(dt);
                continue;
            }
            Vector svrs = (Vector)n2s.get(((ServerTarget)dt).getNodeName());
            if (svrs == null || !svrs.contains(dt.getName())) continue;
            removeDT.add(dt);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDT: " + removeDT);
        }
        this.removeDTFromDeployment(d.getDeployedObject(), removeDT);
        EList modDepl = ((ApplicationDeployment)d.getDeployedObject()).getModules();
        for (i = 0; i < modDepl.size(); ++i) {
            this.removeDTFromDeployment((DeployedObject)modDepl.get(i), removeDT);
        }
        for (i = 0; i < removeDT.size(); ++i) {
            d.getDeploymentTargets().remove(removeDT.get(i));
        }
        if (!removeDT.isEmpty()) {
            dtChanges = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dtChanges: " + dtChanges);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAppTargets");
        }
        return dtChanges;
    }

    private void removeDTFromDeployment(DeployedObject dObj, List removeDT) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDTFromDeployment");
        }
        for (int i = 0; i < dObj.getTargetMappings().size(); ++i) {
            DeploymentTargetMapping dtm = (DeploymentTargetMapping)dObj.getTargetMappings().get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dtm: " + dtm.getTarget().getName());
            }
            if (!removeDT.contains(dtm.getTarget())) continue;
            dObj.getTargetMappings().remove(dtm);
            --i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDTFromDeployment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changeServerToCluster(ObjectName serverName, ObjectName clusterName) throws AdminException {
        int i;
        Vector<RepositoryContext> v;
        Resource res;
        String clName;
        String sName;
        String nName;
        boolean bEx;
        WorkSpace ws;
        block19: {
            EList depls;
            RepositoryContext cellC;
            block18: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "changeServerToCluster: " + serverName + " -to-> " + clusterName);
                }
                ws = null;
                bEx = false;
                try {
                    try {
                        ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                        String cName = serverName.getKeyProperty("cell");
                        nName = serverName.getKeyProperty("node");
                        sName = serverName.getKeyProperty("server");
                        clName = clusterName.getKeyProperty("cluster");
                        cellC = AppUtils.findContext("cells", cName, null, null, ws, true);
                        if (cellC == null) {
                            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{cName}));
                        }
                        RepositoryContext nodeC = AppUtils.findContext("nodes", nName, cName, cellC, ws, true);
                        if (nodeC == null) {
                            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5052E", new Object[]{serverName}));
                        }
                        URI uri = URI.createURI("serverindex.xml");
                        res = nodeC.getResourceSet().getResource(uri, true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found for node " + nodeC + " SI doc res: " + res);
                        }
                        ServerIndex top = (ServerIndex)res.getContents().get(0);
                        v = new Vector<RepositoryContext>();
                        EList entries = top.getServerEntries();
                        for (i = 0; i < entries.size(); ++i) {
                            if (!((ServerEntry)entries.get(i)).getServerName().equals(sName)) continue;
                            depls = ((ServerEntry)entries.get(i)).getDeployedApplications();
                            break block18;
                        }
                        break block19;
                    }
                    catch (Throwable th) {
                        bEx = true;
                        AppAssociation.handleCatch(th, "changeServerToCluster", "106", this);
                        Object var24_29 = null;
                        EditApplication.doFinally(ws, this.workspaceID, null, !bEx);
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "changeServerToCluster");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var24_30 = null;
                    EditApplication.doFinally(ws, this.workspaceID, null, !bEx);
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit(tc, "changeServerToCluster");
                    throw throwable;
                }
            }
            for (int lcv = 0; lcv < depls.size(); ++lcv) {
                try {
                    RepositoryContext rc = ConfigRepoHelper.getAppContextFromSIEntry((String)depls.get(lcv), cellC, ws);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "rc: " + rc);
                    }
                    v.addElement(rc);
                    continue;
                }
                catch (Exception ex) {
                    Tr.warning(tc, AppUtils.getMessage(this.resBundle, "ADMA5053W", new Object[]{ex, depls.get(lcv)}));
                }
            }
        }
        for (i = 0; i < v.size(); ++i) {
            RepositoryContext rc = (RepositoryContext)v.elementAt(i);
            try {
                res = ConfigRepoHelper.getAppDeploymentResource(rc);
                Deployment d = (Deployment)res.getContents().get(0);
                ServerTarget sT = null;
                EList ts = d.getDeploymentTargets();
                for (int j = 0; j < ts.size(); ++j) {
                    ServerTarget t;
                    if (!(ts.get(j) instanceof ServerTarget) || !(t = (ServerTarget)ts.get(j)).getName().equals(sName) || !t.getNodeName().equals(nName)) continue;
                    sT = t;
                    break;
                }
                if (sT == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "ServerTarget not found for " + sName + "-" + nName + " in " + d);
                    continue;
                }
                ClusteredTarget t = AppAssociation.getAppFactory().createClusteredTarget();
                t.setName(clName);
                this.replaceTarget(sT, (DeploymentTarget)t, d);
                res.save(new HashMap(0));
                continue;
            }
            catch (Throwable th) {
                Tr.warning(tc, AppUtils.getMessage(this.resBundle, "ADMA5054W", new Object[]{th, rc.getName(), sName, clName}));
            }
        }
        Object var24_28 = null;
        EditApplication.doFinally(ws, this.workspaceID, null, !bEx);
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "changeServerToCluster");
    }

    private void replaceTarget(DeploymentTarget from, DeploymentTarget to, Deployment d) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceTarget: " + from);
        }
        d.getDeploymentTargets().add(to);
        this.replaceTarget(from, to, d.getDeployedObject());
        EList mods = ((ApplicationDeployment)d.getDeployedObject()).getModules();
        for (int i = 0; i < mods.size(); ++i) {
            this.replaceTarget(from, to, (DeployedObject)mods.get(i));
        }
        d.getDeploymentTargets().remove(from);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceTarget");
        }
    }

    private void replaceTarget(DeploymentTarget from, DeploymentTarget to, DeployedObject d) throws Exception {
        EList l = d.getTargetMappings();
        for (int i = 0; i < l.size(); ++i) {
            DeploymentTargetMapping map = (DeploymentTargetMapping)l.get(i);
            if (!map.getTarget().equals(from)) continue;
            map.setTarget(to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void clusterMemberAdded(ObjectName memberName, ObjectName clusterName) throws AdminException {
        block70: {
            if (AppAssociation.tc.isEntryEnabled()) {
                Tr.entry(AppAssociation.tc, "clusterMemberAdded: " + memberName + " to " + clusterName);
            }
            ws = null;
            bEx = false;
            try {
                block69: {
                    ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                    cName = memberName.getKeyProperty("cell");
                    nName = memberName.getKeyProperty("node");
                    sName = memberName.getKeyProperty("server");
                    clName = clusterName.getKeyProperty("cluster");
                    cellC = AppUtils.findContext("cells", cName, null, null, ws, true);
                    if (cellC == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{cName}));
                    }
                    clC = AppUtils.findContext("clusters", clName, cName, cellC, ws, true);
                    if (clC == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5055E", new Object[]{clName, sName}));
                    }
                    nodeCtx = AppUtils.findContext("nodes", nName, cName, cellC, ws, true);
                    if (nodeCtx == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5052E", new Object[]{nName}));
                    }
                    uri = URI.createURI("cluster.xml");
                    res = clC.getResourceSet().getResource(uri, true);
                    clst = (ServerCluster)res.getContents().get(0);
                    l = clst.getMembers();
                    add = null;
                    addSysApp = null;
                    resSysApp = null;
                    uriSysApp = null;
                    otherEntry = null;
                    otherMemberNode = null;
                    otherMemberName = null;
                    theEntry = null;
                    if (l.size() > 1) {
                        block10: for (lcv = 0; lcv < l.size(); ++lcv) {
                            member = (ClusterMember)l.get(lcv);
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, "Member: " + member.getMemberName() + " - " + member.getNodeName() + " sName: " + sName + " nName: " + nName);
                            }
                            if (member.getMemberName().equals(sName) && member.getNodeName().equals(nName)) continue;
                            rc = AppUtils.findContext("nodes", member.getNodeName(), cName, cellC, ws, true);
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, "Node context: " + rc);
                            }
                            if (rc == null) {
                                if (!AppAssociation.tc.isDebugEnabled()) continue;
                                Tr.debug(AppAssociation.tc, "Invalid member: " + member.getMemberName());
                                continue;
                            }
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, "Member: " + member.getMemberName() + " - " + member.getNodeName());
                            }
                            uri = URI.createURI("serverindex.xml");
                            index = rc.getResourceSet().getResource(uri, true);
                            top = (ServerIndex)index.getContents().get(0);
                            entries = top.getServerEntries();
                            for (i = 0; i < entries.size(); ++i) {
                                ent = (ServerEntry)entries.get(i);
                                if (!ent.getServerName().equals(member.getMemberName())) continue;
                                add = ent.getDeployedApplications();
                                if (AppAssociation.tc.isDebugEnabled()) {
                                    Tr.debug(AppAssociation.tc, "add: " + add);
                                }
                                otherEntry = ent;
                                otherMemberName = member.getMemberName();
                                otherMemberNode = rc;
                                break;
                            }
                            uriSysApp = URI.createURI("systemapps.xml");
                            indexSysApp = rc.getResourceSet().getResource(uriSysApp, true);
                            if (indexSysApp == null) {
                                if (!AppAssociation.tc.isDebugEnabled()) continue;
                                Tr.debug(AppAssociation.tc, "systemapps.xml not found.");
                                continue;
                            }
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, "Found for node " + rc + " systemapp SI doc res: " + indexSysApp);
                            }
                            topSysApp = (ServerIndex)indexSysApp.getContents().get(0);
                            entriesSysApp = topSysApp.getServerEntries();
                            for (i = 0; i < entriesSysApp.size(); ++i) {
                                ent = (ServerEntry)entriesSysApp.get(i);
                                if (!ent.getServerName().equals(member.getMemberName())) continue;
                                addSysApp = ent.getDeployedApplications();
                                if (!AppAssociation.tc.isDebugEnabled()) break block10;
                                Tr.debug(AppAssociation.tc, "addSysApp: " + addSysApp);
                                break block10;
                            }
                            break;
                        }
                    }
                    if (add == null) {
                        add = new ArrayList<String>();
                        ar = AppUtils.getContextArray("deployments", cellC, ws);
                        block13: for (i = 0; i < ar.length; ++i) {
                            rc = (RepositoryContext)ar[i];
                            res = ConfigRepoHelper.getAppDeploymentResource(rc);
                            d = (Deployment)res.getContents().get(0);
                            ts = d.getDeploymentTargets();
                            for (j = 0; j < ts.size(); ++j) {
                                if (!(ts.get(j) instanceof ClusteredTarget) || !((ClusteredTarget)ts.get(j)).getName().equals(clName)) continue;
                                add.add(ConfigRepoHelper.getSIEntryText(rc));
                                continue block13;
                            }
                        }
                    }
                    if (AppAssociation.tc.isDebugEnabled()) {
                        Tr.debug(AppAssociation.tc, "add is: " + add);
                    }
                    uri = URI.createURI("serverindex.xml");
                    res = nodeCtx.getResourceSet().getResource(uri, true);
                    top = (ServerIndex)res.getContents().get(0);
                    entries = top.getServerEntries();
                    for (i = 0; i < entries.size(); ++i) {
                        ent = (ServerEntry)entries.get(i);
                        if (!ent.getServerName().equals(sName)) continue;
                        theEntry = ent;
                        for (j = 0; j < add.size(); ++j) {
                            if (ent.getDeployedApplications().contains(add.get(j))) continue;
                            ent.getDeployedApplications().add(add.get(j));
                        }
                        break;
                    }
                    res.save(new HashMap<K, V>(0));
                    props = new Hashtable<String, String>();
                    props.put("cell.name", cName);
                    props.put("node.name", nName);
                    ConfigRepoHelper.getReferenceToSystemAppsXML(ws, props);
                    uriSysApp = URI.createURI("systemapps.xml");
                    resSysApp = nodeCtx.getResourceSet().getResource(uriSysApp, true);
                    topSysApp = (ServerIndex)resSysApp.getContents().get(0);
                    entriesSysApp = topSysApp.getServerEntries();
                    entriesNameSysApp = ConfigRepoHelper.getServerNameForServerEntries(entriesSysApp);
                    if (!entriesNameSysApp.contains(sName)) {
                        ConfigRepoHelper.createServerEntry(topSysApp, sName);
                    }
                    entriesSysApp = topSysApp.getServerEntries();
                    if (AppAssociation.tc.isDebugEnabled()) {
                        Tr.debug(AppAssociation.tc, "serversEntries for " + nodeCtx.getName() + " are " + entriesSysApp);
                    }
                    if (addSysApp != null) {
                        for (i = 0; i < entriesSysApp.size(); ++i) {
                            ent = (ServerEntry)entriesSysApp.get(i);
                            if (!ent.getServerName().equals(sName)) continue;
                            for (j = 0; j < addSysApp.size(); ++j) {
                                if (ent.getDeployedApplications().contains(addSysApp.get(j))) continue;
                                ent.getDeployedApplications().add(addSysApp.get(j));
                            }
                            break;
                        }
                        resSysApp.save(new HashMap<K, V>(0));
                    }
                    uri = URI.createURI("deployment.xml");
                    appCs = new ArrayList<RepositoryContext>();
                    for (i = 0; i < add.size(); ++i) {
                        try {
                            appC = ConfigRepoHelper.getAppContextFromSIEntry((String)add.get(i), cellC, ws);
                            res = appC.getResourceSet().getResource(uri, true);
                            res.save(new HashMap<K, V>(0));
                            appCs.add(appC);
                            continue;
                        }
                        catch (Throwable th) {
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, "Exception: " + th + " in touching deployment.xml " + " in " + add.get(i));
                            }
                            RasUtils.logException(th, AppAssociation.tc, AppAssociation.CLASS_NAME, "clusterMemberAdded", "1004", this);
                            appCs = new ArrayList<E>();
                        }
                    }
                    ear = null;
                    shouldProceed = false;
                    if (AppAssociation.tc.isDebugEnabled()) {
                        Tr.debug(AppAssociation.tc, "appCs = " + appCs);
                    }
                    try {
                        block68: {
                            vh = new ArrayList<String>();
                            block20: for (i = 0; i < appCs.size(); ++i) {
                                appC = (RepositoryContext)appCs.get(i);
                                ear = ConfigRepoHelper.getEarFileFromDeployment(ws, appC);
                                refs = ear.getWebModuleRefs();
                                for (j = 0; j < refs.size(); ++j) {
                                    bnd = (WebAppBinding)((ModuleRef)refs.get(j)).getBindings();
                                    if (bnd == null) {
                                        if (!AppAssociation.tc.isDebugEnabled()) continue;
                                        Tr.debug(AppAssociation.tc, "null binding for " + appC + " - " + ((ModuleRef)refs.get(j)).getUri());
                                        continue;
                                    }
                                    vHost = bnd.getVirtualHostName();
                                    if (vHost == null) continue;
                                    if (AppAssociation.tc.isDebugEnabled()) {
                                        Tr.debug(AppAssociation.tc, "vhost = " + vHost);
                                    }
                                    if (!vh.contains(vHost)) {
                                        vh.add(vHost);
                                    }
                                    if (vh.size() > 1) continue block20;
                                }
                            }
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, "vh = " + vh);
                            }
                            theVH = null;
                            if (vh.size() == 1) {
                                vHost = (String)vh.get(0);
                                uri = URI.createURI("virtualhosts.xml");
                                res = cellC.getResourceSet().getResource(uri, true);
                                hosts = res.getContents();
                                block22: for (k = 0; k < hosts.size(); ++k) {
                                    vh_def = (VirtualHost)hosts.get(k);
                                    if (!vHost.equals(vh_def.getName())) continue;
                                    shouldProceed = true;
                                    theVH = vh_def;
                                    aliases = theVH.getAliases();
                                    for (i = 0; i < aliases.size(); ++i) {
                                        alias = (HostAlias)aliases.get(i);
                                        if (AppAssociation.tc.isDebugEnabled()) {
                                            Tr.debug(AppAssociation.tc, "alias: " + alias.getHostname());
                                        }
                                        if ("*".equals(alias.getHostname())) continue;
                                        shouldProceed = false;
                                        continue block22;
                                    }
                                }
                            }
                            currentPorts = new ArrayList<String>();
                            aliases = theVH.getAliases();
                            for (i = 0; i < aliases.size(); ++i) {
                                currentPorts.add(((HostAlias)aliases.get(i)).getPort());
                            }
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, "current ports: " + currentPorts);
                            }
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, "shouldProceed: " + shouldProceed + ", " + theVH);
                            }
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, otherMemberName + ", " + otherMemberNode + ", " + otherEntry);
                            }
                            if (shouldProceed && otherMemberName != null && otherMemberNode != null && otherEntry != null) {
                                endPorts = AppAssociation.getEndPorts(otherMemberName, otherMemberNode, otherEntry);
                                if (AppAssociation.tc.isDebugEnabled()) {
                                    Tr.debug(AppAssociation.tc, "endPorts for other: " + endPorts);
                                }
                                for (i = 0; i < currentPorts.size(); ++i) {
                                    endPorts.remove(currentPorts.get(i));
                                }
                                if (AppAssociation.tc.isDebugEnabled()) {
                                    Tr.debug(AppAssociation.tc, "endPorts for other after remove: " + endPorts);
                                }
                                if (endPorts.size() != 0) {
                                    shouldProceed = false;
                                }
                            }
                            if (!shouldProceed) break block68;
                            endPorts = AppAssociation.getEndPorts(sName, nodeCtx, theEntry);
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, "endPorts to add: " + endPorts);
                            }
                            for (i = 0; i < endPorts.size(); ++i) {
                                if (currentPorts.contains(endPorts.get(i))) {
                                    if (!AppAssociation.tc.isDebugEnabled()) continue;
                                    Tr.debug(AppAssociation.tc, "port already defined, skipping -" + endPorts.get(i));
                                    continue;
                                }
                                alias = HostFactory.eINSTANCE.createHostAlias();
                                alias.setHostname("*");
                                alias.setPort((String)endPorts.get(i));
                                theVH.getAliases().add(alias);
                            }
                            theVH.eResource().save(new HashMap<K, V>());
                        }
                        var43_67 = null;
                        ** if (ear == null) goto lbl-1000
                    }
                    catch (Throwable var42_70) {
                        var43_69 = null;
                        if (ear != null) {
                            ear.close();
                        }
                        throw var42_70;
                    }
lbl-1000:
                    // 1 sources

                    {
                        ear.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block69;
                        catch (Throwable th) {
                            if (AppAssociation.tc.isDebugEnabled()) {
                                Tr.debug(AppAssociation.tc, "Unexpected exception in updating server with http ports: " + th);
                            }
                            RasUtils.logException(th, AppAssociation.tc, AppAssociation.CLASS_NAME, "clusterMemberAdded", "1118", this);
                            var43_68 = null;
                            if (ear != null) {
                                ear.close();
                            }
                        }
                    }
                }
                var45_71 = null;
                EditApplication.doFinally(ws, this.workspaceID, null, bEx == false);
            }
            catch (Throwable var44_74) {
                var45_73 = null;
                EditApplication.doFinally(ws, this.workspaceID, null, bEx == false);
                if (AppAssociation.tc.isEntryEnabled()) {
                    Tr.exit(AppAssociation.tc, "clusterMemberAdded");
                }
                throw var44_74;
            }
            if (AppAssociation.tc.isEntryEnabled()) {
                Tr.exit(AppAssociation.tc, "clusterMemberAdded");
            }
            break block70;
            {
                catch (Throwable th) {
                    bEx = true;
                    AppAssociation.handleCatch(th, "clusterMemberAdded", "106", this);
                    var45_72 = null;
                    EditApplication.doFinally(ws, this.workspaceID, null, bEx == false);
                    if (AppAssociation.tc.isEntryEnabled()) {
                        Tr.exit(AppAssociation.tc, "clusterMemberAdded");
                    }
                }
            }
        }
    }

    public static List getEndPorts(String sName, RepositoryContext nodeCtx, ServerEntry entry) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPorts: " + sName);
        }
        ArrayList<String> ports = new ArrayList<String>();
        RepositoryContext otherMemCtx = nodeCtx.getChild(AppUtils.getContextType("servers"), sName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "contexts: node=" + nodeCtx + ", server=" + otherMemCtx);
        }
        URI uri = URI.createURI("server.xml");
        Resource res = otherMemCtx.getResourceSet().getResource(uri, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resource: " + res);
        }
        Server server = (Server)res.getContents().get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found server: " + server);
        }
        EList components = server.getComponents();
        for (int i = 0; i < components.size(); ++i) {
            if (!(components.get(i) instanceof ApplicationServer)) continue;
            ApplicationServer appServer = (ApplicationServer)components.get(i);
            EList comps = appServer.getComponents();
            for (int j = 0; j < comps.size(); ++j) {
                if (!(comps.get(j) instanceof WebContainer)) continue;
                WebContainer webContainer = (WebContainer)comps.get(j);
                EList transports = webContainer.getTransports();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "transports: " + transports);
                }
                for (int k = 0; k < transports.size(); ++k) {
                    Transport transport = (Transport)transports.get(k);
                    if (transport.getAddress() == null || ports.contains("" + transport.getAddress().getPort())) continue;
                    ports.add("" + transport.getAddress().getPort());
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "After adding ports from webcontainer: " + ports);
            }
        }
        EList services = server.getServices();
        for (int i = 0; i < services.size(); ++i) {
            if (!(services.get(i) instanceof TransportChannelService)) continue;
            TransportChannelService service = (TransportChannelService)services.get(i);
            EList chains = service.getChains();
            for (int j = 0; j < chains.size(); ++j) {
                int k;
                Chain chain = (Chain)chains.get(j);
                boolean chainEnabled = chain.isEnable();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "chain: " + chain.getName() + " enabled: " + chainEnabled);
                }
                if (!chainEnabled) continue;
                EList channels = chain.getTransportChannels();
                boolean hasWCInbound = false;
                for (k = 0; k < channels.size(); ++k) {
                    if (!(channels.get(k) instanceof WebContainerInboundChannel)) continue;
                    hasWCInbound = true;
                    break;
                }
                if (!hasWCInbound) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No WCInbound for this chain");
                    continue;
                }
                for (k = 0; k < channels.size(); ++k) {
                    if (!(channels.get(k) instanceof TCPInboundChannel)) continue;
                    TCPInboundChannel tcpIn = (TCPInboundChannel)channels.get(k);
                    String epName = tcpIn.getEndPointName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ep name: " + epName);
                    }
                    String port = AppAssociation.getPortForEP(entry, epName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "port: " + port);
                    }
                    if (port == null || ports.contains(port)) continue;
                    ports.add(port);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPorts: " + ports);
        }
        return ports;
    }

    private static String getPortForEP(ServerEntry entry, String epName) {
        EList eps = entry.getSpecialEndpoints();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "looking for ep port for: " + epName);
        }
        for (int i = 0; i < eps.size(); ++i) {
            NamedEndPoint namedEP;
            if (!(eps.get(i) instanceof NamedEndPoint) || !epName.equals((namedEP = (NamedEndPoint)eps.get(i)).getEndPointName())) continue;
            return "" + namedEP.getEndPoint().getPort();
        }
        return null;
    }

    public static void populateDeployTargets(Deployment depl, ModuleDeployment modDepl, String strAll, String unique, RepositoryContext cellContext, WorkSpace ws, AppcfgFactory factory, AppdeploymentFactory appFactory) throws Exception {
        ConfigureTask.populateDeployTargets(depl, modDepl, strAll, unique, cellContext, ws, factory, appFactory);
    }

    public static Vector getServerNames(String names, String unique, RepositoryContext cellContext, WorkSpace ws) throws Exception {
        return ConfigRepoHelper.getServerNames(names, unique, true, cellContext, ws);
    }

    public static Vector getServerNames(String names, String unique, boolean returnConfig, RepositoryContext cellContext, WorkSpace ws) throws Exception {
        return ConfigRepoHelper.getServerNames(names, unique, returnConfig, cellContext, ws);
    }

    private static int existsInNewConfig(DeploymentTargetMapping mapping, Vector v) {
        for (int i = 0; i < v.size(); i += 2) {
            RepositoryContext rc = (RepositoryContext)v.elementAt(i);
            String config = (String)v.elementAt(i + 1);
            String mapCfg = null;
            ModuleConfig modC = (ModuleConfig)mapping.getConfig();
            if (modC != null) {
                mapCfg = modC.getName();
            }
            if ((!AppUtils.isEmpty(config) || !AppUtils.isEmpty(mapCfg)) && !config.equals(mapCfg) || !rc.getName().equals(mapping.getTarget().getName())) continue;
            if (mapping.getTarget() instanceof ClusteredTarget && AppUtils.isCluster(rc)) {
                return i;
            }
            if (!(mapping.getTarget() instanceof ServerTarget) || !AppUtils.isServer(rc) || !rc.getParent().getName().equals(((ServerTarget)mapping.getTarget()).getNodeName())) continue;
            return i;
        }
        return -1;
    }

    private static ModuleConfig getOrCreateConfig(ModuleDeployment depl, String config, AppcfgFactory factory) throws Exception {
        EList c = depl.getConfigs();
        for (int i = 0; i < c.size(); ++i) {
            ModuleConfig cfg = (ModuleConfig)c.get(i);
            if (!cfg.getName().equals(config)) continue;
            return cfg;
        }
        if (AppUtils.isEmpty(config)) {
            return null;
        }
        if (depl instanceof EJBModuleDeployment) {
            EJBModuleConfiguration cfg = factory.createEJBModuleConfiguration();
            cfg.setName(config);
            c.add(cfg);
            return cfg;
        }
        if (depl instanceof WebModuleDeployment) {
            WebModuleConfig cfg = factory.createWebModuleConfig();
            cfg.setName(config);
            c.add(cfg);
            return cfg;
        }
        return null;
    }

    private static DeploymentTarget getOrCreateTarget(Deployment depl, RepositoryContext rc, AppdeploymentFactory appFactory) throws Exception {
        EList targets = depl.getDeploymentTargets();
        for (int i = 0; i < targets.size(); ++i) {
            DeploymentTarget t = (DeploymentTarget)targets.get(i);
            if (t instanceof ClusteredTarget && AppUtils.isCluster(rc) && t.getName().equals(rc.getName())) {
                return t;
            }
            if (!(t instanceof ServerTarget) || !AppUtils.isServer(rc) || !t.getName().equals(rc.getName()) || !rc.getParent().getName().equals(((ServerTarget)t).getNodeName())) continue;
            return t;
        }
        DeploymentTarget target = null;
        target = AppUtils.isCluster(rc) ? appFactory.createClusteredTarget() : appFactory.createServerTarget();
        target.setName(rc.getName());
        if (target instanceof ServerTarget) {
            ((ServerTarget)target).setNodeName(rc.getParent().getName());
        }
        depl.getDeploymentTargets().add(target);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created target: " + target);
        }
        return target;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/AppAssociation.java, WAS.admin.appmgmt, WAS70.SERV1, cf050925.09, ver. 1.12.1.9");
        }
        CLASS_NAME = AppAssociation.class.getName();
        appFactory = null;
        isReg = false;
    }
}

