/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.ws.http.logging.DebugLog;
import com.ibm.ws.http.logging.impl.LoggerOnThread;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import java.io.FileNotFoundException;

public class DebugLogger
extends LoggerOnThread
implements DebugLog {
    private static final TraceComponent tc = Tr.register(DebugLogger.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private DebugLog.Level myLevel = DebugLog.Level.WARN;

    public DebugLogger(String filename) throws FileNotFoundException {
        super(filename);
    }

    public DebugLog.Level getCurrentLevel() {
        return this.myLevel;
    }

    public void setCurrentLevel(DebugLog.Level logLevel) {
        this.myLevel = logLevel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Set the loglevel to " + (Object)((Object)logLevel));
        }
    }

    public boolean isEnabled(DebugLog.Level logLevel) {
        return 0 <= this.myLevel.compareTo(logLevel);
    }

    public void log(DebugLog.Level logLevel, byte[] message, HttpServiceContext hsc) {
        block5: {
            if (!this.isEnabled(logLevel) || null == message) {
                return;
            }
            try {
                StringBuilder sb = new StringBuilder(125);
                sb.append('[');
                sb.append(HttpDateFormat.getRef().getRFC1123Time());
                sb.append("] [");
                sb.append(logLevel.name());
                sb.append("] [");
                if (null == hsc) {
                    sb.append("-/-");
                } else {
                    sb.append(hsc.getRemoteAddr().getHostAddress());
                    sb.append(':');
                    sb.append(hsc.getRemotePort());
                    sb.append('/');
                    sb.append(hsc.getLocalAddr().getHostAddress());
                    sb.append(':');
                    sb.append(hsc.getLocalPort());
                }
                sb.append("] ");
                byte[] data = HttpChannelUtils.getBytes(sb);
                WsByteBuffer wsbb = WsByteBufferPoolManagerImpl.getRef().allocateDirect(data.length + message.length + 2);
                wsbb.put(data);
                wsbb.put(message);
                wsbb.put(CRLF);
                wsbb.flip();
                super.log(wsbb);
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, this.getClass().getName() + ".log", "1", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                Tr.event(tc, "Error writing to log; " + t);
            }
        }
    }

    public void log(DebugLog.Level logLevel, String message, HttpServiceContext hsc) {
        if (this.isEnabled(logLevel) && null != message) {
            this.log(logLevel, GenericUtils.getEnglishBytes(message), hsc);
        }
    }

    public void log(DebugLog.Level logLevel, byte[] message, String remoteIP, String remotePort, String localIP, String localPort) {
        block3: {
            if (!this.isEnabled(logLevel) || null == message) {
                return;
            }
            try {
                StringBuilder sb = new StringBuilder(125);
                sb.append('[');
                sb.append(HttpDateFormat.getRef().getRFC1123Time());
                sb.append("] [");
                sb.append(logLevel.name());
                sb.append("] [");
                sb.append(remoteIP);
                sb.append(':');
                sb.append(remotePort);
                sb.append('/');
                sb.append(localIP);
                sb.append(':');
                sb.append(localPort);
                sb.append("] ");
                byte[] data = HttpChannelUtils.getBytes(sb);
                WsByteBuffer wsbb = WsByteBufferPoolManagerImpl.getRef().allocateDirect(data.length + message.length + 2);
                wsbb.put(data);
                wsbb.put(message);
                wsbb.put(CRLF);
                wsbb.flip();
                super.log(wsbb);
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, this.getClass().getName() + ".log", "3", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                Tr.event(tc, "Error writing to log; " + t);
            }
        }
    }

    public void log(DebugLog.Level logLevel, String message, String remoteIP, String remotePort, String localIP, String localPort) {
        if (this.isEnabled(logLevel) && null != message) {
            this.log(logLevel, GenericUtils.getEnglishBytes(message), remoteIP, remotePort, localIP, localPort);
        }
    }

    public String toString() {
        return super.toString() + "\n  LogLevel: " + (Object)((Object)this.getCurrentLevel());
    }
}

