/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSCReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSCReadCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final HttpOSCReadCallback myInstance = new HttpOSCReadCallback();

    private HttpOSCReadCallback() {
    }

    public static final HttpOSCReadCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext req) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + vc);
        }
        HttpOutboundServiceContextImpl mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        VirtualConnection readVC = null;
        try {
            do {
                if (mySC.parseMessage()) {
                    mySC.handleParsedMessage();
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reading for more data");
                }
                mySC.setupReadBuffers(mySC.getHttpConfig().getIncomingHdrBufferSize(), false);
            } while (null != (readVC = req.read(1L, (TCPReadCompletedCallback)this, false, mySC.getReadTimeout())));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".complete", "112", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception: " + e.getMessage());
            }
            mySC.setPersistent(false);
            mySC.getAppWriteCallback().error(vc, (Throwable)e);
        }
    }

    public void error(VirtualConnection vc, TCPReadRequestContext req, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + vc + " ioe=" + ioe);
        }
        HttpOutboundServiceContextImpl mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        mySC.setPersistent(false);
        mySC.reConnect(vc, ioe);
    }
}

