/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HttpLocalFormat;
import com.ibm.ws.util.WSThreadLocal;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HttpDateFormat {
    private static final TraceComponent tc = Tr.register(HttpDateFormat.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private WSThreadLocal threadStorage = new WSThreadLocal();
    private static HttpDateFormat myInstance = null;

    private HttpDateFormat() {
        this.threadStorage.set(new HttpLocalFormat());
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpDateFormat();
        }
    }

    public static final HttpDateFormat getRef() {
        if (null == myInstance) {
            HttpDateFormat.createSingleton();
        }
        return myInstance;
    }

    private HttpLocalFormat getFormat() {
        HttpLocalFormat format = (HttpLocalFormat)this.threadStorage.get();
        if (null == format) {
            format = new HttpLocalFormat();
            this.threadStorage.set(format);
        }
        return format;
    }

    public byte[] getRFC1123TimeAsBytes() {
        return this.getFormat().get1123TimeAsBytes(0L);
    }

    public byte[] getRFC1123TimeAsBytes(long range) {
        return this.getFormat().get1123TimeAsBytes(range);
    }

    public String getRFC1123Time() {
        return this.getFormat().get1123TimeAsString(0L);
    }

    public String getRFC1123Time(long range) {
        return this.getFormat().get1123TimeAsString(range);
    }

    public String getRFC1123Time(Date inDate) {
        return this.getFormat().get1123Format().format(inDate);
    }

    public byte[] getRFC1036TimeAsBytes() {
        return this.getFormat().get1036TimeAsBytes(0L);
    }

    public byte[] getRFC1036TimeAsBytes(long range) {
        return this.getFormat().get1036TimeAsBytes(range);
    }

    public String getRFC1036Time() {
        return this.getFormat().get1036TimeAsString(0L);
    }

    public String getRFC1036Time(long range) {
        return this.getFormat().get1036TimeAsString(range);
    }

    public String getRFC1036Time(Date inDate) {
        return this.getFormat().get1036Format().format(inDate);
    }

    public byte[] getRFC2109TimeAsBytes() {
        return this.getFormat().get2109TimeAsBytes(0L);
    }

    public byte[] getRFC2109TimeAsBytes(long range) {
        return this.getFormat().get2109TimeAsBytes(range);
    }

    public String getRFC2109Time() {
        return this.getFormat().get2109TimeAsString(0L);
    }

    public String getRFC2109Time(long range) {
        return this.getFormat().get2109TimeAsString(range);
    }

    public String getRFC2109Time(Date inDate) {
        return this.getFormat().get2109Format().format(inDate);
    }

    public byte[] getASCIITimeAsBytes() {
        return this.getFormat().getAsciiTimeAsBytes(0L);
    }

    public byte[] getASCIITimeAsBytes(long range) {
        return this.getFormat().getAsciiTimeAsBytes(range);
    }

    public String getASCIITime() {
        return this.getFormat().getAsciiTimeAsString(0L);
    }

    public String getASCIITime(long range) {
        return this.getFormat().getAsciiTimeAsString(range);
    }

    public String getASCIITime(Date inDate) {
        return this.getFormat().getAsciiFormat().format(inDate);
    }

    public byte[] getNCSATimeAsBytes() {
        return this.getFormat().getNCSATimeAsBytes(0L);
    }

    public byte[] getNCSATimeAsBytes(long range) {
        return this.getFormat().getNCSATimeAsBytes(range);
    }

    public String getNCSATime() {
        return this.getFormat().getNCSATimeAsString(0L);
    }

    public String getNCSATime(long range) {
        return this.getFormat().getNCSATimeAsString(range);
    }

    public String getNCSATime(Date inDate) {
        return this.getFormat().getNCSAFormat().format(inDate);
    }

    private Date attemptParse(SimpleDateFormat format, String input) {
        ParsePosition pos = new ParsePosition(0);
        Date d = format.parse(input, pos);
        if (0 == pos.getIndex() || pos.getIndex() != input.length()) {
            return null;
        }
        return d;
    }

    public Date parseRFC1123Time(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "rfc1123 parsing [" + input + "]");
        }
        if (null == (d = this.attemptParse(this.getFormat().get1123Parse(), input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    public Date parseRFC1036Time(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "rfc1036 parsing [" + input + "]");
        }
        if (null == (d = this.attemptParse(this.getFormat().get1036Parse(), input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    public Date parseRFC2109Time(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "rfc2109 parsing [" + input + "]");
        }
        if (null == (d = this.attemptParse(this.getFormat().get2109Parse(), input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    public Date parseASCIITime(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ascii parsing [" + input + "]");
        }
        if (null == (d = this.attemptParse(this.getFormat().getAsciiParse(), input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    public Date parseTime(String input) throws ParseException {
        Date parsedDate;
        String data;
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseTime parsing [" + input + "]");
        }
        if (-1 != (i = (data = input).indexOf(59, 0))) {
            char c;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring excess data following semi-colon in date");
            }
            while (i > 20 && (' ' == (c = data.charAt(i - 1)) || '\t' == c)) {
                --i;
            }
            if (20 >= i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not enough data left to make a valid date");
                }
                throw new ParseException("Invalid date [" + input + "]", 0);
            }
            data = input.substring(0, i);
        }
        if (null == (parsedDate = this.attemptParse(this.getFormat().get1123Parse(), data)) && null == (parsedDate = this.attemptParse(this.getFormat().get1036Parse(), data)) && null == (parsedDate = this.attemptParse(this.getFormat().getAsciiParse(), data)) && null == (parsedDate = this.attemptParse(this.getFormat().get2109Parse(), data))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Time does not match supported formats");
            }
            throw new ParseException("Unparseable [" + data + "]", 0);
        }
        return parsedDate;
    }

    public Date parseTime(byte[] inBytes) throws ParseException {
        return this.parseTime(GenericUtils.getEnglishString(inBytes));
    }
}

