/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.genericbnf.impl.HeaderElement;
import com.ibm.ws.genericbnf.impl.TokenCodes;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BNFHeadersImpl
implements BNFHeaders,
Externalizable {
    private static final TraceComponent tc = Tr.register(BNFHeadersImpl.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private static final long serialVersionUID = -4154557451251031540L;
    protected static final int SERIALIZATION_V1 = -1091633151;
    protected static final int SERIALIZATION_V2 = -1091633150;
    private static final int PARSING_HEADER = 0;
    private static final int PARSING_VALUE = 1;
    private static final int PARSING_CRLF = 2;
    private static final int DEFAULT_BUFFERSIZE = 1024;
    private static final int DEFAULT_CACHESIZE = 512;
    private static final int DEFAULT_LIMIT_TOKENSIZE = 16384;
    private static final int DEFAULT_LIMIT_NUMHEADERS = 500;
    private static final int BUFFERS_INITIAL_SIZE = 10;
    private static final int BUFFERS_MIN_GROWTH = 5;
    private static final boolean FILTER_YES = true;
    private static final boolean FILTER_NO = false;
    protected static final int LOG_FULL = 0;
    protected static final int LOG_NONE = 1;
    protected static final int LOG_PARTIAL = 2;
    private static byte[] whitespace = null;
    private transient HeaderElement[] storage = new HeaderElement[100];
    private transient HeaderElement hdrSequence = null;
    private transient HeaderElement lastHdrInSequence = null;
    private transient HeaderElement headerElements = null;
    private transient WsByteBuffer[] parseBuffers = new WsByteBuffer[10];
    private transient int[] parseBuffersStartPos = new int[10];
    private transient int parseIndex = -1;
    private transient WsByteBuffer[] myCreatedBuffers = new WsByteBuffer[10];
    private transient int createdIndex = -1;
    private transient int numberOfHeaders = 0;
    private transient boolean bHeaderValidation = true;
    private transient int lastCRLFBufferIndex = -1;
    private transient int lastCRLFPosition = -1;
    private transient boolean lastCRLFisCR = false;
    private transient int headerChangeLimit = -1;
    private transient int headerChangeCount = 0;
    private transient int headerAddCount = 0;
    private transient boolean bOverChangeLimit = false;
    private transient int limitTokenSize = 16384;
    private transient int limitNumHeaders = 500;
    private transient int eohPosition = -1;
    private transient WsByteBuffer currentReadBB = null;
    private transient boolean useDirectBuffer = true;
    private transient int outgoingHdrBufferSize = 1024;
    private transient int incomingBufferSize = 1024;
    private transient int byteCacheSize = 512;
    private transient byte[] parsedToken = null;
    private transient int parsedTokenLength = 0;
    private transient byte[] byteCache = new byte[this.byteCacheSize];
    private transient byte[] originalByteCache = this.byteCache;
    private transient int bytePosition = 0;
    private transient int byteLimit = 0;
    private transient boolean isByteBufferArray = false;
    private transient int stateOfParsing = 2;
    private transient int binaryParsingState = 1;
    private transient HeaderElement currentElem = null;
    private transient boolean bIsMultiLine = false;
    private transient int numCRLFs = 0;
    private transient Object debugContext = this;
    private transient boolean compactHeaderFlag = false;
    private transient int deserializationVersion = -1091633151;

    public BNFHeadersImpl() {
        for (int i = 0; i < this.parseBuffersStartPos.length; ++i) {
            this.parseBuffersStartPos[i] = -1;
        }
    }

    protected void init(boolean useDirect, int outSize, int inSize, int cacheSize) {
        this.useDirectBuffer = useDirect;
        this.outgoingHdrBufferSize = outSize;
        this.incomingBufferSize = inSize;
        if (cacheSize > this.byteCacheSize) {
            this.byteCacheSize = cacheSize;
            this.byteCache = new byte[cacheSize];
            this.originalByteCache = this.byteCache;
        }
    }

    public void addParseBuffer(WsByteBuffer buffer) {
        int index;
        if ((index = ++this.parseIndex) == this.parseBuffers.length) {
            int size = index + 5;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Increasing parse buffer array size to " + size);
            }
            WsByteBuffer[] tempNew = new WsByteBuffer[size];
            System.arraycopy(this.parseBuffers, 0, tempNew, 0, index);
            this.parseBuffers = tempNew;
            int[] posNew = new int[size];
            System.arraycopy(this.parseBuffersStartPos, 0, posNew, 0, index);
            this.parseBuffersStartPos = posNew;
            for (int i = index; i < size; ++i) {
                this.parseBuffersStartPos[i] = -1;
            }
        }
        this.parseBuffers[index] = buffer;
    }

    public void addToCreatedBuffer(WsByteBuffer buffer) {
        int index;
        if ((index = ++this.createdIndex) == this.myCreatedBuffers.length) {
            int size = index + 5;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Increasing created buffer array size to " + size);
            }
            WsByteBuffer[] tempNew = new WsByteBuffer[size];
            System.arraycopy(this.myCreatedBuffers, 0, tempNew, 0, index);
            this.myCreatedBuffers = tempNew;
        }
        this.myCreatedBuffers[index] = buffer;
    }

    @Override
    public void appendHeader(String header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(s,b): " + header);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setByteArrayValue(value);
        this.addHeader(elem, true, true);
    }

    @Override
    public void appendHeader(String header, byte[] value, int offset, int length) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(s,b,i,i): " + header);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setByteArrayValue(value, offset, length);
        this.addHeader(elem, true, true);
    }

    @Override
    public void appendHeader(byte[] header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(b,b): " + GenericUtils.getEnglishString(header));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setByteArrayValue(value);
        this.addHeader(elem, true, true);
    }

    @Override
    public void appendHeader(byte[] header, byte[] value, int offset, int length) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(b,b,i,i): " + GenericUtils.getEnglishString(header));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setByteArrayValue(value, offset, length);
        this.addHeader(elem, true, true);
    }

    @Override
    public void appendHeader(HeaderKeys key, byte[] value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(h,b): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        HeaderElement elem = this.getElement(key);
        elem.setByteArrayValue(value);
        this.addHeader(elem, true, true);
    }

    @Override
    public void appendHeader(HeaderKeys key, byte[] value, int offset, int length) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(h,b,i,i): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        HeaderElement elem = this.getElement(key);
        elem.setByteArrayValue(value, offset, length);
        this.addHeader(elem, true, true);
    }

    @Override
    public void appendHeader(String header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided: " + header + " " + value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(s,s): " + header);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setStringValue(value);
        this.addHeader(elem, true, true);
    }

    @Override
    public void appendHeader(byte[] header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(b,s): " + GenericUtils.getEnglishString(header));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setStringValue(value);
        this.addHeader(elem, true, true);
    }

    @Override
    public void appendHeader(HeaderKeys key, String value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "appendHeader(h,s): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value);
        }
        HeaderElement elem = this.getElement(key);
        elem.setStringValue(value);
        this.addHeader(elem, true, true);
    }

    public void clear() {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry(tc, "clear");
        }
        this.clearAllHeaders();
        this.eohPosition = -1;
        this.currentElem = null;
        this.stateOfParsing = 2;
        this.binaryParsingState = 1;
        this.parsedToken = null;
        this.parsedTokenLength = 0;
        this.bytePosition = 0;
        this.byteLimit = 0;
        this.currentReadBB = null;
        this.clearBuffers();
        this.debugContext = this;
        this.numCRLFs = 0;
        this.bIsMultiLine = false;
        this.lastCRLFBufferIndex = -1;
        this.lastCRLFPosition = -1;
        this.lastCRLFisCR = false;
        this.headerChangeCount = 0;
        this.headerAddCount = 0;
        this.bOverChangeLimit = false;
        this.compactHeaderFlag = false;
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    private void clearBuffers() {
        int i;
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        for (i = 0; i <= this.parseIndex; ++i) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing reference to parse buffer: " + this.parseBuffers[i]);
            }
            this.parseBuffers[i] = null;
            this.parseBuffersStartPos[i] = -1;
        }
        this.parseIndex = -1;
        for (i = 0; i <= this.createdIndex; ++i) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing marshall buffer: " + this.myCreatedBuffers[i]);
            }
            this.myCreatedBuffers[i].release();
            this.myCreatedBuffers[i] = null;
        }
        this.createdIndex = -1;
    }

    @Override
    public int compareValue(HeaderKeys key, byte[] value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: k[" + key.getName() + "] b[" + GenericUtils.getEnglishString(value) + "]");
        }
        return this.compareByteArrays(this.findHeader(key), value);
    }

    @Override
    public int compareValue(String header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: s[" + header + "] b[" + GenericUtils.getEnglishString(value) + "]");
        }
        return this.compareByteArrays(this.findHeader(this.findKey(header)), value);
    }

    @Override
    public int compareValue(byte[] header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: b[" + GenericUtils.getEnglishString(header) + "] b[" + GenericUtils.getEnglishString(value) + "]");
        }
        return this.compareByteArrays(this.findHeader(this.findKey(header)), value);
    }

    @Override
    public int compareValue(HeaderKeys key, String value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: k[" + key.getName() + "] s[" + value + "]");
        }
        return this.compareStrings(this.findHeader(key), value);
    }

    @Override
    public int compareValue(String header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: s[" + header + "] s[" + value + "]");
        }
        return this.compareStrings(this.findHeader(this.findKey(header)), value);
    }

    @Override
    public int compareValue(byte[] header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compareValue: b[" + GenericUtils.getEnglishString(header) + "] s[" + value + "]");
        }
        return this.compareStrings(this.findHeader(this.findKey(header)), value);
    }

    public void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "*** Begin Header Debug ***");
            HeaderElement elem = this.hdrSequence;
            while (null != elem) {
                Tr.debug(tc, elem.getName() + ": " + elem.getDebugValue());
                elem = elem.nextSequence;
            }
            Tr.debug(tc, "*** End Header Debug ***");
        }
    }

    protected void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying these headers: " + this);
        }
        if (null != this.hdrSequence) {
            this.clear();
        }
        this.byteCacheSize = 512;
        this.incomingBufferSize = 1024;
        this.outgoingHdrBufferSize = 1024;
        this.useDirectBuffer = true;
        this.limitNumHeaders = 500;
        this.limitTokenSize = 16384;
        this.headerChangeLimit = -1;
    }

    @Override
    public void duplicate(BNFHeaders msg) {
        this.duplicate((BNFHeadersImpl)msg);
    }

    protected void duplicate(BNFHeadersImpl msg) {
        if (null == msg) {
            throw new NullPointerException("Null object passed to duplicate");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Duplicating the headers");
        }
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                msg.appendHeader(elem.getHeaderKey(), elem.getByteArrayValue());
            }
            elem = elem.nextSequence;
        }
        msg.init(this.useDirectBuffer, this.outgoingHdrBufferSize, this.incomingBufferSize, this.byteCacheSize);
        msg.setDebugContext(this.debugContext);
        msg.setHeaderValidation(this.bHeaderValidation);
        msg.setLimitOfTokenSize(this.limitTokenSize);
        msg.setLimitOnNumberOfHeaders(this.limitNumHeaders);
    }

    protected int getDeserializationVersion() {
        return this.deserializationVersion;
    }

    protected byte[] readByteArray(ObjectInput input) throws IOException {
        int len = input.readInt();
        if (-1 == len) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "read byte[] found -1 length marker");
            }
            return null;
        }
        byte[] value = new byte[len];
        input.readFully(value);
        return value;
    }

    protected void writeByteArray(ObjectOutput output, byte[] data) throws IOException {
        if (null == data || 0 == data.length) {
            output.writeInt(-1);
        } else {
            output.writeInt(data.length);
            output.write(data);
        }
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        int len = input.readInt();
        if (-1091633150 == len) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Deserializing a V2 object");
            }
            this.deserializationVersion = -1091633150;
            len = input.readInt();
        }
        this.storage = new HeaderElement[len];
        int number = input.readInt();
        if (-1091633150 == this.deserializationVersion) {
            for (int i = 0; i < number; ++i) {
                this.appendHeader(this.readByteArray(input), this.readByteArray(input));
            }
        } else {
            for (int i = 0; i < number; ++i) {
                this.appendHeader((String)input.readObject(), (String)input.readObject());
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeInt(-1091633150);
        output.writeInt(this.storage.length);
        output.writeInt(this.numberOfHeaders);
        int count = 0;
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                ++count;
                this.writeByteArray(output, elem.getHeaderKey().getByteArray());
                this.writeByteArray(output, elem.getByteArrayValue());
            }
            elem = elem.nextSequence;
        }
        if (count != this.numberOfHeaders) {
            throw new IOException("Expected " + this.numberOfHeaders + " headers but wrote " + count);
        }
    }

    public boolean isEOHFound() {
        return -1 != this.eohPosition;
    }

    @Override
    public Vector<?> getAllHeaders() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllHeaders");
        }
        Vector<String> vals = new Vector<String>();
        if (0 == this.numberOfHeaders) {
            return vals;
        }
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            if (!elem.wasRemoved() && !vals.contains(elem.getName())) {
                vals.add(elem.getName());
            }
            elem = elem.nextSequence;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllHeaders: size=" + vals.size());
        }
        return vals;
    }

    @Override
    public byte[] getHeaderAsByteArray(HeaderKeys key) {
        byte[] val;
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(key);
        byte[] byArray = val = null != elem ? elem.getByteArrayValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsByteArray(h): " + key.getName() + " [" + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public byte[] getHeaderAsByteArray(String header) {
        byte[] val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(this.findKey(header));
        byte[] byArray = val = null != elem ? elem.getByteArrayValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsByteArray(s): " + header + " [" + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public byte[] getHeaderAsByteArray(byte[] header) {
        byte[] val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        HeaderElement elem = this.findHeader(key);
        byte[] byArray = val = null != elem ? elem.getByteArrayValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsByteArray(b): " + key.getName() + " [" + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public byte[] getHeaderAsByteArray(HeaderKeys key, int instance) {
        byte[] val;
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(key, instance);
        byte[] byArray = val = null != elem ? elem.getByteArrayValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsByteArray(h,i): " + key.getName() + " " + instance + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public byte[] getHeaderAsByteArray(String header, int instance) {
        byte[] val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(this.findKey(header), instance);
        byte[] byArray = val = null != elem ? elem.getByteArrayValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsByteArray(s,i): " + header + " " + instance + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public byte[] getHeaderAsByteArray(byte[] header, int instance) {
        byte[] val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        HeaderElement elem = this.findHeader(key, instance);
        byte[] byArray = val = null != elem ? elem.getByteArrayValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsByteArray(b,i): " + key.getName() + " " + instance + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public Date getHeaderAsDate(byte[] header) throws ParseException {
        Date val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        HeaderElement elem = this.findHeader(key);
        Date date = val = null != elem ? elem.asDate() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsDate(b): " + key.getName() + " [" + val + "]");
        }
        return val;
    }

    @Override
    public Date getHeaderAsDate(byte[] header, int instance) throws ParseException {
        Date val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        HeaderElement elem = this.findHeader(key, instance);
        Date date = val = null != elem ? elem.asDate() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsDate(b,i): " + key.getName() + " " + instance + " [" + val + "]");
        }
        return val;
    }

    @Override
    public Date getHeaderAsDate(HeaderKeys key) throws ParseException {
        Date val;
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(key);
        Date date = val = null != elem ? elem.asDate() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsDate(h): " + key.getName() + " [" + val + "]");
        }
        return val;
    }

    @Override
    public Date getHeaderAsDate(HeaderKeys key, int instance) throws ParseException {
        Date val;
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(key, instance);
        Date date = val = null != elem ? elem.asDate() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsDate(h,i): " + key.getName() + " " + instance + " [" + val + "]");
        }
        return val;
    }

    @Override
    public Date getHeaderAsDate(String header) throws ParseException {
        Date val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(this.findKey(header));
        Date date = val = null != elem ? elem.asDate() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsDate(s): " + header + " [" + val + "]");
        }
        return val;
    }

    @Override
    public Date getHeaderAsDate(String header, int instance) throws ParseException {
        Date val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(this.findKey(header), instance);
        Date date = val = null != elem ? elem.asDate() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsDate(s,i): " + header + " " + instance + " [" + val + "]");
        }
        return val;
    }

    private Vector<Date> getHeaderDateValues(HeaderElement root) throws ParseException {
        Vector<Date> list = new Vector<Date>();
        HeaderElement elem = root;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                list.add(elem.asDate());
            }
            elem = elem.nextInstance;
        }
        return list;
    }

    @Override
    public Vector<Date> getHeaderDateValues(byte[] header) throws ParseException {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderDateValues(b): " + key.getName());
        }
        return this.getHeaderDateValues(this.findHeader(key));
    }

    @Override
    public Vector<Date> getHeaderDateValues(HeaderKeys key) throws ParseException {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderDateValues(h): " + key.getName());
        }
        return this.getHeaderDateValues(this.findHeader(key));
    }

    @Override
    public Vector<Date> getHeaderDateValues(String header) throws ParseException {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderDateValues(s): " + header);
        }
        return this.getHeaderDateValues(this.findHeader(this.findKey(header)));
    }

    @Override
    public Integer getHeaderAsInteger(byte[] header) throws NumberFormatException {
        Integer val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        HeaderElement elem = this.findHeader(key);
        Integer n = val = null != elem ? elem.asInteger() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsInteger(b): " + key.getName() + " [" + val + "]");
        }
        return val;
    }

    @Override
    public Integer getHeaderAsInteger(byte[] header, int instance) throws NumberFormatException {
        Integer val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        HeaderElement elem = this.findHeader(key, instance);
        Integer n = val = null != elem ? elem.asInteger() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsInteger(b,i): " + key.getName() + " " + instance + " [" + val + "]");
        }
        return val;
    }

    @Override
    public Integer getHeaderAsInteger(HeaderKeys key) throws NumberFormatException {
        Integer val;
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(key);
        Integer n = val = null != elem ? elem.asInteger() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsInteger(h): " + key.getName() + " [" + val + "]");
        }
        return val;
    }

    @Override
    public Integer getHeaderAsInteger(HeaderKeys key, int instance) throws NumberFormatException {
        Integer val;
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(key, instance);
        Integer n = val = null != elem ? elem.asInteger() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsInteger(h,i): " + key.getName() + " " + instance + " [" + val + "]");
        }
        return val;
    }

    @Override
    public Integer getHeaderAsInteger(String header) throws NumberFormatException {
        Integer val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(this.findKey(header));
        Integer n = val = null != elem ? elem.asInteger() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsInteger(s): " + header + " [" + val + "]");
        }
        return val;
    }

    @Override
    public Integer getHeaderAsInteger(String header, int instance) throws NumberFormatException {
        Integer val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(this.findKey(header), instance);
        Integer n = val = null != elem ? elem.asInteger() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsInteger(s,i): " + header + " " + instance + " [" + val + "]");
        }
        return val;
    }

    private Vector<Integer> getHeaderIntegerValues(HeaderElement root) throws NumberFormatException {
        Vector<Integer> list = new Vector<Integer>();
        HeaderElement elem = root;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                list.add(elem.asInteger());
            }
            elem = elem.nextInstance;
        }
        return list;
    }

    @Override
    public Vector<Integer> getHeaderIntegerValues(byte[] header) throws NumberFormatException {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderIntegerValues(b): " + key.getName());
        }
        return this.getHeaderIntegerValues(this.findHeader(key));
    }

    @Override
    public Vector<Integer> getHeaderIntegerValues(HeaderKeys key) throws NumberFormatException {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderIntegerValues(h): " + key.getName());
        }
        return this.getHeaderIntegerValues(this.findHeader(key));
    }

    @Override
    public Vector<Integer> getHeaderIntegerValues(String header) throws NumberFormatException {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderIntegerValues(s): " + header);
        }
        return this.getHeaderIntegerValues(this.findHeader(this.findKey(header)));
    }

    @Override
    public String getHeaderAsString(HeaderKeys key) {
        String val;
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(key);
        String string = val = null != elem ? elem.getStringValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsString(h): " + key.getName() + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public String getHeaderAsString(String header) {
        String val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(this.findKey(header));
        String string = val = null != elem ? elem.getStringValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsString(s): " + header + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public String getHeaderAsString(byte[] header) {
        String val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        HeaderElement elem = this.findHeader(key);
        String string = val = null != elem ? elem.getStringValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsString(b,i): " + key.getName() + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public String getHeaderAsString(HeaderKeys key, int instance) {
        String val;
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(key, instance);
        String string = val = null != elem ? elem.getStringValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsString(h,i): " + key.getName() + " " + instance + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public String getHeaderAsString(String header, int instance) {
        String val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement elem = this.findHeader(this.findKey(header), instance);
        String string = val = null != elem ? elem.getStringValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsString(s,i): " + header + " " + instance + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    @Override
    public String getHeaderAsString(byte[] header, int instance) {
        String val;
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        HeaderElement elem = this.findHeader(key, instance);
        String string = val = null != elem ? elem.getStringValue() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderAsString(b,i): " + key.getName() + " " + instance + " [" + (null != elem ? elem.getDebugValue() : null) + "]");
        }
        return val;
    }

    private Vector<byte[]> getHeaderByteArrayValues(HeaderElement root) {
        Vector<byte[]> vals = new Vector<byte[]>();
        HeaderElement elem = root;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                vals.add(elem.getByteArrayValue());
            }
            elem = elem.nextInstance;
        }
        return vals;
    }

    @Override
    public Vector<byte[]> getHeaderByteArrayValues(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderByteArrayValues(h): " + key.getName());
        }
        return this.getHeaderByteArrayValues(this.findHeader(key));
    }

    @Override
    public Vector<byte[]> getHeaderByteArrayValues(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderByteArrayValues(s): " + header);
        }
        return this.getHeaderByteArrayValues(this.findHeader(this.findKey(header)));
    }

    @Override
    public Vector<byte[]> getHeaderByteArrayValues(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderByteArrayValues(b): " + key.getName());
        }
        return this.getHeaderByteArrayValues(this.findHeader(key));
    }

    private Vector<String> getHeaderStringValues(HeaderElement root) {
        Vector<String> vals = new Vector<String>();
        HeaderElement elem = root;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                vals.add(elem.getStringValue());
            }
            elem = elem.nextInstance;
        }
        return vals;
    }

    @Override
    public Vector<String> getHeaderStringValues(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderStringValues(h): " + key.getName());
        }
        return this.getHeaderStringValues(this.findHeader(key));
    }

    @Override
    public Vector<String> getHeaderStringValues(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderStringValues(s): " + header);
        }
        return this.getHeaderStringValues(this.findHeader(this.findKey(header)));
    }

    @Override
    public Vector<String> getHeaderStringValues(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderStringValues(b): " + key.getName());
        }
        return this.getHeaderStringValues(this.findHeader(key));
    }

    @Override
    public Vector<byte[]> getHeaderTokens(HeaderKeys key, byte delimiter) {
        return this.getHeaderTokens(key, delimiter, 0);
    }

    @Override
    public Vector<byte[]> getHeaderTokens(String header, byte delimiter) {
        return this.getHeaderTokens(header, delimiter, 0);
    }

    @Override
    public Vector<byte[]> getHeaderTokens(byte[] header, byte delimiter) {
        return this.getHeaderTokens(header, delimiter, 0);
    }

    private Vector<byte[]> getHeaderTokens(HeaderElement elem, byte delim) {
        if (null != elem) {
            return GenericUtils.byteArrayTokenize(elem.getByteArrayValue(), delim);
        }
        return new Vector<byte[]>();
    }

    @Override
    public Vector<byte[]> getHeaderTokens(HeaderKeys key, byte delimiter, int instance) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderTokens(h,d,i): " + key.getName() + " " + (char)delimiter + " " + instance);
        }
        return this.getHeaderTokens(this.findHeader(key, instance), delimiter);
    }

    @Override
    public Vector<byte[]> getHeaderTokens(String header, byte delimiter, int instance) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderTokens(s,d,i): " + header + " " + (char)delimiter + " " + instance);
        }
        return this.getHeaderTokens(this.findHeader(this.findKey(header), instance), delimiter);
    }

    @Override
    public Vector<byte[]> getHeaderTokens(byte[] header, byte delimiter, int instance) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getHeaderTokens(b,d,i): " + key.getName() + " " + (char)delimiter + " " + instance);
        }
        return this.getHeaderTokens(this.findHeader(key, instance), delimiter);
    }

    @Override
    public int getPositionOfHeader(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.findSequencePosition(this.findHeader(key));
    }

    @Override
    public int getPositionOfHeader(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.findSequencePosition(this.findHeader(this.findKey(header)));
    }

    @Override
    public int getPositionOfHeader(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.findSequencePosition(this.findHeader(this.findKey(header)));
    }

    @Override
    public int getNumberOfHeaderInstances(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(this.findKey(header)));
    }

    @Override
    public int getNumberOfHeaderInstances(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(this.findKey(header)));
    }

    @Override
    public int getNumberOfHeaderInstances(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(key));
    }

    @Override
    public boolean containsHeader(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(this.findKey(header));
    }

    @Override
    public boolean containsHeader(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(this.findKey(header));
    }

    @Override
    public boolean containsHeader(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(key);
    }

    @Override
    public WsByteBuffer[] marshallBinaryHeaders(WsByteBuffer[] src) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallBinaryHeaders");
        }
        this.preMarshallHeaders();
        WsByteBuffer[] buffers = src;
        if (null == buffers) {
            buffers = new WsByteBuffer[]{this.allocateBuffer(this.outgoingHdrBufferSize)};
            this.bytePosition = 0;
        }
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            buffers = this.marshallBinaryHeader(buffers, elem);
            elem = elem.nextSequence;
        }
        buffers = this.putInt(0, buffers);
        buffers = this.flushCache(buffers);
        buffers[buffers.length - 1].flip();
        this.postMarshallHeaders();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallBinaryHeaders");
        }
        return buffers;
    }

    @Override
    public WsByteBuffer[] marshallHeaders(WsByteBuffer[] src) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallHeaders");
        }
        this.preMarshallHeaders();
        WsByteBuffer[] buffers = src;
        if (null != this.parseBuffers[0] && !this.overHeaderChangeLimit()) {
            buffers = this.marshallReuseHeaders(src);
        } else {
            if (null == buffers) {
                buffers = new WsByteBuffer[]{this.allocateBuffer(this.outgoingHdrBufferSize)};
                this.bytePosition = 0;
            }
            HeaderElement elem = this.hdrSequence;
            while (null != elem) {
                buffers = this.marshallHeader(buffers, elem);
                elem = elem.nextSequence;
            }
            buffers = this.putBytes(BNFHeaders.EOL, buffers);
            buffers = this.flushCache(buffers);
            buffers[buffers.length - 1].flip();
        }
        this.postMarshallHeaders();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallHeaders");
        }
        return buffers;
    }

    protected boolean filterAdd(HeaderKeys key, byte[] value) {
        return true;
    }

    protected void filterRemove(HeaderKeys key, byte[] value) {
    }

    private void scribbleWhiteSpace(WsByteBuffer buffer, int start, int stop) {
        if (buffer.hasArray()) {
            byte[] data = buffer.array();
            for (int i = start; i < stop; ++i) {
                data[i] = 32;
            }
        } else {
            int partial;
            if (null == whitespace) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Allocating static whitespace data");
                }
                whitespace = new byte[1024];
                for (int i = 0; i < 1024; ++i) {
                    BNFHeadersImpl.whitespace[i] = 32;
                }
            }
            buffer.position(start);
            for (int len = stop - start; len > 0; len -= partial) {
                if (whitespace.length >= len) {
                    buffer.put(whitespace, 0, len);
                    break;
                }
                partial = whitespace.length;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Scribbling " + partial + " bytes of whitespace");
                }
                buffer.put(whitespace, 0, partial);
            }
        }
    }

    private void eraseValue(HeaderElement elem) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Erasing existing header: " + elem.getName());
        }
        int next_index = this.lastCRLFBufferIndex;
        int next_pos = this.lastCRLFPosition;
        if (null != elem.nextSequence && !elem.nextSequence.wasAdded()) {
            next_index = elem.nextSequence.getLastCRLFBufferIndex();
            next_pos = elem.nextSequence.getLastCRLFPosition();
        }
        int start = elem.getLastCRLFPosition();
        for (int x = elem.getLastCRLFBufferIndex(); x < next_index; ++x) {
            this.parseBuffers[x].position(start);
            this.parseBuffers[x].limit(start);
            start = 0;
        }
        this.scribbleWhiteSpace(this.parseBuffers[next_index], start, next_pos);
    }

    private int overlayBytes(byte[] data, int inOffset, int inLength, int inIndex) {
        int length = inLength;
        int offset = inOffset;
        int index = inIndex;
        WsByteBuffer buffer = this.parseBuffers[index];
        if (-1 == length) {
            length = data.length;
        }
        while (index <= this.parseIndex) {
            int remaining = buffer.remaining();
            if (remaining >= length) {
                buffer.put(data, offset, length);
                return index;
            }
            buffer.put(data, offset, remaining);
            offset += remaining;
            length -= remaining;
            buffer = this.parseBuffers[++index];
            buffer.position(0);
        }
        return index;
    }

    private void overlayValue(HeaderElement elem) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Overlaying existing header: " + elem.getName());
        }
        int next_index = this.lastCRLFBufferIndex;
        int next_pos = this.lastCRLFPosition;
        if (null != elem.nextSequence && !elem.nextSequence.wasAdded()) {
            next_index = elem.nextSequence.getLastCRLFBufferIndex();
            next_pos = elem.nextSequence.getLastCRLFPosition();
        }
        WsByteBuffer buffer = this.parseBuffers[elem.getLastCRLFBufferIndex()];
        buffer.position(elem.getLastCRLFPosition() + (elem.isLastCRLFaCR() ? 2 : 1));
        if (next_index == elem.getLastCRLFBufferIndex()) {
            buffer.put(elem.getHeaderKey().getMarshalledByteArray(this.foundCompactHeader()));
            buffer.put(elem.getRawByteArrayValue(), elem.getOffset(), elem.getValueLength());
        } else {
            int index = elem.getLastCRLFBufferIndex();
            index = this.overlayBytes(elem.getHeaderKey().getMarshalledByteArray(this.foundCompactHeader()), 0, -1, index);
            index = this.overlayBytes(elem.getRawByteArrayValue(), elem.getOffset(), elem.getValueLength(), index);
            buffer = this.parseBuffers[index];
        }
        int start = buffer.position();
        if (start < next_pos) {
            this.scribbleWhiteSpace(buffer, start, next_pos);
        }
    }

    private WsByteBuffer[] marshallAddedHeaders(WsByteBuffer[] inBuffers, int index) {
        WsByteBuffer[] buffers = inBuffers;
        buffers[index] = this.allocateBuffer(this.outgoingHdrBufferSize);
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            if (elem.wasAdded()) {
                buffers = this.marshallHeader(buffers, elem);
            }
            elem = elem.nextSequence;
        }
        buffers = this.putBytes(BNFHeaders.EOL, buffers);
        buffers = this.flushCache(buffers);
        buffers[buffers.length - 1].flip();
        return buffers;
    }

    private WsByteBuffer[] marshallReuseHeaders(WsByteBuffer[] inBuffers) {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        WsByteBuffer[] src = inBuffers;
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug(tc, "Marshalling headers and re-using buffers, change=" + this.headerChangeCount + ", add=" + this.headerAddCount + ", src=" + src);
        }
        HeaderElement elem = this.hdrSequence;
        WsByteBuffer[] buffers = src;
        int size = this.parseIndex + (0 < this.headerAddCount ? 2 : 1);
        int output = 0;
        int input = 0;
        if (null == src || 0 == src.length) {
            buffers = new WsByteBuffer[size];
        } else {
            src = this.flushCache(src);
            src[src.length - 1].flip();
            int firstHeaderBuffer = elem.getLastCRLFBufferIndex();
            for (int i = 0; i < firstHeaderBuffer; ++i) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trimming first line data from " + this.parseBuffers[i]);
                }
                this.parseBuffersStartPos[i] = this.parseBuffers[i].limit();
            }
            int firstHeaderPos = elem.getLastCRLFPosition() + (elem.isLastCRLFaCR() ? 2 : 1);
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting first buffer with headers pos to " + firstHeaderPos);
            }
            this.parseBuffersStartPos[firstHeaderBuffer] = firstHeaderPos;
            size = size - firstHeaderBuffer + src.length;
            buffers = new WsByteBuffer[size];
            System.arraycopy(src, 0, buffers, 0, src.length);
            output = src.length;
            input = firstHeaderBuffer;
        }
        if (0 < this.headerChangeCount) {
            elem = this.hdrSequence;
            int i = 0;
            while (i < this.headerChangeCount && null != elem && -1 != elem.getLastCRLFBufferIndex()) {
                if (elem.wasRemoved()) {
                    this.eraseValue(elem);
                    ++i;
                } else if (elem.wasChanged()) {
                    this.overlayValue(elem);
                    ++i;
                }
                elem = elem.nextSequence;
            }
        }
        while (input < this.parseIndex) {
            buffers[output] = this.parseBuffers[input];
            buffers[output].position(this.parseBuffersStartPos[input]);
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Copying existing parse buffer: " + buffers[output]);
            }
            ++input;
            ++output;
        }
        int endPos = this.eohPosition;
        if (0 < this.headerAddCount) {
            endPos = this.lastCRLFPosition + 1;
            if (this.lastCRLFisCR) {
                ++endPos;
            }
        }
        WsByteBuffer buffer = this.parseBuffers[input];
        int pos = buffer.position();
        int lim = buffer.limit();
        buffer.position(this.parseBuffersStartPos[input]);
        buffer.limit(endPos);
        buffers[output] = buffer.slice();
        this.addToCreatedBuffer(buffers[output]);
        buffer.limit(lim);
        buffer.position(pos);
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sliced last header buffer: " + buffers[output]);
        }
        if (0 < this.headerAddCount) {
            buffers = this.marshallAddedHeaders(buffers, ++output);
        }
        return buffers;
    }

    private boolean moveHeader(HeaderElement elem, int position) {
        if (null != elem) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "moveHeader: " + elem.getName() + " to " + position);
            }
            this.bOverChangeLimit = true;
            this.removeHeaderFromSequence(elem);
            this.addToSequenceList(position, elem);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveHeader(HeaderKeys key, int position) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.moveHeader(this.findHeader(key), position);
    }

    @Override
    public boolean moveHeader(String header, int position) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.moveHeader(this.findHeader(this.findKey(header)), position);
    }

    @Override
    public boolean moveHeader(byte[] header, int position) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.moveHeader(this.findHeader(this.findKey(header)), position);
    }

    @Override
    public boolean parseBinaryHeaders(WsByteBuffer buff, HeaderKeys keys) throws MalformedMessageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing binary headers with input buff: " + buff);
        }
        if (null == this.parsedToken) {
            this.createCacheToken(4);
        }
        boolean complete = false;
        block8: while (!complete) {
            if (!this.fillCacheToken(buff)) {
                return false;
            }
            switch (this.binaryParsingState) {
                case 1: {
                    int value = GenericUtils.asInt(this.parsedToken);
                    if (0 == value) {
                        complete = true;
                        continue block8;
                    }
                    if (1 == value) {
                        this.binaryParsingState = 2;
                        this.resetCacheToken(4);
                        continue block8;
                    }
                    if (2 != value) continue block8;
                    this.binaryParsingState = 3;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 2: {
                    HeaderKeys key = (HeaderKeys)keys.getEnumByOrdinal(GenericUtils.asInt(this.parsedToken));
                    this.currentElem = this.getElement(key);
                    this.binaryParsingState = 5;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 3: {
                    this.binaryParsingState = 4;
                    this.resetCacheToken(GenericUtils.asInt(this.parsedToken));
                    continue block8;
                }
                case 4: {
                    this.currentElem = this.getElement(this.findKey(this.parsedToken));
                    this.binaryParsingState = 5;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 5: {
                    this.binaryParsingState = 6;
                    this.resetCacheToken(GenericUtils.asInt(this.parsedToken));
                    continue block8;
                }
                case 6: {
                    this.setHeaderValue();
                    this.binaryParsingState = 1;
                    this.createCacheToken(4);
                    continue block8;
                }
            }
            throw new MalformedMessageException("Invalid state in headers: " + this.binaryParsingState);
        }
        this.eohPosition = this.isByteBufferArray ? this.bytePosition : buff.position() - (this.byteLimit - this.bytePosition);
        buff.position(this.eohPosition);
        this.resetByteCache();
        this.clearCacheToken();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "End of binary headers at pos: " + this.eohPosition);
        }
        return true;
    }

    @Override
    public boolean parseHeaders(WsByteBuffer buff, boolean bExtractValue) throws MalformedMessageException {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing headers with input buff: " + buff);
        }
        boolean rc = false;
        while (-1 == this.eohPosition) {
            switch (this.stateOfParsing) {
                case 0: {
                    rc = this.parseHeaderName(buff);
                    break;
                }
                case 1: {
                    rc = bExtractValue || this.bIsMultiLine ? this.parseHeaderValueExtract(buff) : this.parseHeaderValueNonExtract(buff);
                    break;
                }
                case 2: {
                    rc = this.parseCRLFs(buff);
                    break;
                }
                default: {
                    if (!bTrace || !tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Found invalid parsing ID of " + this.stateOfParsing);
                }
            }
            if (rc) continue;
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Need more data");
            }
            this.resetByteCache();
            return false;
        }
        this.resetByteCache();
        this.headerChangeCount = 0;
        this.headerAddCount = 0;
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug(tc, "End of headers found at position " + this.eohPosition);
        }
        return true;
    }

    @Override
    public void postMarshallHeaders() {
    }

    @Override
    public void preMarshallHeaders() {
    }

    private void checkPrependedHeader(HeaderElement root) {
        HeaderElement elem = root.nextInstance;
        while (null != elem) {
            if (!elem.wasAdded()) {
                this.bOverChangeLimit = true;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "New header is before old one, disabling change limit");
                break;
            }
            elem = elem.nextInstance;
        }
    }

    @Override
    public void prependHeader(HeaderKeys key, byte[] value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(h,b): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        HeaderElement elem = this.getElement(key);
        elem.setByteArrayValue(value);
        this.addHeader(elem, false, true);
        this.checkPrependedHeader(elem);
    }

    @Override
    public void prependHeader(HeaderKeys key, byte[] value, int offset, int length) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(h,b,i,i): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        HeaderElement elem = this.getElement(key);
        elem.setByteArrayValue(value, offset, length);
        this.addHeader(elem, false, true);
        this.checkPrependedHeader(elem);
    }

    @Override
    public void prependHeader(HeaderKeys key, String value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(h,s): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value);
        }
        HeaderElement elem = this.getElement(key);
        elem.setStringValue(value);
        this.addHeader(elem, false, true);
        this.checkPrependedHeader(elem);
    }

    @Override
    public void prependHeader(String header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(s,b): " + header);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setByteArrayValue(value);
        this.addHeader(elem, false, true);
        this.checkPrependedHeader(elem);
    }

    @Override
    public void prependHeader(String header, byte[] value, int offset, int length) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(s,b,i,i): " + header);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setByteArrayValue(value, offset, length);
        this.addHeader(elem, false, true);
        this.checkPrependedHeader(elem);
    }

    @Override
    public void prependHeader(byte[] header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(b,b): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        HeaderElement elem = this.getElement(key);
        elem.setByteArrayValue(value);
        this.addHeader(elem, false, true);
        this.checkPrependedHeader(elem);
    }

    @Override
    public void prependHeader(byte[] header, byte[] value, int offset, int length) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(b,b,i,i): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        HeaderElement elem = this.getElement(key);
        elem.setByteArrayValue(value, offset, length);
        this.addHeader(elem, false, true);
        this.checkPrependedHeader(elem);
    }

    @Override
    public void prependHeader(String header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(s,s): " + header);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value);
        }
        HeaderElement elem = this.getElement(this.findKey(header));
        elem.setStringValue(value);
        this.addHeader(elem, false, true);
        this.checkPrependedHeader(elem);
    }

    @Override
    public void prependHeader(byte[] header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "prependHeader(b,s): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value);
        }
        HeaderElement elem = this.getElement(key);
        elem.setStringValue(value);
        this.addHeader(elem, false, true);
        this.checkPrependedHeader(elem);
    }

    @Override
    public void removeAllHeaders() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllHeaders()");
        }
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            if (elem.getHeaderKey().useFilters()) {
                this.filterRemove(elem.getHeaderKey(), null);
            }
            elem.remove();
            elem = elem.nextSequence;
        }
        this.numberOfHeaders = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllHeaders()");
        }
    }

    private void clearAllHeaders() {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearAllHeaders()");
        }
        HeaderElement elem = this.hdrSequence;
        while (null != elem) {
            HeaderElement next = elem.nextSequence;
            HeaderKeys key = elem.getHeaderKey();
            int ord = key.getOrdinal();
            if (null != this.storage[ord]) {
                if (key.useFilters()) {
                    this.filterRemove(key, null);
                }
                this.storage[ord] = null;
            }
            elem.destroy();
            elem = next;
        }
        this.hdrSequence = null;
        this.lastHdrInSequence = null;
        this.numberOfHeaders = 0;
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAllHeaders()");
        }
    }

    @Override
    public void removeHeader(HeaderKeys key) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(h): " + key.getName());
        }
        this.removeHdrInstances(this.findHeader(key), true);
    }

    @Override
    public void removeHeader(String header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(s): " + header);
        }
        this.removeHdrInstances(this.findHeader(this.findKey(header)), true);
    }

    @Override
    public void removeHeader(byte[] header) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(b): " + key.getName());
        }
        this.removeHdrInstances(this.findHeader(key), true);
    }

    @Override
    public void removeHeader(HeaderKeys key, int instance) {
        if (null == key) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(h,i): " + key.getName() + " " + instance);
        }
        this.removeHdr(this.findHeader(key, instance));
    }

    @Override
    public void removeHeader(String header, int instance) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(s,i): " + header + " " + instance);
        }
        this.removeHdr(this.findHeader(this.findKey(header), instance));
    }

    @Override
    public void removeHeader(byte[] header, int instance) {
        if (null == header) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeHeader(b,i): " + key.getName() + " " + instance);
        }
        this.removeHdr(this.findHeader(key, instance));
    }

    public void removeSpecialHeader(HeaderKeys key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeSpecialHeader(h): " + key.getName());
        }
        this.removeHdrInstances(this.findHeader(key), false);
    }

    @Override
    public void replaceHeader(HeaderKeys key, int instance, byte[] value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(h,i,b): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        this.replaceHdr(key, value, instance);
    }

    @Override
    public void replaceHeader(HeaderKeys key, int instance, byte[] value, int offset, int length) {
        if (null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(h,i,b,i,i): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        byte[] temp = new byte[length];
        System.arraycopy(value, offset, temp, 0, length);
        this.replaceHdr(key, temp, instance);
    }

    @Override
    public void replaceHeader(HeaderKeys key, int instance, String value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(h,i,s): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value);
        }
        this.replaceHdr(key, value, instance);
    }

    @Override
    public void replaceHeader(String header, int instance, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(s,i,b): " + header);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        this.replaceHdr(this.findKey(header), value, instance);
    }

    @Override
    public void replaceHeader(String header, int instance, byte[] value, int offset, int length) {
        if (null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(s,i,b,i,i): " + header);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        byte[] temp = new byte[length];
        System.arraycopy(value, offset, temp, 0, length);
        this.replaceHdr(this.findKey(header), temp, instance);
    }

    @Override
    public void replaceHeader(byte[] header, int instance, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(b,i,b): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        this.replaceHdr(this.findKey(header), value, instance);
    }

    @Override
    public void replaceHeader(byte[] header, int instance, byte[] value, int offset, int length) {
        if (null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(b,i,b,i,i): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        byte[] temp = new byte[length];
        System.arraycopy(value, offset, temp, 0, length);
        this.replaceHdr(key, temp, instance);
    }

    @Override
    public void replaceHeader(String header, int instance, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(s,i,s): " + header);
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value);
        }
        this.replaceHdr(this.findKey(header), value, instance);
    }

    @Override
    public void replaceHeader(byte[] header, int instance, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "replaceHeader(b,i,s): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value);
        }
        this.replaceHdr(key, value, instance);
    }

    public WsByteBuffer returnCurrentBuffer() {
        WsByteBuffer buff = null;
        if (-1 != this.parseIndex) {
            buff = this.parseBuffers[this.parseIndex];
            --this.parseIndex;
        }
        return buff;
    }

    @Override
    public void setHeader(String header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(s,b): " + header);
        }
        this.setHeader(this.findKey(header), value);
    }

    @Override
    public void setHeader(String header, byte[] value, int offset, int length) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(s,b,i,i): " + header);
        }
        this.setHeader(this.findKey(header), value, offset, length);
    }

    @Override
    public void setHeader(byte[] header, byte[] value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(b,b): " + key.getName());
        }
        this.setHeader(key, value);
    }

    @Override
    public void setHeader(byte[] header, byte[] value, int offset, int length) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(b,b,i,i): " + key.getName());
        }
        this.setHeader(key, value, offset, length);
    }

    @Override
    public void setHeader(HeaderKeys key, byte[] value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(h,b): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, 0, value.length);
        }
        if (key.useFilters()) {
            HeaderElement elem = this.findHeader(key);
            if (null != elem) {
                this.filterRemove(key, null);
            }
            if (!this.filterAdd(key, value)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "New value disallowed: " + GenericUtils.getEnglishString(value));
                }
                if (null != elem) {
                    this.removeHdrInstances(elem, false);
                }
                return;
            }
        }
        this.createSingleHeader(key, value, 0, value.length);
    }

    @Override
    public void setHeader(HeaderKeys key, byte[] value, int offset, int length) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(h,b,i,i): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value, offset, length);
        }
        if (key.useFilters()) {
            HeaderElement elem = this.findHeader(key);
            if (null != elem) {
                this.filterRemove(key, null);
            }
            byte[] temp = new byte[length];
            System.arraycopy(value, offset, temp, 0, length);
            if (!this.filterAdd(key, temp)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "New value disallowed: " + GenericUtils.getEnglishString(temp));
                }
                if (null != elem) {
                    this.removeHdrInstances(elem, false);
                }
                return;
            }
        }
        this.createSingleHeader(key, value, offset, length);
    }

    @Override
    public void setHeader(HeaderKeys key, String value) {
        if (null == key || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(h,s): " + key.getName());
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(value);
        }
        if (key.useFilters()) {
            HeaderElement elem = this.findHeader(key);
            if (null != elem) {
                this.filterRemove(key, null);
            }
            if (!this.filterAdd(key, GenericUtils.getEnglishBytes(value))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "New value disallowed: " + value);
                }
                if (null != elem) {
                    this.removeHdrInstances(elem, false);
                }
                return;
            }
        }
        this.createSingleHeader(key, value);
    }

    @Override
    public void setHeader(String header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(s,s): " + header);
        }
        this.setHeader(this.findKey(header), value);
    }

    @Override
    public void setHeader(byte[] header, String value) {
        if (null == header || null == value) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys key = this.findKey(header);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setHeader(b,s): " + key.getName());
        }
        this.setHeader(key, value);
    }

    private void createSingleHeader(HeaderKeys key, byte[] value, int offset, int length) {
        HeaderElement elem = this.findHeader(key);
        if (null != elem) {
            if (null != elem.nextInstance) {
                HeaderElement temp = elem.nextInstance;
                while (null != temp) {
                    temp.remove();
                    temp = temp.nextInstance;
                }
            }
            if (-1 != this.headerChangeLimit) {
                if (length <= elem.getValueLength()) {
                    ++this.headerChangeCount;
                    elem.setByteArrayValue(value, offset, length);
                } else {
                    elem.remove();
                    elem = null;
                }
            } else {
                elem.setByteArrayValue(value, offset, length);
            }
        }
        if (null == elem) {
            elem = this.getElement(key);
            elem.setByteArrayValue(value, offset, length);
            this.addHeader(elem, true, false);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing header " + key.getName() + " with [" + elem.getDebugValue() + "]");
        }
    }

    private void createSingleHeader(HeaderKeys key, String value) {
        HeaderElement elem = this.findHeader(key);
        if (null != elem) {
            if (null != elem.nextInstance) {
                HeaderElement temp = elem.nextInstance;
                while (null != temp) {
                    temp.remove();
                    temp = temp.nextInstance;
                }
            }
            if (-1 != this.headerChangeLimit) {
                if (value.length() <= elem.getValueLength()) {
                    ++this.headerChangeCount;
                    elem.setStringValue(value);
                } else {
                    elem.remove();
                    elem = null;
                }
            } else {
                elem.setStringValue(value);
            }
        }
        if (null == elem) {
            elem = this.getElement(key);
            elem.setStringValue(value);
            this.addHeader(elem, true, false);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing header " + key.getName() + " with [" + elem.getDebugValue() + "]");
        }
    }

    private void addHeader(HeaderElement elem, boolean bLast, boolean bFilter) {
        boolean rc;
        HeaderKeys key = elem.getHeaderKey();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Adding header [" + key.getName() + "] with value [" + elem.getDebugValue() + "]");
        }
        if (bFilter && key.useFilters() && !this.filterAdd(key, elem.getByteArrayValue())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "filter disallowed: " + elem.getDebugValue());
            }
            return;
        }
        this.incrementHeaderCounter();
        HeaderElement root = this.findHeader(key);
        boolean bl = rc = bLast ? this.addInstanceOfElement(root, elem) : this.addLeadingInstanceOfElement(root, elem);
        if (rc) {
            int ord = key.getOrdinal();
            if (ord >= this.storage.length) {
                HeaderElement[] temp = new HeaderElement[ord + 10];
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Increasing header storage to " + temp.length);
                }
                for (int i = 0; i < this.storage.length; ++i) {
                    temp[i] = this.storage[i];
                }
                this.storage = temp;
            }
            this.storage[ord] = elem;
        }
    }

    private HeaderElement getElement(HeaderKeys key) {
        HeaderElement elem = this.headerElements;
        if (null != elem) {
            this.headerElements = elem.nextInstance;
            elem.nextInstance = null;
            elem.init(key);
        } else {
            elem = new HeaderElement(key, this);
        }
        return elem;
    }

    protected void freeElement(HeaderElement elem) {
        elem.nextInstance = this.headerElements;
        this.headerElements = elem;
    }

    protected abstract HeaderKeys findKey(String var1);

    protected abstract HeaderKeys findKey(byte[] var1);

    protected abstract HeaderKeys findKey(byte[] var1, int var2, int var3);

    private HeaderElement findHeader(HeaderKeys key, int instance) {
        int ord = key.getOrdinal();
        if (ord >= this.storage.length) {
            return null;
        }
        HeaderElement elem = this.storage[ord];
        int i = -1;
        while (null != elem) {
            if (!elem.wasRemoved() && ++i == instance) {
                return elem;
            }
            elem = elem.nextInstance;
        }
        return null;
    }

    private HeaderElement findHeader(HeaderKeys key) {
        int ord = key.getOrdinal();
        if (ord >= this.storage.length) {
            return null;
        }
        HeaderElement elem = this.storage[ord];
        while (null != elem && elem.wasRemoved()) {
            elem = elem.nextInstance;
        }
        return elem;
    }

    private void removeHdr(HeaderElement elem) {
        if (null == elem) {
            return;
        }
        HeaderKeys key = elem.getHeaderKey();
        elem.remove();
        if (key.useFilters()) {
            this.filterRemove(key, elem.getByteArrayValue());
        }
    }

    private void removeHdrInstances(HeaderElement root, boolean bFilter) {
        if (null == root) {
            return;
        }
        HeaderKeys key = root.getHeaderKey();
        if (bFilter && key.useFilters()) {
            this.filterRemove(key, null);
        }
        HeaderElement elem = root;
        while (null != elem) {
            elem.remove();
            elem = elem.nextInstance;
        }
    }

    private void replaceHdr(HeaderKeys key, byte[] value, int instance) {
        HeaderElement elem;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing header " + key.getName() + " (" + instance + ")");
        }
        if (null != (elem = this.findHeader(key, instance))) {
            if (key.useFilters()) {
                byte[] old = elem.getByteArrayValue();
                this.filterRemove(key, old);
                if (!this.filterAdd(key, value)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "replaceHeader failed filterAdd: " + GenericUtils.getEnglishString(value));
                    }
                    this.filterAdd(key, old);
                    return;
                }
            }
            elem.setByteArrayValue(value);
            ++this.headerChangeCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Value replaced with [" + elem.getDebugValue() + "]");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Instance not found");
        }
    }

    private void replaceHdr(HeaderKeys key, String value, int instance) {
        HeaderElement elem;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing header " + key.getName() + " (" + instance + ")");
        }
        if (null != (elem = this.findHeader(key, instance))) {
            if (key.useFilters()) {
                byte[] old = elem.getByteArrayValue();
                this.filterRemove(key, old);
                if (!this.filterAdd(key, GenericUtils.getEnglishBytes(value))) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "replaceHeader failed filterAdd: " + value);
                    }
                    this.filterAdd(key, old);
                    return;
                }
            }
            elem.setStringValue(value);
            ++this.headerChangeCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Value replaced with [" + elem.getDebugValue() + "]");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Instance not found");
        }
    }

    protected void setSpecialHeader(HeaderKeys key, byte[] value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setSpecialHeader(h,b[]): " + key.getName());
        }
        this.removeHdrInstances(this.findHeader(key), false);
        HeaderElement elem = this.getElement(key);
        elem.setByteArrayValue(value);
        this.addHeader(elem, true, false);
    }

    protected void setSpecialHeader(HeaderKeys key, String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setSpecialHeader(h,s): " + key.getName());
        }
        this.removeHdrInstances(this.findHeader(key), false);
        HeaderElement elem = this.getElement(key);
        elem.setStringValue(value);
        this.addHeader(elem, true, false);
    }

    protected boolean overHeaderChangeLimit() {
        if (this.bOverChangeLimit || -1 == this.parseIndex) {
            return true;
        }
        this.bOverChangeLimit = this.headerChangeCount >= this.headerChangeLimit;
        return this.bOverChangeLimit;
    }

    public void setHeaderChangeLimit(int limit) {
        this.headerChangeLimit = limit;
        this.bOverChangeLimit = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting header change limit to " + limit);
        }
    }

    public int getHeaderChangeLimit() {
        return this.headerChangeLimit;
    }

    protected WsByteBuffer[] marshallHeader(WsByteBuffer[] inBuffers, HeaderElement elem) {
        if (elem.wasRemoved()) {
            return inBuffers;
        }
        WsByteBuffer[] buffers = inBuffers;
        byte[] value = elem.getRawByteArrayValue();
        if (null != value) {
            buffers = this.putBytes(elem.getHeaderKey().getMarshalledByteArray(this.foundCompactHeader()), buffers);
            buffers = this.putBytes(value, elem.getOffset(), elem.getValueLength(), buffers);
            buffers = this.putBytes(BNFHeaders.EOL, buffers);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Marshalling: " + elem.getHeaderKey() + " [" + elem.getDebugValue() + "]");
            }
        }
        return buffers;
    }

    protected WsByteBuffer[] marshallBinaryHeader(WsByteBuffer[] inBuffers, HeaderElement elem) {
        if (elem.wasRemoved()) {
            return inBuffers;
        }
        WsByteBuffer[] buffers = inBuffers;
        byte[] value = elem.getRawByteArrayValue();
        if (null != value) {
            HeaderKeys key = elem.getHeaderKey();
            if (!key.isUndefined()) {
                buffers = this.putInt(1, buffers);
                buffers = this.putInt(elem.getHeaderKey().getOrdinal(), buffers);
            } else {
                buffers = this.putInt(2, buffers);
                buffers = this.putInt(key.getByteArray().length, buffers);
                buffers = this.putBytes(key.getByteArray(), buffers);
            }
            buffers = this.putInt(elem.getValueLength(), buffers);
            buffers = this.putBytes(value, elem.getOffset(), elem.getValueLength(), buffers);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Marshalling: " + elem.getName() + " [" + elem.getDebugValue() + "]");
            }
        }
        return buffers;
    }

    protected final int getBinaryParseState() {
        return this.binaryParsingState;
    }

    protected final void setBinaryParseState(int state) {
        this.binaryParsingState = state;
    }

    public WsByteBuffer allocateBuffer(int size) {
        WsByteBuffer wsbb = this.useDirectBuffer ? WsByteBufferPoolManagerImpl.getRef().allocateDirect(size) : WsByteBufferPoolManagerImpl.getRef().allocate(size);
        this.addToCreatedBuffer(wsbb);
        return wsbb;
    }

    public final WsByteBuffer getCurrentBuffer() {
        return this.currentReadBB;
    }

    public final void setCurrentBuffer(WsByteBuffer b) {
        this.currentReadBB = b;
    }

    @Override
    public void setDebugContext(Object o) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "debugContext set to " + o + " for " + this);
        }
        if (null != o) {
            this.debugContext = o;
        }
    }

    protected final Object getDebugContext() {
        return this.debugContext;
    }

    protected final int getIncomingBufferSize() {
        return this.incomingBufferSize;
    }

    protected final int getOutgoingBufferSize() {
        return this.outgoingHdrBufferSize;
    }

    protected final boolean shouldAllocateDirectBuffer() {
        return this.useDirectBuffer;
    }

    protected final void setParsedToken(byte[] token) {
        this.parsedToken = token;
    }

    protected final byte[] getParsedToken() {
        return this.parsedToken;
    }

    protected final int getByteCacheSize() {
        return this.byteCacheSize;
    }

    protected WsByteBuffer getParseBuffer(int index) {
        if (0 > index || index >= this.parseBuffers.length) {
            return null;
        }
        return this.parseBuffers[index];
    }

    public final int getBuffersIndex() {
        return this.parseIndex;
    }

    public void setLimitOfTokenSize(int size) {
        if (0 >= size) {
            throw new IllegalArgumentException("Invalid limit on token size: " + size);
        }
        this.limitTokenSize = size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Limit on token size now: " + this.limitTokenSize);
        }
    }

    public final int getLimitOfTokenSize() {
        return this.limitTokenSize;
    }

    public int getNumberOfHeaders() {
        return this.numberOfHeaders;
    }

    private void incrementHeaderCounter() {
        ++this.numberOfHeaders;
        ++this.headerAddCount;
        if (this.limitNumHeaders < this.numberOfHeaders) {
            String msg = "Too many headers in storage: " + this.numberOfHeaders;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            throw new IllegalArgumentException(msg);
        }
    }

    protected void decrementHeaderCounter() {
        --this.numberOfHeaders;
        ++this.headerChangeCount;
    }

    public final void setLimitOnNumberOfHeaders(int size) {
        if (0 >= size) {
            throw new IllegalArgumentException("Invalid limit on number headers: " + size);
        }
        this.limitNumHeaders = size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Limit on number of headers now: " + this.limitNumHeaders);
        }
    }

    public final int getLimitOnNumberOfHeaders() {
        return this.limitNumHeaders;
    }

    protected final void setHeaderValidation(boolean flag) {
        this.bHeaderValidation = flag;
    }

    private void checkHeaderValue(byte[] data, int offset, int length) {
        int index = offset + length - 1;
        if (index < 0) {
            return;
        }
        String error = null;
        if (10 == data[index] || 13 == data[index]) {
            error = "Illegal trailing EOL";
        }
        for (int i = offset; null == error && i < index; ++i) {
            if (13 == data[i]) {
                if (10 == data[i + 1]) continue;
                error = "Invalid CR not followed by LF";
                continue;
            }
            if (10 != data[i] || 9 == data[++i] || 32 == data[i]) continue;
            error = "Invalid LF not followed by whitespace";
        }
        if (null != error) {
            IllegalArgumentException iae = new IllegalArgumentException(error);
            FFDCFilter.processException((Throwable)iae, this.getClass().getName() + ".checkHeaderValue(byte[])", "1", this);
            throw iae;
        }
    }

    private void checkHeaderValue(String data) {
        int index = data.length() - 1;
        if (index < 0) {
            return;
        }
        String error = null;
        char c = data.charAt(index);
        if ('\n' == c || '\r' == c) {
            error = "Illegal trailing EOL";
        }
        for (int i = 0; null == error && i < index; ++i) {
            c = data.charAt(i);
            if ('\r' == c) {
                if ('\n' == data.charAt(i + 1)) continue;
                error = "Invalid CR not followed by LF";
                continue;
            }
            if ('\n' != c || '\t' == (c = data.charAt(++i)) || ' ' == c) continue;
            error = "Invalid LF not followed by whitespace";
        }
        if (null != error) {
            IllegalArgumentException iae = new IllegalArgumentException(error);
            FFDCFilter.processException((Throwable)iae, this.getClass().getName() + ".checkHeaderValue(String)", "1", this);
            throw iae;
        }
    }

    private int countInstances(HeaderElement root) {
        int count = 0;
        HeaderElement elem = root;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                ++count;
            }
            elem = elem.nextInstance;
        }
        return count;
    }

    private int compareByteArrays(HeaderElement list, byte[] value) {
        if (null == list) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Compare failed against nonexistant header");
            }
            return -1;
        }
        HeaderElement elem = list;
        while (null != elem) {
            if (!elem.wasRemoved()) {
                int x;
                byte[] elemValue = elem.getByteArrayValue();
                if (elemValue.length != value.length) {
                    elem = elem.nextInstance;
                    continue;
                }
                for (x = 0; x < elemValue.length && elemValue[x] == value[x]; ++x) {
                }
                if (x == elemValue.length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Compare found a match");
                    }
                    return 1;
                }
            }
            elem = elem.nextInstance;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Compare did not find a match");
        }
        return 0;
    }

    private int compareStrings(HeaderElement list, String value) {
        if (null == list) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Compare against missing header");
            }
            return -1;
        }
        HeaderElement elem = list;
        while (null != elem) {
            if (!elem.wasRemoved() && elem.getStringValue().equals(value)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Compare found a match");
                }
                return 1;
            }
            elem = elem.nextInstance;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Compare did not find a match");
        }
        return 0;
    }

    private int findSequencePosition(HeaderElement elem) {
        if (null != elem) {
            int i = 0;
            HeaderElement temp = this.hdrSequence;
            while (null != temp) {
                if (!temp.wasRemoved()) {
                    if (temp.equals(elem)) {
                        return i;
                    }
                    ++i;
                }
                temp = temp.nextSequence;
            }
        }
        return -1;
    }

    private boolean skipWhiteSpace(WsByteBuffer buff) {
        byte b;
        do {
            if (this.bytePosition < this.byteLimit || this.fillByteCache(buff)) continue;
            return false;
        } while (32 == (b = this.byteCache[this.bytePosition++]) || 9 == b);
        --this.bytePosition;
        return true;
    }

    private boolean addInstanceOfElement(HeaderElement root, HeaderElement elem) {
        this.addToSequenceList(elem);
        if (null == root) {
            return true;
        }
        HeaderElement prev = root;
        while (null != prev.nextInstance) {
            prev = prev.nextInstance;
        }
        prev.nextInstance = elem;
        return false;
    }

    private boolean addLeadingInstanceOfElement(HeaderElement root, HeaderElement elem) {
        if (null == root) {
            this.addToSequenceList(elem);
        } else {
            elem.nextInstance = root;
            this.prependHeaderInSequence(root, elem);
        }
        return true;
    }

    private void addToSequenceList(int position, HeaderElement elem) {
        if (null == this.hdrSequence) {
            this.hdrSequence = elem;
            this.lastHdrInSequence = elem;
        } else if (0 == position) {
            elem.nextSequence = this.hdrSequence;
            this.hdrSequence.prevSequence = elem;
            this.hdrSequence = elem;
        } else if (-1 == position) {
            this.lastHdrInSequence.nextSequence = elem;
            elem.prevSequence = this.lastHdrInSequence;
            this.lastHdrInSequence = elem;
        } else {
            HeaderElement temp;
            HeaderElement prev = temp = this.hdrSequence;
            for (int i = 0; i < position && null != temp; ++i) {
                prev = temp;
                temp = temp.nextSequence;
            }
            prev.nextSequence = elem;
            elem.prevSequence = prev;
            elem.nextSequence = temp;
            if (null != temp) {
                temp.prevSequence = elem;
            } else {
                this.lastHdrInSequence = elem;
            }
        }
    }

    private void addToSequenceList(HeaderElement elem) {
        if (null == this.hdrSequence) {
            this.hdrSequence = elem;
            this.lastHdrInSequence = elem;
        } else {
            this.lastHdrInSequence.nextSequence = elem;
            elem.prevSequence = this.lastHdrInSequence;
            this.lastHdrInSequence = elem;
        }
    }

    private void prependHeaderInSequence(HeaderElement oldNode, HeaderElement newNode) {
        HeaderElement prev = oldNode.prevSequence;
        newNode.nextSequence = oldNode;
        newNode.prevSequence = prev;
        oldNode.prevSequence = newNode;
        if (null != prev) {
            prev.nextSequence = newNode;
        } else {
            this.hdrSequence = newNode;
        }
    }

    private void removeHeaderFromSequence(HeaderElement elem) {
        HeaderElement next = elem.nextSequence;
        HeaderElement prev = elem.prevSequence;
        if (null != prev) {
            prev.nextSequence = next;
        } else {
            this.hdrSequence = next;
        }
        if (null != elem.nextSequence) {
            next.prevSequence = prev;
        } else {
            this.lastHdrInSequence = prev;
        }
        elem.nextSequence = null;
        elem.prevSequence = null;
    }

    protected WsByteBuffer[] putInt(int data, WsByteBuffer[] buffers) {
        return this.putBytes(GenericUtils.asBytes(data), buffers);
    }

    protected WsByteBuffer[] putByte(byte data, WsByteBuffer[] inBuffers) {
        WsByteBuffer[] buffers = inBuffers;
        this.byteCache[this.bytePosition] = data;
        ++this.bytePosition;
        if (this.bytePosition >= this.byteCacheSize) {
            buffers = this.flushFullCache(buffers);
        }
        return buffers;
    }

    protected WsByteBuffer[] putBytes(byte[] data, WsByteBuffer[] inBuffers) {
        WsByteBuffer[] buffers = inBuffers;
        int space_left = this.byteCacheSize - this.bytePosition;
        if (data.length <= space_left) {
            System.arraycopy(data, 0, this.byteCache, this.bytePosition, data.length);
            this.bytePosition += data.length;
        } else {
            buffers = this.flushCache(buffers);
            return GenericUtils.putByteArray(buffers, data, 0, data.length, this);
        }
        if (this.bytePosition == this.byteCacheSize) {
            buffers = this.flushFullCache(buffers);
        }
        return buffers;
    }

    protected WsByteBuffer[] putBytes(byte[] data, int offset, int length, WsByteBuffer[] inBuffers) {
        WsByteBuffer[] buffers = inBuffers;
        int space_left = this.byteCacheSize - this.bytePosition;
        if (length <= space_left) {
            System.arraycopy(data, offset, this.byteCache, this.bytePosition, length);
            this.bytePosition += length;
        } else {
            buffers = this.flushCache(buffers);
            return GenericUtils.putByteArray(buffers, data, offset, length, this);
        }
        if (this.bytePosition == this.byteCacheSize) {
            buffers = this.flushFullCache(buffers);
        }
        return buffers;
    }

    protected WsByteBuffer[] flushFullCache(WsByteBuffer[] buffers) {
        this.bytePosition = 0;
        return GenericUtils.putByteArray(buffers, this.byteCache, this);
    }

    protected WsByteBuffer[] flushCache(WsByteBuffer[] buffers) {
        int pos = this.bytePosition;
        if (0 == pos) {
            return buffers;
        }
        this.bytePosition = 0;
        return GenericUtils.putByteArray(buffers, this.byteCache, 0, pos, this);
    }

    protected final void resetByteCache() {
        if (this.isByteBufferArray) {
            this.byteCache = this.originalByteCache;
            this.isByteBufferArray = false;
        }
        this.bytePosition = 0;
        this.byteLimit = 0;
    }

    protected final void setBytePosition(int pos) {
        this.bytePosition = pos;
    }

    protected final void decrementBytePosition() {
        --this.bytePosition;
        if (0 > this.bytePosition && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Negative byteposition: " + this.bytePosition);
        }
    }

    protected final void decrementBytePositionIgnoringLFs() {
        --this.bytePosition;
        if (10 == this.byteCache[this.bytePosition]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "decrementILF found an LF character");
            }
            ++this.bytePosition;
        }
    }

    protected final int getBytePosition() {
        return this.bytePosition;
    }

    protected final int getByteLimit() {
        return this.byteLimit;
    }

    protected final void clearCacheToken() {
        this.parsedToken = null;
        this.parsedTokenLength = 0;
    }

    protected final void createCacheToken(int len) {
        this.parsedToken = new byte[len];
        this.parsedTokenLength = 0;
    }

    protected final void resetCacheToken(int len) {
        if (null == this.parsedToken || len != this.parsedToken.length) {
            this.parsedToken = new byte[len];
        }
        this.parsedTokenLength = 0;
    }

    protected final boolean fillCacheToken(WsByteBuffer buff) {
        int need_len;
        int curr_len = this.parsedTokenLength;
        int copy_len = need_len = this.parsedToken.length - curr_len;
        while (0 < need_len) {
            if (this.bytePosition >= this.byteLimit && !this.fillByteCache(buff)) {
                this.parsedTokenLength = curr_len;
                return false;
            }
            int available = this.byteLimit - this.bytePosition;
            copy_len = available < need_len ? available : need_len;
            System.arraycopy(this.byteCache, this.bytePosition, this.parsedToken, curr_len, copy_len);
            need_len -= copy_len;
            curr_len += copy_len;
            this.bytePosition += copy_len;
        }
        return true;
    }

    protected boolean fillByteCache(WsByteBuffer buff) {
        if (this.bytePosition < this.byteLimit) {
            return false;
        }
        if (buff.hasArray()) {
            this.bytePosition = buff.position();
            this.byteLimit = buff.limit();
            if (this.bytePosition == this.byteLimit) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Already parsed entire indirect buffer");
                }
                return false;
            }
            buff.position(this.byteLimit);
            this.byteCache = buff.array();
            this.isByteBufferArray = true;
            if (-1 != this.headerChangeLimit && -1 != this.parseIndex && -1 == this.parseBuffersStartPos[this.parseIndex]) {
                this.parseBuffersStartPos[this.parseIndex] = this.bytePosition;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Grabbed a Heap buffer's array");
            }
        } else {
            int size;
            if (this.isByteBufferArray) {
                this.byteCache = this.originalByteCache;
                this.isByteBufferArray = false;
            }
            if ((size = buff.remaining()) > this.byteCacheSize) {
                size = this.byteCacheSize;
            }
            this.bytePosition = 0;
            this.byteLimit = size;
            if (0 == this.byteLimit) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "fillByteCache: no data");
                }
                return false;
            }
            if (-1 != this.headerChangeLimit && -1 != this.parseIndex && -1 == this.parseBuffersStartPos[this.parseIndex]) {
                this.parseBuffersStartPos[this.parseIndex] = buff.position();
            }
            buff.get(this.byteCache, this.bytePosition, this.byteLimit);
        }
        return true;
    }

    private int findCurrentBufferPosition(WsByteBuffer buffer) {
        if (this.isByteBufferArray) {
            return this.bytePosition;
        }
        return buffer.position() - (this.byteLimit - this.bytePosition);
    }

    protected TokenCodes findCRLFTokenLength(WsByteBuffer buff) throws MalformedMessageException {
        TokenCodes rc = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == buff) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Null buffer provided");
            }
            return rc;
        }
        int length = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(buff)) {
            byte b;
            if (13 == (b = this.byteCache[this.bytePosition++])) {
                rc = TokenCodes.TOKEN_RC_DELIM;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(buff) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = true;
                break;
            }
            if (10 == b) {
                rc = TokenCodes.TOKEN_RC_DELIM;
                this.numCRLFs = 1;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(buff) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = false;
                break;
            }
            if (++length <= this.limitTokenSize) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findCRLFTokenLength: length is too big: " + length);
            }
            throw new MalformedMessageException("Token length: " + length);
        }
        this.parsedTokenLength = length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "findCRLFTokenLength returning " + rc.getName() + "; len=" + length);
        }
        return rc;
    }

    protected TokenCodes findTokenLength(WsByteBuffer buff, byte delimiter, boolean bApproveCRLF) throws MalformedMessageException {
        TokenCodes rc = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == buff) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findTokenLength: null buffer provided");
            }
            return rc;
        }
        int length = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(buff)) {
            byte b;
            if (delimiter == (b = this.byteCache[this.bytePosition++])) {
                rc = TokenCodes.TOKEN_RC_DELIM;
                break;
            }
            if (13 == b) {
                if (!bApproveCRLF) {
                    throw new MalformedMessageException("Invalid CR found in token");
                }
                rc = TokenCodes.TOKEN_RC_CRLF;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(buff) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = true;
                break;
            }
            if (10 == b) {
                if (!bApproveCRLF) {
                    throw new MalformedMessageException("Invalid LF found in token");
                }
                rc = TokenCodes.TOKEN_RC_CRLF;
                this.numCRLFs = 1;
                if (-1 == this.headerChangeLimit) break;
                this.lastCRLFPosition = this.findCurrentBufferPosition(buff) - 1;
                this.lastCRLFBufferIndex = this.parseIndex;
                this.lastCRLFisCR = false;
                break;
            }
            if (++length <= this.limitTokenSize) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findTokenLength: length is too big: " + length);
            }
            throw new MalformedMessageException("Token length: " + length);
        }
        this.parsedTokenLength = length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "findTokenLength: [" + (char)delimiter + "] " + rc.getName() + "; len=" + length);
        }
        return rc;
    }

    protected TokenCodes skipCRLFs(WsByteBuffer buffer) {
        int maxCRLFs = 33;
        if (this.bytePosition >= this.byteLimit && !this.fillByteCache(buffer)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        byte b = this.byteCache[this.bytePosition++];
        for (int i = 0; i < maxCRLFs; ++i) {
            if (-1 == b) {
                return TokenCodes.TOKEN_RC_MOREDATA;
            }
            if (13 != b && 10 != b) {
                --this.bytePosition;
                return TokenCodes.TOKEN_RC_DELIM;
            }
            if (this.bytePosition >= this.byteLimit) {
                return TokenCodes.TOKEN_RC_MOREDATA;
            }
            b = this.byteCache[this.bytePosition++];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Too many leading CRLFs found");
        }
        return TokenCodes.TOKEN_RC_CRLF;
    }

    private boolean parseCRLFs(WsByteBuffer buff) throws MalformedMessageException {
        for (int i = 0; i < 4; ++i) {
            byte b;
            if (this.bytePosition >= this.byteLimit && !this.fillByteCache(buff)) {
                return false;
            }
            if (13 == (b = this.byteCache[this.bytePosition++])) continue;
            if (10 == b) {
                ++this.numCRLFs;
            } else {
                if (32 == b || 9 == b) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Multiline header follows");
                    }
                    this.bIsMultiLine = true;
                    if (null == this.lastHdrInSequence) {
                        throw new MalformedMessageException("Incorrect multiline header value");
                    }
                    this.currentElem = this.lastHdrInSequence;
                    this.stateOfParsing = 1;
                    this.numCRLFs = 0;
                    return true;
                }
                --this.bytePosition;
                break;
            }
            if (2 > this.numCRLFs) continue;
            this.eohPosition = this.isByteBufferArray ? this.bytePosition : buff.position() - (this.byteLimit - this.bytePosition);
            buff.position(this.eohPosition);
            break;
        }
        this.bIsMultiLine = false;
        this.stateOfParsing = 0;
        this.numCRLFs = 0;
        return true;
    }

    protected TokenCodes parseCRLFTokenExtract(WsByteBuffer buff, int log) throws MalformedMessageException {
        int start;
        if (null == this.parsedToken && !this.skipWhiteSpace(buff)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        int n = start = this.isByteBufferArray ? this.bytePosition : buff.position() - (this.byteLimit - this.bytePosition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseCRLFTokenExtract: start:" + start + " lim:" + this.byteLimit + " pos:" + this.bytePosition);
        }
        TokenCodes rc = this.findCRLFTokenLength(buff);
        this.saveParsedToken(buff, start, TokenCodes.TOKEN_RC_DELIM.equals(rc), log);
        return rc;
    }

    protected int parseCRLFTokenNonExtract(WsByteBuffer buff) throws MalformedMessageException {
        this.findCRLFTokenLength(buff);
        return this.parsedTokenLength;
    }

    protected TokenCodes findHeaderLength(WsByteBuffer buff) throws MalformedMessageException {
        TokenCodes rc = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == buff) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findHeaderLength: null buffer provided");
            }
            return rc;
        }
        int numSpaces = 0;
        int length = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(buff)) {
            byte b;
            if (58 == (b = this.byteCache[this.bytePosition++])) {
                length -= numSpaces;
                rc = TokenCodes.TOKEN_RC_DELIM;
                break;
            }
            numSpaces = 32 == b || 9 == b ? ++numSpaces : 0;
            if (13 == b || 10 == b) {
                throw new MalformedMessageException("Invalid CRLF found in header name");
            }
            if (++length <= this.limitTokenSize) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findTokenLength: length is too big: " + length);
            }
            throw new MalformedMessageException("Token length: " + length);
        }
        this.parsedTokenLength = length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "findHeaderLength: " + rc.getName() + "; len=" + length);
        }
        return rc;
    }

    private boolean parseHeaderName(WsByteBuffer buff) throws MalformedMessageException {
        byte[] data;
        if (null == this.parsedToken && !this.skipWhiteSpace(buff)) {
            return false;
        }
        int start = this.isByteBufferArray ? this.bytePosition : buff.position() - (this.byteLimit - this.bytePosition);
        int cachestart = this.bytePosition;
        TokenCodes rc = this.findHeaderLength(buff);
        if (TokenCodes.TOKEN_RC_MOREDATA.equals(rc)) {
            this.saveParsedToken(buff, start, false, 0);
            return false;
        }
        int length = this.parsedTokenLength;
        if (null == this.parsedToken && length < this.bytePosition) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using bytecache, length=" + length + " pos=" + this.bytePosition + " start=" + cachestart);
            }
            data = this.byteCache;
            start = cachestart;
        } else {
            this.saveParsedToken(buff, start, true, 0);
            data = this.parsedToken;
            start = 0;
            length = data.length;
        }
        this.currentElem = this.getElement(this.findKey(data, start, length));
        if (-1 != this.headerChangeLimit) {
            this.currentElem.updateLastCRLFInfo(this.lastCRLFBufferIndex, this.lastCRLFPosition, this.lastCRLFisCR);
        }
        this.stateOfParsing = 1;
        this.parsedToken = null;
        this.parsedTokenLength = 0;
        return true;
    }

    private boolean parseHeaderValueExtract(WsByteBuffer buff) throws MalformedMessageException {
        TokenCodes tcRC;
        int log = 0;
        HeaderKeys key = this.currentElem.getHeaderKey();
        if (null != key && !key.shouldLogValue()) {
            log = 1;
        }
        if (!(tcRC = this.parseCRLFTokenExtract(buff, log)).equals(TokenCodes.TOKEN_RC_MOREDATA)) {
            this.setHeaderValue();
            this.parsedToken = null;
            this.currentElem = null;
            this.stateOfParsing = 2;
            return true;
        }
        return false;
    }

    private boolean parseHeaderValueNonExtract(WsByteBuffer buff) throws MalformedMessageException {
        if (0 == this.parsedTokenLength) {
            if (!this.skipWhiteSpace(buff)) {
                return false;
            }
            int start = this.isByteBufferArray ? this.bytePosition : buff.position() - (this.byteLimit - this.bytePosition);
            this.currentElem.setParseInformation(this.parseIndex, start);
        }
        if (TokenCodes.TOKEN_RC_MOREDATA.equals(this.findCRLFTokenLength(buff))) {
            return false;
        }
        this.currentElem.setValueLength(this.parsedTokenLength);
        this.addHeader(this.currentElem, true, true);
        this.parsedTokenLength = 0;
        this.currentElem = null;
        this.stateOfParsing = 2;
        return true;
    }

    protected TokenCodes parseTokenExtract(WsByteBuffer buff, byte bDelimiter, boolean bApproveCRLF, int log) throws MalformedMessageException {
        TokenCodes rc;
        int start;
        if (null == this.parsedToken && !this.skipWhiteSpace(buff)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        int n = start = this.isByteBufferArray ? this.bytePosition : buff.position() - (this.byteLimit - this.bytePosition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseTokenExtract: start:" + start + " lim:" + this.byteLimit + " pos:" + this.bytePosition);
        }
        this.saveParsedToken(buff, start, !TokenCodes.TOKEN_RC_MOREDATA.equals(rc = this.findTokenLength(buff, bDelimiter, bApproveCRLF)), log);
        return rc;
    }

    protected int parseTokenNonExtract(WsByteBuffer buff, byte bDelimiter, boolean bApproveCRLF) throws MalformedMessageException {
        TokenCodes rc = this.findTokenLength(buff, bDelimiter, bApproveCRLF);
        return TokenCodes.TOKEN_RC_MOREDATA.equals(rc) ? -1 : this.parsedTokenLength;
    }

    protected void setHeaderValue() throws MalformedMessageException {
        if (null == this.parsedToken) {
            this.parsedToken = new byte[]{32};
        }
        if (this.bIsMultiLine) {
            byte[] oldValue = this.currentElem.getByteArrayValue();
            int size = oldValue.length + this.parsedToken.length + 1;
            if (size > this.limitTokenSize) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Multiline header value too large: " + size);
                }
                throw new MalformedMessageException("Multiline value length: " + size);
            }
            byte[] newValue = new byte[oldValue.length + this.parsedToken.length + 1];
            System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
            newValue[oldValue.length] = 32;
            System.arraycopy(this.parsedToken, 0, newValue, oldValue.length + 1, this.parsedToken.length);
            this.currentElem.setByteArrayValue(newValue);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Saved multiline header value [" + this.currentElem.getDebugValue() + "]");
            }
        } else {
            this.currentElem.setByteArrayValue(this.parsedToken);
            this.addHeader(this.currentElem, true, true);
        }
        this.currentElem.startTracking();
    }

    private void saveParsedToken(WsByteBuffer buff, int start, boolean delim, int log) {
        byte[] temp;
        int offset;
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        int length = this.parsedTokenLength;
        this.parsedTokenLength = 0;
        if (0 > length) {
            throw new IllegalArgumentException("Negative token length: " + length);
        }
        if (bTrace && tc.isDebugEnabled()) {
            String value = GenericUtils.getEnglishString(this.parsedToken);
            if (null != value) {
                if (2 == log) {
                    value = GenericUtils.nullOutPasswords(value, (byte)10);
                } else if (1 == log) {
                    value = GenericUtils.blockContents(value);
                }
            }
            Tr.debug(tc, "Saving token: " + value + " len:" + length + " start:" + start + " pos:" + this.bytePosition + " delim:" + delim);
        }
        if (null != this.parsedToken) {
            offset = this.parsedToken.length;
            temp = new byte[offset + length];
            System.arraycopy(this.parsedToken, 0, temp, 0, offset);
        } else {
            offset = 0;
            temp = new byte[length];
        }
        if (this.bytePosition > length) {
            int cacheStart = this.bytePosition - length;
            if (delim) {
                --cacheStart;
            }
            System.arraycopy(this.byteCache, cacheStart, temp, offset, length);
        } else {
            int orig = buff.position();
            buff.position(start);
            buff.get(temp, offset, length);
            buff.position(orig);
        }
        this.parsedToken = temp;
        if (bTrace && tc.isDebugEnabled()) {
            String value = GenericUtils.getEnglishString(this.parsedToken);
            if (2 == log) {
                value = GenericUtils.nullOutPasswords(value, (byte)10);
            } else if (1 == log) {
                value = GenericUtils.blockContents(value);
            }
            Tr.debug(tc, "Saved token [" + value + "]");
        }
    }

    public void parsedCompactHeader(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parsedCompactHeader: " + flag);
        }
        this.compactHeaderFlag = flag;
    }

    public boolean foundCompactHeader() {
        return this.compactHeaderFlag;
    }
}

