/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc.impl;

import com.ibm.ffdc.config.Formattable;
import com.ibm.ffdc.util.provider.Incident;
import com.ibm.ffdc.util.provider.IncidentEntry;
import com.ibm.ffdc.util.provider.IncidentLogger;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.impl.ConfigurationHelper;
import com.ibm.ws.ffdc.impl.Configure;
import com.ibm.ws.ffdc.impl.DMAdapter;
import com.ibm.ws.ffdc.impl.FFDCHelper;
import com.ibm.ws.ffdc.impl.FFDCJanitor;
import com.ibm.ws.ffdc.impl.IncidentStream;
import com.ibm.ws.ffdc.impl.WrappingFileOutputStream;
import com.ibm.ws.security.util.ServerIdentityHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FfdcProvider
extends com.ibm.ffdc.util.provider.FfdcProvider
implements com.ibm.ffdc.provider.FfdcProvider {
    private ConfigurationHelper configurationHelper;
    private int size = -1;
    private WrappingFileOutputStream incidentSummaryStream;
    private static final String FFDC_SUFFIX = ".txt";
    private static final String thisClass = FfdcProvider.class.getName();
    private static final Logger LOGGER = Logger.getLogger(thisClass, "com.ibm.ws.ffdc.resources.FFDCMessages");

    public FfdcProvider() {
        this.getConfigurationHelper();
    }

    public synchronized Configure getConfiguration() {
        return this.getConfigurationHelper().getConfiguration();
    }

    @Override
    protected final boolean isLoggable(IncidentEntry incident) {
        return super.isLoggable(incident) && this.getConfigurationHelper().hasPermissionForLogging();
    }

    private synchronized ConfigurationHelper getConfigurationHelper() {
        if (this.configurationHelper == null) {
            this.configurationHelper = new ConfigurationHelper(this);
        }
        return this.configurationHelper;
    }

    @Override
    protected synchronized void logIncident(IncidentEntry incident, Object reporter, Throwable th, List<Formattable> data) {
        IncidentLogger<FfdcProvider> incidentLogger = new IncidentLogger<FfdcProvider>(this);
        this.logIncident(incidentLogger, incident, reporter, th, data);
        this.logSummary(incidentLogger);
    }

    @Override
    protected void log(IncidentEntry incident, Object reporter, Throwable th, Object[] cde) throws Exception {
        if (cde != null && cde.length == 1 && cde[0] instanceof DMAdapter) {
            super.log(incident, reporter, th, (DMAdapter)cde[0]);
        } else {
            super.log(incident, reporter, th, cde);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logIncident(IncidentLogger<FfdcProvider> incidentLogger, IncidentEntry incident, Object reporter, Throwable th, List<Formattable> data) {
        FileOutputStream out;
        String dirpath;
        FFDCJanitor.getInstance().doCleanupIfNeeded();
        final String prefix = FFDCHelper.generateFilename(Integer.toHexString(Thread.currentThread().hashCode()));
        try {
            dirpath = FFDCHelper.getDefaultLoggingDirectory();
        }
        catch (WsException e) {
            this.abort(e);
            return;
        }
        final File[] aF = new File[]{null};
        ServerIdentityHelper sih = FFDC.isZos() ? ServerIdentityHelper.getServerIdentityHelper() : null;
        Object credToken = null;
        try {
            if (sih != null) {
                sih = ServerIdentityHelper.getServerIdentityHelper();
                credToken = sih.push();
            }
            out = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws Exception {
                    aF[0] = File.createTempFile(prefix, FfdcProvider.FFDC_SUFFIX, new File(dirpath));
                    return new FileOutputStream(aF[0]);
                }
            });
        }
        catch (Exception e) {
            this.abort(e);
            return;
        }
        finally {
            try {
                if (sih != null) {
                    sih.pop(credToken);
                }
            }
            catch (Exception e) {
                this.abort(e);
            }
        }
        String incidentFile = aF[0].getAbsolutePath();
        try {
            IncidentStream is = new IncidentStream(this, (OutputStream)out);
            incidentLogger.writeIncidentTo(is, incident, reporter, th, data);
            out.flush();
            incident.setLabel(incidentFile);
            LOGGER.logp(Level.INFO, FfdcProvider.class.getName(), "logIncident", "FFDCIncidentEmitted", new Object[]{incidentFile, incident.getSourceId(), incident.getProbeId()});
        }
        catch (IOException e) {
            this.ffdcerror(e);
        }
    }

    private synchronized void logSummary(IncidentLogger<FfdcProvider> incidentLogger) {
        WrappingFileOutputStream ws;
        List<Incident> incidents = this.getIncidents();
        if (this.size == incidents.size()) {
            return;
        }
        try {
            ws = this.getIncidentSummaryStream();
            ws.getChanel().truncate(0L);
        }
        catch (WsException e) {
            this.abort(e);
            return;
        }
        catch (IOException e) {
            this.abort(e);
            return;
        }
        incidentLogger.logIncidentSummary(ws, incidents);
        this.size = incidents.size();
    }

    private WrappingFileOutputStream getIncidentSummaryStream() throws WsException, IOException {
        if (this.incidentSummaryStream != null) {
            return this.incidentSummaryStream;
        }
        this.incidentSummaryStream = this.getConfigurationHelper().getIncidentSummaryStream();
        return this.incidentSummaryStream;
    }
}

