/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc.impl;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallStack {
    private final Throwable th;
    private List<String> cnames;
    int start = -2;

    public CallStack(Throwable th) {
        this.th = th;
    }

    public Throwable getThrowable() {
        return this.th;
    }

    public String getReporterClassName() {
        int i = this.getStart();
        if (i < 0) {
            return null;
        }
        StackTraceElement ste = this.th.getStackTrace()[i];
        return ste.getClassName();
    }

    public String getExecutionMethodName() {
        int i = this.getStart();
        if (i == -1) {
            return null;
        }
        StackTraceElement ste = this.th.getStackTrace()[i];
        String cname = ste.getClassName();
        return cname + '.' + ste.getMethodName();
    }

    public List<String> getClassNames() {
        if (this.cnames == null) {
            this.cnames = this.collectClassNames();
        }
        return this.cnames;
    }

    private List<String> collectClassNames() {
        ArrayList<String> cnames;
        if (this.th == null) {
            return Collections.emptyList();
        }
        TreeSet<String> foundNames = new TreeSet<String>();
        StackTraceElement[] stackTrace = this.th.getStackTrace();
        int idx = this.getStart();
        if (idx < 0) {
            return Collections.emptyList();
        }
        try {
            cnames = new ArrayList<String>(stackTrace.length - idx + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return Collections.emptyList();
        }
        while (idx < stackTrace.length) {
            String cname = stackTrace[idx].getClassName();
            if (foundNames.add(cname)) {
                cnames.add(cname);
            }
            ++idx;
        }
        return cnames;
    }

    public int getStart() {
        if (this.start > -2) {
            return this.start;
        }
        this.start = CallStack.getLastCommonIndex(this.th, new Exception());
        return this.start;
    }

    public static int getLastCommonIndex(Throwable first, Throwable second) {
        if (first == null || second == null) {
            return -1;
        }
        StackTraceElement[] trace1 = first.getStackTrace();
        StackTraceElement[] trace2 = second.getStackTrace();
        if (trace2 == null || trace1 == null) {
            return -1;
        }
        int end = Math.min(trace2.length, trace1.length);
        for (int i = 0; i < end; ++i) {
            StackTraceElement mySTE = trace2[trace2.length - i - 1];
            int idx = trace1.length - i - 1;
            StackTraceElement exSTE = trace1[idx];
            if (mySTE.equals(exSTE)) continue;
            return idx;
        }
        return -1;
    }

    public String getExceptionName() {
        if (this.th == null) {
            return String.valueOf((Object)null);
        }
        return this.th.getClass().getName();
    }

    public String[] getCallStack() {
        if (this.th == null) {
            return new String[0];
        }
        StackTraceElement[] aSTE = this.th.getStackTrace();
        if (aSTE == null || aSTE.length == 0) {
            return new String[0];
        }
        String[] result = new String[aSTE.length];
        for (int i = 0; i < aSTE.length; ++i) {
            StackTraceElement ste = aSTE[i];
            result[i] = ste.getClassName() + '.' + ste.getMethodName();
        }
        return result;
    }

    public void printCallStack() {
        if (this.th == null) {
            System.out.println((Object)null);
        } else {
            this.th.printStackTrace(System.out);
        }
    }

    public void printCallStack(PrintStream ps) {
        if (this.th == null) {
            ps.println((Object)null);
        } else {
            this.th.printStackTrace(ps);
        }
    }
}

