/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.AnalysisEngineWrapper;
import com.ibm.ws.ffdc.impl.FFDCHelper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class AnalysisEngineTool {
    private static FileInputStream fis = null;
    private static int readLineCount = 0;
    private static String databaseName = null;
    private static final String startHeader = "------Start";
    private static final String startCallStack = "Stack Dump = ";
    private static final String atString = "at ";
    private static final String exHeader = "Exception =";
    private static final String srcHeader = "Source =";
    private static final String prbHeader = "probeid =";
    private static int verbose = 0;
    private static String filename = null;
    private static boolean calledByDMTest = false;
    private static Vector vector = new Vector(100, 100);

    private static BufferedReader openFile() {
        BufferedReader open = null;
        try {
            if (filename != null) {
                fis = new FileInputStream(filename);
                open = new BufferedReader(new InputStreamReader(fis));
            }
        }
        catch (Exception e) {
            AnalysisEngineTool.error("Error occured opening the file : " + filename);
            AnalysisEngineTool.error(e.toString());
            System.exit(0);
        }
        return open;
    }

    public static void closeFile(BufferedReader di) {
        try {
            di.close();
            fis.close();
        }
        catch (IOException e) {
            AnalysisEngineTool.error(e.toString());
        }
    }

    public static String readLine(BufferedReader inn) {
        try {
            String returnString = inn.readLine();
            AnalysisEngineTool.debug("debug read : " + ++readLineCount + " " + returnString);
            return returnString;
        }
        catch (IOException e) {
            AnalysisEngineTool.error(e.toString());
            return null;
        }
    }

    private static void usage(String inMessage) {
        System.out.println(inMessage);
        System.out.println("Usage : java -Djava.ext.dirs=<install_root>\\lib com.ibm.ws.ffdc.AnalysisEngineTool <install_root>\\logs\\ffdc\\<filename> <instal_root>\\properties\\logbr\\ffdc\\adv\\ffdcdb.xml");
        System.out.println("\t<install_root> - location of the websphere install");
        System.out.println("\t<filename> - name of the ffdc file which will be processed");
        System.out.println("\tAlternately, a different database can be specified for the last parameter");
    }

    private static void msg(String inMsg) {
        if (verbose != 0) {
            System.out.println("***** " + inMsg + " ******");
        }
    }

    private static void error(String inMsg) {
        System.out.println("----- " + inMsg + "------");
    }

    private static void debug(String inMsg) {
        if (verbose == 2) {
            System.out.println("!!!!! " + inMsg + " !!!!!");
        }
    }

    private static boolean parseParams(String[] params) {
        switch (params.length) {
            case 3: {
                if (params[2].equalsIgnoreCase("verbose")) {
                    verbose = 1;
                }
                if (params[2].equalsIgnoreCase("debug")) {
                    verbose = 2;
                }
                if (params[2].equalsIgnoreCase("directives")) {
                    verbose = 1;
                }
            }
            case 2: {
                databaseName = !params[1].equalsIgnoreCase("default") ? params[1] : null;
            }
            case 1: {
                if (params[0].indexOf("txt") == -1) {
                    AnalysisEngineTool.error("Filename specified is not a FFDC txt file: " + params[0]);
                    return false;
                }
                filename = params[0];
                break;
            }
            default: {
                AnalysisEngineTool.error("Wrong number of parameters specified");
                AnalysisEngineTool.usage("Number of parameter specified was : " + params.length + ", should be at least 1");
                return false;
            }
        }
        return true;
    }

    private static String processHeader(String inLine) {
        AnalysisEngineTool.msg("This is the header : " + inLine);
        return inLine;
    }

    private static String processException(String inLine) {
        AnalysisEngineTool.msg("This is the exception : " + inLine);
        int equalIndex = 0;
        int endIndex = 0;
        String equalString = " = ";
        int sepChar = 58;
        String exceptionName = null;
        AnalysisEngineTool.debug("Start to look for the = sign");
        equalIndex = inLine.indexOf(equalString);
        AnalysisEngineTool.debug("The value of the index is : " + equalIndex);
        if (equalIndex == -1) {
            AnalysisEngineTool.msg("Something seems wrong");
            return null;
        }
        AnalysisEngineTool.debug("The index value is : " + (equalIndex += equalString.length()));
        endIndex = inLine.indexOf(sepChar);
        if (endIndex == -1) {
            endIndex = inLine.length();
        }
        exceptionName = inLine.substring(equalIndex, endIndex);
        AnalysisEngineTool.debug("The exception name is : |" + exceptionName + '|');
        return exceptionName;
    }

    private static String processExceptionHeader(String inLine) {
        AnalysisEngineTool.msg("Look for the exception in : " + inLine);
        int index = 0;
        String exceptionName = null;
        index = inLine.indexOf(exHeader);
        if (index != -1) {
            exceptionName = inLine.substring(index += exHeader.length());
        }
        return exceptionName;
    }

    private static String processSourceHeader(String inLine) {
        AnalysisEngineTool.msg("Look for the Source in : " + inLine);
        int index = 0;
        String sourceName = null;
        index = inLine.indexOf(srcHeader);
        if (index != -1) {
            sourceName = inLine.substring(index += srcHeader.length());
        }
        return sourceName;
    }

    private static String processProbeHeader(String inLine) {
        AnalysisEngineTool.msg("Look for the Probe in : " + inLine);
        int index = 0;
        String probeName = null;
        index = inLine.indexOf(prbHeader);
        if (index != -1) {
            probeName = inLine.substring(index += prbHeader.length());
        }
        return probeName;
    }

    private static String processMethodName(String inLine) {
        AnalysisEngineTool.debug("This is the method name : " + inLine);
        int atIndex = 0;
        int endIndex = 0;
        String methodName = null;
        atIndex = inLine.indexOf(atString);
        if (atIndex == -1) {
            return null;
        }
        atIndex += atString.length();
        endIndex = inLine.indexOf(40);
        if (endIndex == -1) {
            endIndex = inLine.length();
        }
        methodName = inLine.substring(atIndex, endIndex);
        AnalysisEngineTool.debug("The name of the method is : " + methodName);
        return methodName;
    }

    private static String[] convertVectorToCallStack(Vector inVector) {
        AnalysisEngineTool.msg("Convert the vector to a call stack array");
        int vectorSize = 0;
        vectorSize = inVector.size();
        Object[] returnArray = new String[vectorSize];
        inVector.copyInto(returnArray);
        inVector.removeAllElements();
        return returnArray;
    }

    private static String[] checkKnowledgeBase(String exceptionName, String[] callStack, String header, String printStackForDisplay) {
        String[] directives = null;
        AnalysisEngineTool.msg("Check the knowlege base");
        directives = AnalysisEngineWrapper.checkKnowledgeBase(exceptionName, callStack, header, printStackForDisplay, 0x100000, 1);
        if (directives != null) {
            AnalysisEngineTool.debug("Directives do exist here");
            for (int i = 0; i < directives.length; ++i) {
                AnalysisEngineTool.msg("directive[" + i + "] = " + directives[i]);
            }
        }
        AnalysisEngineTool.msg("Return from knowledgebase");
        return directives;
    }

    public static String[] processFile() {
        BufferedReader theFile = null;
        String readString = null;
        String exceptionName = null;
        String newExceptionInformation = "";
        String exceptionKey = null;
        String sourceKey = null;
        String probeKey = null;
        String methodName = null;
        String[] callStack = null;
        Object solution = null;
        String printStackTrace = " ";
        String[] saveDirectives = null;
        theFile = AnalysisEngineTool.openFile();
        String lineSepChar = null;
        if (lineSepChar == null) {
            lineSepChar = FFDCHelper.getSystemProperty("line.separator");
        }
        while (true) {
            if ((readString = AnalysisEngineTool.readLine(theFile)) == null) break;
            if (readString.indexOf(startHeader) != -1) {
                AnalysisEngineTool.processHeader(readString);
            }
            if (readString.indexOf(exHeader) != -1) {
                exceptionKey = AnalysisEngineTool.processExceptionHeader(readString);
            }
            if (readString.indexOf(srcHeader) != -1) {
                sourceKey = AnalysisEngineTool.processSourceHeader(readString);
            }
            if (readString.indexOf(prbHeader) != -1) {
                probeKey = AnalysisEngineTool.processProbeHeader(readString);
            }
            if (readString.indexOf(startCallStack) == -1) continue;
            exceptionName = AnalysisEngineTool.processException(readString);
            while (readString.trim().indexOf(atString) != 0) {
                newExceptionInformation = newExceptionInformation + readString;
                readString = AnalysisEngineTool.readLine(theFile);
            }
            printStackTrace = newExceptionInformation;
            while (readString.indexOf(atString) != -1) {
                printStackTrace = printStackTrace + lineSepChar + readString;
                methodName = AnalysisEngineTool.processMethodName(readString);
                vector.add(methodName);
                readString = AnalysisEngineTool.readLine(theFile);
                if (readString != null) continue;
            }
            callStack = AnalysisEngineTool.convertVectorToCallStack(vector);
            String[] tempDirectives = AnalysisEngineTool.checkKnowledgeBase(exceptionName, callStack, exceptionKey + sourceKey + probeKey, printStackTrace);
            if (!calledByDMTest || tempDirectives == null || tempDirectives.length <= 0) continue;
            if (saveDirectives != null) {
                AnalysisEngineTool.error("Directives from previous call stack are being overwritten");
                AnalysisEngineTool.error("This test environment should only be used to process a single call stack");
                AnalysisEngineTool.error("Modify the input file to contain only a single call stack and reissue command");
                AnalysisEngineTool.error("Processing of the last set of directives will continue");
            }
            saveDirectives = tempDirectives;
        }
        AnalysisEngineTool.msg("Reached the end of the file");
        return saveDirectives;
    }

    public static String[] unitTestDMCall(String inFilename, String inDatabase, String inOutput) {
        String[] parameter = new String[3];
        String[] directives = null;
        calledByDMTest = true;
        if (inFilename == null) {
            System.err.println("Filename was null, need to specify a file for processing");
            return null;
        }
        parameter[0] = inFilename;
        parameter[1] = inDatabase == null ? "default" : inDatabase;
        parameter[2] = inOutput == null ? "nooutput" : inOutput;
        try {
            AnalysisEngineTool.parseParams(parameter);
            AnalysisEngineWrapper.setUpForCommandLineCall(databaseName);
            directives = AnalysisEngineTool.processFile();
        }
        catch (Throwable th) {
            System.err.println("A problem was encountered with the tool");
            th.printStackTrace();
            return null;
        }
        return directives;
    }

    public static void main(String[] args) {
        if (!AnalysisEngineTool.parseParams(args)) {
            AnalysisEngineTool.msg("problem encountered with the parameters");
            return;
        }
        AnalysisEngineTool.msg("Start of parsing file : " + filename);
        try {
            AnalysisEngineWrapper.setUpForCommandLineCall(databaseName);
            AnalysisEngineTool.processFile();
        }
        catch (Throwable th) {
            AnalysisEngineTool.error("Problem has been encountered during the execution of the program");
            th.printStackTrace();
        }
    }
}

