/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.extension.thinregistry.Extension;
import com.ibm.ws.extension.thinregistry.ExtensionPoint;
import com.ibm.ws.extension.thinregistry.ExtensionRegistry;
import com.ibm.ws.extension.thinregistry.PluginDescriptor;
import java.util.Collection;

public class RegistryResolver {
    private static final String srcClass = "RegistryResolver";
    private static final String SEPARATOR = ".";
    private ExtensionRegistry _reg;

    public RegistryResolver(ExtensionRegistry reg) {
        this._reg = reg;
    }

    public void resolve() {
        Collection plugins = this._reg.getAllPlugins();
        if (plugins == null || plugins.isEmpty()) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.trace("registry.warning.empty_plugin_list");
            }
            return;
        }
        for (PluginDescriptor pd : plugins) {
            this.resolvePluginDescriptorExtensions(pd);
        }
    }

    private void resolvePluginDescriptorExtensions(PluginDescriptor pd) {
        Extension[] exts = (Extension[])pd.getExtensions();
        if (exts != null && 0 < exts.length) {
            for (int i = 0; i < exts.length; ++i) {
                if (exts[i] == null) continue;
                this.resolveExtension(exts[i]);
            }
        }
    }

    private boolean resolveExtension(Extension ext) {
        boolean success = false;
        String targetXptId = ext.getExtensionPointUniqueIdentifier();
        int ix = targetXptId.lastIndexOf(SEPARATOR);
        String targetPluginId = targetXptId.substring(0, ix);
        String targetXptSimpleId = targetXptId.substring(ix + 1);
        PluginDescriptor targetPlugin = this._reg.getPlugin(targetPluginId);
        if (targetPlugin != null) {
            ExtensionPoint xpt = (ExtensionPoint)targetPlugin.getExtensionPoint(targetXptSimpleId);
            if (xpt == null) {
                if (LoggingServices.debugEnabled) {
                    LoggingServices.trace("registry.warning.nonexistent_ext_pt", new Object[]{targetXptId, ext.getUniqueIdentifier()});
                }
            } else {
                xpt.addExtension(ext);
                success = true;
            }
        }
        return success;
    }
}

