/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.URL.ParserUtils;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.classloader.Handler;
import com.ibm.ws.classloader.ResourceCache;
import com.ibm.ws.classloader.ZipFileHandle;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SinglePathClassProvider {
    private static TraceComponent tc = Tr.register(SinglePathClassProvider.class.getName(), "Websphere ClassLoader", "com.ibm.ws.runtime.runtime");
    protected File pathFile = null;
    protected boolean pathExists = false;
    protected boolean isDirectory = false;
    protected URL url = null;
    protected String path = null;
    protected ZipFile cachedZip = null;
    protected boolean cachingEnabled = false;
    protected Manifest manifest = null;
    private static final boolean emulateURLClassLoader = Boolean.getBoolean("com.ibm.ws.classloader.strict");
    private static String resourceURLProtocol = Handler.register() ? "wsjar" : "jar";
    private static final boolean encodeResourceURLs = Boolean.getBoolean("com.ibm.ws.classloader.encodeResourceURLs");
    private static final int zipFileCacheSize = Integer.getInteger("com.ibm.ws.classloader.zipFileCacheSize", 8);
    private static Map providerCache = new HashMap();
    private static ZipFileCache zipFileCache = new ZipFileCache();
    private ResourceCache resourcesInJar = new ResourceCache('/');
    private ResourceCache classesInJar = new ResourceCache('.');
    private Set metaInfEntries = new HashSet();
    private int numClassLoaderRefs;

    public SinglePathClassProvider(String fpath) {
        this.pathFile = new File(fpath);
        try {
            this.path = this.pathFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            Manager.Ffdc.log(ioe, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "40", this);
            this.path = fpath;
        }
        this.pathExists = this.pathFile.exists();
        this.isDirectory = this.pathFile.isDirectory();
        if (this.pathExists && !this.isDirectory) {
            this.buildContentsCache();
        }
        try {
            File canonicalFile = this.pathFile.getCanonicalFile();
            this.url = encodeResourceURLs ? canonicalFile.toURI().toURL() : canonicalFile.toURL();
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "59", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SinglePathClassProvider create(String path, boolean cacheZipFiles) {
        SinglePathClassProvider provider;
        if (!cacheZipFiles) {
            return new SinglePathClassProvider(path);
        }
        Map map = providerCache;
        synchronized (map) {
            provider = (SinglePathClassProvider)providerCache.get(path);
            if (provider == null) {
                provider = new SinglePathClassProvider(path);
                providerCache.put(path, provider);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding cached provider " + provider);
                }
            }
            ++provider.numClassLoaderRefs;
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ZipFileHandle openZipFile(String path, SinglePathClassProvider provider) throws IOException {
        ZipFileHandle handle;
        block16: {
            try {
                path = new File(path).getCanonicalPath();
            }
            catch (IOException ioe) {
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "openZipFile() Couldn't create canonical path for " + path);
            }
        }
        if (zipFileCacheSize == 0) {
            handle = new ZipFileHandle(path);
        } else {
            ZipFileCache zipFileCache = SinglePathClassProvider.zipFileCache;
            synchronized (zipFileCache) {
                handle = (ZipFileHandle)SinglePathClassProvider.zipFileCache.get(path);
                if (handle == null) {
                    handle = new ZipFileHandle(path);
                    Map map = providerCache;
                    synchronized (map) {
                        if (provider == null) {
                            provider = (SinglePathClassProvider)providerCache.get(path);
                        }
                        if (provider != null && provider.numClassLoaderRefs != 0) {
                            handle.ref();
                            SinglePathClassProvider.zipFileCache.put(path, handle);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "adding cached zip file " + path);
                            }
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "opening non-cached zip file " + path);
                        }
                    }
                }
            }
        }
        handle.open();
        return handle;
    }

    static ZipFileHandle openZipFile(String path) throws IOException {
        return SinglePathClassProvider.openZipFile(path, null);
    }

    private ZipFileHandle openZipFile() throws IOException {
        return SinglePathClassProvider.openZipFile(this.path, this);
    }

    protected Manifest getManifest() {
        return this.manifest;
    }

    public void reload() {
        this.pathFile = new File(this.path);
        this.pathExists = this.pathFile.exists();
        this.isDirectory = this.pathFile.isDirectory();
        this.resourcesInJar.clear();
        this.classesInJar.clear();
        if (this.pathExists && !this.isDirectory) {
            this.buildContentsCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map = providerCache;
        synchronized (map) {
            if (--this.numClassLoaderRefs != 0) {
                return;
            }
            Object spcp = providerCache.remove(this.path);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "removing cached provider: [" + spcp + "] for path: [" + this.path + "]");
            }
        }
        if (zipFileCacheSize != 0) {
            map = zipFileCache;
            synchronized (map) {
                ZipFileHandle handle = (ZipFileHandle)zipFileCache.remove(this.path);
                if (handle != null) {
                    handle.close();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "removing cached zip file " + this.path);
                    }
                }
            }
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isValid() {
        return this.pathExists;
    }

    public byte[] getClassBytes(String name, ClassProviderListener ccl) {
        byte[] b = null;
        if (this.pathExists) {
            b = this.isDirectory ? this.getClassBytesFromDir(name, ccl) : this.getClassBytesFromJar(name, ccl);
        }
        return b;
    }

    protected byte[] getClassBytesFromDir(final String cName, final ClassProviderListener ccl) {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object run() {
                File file;
                FileInputStream fin;
                block17: {
                    String className = cName.replace('.', '/');
                    fin = null;
                    String path = SinglePathClassProvider.this.getRealResourcePath(className + ".class");
                    file = new File(path);
                    if (file.exists()) break block17;
                    Object var5_7 = null;
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (IOException e) {
                        Tr.error(tc, "WSVR0120E", new Object[]{cName, e});
                    }
                    return var5_7;
                }
                fin = new FileInputStream(file);
                byte[] b = new byte[(int)file.length()];
                SinglePathClassProvider.this.readFully(fin, b);
                ccl.classLoadedFromFile(file);
                byte[] byArray = b;
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException e) {
                    Tr.error(tc, "WSVR0120E", new Object[]{cName, e});
                }
                return byArray;
                catch (IOException ioe) {
                    try {
                        Tr.error(tc, "WSVR0120E", new Object[]{cName, ioe});
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fin != null) {
                                fin.close();
                            }
                        }
                        catch (IOException e) {
                            Tr.error(tc, "WSVR0120E", new Object[]{cName, e});
                        }
                        throw throwable;
                    }
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (IOException e) {
                        Tr.error(tc, "WSVR0120E", new Object[]{cName, e});
                    }
                }
                return null;
            }
        });
    }

    protected byte[] getClassBytesFromJar(final String className, final ClassProviderListener ccl) {
        if (this.classesInJar.contains(className, '.')) {
            return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public Object run() {
                    byte[] buf;
                    block27: {
                        IOException ioe222;
                        ZipFileHandle zipFileHandle;
                        ByteArrayOutputStream baos;
                        InputStream jis;
                        block25: {
                            block24: {
                                buf = null;
                                jis = null;
                                baos = null;
                                zipFileHandle = null;
                                zipFileHandle = SinglePathClassProvider.this.openZipFile();
                                String name = className.replace('.', '/');
                                ZipEntry zipEntry = zipFileHandle.getZipFile().getEntry(name + ".class");
                                if (zipEntry == null) break block24;
                                jis = zipFileHandle.getZipFile().getInputStream(zipEntry);
                                long zipEntrySize = zipEntry.getSize();
                                if (zipEntrySize != -1L) {
                                    int size = (int)zipEntrySize;
                                    buf = new byte[size];
                                    SinglePathClassProvider.this.readFully(jis, buf);
                                } else {
                                    byte[] tmpbuf = new byte[4096];
                                    baos = new ByteArrayOutputStream();
                                    int len = 0;
                                    while ((len = jis.read(tmpbuf, 0, tmpbuf.length)) != -1) {
                                        baos.write(tmpbuf, 0, len);
                                    }
                                    buf = baos.toByteArray();
                                }
                                ccl.classLoadedFromFile(SinglePathClassProvider.this.pathFile);
                            }
                            Object var12_12 = null;
                            if (zipFileHandle != null) {
                                zipFileHandle.close();
                            }
                            if (jis == null) break block25;
                            try {
                                jis.close();
                            }
                            catch (IOException ioe222) {
                                Tr.error(tc, "WSVR0120E", new Object[]{className, ioe222});
                            }
                        }
                        if (baos != null) {
                            try {
                                baos.close();
                            }
                            catch (IOException ioe222) {
                                Tr.error(tc, "WSVR0120E", new Object[]{className, ioe222});
                            }
                        }
                        break block27;
                        {
                            catch (IOException e) {
                                IOException ioe222;
                                Tr.error(tc, "WSVR0120E", new Object[]{className, e});
                                Object var12_13 = null;
                                if (zipFileHandle != null) {
                                    zipFileHandle.close();
                                }
                                if (jis != null) {
                                    try {
                                        jis.close();
                                    }
                                    catch (IOException ioe222) {
                                        Tr.error(tc, "WSVR0120E", new Object[]{className, ioe222});
                                    }
                                }
                                if (baos != null) {
                                    try {
                                        baos.close();
                                    }
                                    catch (IOException ioe222) {
                                        Tr.error(tc, "WSVR0120E", new Object[]{className, ioe222});
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            IOException ioe222;
                            Object var12_14 = null;
                            if (zipFileHandle != null) {
                                zipFileHandle.close();
                            }
                            if (jis != null) {
                                try {
                                    jis.close();
                                }
                                catch (IOException ioe222) {
                                    Tr.error(tc, "WSVR0120E", new Object[]{className, ioe222});
                                }
                            }
                            if (baos != null) {
                                try {
                                    baos.close();
                                }
                                catch (IOException ioe222) {
                                    Tr.error(tc, "WSVR0120E", new Object[]{className, ioe222});
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (buf == null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "failed to read " + className + " from " + SinglePathClassProvider.this.path);
                    }
                    return buf;
                }
            });
        }
        return null;
    }

    protected String getRealResourcePath(String resource) {
        StringBuffer sb = new StringBuffer(this.path.length() + resource.length() + 1);
        sb.append(this.path);
        sb.append(File.separatorChar);
        char[] chars = resource.toCharArray();
        if (chars.length != 1 || chars[0] != '/' && chars[0] != '\\') {
            boolean lastCharWasSeparator = true;
            int j = 0;
            int N = chars.length;
            for (int i = 0; i < N; ++i) {
                if (lastCharWasSeparator) {
                    while ((chars[i] == '/' || chars[i] == '\\') && ++i < N) {
                    }
                }
                if (chars[i] == '/' || chars[i] == '\\') {
                    lastCharWasSeparator = true;
                    chars[j++] = File.separatorChar;
                    continue;
                }
                lastCharWasSeparator = false;
                chars[j++] = chars[i];
            }
            sb.append(chars, 0, j);
        }
        String result = sb.toString();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append('[').append(this.pathFile);
        if (!this.pathExists) {
            sb.append(", nonexistent");
        } else if (this.isDirectory) {
            sb.append(", directory");
        }
        return sb.append(']').toString();
    }

    public URL getResource(String resourceName) {
        URL url = null;
        if (this.pathExists && resourceName != null) {
            String name;
            if (emulateURLClassLoader && resourceName.startsWith("/")) {
                return null;
            }
            boolean found = true;
            if (!this.isDirectory) {
                if (resourceName.startsWith("/")) {
                    resourceName = resourceName.substring(1);
                }
                found = resourceName.startsWith("META-INF/") ? this.metaInfEntries.contains(resourceName) : (resourceName.endsWith(".class") ? this.classesInJar.contains(resourceName, '/') : (resourceName.endsWith("/") ? this.classesInJar.containsDir(resourceName, '/') || this.resourcesInJar.containsDir(resourceName, '/') : this.resourcesInJar.contains(resourceName, '/')));
            }
            if (found && (url = (URL)AccessController.doPrivileged(new PrivilegedAction(name = resourceName){
                final /* synthetic */ String val$name;
                {
                    this.val$name = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    URL url;
                    block14: {
                        url = null;
                        if (SinglePathClassProvider.this.isDirectory) {
                            try {
                                String resourcePath = SinglePathClassProvider.this.getRealResourcePath(this.val$name);
                                File file = new File(resourcePath);
                                if (!file.exists()) break block14;
                                File canonicalFile = file.getCanonicalFile();
                                URL uRL = url = encodeResourceURLs ? canonicalFile.toURI().toURL() : canonicalFile.toURL();
                                if (resourcePath.indexOf("..") >= 0 && resourcePath.indexOf("...") < 0 && !url.getFile().startsWith(SinglePathClassProvider.this.url.getFile())) {
                                    return null;
                                }
                            }
                            catch (Exception e) {
                                Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "324", this);
                            }
                        } else {
                            ZipFileHandle zipFileHandle = null;
                            try {
                                block15: {
                                    try {
                                        zipFileHandle = SinglePathClassProvider.this.openZipFile();
                                        ZipEntry zipEntry = zipFileHandle.getZipFile().getEntry(this.val$name);
                                        if (zipEntry == null) break block15;
                                        URL pathURL = encodeResourceURLs ? SinglePathClassProvider.this.pathFile.toURI().toURL() : SinglePathClassProvider.this.pathFile.toURL();
                                        url = new URL(new URL(resourceURLProtocol, "", -1, pathURL + "!/"), ParserUtils.encode((String)this.val$name));
                                    }
                                    catch (IOException e) {
                                        Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "350", this);
                                        Object var6_12 = null;
                                        if (zipFileHandle != null) {
                                            zipFileHandle.close();
                                        }
                                        break block14;
                                    }
                                    catch (Throwable th) {
                                        Manager.Ffdc.log(th, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "354", this);
                                        Object var6_13 = null;
                                        if (zipFileHandle != null) {
                                            zipFileHandle.close();
                                        }
                                    }
                                }
                                Object var6_11 = null;
                                if (zipFileHandle != null) {
                                    zipFileHandle.close();
                                }
                            }
                            catch (Throwable throwable) {
                                Object var6_14 = null;
                                if (zipFileHandle != null) {
                                    zipFileHandle.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                    return url;
                }
            })) == null && !this.isDirectory && tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to read " + resourceName + " from " + this.path);
            }
        }
        if (url != null) {
            url = SinglePathClassProvider.checkURL(url);
        }
        return url;
    }

    static URL checkURL(URL url) {
        try {
            SinglePathClassProvider.check(url);
        }
        catch (Exception exception) {
            return null;
        }
        return url;
    }

    private static void check(URL url) throws IOException {
        Permission permission;
        SecurityManager securitymanager = System.getSecurityManager();
        if (securitymanager != null && (permission = url.openConnection().getPermission()) != null) {
            try {
                securitymanager.checkPermission(permission);
            }
            catch (SecurityException securityexception) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securitymanager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securitymanager.checkConnect(url.getHost(), url.getPort());
                }
                throw securityexception;
            }
        }
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void buildContentsCache() {
        try {
            JarFile zipFile = new JarFile(this.path);
            Enumeration<JarEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                String entryName = ze.getName();
                if (entryName.startsWith("META-INF/")) {
                    this.metaInfEntries.add(entryName);
                    continue;
                }
                if (!emulateURLClassLoader && ze.isDirectory()) continue;
                if (entryName.endsWith(".class")) {
                    this.classesInJar.add(entryName, '/');
                    continue;
                }
                this.resourcesInJar.add(entryName, '/');
            }
            try {
                this.manifest = zipFile.getManifest();
            }
            catch (Exception exception) {
                // empty catch block
            }
            zipFile.close();
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.buildContentsCache", "453", this);
        }
    }

    private final void readFully(InputStream is, byte[] b) throws IOException {
        int offset = 0;
        int n = 0;
        for (int len = b.length; len > 0; len -= n) {
            n = is.read(b, offset, len);
            if (n < 0) {
                throw new EOFException();
            }
            offset += n;
        }
    }

    private static class ZipFileCache
    extends LinkedHashMap {
        ZipFileCache() {
            super(zipFileCacheSize, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            if (this.size() > zipFileCacheSize) {
                ((ZipFileHandle)entry.getValue()).close();
                return true;
            }
            return false;
        }
    }
}

