/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.util.PathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class ExtJarClassLoader
extends CompoundClassLoader {
    protected HashSet addedPaths = new HashSet();
    private static TraceComponent tc = Tr.register(ExtJarClassLoader.class.getName(), "Websphere ClassLoader", null);

    public ExtJarClassLoader(String extDir, ClassLoader parent, String[] protectedPrefixes, boolean delegate) {
        this(new String[]{extDir}, parent, protectedPrefixes, delegate);
    }

    public ExtJarClassLoader(String[] extDirs, ClassLoader parent, String[] protectedPrefixes, boolean delegate) {
        super(new String[0], parent, protectedPrefixes, delegate);
        this.setCacheZipFiles(true);
        String[] resolvedPaths = this.resolvePaths(extDirs);
        if (resolvedPaths.length != 0) {
            this.addPaths(resolvedPaths);
        }
    }

    public void addPath(String path) {
        String[] resolvedPaths = this.resolvePaths(new String[]{path});
        if (resolvedPaths.length != 0) {
            this.addPaths(resolvedPaths);
        }
    }

    protected String[] resolvePaths(String[] dirs) {
        boolean debugEnabled = tc.isDebugEnabled();
        if (debugEnabled) {
            Tr.debug(tc, "resolvePaths dirs='" + PathUtils.arrayToString((String[])dirs) + "'");
        }
        String[] appFiles = null;
        if (dirs != null) {
            if (dirs.length != 0) {
                ArrayList appList = new ArrayList();
                int dirsLength = dirs.length;
                for (int i = 0; i < dirsLength; ++i) {
                    File appDir;
                    if (debugEnabled) {
                        Tr.debug(tc, "resolving paths for " + dirs[i]);
                    }
                    if ((appDir = new File(dirs[i])).isDirectory()) {
                        boolean dirContainsResourceOrClass = false;
                        ArrayList<String> dirList = new ArrayList<String>();
                        File[] files = appDir.listFiles();
                        if (files != null) {
                            int filesLength = files.length;
                            for (int j = 0; j < filesLength; ++j) {
                                String fileName = files[j].getName().toLowerCase();
                                if (fileName.endsWith(".zip") || fileName.endsWith(".jar")) {
                                    if (this.addedPaths.contains(files[j].getPath())) continue;
                                    if (debugEnabled) {
                                        Tr.debug(tc, "adding path " + files[j].getPath());
                                    }
                                    this.addedPaths.add(files[j].getPath());
                                    dirList.add(files[j].getPath());
                                    continue;
                                }
                                dirContainsResourceOrClass = true;
                            }
                            if (dirContainsResourceOrClass && !this.addedPaths.contains(appDir.getPath())) {
                                if (debugEnabled) {
                                    Tr.debug(tc, "adding path " + appDir.getPath());
                                }
                                this.addedPaths.add(appDir.getPath());
                                dirList.add(0, appDir.getPath());
                            }
                            appList.addAll(dirList);
                            continue;
                        }
                        Tr.error(tc, "WSVR0330E", appDir);
                        continue;
                    }
                    if (this.addedPaths.contains(appDir.getPath())) continue;
                    if (debugEnabled) {
                        Tr.debug(tc, "adding path " + appDir.getPath());
                    }
                    this.addedPaths.add(appDir.getPath());
                    appList.add(appDir.getPath());
                }
                appFiles = new String[appList.size()];
                appList.toArray(appFiles);
            } else {
                appFiles = new String[]{};
            }
        }
        return appFiles;
    }
}

