/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.classloader.ClassLoaderInstancePreDefinePlugin;
import com.ibm.websphere.classloader.ClassLoaderPlugin;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.classloader.SinglePathClassProvider;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ServerIdentityHelper;
import com.ibm.ws.util.PathUtils;
import com.ibm.wsspi.classloader.JIT_StubClassPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundClassLoader
extends SecureClassLoader
implements ClassProviderListener,
WsClassLoader {
    private static final TraceComponent tc = Tr.register(CompoundClassLoader.class, "Websphere ClassLoader", "com.ibm.ws.runtime.runtime");
    private static final ClassLoader bootClassLoader = new ClassLoader(null){};
    static final int resourceRequestCacheSize = Integer.getInteger("com.ibm.ws.classloader.resourceRequestCacheSize", 16);
    private static final URL badResource;
    protected ClassLoader parent = null;
    protected String localClassPath = "";
    protected String[] nativelibpaths = new String[0];
    protected CompoundClassLoader[] libraryClassLoaders = new CompoundClassLoader[0];
    protected boolean delegate = false;
    protected String[] protectedPrefixes = null;
    protected SinglePathClassProvider[] providers = new SinglePathClassProvider[0];
    protected Vector reloadableParents = new Vector();
    protected Map resourceRequestCache = Collections.synchronizedMap(new ResourceRequestCache());
    protected Map codeSourcePermissions;
    protected static DynamicPolicy dynamicPolicy;
    protected ServerIdentityHelper serverIdentityHelper = null;
    private boolean cacheZipFiles;
    private List preDefinePlugins = null;
    private String name;
    private JIT_StubClassPlugin JIT_StubPlugin = null;
    public static ClassLoaderPlugin plugin;
    private static final ProtectionDomain svPD;

    public CompoundClassLoader(String[] paths, ClassLoader parent, boolean delegate) {
        super(parent);
        if (WSLauncher.isZOS()) {
            this.serverIdentityHelper = ServerIdentityHelper.getServerIdentityHelper();
        }
        this.parent = parent != null ? parent : CompoundClassLoader.getSystemClassLoader();
        this.delegate = delegate;
        this.addPaths(paths);
        this.preDefinePlugins = new ArrayList();
    }

    public CompoundClassLoader(String[] paths, ClassLoader parent, String[] prefixes, boolean delegate) {
        this(paths, parent, delegate);
        this.protectedPrefixes = prefixes;
    }

    protected CompoundClassLoader(CompoundClassLoader old) {
        super(old.getParent());
        this.parent = old.parent;
        this.localClassPath = old.localClassPath;
        this.nativelibpaths = old.nativelibpaths;
        this.libraryClassLoaders = old.libraryClassLoaders;
        this.protectedPrefixes = old.protectedPrefixes;
        this.delegate = old.delegate;
        this.providers = old.providers;
        this.reloadableParents = old.reloadableParents;
        this.codeSourcePermissions = old.codeSourcePermissions;
        this.serverIdentityHelper = old.serverIdentityHelper;
        this.preDefinePlugins = new ArrayList(old.preDefinePlugins);
    }

    void setCacheZipFiles(boolean cacheZipFiles) {
        this.cacheZipFiles = cacheZipFiles;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDelegationMode(boolean parentFirst) {
        this.delegate = parentFirst;
    }

    public boolean getDelegationMode() {
        return this.delegate;
    }

    public CompoundClassLoader reload() {
        return this.reload(true);
    }

    public CompoundClassLoader reload(boolean deepReload) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "reload this=" + this);
        }
        int n = this.providers.length;
        for (int i = 0; i < n; ++i) {
            this.providers[i].reload();
        }
        return new CompoundClassLoader(this);
    }

    public void dispose(boolean deepDispose) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "dispose this=" + this);
        }
        this.resourceRequestCache.clear();
        int n = this.providers.length;
        for (int i = 0; i < n; ++i) {
            this.providers[i].dispose();
        }
        this.reloadableParents.clear();
        this.localClassPath = "";
        this.nativelibpaths = null;
        this.libraryClassLoaders = null;
        this.preDefinePlugins.clear();
    }

    public synchronized void addPaths(String[] paths) {
        if (paths != null && paths.length != 0) {
            boolean debug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            ArrayList<SinglePathClassProvider> vProviders = new ArrayList<SinglePathClassProvider>();
            int n = paths.length;
            for (int i = 0; i < n; ++i) {
                SinglePathClassProvider provider = SinglePathClassProvider.create(paths[i], this.cacheZipFiles);
                vProviders.add(provider);
                if (!debug) continue;
                Tr.debug(tc, "adding " + provider);
            }
            this.addProviders(vProviders);
        }
    }

    public synchronized void addNativeLibPaths(String[] nlpaths) {
        if (nlpaths != null && nlpaths.length != 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "addNativeLibPaths native paths='" + PathUtils.arrayToString((String[])nlpaths) + "'");
            }
            String[] oldnlp = this.nativelibpaths;
            this.nativelibpaths = new String[oldnlp.length + nlpaths.length];
            System.arraycopy(oldnlp, 0, this.nativelibpaths, 0, oldnlp.length);
            System.arraycopy(nlpaths, 0, this.nativelibpaths, oldnlp.length, nlpaths.length);
        }
    }

    public synchronized void addLibraryClassLoaders(CompoundClassLoader[] libraryCLs) {
        if (libraryCLs != null && libraryCLs.length != 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                for (CompoundClassLoader libraryCL : libraryCLs) {
                    Tr.debug(tc, "addLibraryClassLoaders " + libraryCL);
                }
            }
            CompoundClassLoader[] oldLibraryCLs = this.libraryClassLoaders;
            this.libraryClassLoaders = new CompoundClassLoader[oldLibraryCLs.length + libraryCLs.length];
            System.arraycopy(oldLibraryCLs, 0, this.libraryClassLoaders, 0, oldLibraryCLs.length);
            System.arraycopy(libraryCLs, 0, this.libraryClassLoaders, oldLibraryCLs.length, libraryCLs.length);
        }
    }

    public void removePaths(String[] paths) {
        ArrayList<SinglePathClassProvider> vProviders = new ArrayList<SinglePathClassProvider>();
        int i = 0;
        int j = 0;
        boolean found = false;
        StringBuffer sb = new StringBuffer();
        for (i = this.providers.length - 1; i >= 0; --i) {
            for (j = paths.length - 1; j >= 0; --j) {
                if (!this.providers[i].getPath().equals(paths[j])) continue;
                found = true;
                break;
            }
            if (!found) {
                vProviders.add(this.providers[i]);
                sb.append(File.pathSeparatorChar).append(this.providers[i].getPath());
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "removing path: " + this.providers[i].getPath());
            }
            this.providers[i].dispose();
            found = false;
        }
        this.localClassPath = sb.length() > 0 ? sb.substring(1) : "";
        int newSize = vProviders.size();
        SinglePathClassProvider[] newProviders = new SinglePathClassProvider[newSize];
        newProviders = vProviders.toArray(newProviders);
        this.providers = newProviders;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removePaths complete this=" + this);
            Tr.debug(tc, "removePaths complete traversed=" + this.getClassPath());
        }
    }

    protected void addProviders(ArrayList v) {
        int alSize = v.size();
        int i = this.providers.length;
        SinglePathClassProvider[] newproviders = new SinglePathClassProvider[alSize + i];
        StringBuffer sb = new StringBuffer();
        SinglePathClassProvider spcp = null;
        for (int j = 0; j < alSize; ++j) {
            spcp = (SinglePathClassProvider)v.get(j);
            newproviders[i++] = spcp;
            sb.append(File.pathSeparatorChar).append(spcp.getPath());
        }
        if (sb.length() > 0) {
            this.localClassPath = this.localClassPath.length() == 0 ? sb.substring(1) : this.localClassPath.concat(sb.toString());
        }
        System.arraycopy(this.providers, 0, newproviders, 0, this.providers.length);
        this.providers = newproviders;
    }

    public void addClassProviderListener(ClassProviderListener cpl) {
        this.reloadableParents.add(cpl);
    }

    @Override
    public void classLoadedFromFile(File f) {
        int n = this.reloadableParents.size();
        for (int i = 0; i < n; ++i) {
            ClassProviderListener cl = (ClassProviderListener)this.reloadableParents.elementAt(i);
            cl.classLoadedFromFile(f);
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class loadedClass;
        boolean debug;
        block24: {
            boolean bl = debug = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
            if (debug) {
                Tr.entry(tc, "loadClass " + name + " this=" + this.toShortString());
            }
            if ((loadedClass = this.findLoadedClass(name)) == null) {
                try {
                    if (name.startsWith("java.")) {
                        try {
                            loadedClass = bootClassLoader.loadClass(name);
                            break block24;
                        }
                        catch (ClassNotFoundException cnfe) {
                            Tr.exit(tc, "loadClass " + name + " failed");
                            throw cnfe;
                        }
                    }
                    if (this.delegate) {
                        if (this.checkForSystemPrefix(name)) {
                            if (debug) {
                                Tr.exit(tc, "loadClass " + name + " failed");
                            }
                            throw new ClassNotFoundException(name);
                        }
                        loadedClass = this.libraryClassLoadersFindClass(name);
                        if (loadedClass != null) break block24;
                        try {
                            loadedClass = this.parent.loadClass(name);
                            break block24;
                        }
                        catch (ClassNotFoundException cnfe) {
                            loadedClass = this.localFindClass(name);
                            if (loadedClass == null) {
                                if (this.JIT_StubPlugin != null && name.endsWith("_Stub")) {
                                    loadedClass = this.JIT_StubPlugin.defineStubClass(name);
                                }
                                if (loadedClass == null) {
                                    Tr.exit(tc, "loadClass " + name + " failed");
                                    throw cnfe;
                                }
                            }
                            break block24;
                        }
                    }
                    loadedClass = this.localFindClass(name);
                    if (loadedClass != null || (loadedClass = this.libraryClassLoadersFindClass(name)) != null) break block24;
                    if (this.checkForSystemPrefix(name)) {
                        if (debug) {
                            Tr.exit(tc, "loadClass " + name + " failed");
                        }
                        throw new ClassNotFoundException(name);
                    }
                    try {
                        loadedClass = this.parent.loadClass(name);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (this.JIT_StubPlugin != null && name.endsWith("_Stub")) {
                            loadedClass = this.JIT_StubPlugin.defineStubClass(name);
                        }
                        if (loadedClass == null) {
                            Tr.exit(tc, "loadClass " + name + " failed");
                            throw cnfe;
                        }
                    }
                }
                catch (LinkageError ex) {
                    if (debug) {
                        Tr.exit(tc, "loadClass " + name + " " + ex);
                    }
                    throw ex;
                }
            }
        }
        if (resolve) {
            this.resolveClass(loadedClass);
        }
        if (debug) {
            final Class tmpLoadedClass = loadedClass;
            String loaderString = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String loaderString;
                    ClassLoader loader = tmpLoadedClass.getClassLoader();
                    if (loader instanceof CompoundClassLoader) {
                        loaderString = ((CompoundClassLoader)loader).toShortString();
                    } else {
                        loaderString = String.valueOf(loader);
                        CodeSource codeSource = tmpLoadedClass.getProtectionDomain().getCodeSource();
                        if (loader != null || codeSource != Object.class.getProtectionDomain().getCodeSource()) {
                            loaderString = loaderString + " source=" + codeSource.getLocation();
                        }
                    }
                    return loaderString;
                }
            });
            Tr.exit(tc, "loadClass " + name + " loader=" + loaderString);
        }
        return loadedClass;
    }

    public synchronized Class<?> defineApplicationClass(String className, byte[] bytecode) {
        Class<?> appClass;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "defineApplicationClass: " + className);
        }
        if ((appClass = this.findLoadedClass(className)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "calling defineClass on this");
            }
            appClass = this.defineClass(className, bytecode, 0, bytecode.length, svPD);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "class has already been loaded");
        }
        return appClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class localFindClass(String name) {
        byte[] classBytes = null;
        SinglePathClassProvider providerUsed = null;
        boolean debugEnabled = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        Object credentialToken = null;
        try {
            if (this.serverIdentityHelper != null) {
                credentialToken = this.serverIdentityHelper.push();
            }
            int n = this.providers.length;
            for (int i = 0; i < n; ++i) {
                classBytes = this.providers[i].getClassBytes(name, this);
                if (classBytes == null) continue;
                if (debugEnabled) {
                    Tr.debug(tc, "class " + name + " found in " + this.providers[i]);
                }
                providerUsed = this.providers[i];
                break;
            }
        }
        finally {
            if (credentialToken != null) {
                this.serverIdentityHelper.pop(credentialToken);
            }
        }
        if (classBytes == null) {
            return null;
        }
        if (plugin != null) {
            byte[] origBytes = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                origBytes = new byte[classBytes.length];
                System.arraycopy(classBytes, 0, origBytes, 0, classBytes.length);
            }
            byte[] newBytes = plugin.preDefineApplicationClass(name, classBytes);
            if (origBytes != null) {
                if (newBytes != classBytes) {
                    Tr.debug(tc, "class bytes replaced by " + plugin);
                } else {
                    for (int i = 0; i < classBytes.length; ++i) {
                        if (classBytes[i] == origBytes[i]) continue;
                        Tr.debug(tc, "class bytes changed at offset " + i + " by " + plugin);
                        break;
                    }
                }
            }
            classBytes = newBytes;
        }
        return this._defineClass(name, classBytes, providerUsed);
    }

    private Class libraryClassLoadersFindClass(String name) {
        Class foundClass = null;
        for (int i = 0; i < this.libraryClassLoaders.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "searching " + this.libraryClassLoaders[i].toShortString());
            }
            if ((foundClass = this.libraryClassLoaders[i].libraryClassLoaderFindClass(name)) != null) break;
        }
        return foundClass;
    }

    private Class libraryClassLoaderFindClass(String name) {
        Class foundClass = this.findLoadedClass(name);
        if (foundClass == null) {
            foundClass = this.localFindClass(name);
        }
        return foundClass;
    }

    protected Class _defineClass(String name, byte[] classBytes, SinglePathClassProvider providerUsed) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            Manifest man = providerUsed.getManifest();
            if (pkg == null) {
                if (man != null) {
                    this.definePackage(pkgname, man, providerUsed.getURL());
                } else {
                    this.definePackage(pkgname, null, null, null, null, null, null, null);
                }
            } else if (System.getSecurityManager() != null) {
                boolean ok;
                URL url = providerUsed.getURL();
                if (pkg.isSealed()) {
                    ok = pkg.isSealed(url);
                } else {
                    boolean bl = ok = man == null || !this.isSealed(pkgname, man);
                }
                if (!ok) {
                    throw new SecurityException("sealing violation on package=" + pkg.getName() + " at codesource=" + url);
                }
            }
        }
        CodeSource cs = new CodeSource(providerUsed.getURL(), (Certificate[])null);
        if (this.preDefinePlugins.size() > 0) {
            for (int j = 0; j < this.preDefinePlugins.size(); ++j) {
                ClassLoaderInstancePreDefinePlugin plugin = (ClassLoaderInstancePreDefinePlugin)this.preDefinePlugins.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Transforming " + name + " by " + plugin.getClass().getName());
                }
                classBytes = plugin.transformClass(name, classBytes, cs, this);
            }
        }
        return this.defineClass(name, classBytes, 0, classBytes.length, cs);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    @Override
    public URL getResource(String name) {
        URL url;
        boolean debug;
        boolean bl = debug = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (debug) {
            Tr.entry(tc, "getResource " + name + " this=" + this.toShortString());
        }
        if ((url = (URL)this.resourceRequestCache.get(name)) != null) {
            if (debug) {
                Tr.debug(tc, "cached");
            }
            if (url == badResource) {
                url = null;
            } else if (!url.getProtocol().equals("bundleresource")) {
                url = SinglePathClassProvider.checkURL(url);
                if (debug && url == null) {
                    Tr.debug(tc, "permission check failed");
                }
            }
        } else {
            if (this.delegate) {
                url = this.libraryClassLoadersFindResource(name);
                if (url == null && (url = this.parent.getResource(name)) == null) {
                    url = this.findResource(name);
                }
            } else {
                url = this.findResource(name);
                if (url == null && (url = this.libraryClassLoadersFindResource(name)) == null) {
                    url = this.parent.getResource(name);
                }
            }
            if (url == null) {
                this.resourceRequestCache.put(name, badResource);
            } else if (System.getSecurityManager() == null) {
                this.resourceRequestCache.put(name, url);
            } else {
                String protocol = url.getProtocol();
                if (protocol.equalsIgnoreCase("file") || protocol.equalsIgnoreCase("jar") || protocol.equals("wsjar") || protocol.equals("bundleresource")) {
                    this.resourceRequestCache.put(name, url);
                }
            }
        }
        if (debug) {
            Tr.exit(tc, "getResource " + url);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URL findResource(String name) {
        URL url = null;
        Object credentialToken = null;
        try {
            if (this.serverIdentityHelper != null) {
                credentialToken = this.serverIdentityHelper.push();
            }
            int n = this.providers.length;
            for (int i = 0; i < n; ++i) {
                url = this.providers[i].getResource(name);
                if (url == null) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "found in " + this.providers[i] + " this=" + this.toShortString());
                }
                break;
            }
        }
        finally {
            if (credentialToken != null) {
                this.serverIdentityHelper.pop(credentialToken);
            }
        }
        return url;
    }

    protected URL libraryClassLoadersFindResource(String name) {
        URL url = null;
        for (int i = 0; i < this.libraryClassLoaders.length && (url = this.libraryClassLoaders[i].findResource(name)) == null; ++i) {
        }
        return url;
    }

    public Enumeration getResources(String name) throws IOException {
        Vector resources = new Vector();
        if (this.resourceRequestCache.get(name) == badResource) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getResources " + name + " this=" + super.toString() + ": cached null");
            }
        } else {
            this.getResources(name, resources);
        }
        return resources.elements();
    }

    private void getResources(String name, Vector resources) throws IOException {
        boolean debug;
        boolean bl = debug = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (debug) {
            Tr.entry(tc, "getResources " + name + " this=" + super.toString());
        }
        if (this.delegate) {
            for (CompoundClassLoader libraryClassLoader : this.libraryClassLoaders) {
                libraryClassLoader.findResources(name, resources);
            }
            this.findParentResources(name, resources);
            this.findResources(name, resources);
        } else {
            this.findResources(name, resources);
            for (CompoundClassLoader libraryClassLoader : this.libraryClassLoaders) {
                libraryClassLoader.findResources(name, resources);
            }
            this.findParentResources(name, resources);
        }
        if (debug) {
            Tr.exit(tc, "getResources");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findResources(String name, Vector resources) {
        Object credentialToken = this.serverIdentityHelper == null ? null : this.serverIdentityHelper.push();
        try {
            int n = this.providers.length;
            for (int i = 0; i < n; ++i) {
                URL url = this.providers[i].getResource(name);
                if (url == null) continue;
                resources.add(url);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "found " + name + " in " + this.providers[i] + " this=" + this.toShortString());
            }
        }
        finally {
            if (credentialToken != null) {
                this.serverIdentityHelper.pop(credentialToken);
            }
        }
    }

    private void findParentResources(String name, Vector resources) throws IOException {
        if (this.parent instanceof CompoundClassLoader) {
            ((CompoundClassLoader)this.parent).getResources(name, resources);
        } else {
            Enumeration<URL> en = this.parent.getResources(name);
            while (en.hasMoreElements()) {
                URL resource = en.nextElement();
                resources.add(resource);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "found " + resource + " from parent");
            }
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        boolean debug;
        boolean bl = debug = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (debug) {
            Tr.entry(tc, "getResourceAsStream " + name + " this=" + this.toShortString());
        }
        InputStream is = null;
        URL url = this.getResource(name);
        try {
            is = url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceAsStream " + is);
        }
        return is;
    }

    protected boolean checkForSystemPrefix(String name) {
        if (this.protectedPrefixes != null) {
            int n = this.protectedPrefixes.length;
            for (int i = 0; i < n; ++i) {
                if (!name.startsWith(this.protectedPrefixes[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String findLibrary(String libname) {
        boolean debug;
        final String mappedLib = System.mapLibraryName(libname);
        boolean bl = debug = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (debug) {
            Tr.debug(tc, "findLibrary " + libname + " (" + mappedLib + ") this=" + this.toShortString());
        }
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    File lib;
                    File f;
                    int i;
                    int n = CompoundClassLoader.this.nativelibpaths.length;
                    for (i = 0; i < n; ++i) {
                        f = new File(CompoundClassLoader.this.nativelibpaths[i]);
                        if (!f.isDirectory() || !(lib = new File(f, mappedLib)).exists()) continue;
                        if (debug) {
                            Tr.debug(tc, "findLibrary " + lib);
                        }
                        return lib.getPath();
                    }
                    n = CompoundClassLoader.this.providers.length;
                    for (i = 0; i < n; ++i) {
                        f = new File(CompoundClassLoader.this.providers[i].getPath());
                        if (!f.isDirectory() || !(lib = new File(f, mappedLib)).exists()) continue;
                        if (debug) {
                            Tr.debug(tc, "findLibrary " + lib);
                        }
                        return lib.getPath();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    @Override
    public String getClassPath() {
        StringBuffer classpath = new StringBuffer();
        String libraryClassLoadersClasspath = this.getLibraryClassLoadersClassPath();
        String parentClasspath = this.getParentClassPath();
        if (this.delegate) {
            classpath.append(libraryClassLoadersClasspath);
            if (parentClasspath != null && parentClasspath.length() > 0) {
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparatorChar);
                }
                classpath.append(parentClasspath);
            }
            if (this.localClassPath.length() > 0) {
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparatorChar);
                }
                classpath.append(this.localClassPath);
            }
        } else {
            classpath.append(this.localClassPath);
            if (libraryClassLoadersClasspath.length() > 0) {
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparatorChar);
                }
                classpath.append(libraryClassLoadersClasspath);
            }
            if (parentClasspath != null && parentClasspath.length() > 0) {
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparatorChar);
                }
                classpath.append(parentClasspath);
            }
        }
        return classpath.toString();
    }

    protected String getParentClassPath() {
        String parentCP = null;
        if (this.parent instanceof WsClassLoader) {
            parentCP = ((WsClassLoader)((Object)this.parent)).getClassPath();
        } else if (this.parent instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)this.parent).getURLs();
            StringBuffer cpath = new StringBuffer();
            int n = urls.length;
            for (int i = 0; i < n; ++i) {
                if (!urls[i].getProtocol().equals("file")) continue;
                cpath.append(urls[i].getFile()).append(File.pathSeparatorChar);
            }
            parentCP = cpath.toString();
        } else {
            parentCP = System.getProperty("java.class.path");
        }
        return parentCP;
    }

    protected String getLibraryClassLoadersClassPath() {
        StringBuffer classpath = new StringBuffer();
        for (int i = 0; i < this.libraryClassLoaders.length; ++i) {
            classpath.append(File.pathSeparatorChar).append(this.libraryClassLoaders[i].localClassPath);
        }
        return classpath.length() > 0 ? classpath.substring(1) : "";
    }

    public CompoundClassLoader getCurrentClassLoader() {
        return this;
    }

    public String[] getPaths() {
        return this.localClassPath.split(File.pathSeparator);
    }

    public synchronized CompoundClassLoader[] getLibraryClassLoaders() {
        CompoundClassLoader[] result = new CompoundClassLoader[this.libraryClassLoaders.length];
        System.arraycopy(this.libraryClassLoaders, 0, result, 0, this.libraryClassLoaders.length);
        return result;
    }

    private String toShortString() {
        StringBuilder builder = new StringBuilder(super.toString());
        if (!this.delegate) {
            builder.append("[PL]");
        }
        if (this.name != null) {
            builder.append('[').append(this.name).append(']');
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append(super.toString());
        if (this.name != null) {
            sb.append('[').append(this.name).append(']');
        }
        sb.append("\n   Local ClassPath: ");
        sb.append(this.localClassPath);
        if (this.nativelibpaths.length != 0) {
            sb.append("\n   Native Library Path: ");
            sb.append(PathUtils.arrayToString((String[])this.nativelibpaths));
        }
        sb.append("\n   Parent: ");
        if (this.parent instanceof CompoundClassLoader) {
            sb.append(((CompoundClassLoader)this.parent).toShortString());
        } else {
            sb.append(this.parent);
        }
        sb.append("\n   Delegation Mode: ");
        sb.append(this.delegate ? "PARENT_FIRST" : "PARENT_LAST");
        if (this.libraryClassLoaders != null) {
            for (int i = 0; i < this.libraryClassLoaders.length; ++i) {
                sb.append("\n   Library Class Loader: ");
                sb.append(this.libraryClassLoaders[i].toShortString());
            }
        }
        return sb.toString();
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection perms = null;
        if (this.codeSourcePermissions != null) {
            perms = dynamicPolicy.getPermissions(cs, this.codeSourcePermissions);
        }
        if (perms == null) {
            perms = super.getPermissions(cs);
        }
        return perms;
    }

    public Map getCodeSourcePermissions() {
        return this.codeSourcePermissions;
    }

    public void setCodeSourcePermissions(Map codeSourcePermissions) {
        this.codeSourcePermissions = codeSourcePermissions;
        if (dynamicPolicy == null) {
            dynamicPolicy = DynamicPolicyFactory.getInstance();
        }
    }

    public boolean isAncestor(CompoundClassLoader cl) {
        CompoundClassLoader ccl;
        if (cl == this) {
            return true;
        }
        ClassLoader parent = this.getParent();
        if (parent instanceof ReloadableClassLoader && (ccl = ((ReloadableClassLoader)parent).getCurrentClassLoader()).isAncestor(cl)) {
            return true;
        }
        return parent instanceof CompoundClassLoader && (ccl = (CompoundClassLoader)parent).isAncestor(cl);
    }

    public void addPreDefinePlugin(ClassLoaderInstancePreDefinePlugin newPlugin) {
        int idx = this.preDefinePlugins.indexOf(newPlugin);
        if (idx != -1) {
            this.preDefinePlugins.remove(idx);
        }
        this.preDefinePlugins.add(newPlugin);
    }

    public void removePreDefinePlugin(ClassLoaderInstancePreDefinePlugin plugin) {
        this.preDefinePlugins.remove(plugin);
    }

    public JIT_StubClassPlugin setJIT_StubClassPlugin(JIT_StubClassPlugin plugin) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setJIT_StubClassPlugin : " + this.JIT_StubPlugin + " -> " + plugin);
        }
        JIT_StubClassPlugin oldPlugin = this.JIT_StubPlugin;
        this.JIT_StubPlugin = plugin;
        return oldPlugin;
    }

    public JIT_StubClassPlugin getJIT_StubClassPlugin() {
        return this.JIT_StubPlugin;
    }

    static {
        plugin = null;
        String bciClassName = System.getProperty("com.ibm.websphere.classloader.plugin");
        if (bciClassName != null) {
            block6: {
                try {
                    Class<?> bciClass = Class.forName(bciClassName, false, ExtClassLoader.getInstance());
                    plugin = (ClassLoaderPlugin)bciClass.newInstance();
                }
                catch (Throwable t) {
                    Manager.Ffdc.log(t, CompoundClassLoader.class, "com.ibm.ws.classloader.CompoundClassLoader", "70");
                    t.printStackTrace();
                    if (!(t instanceof ExceptionInInitializerError)) break block6;
                    ((ExceptionInInitializerError)t).getException().printStackTrace();
                }
            }
            if (plugin != null) {
                Tr.info(tc, "WSVR0331I", bciClassName);
            }
        }
        Permissions pc = new Permissions();
        ((PermissionCollection)pc).add(new AllPermission());
        svPD = new ProtectionDomain(null, pc);
        try {
            badResource = new URL("file:");
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static class ResourceRequestCache
    extends LinkedHashMap {
        ResourceRequestCache() {
            super(resourceRequestCacheSize, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > resourceRequestCacheSize;
        }
    }
}

