/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.ctm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.channel.framework.ctm.BaseChannelTypeManager;
import java.io.File;
import java.io.FileFilter;

public final class ValidationChannelTypeManager
extends BaseChannelTypeManager {
    private static TraceComponent tc = Tr.register(ValidationChannelTypeManager.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");

    public ValidationChannelTypeManager() {
        File[] channelJars;
        File dir = new File(System.getProperty("was.install.root"), "installedChannels");
        if (!dir.exists() || !dir.isDirectory()) {
            channelJars = new File[]{};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The directory " + dir + " does not exist or is not a directory");
            }
        } else {
            if (tc.isDebugEnabled()) {
                StringBuffer message = new StringBuffer();
                message.append("ValidationChannelTypeManager is loading channels from ");
                message.append(dir.getAbsolutePath());
                Tr.debug(tc, message.toString());
            }
            channelJars = dir.listFiles(new ChannelJARFilter());
        }
        if (!this.loadChannelDefinitions(channelJars)) {
            Tr.audit(tc, "channel.load.problems");
        }
    }

    protected static class ChannelJARFilter
    implements FileFilter {
        protected ChannelJARFilter() {
        }

        public boolean accept(File file) {
            return file.getName().startsWith("channel.") && file.getName().endsWith(".jar");
        }
    }
}

