/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.cos;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorRenderer;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.activity.remote.cos.ContextList;
import com.ibm.ws.activity.remote.cos.CosActivityContextDescriptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.util.WSThreadLocal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosActivity.ActivityContext;
import org.omg.CosActivity.ActivityCoordinatorHelper;
import org.omg.CosActivity.ActivityIdentity;
import org.omg.CosActivity.PropertyGroupIdentity;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class CosActivityContextDescriptorRenderer
extends ActivityContextDescriptorRenderer {
    private static final TraceComponent tc = Tr.register(CosActivityContextDescriptorRenderer.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private ExtendedClientRequestInfo _clientRequestInfo = null;
    private ServerRequestInfo _serverRequestInfo = null;
    private static WSThreadLocal _cachedPropagationContexts = new WSThreadLocal();
    private List _renderedContexts = null;
    private Map _maximumSendSizes = null;
    private byte[] _cachedPropagationContext = null;
    private boolean _optimiseReplyContext;

    protected CosActivityContextDescriptorRenderer(ServerRequestInfo requestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CosActivityContextDescriptorRenderer", requestInfo);
        }
        this._serverRequestInfo = requestInfo;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CosActivityContextDescriptorRenderer", this);
        }
    }

    protected CosActivityContextDescriptorRenderer(ExtendedClientRequestInfo requestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CosActivityContextDescriptorRenderer", requestInfo);
        }
        this._clientRequestInfo = requestInfo;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CosActivityContextDescriptorRenderer", this);
        }
    }

    public boolean renderingStarting(List importedContexts) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "renderingStarting", importedContexts);
        }
        if (importedContexts instanceof ContextList) {
            this._optimiseReplyContext = ((ContextList)importedContexts).isOptimised();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "renderingStarting ... optimise", this._optimiseReplyContext);
            }
        }
        return this.renderingStarting();
    }

    public boolean renderingStarting() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renderingStarting", this);
        }
        boolean result = true;
        if (this._clientRequestInfo != null) {
            this._cachedPropagationContext = (byte[])_cachedPropagationContexts.get();
            boolean bl = result = this._cachedPropagationContext == null;
            if (result) {
                this._maximumSendSizes = new HashMap();
            }
        } else {
            this._maximumSendSizes = new HashMap();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renderingStarting", result);
        }
        return result;
    }

    public void render(ActivityContextDescriptor descriptor, boolean outboundRequest) throws SystemException {
        ActivityIdentity activityIdentity;
        CosActivityContextDescriptor child;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "render", new Object[]{descriptor, outboundRequest, this});
        }
        if ((child = (CosActivityContextDescriptor)descriptor.getChild()) != null) {
            this.render(child, outboundRequest);
        }
        if ((activityIdentity = ((CosActivityContextDescriptor)descriptor).marshalActivityIdentity(outboundRequest, this._maximumSendSizes, this._optimiseReplyContext)) != null) {
            if (this._renderedContexts == null) {
                this._renderedContexts = new ArrayList();
            }
            this._renderedContexts.add(activityIdentity);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "render");
        }
    }

    public void renderingComplete() throws SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renderingComplete", this);
        }
        byte[] propagationContext = null;
        if (this._clientRequestInfo != null) {
            propagationContext = this._cachedPropagationContext;
        }
        if (propagationContext == null) {
            List liteAIs;
            ActivityIdentity[] renderedContexts = null;
            if (this._renderedContexts != null) {
                renderedContexts = this._renderedContexts.toArray(new ActivityIdentity[0]);
            }
            if (this._clientRequestInfo != null && (liteAIs = ActivityService.getLiteData()) != null && !liteAIs.isEmpty()) {
                ActivityIdentity[] liteActivityIdentities = liteAIs.toArray(new ActivityIdentity[0]);
                if (renderedContexts == null) {
                    renderedContexts = liteActivityIdentities;
                } else {
                    ActivityIdentity[] combinedContexts = new ActivityIdentity[liteActivityIdentities.length + renderedContexts.length];
                    System.arraycopy(liteActivityIdentities, 0, combinedContexts, 0, liteActivityIdentities.length);
                    System.arraycopy(renderedContexts, 0, combinedContexts, liteActivityIdentities.length, renderedContexts.length);
                    renderedContexts = combinedContexts;
                }
            }
            if (renderedContexts != null) {
                ActivityContext activityContext = new ActivityContext();
                activityContext.hierarchy = renderedContexts;
                activityContext.invocation_specific_data = ActivityService.getORB().create_any();
                activityContext.invocation_specific_data.insert_long(0);
                CDROutputStream outputStream = ORB.createCDROutputStream((ORB)((ORB)ActivityService.getORB()));
                outputStream.putEndian();
                CosActivityContextDescriptorRenderer.writeToOutputStream(outputStream, activityContext, this._maximumSendSizes);
                propagationContext = outputStream.toByteArray();
                if (this._clientRequestInfo != null) {
                    _cachedPropagationContexts.set(propagationContext);
                }
            }
        }
        if (propagationContext != null) {
            ServiceContext context = new ServiceContext(16, propagationContext);
            if (this._clientRequestInfo != null) {
                this._clientRequestInfo.add_request_service_context(context, true);
            } else {
                this._serverRequestInfo.add_reply_service_context(context, true);
            }
        }
        if (this._clientRequestInfo == null) {
            ActivityService.instance().resetLiteData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renderingComplete");
        }
    }

    protected static void replyReceived() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replyReceived");
        }
        _cachedPropagationContexts.set(null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replyReceived");
        }
    }

    private static void writeToOutputStream(CDROutputStream ostream, ActivityContext value, Map maximumSendSizes) throws PropertyGroupTooLargeException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeToOutputStream", new Object[]{ostream, value, maximumSendSizes});
        }
        try {
            ostream.write_long(value.hierarchy.length);
            for (int _i0 = 0; _i0 < value.hierarchy.length; ++_i0) {
                CosActivityContextDescriptorRenderer.writeToOutputStream(ostream, value.hierarchy[_i0], maximumSendSizes);
            }
            ostream.write_any(value.invocation_specific_data);
        }
        catch (PropertyGroupTooLargeException pgtle) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeToOutputStream", pgtle);
            }
            throw pgtle;
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorRenderer.writeToOutputStream", "129");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unknown exception thrown");
            }
            Object[] parms = new Object[]{"writeToOutputStream", "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorRenderer", ex};
            Tr.error(tc, "ERR_UNEXP_EXCPN", parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeToOutputStream", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeToOutputStream");
        }
    }

    private static void writeToOutputStream(CDROutputStream ostream, ActivityIdentity value, Map maximumSendSizes) throws PropertyGroupTooLargeException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeToOutputStream", new Object[]{ostream, value, maximumSendSizes});
        }
        try {
            ostream.write_ulong(value.type);
            ostream.write_long(value.timeout);
            ActivityCoordinatorHelper.write((OutputStream)ostream, value.coord);
            ostream.write_long(value.ctxId.length);
            ostream.write_octet_array(value.ctxId, 0, value.ctxId.length);
            ostream.write_long(value.pgCtx.length);
            for (int _i0 = 0; _i0 < value.pgCtx.length; ++_i0) {
                CosActivityContextDescriptorRenderer.writeToOutputStream(ostream, value.pgCtx[_i0], maximumSendSizes);
            }
            ostream.write_any(value.activity_specific_data);
        }
        catch (PropertyGroupTooLargeException pgtle) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeToOutputStream", pgtle);
            }
            throw pgtle;
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorRenderer.writeToOutputStream", "164");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unknown exception thrown");
            }
            Object[] parms = new Object[]{"writeToOutputStream", "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorRenderer", ex};
            Tr.error(tc, "ERR_UNEXP_EXCPN", parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeToOutputStream", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeToOutputStream");
        }
    }

    private static void writeToOutputStream(CDROutputStream ostream, PropertyGroupIdentity value, Map maximumSendSizes) throws PropertyGroupTooLargeException, SystemException, IMP_LIMIT {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeToOutputStream", new Object[]{ostream, value, maximumSendSizes});
        }
        try {
            Integer maximumSendSize;
            Object[] maxSendSizeInfo;
            ostream.write_string(value.property_group_name);
            int size = ostream.getSize();
            ostream.write_any(value.context_data);
            int length = ostream.getSize() - size;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property group's length: " + length);
            }
            if ((maxSendSizeInfo = (Object[])maximumSendSizes.get(value)) != null && (maximumSendSize = (Integer)maxSendSizeInfo[0]) < length) {
                Tr.error(tc, "ERR_IMP_LIMIT", new Object[]{maxSendSizeInfo[1], value.property_group_name, new Integer(length), maximumSendSize});
                PropertyGroupTooLargeException pgtle = new PropertyGroupTooLargeException();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeToOutputStream", pgtle);
                }
                throw pgtle;
            }
        }
        catch (PropertyGroupTooLargeException pgtle) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeToOutputStream", pgtle);
            }
            throw pgtle;
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorRenderer.writeToOutputStream", "189");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unknown exception thrown");
            }
            Object[] parms = new Object[]{"writeToOutputStream", "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorRenderer", ex};
            Tr.error(tc, "ERR_UNEXP_EXCPN", parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeToOutputStream", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeToOutputStream");
        }
    }
}

