/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.cos;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.ActivityContextDescriptorFactory;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.activity.remote.cos.ContextList;
import com.ibm.ws.activity.remote.cos.CosActivityContextDescriptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.SystemException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.portable.InputStream;
import org.omg.CosActivity.ActivityContext;
import org.omg.CosActivity.ActivityCoordinatorHelper;
import org.omg.CosActivity.ActivityIdentity;
import org.omg.CosActivity.PropertyGroupIdentity;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class CosActivityContextDescriptorFactory
implements ActivityContextDescriptorFactory {
    private static final TraceComponent tc = Tr.register(CosActivityContextDescriptorFactory.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");

    public ActivityContextDescriptor createDescriptor(LocalActivityContext context, boolean outboundSIBWSRequest) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDescriptor", new Object[]{context, outboundSIBWSRequest, this});
        }
        CosActivityContextDescriptor result = new CosActivityContextDescriptor(context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDescriptor", result);
        }
        return result;
    }

    public List extractDescriptors(Object message) throws SystemException, PropertyGroupTooLargeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractDescriptors", new Object[]{message, this});
        }
        ServiceContext serviceContext = null;
        ExtendedServerRequestInfo serverRequestInfo = null;
        if (message instanceof ExtendedClientRequestInfo) {
            serviceContext = ((ExtendedClientRequestInfo)message).getReplyServiceContext(16);
        } else {
            serverRequestInfo = (ExtendedServerRequestInfo)message;
            serviceContext = serverRequestInfo.getRequestServiceContext(16);
        }
        ContextList extractedRootDescriptors = new ContextList();
        if (serviceContext != null && serviceContext.context_data != null) {
            ActivityContext activityContext;
            HashMap marshalledPropertyGroupSizes;
            block9: {
                byte[] activityPropagationContext = serviceContext.context_data;
                ORB orb = (ORB)ActivityService.getORB();
                CDRInputStream is = ORB.createCDRInputStream((ORB)orb, (byte[])activityPropagationContext, (int)activityPropagationContext.length);
                is.consumeEndian();
                marshalledPropertyGroupSizes = new HashMap();
                activityContext = CosActivityContextDescriptorFactory.readActivityContextFromInputStream((InputStream)is, marshalledPropertyGroupSizes);
                try {
                    int i = activityContext.invocation_specific_data.extract_long();
                    extractedRootDescriptors.setOptimised();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "extractDescriptors ... found optimised context");
                    }
                }
                catch (BAD_OPERATION ex) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "extractDescriptors ... NO optimised context", (Object)ex);
                }
            }
            HashMap importedContexts = new HashMap();
            for (int i = 0; i < activityContext.hierarchy.length; ++i) {
                CosActivityContextDescriptor.create(activityContext.hierarchy[i], importedContexts, (List)extractedRootDescriptors, (ServerRequestInfo)serverRequestInfo, marshalledPropertyGroupSizes);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractDescriptors", extractedRootDescriptors);
        }
        return extractedRootDescriptors;
    }

    protected static ActivityContext readActivityContextFromInputStream(InputStream istream, Map marshalledPropertyGroupSizes) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readActivityContextFromInputStream", new Object[]{istream, marshalledPropertyGroupSizes});
        }
        ActivityContext value = new ActivityContext();
        try {
            int _len0 = istream.read_long();
            value.hierarchy = new ActivityIdentity[_len0];
            for (int _o1 = 0; _o1 < value.hierarchy.length; ++_o1) {
                value.hierarchy[_o1] = CosActivityContextDescriptorFactory.readActivityIdentityFromInputStream(istream, marshalledPropertyGroupSizes);
            }
            value.invocation_specific_data = istream.read_any();
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory.readActivityContextFromInputStream", "81");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught", ex);
            }
            Object[] parms = new Object[]{"readActivityContextFromInputStream", "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory", ex};
            Tr.error(tc, "ERR_UNEXP_EXCPN", parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readActivityContextFromInputStream", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readActivityContextFromInputStream", value);
        }
        return value;
    }

    private static ActivityIdentity readActivityIdentityFromInputStream(InputStream istream, Map marshalledPropertyGroupSizes) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readActivityIdentityFromInputStream", new Object[]{istream, marshalledPropertyGroupSizes});
        }
        ActivityIdentity value = new ActivityIdentity();
        try {
            value.type = istream.read_ulong();
            value.timeout = istream.read_long();
            value.coord = ActivityCoordinatorHelper.read(istream);
            int _len0 = istream.read_long();
            value.ctxId = new byte[_len0];
            istream.read_octet_array(value.ctxId, 0, _len0);
            int _len1 = istream.read_long();
            value.pgCtx = new PropertyGroupIdentity[_len1];
            for (int _o2 = 0; _o2 < value.pgCtx.length; ++_o2) {
                value.pgCtx[_o2] = CosActivityContextDescriptorFactory.readPropertyGroupIdentityFromInputStream(istream, marshalledPropertyGroupSizes);
            }
            value.activity_specific_data = istream.read_any();
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory.readActivityIdentityFromInputStream", "128");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught", ex);
            }
            Object[] parms = new Object[]{"readActivityIdentityFromInputStream", "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory", ex};
            Tr.error(tc, "ERR_UNEXP_EXCPN", parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readActivityIdentityFromInputStream");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readActivityIdentityFromInputStream", value);
        }
        return value;
    }

    private static PropertyGroupIdentity readPropertyGroupIdentityFromInputStream(InputStream istream, Map marshalledPropertyGroupSizes) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readPropertyGroupIdentityFromInputStream", new Object[]{istream, marshalledPropertyGroupSizes});
        }
        PropertyGroupIdentity value = new PropertyGroupIdentity();
        try {
            value.property_group_name = istream.read_string();
            int available = istream.available();
            value.context_data = istream.read_any();
            int length = available - istream.available();
            if (marshalledPropertyGroupSizes != null) {
                marshalledPropertyGroupSizes.put(value, new Integer(length));
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory.readPropertyGroupIdentityFromInputStream", "157");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught", ex);
            }
            Object[] parms = new Object[]{"readPropertyGroupIdentityFromInputStream", "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptorFactory", ex};
            Tr.error(tc, "ERR_UNEXP_EXCPN", parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readPropertyGroupIdentityFromInputStream", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readPropertyGroupIdentityFromInputStream", value);
        }
        return value;
    }
}

