/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote.cos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityCoordinatorImpl;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.activity.GlobalIdImpl;
import com.ibm.ws.activity.HLSInformation;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.PropertyGroupInfo;
import com.ibm.ws.activity.UserActivityImpl;
import com.ibm.ws.activity.j2ee_activity_specific_data;
import com.ibm.ws.activity.j2ee_activity_specific_dataHelper;
import com.ibm.ws.activity.remote.ActivityContextDescriptor;
import com.ibm.ws.activity.remote.CoordinatorProxy;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.activity.remote.PropertyGroupTooLargeException;
import com.ibm.ws.activity.remote.RemoteCoordinator;
import com.ibm.ws.activity.remote.cos.CosActivityCoordinatorProxy;
import com.ibm.ws.activity.remote.cos.CosActivityRemoteCoordinator;
import com.ibm.ws.activity.remote.cos.CosActivityUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.PropertyGroupContext;
import com.ibm.ws.javax.activity.ServiceInformation;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.coordination.ServiceManager;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CosActivity.ActivityIdentity;
import org.omg.CosActivity.PropertyGroupIdentity;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class CosActivityContextDescriptor
extends ActivityContextDescriptor {
    private static final TraceComponent tc = Tr.register(CosActivityContextDescriptor.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private Any _serviceSpecificData = null;
    private static final long serialVersionUID = 4333382421033909511L;

    public CosActivityContextDescriptor(LocalActivityContext context) {
        super(context, false, false);
        LocalActivityContext childContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CosActivityContextDescriptor", context);
        }
        if ((childContext = this._context.getActiveChild()) != null) {
            this._child = new CosActivityContextDescriptor(childContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CosActivityContextDescriptor", this);
        }
    }

    public CosActivityContextDescriptor(String id, int timeout, String contextGroup, String serviceName, int type, CoordinatorProxy coordinator, List propertyGroups, Serializable activitySpecificData, ActivityContextDescriptor child, Any serviceSpecificData) {
        super(id, timeout, contextGroup, serviceName, type, coordinator, propertyGroups, activitySpecificData, child, false);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CosActivityContextDescriptor", new Object[]{id, new Integer(timeout), contextGroup, serviceName, new Integer(type), coordinator, propertyGroups, activitySpecificData, child, serviceSpecificData});
        }
        this._serviceSpecificData = serviceSpecificData;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CosActivityContextDescriptor", this);
        }
    }

    protected static void create(ActivityIdentity ai, HashMap importedRootContextMap, List importedRootContextList, ServerRequestInfo serverRequestInfo, Map marshalledPropertyGroupSizes) throws PropertyGroupTooLargeException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", new Object[]{ai, importedRootContextMap, importedRootContextList, serverRequestInfo, marshalledPropertyGroupSizes});
        }
        String contextGroup = null;
        String serviceName = null;
        Any serviceSpecificData = null;
        if (ai.type == 2) {
            contextGroup = "default";
            serviceName = "";
        } else {
            j2ee_activity_specific_data jasd = j2ee_activity_specific_dataHelper.extract((Any)ai.activity_specific_data);
            contextGroup = jasd.context_group;
            serviceName = jasd.service_name;
            serviceSpecificData = jasd.service_specific_data;
        }
        String id = new GlobalIdImpl(ai.ctxId).toString();
        if (ActivityService.isLiteService(serviceName)) {
            if (serverRequestInfo != null) {
                ActivityService.setLiteData(serviceName, ai, serverRequestInfo);
            }
        } else {
            CosActivityCoordinatorProxy coordinator = null;
            if (ai.coord != null) {
                coordinator = new CosActivityCoordinatorProxy(ai.coord);
            }
            CosActivityContextDescriptor descriptor = new CosActivityContextDescriptor(id, ai.timeout, contextGroup, serviceName, ai.type, (CoordinatorProxy)coordinator, CosActivityContextDescriptor.extractPropertyGroups(ai, serviceName, marshalledPropertyGroupSizes), (Serializable)ai.activity_specific_data, (ActivityContextDescriptor)importedRootContextMap.get(serviceName), serviceSpecificData);
            CosActivityContextDescriptor replacedContext = importedRootContextMap.put(serviceName, descriptor);
            importedRootContextList.remove(replacedContext);
            importedRootContextList.add(descriptor);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
    }

    private static List extractPropertyGroups(ActivityIdentity ai, String serviceName, Map marshalledPropertyGroupSizes) throws PropertyGroupTooLargeException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractPropertyGroups", new Object[]{ai, serviceName, marshalledPropertyGroupSizes});
        }
        ArrayList<PropertyGroupContext> propertyGroupsList = new ArrayList<PropertyGroupContext>();
        PropertyGroupIdentity[] propertyGroups = ai.pgCtx;
        if (propertyGroups != null) {
            for (int i = 0; i < propertyGroups.length; ++i) {
                int length;
                int maxReceiveSize;
                PropertyGroupInfo propertyGroupInfo;
                PropertyGroupIdentity propertyGroupIdentity = propertyGroups[i];
                String name = propertyGroupIdentity.property_group_name;
                Any dataAsAny = propertyGroupIdentity.context_data;
                HLSInformation hlsInformation = UserActivityImpl.getRegisteredService((String)serviceName);
                if (hlsInformation != null && (propertyGroupInfo = hlsInformation.getPropertyGroupInfo(name)) != null && (maxReceiveSize = propertyGroupInfo._maxReceiveSize) > -1 && (length = ((Integer)marshalledPropertyGroupSizes.get(propertyGroupIdentity)).intValue()) > maxReceiveSize) {
                    PropertyGroupTooLargeException pgtle = new PropertyGroupTooLargeException();
                    Tr.error(tc, "ERR_IMP_LIMIT", new Object[]{serviceName, name, new Integer(length), new Integer(maxReceiveSize)});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "extractPropertyGroups", pgtle);
                    }
                    throw pgtle;
                }
                if (CosActivityUtils.getAnyMO().type().equal(dataAsAny.type())) {
                    MarshalledObject mo = (MarshalledObject)dataAsAny.extract_Value();
                    try {
                        propertyGroupsList.add(new PropertyGroupContext(name, (Serializable)mo.get()));
                        continue;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptor.extractPropertyGroups", "175");
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Exception caught getting Serializable from MarshalledObject", e);
                        }
                        SystemException se = new SystemException(e);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "extractPropertyGroups", se);
                        }
                        throw se;
                    }
                }
                propertyGroupsList.add(new PropertyGroupContext(name, dataAsAny));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractPropertyGroups", propertyGroupsList);
        }
        return propertyGroupsList;
    }

    private void insertPropertyGroups(List propertyGroupContextList, PropertyGroupIdentity[] propertyGroupIdentities, int index, Map maximumSendSizes) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertPropertyGroups", new Object[]{propertyGroupContextList, propertyGroupIdentities, new Integer(index), maximumSendSizes, this});
        }
        for (PropertyGroupContext propertyGroupContext : propertyGroupContextList) {
            int maxSendSize;
            PropertyGroupIdentity propertyGroupIdentity = new PropertyGroupIdentity();
            propertyGroupIdentity.property_group_name = propertyGroupContext.getPropertyGroupName();
            Any pgcData = propertyGroupContext.getContextDataAny();
            if (pgcData == null) {
                ORB orb = ActivityService.getORB();
                pgcData = orb.create_any();
                Serializable ser = propertyGroupContext.getContextDataValue();
                if (ser != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Placing Serializable in MarshalledObject");
                    }
                    try {
                        MarshalledObject<Serializable> mo = new MarshalledObject<Serializable>(ser);
                        pgcData.insert_Value(mo);
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.activity.remote.cos.CosActivityContextDescriptor.insertPropertyGroups", "232", this);
                        SystemException se = new SystemException(ioe);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "insertPropertyGroups", se);
                        }
                        throw se;
                    }
                }
            }
            propertyGroupIdentity.context_data = pgcData;
            propertyGroupIdentities[index++] = propertyGroupIdentity;
            PropertyGroupInfo propertyGroupInfo = this._context.getPropertyGroupManager(propertyGroupIdentity.property_group_name);
            if (propertyGroupInfo == null || (maxSendSize = propertyGroupInfo._maxSendSize) <= -1) continue;
            maximumSendSizes.put(propertyGroupIdentity, new Object[]{new Integer(maxSendSize), this._serviceName});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertPropertyGroups");
        }
    }

    private ActivityIdentity createActivityIdentity(DistributedActivityContext distributedContext, boolean outboundRequest, Map maximumSendSizes) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createActivityIdentity", new Object[]{distributedContext, outboundRequest, maximumSendSizes, this});
        }
        ActivityIdentity result = new ActivityIdentity();
        result.type = this._type;
        result.timeout = this._timeout;
        result.ctxId = this._context.getGlobalId().toBytes();
        result.activity_specific_data = (Any)distributedContext.getActivitySpecificData();
        if (result.activity_specific_data == null) {
            result.activity_specific_data = CosActivityUtils.createActivitySpecificData((ServiceManager)this._context.getServiceManager());
            distributedContext.setActivitySpecificData((Serializable)result.activity_specific_data);
        }
        List cachedPropertyGroupContexts = null;
        if (outboundRequest) {
            cachedPropertyGroupContexts = this._context.getDistributedContext().getCachedPropertyGroupContexts();
        }
        int propertyGroupCount = 0;
        if (this._propertyGroupContexts != null) {
            propertyGroupCount += this._propertyGroupContexts.size();
        }
        if (cachedPropertyGroupContexts != null) {
            propertyGroupCount += cachedPropertyGroupContexts.size();
        }
        result.pgCtx = new PropertyGroupIdentity[propertyGroupCount];
        if (propertyGroupCount > 0) {
            if (this._propertyGroupContexts != null) {
                this.insertPropertyGroups(this._propertyGroupContexts, result.pgCtx, 0, maximumSendSizes);
                if (cachedPropertyGroupContexts != null) {
                    this.insertPropertyGroups(cachedPropertyGroupContexts, result.pgCtx, this._propertyGroupContexts.size(), maximumSendSizes);
                }
            } else {
                this.insertPropertyGroups(cachedPropertyGroupContexts, result.pgCtx, 0, maximumSendSizes);
            }
        }
        LocalActivityContext localContext = distributedContext.getLocalContext();
        if (outboundRequest) {
            ActivityCoordinatorImpl localCoordinator = localContext.getCoordinatorRef();
            if (localCoordinator != null) {
                CosActivityRemoteCoordinator remoteCoordinator = (CosActivityRemoteCoordinator)localCoordinator.getRemoteCoordinator();
                if (remoteCoordinator == null) {
                    remoteCoordinator = new CosActivityRemoteCoordinator(localCoordinator, distributedContext.getSuperiorCoordinatorProxy(), localContext.getHLSInformation());
                    remoteCoordinator.connect();
                }
                result.coord = remoteCoordinator.getCosActivityCoordinator();
                localCoordinator.setRemoteCoordinator((RemoteCoordinator)remoteCoordinator);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "localCoord ref added to context: " + result.coord);
                }
            } else {
                CoordinatorProxy superiorProxy = distributedContext.getSuperiorCoordinatorProxy();
                result.coord = superiorProxy != null ? ((CosActivityCoordinatorProxy)superiorProxy).getCosActivityCoordinator() : null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "superiorCoord ref added to context: " + result.coord);
                }
            }
        } else {
            CoordinatorProxy superiorProxy = distributedContext.getSuperiorCoordinatorProxy();
            if (superiorProxy != null) {
                if (superiorProxy instanceof CosActivityCoordinatorProxy) {
                    result.coord = ((CosActivityCoordinatorProxy)superiorProxy).getCosActivityCoordinator();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "superiorCoord ref added to context: " + result.coord);
                }
            } else {
                ActivityCoordinatorImpl localCoordinator = localContext.getCoordinatorRef();
                if (localCoordinator != null) {
                    CosActivityRemoteCoordinator remoteCoordinator = (CosActivityRemoteCoordinator)localCoordinator.getRemoteCoordinator();
                    if (remoteCoordinator == null) {
                        remoteCoordinator = new CosActivityRemoteCoordinator(localCoordinator, distributedContext.getSuperiorCoordinatorProxy(), localContext.getHLSInformation());
                        remoteCoordinator.connect();
                    }
                    result.coord = remoteCoordinator.getCosActivityCoordinator();
                    localCoordinator.setRemoteCoordinator((RemoteCoordinator)remoteCoordinator);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "localCoord ref added to context: " + result.coord);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createActivityIdentity", result);
        }
        return result;
    }

    protected ActivityIdentity marshalActivityIdentity(boolean outboundRequest, Map maximumSendSizes, boolean optimise) throws SystemException {
        DistributedActivityContext distributedContext;
        ActivityContextDescriptor cachedContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshalActivityIdentity", new Object[]{outboundRequest, maximumSendSizes, optimise, this});
        }
        if ((cachedContext = (distributedContext = this._context.getDistributedContext()).getCachedContext()) != null) {
            ActivityIdentity cachedIdentity = null;
            if (cachedContext instanceof CosActivityContextDescriptor) {
                if (!outboundRequest && !distributedContext.isCachedContextUpdated()) {
                    if (optimise) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Upstream request with unchanged cached identity, returning null ActivityIdentity");
                        }
                    } else {
                        cachedIdentity = ((CosActivityContextDescriptor)cachedContext).createActivityIdentity(distributedContext, outboundRequest, maximumSendSizes);
                        cachedIdentity.pgCtx = new PropertyGroupIdentity[0];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "returning cached AI with zero pg array size");
                        }
                    }
                } else {
                    cachedIdentity = ((CosActivityContextDescriptor)cachedContext).createActivityIdentity(distributedContext, outboundRequest, maximumSendSizes);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "returning cached AI with pg array size of: " + cachedIdentity.pgCtx.length);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "marshalActivityIdentity", cachedIdentity);
            }
            return cachedIdentity;
        }
        ActivityIdentity result = this.createActivityIdentity(distributedContext, outboundRequest, maximumSendSizes);
        if (!outboundRequest && optimise && result.pgCtx.length == 0 && (result.coord == null || distributedContext.hasUpstreamCoord())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Activity unchanged on response, returning null ActivityIdentity");
            }
            result = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshalActivityIdentity", result);
        }
        return result;
    }

    public ServiceInformation getServiceInformation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceInformation", this);
        }
        ServiceInformation serviceInformation = null;
        try {
            MarshalledObject mo = (MarshalledObject)this._serviceSpecificData.extract_Value();
            serviceInformation = new ServiceInformation(this._serviceName, this._contextGroup, mo);
        }
        catch (Exception exc) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Exception caught extracting marshalled object. Using the any as it is.");
            }
            serviceInformation = new ServiceInformation(this._serviceName, this._contextGroup, this._serviceSpecificData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceInformation", serviceInformation);
        }
        return serviceInformation;
    }
}

