/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity.remote;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.LocalActivityContext;
import com.ibm.ws.activity.PropertyGroupInfo;
import com.ibm.ws.activity.remote.CoordinatorProxy;
import com.ibm.ws.activity.remote.DistributedActivityContext;
import com.ibm.ws.javax.activity.PropertyGroupContext;
import com.ibm.ws.javax.activity.ServiceInformation;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroup;
import com.ibm.ws.javax.activity.propertygroup.PropertyGroupManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ActivityContextDescriptor
implements Serializable {
    private static final TraceComponent tc = Tr.register(ActivityContextDescriptor.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    protected int _timeout = -1;
    protected String _id = null;
    protected List _propertyGroupContexts = null;
    protected String _serviceName = null;
    protected ActivityContextDescriptor _child = null;
    protected Serializable _activitySpecificData = null;
    protected String _contextGroup = null;
    protected int _type = 1;
    protected CoordinatorProxy _coordinator = null;
    protected boolean _custom = false;
    protected boolean _representsAllAncestorNodes = false;
    protected LocalActivityContext _context = null;

    protected ActivityContextDescriptor(String id, int timeout, String contextGroup, String serviceName, int type, CoordinatorProxy coordinator, List propertyGroups, Serializable activitySpecificData, ActivityContextDescriptor child, boolean custom) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ActivityContextDescriptor", new Object[]{id, new Integer(timeout), contextGroup, serviceName, new Integer(type), coordinator, propertyGroups, activitySpecificData, child, custom});
        }
        this._id = id;
        this._timeout = timeout;
        this._contextGroup = contextGroup;
        this._serviceName = serviceName;
        this._type = type;
        this._coordinator = coordinator;
        this._propertyGroupContexts = propertyGroups;
        this._activitySpecificData = activitySpecificData;
        this._child = child;
        this._context = null;
        this._custom = custom;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ActivityContextDescriptor", this);
        }
    }

    protected ActivityContextDescriptor(LocalActivityContext context, boolean custom, boolean outboundSIBWSRequest) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ActivityContextDescriptor", new Object[]{context, custom, outboundSIBWSRequest});
        }
        this._context = context;
        this._timeout = this._context.getTimeout();
        this._id = this._context.getGlobalId().print();
        this._serviceName = this._context.getServiceName();
        this._type = context.getType();
        this._custom = custom;
        this._contextGroup = context.getContextGroup();
        DistributedActivityContext distributedContext = context.getDistributedContext();
        if (!this._custom) {
            this.updatePropertyGroups(true);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Custom-rendered context; skipping update of property groups");
        }
        if (distributedContext == null) {
            distributedContext = new DistributedActivityContext(context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ActivityContextDescriptor", this);
        }
    }

    public ActivityContextDescriptor getChild() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChild", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChild", this._child);
        }
        return this._child;
    }

    public LocalActivityContext getContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContext", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContext", this._context);
        }
        return this._context;
    }

    public void setContext(LocalActivityContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setContext", new Object[]{context, this});
        }
        this._context = context;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setContext");
        }
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getId", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getId", this._id);
        }
        return this._id;
    }

    public String getServiceName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceName", this._serviceName);
        }
        return this._serviceName;
    }

    public int getTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeout", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeout", new Integer(this._timeout));
        }
        return this._timeout;
    }

    public List getPropertyGroups() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyGroups", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyGroups", this._propertyGroupContexts);
        }
        return this._propertyGroupContexts;
    }

    public void setPropertyGroups(List propertyGroups) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPropertyGroups", new Object[]{propertyGroups, this});
        }
        this._propertyGroupContexts = propertyGroups;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPropertyGroups");
        }
    }

    public String getContextGroup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextGroup", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextGroup", this._contextGroup);
        }
        return this._contextGroup;
    }

    public int getType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType", new Integer(this._type));
        }
        return this._type;
    }

    public Serializable getActivitySpecificData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActivitySpecificData", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivitySpecificData", this._activitySpecificData);
        }
        return this._activitySpecificData;
    }

    public void setCoordinator(CoordinatorProxy coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCoordinator", new Object[]{coordinator, this});
        }
        this._coordinator = coordinator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCoordinator");
        }
    }

    public CoordinatorProxy getCoordinator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoordinator", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoordinator", this._coordinator);
        }
        return this._coordinator;
    }

    public String viewDescriptorAsString() {
        return this.viewDescriptorAsString(0);
    }

    private String viewDescriptorAsString(int count) {
        StringBuffer result = new StringBuffer();
        String pad = "    ";
        for (int i = 0; i <= count; ++i) {
            pad = pad + "    ";
        }
        result.append("\n");
        result.append(pad + "Identifier:     " + this.getId() + "\n");
        result.append(pad + "Timeout:        " + this.getTimeout() + "\n");
        result.append(pad + "Service Name:   " + this.getServiceName() + "\n");
        if (this._propertyGroupContexts != null) {
            result.append(pad + "PropertyGroups:   " + "\n");
            Iterator iterator = this._propertyGroupContexts.iterator();
            while (iterator.hasNext()) {
                result.append(pad + "    " + iterator.next());
            }
        }
        if (this._child != null) {
            result.append(pad + "Child Context:" + this._child.viewDescriptorAsString(count + 1));
        }
        if (count == 0) {
            result.append("\n");
        }
        return result.toString();
    }

    public void updatePropertyGroups(boolean outboundRequest) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updatePropertyGroups", new Object[]{outboundRequest, this});
        }
        Iterator iterator = this._context.getPropertyGroupNames();
        this._propertyGroupContexts = new ArrayList();
        while (iterator.hasNext()) {
            String propertyGroupName = (String)iterator.next();
            PropertyGroup propertyGroup = this._context.getPropertyGroup(propertyGroupName);
            PropertyGroupInfo propertyGroupInfo = this._context.getPropertyGroupInfo(propertyGroupName);
            PropertyGroupManager propertyGroupManager = propertyGroupInfo._manager;
            PropertyGroupContext propertyGroupContext = null;
            if (outboundRequest) {
                propertyGroupContext = propertyGroupManager.marshalRequest(propertyGroup);
            } else if (propertyGroupInfo._marshalResponse) {
                propertyGroupContext = propertyGroupManager.marshalResponse(propertyGroup);
            }
            if (propertyGroupContext == null) continue;
            this._propertyGroupContexts.add(propertyGroupContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updatePropertyGroups");
        }
    }

    public static void outputDescriptorHierarchy(List descriptors) {
        if (tc.isDebugEnabled()) {
            Iterator iterator = descriptors.iterator();
            String str = null;
            while (iterator.hasNext()) {
                str = ((ActivityContextDescriptor)iterator.next()).viewDescriptorAsString();
                Tr.debug(tc, "Activity context hierarchy: " + str);
            }
        }
    }

    public abstract ServiceInformation getServiceInformation();

    public boolean equals(Object other) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Object[]{other, this});
        }
        boolean equal = false;
        if (other == this) {
            equal = true;
        } else if (other instanceof ActivityContextDescriptor) {
            ActivityContextDescriptor otherDescriptor = (ActivityContextDescriptor)other;
            equal = this._id.equals(otherDescriptor._id);
            if (equal) {
                equal = this._child == null ? otherDescriptor._child == null : this._child.equals(otherDescriptor._child);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals", equal);
        }
        return equal;
    }

    public int hashCode() {
        int hashCode = this._id.hashCode();
        if (this._child != null) {
            hashCode += this._child.hashCode();
        }
        return hashCode;
    }

    public boolean representsAllAncestorNodes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "representsAllAncestorNodes", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "representsAllAncestorNodes", this._representsAllAncestorNodes);
        }
        return this._representsAllAncestorNodes;
    }
}

