/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity;

import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.activity.HLSLiteDataInterface;
import com.ibm.ws.activity.HLSLiteExtended;
import com.ibm.ws.activity.HLSLiteInfo;
import com.ibm.ws.activity.ServiceMigration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityManager;
import com.ibm.ws.javax.activity.ActivityToken;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.activity.InvalidParentContextException;
import com.ibm.ws.javax.activity.ServiceNotRegisteredException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.util.WSThreadLocal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosActivity.ActivityIdentity;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class ActivityService {
    private static final TraceComponent tc = Tr.register(ActivityService.class, "ActivityService", "com.ibm.ws.activity.resources.activityMessages");
    private static ORB _orb = null;
    private static ActivityService _instance = null;
    private static boolean _serverProcess = true;
    private static ActivityManager _activityManager = null;
    private static WSThreadLocal _suspendHLSLite = new WSThreadLocal();
    private static Map _hlsLiteMap = new HashMap();
    private static List _hlsLiteResetList = new ArrayList();
    private static HLSLiteInfo _hlsLiteRequestService = null;
    public static boolean _HLSLiteExtendedEnabled = false;
    private static List _HLSs = new ArrayList();
    private static boolean _initialized = false;
    private static final int STRING_TO_REF_RETRIES = 20;
    private static ServiceMigration _migrationClass = null;
    private static boolean _50Interop = false;

    private ActivityService() {
    }

    protected static void init(ORB orb) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "init", orb);
            }
            _orb = orb;
            _initialized = true;
            try {
                _activityManager = (ActivityManager)Class.forName("com.ibm.ws.activity.WebSphereActivityContextManagerImpl").newInstance();
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "activity manager created", _activityManager);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.activity.ActivityService.init", "75");
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Exception caught attempting to create ActivityManager", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    protected static void init(boolean isServerProcess) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", isServerProcess);
        }
        _serverProcess = isServerProcess;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public static synchronized ActivityService instance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instance");
        }
        if (_instance == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Creating ActivityService instance");
            }
            _instance = new ActivityService();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instance");
        }
        return _instance;
    }

    public static org.omg.CORBA.ORB getORB() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getORB");
        }
        if (_orb == null && tc.isEventEnabled()) {
            Tr.event(tc, "Activity Service being called before it is initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getORB", _orb);
        }
        return _orb;
    }

    public boolean isServerProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerProcess", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerProcess", _serverProcess);
        }
        return _serverProcess;
    }

    public static boolean isInitialized() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInitialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInitialized", _initialized);
        }
        return _initialized;
    }

    public static void registerLiteService(String serviceName, HLSLiteDataInterface dataInterface) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerLiteService", new java.lang.Object[]{serviceName, dataInterface});
        }
        if (dataInterface == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Null dataInterface provided. Throwing SystemException.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerLiteService", "SystemException");
            }
            throw new SystemException();
        }
        if (serviceName == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Null serviceName provided. Throwing SystemException.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerLiteService", "SystemException");
            }
            throw new SystemException();
        }
        if (_HLSs.contains(serviceName)) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Service " + serviceName + " already registered as full HLS. Throwing SystemeException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerLiteService", "SystemException");
            }
            throw new SystemException();
        }
        try {
            HLSLiteInfo info = new HLSLiteInfo(serviceName, dataInterface);
            _hlsLiteMap.put(serviceName, info);
            if (dataInterface instanceof HLSLiteExtended && _hlsLiteRequestService == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registering as an extended lite service");
                }
                _hlsLiteRequestService = info;
                _HLSLiteExtendedEnabled = true;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registering as a standard lite service");
                }
                _hlsLiteResetList.add(info);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.activity.ActivityService.registerLiteService", "315");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught. Throwing SystemException", e);
            }
            java.lang.Object[] parms = new java.lang.Object[]{"registerLiteService", "com.ibm.ws.activity.ActivityService", e};
            Tr.error(tc, "ERR_UNEXP_EXCPN", parms);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerLiteService", "SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerLiteService");
        }
    }

    public static boolean isLiteService(String serviceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isLiteService", serviceName);
        }
        boolean result = false;
        HLSLiteInfo info = (HLSLiteInfo)_hlsLiteMap.get(serviceName);
        if (info != null && info.isEnabled()) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isLiteService", result);
        }
        return result;
    }

    public static List getLiteData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLiteData");
        }
        ArrayList<ActivityIdentity> liteData = new ArrayList<ActivityIdentity>();
        if (null == _suspendHLSLite.get()) {
            for (HLSLiteInfo info : _hlsLiteMap.values()) {
                ActivityIdentity ai = info.getActivityIdentity();
                if (ai == null) continue;
                liteData.add(ai);
            }
        }
        int listSize = liteData.size();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LiteData size = " + listSize);
        }
        if (listSize == 0) {
            liteData = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLiteData", liteData);
        }
        return liteData;
    }

    public static HLSLiteDataInterface getHLS(String serviceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHLS", serviceName);
        }
        HLSLiteDataInterface hls = null;
        HLSLiteInfo info = (HLSLiteInfo)_hlsLiteMap.get(serviceName);
        if (info != null) {
            hls = info._dataInterface;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHLS", hls);
        }
        return hls;
    }

    public static void setLiteData(String serviceName, ActivityIdentity ai, ServerRequestInfo reqinfo) {
        HLSLiteInfo info;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLiteData", new java.lang.Object[]{serviceName, ai, reqinfo});
        }
        if ((info = (HLSLiteInfo)_hlsLiteMap.get(serviceName)) != null) {
            info.setActivityIdentity(ai, reqinfo);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No info object found for service " + serviceName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLiteData");
        }
    }

    public void resetLiteData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetLiteData", this);
        }
        for (HLSLiteInfo info : _hlsLiteResetList) {
            if (!info.isEnabled()) continue;
            info.requestComplete();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetLiteData");
        }
    }

    public static void inboundRequest(ServerRequestInfo reqinfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inboundRequest", reqinfo);
        }
        if (_hlsLiteRequestService != null && _hlsLiteRequestService.isEnabled()) {
            Object target = ((ExtendedServerRequestInfo)reqinfo).getTarget();
            String method2 = reqinfo.operation();
            ActivityService._hlsLiteRequestService._extInterface.inboundRequest(target, method2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inboundRequest");
        }
    }

    public static void requestComplete(ServerRequestInfo reqinfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestComplete", reqinfo);
        }
        if (_hlsLiteRequestService != null && _hlsLiteRequestService.isEnabled()) {
            Object target = ((ExtendedServerRequestInfo)reqinfo).getTarget();
            String method2 = reqinfo.operation();
            ActivityService._hlsLiteRequestService._extInterface.requestComplete(target, method2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestComplete");
        }
    }

    public static void disableLiteService(String serviceName) throws ServiceNotRegisteredException {
        HLSLiteInfo info;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableLiteService", serviceName);
        }
        if ((info = (HLSLiteInfo)_hlsLiteMap.get(serviceName)) != null) {
            info.disable();
            if (info == _hlsLiteRequestService) {
                _HLSLiteExtendedEnabled = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Disabling the extended lite service");
                }
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Service " + serviceName + "not found in map. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "disableLiteService", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableLiteService");
        }
    }

    public static void enableLiteService(String serviceName) throws ServiceNotRegisteredException {
        HLSLiteInfo info;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enableLiteService", serviceName);
        }
        if ((info = (HLSLiteInfo)_hlsLiteMap.get(serviceName)) != null) {
            info.enable();
            if (info == _hlsLiteRequestService) {
                _HLSLiteExtendedEnabled = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Enabling the extended lite service");
                }
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Service " + serviceName + "not found in map. Throwing ServiceNotRegisteredException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "enableLiteService", "ServiceNotRegisteredException");
            }
            throw new ServiceNotRegisteredException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enableLiteService");
        }
    }

    public static final byte[] object_to_bytes(Object obj) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "object_to_bytes", obj);
        }
        byte[] result = null;
        try {
            boolean disconnect = false;
            try {
                ((ObjectImpl)obj)._orb();
            }
            catch (Exception e) {
                disconnect = true;
            }
            String objRefStr = _orb.object_to_string(obj);
            if (disconnect) {
                _orb.disconnect(obj);
            }
            result = Util.byteArray((String)objRefStr);
        }
        catch (Throwable exc) {
            FFDCFilter.processException(exc, "com.ibm.ws.activity.ActivityService.object_to_bytes", "643");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "object_to_bytes", Util.toHexString(result));
        }
        return result;
    }

    public static final Object bytes_to_object(byte[] ref) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bytes_to_object", ref);
        }
        String refStr = Util.toString((byte[])ref);
        Object obj = null;
        int retries = 20;
        boolean discard = false;
        while (obj == null && retries-- > 0 && !discard) {
            try {
                obj = _orb.string_to_object(refStr);
            }
            catch (MARSHAL exc) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught MARSHAL exception. Sleeping for 2 sec and retrying", (java.lang.Object)exc);
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex2) {
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "Sleep interrupted", ex2);
                }
            }
            catch (Throwable exc) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Invalid object reference. Discarding.");
                }
                discard = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bytes_to_object", obj);
        }
        return obj;
    }

    public static void set50CoordInterop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "set50CoordInterop");
        }
        _50Interop = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "set50CoordInterop");
        }
    }

    public static boolean is50Interop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is50Interop");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is50Interop", _50Interop);
        }
        return _50Interop;
    }

    public static ServiceMigration getMigrationClass() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMigrationClass");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMigrationClass", _migrationClass);
        }
        return _migrationClass;
    }

    public static ActivityToken suspendAll() throws SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendAll");
        }
        ActivityToken token = null;
        if (_activityManager != null) {
            token = _activityManager.suspendAll();
            _suspendHLSLite.set(Boolean.TRUE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendAll", token);
        }
        return token;
    }

    public static void resumeAll(ActivityToken activityToken) throws InvalidActivityException, InvalidParentContextException, SystemException, ServiceNotRegisteredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeAll", activityToken);
        }
        if (_activityManager != null) {
            _suspendHLSLite.set(null);
            _activityManager.resumeAll(activityToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeAll");
        }
    }
}

