/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.EnvironmentType;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class TransactionManagerFactory {
    private static final TraceComponent tc = Tr.register(TransactionManagerFactory.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static WebSphereTransactionManager _tranManager;
    private static LocalTransactionCurrent _localTranCurrent;
    static boolean inWAS;
    static TransactionManagerFactory _instance;

    private TransactionManagerFactory() {
    }

    public static WebSphereTransactionManager getTransactionManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTransactionManager", _tranManager);
        }
        return _tranManager;
    }

    private static void loadTranManager() {
        String tmClass;
        if (inWAS) {
            if (EnvironmentType.getEnvironmentType() == 0) {
                tmClass = "com.ibm.ws.tx.jta.TranManagerSet";
                try {
                    TransactionManagerFactory.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Class<?> clazz = Class.forName(tmClass);
                            Method m = clazz.getMethod("anInstance", null);
                            _tranManager = (WebSphereTransactionManager)m.invoke(null, (Object[])null);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.Transaction.TransactionManagerFactory.loadTranManager", "135");
                }
            } else {
                tmClass = "com.ibm.ws.Transaction.client.NonRecoverableTranManagerSet";
                try {
                    TransactionManagerFactory.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Class<?> clazz = Class.forName(tmClass);
                            Method m = clazz.getMethod("instance", null);
                            _tranManager = (WebSphereTransactionManager)m.invoke(null, (Object[])null);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.Transaction.TransactionManagerFactory.loadTranManager", "162");
                }
            }
        } else {
            tmClass = "com.ibm.ws.Transaction.JTA.TranManagerSet";
            try {
                TransactionManagerFactory.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        _tranManager = (WebSphereTransactionManager)Class.forName(tmClass).newInstance();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException(e, "com.ibm.ws.Transaction.TransactionManagerFactory.loadTranManager", "190");
            }
        }
        if (_tranManager == null) {
            NoClassDefFoundError ncdfe = new NoClassDefFoundError(tmClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTransactionManager", ncdfe);
            }
            throw ncdfe;
        }
    }

    public static LocalTransactionCurrent getLocalTransactionCurrent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit(tc, "getLocalTransactionCurrent", _localTranCurrent);
        }
        return _localTranCurrent;
    }

    private static void loadLTCCurrent() {
        if (EnvironmentType.getEnvironmentType() != 0) {
            return;
        }
        final String tmClass = "com.ibm.ws.LocalTransaction.LocalTranCurrentSet";
        try {
            TransactionManagerFactory.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        Class<?> clazz = Class.forName(tmClass);
                        Method m = clazz.getMethod("instance", null);
                        _localTranCurrent = (LocalTransactionCurrent)m.invoke(null, (Object[])null);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException(t, "com.ibm.ws.Transaction.TransactionManagerFactory.run", "126", this);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException(e, "com.ibm.ws.Transaction.TransactionManagerFactory.getTransactionManager", "135");
        }
        if (_localTranCurrent == null) {
            NoClassDefFoundError ncdfe = new NoClassDefFoundError(tmClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "loadLTCCurrent", ncdfe);
            }
            throw ncdfe;
        }
    }

    public static UOWCurrent getUOWCurrent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getUOWCurrent", _tranManager);
        }
        return (UOWCurrent)((Object)_tranManager);
    }

    public static Object doPrivileged(PrivilegedExceptionAction action) throws PrivilegedActionException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            try {
                return action.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return AccessController.doPrivileged(action);
    }

    static {
        try {
            Class.forName("com.ibm.ws.tx.jta.TranManagerSet");
            inWAS = true;
        }
        catch (Throwable t) {
            try {
                Class.forName("com.ibm.ws.Transaction.client.NonRecoverableTranManagerSet");
                inWAS = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        TransactionManagerFactory.loadTranManager();
        TransactionManagerFactory.loadLTCCurrent();
    }
}

