/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import org.omg.CosTransactions.Status;

public final class TxStatusHelper {
    private static final TraceComponent tc = Tr.register(TxStatusHelper.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public static final Status getCORBAStatus(int javaxStatus) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCORBAStatus", TxStatusHelper.getJavaxStatusAsString(javaxStatus));
        }
        Status corbaStatus = null;
        switch (javaxStatus) {
            case 0: {
                corbaStatus = Status.StatusActive;
                break;
            }
            case 3: {
                corbaStatus = Status.StatusCommitted;
                break;
            }
            case 8: {
                corbaStatus = Status.StatusCommitting;
                break;
            }
            case 1: {
                corbaStatus = Status.StatusMarkedRollback;
                break;
            }
            case 6: {
                corbaStatus = Status.StatusNoTransaction;
                break;
            }
            case 2: {
                corbaStatus = Status.StatusPrepared;
                break;
            }
            case 7: {
                corbaStatus = Status.StatusPreparing;
                break;
            }
            case 4: {
                corbaStatus = Status.StatusRolledBack;
                break;
            }
            case 9: {
                corbaStatus = Status.StatusRollingBack;
                break;
            }
            default: {
                corbaStatus = Status.StatusUnknown;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCORBAStatus", TxStatusHelper.getCORBAStatusAsString(corbaStatus));
        }
        return corbaStatus;
    }

    public static final int getJavaxStatus(Status corbaStatus) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getJavaxStatus", TxStatusHelper.getCORBAStatusAsString(corbaStatus));
        }
        int status = corbaStatus.value();
        int javaxStatus = 5;
        switch (status) {
            case 0: {
                javaxStatus = 0;
                break;
            }
            case 3: {
                javaxStatus = 3;
                break;
            }
            case 8: {
                javaxStatus = 8;
                break;
            }
            case 1: {
                javaxStatus = 1;
                break;
            }
            case 6: {
                javaxStatus = 6;
                break;
            }
            case 2: {
                javaxStatus = 2;
                break;
            }
            case 7: {
                javaxStatus = 7;
                break;
            }
            case 4: {
                javaxStatus = 4;
                break;
            }
            case 9: {
                javaxStatus = 9;
                break;
            }
            default: {
                javaxStatus = 5;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getJavaxStatus", TxStatusHelper.getJavaxStatusAsString(javaxStatus));
        }
        return javaxStatus;
    }

    public static final String getJavaxStatusAsString(int javaxStatus) {
        String status = null;
        switch (javaxStatus) {
            case 0: {
                status = "active";
                break;
            }
            case 3: {
                status = "committed";
                break;
            }
            case 8: {
                status = "committing";
                break;
            }
            case 1: {
                status = "marked rollback";
                break;
            }
            case 6: {
                status = "no transaction";
                break;
            }
            case 2: {
                status = "prepared";
                break;
            }
            case 7: {
                status = "preparing";
                break;
            }
            case 4: {
                status = "rolledback";
                break;
            }
            case 9: {
                status = "rolling back";
                break;
            }
            default: {
                status = "unknown";
            }
        }
        return status;
    }

    public static final String getCORBAStatusAsString(Status corbaStatus) {
        String status = null;
        switch (corbaStatus.value()) {
            case 0: {
                status = "active";
                break;
            }
            case 3: {
                status = "committed";
                break;
            }
            case 8: {
                status = "committing";
                break;
            }
            case 1: {
                status = "marked rollback";
                break;
            }
            case 6: {
                status = "no transaction";
                break;
            }
            case 2: {
                status = "prepared";
                break;
            }
            case 7: {
                status = "preparing";
                break;
            }
            case 4: {
                status = "rolledback";
                break;
            }
            case 9: {
                status = "rolling back";
                break;
            }
            default: {
                status = "unknown";
            }
        }
        return status;
    }
}

