/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.xml;

import com.ibm.websphere.product.utils.WASProductParserFactory;
import com.ibm.websphere.product.xml.BaseEntityResolver;
import com.ibm.websphere.product.xml.BaseErrorHandler;
import com.ibm.websphere.product.xml.BaseHandler;
import com.ibm.websphere.product.xml.BaseHandlerException;
import com.ibm.websphere.product.xml.BaseWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class BaseFactory {
    public static final String pgmVersion = "1.14";
    public static final String pgmUpdate = "8/8/08";
    protected BaseHandler handler;
    protected BaseWriter writer;
    public static final String NAMESPACES_FEATURE_NAME = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATE_FEATURE_NAME = "http://xml.org/sax/features/validation";
    public static final String LOAD_EXTERNAL_DTD_FEATURE_NAME = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String VALIDATING_PROPERTY_NAME = "was.version.validate";
    public static final String VALIDATING_PROPERTY_TRUE_VALUE = "true";
    public static final String VALIDATING_PROPERTY_FALSE_VALUE = "false";
    protected BaseHandlerException boundException;
    protected Vector recoverableErrors;
    protected Vector warnings;
    private boolean m_fIsForOS390 = System.getProperty("os.name").equals("OS/390") || System.getProperty("os.name").equals("z/OS");

    public BaseFactory(BaseHandler handler, BaseWriter writer) {
        this.handler = handler;
        this.writer = writer;
        this.boundException = null;
        this.recoverableErrors = new Vector();
        this.warnings = new Vector();
    }

    public BaseHandler getHandler() {
        return this.handler;
    }

    public BaseWriter getWriter() {
        return this.writer;
    }

    public static BaseHandlerException saveSingleton(Object rootElement, BaseWriter writer, String filename) {
        ArrayList<Object> roots = new ArrayList<Object>();
        roots.add(rootElement);
        BaseFactory factory = new BaseFactory(null, writer);
        if (!factory.save(filename, roots)) {
            return factory.getException();
        }
        return null;
    }

    public boolean save(String filename, List rootElements) {
        this.getWriter().emit(rootElements, filename);
        Exception writerException = this.writer.getBoundException();
        if (writerException != null) {
            this.setException("WVER0107E", new Object[]{filename}, writerException);
            return false;
        }
        return true;
    }

    public static Object loadSingleton(BaseHandler handler, String dtdDirName, String dirName, String fileName) throws BaseHandlerException, FileNotFoundException {
        BaseFactory factory = new BaseFactory(handler, null);
        List rootElements = factory.load(dtdDirName, dirName, fileName);
        BaseHandlerException handlerException = factory.getException();
        if (handlerException != null) {
            throw handlerException;
        }
        Iterator roots = rootElements.iterator();
        if (roots.hasNext()) {
            return roots.next();
        }
        return null;
    }

    public static Object loadSingleton(BaseHandler handler, String dtdDirName, InputSource inputSource, String sourceName) throws BaseHandlerException {
        BaseFactory factory = new BaseFactory(handler, null);
        List rootElements = factory.load(dtdDirName, inputSource, sourceName);
        BaseHandlerException handlerException = factory.getException();
        if (handlerException != null) {
            throw handlerException;
        }
        Iterator roots = rootElements.iterator();
        if (roots.hasNext()) {
            return roots.next();
        }
        return null;
    }

    public List load(String dtdDirName, String dirName, String fileName) throws FileNotFoundException {
        InputSource inputSource = this.openSource(dirName, fileName);
        return this.load(dtdDirName, inputSource, fileName);
    }

    public List load(String dtdDirName, InputSource inputSource, String sourceName) {
        XMLReader reader;
        try {
            reader = this.createReader(dtdDirName);
        }
        catch (SAXException e) {
            this.setException("WVER0101E", new Object[]{dtdDirName, sourceName}, e);
            return null;
        }
        try {
            reader.parse(inputSource);
        }
        catch (SAXParseException e) {
            e.printStackTrace(System.out);
            this.setException("WVER0102E", new Object[]{dtdDirName, sourceName, e.getSystemId(), e.getPublicId(), new Integer(e.getLineNumber()), new Integer(e.getColumnNumber())}, e);
            return null;
        }
        catch (Throwable th) {
            th.printStackTrace(System.out);
            this.setException("WVER0101E", new Object[]{dtdDirName, sourceName});
            return null;
        }
        return (List)this.getHandler().getObject();
    }

    protected XMLReader createReader(String dtdDirName) throws SAXException, SAXNotRecognizedException {
        boolean validating = this.isValidating();
        XMLReader reader = null;
        try {
            reader = WASProductParserFactory.createXMLReader();
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce);
        }
        reader.setFeature(NAMESPACES_FEATURE_NAME, true);
        reader.setFeature(VALIDATE_FEATURE_NAME, validating);
        reader.setEntityResolver(this.createEntityResolver(dtdDirName));
        reader.setContentHandler(this.getHandler());
        reader.setErrorHandler(this.createErrorHandler());
        return reader;
    }

    protected EntityResolver createEntityResolver(String dtdDir) {
        return new BaseEntityResolver(this, dtdDir);
    }

    protected ErrorHandler createErrorHandler() {
        return new BaseErrorHandler(this);
    }

    protected InputSource openSource(String dirName, String fileName) throws FileNotFoundException {
        File inputFile = new File(dirName, fileName);
        InputSource inputSource = null;
        FileInputStream inputStream = null;
        if (this.m_fIsForOS390) {
            String inputFilePath = inputFile.getAbsolutePath();
            inputSource = new InputSource(inputFilePath);
        } else {
            String uri = "file:" + inputFile.getAbsolutePath().replace('\\', '/');
            inputStream = new FileInputStream(inputFile);
            inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uri);
        }
        return inputSource;
    }

    protected boolean isValidating() {
        String validatingValue = System.getProperty(VALIDATING_PROPERTY_NAME);
        return validatingValue == null || !validatingValue.equalsIgnoreCase(VALIDATING_PROPERTY_FALSE_VALUE);
    }

    protected void setException(BaseHandlerException e) {
        this.boundException = e;
    }

    public BaseHandlerException getException() {
        return this.boundException;
    }

    protected void clearException() {
        this.boundException = null;
    }

    protected void setException(String msgKey) {
        this.setException(this.createException(msgKey, null, null));
    }

    protected void setException(String msgKey, Exception e) {
        this.setException(this.createException(msgKey, null, e));
    }

    protected void setException(String msgKey, Object[] msgArgs) {
        this.setException(this.createException(msgKey, msgArgs, null));
    }

    protected void setException(String msgKey, Object[] msgArgs, Exception e) {
        this.setException(this.createException(msgKey, msgArgs, e));
    }

    protected BaseHandlerException createException(String msgKey, Object[] msgArgs, Exception e) {
        return new BaseHandlerException(msgKey, msgArgs, e);
    }

    public Iterator getRecoverableErrors() {
        return this.recoverableErrors.iterator();
    }

    protected void addRecoverableError(SAXException e) {
        this.recoverableErrors.add(e);
    }

    public void clearRecoverableErrors() {
        this.recoverableErrors = new Vector();
    }

    public Iterator getWarnings() {
        return this.warnings.iterator();
    }

    protected void addWarning(SAXException e) {
        this.warnings.add(e);
    }

    public void clearWarnings() {
        this.warnings = new Vector();
    }
}

