/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.logger;

import com.ibm.websphere.product.utils.WASDirectoryHelper;
import com.ibm.websphere.product.utils.WASPlatformConstants;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class WASDirectoryLogger {
    private static final String S_WASDIRECTORY_TRACE_FILE_NAME = "wasdirectory.trace";
    public static final String S_TRACE_FILE_EXT = ".txt";
    public static final String S_TRACE_LOCK_FILE_EXT = ".lck";
    public static final Level DEFAULT_TRACE_LEVEL = Level.OFF;
    private static HashMap loggerMap = new HashMap();
    private Logger LOGGER;
    private boolean isLoggerInitProperly = false;
    private static final String WASDIRECTORY_LOGGER_TRACE_LEVEL = "wasdirectory.logger.level";
    private static final String LEVEL_ALL = "all";
    private static final String LEVEL_CONFIG = "config";
    private static final String LEVEL_FINE = "fine";
    private static final String LEVEL_FINER = "finer";
    private static final String LEVEL_FINEST = "finest";
    private static final String LEVEL_INFO = "info";
    private static final String LEVEL_OFF = "off";
    private static final String LEVEL_SEVERE = "severe";
    private static final String LEVEL_WARNING = "warning";

    public static WASDirectoryLogger getWASDirectoryLogger(String installRoot) {
        return WASDirectoryLogger.getWASDirectoryLogger(installRoot, DEFAULT_TRACE_LEVEL);
    }

    public static WASDirectoryLogger getWASDirectoryLogger(String installRoot, Level traceLevel) {
        WASDirectoryLogger wasDirectoryLogger;
        installRoot = WASDirectoryHelper.normalizeLocationAccordingToPlatform(installRoot, false);
        if (WASPlatformConstants.isCurrentPlatformWindows()) {
            installRoot = installRoot.toLowerCase();
        }
        if ((wasDirectoryLogger = (WASDirectoryLogger)loggerMap.get(installRoot)) == null) {
            wasDirectoryLogger = new WASDirectoryLogger(installRoot, traceLevel);
            loggerMap.put(installRoot, wasDirectoryLogger);
        }
        return wasDirectoryLogger;
    }

    public void logThisMessage(Level traceLevel, String sourceClass, String sourceMethod, String message) {
        if (!this.isLoggerInitProperly) {
            return;
        }
        try {
            this.LOGGER.logp(traceLevel, sourceClass, sourceMethod, message);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void logThisException(Level traceLevel, String sourceClass, String sourceMethod, String message, Throwable throwable) {
        if (!this.isLoggerInitProperly) {
            return;
        }
        try {
            this.LOGGER.logp(traceLevel, sourceClass, sourceMethod, message);
            this.LOGGER.logp(traceLevel, sourceClass, sourceMethod, this.getStackTrace(throwable));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void entering(String sSourceClass, String sSourceMethod) {
        if (!this.isLoggerInitProperly) {
            return;
        }
        try {
            this.LOGGER.entering(sSourceClass, sSourceMethod);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exiting(String sSourceClass, String sSourceMethod) {
        if (!this.isLoggerInitProperly) {
            return;
        }
        try {
            this.LOGGER.exiting(sSourceClass, sSourceMethod);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected WASDirectoryLogger(String installRoot, Level traceLevel) {
        this.LOGGER = this.createLogger(installRoot, traceLevel);
        if (this.LOGGER != null) {
            this.isLoggerInitProperly = true;
            this.LOGGER.info("Logger for install root: " + installRoot + ", is initialized successfully.");
        }
    }

    protected Logger createLogger(String installRoot, Level traceLevel) {
        if (!new File(installRoot).exists() || !WASDirectoryHelper.isThisPathWritable(new File(WASDirectoryHelper.getVersionDirPath(installRoot)))) {
            return null;
        }
        return this.initLogger(installRoot, traceLevel);
    }

    protected Logger initLogger(String installRoot, Level traceLevel) {
        block7: {
            Logger LOGGER = null;
            if ((traceLevel = this.setLoggerTraceLevel(traceLevel)) == Level.OFF) {
                return null;
            }
            try {
                LOGGER = Logger.getAnonymousLogger();
                LOGGER.setUseParentHandlers(false);
                LOGGER.setLevel(traceLevel);
                if (installRoot != null) {
                    Date dateCurrentDate = new Date(System.currentTimeMillis());
                    String sTime = new SimpleDateFormat("_yyyy.MM.dd_HH.mm.ss.SSS_").format(dateCurrentDate);
                    File traceFile = File.createTempFile(S_WASDIRECTORY_TRACE_FILE_NAME + sTime, S_TRACE_FILE_EXT, new File(WASDirectoryHelper.getVersionDirPath(installRoot)));
                    FileHandler handlerFileHandler = new FileHandler(traceFile.getAbsolutePath());
                    handlerFileHandler.setFormatter(new SimpleFormatter());
                    handlerFileHandler.setLevel(traceLevel);
                    LOGGER.addHandler(handlerFileHandler);
                }
                return LOGGER;
            }
            catch (IOException ioe) {
                if (LOGGER == null) break block7;
                Handler[] handlers = LOGGER.getHandlers();
                for (int i = 0; i < handlers.length; ++i) {
                    if (!(handlers[i] instanceof FileHandler)) continue;
                    handlers[i].close();
                }
            }
            catch (SecurityException se) {
                if (LOGGER == null) break block7;
                Handler[] handlers = LOGGER.getHandlers();
                for (int i = 0; i < handlers.length; ++i) {
                    if (!(handlers[i] instanceof FileHandler)) continue;
                    handlers[i].close();
                }
            }
        }
        return null;
    }

    protected void cleanupTraceFile(String versionDirPath) {
        File[] traceFiles = new File(versionDirPath).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(WASDirectoryLogger.S_WASDIRECTORY_TRACE_FILE_NAME) && (name.endsWith(WASDirectoryLogger.S_TRACE_FILE_EXT) || name.endsWith(WASDirectoryLogger.S_TRACE_LOCK_FILE_EXT));
            }
        });
        if (traceFiles != null) {
            for (int i = 0; i < traceFiles.length; ++i) {
                traceFiles[i].delete();
            }
        }
    }

    protected Level setLoggerTraceLevel(Level traceLevel) {
        String specifiedLevel = System.getProperty(WASDIRECTORY_LOGGER_TRACE_LEVEL);
        if (specifiedLevel == null) {
            return traceLevel;
        }
        if (LEVEL_ALL.equals(specifiedLevel)) {
            return Level.ALL;
        }
        if (LEVEL_CONFIG.equals(specifiedLevel)) {
            return Level.CONFIG;
        }
        if (LEVEL_FINE.equals(specifiedLevel)) {
            return Level.FINE;
        }
        if (LEVEL_FINER.equals(specifiedLevel)) {
            return Level.FINER;
        }
        if (LEVEL_FINEST.equals(specifiedLevel)) {
            return Level.FINEST;
        }
        if (LEVEL_INFO.equals(specifiedLevel)) {
            return Level.INFO;
        }
        if (LEVEL_OFF.equals(specifiedLevel)) {
            return Level.OFF;
        }
        if (LEVEL_SEVERE.equals(specifiedLevel)) {
            return Level.SEVERE;
        }
        if (LEVEL_WARNING.equals(specifiedLevel)) {
            return Level.WARNING;
        }
        return traceLevel;
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringwriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringwriter));
        return stringwriter.toString();
    }
}

