/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.utils.WASDirectoryHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WASSystem {
    public static final int N_UNKNOWN = 0;
    public static final int N_AIX = 1;
    public static final int N_HPUX = 2;
    public static final int N_SOLARIS = 3;
    public static final int N_LINUX = 4;
    public static final int N_WINDOWS = 5;
    public static final int N_Z_OS = 6;
    public static final int N_OS400 = 7;
    private String m_sWASRegistryFile = null;
    private static WASSystem instance = null;
    private String m_sNIFRegistryFile = null;
    private Set m_setAllFileLocations = new HashSet();
    private Vector m_vAllLocations = new Vector();
    private String[] m_saAllLocations = null;
    private Vector m_vWasLocations = new Vector();
    private String[] m_saWasLocations = null;
    private Vector m_vBaseLocations = new Vector();
    private String[] m_saBaseLocations = null;
    private Vector m_vExpressLocations = new Vector();
    private String[] m_saExpressLocations = null;
    private Vector m_vNDLocations = new Vector();
    private String[] m_saNDLocations = null;
    private Vector m_vNDDMZLocations = new Vector();
    private String[] m_saNDDMZLocations = null;
    private Vector m_vEmbeddedExpressLocations = new Vector();
    private String[] m_saEmbeddedExpressLocations = null;
    private Vector m_vWBILocations = new Vector();
    private String[] m_saWBILocations = null;
    private Vector m_vJDKLocations = new Vector();
    private String[] m_saJDKLocations = null;
    private Vector m_vCLTLocations = new Vector();
    private String[] m_saCLTLocations = null;
    private Vector m_vPLGLocations = new Vector();
    private String[] m_saPLGLocations = null;
    private Vector m_vIHSLocations = new Vector();
    private String[] m_saIHSLocations = null;
    private Vector m_vXDLocations = new Vector();
    private String[] m_saXDLocations = null;
    private Vector m_vWXDLocations = new Vector();
    private String[] m_saWXDLocations = null;
    private Vector m_vPMELocations = new Vector();
    private String[] m_saPMELocations = null;
    private static String m_sSystemDriveOnWindows = null;
    private static String m_sSystemRootOnWindows = null;
    private static final String ID_AllProduct = "AllProduct";
    private static final String S_REGISTRY_FILE_NAME = ".WASRegistry";
    private static final String S_USER_HOME = "user.home";
    private static final String S_EMPTY = "";
    private static final String S_RALATIVE_PROPERTIES_VERSION_DIR = File.separator + "properties" + File.separator + "version";
    private static final String S_DOT_PRODUCT = ".product";
    private static final String S_NIFREGISTRY_FILE_NAME = ".nifregistry";
    private static final String S_NIFREGISTRY_PARENT_OS400 = "/QIBM/WAS/.ibm/.nif";
    private static final String S_NIFREGISTRY_RELATIVEPATH = "/.ibm/.nif";
    private static final String S_NIFREGISTRY_PARENT_UNIX_FORROOT = "/opt";
    private static final String S_NIFREGISTRY_PARENT_AIX_FORROOT = "/usr";
    private static final String S_PATH_SEPARATOR = "/";
    private static final String S_JAVA_OS_PROPERTY = "os.name";
    private static final String S_AIX_PATTERN = "^.*aix.*$";
    private static final String S_HPUX_PATTERN = "^.*hp-ux.*$";
    private static final String S_SOLARIS_PATTERN = "^.*sunos.*$";
    private static final String S_LINUX_PATTERN = "^.*linux.*$";
    private static final String S_WINDOWS_PATTERN = "^.*windows.*$";
    private static final String S_Z_OS_PATTERN = "^.*z/os.*$";
    private static final String S_OS400_PATTERN = "^.*os/400.*$";
    private static final String S_NIFREGISTRY_ROOT_PATTERN = "<nifregistry.*";
    private static final String S_PRODUCT_ELEMENT_PATTERN = "\\s*<product.*?installrooturi=\"(.*?)\".*?productid=\"(.*?)\".*?version=.*";
    private static final char S_WINDOWS_FILE_SEPARATOR = '\\';
    public static final String S_URI_PATH_SEPARATOR = "/";
    private static final char S_LINUX_FILE_SEPARATOR = '/';
    private static final String S_DRIVE_A = "A";
    private static final String S_DRIVE_B = "B";
    private static final String S_UTF8_ENCODING = "UTF-8";

    public static WASSystem getWASSystemInstance() {
        if (instance == null) {
            instance = new WASSystem();
        }
        return instance;
    }

    public static WASSystem getWASSystemInstance(String sRegistryFile) {
        File regFile = new File(sRegistryFile);
        if (!regFile.exists() || regFile.isDirectory()) {
            return null;
        }
        if (instance == null) {
            instance = new WASSystem(sRegistryFile);
        }
        return instance;
    }

    public String getNIFRegistryFile() {
        return this.m_sNIFRegistryFile;
    }

    public void setNIFRegistryFile(String sNIFRegistryFile) {
        this.m_sNIFRegistryFile = sNIFRegistryFile;
    }

    public String getWASRegistryFile() {
        return this.m_sWASRegistryFile;
    }

    public void setWASRegistryFile(String sWASRegistryFile) {
        this.m_sWASRegistryFile = sWASRegistryFile;
    }

    public String[] getWASLocations() {
        return this.getInstallPackageLocationsByProductID(null);
    }

    public void setWASLocations(String[] saWASLocations) {
    }

    public String[] getAllInstallPackageLocations() {
        return this.getInstallPackageLocationsByProductID(ID_AllProduct);
    }

    public String[] getInstallPackageLocationsByProductID(String sProductID) {
        if (this.m_saWasLocations == null) {
            return this.getNonCachedInstallPackageLocationsByProductID(sProductID);
        }
        return this.getLocationsByProductID(sProductID);
    }

    public String[] getNonCachedAllInstallPackageLocations() {
        return this.getNonCachedInstallPackageLocationsByProductID(ID_AllProduct);
    }

    public String[] getNonCachedInstallPackageLocationsByProductID(String sProductID) {
        this.clearLocationVectors();
        this.parseNIFRegistry(this.m_sNIFRegistryFile);
        this.parseWASRegistry(this.m_sWASRegistryFile);
        this.convertLocationVectorsToStringArray();
        return this.getLocationsByProductID(sProductID);
    }

    public String[] getNonCachedWASLocations() {
        return this.getNonCachedInstallPackageLocationsByProductID(null);
    }

    public void print() {
        String[] saWASLocations = this.getLocationsByProductID(null);
        for (int i = 0; i < saWASLocations.length; ++i) {
            System.out.println("location[" + i + "]=" + saWASLocations[i]);
        }
    }

    private WASSystem() {
        this.m_sNIFRegistryFile = this.getNIFRegistryPath(S_NIFREGISTRY_FILE_NAME);
        String userDir = System.getProperty(S_USER_HOME);
        this.m_sWASRegistryFile = userDir + File.separator + S_REGISTRY_FILE_NAME;
    }

    private WASSystem(String sRegistryFile) {
        if (!this.isThisRegistryNIFRegistry(sRegistryFile)) {
            this.m_sWASRegistryFile = sRegistryFile;
        } else {
            this.m_sNIFRegistryFile = sRegistryFile;
        }
    }

    private void addInstallPackageLocationsByProductID(String sProductID, File fileInstallLocation) {
        String sLocation = fileInstallLocation.getAbsolutePath();
        if (!this.m_setAllFileLocations.contains(fileInstallLocation)) {
            this.m_setAllFileLocations.add(fileInstallLocation);
            this.m_vAllLocations.add(sLocation);
        }
        if ((sProductID = WASDirectoryHelper.normalizedProductID(sProductID)) == null) {
            this.m_vWasLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("BASE")) {
            this.m_vWasLocations.add(sLocation);
            this.m_vBaseLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("EXPRESS")) {
            this.m_vWasLocations.add(sLocation);
            this.m_vExpressLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("BASETRIAL")) {
            this.m_vWasLocations.add(sLocation);
            this.m_vBaseLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("EXPRESSTRIAL")) {
            this.m_vWasLocations.add(sLocation);
            this.m_vExpressLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("ND")) {
            this.m_vWasLocations.add(sLocation);
            this.m_vNDLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("NDDMZ")) {
            this.m_vWasLocations.add(sLocation);
            this.m_vNDDMZLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("embeddedEXPRESS")) {
            this.m_vWasLocations.add(sLocation);
            this.m_vEmbeddedExpressLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("XD")) {
            this.m_vXDLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("WXD")) {
            this.m_vWXDLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("CLIENT")) {
            this.m_vCLTLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("PLG")) {
            this.m_vPLGLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("IHS")) {
            this.m_vIHSLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("JDK")) {
            this.m_vJDKLocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("PME")) {
            this.m_vPMELocations.add(sLocation);
        } else if (sProductID.equalsIgnoreCase("WBI")) {
            this.m_vWBILocations.add(sLocation);
        }
    }

    private boolean canCurrentUserAccessRootNIFRegistry(String sNIFRegistyFileName) {
        String sNIFRegistryPathForRootUser = this.getNIFRegistryPathForRootUser(sNIFRegistyFileName);
        try {
            File fileNIFRegistryPathForRootUser = new File(sNIFRegistryPathForRootUser);
            return fileNIFRegistryPathForRootUser.canWrite();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void clearLocationVectors() {
        this.m_vAllLocations.clear();
        this.m_vBaseLocations.clear();
        this.m_vCLTLocations.clear();
        this.m_vEmbeddedExpressLocations.clear();
        this.m_vExpressLocations.clear();
        this.m_vIHSLocations.clear();
        this.m_vJDKLocations.clear();
        this.m_vNDLocations.clear();
        this.m_vNDDMZLocations.clear();
        this.m_vPLGLocations.clear();
        this.m_vPMELocations.clear();
        this.m_vWasLocations.clear();
        this.m_vWBILocations.clear();
        this.m_vXDLocations.clear();
    }

    private void convertLocationVectorsToStringArray() {
        int i;
        int nSize = this.m_vAllLocations.size();
        this.m_saAllLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saAllLocations[i] = (String)this.m_vAllLocations.elementAt(i);
        }
        nSize = this.m_vBaseLocations.size();
        this.m_saBaseLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saBaseLocations[i] = (String)this.m_vBaseLocations.elementAt(i);
        }
        nSize = this.m_vCLTLocations.size();
        this.m_saCLTLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saCLTLocations[i] = (String)this.m_vCLTLocations.elementAt(i);
        }
        nSize = this.m_vEmbeddedExpressLocations.size();
        this.m_saEmbeddedExpressLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saEmbeddedExpressLocations[i] = (String)this.m_vEmbeddedExpressLocations.elementAt(i);
        }
        nSize = this.m_vExpressLocations.size();
        this.m_saExpressLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saExpressLocations[i] = (String)this.m_vExpressLocations.elementAt(i);
        }
        nSize = this.m_vIHSLocations.size();
        this.m_saIHSLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saIHSLocations[i] = (String)this.m_vIHSLocations.elementAt(i);
        }
        nSize = this.m_vJDKLocations.size();
        this.m_saJDKLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saJDKLocations[i] = (String)this.m_vJDKLocations.elementAt(i);
        }
        nSize = this.m_vNDLocations.size();
        this.m_saNDLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saNDLocations[i] = (String)this.m_vNDLocations.elementAt(i);
        }
        nSize = this.m_vNDDMZLocations.size();
        this.m_saNDDMZLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saNDDMZLocations[i] = (String)this.m_vNDDMZLocations.elementAt(i);
        }
        nSize = this.m_vPLGLocations.size();
        this.m_saPLGLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saPLGLocations[i] = (String)this.m_vPLGLocations.elementAt(i);
        }
        nSize = this.m_vPMELocations.size();
        this.m_saPMELocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saPMELocations[i] = (String)this.m_vPMELocations.elementAt(i);
        }
        nSize = this.m_vWasLocations.size();
        this.m_saWasLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saWasLocations[i] = (String)this.m_vWasLocations.elementAt(i);
        }
        nSize = this.m_vWBILocations.size();
        this.m_saWBILocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saWBILocations[i] = (String)this.m_vWBILocations.elementAt(i);
        }
        nSize = this.m_vXDLocations.size();
        this.m_saXDLocations = new String[nSize];
        for (i = 0; i < nSize; ++i) {
            this.m_saXDLocations[i] = (String)this.m_vXDLocations.elementAt(i);
        }
    }

    private int getCurrentPlatform() {
        String sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
        if (Pattern.matches(S_AIX_PATTERN, sOSName)) {
            return 1;
        }
        if (Pattern.matches(S_HPUX_PATTERN, sOSName)) {
            return 2;
        }
        if (Pattern.matches(S_SOLARIS_PATTERN, sOSName)) {
            return 3;
        }
        if (Pattern.matches(S_LINUX_PATTERN, sOSName)) {
            return 4;
        }
        if (Pattern.matches(S_WINDOWS_PATTERN, sOSName)) {
            return 5;
        }
        if (Pattern.matches(S_Z_OS_PATTERN, sOSName)) {
            return 6;
        }
        if (Pattern.matches(S_OS400_PATTERN, sOSName)) {
            return 7;
        }
        return 0;
    }

    private String[] getLocationsByProductID(String sProductID) {
        if ((sProductID = WASDirectoryHelper.normalizedProductID(sProductID)) == null) {
            return this.m_saWasLocations;
        }
        if (sProductID.equalsIgnoreCase("BASE")) {
            return this.m_saBaseLocations;
        }
        if (sProductID.equalsIgnoreCase("EXPRESS")) {
            return this.m_saExpressLocations;
        }
        if (sProductID.equalsIgnoreCase("BASETRIAL")) {
            return this.m_saBaseLocations;
        }
        if (sProductID.equalsIgnoreCase("EXPRESSTRIAL")) {
            return this.m_saExpressLocations;
        }
        if (sProductID.equalsIgnoreCase("ND")) {
            return this.m_saNDLocations;
        }
        if (sProductID.equalsIgnoreCase("NDDMZ")) {
            return this.m_saNDDMZLocations;
        }
        if (sProductID.equalsIgnoreCase("embeddedEXPRESS")) {
            return this.m_saEmbeddedExpressLocations;
        }
        if (sProductID.equalsIgnoreCase("CLIENT")) {
            return this.m_saCLTLocations;
        }
        if (sProductID.equalsIgnoreCase("PLG")) {
            return this.m_saPLGLocations;
        }
        if (sProductID.equalsIgnoreCase("IHS")) {
            return this.m_saIHSLocations;
        }
        if (sProductID.equalsIgnoreCase("JDK")) {
            return this.m_saJDKLocations;
        }
        if (sProductID.equalsIgnoreCase("PME")) {
            return this.m_saPMELocations;
        }
        if (sProductID.equalsIgnoreCase("WBI")) {
            return this.m_saWBILocations;
        }
        if (sProductID.equalsIgnoreCase("XD")) {
            return this.m_saXDLocations;
        }
        if (sProductID.equalsIgnoreCase("WXD")) {
            return this.m_saWXDLocations;
        }
        if (sProductID.equalsIgnoreCase(ID_AllProduct)) {
            return this.m_saAllLocations;
        }
        return new String[0];
    }

    private String getNIFRegistryPath(String sNIFRegistyFileName) {
        if (this.getCurrentPlatform() == 7) {
            return "/QIBM/WAS/.ibm/.nif/" + sNIFRegistyFileName;
        }
        if (this.canCurrentUserAccessRootNIFRegistry(sNIFRegistyFileName)) {
            String sNIFRegistryPathForNonRootUser = this.getNIFRegistryPathForNonRootUser(sNIFRegistyFileName);
            try {
                File fileNIFRegistry = new File(sNIFRegistryPathForNonRootUser);
                if (fileNIFRegistry.exists()) {
                    return sNIFRegistryPathForNonRootUser;
                }
                return this.getNIFRegistryPathForRootUser(sNIFRegistyFileName);
            }
            catch (Exception e) {
                return this.getNIFRegistryPathForRootUser(sNIFRegistyFileName);
            }
        }
        return this.getNIFRegistryPathForNonRootUser(sNIFRegistyFileName);
    }

    private String getNIFRegistryPathForNonRootUser(String sNIFRegistyFileName) {
        String sUserHome = this.normalizePath(System.getProperty(S_USER_HOME));
        String sNIFRegistryParent = sUserHome + S_NIFREGISTRY_RELATIVEPATH;
        return sNIFRegistryParent + "/" + sNIFRegistyFileName;
    }

    private String getNIFRegistryPathForRootUser(String sNIFRegistryFileName) {
        String sNIFRegistryParent = null;
        sNIFRegistryParent = this.getCurrentPlatform() == 5 ? this.getSystemRootOnWindows() : (this.getCurrentPlatform() == 1 ? "/usr/.ibm/.nif" : "/opt/.ibm/.nif");
        String sReturn = sNIFRegistryParent + "/" + sNIFRegistryFileName;
        return sReturn;
    }

    private String getFirstAvailableSystemDriveRootDirectory() {
        File[] aFileRoots = File.listRoots();
        String sRootAbsolutePath = null;
        for (int i = 0; i < aFileRoots.length && ((sRootAbsolutePath = aFileRoots[i].getAbsolutePath()).startsWith(S_DRIVE_A) || sRootAbsolutePath.startsWith(S_DRIVE_B)); ++i) {
        }
        return sRootAbsolutePath;
    }

    private String getSystemDriveOnWindows() {
        if (m_sSystemDriveOnWindows == null) {
            String sSystemDrive = null;
            String envName = "SystemDrive";
            String cmd = "cmd /c SET";
            String line = null;
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                InputStreamReader isr = new InputStreamReader(p.getInputStream());
                BufferedReader brCommandResult = new BufferedReader(isr);
                while ((line = brCommandResult.readLine()) != null) {
                    if (line.indexOf(envName) <= -1) continue;
                    sSystemDrive = line.substring(line.indexOf(envName) + envName.length() + 1);
                    break;
                }
            }
            catch (Exception e) {
                sSystemDrive = this.getFirstAvailableSystemDriveRootDirectory();
                sSystemDrive = sSystemDrive.substring(0, sSystemDrive.length() - 1);
            }
            m_sSystemDriveOnWindows = sSystemDrive;
        }
        return m_sSystemDriveOnWindows;
    }

    private String getSystemRootOnWindows() {
        String newSystemRoot;
        m_sSystemRootOnWindows = newSystemRoot = WASSystem.getWindowsSystemEnv("SystemRoot");
        return m_sSystemRootOnWindows;
    }

    protected static String getWindowsSystemEnv(String sEnvName) {
        String sSystemEnv = null;
        String cmdWindows = "cmd /c echo ";
        String cmdCygWin = "echo ";
        String macroWindows = "%";
        String macroCynWin = "$";
        String cmdInputParams = macroWindows + sEnvName + macroWindows;
        String cmdToBeExecuted = cmdWindows + cmdInputParams;
        String line = null;
        Process p = null;
        InputStreamReader isr = null;
        try {
            BufferedReader brCommandResult;
            try {
                p = Runtime.getRuntime().exec(cmdToBeExecuted);
            }
            catch (IOException ioe) {
                cmdInputParams = macroCynWin + sEnvName;
                cmdToBeExecuted = cmdCygWin + cmdInputParams;
                try {
                    p = Runtime.getRuntime().exec(cmdToBeExecuted);
                    isr = new InputStreamReader(p.getInputStream());
                    brCommandResult = new BufferedReader(isr);
                    line = brCommandResult.readLine();
                    if (line == null || line.equals(S_EMPTY) || line.equals(cmdInputParams)) {
                        isr.close();
                        return null;
                    }
                    isr.close();
                    sSystemEnv = line;
                }
                catch (IOException ioe2) {
                    return null;
                }
            }
            if (sSystemEnv == null && (line = (brCommandResult = new BufferedReader(isr = new InputStreamReader(p.getInputStream()))).readLine()) != null && !line.equals(S_EMPTY) && !line.equals(cmdInputParams)) {
                sSystemEnv = line;
            }
            isr.close();
        }
        catch (IOException ioe1) {
            return null;
        }
        return WASSystem.normalizePathNoEndingSlash(sSystemEnv);
    }

    public static String normalizePathNoEndingSlash(String sPath) {
        if (sPath != null && !sPath.equals(S_EMPTY) && (sPath = sPath.replace('\\', '/')).length() > 1 && sPath.endsWith("/")) {
            sPath = sPath.substring(0, sPath.length() - 1);
        }
        return sPath;
    }

    private boolean isThisRegistryNIFRegistry(String sRegistryFilePath) {
        if (sRegistryFilePath == null) {
            return false;
        }
        File registryFile = new File(sRegistryFilePath);
        if (registryFile == null || !registryFile.exists() || registryFile.isDirectory()) {
            return false;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(registryFile));
            String sLine = reader.readLine();
            while (sLine != null) {
                Pattern patternNIFRegistry;
                Matcher matcherNIFRegistry;
                if (sLine != null && !sLine.equals(S_EMPTY) && (matcherNIFRegistry = (patternNIFRegistry = Pattern.compile(S_NIFREGISTRY_ROOT_PATTERN, 32)).matcher(sLine)).matches()) {
                    reader.close();
                    return true;
                }
                sLine = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isThisValidWASHome(File sWAS_HOME) {
        if (sWAS_HOME == null) {
            return false;
        }
        String sPath = sWAS_HOME.getAbsolutePath() + S_RALATIVE_PROPERTIES_VERSION_DIR;
        File fVersionDir = new File(sPath);
        File[] children = fVersionDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                try {
                    return pathname.getName().endsWith(WASSystem.S_DOT_PRODUCT);
                }
                catch (Throwable t) {
                    return false;
                }
            }
        });
        return children != null && children.length > 0;
    }

    private String normalizePath(String sPath) {
        char cWindowsPathSeparator = '\\';
        char cUnixPathSeparator = '/';
        if (this.getCurrentPlatform() == 5) {
            return sPath.replace(cWindowsPathSeparator, cUnixPathSeparator);
        }
        return sPath;
    }

    private void parseWASRegistry(String sWASRegistryFile) {
        if (sWASRegistryFile == null) {
            return;
        }
        File registryFile = new File(sWASRegistryFile);
        if (registryFile == null || !registryFile.exists() || registryFile.isDirectory()) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(registryFile));
            String sLine = reader.readLine();
            while (sLine != null) {
                File wasHome;
                if ((sLine = sLine.trim()) != null && !sLine.equals(S_EMPTY) && this.isThisValidWASHome(wasHome = new File(sLine))) {
                    this.addInstallPackageLocationsByProductID(null, wasHome);
                }
                sLine = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseNIFRegistry(String sNIFRegistryFile) {
        if (sNIFRegistryFile == null) {
            return;
        }
        File registryFile = new File(sNIFRegistryFile);
        if (registryFile == null || !registryFile.exists() || registryFile.isDirectory()) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(registryFile), S_UTF8_ENCODING));
            String sLine = reader.readLine();
            while (sLine != null) {
                Pattern patternProductElement;
                Matcher matcherProductElement;
                if (sLine != null && !sLine.equals(S_EMPTY) && (matcherProductElement = (patternProductElement = Pattern.compile(S_PRODUCT_ELEMENT_PATTERN, 32)).matcher(sLine)).matches()) {
                    String sInstallRootURI = null;
                    sInstallRootURI = matcherProductElement.group(1);
                    String sProductID = null;
                    sProductID = matcherProductElement.group(2);
                    try {
                        File wasHome = new File(new URI(sInstallRootURI));
                        if (this.isThisValidWASHome(wasHome)) {
                            this.addInstallPackageLocationsByProductID(sProductID, wasHome);
                        }
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                sLine = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

