/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdDouble;
import com.ibm.websphere.pmi.server.SpdGroup;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.pmi.factory.StatsFactoryUtil;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.data.SpdDoubleAggregate;
import com.ibm.ws.pmi.server.data.SpdDoubleImpl;
import com.ibm.ws.pmi.server.data.SpdLoadAggregate;
import com.ibm.ws.pmi.server.data.SpdLoadImpl;
import com.ibm.ws.pmi.server.data.SpdLongAggregate;
import com.ibm.ws.pmi.server.data.SpdLongImpl;
import com.ibm.ws.pmi.server.data.SpdStatAggregate;
import com.ibm.ws.pmi.server.data.SpdStatImpl;
import com.ibm.ws.pmi.server.data.SpdStatisticAggregate;
import com.ibm.ws.pmi.server.data.SpdStatisticExternal;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.management.ObjectName;

public abstract class PmiAbstractModule
implements PmiModule,
PmiConstants {
    protected String name = null;
    protected String instanceName = null;
    protected String submoduleName = null;
    protected String subinstanceName = null;
    protected String categoryName = null;
    protected ObjectName mbeanName = null;
    protected StatDescriptor msd_sd = null;
    protected StatDescriptor sd60 = null;
    public PmiModuleConfig moduleConfig = null;
    protected int type = 14;
    protected int currentLevel = -1;
    protected boolean aggregateModule = false;
    protected PmiCallback callback = null;
    protected int[] enabled = new int[0];
    protected int[] enabledSync = new int[0];
    protected StatisticActions statisticActionLsnr = null;
    protected boolean bStandaloneTree = false;
    protected HashMap nameDataTable = null;
    protected Map dataTable = new TreeMap();
    private ArrayList dataList = new ArrayList(3);
    protected boolean bAllCountersDisabled = true;
    private static final TraceComponent tc = Tr.register(PmiAbstractModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static int SET = 1;
    public static int INCREMENT = 2;
    public static int DECREMENT = 3;

    public PmiAbstractModule(String moduleID, String instanceName) {
        this(null, moduleID, instanceName, null);
    }

    public PmiAbstractModule(String moduleID, String instanceName, PmiCallback callback) {
        this(null, moduleID, instanceName, callback);
    }

    public boolean isStandaloneTree() {
        return this.bStandaloneTree;
    }

    public PmiAbstractModule(ObjectName mbeanName, String moduleID, String instanceName, PmiCallback callback) {
        if (!PmiRegistry.isDisabled()) {
            this.instanceName = instanceName;
            this.callback = callback;
            this.mbeanName = mbeanName;
            this.moduleConfig = PerfModules.getConfig(moduleID);
            if (this.moduleConfig == null) {
                Tr.warning(tc, "PMI0007W", moduleID);
            }
        }
    }

    public PmiAbstractModule(PmiModuleConfig mcfg, String instanceName, StatisticActions sal) {
        if (!PmiRegistry.isDisabled()) {
            this.instanceName = instanceName;
            this.moduleConfig = mcfg;
            this.statisticActionLsnr = sal;
        }
    }

    public PmiAbstractModule() {
    }

    public void init(Object[] params) {
    }

    protected void registerModule(PmiModule moduleInstance) {
        if (this.moduleConfig != null) {
            PmiRegistry.registerModule(moduleInstance);
        }
    }

    protected void unregisterModule(PmiModule moduleInstance) {
        this.dataTable = null;
        PmiRegistry.unregisterModule(moduleInstance);
    }

    protected boolean isDisabled() {
        return PmiRegistry.isDisabled();
    }

    protected boolean longCreated(SpdLong data) {
        return false;
    }

    protected boolean doubleCreated(SpdDouble data) {
        return false;
    }

    protected boolean statCreated(SpdStat data) {
        return false;
    }

    protected boolean loadCreated(SpdLoad data) {
        return false;
    }

    protected void counterStateChanged(boolean isAllDisabled) {
    }

    protected boolean externalStatisticCreated(StatisticImpl stat) {
        return false;
    }

    protected void callbackRuntime(int newLevel) {
    }

    protected void initializeMe(int newLevel) {
    }

    protected void initializeFG(int dataID) {
        RangeStatisticImpl val;
        SpdData data = (SpdData)this.dataTable.get(new Integer(dataID));
        if (data != null && data instanceof SpdLoadImpl && (val = (RangeStatisticImpl)data.getStatistic()) != null && val.getCurrent() < 0L) {
            val.setLastValue(0L);
        }
    }

    protected synchronized void putToTable(SpdData data) {
        if (data == null) {
            return;
        }
        this.dataTable.put(new Integer(data.getId()), data);
        data.setDataInfo(this.moduleConfig);
        if (data.isEnabled()) {
            this.addStatToEnabledArray(data.getId());
        }
    }

    private void addStatToEnabledArray(int stat) {
        for (int i = 0; i < this.enabled.length; ++i) {
            if (this.enabled[i] != stat) continue;
            return;
        }
        int[] newEnabled = new int[this.enabled.length + 1];
        for (int i = 0; i < this.enabled.length; ++i) {
            newEnabled[i] = this.enabled[i];
        }
        newEnabled[this.enabled.length] = stat;
        this.enabled = newEnabled;
    }

    private void removeStatFromEnabledArray(int stat) {
        int len = this.enabled.length;
        for (int i = 0; i < this.enabled.length; ++i) {
            if (this.enabled[i] != stat) continue;
            --len;
        }
        if (this.enabled.length == len) {
            return;
        }
        if (len < 0) {
            len = 0;
        }
        int[] newEnabled = new int[len];
        int ii = 0;
        for (int i = 0; i < this.enabled.length; ++i) {
            if (this.enabled[i] == stat) continue;
            newEnabled[ii++] = this.enabled[i];
        }
        this.enabled = newEnabled;
    }

    protected synchronized void removeFromTable(SpdData data) {
        if (data == null) {
            return;
        }
        this.dataTable.remove(new Integer(data.getId()));
        this.removeStatFromEnabledArray(data.getId());
    }

    protected SpdData createOneData(PmiDataInfo info) {
        String[] _path;
        if (info == null || info.getLevel() == 1000) {
            return null;
        }
        if (!info.isAvailableInPlatform(PmiRegistry.PLATFORM)) {
            return null;
        }
        if (info.getSubmoduleName() != null && this.type != 13 && this.type != 15 && this.type != 16) {
            return null;
        }
        if (this.type == 15 || this.type == 16) {
            if (info.getSubmoduleName() == null) {
                return null;
            }
            if (!info.getSubmoduleName().equals(this.submoduleName)) {
                return null;
            }
        }
        if ((_path = this.getPath())[0].equals("beanModule") && _path.length == 1 && info.getId() >= 50) {
            return null;
        }
        if (!info.getCategory().equals("all") && !this.isInCategory(this.categoryName, info.getCategory())) {
            return null;
        }
        if (this.aggregateModule) {
            return this.createAggregateData(info);
        }
        if (info.getType() == 15) {
            return null;
        }
        if (!this.aggregateModule && this.type == 13 && info.getSubmoduleName() != null) {
            return null;
        }
        int dataId = info.getId();
        if (info.isUpdateOnRequest()) {
            SpdStatisticExternal onReqStat = null;
            if (this.statisticActionLsnr != null) {
                onReqStat = new SpdStatisticExternal(info, this.statisticActionLsnr);
                this.externalStatisticCreated(onReqStat.getStatisticRef());
            }
            return onReqStat;
        }
        switch (info.getType()) {
            case 2: {
                SpdLongImpl longData = new SpdLongImpl(dataId);
                this.longCreated(longData);
                return longData;
            }
            case 3: {
                SpdDoubleImpl doubleData = new SpdDoubleImpl(dataId);
                this.doubleCreated(doubleData);
                return doubleData;
            }
            case 4: {
                SpdStatImpl statData = new SpdStatImpl(dataId);
                this.statCreated(statData);
                return statData;
            }
            case 6: {
                SpdStatImpl avgData = new SpdStatImpl(6, dataId);
                this.statCreated(avgData);
                return avgData;
            }
            case 5: {
                SpdLoadImpl loadData = new SpdLoadImpl(dataId);
                this.loadCreated(loadData);
                return loadData;
            }
            case 7: {
                SpdLoadImpl rangeData = new SpdLoadImpl(7, dataId);
                this.loadCreated(rangeData);
                return rangeData;
            }
        }
        return null;
    }

    private boolean isInCategory(String myCategory, String categoryList) {
        if (myCategory == null) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(categoryList, "+");
        while (st.hasMoreTokens()) {
            if (!myCategory.equals(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    protected SpdData createAggregateData(PmiDataInfo info) {
        if (!info.isAggregatable()) {
            return null;
        }
        int dataId = info.getId();
        if (info.isUpdateOnRequest()) {
            return new SpdStatisticAggregate(info);
        }
        switch (info.getType()) {
            case 2: {
                SpdLongAggregate longData = new SpdLongAggregate(dataId);
                return longData;
            }
            case 3: {
                SpdDoubleAggregate doubleData = new SpdDoubleAggregate(dataId);
                return doubleData;
            }
            case 4: {
                SpdStatAggregate statData = new SpdStatAggregate(dataId);
                return statData;
            }
            case 5: {
                SpdLoadAggregate loadData = new SpdLoadAggregate(dataId);
                return loadData;
            }
            case 7: {
                SpdLoadAggregate rangeData = new SpdLoadAggregate(7, dataId);
                return rangeData;
            }
            case 6: {
                SpdStatAggregate avgData = new SpdStatAggregate(6, dataId);
                return avgData;
            }
        }
        return null;
    }

    protected void createData(PmiModuleConfig aModCfg, int level) {
        if (aModCfg == null) {
            return;
        }
        if (this.dataTable == null) {
            this.dataTable = new TreeMap();
        }
        PmiDataInfo[] infoList = aModCfg.listData(this.submoduleName);
        for (int i = 0; i < infoList.length; ++i) {
            if (infoList[i].getLevel() > level && (infoList[i].getType() != 5 && infoList[i].getType() != 7 || infoList[i].getLevel() != 7)) continue;
            SpdData data = (SpdData)this.dataTable.get(new Integer(infoList[i].getId()));
            if (data != null && infoList[i].getLevel() <= level) {
                data.enable(level);
                continue;
            }
            if (data != null || (data = this.createOneData(infoList[i])) == null) continue;
            this.putToTable(data);
            if (infoList[i].getLevel() <= level) {
                data.enable(level);
                continue;
            }
            data.disable();
        }
    }

    protected synchronized void removeData(int level) {
        if (this.dataTable == null) {
            return;
        }
        for (SpdData data : this.dataTable.values()) {
            PmiDataInfo info = this.moduleConfig.getDataInfo(data.getId());
            if (info != null) {
                if (info.getLevel() <= level) continue;
                data.disable();
                continue;
            }
            data.disable();
        }
    }

    protected synchronized void createNameDataTable() {
        if (this.moduleConfig == null) {
            Tr.warning(tc, "PMI0007W", this.getModuleID());
            return;
        }
        if (this.nameDataTable != null) {
            return;
        }
        PmiDataInfo[] dataInfos = this.moduleConfig.listAllData();
        this.nameDataTable = new HashMap(dataInfos.length * 2);
        for (int i = 0; i < dataInfos.length; ++i) {
            this.nameDataTable.put(dataInfos[i].getName(), new Integer(dataInfos[i].getId()));
        }
    }

    public abstract int getDefaultLevel();

    public abstract String getModuleID();

    public ObjectName getMBeanName() {
        if (!this.isCustomModule() && this.mbeanName == null) {
            this._findMBean();
        }
        return this.mbeanName;
    }

    public MBeanStatDescriptor getMBeanStatDescriptor() {
        if (!this.isCustomModule() && this.mbeanName == null) {
            this._findMBean();
        }
        return new MBeanStatDescriptor(this.mbeanName, this.msd_sd);
    }

    public StatDescriptor getMSD_StatDescriptor() {
        if (!this.isCustomModule() && this.mbeanName == null) {
            this._findMBean();
        }
        return this.msd_sd;
    }

    public StatDescriptor get60_StatDescriptor() {
        if (this.sd60 == null) {
            this.sd60 = new StatDescriptor(this.getPath());
        }
        return this.sd60;
    }

    public void setMBeanName(ObjectName on) {
        this.mbeanName = on;
    }

    public void setMBeanName(ObjectName on, StatDescriptor msd_sd) {
        this.mbeanName = on;
        this.msd_sd = msd_sd;
    }

    private void _findMBean() {
        if (this.isCustomModule() || this.mbeanName != null) {
            return;
        }
        MBeanStatDescriptor msd = PmiRegistry.jmxMapper.getMBeanStatDescriptor(null, new DataDescriptor(this.getPath()));
        if (msd != null) {
            this.mbeanName = msd.getObjectName();
            this.msd_sd = msd.getStatDescriptor();
        } else {
            this.msd_sd = new StatDescriptor(this.getPath());
            Tr.warning(tc, "PMI0006W", this.getModuleID() + "," + this.getName());
        }
    }

    public MBeanStatDescriptor[] listStatMembers() {
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String[] path = this.getPath();
        this.name = path == null || path.length == 0 ? null : path[path.length - 1];
        return this.name;
    }

    public String[] getPath() {
        String[] path = null;
        if (this.type == 13) {
            path = new String[]{this.getModuleID()};
        } else if (this.categoryName == null) {
            if (this.type == 14) {
                path = new String[]{this.getModuleID(), this.instanceName};
            } else if (this.type == 15) {
                path = new String[]{this.getModuleID(), this.instanceName, this.submoduleName};
            } else if (this.type == 16) {
                path = new String[]{this.getModuleID(), this.instanceName, this.submoduleName, this.subinstanceName};
            }
        } else if (this.type == 19) {
            path = new String[]{this.getModuleID(), this.categoryName};
        } else if (this.type == 14) {
            path = new String[]{this.getModuleID(), this.categoryName, this.instanceName};
        } else if (this.type == 15) {
            path = new String[]{this.getModuleID(), this.categoryName, this.instanceName, this.submoduleName};
        } else if (this.type == 16) {
            path = new String[]{this.getModuleID(), this.categoryName, this.instanceName, this.submoduleName, this.subinstanceName};
        }
        return path;
    }

    public int getType() {
        return this.type;
    }

    public int getInstrumentationLevel() {
        if (this.currentLevel == 2) {
            return 0;
        }
        return this.currentLevel;
    }

    public int[] getEnabled() {
        return this.enabled;
    }

    public int[] getEnabledSync() {
        return this.enabledSync;
    }

    public synchronized void setInstrumentationLevel(int newLevel) {
        try {
            if (this.moduleConfig == null) {
                Tr.warning(tc, "PMI0007W", this.getModuleID());
                return;
            }
            if (newLevel == -1) {
                return;
            }
            if (newLevel == this.currentLevel) {
                return;
            }
            if (this.currentLevel == -2 || newLevel < this.currentLevel) {
                this.createData(this.moduleConfig, newLevel);
                this.removeData(newLevel);
            } else if (newLevel > this.currentLevel) {
                this.createData(this.moduleConfig, newLevel);
                this.initializeMe(newLevel);
            }
            this.currentLevel = newLevel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateDataList();
        this.updateEnabledByLevel();
    }

    public void setInstrumentationBySet(String set) {
        if (this.moduleConfig != null) {
            this.setFineGrainedInstrumentation(this.getStatisticIDBySet(set), new int[0]);
        }
    }

    public synchronized boolean setFineGrainedInstrumentation(int[] enabled, int[] enableWithSync) {
        if (this.moduleConfig == null) {
            Tr.warning(tc, "PMI0007W", this.getModuleID());
            return false;
        }
        this.currentLevel = -2;
        if (enabled == null || enabled.length == 0) {
            this.enabled = enabled;
            this.enabledSync = enableWithSync;
            this.disableAll();
            this.updateDataList();
            return true;
        }
        boolean bSelectiveDisable = false;
        boolean bEnableAll = false;
        if (enabled.length == 1 && enabled[0] == -3) {
            this.enabled = enabled;
            this.enableAll(false);
            bEnableAll = true;
        } else {
            ArrayList<Integer> enList = new ArrayList<Integer>(2);
            bSelectiveDisable = true;
            if (this.dataTable == null) {
                this.dataTable = new TreeMap();
            }
            for (int i = 0; i < enabled.length; ++i) {
                SpdData data = (SpdData)this.dataTable.get(new Integer(enabled[i]));
                if (data == null) {
                    PmiDataInfo dInfo = this.moduleConfig.getDataInfo(enabled[i]);
                    if (dInfo != null) {
                        data = this.createOneData(dInfo);
                    }
                    if (data == null) continue;
                    this.putToTable(data);
                    enList.add(new Integer(enabled[i]));
                    continue;
                }
                if (!data.isEnabled()) {
                    this.initializeFG(enabled[i]);
                }
                data.enable(1);
                enList.add(new Integer(enabled[i]));
            }
            int[] nEnabled = new int[enList.size()];
            for (int k = 0; k < nEnabled.length; ++k) {
                nEnabled[k] = (Integer)enList.get(k);
            }
            this.enabled = nEnabled;
        }
        if (!bEnableAll && bSelectiveDisable) {
            for (SpdData data : this.dataTable.values()) {
                int did = data.getId();
                boolean found = false;
                for (int i = 0; i < enabled.length; ++i) {
                    if (did != enabled[i]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                for (int k = 0; k < enableWithSync.length; ++k) {
                    if (did != enableWithSync[k]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                data.disable();
            }
        }
        this.enableDependencies();
        this.updateDataList();
        return true;
    }

    protected void setStatisticEnabled(int id, boolean flag, boolean bCreateIfReqd) {
        SpdData data = (SpdData)this.dataTable.get(new Integer(id));
        if (flag) {
            if (data == null) {
                if (bCreateIfReqd && (data = this.createOneData(this.moduleConfig.getDataInfo(id))) != null) {
                    this.putToTable(data);
                }
            } else if (!data.isEnabled()) {
                this.initializeFG(id);
                data.enable(1);
            }
        } else if (data != null) {
            data.disable();
        }
    }

    private void enableDependencies() {
        int[] parent = this.moduleConfig.listStatisticsWithDependents();
        if (parent == null || parent.length == 0) {
            return;
        }
        for (int i = 0; i < parent.length; ++i) {
            ArrayList child;
            if (!this.isEnabled(parent[i]) || (child = this.moduleConfig.getDataInfo(parent[i]).getDependency()) == null) continue;
            for (int k = 0; k < child.size(); ++k) {
                this.setStatisticEnabled((Integer)child.get(k), true, true);
            }
        }
    }

    protected String[] getCustomSubModuleList() {
        return null;
    }

    private void enableAll(boolean sync2) {
        if (this.dataTable == null) {
            this.dataTable = new TreeMap();
        }
        this._enableAllInModule(this.moduleConfig, sync2);
        String[] childModules = this.getCustomSubModuleList();
        if (childModules != null) {
            for (int k = 0; k < childModules.length; ++k) {
                PmiModuleConfig childModCfg = PerfModules.getConfig(childModules[k]);
                if (childModCfg == null) continue;
                this._enableAllInModule(childModCfg, sync2);
            }
        }
    }

    private void _enableAllInModule(PmiModuleConfig _config, boolean sync2) {
        PmiDataInfo[] infoList = _config.listData(this.submoduleName);
        for (int i = 0; i < infoList.length; ++i) {
            SpdData data = (SpdData)this.dataTable.get(new Integer(infoList[i].getId()));
            if (data == null && (data = this.createOneData(infoList[i])) != null) {
                this.putToTable(data);
            }
            if (data != null) {
                if (!data.isEnabled()) {
                    this.initializeFG(infoList[i].getId());
                }
                if (sync2) {
                    data.enable(15);
                    continue;
                }
                data.enable(1);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "enableAll: cannot create data: " + _config.getUID() + "; " + infoList[i].getId());
        }
    }

    private void disableAll() {
        if (this.dataTable != null) {
            Iterator itr = this.dataTable.values().iterator();
            while (itr.hasNext()) {
                ((SpdData)itr.next()).disable();
            }
        }
    }

    public synchronized void enableData(int dataId) {
        if (this.dataTable == null) {
            this.dataTable = new TreeMap();
        }
        if (this.moduleConfig == null) {
            return;
        }
        if (dataId == -3) {
            this.setInstrumentationLevel(7);
            return;
        }
        SpdData data = (SpdData)this.dataTable.get(new Integer(dataId));
        if (data != null) {
            data.enable(this.currentLevel);
        } else {
            PmiDataInfo[] infoList = this.moduleConfig.listAllData();
            PmiDataInfo info = null;
            for (int j = 0; j < infoList.length; ++j) {
                if (infoList[j].getId() != dataId) continue;
                info = infoList[j];
                break;
            }
            if (info == null) {
                return;
            }
            if (this.currentLevel == 0) {
                this.currentLevel = 2;
            }
            if ((data = this.createOneData(info)) != null) {
                this.putToTable(data);
            }
        }
    }

    public synchronized void disableData(int dataId) {
        if (this.dataTable == null) {
            return;
        }
        if (dataId == -3) {
            this.setInstrumentationLevel(0);
        } else {
            SpdData[] list;
            SpdData data = (SpdData)this.dataTable.get(new Integer(dataId));
            if (data != null) {
                data.disable();
            }
            if (((list = this.listData()) == null || list.length == 0) && this.type != 13 && this.type != 15) {
                this.currentLevel = 0;
            }
        }
    }

    public SpdData[] listData() {
        if (this.dataTable == null) {
            return null;
        }
        Iterator members = this.dataTable.values().iterator();
        ArrayList<SpdData> list = new ArrayList<SpdData>();
        while (members.hasNext()) {
            SpdData data = (SpdData)members.next();
            if (!data.isEnabled()) continue;
            list.add(data);
        }
        SpdData[] retData = new SpdData[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retData[i] = (SpdData)list.get(i);
        }
        return retData;
    }

    public SpdData listData(int dataId) {
        if (this.dataTable == null) {
            return null;
        }
        SpdData data = (SpdData)this.dataTable.get(new Integer(dataId));
        if (data != null && data.isEnabled()) {
            return data;
        }
        return null;
    }

    public SpdData[] listData(int[] dataIds) {
        if (this.dataTable == null) {
            return null;
        }
        if (dataIds == null) {
            return this.listData();
        }
        ArrayList<SpdData> list = new ArrayList<SpdData>(dataIds.length);
        for (int i = 0; i < dataIds.length; ++i) {
            SpdData data = (SpdData)this.dataTable.get(new Integer(dataIds[i]));
            if (data == null || !data.isEnabled()) continue;
            list.add(data);
        }
        if (list.size() == 0) {
            return null;
        }
        SpdData[] retData = new SpdData[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retData[i] = (SpdData)list.get(i);
        }
        return retData;
    }

    public void updateDataList() {
        if (this.dataTable == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PmiAbstractModule.updateDataList: module data is not initialized");
            }
            return;
        }
        this.dataList.clear();
        for (SpdData data : this.dataTable.values()) {
            if (!data.isEnabled()) continue;
            StatisticImpl s = data.getStatistic();
            if (s == null) {
                Tr.warning(tc, "PMI9999E", "PmiAbstractModule.updateDataList: " + this.getModuleID() + ", " + this.getName());
                Tr.warning(tc, "PMI9999E", new Exception().fillInStackTrace());
                continue;
            }
            this.dataList.add(s);
        }
        if (this.dataList.size() > 0) {
            if (this.bAllCountersDisabled) {
                this.bAllCountersDisabled = false;
                this.counterStateChanged(false);
            }
        } else if (!this.bAllCountersDisabled) {
            this.bAllCountersDisabled = true;
            this.counterStateChanged(true);
        }
    }

    public boolean isAllDisabled() {
        return this.bAllCountersDisabled;
    }

    protected void update() {
        for (SpdData data : this.dataTable.values()) {
            if (!data.isEnabled()) continue;
            if (data.isExternal()) {
                data.updateExternal();
                continue;
            }
            if (!data.isAggregate()) continue;
            ((SpdGroup)data).updateAggregate();
        }
    }

    public void updateStatistics() {
        this.update();
    }

    public ArrayList listStatistics() {
        this.update();
        return this.dataList;
    }

    public StatsImpl getStats(ArrayList dataMembers, ArrayList colMembers) {
        StatsImpl s = new StatsImpl(this.getName(), this.type, this.currentLevel, dataMembers, colMembers);
        s.setStatsType(this.getWCCMStatsType());
        return s;
    }

    public void updateData(int dataId, int opType, double value) {
        if (this.dataTable == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PmiAbstractModule.updateData: module data is not initialized");
            }
            return;
        }
        SpdData mydata = (SpdData)this.dataTable.get(new Integer(dataId));
        this.updateData(mydata, opType, value);
    }

    public void updateData(String dataName, int opType, double value) {
        if (this.nameDataTable == null) {
            this.createNameDataTable();
            if (this.nameDataTable == null) {
                return;
            }
        }
        Integer dataId = (Integer)this.nameDataTable.get(dataName);
        SpdData mydata = (SpdData)this.dataTable.get(dataId);
        this.updateData(mydata, opType, value);
    }

    public void updateData(SpdData mydata, int opType, double value) {
        if (mydata == null) {
            Tr.warning(tc, "PMI0005W", "PmiAbstractModule.updateData, moduleID=" + this.getModuleID());
            return;
        }
        if (mydata instanceof SpdLong) {
            if (opType == SET) {
                ((SpdLong)mydata).set((long)value);
            } else if (opType == INCREMENT) {
                ((SpdLong)mydata).increment((long)value);
            } else if (opType == DECREMENT) {
                ((SpdLong)mydata).decrement((long)value);
            } else {
                Tr.warning(tc, "PMI0009W", "opType");
            }
        } else if (mydata instanceof SpdLoad) {
            if (opType == SET) {
                ((SpdLoad)mydata).add(value);
            } else if (opType == INCREMENT) {
                ((SpdLoad)mydata).increment(value);
            } else if (opType == DECREMENT) {
                ((SpdLoad)mydata).decrement(value);
            } else {
                Tr.warning(tc, "PMI0009W", "opType");
            }
        } else if (mydata instanceof SpdStat) {
            if (opType == SET) {
                ((SpdStat)mydata).add(value);
            } else {
                Tr.warning(tc, "PMI0009W", "opType");
            }
        } else {
            Tr.warning(tc, "PMI0009W", "dataType");
        }
    }

    public void cleanup() {
        if (this.mbeanName != null) {
            PmiRegistry.removeMBeanToModuleMap(new MBeanStatDescriptor(this.mbeanName, this.msd_sd));
        }
        if (this.isCustomModule()) {
            StatsFactoryUtil.deactivateMBean(this.mbeanName);
        }
        if (this.dataTable != null) {
            this.dataTable.clear();
            this.dataTable = null;
        }
        if (this.nameDataTable != null) {
            this.nameDataTable.clear();
            this.nameDataTable = null;
        }
        this.instanceName = null;
        this.subinstanceName = null;
        this.categoryName = null;
        this.mbeanName = null;
        this.msd_sd = null;
        this.moduleConfig = null;
        this.callback = null;
    }

    public void unregister() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unregister " + this.getModuleID() + ", " + this.getName());
        }
        PmiRegistry.unregisterModule(this);
        this.currentLevel = 0;
        this.cleanup();
    }

    public boolean isCustomModule() {
        return false;
    }

    public PmiModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public StatsImpl getJSR77Stats(ModuleItem mitem) {
        return mitem.getStats(false);
    }

    public String getWCCMStatsType() {
        StringBuffer b = new StringBuffer(this.getModuleID());
        if (this.type == 13) {
            return b.toString();
        }
        if (this.type == 15 || this.type == 16) {
            return b.append("#").append(this.submoduleName).toString();
        }
        if (this.type == 14) {
            if (this.moduleConfig.hasSubModule()) {
                b.append("#");
            }
            return b.toString();
        }
        return b.toString();
    }

    public boolean isEnabled(int dataID) {
        if (this.dataTable == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PmiAbstractModule.isEnabled: module data is not initialized");
            }
            return false;
        }
        SpdData data = (SpdData)this.dataTable.get(new Integer(dataID));
        if (data == null) {
            return false;
        }
        return data.isEnabled();
    }

    public boolean isJ2EEStatisticProvider() {
        return this.dataList != null && this.dataList.size() > 0;
    }

    public int[] getStatisticIDBySet(String setID) {
        if (this.moduleConfig != null) {
            return this.moduleConfig.listStatisticsBySet(setID);
        }
        return new int[0];
    }

    public void setSyncEnabled(boolean sync2) {
        if (this.dataTable != null) {
            for (SpdData data : this.dataTable.values()) {
                if (!data.isEnabled()) continue;
                if (sync2) {
                    data.enable(15);
                    continue;
                }
                data.enable(1);
            }
        }
    }

    public void updateEnabledByLevel() {
        if (this.currentLevel == -2) {
            return;
        }
        if (this.dataTable != null) {
            Iterator members = this.dataTable.values().iterator();
            ArrayList<Integer> list = new ArrayList<Integer>();
            while (members.hasNext()) {
                SpdData data = (SpdData)members.next();
                if (!data.isEnabled()) continue;
                list.add(new Integer(data.getId()));
            }
            this.enabled = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.enabled[i] = (Integer)list.get(i);
            }
        }
    }
}

