/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class genericURLInitialContextFactory
implements InitialContextFactory {
    private static final TraceComponent _tc = Tr.register(genericURLInitialContextFactory.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    static final String GEN_URL_CTX_FACTORY_CLASSNAME = "com.ibm.ws.naming.urlns.genericURLContextFactory";
    private static final String CREATE_NAMESPACE_METHODNAME = "createNameSpace";
    private static final String CREATE_GEN_URL_CTXROOT_METHODNAME = "createURLContextRoot";
    private static Class _implClass;
    private static String _implClassName;
    private static Constructor _implClassCtor;

    public genericURLInitialContextFactory() {
        if (_tc.isEntryEnabled()) {
            Tr.debug(_tc, "<init>");
        }
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext", "env=" + env);
        }
        CommonHelpers.mergeWsnJndiProperties(env);
        Context retCtx = null;
        String schemeId = null;
        String packageName = null;
        Object s = env.get("com.ibm.websphere.naming.generic.url.schemeid");
        if (s != null && !(s instanceof String)) {
            String message = "The value of property com.ibm.websphere.naming.generic.url.schemeid is not a string.";
            ConfigurationException ce = new ConfigurationException(message);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContext", ce);
            }
            throw ce;
        }
        schemeId = (String)s;
        Object p = env.get("com.ibm.websphere.naming.generic.url.package");
        if (p != null && !(p instanceof String)) {
            String message = "The value of property com.ibm.websphere.naming.generic.url.package is not a string.";
            ConfigurationException ce = new ConfigurationException(message);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContext", ce);
            }
            throw ce;
        }
        packageName = (String)p;
        if (schemeId == null || schemeId.length() == 0 || packageName == null || packageName.length() == 0) {
            Tr.warning(_tc, "urlNoSchemeOrPkg");
            String message = "The scheme or package name was not set.";
            ConfigurationException ce = new ConfigurationException(message);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContext", ce);
            }
            throw ce;
        }
        String urlFactoryName = packageName + "." + schemeId + "." + schemeId + "URLContextFactory";
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getInitialContext", new String[]{"schemdId=" + schemeId, "packageName=" + packageName, "urlFactoryName=" + urlFactoryName});
        }
        Class urlFactoryClass = genericURLInitialContextFactory.getExternalImplClass(urlFactoryName);
        Object urlFactoryInstance = genericURLInitialContextFactory.createImplClassInstance(urlFactoryClass, null, null);
        Class implClass = genericURLInitialContextFactory.getInternalImplClass(GEN_URL_CTX_FACTORY_CLASSNAME);
        Object implClassInstance = genericURLInitialContextFactory.createImplClassInstance(implClass, new Class[]{String.class}, new Object[]{schemeId});
        genericURLInitialContextFactory.getAndInvokeMethod(implClass, implClassInstance, CREATE_NAMESPACE_METHODNAME, null, null);
        retCtx = (Context)genericURLInitialContextFactory.getAndInvokeMethod(implClass, implClassInstance, CREATE_GEN_URL_CTXROOT_METHODNAME, new Class[]{Hashtable.class}, new Object[]{env});
        this.updateSystemProperty(packageName);
        this.updateContextEnv(packageName, retCtx);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInitialContext", retCtx);
        }
        return retCtx;
    }

    static Class getExternalImplClass(final String implClassName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getExternalImplClass", "implClassName=" + implClassName);
        }
        Class implClass = null;
        Throwable throwable = null;
        try {
            try {
                implClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception, LinkageError {
                        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                        if (contextClassLoader == null) {
                            throw new NullPointerException("Context class loader is null");
                        }
                        return Class.forName(implClassName, true, contextClassLoader);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (Exception ex) {
            throwable = ex;
        }
        catch (LinkageError ex) {
            throwable = ex;
        }
        if (throwable != null) {
            RasUtil.logException(throwable, _tc, CLASS_NAME, "getExternalImplClass", "300");
            Tr.warning(_tc, "cannotGetClassObj", implClassName);
            String message = "Failed to create Class object for the class " + implClassName + ".";
            ConfigurationException ce = new ConfigurationException(message);
            ce.initCause(throwable);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getExternalImplClass", ce);
            }
            throw ce;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getExternalImplClass", implClass);
        }
        return implClass;
    }

    static Class getInternalImplClass(final String implClassName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInternalImplClass", "implClassName=" + implClassName);
        }
        Class implClass = null;
        Throwable throwable = null;
        try {
            try {
                implClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception, LinkageError {
                        return Class.forName(implClassName);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (Exception ex) {
            throwable = ex;
        }
        catch (LinkageError ex) {
            throwable = ex;
        }
        if (throwable != null) {
            RasUtil.logException(throwable, _tc, CLASS_NAME, "getInternalImplClass", "368");
            Tr.warning(_tc, "cannotGetClassObj", implClassName);
            String message = "Failed to create Class object for the class " + implClassName + ".";
            ConfigurationException ce = new ConfigurationException(message);
            ce.initCause(throwable);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInternalImplClass", ce);
            }
            throw ce;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInternalImplClass", implClass);
        }
        return implClass;
    }

    static Object createImplClassInstance(Class implClass, Class[] argsClass, Object[] args) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "creatImplClassInstance", new String[]{"implClass=" + implClass, "argsClass=" + argsClass, "args=" + args});
        }
        Object implClassInstance = null;
        Throwable throwable = null;
        try {
            Constructor implConstructor = implClass.getConstructor(argsClass);
            implClassInstance = implConstructor.newInstance(args);
        }
        catch (Exception ex) {
            throwable = ex;
        }
        catch (LinkageError ex) {
            throwable = ex;
        }
        if (throwable != null) {
            RasUtil.logException(throwable, _tc, CLASS_NAME, "createImplClassInstance", "420");
            Tr.warning(_tc, "cannotCreateObj", implClass.getName());
            String message = "Could not create an instance of the class " + implClass.getName() + ".";
            ConfigurationException ce = new ConfigurationException(message);
            ce.initCause(throwable);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "creatImplClassInstance");
            }
            throw ce;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "creatImplClassInstance", implClassInstance);
        }
        return implClassInstance;
    }

    static Object getAndInvokeMethod(Class implClass, Object implClassInstance, String methodName, Class[] parameterTypes, Object[] args) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAndInvokeMethod", new String[]{"implClass=" + implClass, "implClassInstance=" + implClassInstance, "methodName=" + methodName, "parameterTypes=" + parameterTypes, "args=" + args});
        }
        Object retObj = null;
        Throwable throwable = null;
        try {
            Method method2 = implClass.getMethod(methodName, parameterTypes);
            retObj = method2.invoke(implClassInstance, args);
        }
        catch (Exception ex) {
            throwable = ex;
        }
        catch (LinkageError ex) {
            throwable = ex;
        }
        if (throwable != null) {
            RasUtil.logException(throwable, _tc, CLASS_NAME, "getAndInvokeMethod", "473");
            Tr.warning(_tc, "cannotInvokeMethod", new String[]{methodName, implClass.getName()});
            String message = "Could not invoke method " + methodName + " on object of type " + implClass.getName() + ".";
            ConfigurationException ce = new ConfigurationException(message);
            ce.initCause(throwable);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getAndInvokeMethod", ce);
            }
            throw ce;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getAndInvokeMethod", retObj);
        }
        return retObj;
    }

    void updateSystemProperty(String packageName) {
        String urlPackagePrefixes;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateSystemProperty", "packageName=" + packageName);
        }
        if ((urlPackagePrefixes = CommonHelpers.getSystemProperty("java.naming.factory.url.pkgs")) == null) {
            urlPackagePrefixes = "com.ibm.ws.naming:" + packageName;
            CommonHelpers.setSystemProperty("java.naming.factory.url.pkgs", urlPackagePrefixes);
        } else {
            boolean prependNamingPackage = true;
            boolean appendPackage = true;
            StringTokenizer tokenizer = new StringTokenizer(urlPackagePrefixes, String.valueOf(':'));
            while (tokenizer.hasMoreTokens()) {
                String urlPackagePrefix = tokenizer.nextToken();
                if (urlPackagePrefix.equals("com.ibm.ws.naming")) {
                    prependNamingPackage = false;
                }
                if (!packageName.equals(urlPackagePrefix)) continue;
                appendPackage = false;
            }
            if (prependNamingPackage) {
                urlPackagePrefixes = "com.ibm.ws.naming:" + urlPackagePrefixes;
            }
            if (appendPackage) {
                urlPackagePrefixes = urlPackagePrefixes + ':' + packageName;
            }
            if (prependNamingPackage || appendPackage) {
                CommonHelpers.setSystemProperty("java.naming.factory.url.pkgs", urlPackagePrefixes);
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "updateSystemProperty", "java.naming.factory.url.pkgs=" + CommonHelpers.getSystemProperty("java.naming.factory.url.pkgs"));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateSystemProperty");
        }
    }

    void updateContextEnv(String packageName, Context ctx) throws NamingException {
        Hashtable<?, ?> env;
        Object o;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateContextEnv", new String[]{"packageName=" + packageName, "ctx=" + ctx});
        }
        if ((o = (env = ctx.getEnvironment()).get("java.naming.factory.url.pkgs")) == null) {
            String urlPackagePrefixes = "com.ibm.ws.naming:" + packageName;
            ctx.addToEnvironment("java.naming.factory.url.pkgs", urlPackagePrefixes);
        } else if (o instanceof String) {
            String urlPackagePrefixes = (String)o;
            boolean prependNamingPackage = true;
            boolean appendPackage = true;
            StringTokenizer tokenizer = new StringTokenizer(urlPackagePrefixes, String.valueOf(':'));
            while (tokenizer.hasMoreTokens()) {
                String urlPackagePrefix = tokenizer.nextToken();
                if (urlPackagePrefix.equals("com.ibm.ws.naming")) {
                    prependNamingPackage = false;
                }
                if (!packageName.equals(urlPackagePrefix)) continue;
                appendPackage = false;
            }
            if (prependNamingPackage) {
                urlPackagePrefixes = "com.ibm.ws.naming:" + urlPackagePrefixes;
            }
            if (appendPackage) {
                urlPackagePrefixes = urlPackagePrefixes + ':' + packageName;
            }
            if (prependNamingPackage || appendPackage) {
                ctx.addToEnvironment("java.naming.factory.url.pkgs", urlPackagePrefixes);
            }
        } else {
            String message = "The value of property java.naming.factory.url.pkgs is not a string.";
            ConfigurationException ce = new ConfigurationException(message);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateContextEnv", ce);
            }
            throw ce;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "updateContextEnv", "java.naming.factory.url.pkgs=" + env.get("java.naming.factory.url.pkgs"));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateContextEnv");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('@');
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("[_implClassName=");
        stringBuffer.append(_implClassName);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/websphere/naming/genericURLInitialContextFactory.java, WAS.naming, WAS70.SERV1, cf050925.09, ver. 1.29");
        }
        CLASS_NAME = genericURLInitialContextFactory.class.getName();
        _implClass = null;
        _implClassName = null;
        _implClassCtor = null;
    }
}

