/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.naming;

import com.ibm.WsnOptimizedNaming.WsnBindingCategory;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.CannotInstantiateObjectException;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.jndicos.CNContext;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.InvalidObjectException;
import com.ibm.ws.naming.util.RetryableAction;
import com.ibm.ws.naming.util.UnresolvedURLException;
import com.ibm.ws.naming.util.WsnBinding;
import com.ibm.ws.util.StringUtils;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NamingContext;

public class DumpNameSpace {
    private static final TraceComponent _tc = Tr.register(DumpNameSpace.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    @Deprecated
    public static final int SHORT = 1;
    @Deprecated
    public static final int LONG = 2;
    public static final int NORMAL_EXIT_STATUS = 0;
    public static final int BAD_EXIT_STATUS_NO_STARTING_CONTEXT = 1;
    public static final int BAD_EXIT_STATUS_WITH_ERROR = 2;
    public static final int BAD_EXIT_STATUS_WITH_BAD_OPTION = 3;
    private static final int NS_TYPE_GENERIC = -1;
    private static final int NS_TYPE_WS40 = 0;
    private static final int NS_TYPE_WS50 = 1;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_PORT = "2809";
    private static final String PARAM_PREFIX = "-";
    private static final String BLANK_LINE = " ";
    private static final String INDENT_AMOUNT = "   ";
    private static final String COMPONENT_SEPARATOR = "/";
    public static final String BUNDLE_NAME = "com.ibm.websphere.naming.DumpNameSpaceMessages";
    private static ResourceBundle _resourceBundle;
    private static Mode _mode;
    private PrintStream _out = null;
    private String _factory = "com.ibm.websphere.naming.WsnInitialContextFactory";
    private String _providerUrl = null;
    private String _hostname = "localhost";
    private String _port = "2809";
    private String _url = "";
    private String _principal = null;
    private String _credentials = null;
    private String _startAt = "";
    private boolean _rootOpt = false;
    private String _root = "cellroot";
    private String _rootMsg = "cell";
    private String _nameSyntax = "jndi";
    private ReportFormat _reportFormat = ReportFormat.SHORT;
    private String _topLabel = null;
    private long _seq = 0L;
    private String _seqNum = null;
    private Map<String, ContextInfo> _visitedCxtNames = null;
    private Map<String, ContextInfo> _visitedCxtUuids = null;

    public static void main(String[] arguments) {
        int status = 0;
        DumpNameSpace.setResourceBundle();
        DumpNameSpace dumpNameSpace = new DumpNameSpace();
        if (dumpNameSpace.parseArguments(arguments)) {
            Context startingContext = dumpNameSpace.getStartingContext();
            if (startingContext != null) {
                try {
                    dumpNameSpace.printCmdLineHeader();
                    dumpNameSpace.doGenerateDump(startingContext);
                }
                catch (Exception e) {
                    dumpNameSpace.writeException(e);
                    status = 2;
                }
            } else {
                status = 1;
            }
        } else {
            status = 3;
        }
        System.exit(status);
    }

    private static int getNameServerType(Context ctx) {
        CNContext cnCtx;
        NamingContext cosCtx;
        int nsType = -1;
        if (ctx instanceof CNContext && (cosCtx = (cnCtx = (CNContext)ctx).getCosContext()) instanceof com.ibm.WsnOptimizedNaming.NamingContext) {
            final com.ibm.WsnOptimizedNaming.NamingContext wsnCtx = (com.ibm.WsnOptimizedNaming.NamingContext)cosCtx;
            nsType = CommonHelpers.retry(new RetryableAction<Integer>(){

                @Override
                public Integer run() {
                    return wsnCtx.get_compatibility_level();
                }
            });
        }
        return nsType;
    }

    private static void setResourceBundle() {
        if (_resourceBundle == null) {
            _resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        }
    }

    public DumpNameSpace() {
        this(System.out, ReportFormat.SHORT);
    }

    @Deprecated
    public DumpNameSpace(PrintStream outStream, int reportFormat) {
        this(outStream, reportFormat == 2 ? ReportFormat.LONG : ReportFormat.SHORT);
    }

    public DumpNameSpace(PrintStream outStream, ReportFormat reportFormat) {
        this._out = outStream != null ? outStream : System.out;
        this._reportFormat = reportFormat;
        DumpNameSpace.setResourceBundle();
        this._topLabel = DumpNameSpace.fmtMsg("top");
        this.initForEachDump();
    }

    private void initForEachDump() {
        this._visitedCxtNames = new HashMap<String, ContextInfo>();
        this._visitedCxtUuids = new HashMap<String, ContextInfo>();
        this._seq = 0L;
        this._seqNum = null;
    }

    private boolean parseArguments(String[] arguments) {
        boolean successful = true;
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i].equals("-host")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._hostname = arguments[++i];
                continue;
            }
            if (arguments[i].equals("-port")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._port = arguments[++i];
                continue;
            }
            if (arguments[i].equals("-user") || arguments[i].equals("-username")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._principal = arguments[++i];
                continue;
            }
            if (arguments[i].equals("-password")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._credentials = arguments[++i];
                continue;
            }
            if (arguments[i].equals("-url")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._url = arguments[++i];
                continue;
            }
            if (arguments[i].equals("-factory")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._factory = arguments[++i];
                continue;
            }
            if (arguments[i].equals("-startAt")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._startAt = arguments[++i];
                continue;
            }
            if (arguments[i].equals("-report")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) {
                    this.println(DumpNameSpace.fmtMsg("reportOptBad"));
                    continue;
                }
                if (arguments[++i].equals("short")) {
                    this._reportFormat = ReportFormat.SHORT;
                    continue;
                }
                if (arguments[i].equals("long")) {
                    this._reportFormat = ReportFormat.LONG;
                    continue;
                }
                this.println(DumpNameSpace.fmtMsg("reportOptBad"));
                continue;
            }
            if (arguments[i].equals("-mode")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) continue;
                if (arguments[++i].equals("ws40")) {
                    _mode = Mode.WS40;
                    continue;
                }
                if (arguments[i].equals("ws50")) {
                    _mode = Mode.WS50;
                    continue;
                }
                this.println(DumpNameSpace.fmtMsg("modeOptBad"));
                continue;
            }
            if (arguments[i].equals("-root")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) {
                    this.println(DumpNameSpace.fmtMsg("treeOptBad"));
                    continue;
                }
                this._rootOpt = true;
                if (arguments[++i].equals("tree")) {
                    this._root = "treeinfrastructureroot";
                    this._rootMsg = "tree";
                    continue;
                }
                if (arguments[i].equals("host")) {
                    this._root = "bootstraphostroot";
                    this._rootMsg = "host";
                    continue;
                }
                if (arguments[i].equals("legacy")) {
                    this._root = "legacydomainroot";
                    this._rootMsg = "legacy";
                    continue;
                }
                if (arguments[i].equals("node")) {
                    this._root = "bootstraphostroot";
                    this._rootMsg = "node";
                    continue;
                }
                if (arguments[i].equals("server")) {
                    this._root = "bootstrapserverroot";
                    this._rootMsg = "server";
                    continue;
                }
                if (arguments[i].equals("cell")) {
                    this._root = "cellroot";
                    this._rootMsg = "cell";
                    continue;
                }
                if (arguments[i].equals("default")) {
                    this._root = "defaultroot";
                    this._rootMsg = "default";
                    continue;
                }
                this.println(DumpNameSpace.fmtMsg("treeOptBad"));
                this._rootOpt = false;
                continue;
            }
            if (arguments[i].equals("-format")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) {
                    this.println(DumpNameSpace.fmtMsg("formatOptBad", new String[]{"jndi", "ins"}));
                    continue;
                }
                if (arguments[++i].equals("jndi") || arguments[i].equals("ins")) {
                    this._nameSyntax = arguments[i];
                    continue;
                }
                this.println(DumpNameSpace.fmtMsg("formatOptBad", new String[]{"jndi", "ins"}));
                continue;
            }
            if (arguments[i].equals("-traceString")) {
                if (i + 1 >= arguments.length || arguments[i + 1].startsWith(PARAM_PREFIX)) continue;
                ManagerAdmin.configureClientTrace(arguments[++i], "named file", "DumpNameSpaceTrace.out", false, "basic", false);
                continue;
            }
            if (arguments[i].equals("-?") || arguments[i].equals("?") || arguments[i].equals("-help") || arguments[i].equals("help")) {
                DumpNameSpace.printHelp();
                successful = false;
                continue;
            }
            this.println("\n" + DumpNameSpace.fmtMsg("optionBad", new String[]{arguments[i]}));
            successful = false;
        }
        if (this._url.length() > 0) {
            this._rootMsg = BLANK_LINE;
        }
        if (this._url.length() > 0) {
            this._providerUrl = this._url;
        } else {
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append("corbaloc:iiop:");
            stringBuilder.append(CommonHelpers.normalizeHostForUrl(this._hostname));
            stringBuilder.append(':');
            stringBuilder.append(this._port);
            this._providerUrl = stringBuilder.toString();
        }
        if (_mode == Mode.WS40 && (this._root == "bootstrapserverroot" || this._root == "cellroot")) {
            this._root = "legacydomainroot";
            this._rootMsg = "legacy";
        }
        return successful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getStartingContext() {
        Context startingContext = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this._factory);
        env.put("java.naming.provider.url", this._providerUrl);
        if (this._principal != null) {
            env.put("java.naming.security.principal", this._principal);
        }
        if (this._credentials != null) {
            env.put("java.naming.security.credentials", this._credentials);
        }
        env.put("com.ibm.websphere.naming.namespaceroot", this._root);
        env.put("com.ibm.websphere.naming.name.syntax", this._nameSyntax);
        env.put("com.ibm.websphere.naming.namespace.connection", "eager");
        this.println("");
        this.println(DumpNameSpace.fmtMsg("gettingInitCtx"));
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(env);
            if (_mode == Mode.NOT_SET) {
                int nsType = DumpNameSpace.getNameServerType((Context)initialContext.lookup(""));
                switch (nsType) {
                    case -1: 
                    case 0: {
                        _mode = Mode.WS40;
                        if (!this._rootOpt) {
                            this._root = "legacydomainroot";
                            this._rootMsg = "legacy";
                        }
                        env.put("com.ibm.websphere.naming.namespaceroot", this._root);
                        CommonHelpers.closeIfContext(initialContext);
                        initialContext = new InitialContext(env);
                        break;
                    }
                    case 1: {
                        _mode = Mode.WS50;
                        break;
                    }
                    default: {
                        _mode = Mode.WS50;
                    }
                }
            }
            this.println(DumpNameSpace.fmtMsg("gettingStartCtx"));
            startingContext = (Context)initialContext.lookup(this._startAt);
            try {
                this._startAt = startingContext.getNameInNamespace();
            }
            catch (NamingException ex) {
                // empty catch block
            }
        }
        catch (Exception e) {
            try {
                this.writeException(e);
            }
            catch (Throwable throwable) {
                CommonHelpers.closeIfContext(initialContext);
                throw throwable;
            }
            CommonHelpers.closeIfContext(initialContext);
        }
        CommonHelpers.closeIfContext(initialContext);
        return startingContext;
    }

    private void printCmdLineHeader() {
        String indentation = INDENT_AMOUNT;
        this.println(BLANK_LINE);
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(DumpNameSpace.fmtMsg("nsDump"));
        this.println(indentation + DumpNameSpace.fmtMsg("ctxFactory", new String[]{this._factory}));
        this.println(indentation + DumpNameSpace.fmtMsg("providerUrl", new String[]{this._providerUrl}));
        this.println(indentation + DumpNameSpace.fmtMsg("rootCtx", new String[]{this._rootMsg}));
        if (this._startAt.equals("")) {
            this.println(indentation + DumpNameSpace.fmtMsg("startingCtxRoot"));
        } else {
            this.println(indentation + DumpNameSpace.fmtMsg("startingCtx", new String[]{this._startAt}));
        }
        this.println(indentation + DumpNameSpace.fmtMsg("fmtRules", new String[]{this._nameSyntax}));
        this.println(indentation + DumpNameSpace.fmtMsg("dumpTime", new String[]{new Date().toString()}));
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(BLANK_LINE);
    }

    public void generateDump(Context ctx) {
        this.printApiHeader(ctx);
        this.doGenerateDump(ctx);
    }

    private void doGenerateDump(Context ctx) {
        this.initForEachDump();
        this.println(BLANK_LINE);
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(DumpNameSpace.fmtMsg("startDump"));
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(BLANK_LINE);
        this.dumpContext(this._topLabel, ctx, "", null, null, null);
        this.println(BLANK_LINE);
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(DumpNameSpace.fmtMsg("endDump"));
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(BLANK_LINE);
    }

    private void printApiHeader(Context ctx) {
        String indentation = INDENT_AMOUNT;
        this.println(BLANK_LINE);
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(DumpNameSpace.fmtMsg("nsDump"));
        String top = DumpNameSpace.fmtMsg("topNotAvail");
        try {
            top = ctx.getNameInNamespace();
        }
        catch (NamingException e) {
            // empty catch block
        }
        this.println(indentation + DumpNameSpace.fmtMsg("startingCtx", new String[]{top}));
        this.println(indentation + DumpNameSpace.fmtMsg("dumpTime", new String[]{new Date().toString()}));
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(BLANK_LINE);
    }

    private void dumpContext(String ctxName, Context ctx, String ctxBoundClass, String linktoMsg, BindingType corbaBindingType, String errorMessage) {
        boolean isDistNC = false;
        if (ctx instanceof CNContext) {
            CNContext cnCtx = (CNContext)ctx;
            NamingContext cosCtx = cnCtx.getCosContext();
            try {
                isDistNC = CommonHelpers.isDistributedNC(cosCtx);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.printBinding(ctxName, ctx, ctxBoundClass, errorMessage, linktoMsg, BindingType.ncontext, null);
        boolean alreadyDumped = this.contextWasAlreadyDumped(ctx, ctxName);
        if (!alreadyDumped) {
            try {
                NamingEnumeration<Binding> bindingList = ctx.listBindings("");
                while (bindingList.hasMore()) {
                    NameClassPair ncp;
                    Binding binding = null;
                    String bindingName = null;
                    String boundClass = null;
                    Object boundObject = null;
                    corbaBindingType = null;
                    WsnBinding wsbd = null;
                    int wsnBindingType = -1;
                    WsnBindingCategory wsnBindingCat = null;
                    Reference referenceObject = null;
                    errorMessage = null;
                    linktoMsg = null;
                    try {
                        binding = bindingList.next();
                        bindingName = binding.getName();
                        boundClass = binding.getClassName();
                        boundObject = binding.getObject();
                        if (binding instanceof WsnBinding) {
                            wsbd = (WsnBinding)binding;
                            corbaBindingType = wsbd.getCorbaBindingType();
                            wsnBindingType = wsbd.getWsnContextBindingType();
                            referenceObject = wsbd.getBoundReference();
                            if (isDistNC) {
                                String linkinfo;
                                wsnBindingCat = wsbd.getBindingCategory();
                                if (wsnBindingCat == WsnBindingCategory.CONTEXT_LINKED && boundObject instanceof Context) {
                                    linkinfo = ((Context)boundObject).getNameInNamespace();
                                    linktoMsg = DumpNameSpace.fmtMsg("linkedto", new String[]{linkinfo});
                                }
                                if (wsnBindingCat == WsnBindingCategory.CONTEXT_URL) {
                                    linkinfo = wsbd.getBindingURL();
                                    linktoMsg = DumpNameSpace.fmtMsg("linkedtourl", new String[]{linkinfo});
                                }
                            }
                        }
                    }
                    catch (CannotInstantiateObjectException e) {
                        if (this._reportFormat != ReportFormat.SHORT) {
                            errorMessage = DumpNameSpace.fmtMsg("noInstErr");
                        }
                        if ((ncp = e.getNameClassPair()) != null) {
                            bindingName = ncp.getName();
                            boundClass = ncp.getClassName();
                        }
                        referenceObject = e.getReference();
                    }
                    catch (InvalidObjectException e) {
                        errorMessage = DumpNameSpace.fmtMsg("namingErr", new String[]{e.toString()});
                        InvalidObjectException ioe = e;
                        NameClassPair ncp2 = ioe.getNameClassPair();
                        if (ncp2 != null) {
                            bindingName = ncp2.getName();
                            boundClass = ncp2.getClassName();
                        }
                    }
                    catch (UnresolvedURLException e) {
                        if (this._reportFormat == ReportFormat.SHORT) {
                            linktoMsg = DumpNameSpace.fmtMsg("linkedtourl", new String[]{e.getURL()});
                        } else {
                            errorMessage = DumpNameSpace.fmtMsg("unresolvedURLErr", new String[]{e.getURL(), bindingName});
                        }
                        ncp = e.getNameClassPair();
                        if (ncp != null) {
                            bindingName = ncp.getName();
                            boundClass = ncp.getClassName();
                        }
                    }
                    catch (NamingException e) {
                        errorMessage = DumpNameSpace.fmtMsg("namingErr", new String[]{e.toString()});
                    }
                    String fullName = null;
                    fullName = bindingName != null ? ctxName + COMPONENT_SEPARATOR + bindingName : DumpNameSpace.fmtMsg("bindingNameNotAvail");
                    if (boundClass == null || boundClass.length() == 0) {
                        boundClass = DumpNameSpace.fmtMsg("classNameNotAvail");
                    }
                    if (boundObject instanceof Context && ((corbaBindingType == null || corbaBindingType == BindingType.ncontext) && wsnBindingType != 1 || _mode == Mode.WS40)) {
                        this.dumpContext(fullName, (Context)boundObject, boundClass, linktoMsg, corbaBindingType, errorMessage);
                        continue;
                    }
                    this.printBinding(fullName, boundObject, boundClass, errorMessage, linktoMsg, corbaBindingType, referenceObject);
                }
            }
            catch (NamingException e) {
                this.println(DumpNameSpace.fmtMsg("listErr", new String[]{ctxName, e.toString()}));
            }
        }
    }

    private boolean contextWasAlreadyDumped(Context ctx, String ctxName) {
        if (ctxName.endsWith("nodeSystemNameSpaceRoot")) {
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("nodeSNSRoot"));
            return true;
        }
        if (ctx instanceof UuidContext) {
            UuidContext uuidCtx = (UuidContext)((Object)ctx);
            String ctxID = ((Object)uuidCtx.getContextID()).toString();
            ContextInfo ctxInfo = this._visitedCxtUuids.get(ctxID);
            if (ctxInfo == null) {
                ctxInfo = new ContextInfo(this._seqNum, ctxName);
                this._visitedCxtUuids.put(ctxID.toString(), ctxInfo);
                return false;
            }
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("revisitedCtx"));
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("forCtxInfoSee", new String[]{ctxInfo._sequence, ctxInfo._contextName}));
            return true;
        }
        String ctxNINS = null;
        try {
            ctxNINS = ctx.getNameInNamespace();
        }
        catch (Exception e) {
            this.println(DumpNameSpace.fmtMsg("getNameErr", new String[]{e.toString()}));
        }
        ContextInfo ctxInfo = this._visitedCxtNames.get(ctxNINS);
        if (ctxInfo == null) {
            ctxInfo = new ContextInfo(this._seqNum, ctxName);
            this._visitedCxtNames.put(ctxNINS, ctxInfo);
            return false;
        }
        this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("revisitedCtx"));
        this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("forCtxInfoSee", new String[]{ctxInfo._sequence, ctxInfo._contextName}));
        return true;
    }

    private void printBinding(String fullName, Object boundObj, String boundClassName, String errorMessage, String linktoMsg, BindingType corbaBindingType, Reference referenceObject) {
        this._seqNum = this.getNextSeqNum();
        if (this._reportFormat == ReportFormat.SHORT) {
            String paddedName = this.getPaddedString(fullName, 50);
            if (paddedName.length() <= 50) {
                this.println(this._seqNum + paddedName + BLANK_LINE + boundClassName);
            } else {
                this.println(this._seqNum + paddedName);
                this.println(this._seqNum + this.getPaddedString(BLANK_LINE, 51) + boundClassName);
            }
            if (errorMessage != null) {
                this.println(this._seqNum + INDENT_AMOUNT + errorMessage);
            }
            if (linktoMsg != null && linktoMsg.length() > 0) {
                this.println(this._seqNum + INDENT_AMOUNT + linktoMsg);
            }
        } else if (this._reportFormat == ReportFormat.LONG) {
            String localClass = DumpNameSpace.fmtMsg("null");
            String objToString = "";
            if (boundObj != null) {
                localClass = boundObj.getClass().getName();
                objToString = boundObj.toString();
            }
            this.println(BLANK_LINE);
            this.println(this._seqNum + fullName);
            if (errorMessage != null) {
                this.println(this._seqNum + INDENT_AMOUNT + errorMessage);
            }
            if (linktoMsg != null && linktoMsg.length() > 0) {
                this.println(this._seqNum + INDENT_AMOUNT + linktoMsg);
            }
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("boundType", new String[]{boundClassName}));
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("localType", new String[]{localClass}));
            if (corbaBindingType != null) {
                String corbaTypeStr = null;
                corbaTypeStr = corbaBindingType == BindingType.ncontext ? "org.omg.CosNaming.BindingType.ncontext" : "org.omg.CosNaming.BindingType.nobject";
                this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("corbaType", new String[]{corbaTypeStr}));
            }
            if (boundObj instanceof UuidContext) {
                UuidContext uuidCtx = (UuidContext)boundObj;
                String ctxID = ((Object)uuidCtx.getContextID()).toString();
                this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("ctxId", new String[]{ctxID}));
            }
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("objToString", new String[]{objToString}));
            if (referenceObject != null) {
                String refFactClassLoc;
                this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("srcObjIsRef"));
                String refFactClassName = referenceObject.getFactoryClassName();
                if (refFactClassName != null && refFactClassName.length() > 0) {
                    this.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refFactClass", new String[]{refFactClassName}));
                }
                if ((refFactClassLoc = referenceObject.getFactoryClassLocation()) != null && refFactClassLoc.length() > 0) {
                    this.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refFactLoc", new String[]{refFactClassLoc}));
                }
                Enumeration<RefAddr> addrs = referenceObject.getAll();
                int refAddrIndex = 0;
                while (addrs.hasMoreElements()) {
                    RefAddr refAddr = addrs.nextElement();
                    if (refAddr != null) {
                        this.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refAddrString", new String[]{Integer.toString(refAddrIndex), refAddr.toString()}));
                    } else {
                        this.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refAddrNull", new String[]{Integer.toString(refAddrIndex)}));
                    }
                    ++refAddrIndex;
                }
            }
        }
    }

    private String getNextSeqNum() {
        ++this._seq;
        if (this._seq > 99999L) {
            this._seq = 0L;
        }
        StringBuilder sb = new StringBuilder(6);
        sb.insert(0, BLANK_LINE);
        sb.insert(0, this._seq);
        while (sb.length() < 6) {
            sb.insert(0, BLANK_LINE);
        }
        return sb.toString();
    }

    private String getPaddedString(String str, int paddedLength) {
        int strLength = str.length();
        if (strLength >= paddedLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(paddedLength);
        sb.insert(0, str);
        for (int i = strLength; i < paddedLength; ++i) {
            sb.insert(i, BLANK_LINE);
        }
        return sb.toString();
    }

    private void writeException(Exception e) {
        this.println(DumpNameSpace.fmtMsg("icErr"));
        this.println(DumpNameSpace.fmtMsg("xcptInfo", new String[]{e.toString()}));
        e.printStackTrace(this._out);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_factory=");
        stringBuilder.append(this._factory);
        stringBuilder.append(", _providerUrl=");
        stringBuilder.append(this._providerUrl);
        stringBuilder.append(", _hostname=");
        stringBuilder.append(this._hostname);
        stringBuilder.append(", _port=");
        stringBuilder.append(this._port);
        stringBuilder.append(", _url=");
        stringBuilder.append(this._url);
        stringBuilder.append(", _principal=");
        stringBuilder.append(this._principal);
        stringBuilder.append(", _credentials=");
        stringBuilder.append(StringUtils.maskPassword(this._credentials));
        stringBuilder.append(", _startAt=");
        stringBuilder.append(this._startAt);
        stringBuilder.append(", _rootOpt=");
        stringBuilder.append(this._rootOpt);
        stringBuilder.append(", _root=");
        stringBuilder.append(this._root);
        stringBuilder.append(", _rootMsg=");
        stringBuilder.append(this._rootMsg);
        stringBuilder.append(", _nameSyntax=");
        stringBuilder.append(this._nameSyntax);
        stringBuilder.append(", _reportFormat=");
        stringBuilder.append((Object)this._reportFormat);
        stringBuilder.append(", _topLabel=");
        stringBuilder.append(this._topLabel);
        stringBuilder.append(", _seq=");
        stringBuilder.append(this._seq);
        stringBuilder.append(", _seqNum=");
        stringBuilder.append(this._seqNum);
        stringBuilder.append(", _visitedCxtNames=");
        stringBuilder.append(this._visitedCxtNames);
        stringBuilder.append(", _visitedCxtUuids=");
        stringBuilder.append(this._visitedCxtUuids);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static String fmtMsg(String msgKey) {
        return DumpNameSpace.fmtMsg(msgKey, null);
    }

    private static String fmtMsg(String msgKey, String[] inserts) {
        String msg = null;
        try {
            if (_resourceBundle != null) {
                return MessageFormat.format(_resourceBundle.getString(msgKey), inserts);
            }
            msg = "Message table not found.";
        }
        catch (MissingResourceException e) {
            msg = "Message or message table not found.";
        }
        return msg;
    }

    private static void printHelp() {
        System.out.println(BLANK_LINE);
        System.out.println(DumpNameSpace.fmtMsg("sepLine"));
        System.out.println(DumpNameSpace.fmtMsg("cmdLineUsage"));
        System.out.println(DumpNameSpace.fmtMsg("sepLine"));
    }

    private void println(String line) {
        this._out.println(line);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "println", line);
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/websphere/naming/DumpNameSpace.java, WAS.naming, WAS70.SERV1, cf050925.09, ver. 1.57");
        }
        _resourceBundle = null;
        _mode = Mode.NOT_SET;
    }

    private static class ContextInfo {
        final String _contextName;
        final String _sequence;

        ContextInfo(String sequence, String contextName) {
            this._contextName = contextName;
            this._sequence = sequence;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        NOT_SET,
        WS40,
        WS50;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportFormat {
        LONG,
        SHORT;

    }
}

