/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.util;

import com.ibm.websphere.models.util.TypeCoercionUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.impl.DynamicEDataObjectImpl;

public class MapDataObjectImpl
extends DynamicEDataObjectImpl
implements Map {
    private static final long serialVersionUID = 1L;

    public MapDataObjectImpl(EClass eClass) {
        super(eClass);
    }

    public int size() {
        return this.eClass.getEAllStructuralFeatures().size();
    }

    public void clear() {
        for (EStructuralFeature feature : this.eClass.getEAllStructuralFeatures()) {
            this.eUnset(feature);
        }
    }

    public boolean isEmpty() {
        return this.eClass.getEAllStructuralFeatures().size() == 0;
    }

    public boolean containsKey(Object key) {
        EStructuralFeature feature = this.getFeature(key);
        return feature != null;
    }

    public boolean containsValue(Object value) {
        for (EStructuralFeature feature : this.eClass.getEAllStructuralFeatures()) {
            Object testValue = this.getValue(feature);
            if ((value != null || testValue != null) && (value == null || !value.equals(testValue))) continue;
            return true;
        }
        return false;
    }

    public Collection values() {
        ArrayList<Object> values = new ArrayList<Object>(this.size());
        for (EStructuralFeature feature : this.eClass.getEAllStructuralFeatures()) {
            Object testValue = this.getValue(feature);
            values.add(testValue);
        }
        return values;
    }

    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        HashSet set = new HashSet(){
            private static final long serialVersionUID = 1L;

            public boolean remove(Object o) {
                boolean ret = this.contains(o);
                if (ret) {
                    MapDataObjectImpl.this.remove(o);
                }
                return ret;
            }

            public void clear() {
                MapDataObjectImpl.this.clear();
            }

            public boolean removeAll(Collection c) {
                boolean changed = false;
                if (c != null) {
                    for (Object element : c) {
                        if (!this.contains(element)) continue;
                        MapDataObjectImpl.this.remove(element);
                        changed = true;
                    }
                }
                return changed;
            }
        };
        EList attributes = this.eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : attributes) {
            EEntry entry = new EEntry(feature);
            set.add(entry);
        }
        return set;
    }

    public Set keySet() {
        HashSet<String> set = new HashSet<String>();
        EList attributes = this.eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : attributes) {
            set.add(feature.getName());
        }
        return set;
    }

    public Object get(Object key) {
        EStructuralFeature feature = this.getFeature(key);
        return feature == null ? null : this.getValue(feature);
    }

    public Object remove(Object key) {
        EStructuralFeature feature = this.getFeature(key);
        Object oldValue = null;
        if (feature != null) {
            oldValue = this.getValue(feature);
            this.eUnset(feature);
        }
        return oldValue;
    }

    public Object put(Object key, Object value) {
        EStructuralFeature feature = this.getFeature(key);
        Object oldValue = null;
        if (feature != null) {
            try {
                oldValue = this.getValue(feature);
                this.putValue(feature, value);
            }
            catch (ClassCastException th) {
                this.putValue(feature, TypeCoercionUtil.coerceType(feature.getEType().getInstanceClassName(), value));
            }
        }
        return oldValue;
    }

    protected EStructuralFeature getFeature(Object key) {
        if (key instanceof String) {
            return this.eClass().getEStructuralFeature((String)key);
        }
        if (key instanceof Integer) {
            return (EStructuralFeature)this.eClass.getEAllStructuralFeatures().get((Integer)key);
        }
        if (key instanceof EStructuralFeature) {
            return (EStructuralFeature)key;
        }
        return null;
    }

    protected Object getValue(EStructuralFeature feature) {
        Object[] result = this.eGet(feature);
        if (feature.isMany()) {
            List list = (List)result;
            int len = list.size();
            if (feature instanceof EAttribute) {
                Class type = feature.getEType().getInstanceClass();
                result = list.toArray((Object[])Array.newInstance(type, len));
            } else {
                result = list.toArray(new Map[len]);
            }
        }
        return result;
    }

    protected void putValue(EStructuralFeature feature, Object value) {
        if (feature.isMany()) {
            Object[] array = (Object[])value;
            List list = (List)this.eGet(feature);
            list.clear();
            for (int x = 0; x < array.length; ++x) {
                list.add(array[x]);
            }
        } else {
            this.eSet(feature, value);
        }
    }

    protected class EEntry
    implements Map.Entry {
        private EStructuralFeature fFeature;

        public EEntry(EStructuralFeature feature) {
            this.fFeature = feature;
        }

        public Object getKey() {
            return this.fFeature.getName();
        }

        public Object getValue() {
            return MapDataObjectImpl.this.get(this.getKey());
        }

        public Object setValue(Object value) {
            return MapDataObjectImpl.this.put(this.getKey(), value);
        }
    }
}

