/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.proxy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class LoadBalancingAlgorithmKind
extends AbstractEnumerator {
    public static final int RANDOM = 0;
    public static final int WEIGHTED_ROUND_ROBIN = 1;
    public static final LoadBalancingAlgorithmKind RANDOM_LITERAL = new LoadBalancingAlgorithmKind(0, "RANDOM", "RANDOM");
    public static final LoadBalancingAlgorithmKind WEIGHTED_ROUND_ROBIN_LITERAL = new LoadBalancingAlgorithmKind(1, "WEIGHTED_ROUND_ROBIN", "WEIGHTED_ROUND_ROBIN");
    private static final LoadBalancingAlgorithmKind[] VALUES_ARRAY = new LoadBalancingAlgorithmKind[]{RANDOM_LITERAL, WEIGHTED_ROUND_ROBIN_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static LoadBalancingAlgorithmKind get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LoadBalancingAlgorithmKind result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static LoadBalancingAlgorithmKind getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LoadBalancingAlgorithmKind result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static LoadBalancingAlgorithmKind get(int value) {
        switch (value) {
            case 0: {
                return RANDOM_LITERAL;
            }
            case 1: {
                return WEIGHTED_ROUND_ROBIN_LITERAL;
            }
        }
        return null;
    }

    private LoadBalancingAlgorithmKind(int value, String name, String literal) {
        super(value, name, literal);
    }
}

