/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;

public class SecurityAuditingHelper {
    private static TraceComponent tc = Tr.register(SecurityAuditingHelper.class, "SecurityAuditingHelper", "com.ibm.websphere.management.authorizer");
    private static SecurityAuditingHelper secAuditHepler = new SecurityAuditingHelper();
    private static AuditService auditService = null;
    public static final String SA_ACTION_EXECUTE_COMMAND = "execute command";
    public static final String SA_ACTION_CREATE_SESSION = "create session";
    public static final String SA_ACTION_SAVE_SESSION = "save session";
    public static final String SA_ACTION_DISCARD_SESSION = "discard session";
    public static final String SA_ACTION_PROCESS_PARAM = "process task parameters";
    public static final String SA_ACTION_PREINVOKE_MBEAN = "preinvoke MBean";
    public static final String SA_ACTION_RESOURCE_ADDED = "add resource";
    public static final String SA_ACTION_RESOURCE_MODIFIED = "modify resource";
    public static final String SA_ACTION_RESOURCE_DELETED = "delete resource";
    public static final String SA_ACTION_RESOURCE_ACCESS = "access resource";
    private static final String SA_RES_TYPE_COMMAND = "SM_COMMAND";
    private static final String SA_RES_TYPE_SESSION = "SM_SESSION";
    private static final String SA_RES_TYPE_MBEAN = "SM_MBEAN";
    private static final String SA_RES_TYPE_REPOSITORY = "SM_REPOSITORY";
    private static final String SA_VALUE_NOT_AVAILABLE = "N/A";

    private SecurityAuditingHelper() {
    }

    private static void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize, auditService: " + auditService);
        }
        if (auditService == null) {
            auditService = ContextManagerFactory.getInstance().getAuditService();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize, auditService: " + auditService);
        }
    }

    private ContextHandler getContextHandler() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextHandler, auditService: " + auditService);
        }
        ContextHandler contextHandler = null;
        if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
            Manager.Ffdc.log(new NullPointerException("AuditService returns a null ContextHandler object."), secAuditHepler, "com.ibm.websphere.management.authorizer.SecurityAuditingHelper", "80");
            String msg = "security.audit.service.context.error";
            Tr.error(tc, msg);
            auditService.processAuditFailure(msg, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextHandler, auditService: " + auditService + ", returns contextHandler: " + contextHandler);
        }
        return contextHandler;
    }

    public static SecurityAuditingHelper getInstance() {
        SecurityAuditingHelper.initialize();
        return secAuditHepler;
    }

    public void logSecurityAuditForCommand(boolean success, String className, String cmdName, String sessionId, String action, List requiredRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logSecurityAuditForCommand, cmdName: " + cmdName, new Object[]{success, className, cmdName, sessionId, action, requiredRoles});
        }
        String result = null;
        String outcome = null;
        String failureReason = null;
        long outcomeReason = 0L;
        String url = SA_VALUE_NOT_AVAILABLE;
        if (success) {
            result = "SUCCESSFUL";
            outcome = "SUCCESS";
            failureReason = "SUCCESS";
            outcomeReason = 6L;
        } else {
            result = "UNSUCCESSFUL";
            outcome = "DENIED";
            failureReason = "DENIED";
            outcomeReason = 17L;
        }
        if (tc.isDebugEnabled() && auditService != null) {
            Tr.debug(tc, "isEventRequired for SECURITY_RESOURCE_ACCESS? SUCCESS: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS") + ", DENIED: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "DENIED") + ", INFO: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "INFO") + ", ERROR: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "ERROR"));
        }
        ContextHandler contextHandler = this.getContextHandler();
        if (auditService != null && contextHandler != null && auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", outcome)) {
            String[] rolesChecked = requiredRoles.toArray(new String[requiredRoles.size()]);
            if (rolesChecked.length == 0) {
                rolesChecked = new String[]{SA_VALUE_NOT_AVAILABLE};
            }
            this.setDefaultContextData(contextHandler);
            this.setSessionContextData(contextHandler, sessionId);
            this.setAccessContextData(contextHandler, success, className, cmdName, action, SA_RES_TYPE_COMMAND, rolesChecked);
            this.setResponseContextData(contextHandler, url);
            ConcurrentHashMap auditOutcome = DataHelper.buildOutcomeData(result, new Integer(0), new Integer(0), failureReason, outcomeReason);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "auditOutcome: " + auditOutcome);
            }
            try {
                auditService.sendEvent("SECURITY_RESOURCE_ACCESS", auditOutcome);
            }
            catch (ProviderFailureException pfe) {
                Tr.error(tc, "logSecurityAuditForCommand, security.JSAS1503E", new Object[]{pfe});
                String failmsg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(failmsg, pfe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logSecurityAuditForCommand, cmdName: " + cmdName);
        }
    }

    public void logSecurityAuditForMBean(boolean success, ObjectName mBeanObjName, String methodName, String sessionId, String action) {
        this.logSecurityAuditForMBean(success, mBeanObjName, methodName, sessionId, action, null, null);
    }

    public void logSecurityAuditForMBean(boolean success, ObjectName mBeanObjName, String methodName, String sessionId, String action, String[] resNames, String[] resTypes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logSecurityAuditForMBean, MBeanName: " + mBeanObjName, new Object[]{success, mBeanObjName, methodName, sessionId, action, resNames, resTypes});
            Tr.debug(tc, "resNames: " + this.stringArrayToArrayList(resNames) + ", resTypes: " + this.stringArrayToArrayList(resTypes));
        }
        String result = null;
        String outcome = null;
        String failureReason = null;
        long outcomeReason = 0L;
        String url = SA_VALUE_NOT_AVAILABLE;
        if (success) {
            result = "SUCCESSFUL";
            outcome = "SUCCESS";
            failureReason = "SUCCESS";
            outcomeReason = 6L;
        } else {
            result = "UNSUCCESSFUL";
            outcome = "DENIED";
            failureReason = "DENIED";
            outcomeReason = 17L;
        }
        if (tc.isDebugEnabled() && auditService != null) {
            Tr.debug(tc, "isEventRequired for SECURITY_RESOURCE_ACCESS? SUCCESS: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS") + ", DENIED: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "DENIED") + ", INFO: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "INFO") + ", ERROR: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "ERROR"));
        }
        ContextHandler contextHandler = this.getContextHandler();
        if (auditService != null && contextHandler != null && auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", outcome)) {
            String[] rolesChecked = new String[]{SA_VALUE_NOT_AVAILABLE};
            String moduleName = ObjectNameHelper.getMBeanType(mBeanObjName);
            if (sessionId == null) {
                sessionId = SA_VALUE_NOT_AVAILABLE;
            }
            if (moduleName == null) {
                moduleName = mBeanObjName.toString();
            }
            if (ObjectNameHelper.getMBeanIdentifier(mBeanObjName).contains("/")) {
                moduleName = moduleName + " (module)";
            }
            this.setDefaultContextData(contextHandler);
            this.setSessionContextData(contextHandler, sessionId);
            int inx = methodName.indexOf("(");
            action = inx > 0 ? action + " " + moduleName + ":" + methodName.substring(0, inx) : action + " " + moduleName + ":" + methodName;
            this.setAccessContextData(contextHandler, success, moduleName, methodName, action, SA_RES_TYPE_MBEAN, rolesChecked);
            this.setResponseContextData(contextHandler, url);
            ConcurrentHashMap auditOutcome = DataHelper.buildOutcomeData(result, new Integer(0), new Integer(0), failureReason, outcomeReason);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "auditOutcome: " + auditOutcome);
            }
            try {
                auditService.sendEvent("SECURITY_RESOURCE_ACCESS", auditOutcome);
            }
            catch (ProviderFailureException pfe) {
                Tr.error(tc, "logSecurityAuditForMBean, security.JSAS1503E", new Object[]{pfe});
                String failmsg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(failmsg, pfe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logSecurityAuditForMBean, MBeanName: " + mBeanObjName);
        }
    }

    public void logSecurityAuditForRepository(boolean success, String className, String action, String userID, String url) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logSecurityAuditForRepository, url: " + url, new Object[]{success, action, userID, url});
        }
        String result = null;
        String outcome = null;
        String failureReason = null;
        long outcomeReason = 0L;
        String sessionId = SA_VALUE_NOT_AVAILABLE;
        if (success) {
            result = "SUCCESSFUL";
            if (action == SA_ACTION_RESOURCE_ACCESS) {
                outcome = "SUCCESS";
                failureReason = "SUCCESS";
                outcomeReason = 6L;
            } else {
                outcome = "INFO";
                failureReason = "INFO";
                outcomeReason = 6L;
            }
        } else {
            result = "UNSUCCESSFUL";
            if (action == SA_ACTION_RESOURCE_ACCESS) {
                outcome = "DENIED";
                failureReason = "DENIED";
                outcomeReason = 17L;
            } else {
                outcome = "ERROR";
                failureReason = "ERROR";
                outcomeReason = 14L;
            }
        }
        if (tc.isDebugEnabled() && auditService != null) {
            Tr.debug(tc, "isEventRequired for SECURITY_RESOURCE_ACCESS? SUCCESS: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS") + ", DENIED: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "DENIED") + ", INFO: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "INFO") + ", ERROR: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "ERROR"));
        }
        ContextHandler contextHandler = this.getContextHandler();
        if (auditService != null && contextHandler != null && auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", outcome)) {
            String[] rolesChecked = new String[]{userID};
            int pos = url.lastIndexOf(47);
            String resourceName = pos >= 0 ? url.substring(pos + 1) : url;
            this.setDefaultContextData(contextHandler);
            this.setSessionContextData(contextHandler, sessionId);
            this.setAccessContextData(contextHandler, success, className, resourceName, action, SA_RES_TYPE_REPOSITORY, rolesChecked);
            this.setResponseContextData(contextHandler, url);
            ConcurrentHashMap auditOutcome = DataHelper.buildOutcomeData(result, new Integer(0), new Integer(0), failureReason, outcomeReason);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "auditOutcome: " + auditOutcome);
            }
            try {
                auditService.sendEvent("SECURITY_RESOURCE_ACCESS", auditOutcome);
            }
            catch (ProviderFailureException pfe) {
                Tr.error(tc, "logSecurityAuditForRepository, security.JSAS1503E", new Object[]{pfe});
                String failmsg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(failmsg, pfe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logSecurityAuditForRepository, url: " + url);
        }
    }

    private void setDefaultContextData(ContextHandler contextHandler) {
        HashMap data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
        contextHandler.buildContextObject("EVENT_CONTEXT", data);
        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
        data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
        data = DataHelper.buildRegistryData(null);
        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
    }

    private void setSessionContextData(ContextHandler contextHandler, String sessionId) {
        HashMap data = DataHelper.buildSessionData(sessionId, null, null, null);
        contextHandler.buildContextObject("SESSION_CONTEXT", data);
    }

    private void setAccessContextData(ContextHandler contextHandler, boolean success, String progName, String cmdName, String action, String resourceType, String[] rolesChecked) {
        String accessDecision = success ? "authnSuccess" : "authnFailure";
        HashMap data = DataHelper.buildAccessData(progName, action, null, null, accessDecision, cmdName, resourceType, new Long(0L), null, null, rolesChecked, null);
        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
    }

    private void setResponseContextData(ContextHandler contextHandler, String url) {
        HashMap data = DataHelper.buildResponseData(url, null, null);
        contextHandler.buildContextObject("RESPONSE_CONTEXT", data);
    }

    private ArrayList stringArrayToArrayList(String[] stringArray) {
        ArrayList<String> result;
        block4: {
            result = new ArrayList<String>();
            try {
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        boolean success = result.add(stringArray[i]);
                        if (!tc.isDebugEnabled() || success) continue;
                        Tr.debug(tc, "stringArrayToArrayList, failed to add \"" + stringArray[i] + "\" to the result ArrayList.");
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "stringArrayToArrayList, got unexpected exception: " + e + ". The conversion result may not be correct.", e);
            }
        }
        return result;
    }

    public void logSecurityAuditForSession(boolean success, String className, String sessionId, String action, String userId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logSecurityAuditForSessoin", new Object[]{success, className, sessionId, action, userId});
        }
        String result = null;
        String outcome = null;
        String failureReason = null;
        long outcomeReason = 0L;
        String url = SA_VALUE_NOT_AVAILABLE;
        if (action.equals("create")) {
            action = SA_ACTION_CREATE_SESSION;
        } else if (action.equals("save")) {
            action = SA_ACTION_SAVE_SESSION;
        } else if (action.equals("discard")) {
            action = SA_ACTION_DISCARD_SESSION;
        }
        if (success) {
            result = "SUCCESSFUL";
            outcome = "SUCCESS";
            failureReason = "SUCCESS";
            outcomeReason = 6L;
        } else {
            result = "UNSUCCESSFUL";
            outcome = "DENIED";
            failureReason = "DENIED";
            outcomeReason = 17L;
        }
        if (tc.isDebugEnabled() && auditService != null) {
            Tr.debug(tc, "isEventRequired for SECURITY_RESOURCE_ACCESS? SUCCESS: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS") + ", DENIED: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "DENIED") + ", INFO: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "INFO") + ", ERROR: " + auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "ERROR"));
        }
        ContextHandler contextHandler = this.getContextHandler();
        if (auditService != null && contextHandler != null && auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", outcome)) {
            String[] rolesChecked = userId == null ? new String[]{SA_VALUE_NOT_AVAILABLE} : new String[]{userId};
            this.setDefaultContextData(contextHandler);
            this.setSessionContextData(contextHandler, sessionId);
            this.setAccessContextData(contextHandler, success, className, action, action, SA_RES_TYPE_SESSION, rolesChecked);
            this.setResponseContextData(contextHandler, url);
            ConcurrentHashMap auditOutcome = DataHelper.buildOutcomeData(result, new Integer(0), new Integer(0), failureReason, outcomeReason);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "auditOutcome: " + auditOutcome);
            }
            try {
                auditService.sendEvent("SECURITY_RESOURCE_ACCESS", auditOutcome);
            }
            catch (ProviderFailureException pfe) {
                Tr.error(tc, "logSecurityAuditForSession, security.JSAS1503E", new Object[]{pfe});
                String failmsg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(failmsg, pfe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logSecurityAuditForSession");
        }
    }
}

