/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.ws.management.util.RasUtils;
import java.io.File;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class EARExpander {
    private static final TraceComponent _tc = Tr.register(EARExpander.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String OPTION_EAR = "-ear";
    private static final String OPTION_OPERATION = "-operation";
    private static final String OPTION_OPERATION_DIRECTORY = "-operationDir";
    private static final String OPTION_EXPANSION_FLAG = "-expansionFlag";
    private static final String OPTION_EXPANSION_FLAGS = "-expansionFlags";
    private static final String OPTION_VERBOSE = "-verbose";
    private static final String OPERATION_EXPAND = "expand";
    private static final String OPERATION_COLLAPSE = "collapse";
    private static final String EXPANSION_FLAG_ALL = "all";
    private static final String EXPANSION_FLAG_WAR = "war";
    public static final int EXIT_CODE_SYNTAX = -1;
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_ERROR = 1;
    public static final int EXIT_CODE_EXCEPTION = 2;
    private static final ResourceBundle _resourceBundle;
    private String _ear = null;
    private Operation _operation = null;
    private String _operationDirectory = null;
    private int _extractOptions = 126;
    private boolean _verbose = false;
    private int _exitCode = 0;

    protected EARExpander() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>");
            Tr.exit(_tc, "<init>");
        }
    }

    @Deprecated
    public EARExpander(String ear, String operationDirectory, String expansionFlag) {
        this(ear, operationDirectory, expansionFlag, false);
    }

    @Deprecated
    public EARExpander(String ear, String operationDirectory, String expansionFlag, boolean verbose) {
        this(ear, Operation.EXPAND, operationDirectory, expansionFlag, verbose);
    }

    @Deprecated
    public EARExpander(String ear, Operation operation, String operationDirectory, String expansionFlag, boolean verbose) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new String[]{"ear=" + ear, "operation=" + (Object)((Object)operation), "operationDirectory=" + operationDirectory, "expansionFlag=" + expansionFlag, "verbose=" + verbose});
        }
        if (ear == null) {
            throw new NullPointerException("ear is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is null");
        }
        if (operationDirectory == null) {
            throw new NullPointerException("operationDirectory is null");
        }
        this._ear = ear;
        this._operation = operation;
        this._operationDirectory = operationDirectory;
        this.parseExpansionFlag(expansionFlag);
        this._verbose = verbose;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_ear=");
        stringBuilder.append(this._ear);
        stringBuilder.append(", _operation=");
        stringBuilder.append((Object)this._operation);
        stringBuilder.append(", _operationDirectory=");
        stringBuilder.append(this._operationDirectory);
        stringBuilder.append(", _extractOptions=");
        stringBuilder.append(this._extractOptions);
        stringBuilder.append(", _verbose=");
        stringBuilder.append(this._verbose);
        stringBuilder.append(", _exitCode=");
        stringBuilder.append(this._exitCode);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected static String usage() {
        return EARExpander.getMessage("ADMA4001I");
    }

    protected static String getMessage(String key) {
        return EARExpander.getMessage(key, null);
    }

    protected static String getMessage(String key, Object[] arguments) {
        String message = key;
        if (_resourceBundle != null) {
            try {
                message = _resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                RasUtils.logException(e, _tc, CLASS_NAME, "getMessage", "226");
                message = key;
            }
        }
        if (arguments != null) {
            message = MessageFormat.format(message, arguments);
        }
        return message;
    }

    @Deprecated
    protected static void printCommandErrorAndExit(String key, Object[] arguments) {
        System.err.println(EARExpander.getMessage(key, arguments));
        System.err.println(EARExpander.usage());
        System.exit(-1);
    }

    @Deprecated
    protected static void printErrorAndExit(String key, Object[] arguments) {
        System.err.println(EARExpander.getMessage(key, arguments));
        System.exit(-1);
    }

    protected static void printMessage(PrintStream printStream, String message) {
        printStream.println(message);
    }

    protected static void printMessageStderr(String key, Object[] arguments) {
        String message = EARExpander.getMessage(key, arguments);
        EARExpander.printMessage(System.err, message);
    }

    protected static void printMessageStdout(String key, Object[] arguments) {
        String message = EARExpander.getMessage(key, arguments);
        EARExpander.printMessage(System.out, message);
    }

    public static void main(String[] arguments) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "main", "arguments=" + Arrays.toString(arguments));
        }
        int exitCode = 0;
        EARExpander earExpander = new EARExpander();
        if (earExpander.parseArguments(arguments)) {
            earExpander.doOperation();
            exitCode = earExpander.getExitCode();
        } else {
            EARExpander.printMessageStderr(EARExpander.usage(), null);
            exitCode = -1;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "main", Integer.toString(exitCode));
        }
        System.exit(exitCode);
    }

    private boolean parseArguments(String[] arguments) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseArguments", "arguments=" + Arrays.toString(arguments));
        }
        boolean successful = true;
        boolean earSpecified = false;
        boolean operationSpecified = false;
        boolean operationDirectorySpecified = false;
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i].equalsIgnoreCase(OPTION_EAR)) {
                earSpecified = true;
                if (++i < arguments.length) {
                    this._ear = arguments[i];
                    continue;
                }
                EARExpander.printMessageStderr("ADMA4008E", new Object[]{OPTION_EAR.substring(1)});
                successful = false;
                continue;
            }
            if (arguments[i].equalsIgnoreCase(OPTION_OPERATION)) {
                operationSpecified = true;
                if (++i < arguments.length) {
                    String operation = arguments[i];
                    if (operation.equalsIgnoreCase(OPERATION_EXPAND)) {
                        this._operation = Operation.EXPAND;
                        continue;
                    }
                    if (operation.equalsIgnoreCase(OPERATION_COLLAPSE)) {
                        this._operation = Operation.COLLAPSE;
                        continue;
                    }
                    EARExpander.printMessageStderr("ADMA4005E", new Object[]{operation});
                    successful = false;
                    continue;
                }
                EARExpander.printMessageStderr("ADMA4008E", new Object[]{OPTION_OPERATION.substring(1)});
                successful = false;
                continue;
            }
            if (arguments[i].equalsIgnoreCase(OPTION_OPERATION_DIRECTORY)) {
                operationDirectorySpecified = true;
                if (++i < arguments.length) {
                    this._operationDirectory = arguments[i];
                    continue;
                }
                EARExpander.printMessageStderr("ADMA4008E", new Object[]{OPTION_OPERATION_DIRECTORY.substring(1)});
                successful = false;
                continue;
            }
            if (arguments[i].equalsIgnoreCase(OPTION_EXPANSION_FLAG) || arguments[i].equalsIgnoreCase(OPTION_EXPANSION_FLAGS)) {
                if (++i < arguments.length) {
                    String expansionFlag = arguments[i];
                    this.parseExpansionFlag(expansionFlag);
                    continue;
                }
                EARExpander.printMessageStderr("ADMA4008E", new Object[]{OPTION_EXPANSION_FLAG.substring(1)});
                successful = false;
                continue;
            }
            if (arguments[i].equalsIgnoreCase(OPTION_VERBOSE)) {
                this._verbose = true;
                continue;
            }
            EARExpander.printMessageStderr("ADMA4015E", new Object[]{arguments[i]});
            successful = false;
        }
        if (!earSpecified) {
            EARExpander.printMessageStderr("ADMA4002E", new Object[]{OPTION_EAR.substring(1)});
            successful = false;
        }
        if (!operationSpecified) {
            EARExpander.printMessageStderr("ADMA4002E", new Object[]{OPTION_OPERATION.substring(1)});
            successful = false;
        }
        if (!operationDirectorySpecified) {
            EARExpander.printMessageStderr("ADMA4002E", new Object[]{OPTION_OPERATION_DIRECTORY.substring(1)});
            successful = false;
        }
        if (!successful) {
            this._exitCode = -1;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseArguments", Boolean.toString(successful));
        }
        return successful;
    }

    private void parseExpansionFlag(String expansionFlag) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseExpansionFlag", "expansionFlag=" + expansionFlag);
        }
        int extractOptions = 126;
        if (expansionFlag != null) {
            if (expansionFlag.equalsIgnoreCase(EXPANSION_FLAG_ALL)) {
                extractOptions = 126;
            } else if (expansionFlag.equalsIgnoreCase(EXPANSION_FLAG_WAR)) {
                extractOptions = 2;
            } else {
                EARExpander.printMessageStderr("ADMA4009W", new Object[]{expansionFlag});
            }
        }
        this._extractOptions = extractOptions;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "parseExpansionFlag", "_extractOptions=" + this._extractOptions);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseExpansionFlag");
        }
    }

    private static void closeEarFile(EARFile earFile) {
        if (earFile != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "closeEarFile", "closing ear " + earFile);
            }
            earFile.close();
        }
    }

    protected void doOperation() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doOperation");
        }
        if (this._operation == Operation.EXPAND) {
            this.expand();
        } else {
            this.collapse();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doOperation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void expand() {
        block9: {
            block10: {
                File file;
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, OPERATION_EXPAND);
                }
                if (!(file = new File(this._ear)).exists() || !file.isFile() || !file.canRead()) break block10;
                File directory = new File(this._operationDirectory);
                if (!directory.exists() || !directory.isFile()) {
                    EARFile earFile = null;
                    try {
                        try {
                            earFile = EarUtils.getEarFile((String)this._ear, (boolean)false);
                            EARExpander.printMessageStdout("ADMA4006I", new Object[]{this._ear, this._operationDirectory});
                            EarUtils.extractEar((EARFile)earFile, (String)this._operationDirectory, (boolean)false, (int)this._extractOptions);
                        }
                        catch (Exception e) {
                            RasUtils.logException((Throwable)e, _tc, CLASS_NAME, OPERATION_EXPAND, "503", this);
                            EARExpander.printMessageStderr("ADMA4013E", new Object[]{e.toString()});
                            if (this._verbose) {
                                e.printStackTrace(System.err);
                            }
                            this._exitCode = 2;
                            Object var6_5 = null;
                            EARExpander.closeEarFile(earFile);
                            break block9;
                        }
                        Object var6_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        EARExpander.closeEarFile(earFile);
                        throw throwable;
                    }
                    EARExpander.closeEarFile(earFile);
                    break block9;
                } else {
                    EARExpander.printMessageStderr("ADMA4004E", new Object[]{this._operationDirectory});
                    this._exitCode = 1;
                }
                break block9;
            }
            EARExpander.printMessageStderr("ADMA4003E", new Object[]{this._ear});
            this._exitCode = 1;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, OPERATION_EXPAND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void collapse() {
        block13: {
            File directory;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, OPERATION_COLLAPSE);
            }
            if ((directory = new File(this._operationDirectory)).exists() && directory.isDirectory()) {
                EARFile earFile = null;
                try {
                    try {
                        CommonarchiveFactory factory;
                        Archive archive;
                        File file = new File(this._ear);
                        if (file.exists()) {
                            file.delete();
                        }
                        if ((archive = (factory = CommonarchiveFactoryImpl.getActiveFactory()).openArchive(this._operationDirectory)) instanceof EARFile) {
                            earFile = (EARFile)archive;
                            EARExpander.printMessageStdout("ADMA4007I", new Object[]{this._operationDirectory, this._ear});
                            earFile.saveAs(this._ear);
                        } else {
                            EARExpander.printMessageStderr("ADMA4004E", new Object[]{this._operationDirectory});
                            this._exitCode = 1;
                        }
                    }
                    catch (Exception e) {
                        RasUtils.logException((Throwable)e, _tc, CLASS_NAME, OPERATION_COLLAPSE, "553", this);
                        EARExpander.printMessageStderr("ADMA4014E", new Object[]{e.toString()});
                        if (this._verbose) {
                            e.printStackTrace(System.err);
                        }
                        this._exitCode = 2;
                        Object var7_8 = null;
                        EARExpander.closeEarFile(earFile);
                        break block13;
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    EARExpander.closeEarFile(earFile);
                    throw throwable;
                }
                EARExpander.closeEarFile(earFile);
            } else {
                EARExpander.printMessageStderr("ADMA4004E", new Object[]{this._operationDirectory});
                this._exitCode = 1;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, OPERATION_COLLAPSE);
        }
    }

    protected int getExitCode() {
        return this._exitCode;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/commands/EARExpander.java, WAS.admin.appmgmt, WAS70.SERV1, cf050925.09, ver. 1.6.1.2");
        }
        CLASS_NAME = EARExpander.class.getName();
        _resourceBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        EXPAND,
        COLLAPSE;

    }
}

