/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.client.util;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;

public class WASDeploymentTask
extends AppDeploymentTask
implements Serializable {
    private static TraceComponent tc = Tr.register(WASDeploymentTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final long serialVersionUID = 140503665319507635L;
    private Hashtable properties = new Hashtable();

    public WASDeploymentTask(AppDeploymentController controller) {
        super(controller);
    }

    public WASDeploymentTask(AppDeploymentController controller, String tName, String[] col, boolean[] req, boolean[] mut, boolean[] hid) {
        this(controller);
        this.name = tName;
        this.colNames = col;
        this.requiredColumns = req;
        this.mutables = mut;
        this.hiddenColumns = hid;
    }

    public WASDeploymentTask(AppDeploymentController controller, String tName, String[] col, boolean[] req, boolean[] mut, boolean[] hid, boolean hasHidden) {
        this(controller);
        this.name = tName;
        this.colNames = col;
        this.requiredColumns = req;
        this.mutables = mut;
        this.hiddenColumns = hid;
        this.hasHiddenColumns = hasHidden;
    }

    public String[] validate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Vector<String> errorMessages = new Vector<String>();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "task name " + this.getName());
        }
        this.taskValidateErrorMessages = null;
        if (this.taskData != null) {
            for (int i = 0; i < this.taskData.length; ++i) {
                for (int j = 0; j < this.taskData[i].length; ++j) {
                    if (!this.requiredColumns[j] || this.taskData[i][j] != null && !this.taskData[i][j].equals("")) continue;
                    String error = MessageFormat.format(util.getMessage(this, "ADMA0112E"), util.getGoalTitle(this, this.getName()), this.colNames[j]);
                    errorMessages.addElement(error);
                }
            }
            this.validateInTaskHelper(errorMessages);
            this.buildErrorMessages(errorMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return this.taskValidateErrorMessages;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    private void validateInTaskHelper(Vector errorMessages) {
        String[] errorMessagesInTaskHelper;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateInTaskHelper");
            }
            errorMessagesInTaskHelper = null;
            try {
                errorMessagesInTaskHelper = this.appController.validateInTaskHelper(this.getName());
            }
            catch (AppDeploymentException apex) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "exception in calling validateInTaskHelper for " + this.getName() + ": " + apex.getMessage());
            }
        }
        if (errorMessagesInTaskHelper != null) {
            for (int i = 0; i < errorMessagesInTaskHelper.length; ++i) {
                errorMessages.addElement(errorMessagesInTaskHelper[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateInTaskHelper");
        }
    }
}

