/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.workspace.query.WorkSpaceQueryUtil;
import com.ibm.ws.workspace.query.WorkSpaceQueryUtilFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class ResValidationHelper {
    private static TraceComponent tc = Tr.register(ResValidationHelper.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private Map JNDIKeys = Collections.synchronizedMap(new HashMap());
    private Map inScopeResources = Collections.synchronizedMap(new HashMap());
    private Map outOfScopeResources = Collections.synchronizedMap(new HashMap());
    private String CELL_NAME = "";
    private RepositoryContext CELL_CONTEXT = null;
    public static String[] resTypes;
    public static String[] resTaskArray;
    private static Map typeTranslation;

    public void gatherJNDINames(AppDeploymentController controller, String cellName, WorkSpace ws) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "gatherAllJNDINames", new Object[]{controller, cellName, ws});
        }
        try {
            Hashtable servertbl;
            block22: {
                this.CELL_NAME = cellName;
                servertbl = new Hashtable();
                try {
                    servertbl = controller.getServerTable();
                }
                catch (AppDeploymentException ex) {
                    RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "gatherJNDINames", "161", this);
                    if (!tc.isDebugEnabled()) break block22;
                    Tr.debug(tc, "Exception when calling getServerTable: " + ex);
                }
            }
            if (servertbl == null || servertbl.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "gatherJNDINames: empty mod2svr table");
                }
                return;
            }
            HashSet<String> targets = new HashSet<String>();
            Enumeration en = servertbl.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String tar = (String)servertbl.get(key);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "key: " + key + " -- targets: " + tar);
                }
                if (tar.indexOf(43) > 0) {
                    StringTokenizer stoken = new StringTokenizer(tar, "+");
                    while (stoken.hasMoreTokens()) {
                        targets.add(stoken.nextToken());
                    }
                    continue;
                }
                targets.add(tar);
            }
            RepositoryContext cellContext = AppUtils.findContext("cells", cellName, null, null, ws, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cell Context", cellContext);
            }
            this.CELL_CONTEXT = cellContext;
            RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            for (String t : targets) {
                String cellTarget = "";
                if (this._isServerTarget(t)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Target: " + t);
                    }
                    String nodeTarget = this._getPreviousLevel(t);
                    Properties props = this._getKeyProperties(nodeTarget);
                    String node = props.getProperty("node");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node Name: " + node);
                    }
                    RepositoryContext nodeContext = cellContext.getChild(metaData.getContextType("nodes"), node);
                    if (!this.inScopeResources.containsKey(nodeTarget)) {
                        ArrayList list = this._getJNDINames(nodeContext);
                        this._addToJNDITable(list, this.JNDIKeys, nodeTarget);
                        this.inScopeResources.put(nodeTarget, list);
                    }
                    Properties serverProps = this._getKeyProperties(t);
                    String server = serverProps.getProperty("server");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Name: " + server);
                    }
                    RepositoryContext serverContext = nodeContext.getChild(metaData.getContextType("servers"), server);
                    ArrayList slist = this._getJNDINames(serverContext);
                    this._addToJNDITable(slist, this.JNDIKeys, t);
                    this.inScopeResources.put(t, slist);
                    continue;
                }
                if (this._isClusterTarget(t)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cluster Target: " + t);
                    }
                    Properties clusterProps = this._getKeyProperties(t);
                    String cluster = clusterProps.getProperty("cluster");
                    RepositoryContext clusterContext = cellContext.getChild(metaData.getContextType("clusters"), cluster);
                    ArrayList clist = this._getJNDINames(clusterContext);
                    this._addToJNDITable(clist, this.JNDIKeys, t);
                    this.inScopeResources.put(t, clist);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Odd Target Passed in: " + t);
            }
            String cell_target = "WebSphere:cell=" + cellName;
            ArrayList lst = this._getJNDINames(cellContext);
            ArrayList embeddedList = this._getEmbeddedRarJNDIs(controller);
            this._addToJNDITable(embeddedList, this.JNDIKeys, cell_target);
            lst.addAll(embeddedList);
            this.inScopeResources.put(cell_target, lst);
            this._addToJNDITable(lst, this.JNDIKeys, cell_target);
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "gatherJNDINames", "257", this);
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, "Unexpected Exception from gatherJNDINames: " + th.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "gatherAllJNDINames");
        }
    }

    public ArrayList getResourceJndiNames(AppDeploymentController controller, String resourceType) throws AdminException {
        Hashtable servertbl;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getResourceJndiNames ", new Object[]{controller, resourceType});
            }
            servertbl = null;
            try {
                servertbl = controller.getServerTable();
            }
            catch (AppDeploymentException ex) {
                RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "getResourceJNDINames", "286", this);
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Exception when calling getServerTable: " + ex);
            }
        }
        if (servertbl == null || servertbl.size() == 0) {
            if (tc.isEntryEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "gatherJNDINames: empty mod2svr table");
            }
            return new ArrayList();
        }
        HashSet set = new HashSet();
        HashSet<String> tempset = new HashSet<String>();
        Enumeration en = servertbl.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String targets = (String)servertbl.get(key);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "key: " + key + ".. targets: " + targets);
            }
            StringTokenizer tokenizer = new StringTokenizer(targets, "+");
            while (tokenizer.hasMoreTokens()) {
                String nextT = tokenizer.nextToken();
                if (nextT == null || nextT.trim().equals("") || tempset.contains(nextT)) continue;
                tempset.add(nextT);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "tempset: " + tempset);
        }
        for (String loc : tempset) {
            ArrayList list = this.getResourceJndiNames(loc, resourceType, new HashSet());
            set.addAll(list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceJndiNames ", new Object[]{set});
        }
        return new ArrayList(set);
    }

    public Map resourceValidation(AppDeploymentController controller, String taskName) throws AdminException {
        Hashtable servertbl;
        Map resInfoMap;
        AppDeploymentTask task;
        block15: {
            block14: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "resourceValidation ", new Object[]{controller, taskName});
                }
                task = null;
                boolean validTask = false;
                resInfoMap = new Hashtable();
                for (int i = 0; i < resTaskArray.length; ++i) {
                    if (!taskName.equals(resTaskArray[i])) continue;
                    validTask = true;
                }
                if (!validTask) {
                    Tr.warning(tc, "The task " + taskName + " is not in the resource task list.");
                    return null;
                }
                try {
                    if (validTask) {
                        task = controller.getTaskByName(taskName, false);
                    }
                }
                catch (AppDeploymentException ex) {
                    RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "resourceValidation", "365", this);
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Exception when calling getTaskByName: " + ex);
                }
            }
            if (!task.isValidationEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resouce validation is disabled for the task " + taskName);
                }
                return null;
            }
            servertbl = new Hashtable();
            try {
                servertbl = controller.getServerTable();
            }
            catch (AppDeploymentException ex) {
                RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "resourceValidation", "382", this);
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Exception when calling getServerTable: " + ex);
            }
        }
        if ((servertbl == null || servertbl.size() == 0) && tc.isEntryEnabled()) {
            Tr.exit(tc, "gatherJNDINames: empty mod2svr table");
        }
        if (tc.isDebugEnabled()) {
            Enumeration en = servertbl.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String targets = (String)servertbl.get(key);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "key: " + key + ".. targets: " + targets);
            }
        }
        resInfoMap = this._validateTaskResources(task, servertbl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resourceValidation ", new Object[]{resInfoMap});
        }
        return resInfoMap;
    }

    public Vector resValidation(String earFile, String cellName, WorkSpace ws, Hashtable tbl) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resValidation ", new Object[]{earFile, cellName, ws, tbl});
        }
        Vector<String> messages = new Vector<String>();
        try {
            AppDeploymentController controller = AppManagementFactory.readArchive(earFile, tbl);
            Hashtable options = new Hashtable();
            options = controller.getAppOptions();
            options.putAll(tbl);
            this.gatherJNDINames(controller, cellName, ws);
            Map resMap = new HashMap();
            for (int i = 0; i < resTaskArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resTaskArray[i] " + resTaskArray[i]);
                }
                String taskName = resTaskArray[i];
                resMap = this.resourceValidation(controller, taskName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resMap " + resMap);
                }
                HashMap failedResTable = new HashMap();
                if (resMap.size() <= 0) continue;
                Set set = resMap.keySet();
                Iterator ee = set.iterator();
                while (ee.hasNext()) {
                    String error;
                    failedResTable = (HashMap)resMap.get(ee.next());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "failedResTable " + failedResTable);
                    }
                    if (failedResTable.size() <= 0) continue;
                    String uri = (String)failedResTable.get("uri");
                    String ejbmodule = (String)failedResTable.get("EJBModule");
                    String module = (String)failedResTable.get("module");
                    String jndi = (String)failedResTable.get("JNDI");
                    String target = (String)failedResTable.get("Targets");
                    String resRefName = (String)failedResTable.get("referenceBinding");
                    String resRefType = (String)failedResTable.get("resRef.type");
                    String resEnvRefType = (String)failedResTable.get("resEnvRef.type");
                    String msgDstRefName = (String)failedResTable.get("messageDestinationRefName");
                    String msgDstObjName = (String)failedResTable.get("messageDestinationObject");
                    String rarModule = (String)failedResTable.get("RARModule");
                    String j2cId = (String)failedResTable.get("j2cid");
                    String j2cJNDI = (String)failedResTable.get("j2c.jndiName");
                    String misType = (String)failedResTable.get("MisType");
                    Tr.debug(tc, "misresoure type " + misType);
                    String resType = (String)failedResTable.get("ResourceType");
                    Tr.debug(tc, "expected resource type " + resType);
                    String obj1 = null;
                    String obj2 = null;
                    if (module != null) {
                        ejbmodule = module;
                    } else if (rarModule != null) {
                        ejbmodule = rarModule;
                    }
                    if (jndi == null) {
                        jndi = j2cJNDI;
                    }
                    if (resRefType != null) {
                        obj1 = resRefName;
                        obj2 = resRefType;
                    }
                    if (resEnvRefType != null) {
                        obj1 = resRefName;
                        obj2 = resEnvRefType;
                    }
                    if (msgDstObjName != null) {
                        obj1 = msgDstRefName;
                        obj2 = msgDstObjName;
                    }
                    if (j2cId != null) {
                        obj1 = j2cId;
                        obj2 = "J2CActivationSpec";
                    }
                    if (misType == null) {
                        if (obj1 != null || obj2 != null) {
                            error = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0115W", new String[]{obj1, obj2, jndi, ejbmodule, uri, target});
                            messages.addElement(error);
                            continue;
                        }
                        error = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0114W", new String[]{jndi, ejbmodule, uri, target});
                        messages.addElement(error);
                        continue;
                    }
                    if (obj1 != null || obj2 != null) {
                        error = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0139W", new String[]{obj1, obj2, jndi, ejbmodule, uri, target, misType, resType});
                        messages.addElement(error);
                        continue;
                    }
                    error = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0138W", new String[]{jndi, ejbmodule, uri, target, misType, resType});
                    messages.addElement(error);
                }
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "resValidation", "535", this);
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, "Unexpected Exception from resValidation: " + th.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resValidation ", new Object[]{messages});
        }
        return messages;
    }

    protected ArrayList getResourceJndiNames(String target, String resourceType, Set holder) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceJndiNames ", new Object[]{target, resourceType, holder});
        }
        ArrayList list = (ArrayList)this.inScopeResources.get(target);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "List : ", list);
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String JNDI;
                String key = (String)list.get(i);
                Properties props = this._getKeyProperties(key);
                Tr.debug(tc, "subtype: " + props.getProperty("subtype"));
                Tr.debug(tc, "type: " + props.getProperty("type"));
                if (resourceType.equals("Topic") || resourceType.equals("TopicConnectionFactory") || resourceType.equals("Queue") || resourceType.equals("QueueConnectionFactory") || resourceType.equals("ConnectionFactory") || resourceType.equals("XAQueueConnectionFactory")) {
                    if (!resourceType.equals(props.getProperty("subtype")) || (JNDI = props.getProperty("JNDI")) == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getResourceJndiNames adding to List: " + JNDI);
                    }
                    holder.add(JNDI);
                    continue;
                }
                if (!resourceType.equals(props.getProperty("type")) || (JNDI = props.getProperty("JNDI")) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getResourceJndiNames adding to List: " + JNDI);
                }
                holder.add(JNDI);
            }
        }
        if (this._isServerTarget(target)) {
            String nodeKey = this._getPreviousLevel(target);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getResourceJndiNames ", new Object[]{holder});
            }
            return this.getResourceJndiNames(nodeKey, resourceType, holder);
        }
        if (this._isNodeTarget(target) || this._isClusterTarget(target)) {
            String cellKey = this._getPreviousLevel(target);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getResourceJndiNames ", new Object[]{holder});
            }
            return this.getResourceJndiNames(cellKey, resourceType, holder);
        }
        if (this._isCellTarget(target) && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceJndiNames ", new Object[]{holder});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceJndiNames ", new Object[]{holder});
        }
        return new ArrayList(holder);
    }

    private Properties _getKeyProperties(String target) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getKeyProperties: ", target);
        }
        Properties result = new Properties();
        if (target.startsWith("WebSphere:")) {
            target = target.substring(10, target.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target: " + target);
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(target, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String key = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token: " + token);
            }
            if (token.startsWith("cell")) {
                key = "cell";
            } else if (token.startsWith("node")) {
                key = "node";
            } else if (token.startsWith("server")) {
                key = "server";
            } else if (token.startsWith("JNDI")) {
                key = "JNDI";
            } else if (token.startsWith("name")) {
                key = "name";
            } else if (token.startsWith("type")) {
                key = "type";
            } else if (token.startsWith("cluster")) {
                key = "cluster";
            } else if (token.startsWith("subtype")) {
                key = "subtype";
            } else if (token.startsWith("mistype")) {
                key = "mistype";
            }
            if (key == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Key: " + key + " +  value: " + token.substring(token.indexOf("=") + 1));
            }
            result.setProperty(key, token.substring(token.indexOf("=") + 1));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getKeyProperties: ", result);
        }
        return result;
    }

    private boolean _isValidTarget(String server, String location) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_isValidTarget ", new Object[]{server, location});
        }
        Properties serverProps = this._getKeyProperties(server);
        Properties locationProps = this._getKeyProperties(location);
        if (this._isServerTarget(server)) {
            String lServ;
            String lCell;
            String sCell = serverProps.getProperty("cell");
            if (!sCell.equals(lCell = locationProps.getProperty("cell"))) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_isValidTarget ", new Boolean(false));
                }
                return false;
            }
            String sNode = serverProps.getProperty("node");
            String lNode = locationProps.getProperty("node");
            if (lNode != null && !sNode.equals(lNode)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_isValidTarget ", new Boolean(false));
                }
                return false;
            }
            String sServ = serverProps.getProperty("server");
            if (!sServ.equals(lServ = locationProps.getProperty("server"))) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_isValidTarget ", new Boolean(false));
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_isValidTarget ", new Boolean(true));
            }
            return true;
        }
        if (this._isClusterTarget(server)) {
            String lCell;
            String lClust;
            String sClust = serverProps.getProperty("cluster");
            if (!sClust.equals(lClust = locationProps.getProperty("cluster"))) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_isValidTarget ", new Boolean(false));
                }
                return false;
            }
            String sCell = serverProps.getProperty("cell");
            if (!sCell.equals(lCell = locationProps.getProperty("cell"))) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_isValidTarget ", new Boolean(false));
                }
                return false;
            }
        }
        return true;
    }

    private boolean _isServerTarget(String target) {
        String third;
        StringTokenizer st = new StringTokenizer(target, ",");
        if (st.countTokens() < 3) {
            return false;
        }
        st.nextToken();
        String second = st.nextToken();
        return second.startsWith("node=") && (third = st.nextToken()).startsWith("server=");
    }

    private boolean _isCellTarget(String target) {
        StringTokenizer st = new StringTokenizer(target, ",");
        if (st.countTokens() != 1) {
            return false;
        }
        String cell = st.nextToken();
        return cell.startsWith("WebSphere:cell=");
    }

    private boolean _isNodeTarget(String target) {
        StringTokenizer st = new StringTokenizer(target, ",");
        if (st.countTokens() < 2) {
            return false;
        }
        st.nextToken();
        String second = st.nextToken();
        return second.startsWith("node=");
    }

    private boolean _isClusterTarget(String target) {
        StringTokenizer st = new StringTokenizer(target, ",");
        if (st.countTokens() < 2) {
            return false;
        }
        st.nextToken();
        String second = st.nextToken();
        return second.startsWith("cluster=");
    }

    private String _getPreviousLevel(String target) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getPreviousLevel", target);
        }
        StringTokenizer st = new StringTokenizer(target, ",");
        String answer = null;
        if (st.countTokens() >= 2) {
            if (st.countTokens() == 2) {
                answer = st.nextToken();
            } else if (st.countTokens() == 3) {
                String cell = st.nextToken();
                String next = st.nextToken();
                answer = cell + "," + next;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getPreviousLevel", answer);
        }
        return answer;
    }

    private Map _validateTaskResources(AppDeploymentTask task, Hashtable serverTargets) {
        HashMap ret = new HashMap();
        if (task == null) {
            return ret;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTaskResources ", new Object[]{task.getName()});
        }
        String taskName = task.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "task Name " + taskName);
        }
        String[] colNames = task.getColumnNames();
        int col = colNames.length;
        int jndiCol = -1;
        int uriCol = -1;
        int ejbModuleCol = -1;
        int moduleCol = -1;
        int refBindingCol = -1;
        int resRefTypeCol = -1;
        int resEnvRefTypeCol = -1;
        int msgDstRefNameCol = -1;
        int msgDstObjCol = -1;
        int rarModuleCol = -1;
        int j2cIdCol = -1;
        for (int mm = 0; mm < col; ++mm) {
            if ("uri".equals(colNames[mm])) {
                uriCol = mm;
            }
            if ("JNDI".equals(colNames[mm])) {
                jndiCol = mm;
            }
            if ("EJBModule".equals(colNames[mm])) {
                ejbModuleCol = mm;
            }
            if ("module".equals(colNames[mm])) {
                moduleCol = mm;
            }
            if ("referenceBinding".equals(colNames[mm])) {
                refBindingCol = mm;
            }
            if ("resRef.type".equals(colNames[mm])) {
                resRefTypeCol = mm;
            }
            if ("messageDestinationRefName".equals(colNames[mm])) {
                msgDstRefNameCol = mm;
            }
            if ("messageDestinationObject".equals(colNames[mm])) {
                msgDstObjCol = mm;
            }
            if ("resEnvRef.type".equals(colNames[mm])) {
                resEnvRefTypeCol = mm;
            }
            if ("RARModule".equals(colNames[mm])) {
                rarModuleCol = mm;
            }
            if ("j2cid".equals(colNames[mm])) {
                j2cIdCol = mm;
            }
            if (!"j2c.jndiName".equals(colNames[mm])) continue;
            jndiCol = mm;
        }
        if (!task.isTaskEmpty()) {
            String[][] taskData = task.getTaskData();
            for (int i = 1; i < taskData.length; ++i) {
                HashMap<String, String> resInfoTable = new HashMap<String, String>();
                String key = Integer.toString(i);
                String URI2 = null;
                String JNDI = null;
                String uniqueId = null;
                if (taskData[i][uriCol] != null && !taskData[i][uriCol].equals("")) {
                    URI2 = util.getModuleUriFromUriString(taskData[i][uriCol]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "URI is", URI2);
                    }
                    uniqueId = taskData[i][uriCol].replace(',', '+');
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unique ID", uniqueId);
                    }
                }
                if (taskData[i][jndiCol] != null && !taskData[i][jndiCol].equals("")) {
                    JNDI = taskData[i][jndiCol];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "jndi column " + JNDI);
                    }
                }
                Vector newjndiV = new Vector();
                String target = null;
                String jndiKey = null;
                String jndiType = null;
                target = (String)serverTargets.get(uniqueId);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "target", target);
                }
                Set cellKeys = this.inScopeResources.keySet();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeySet: " + cellKeys);
                }
                if (taskData[i][jndiCol] != null && !taskData[i][jndiCol].equals("")) {
                    resInfoTable.put("uri", taskData[i][uriCol]);
                    resInfoTable.put("JNDI", taskData[i][jndiCol]);
                    if (target == null) {
                        target = "";
                    }
                    resInfoTable.put("Targets", target);
                    if (taskName.equals("DataSourceFor10CMPBeans") || taskName.equals("DataSourceFor20CMPBeans") || taskName.equals("DataSourceFor10EJBModules") || taskName.equals("DataSourceFor20EJBModules")) {
                        resInfoTable.put("EJBModule", taskData[i][ejbModuleCol]);
                        jndiType = "JDBCProvider";
                    }
                    if (taskName.equals("BindJndiForEJBMessageBinding")) {
                        resInfoTable.put("EJBModule", taskData[i][ejbModuleCol]);
                        jndiType = "JMS";
                    }
                    if (taskName.equals("MapResRefToEJB") || taskName.equals("MapResEnvRefToRes") || taskName.equals("MapMessageDestinationRefToEJB")) {
                        resInfoTable.put("module", taskData[i][moduleCol]);
                    }
                    if (taskName.equals("MapResRefToEJB")) {
                        resInfoTable.put("referenceBinding", taskData[i][refBindingCol]);
                        resInfoTable.put("resRef.type", taskData[i][resRefTypeCol]);
                        jndiType = taskData[i][6];
                        String temp = (String)typeTranslation.get(jndiType);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "JNDI Type Translation: " + temp);
                        }
                        if (temp != null) {
                            jndiType = temp;
                        }
                    }
                    if (taskName.equals("MapResEnvRefToRes")) {
                        resInfoTable.put("referenceBinding", taskData[i][refBindingCol]);
                        resInfoTable.put("resEnvRef.type", taskData[i][resEnvRefTypeCol]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Begining Search for : " + JNDI);
                        }
                        jndiType = "ResourceEnvironmentProvider";
                    }
                    if (taskName.equals("MapMessageDestinationRefToEJB")) {
                        resInfoTable.put("messageDestinationObject", taskData[i][msgDstObjCol]);
                        resInfoTable.put("messageDestinationRefName", taskData[i][msgDstRefNameCol]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Begining Search for : " + JNDI);
                        }
                        jndiType = "J2CAdminObject";
                    }
                }
                if (taskName.equals("ActSpecJNDI") && taskData[i][jndiCol] != null && !taskData[i][jndiCol].trim().equals("")) {
                    resInfoTable.put("j2c.jndiName", taskData[i][jndiCol]);
                    resInfoTable.put("RARModule", taskData[i][rarModuleCol]);
                    resInfoTable.put("j2cid", taskData[i][j2cIdCol]);
                    jndiType = "J2CActivationSpec";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JNDI Type: " + jndiType);
                }
                if (jndiType != null) {
                    resInfoTable.put("ExpectedJNDIType", jndiType);
                }
                Tr.debug(tc, "JNDI: " + JNDI);
                if (JNDI != null) {
                    jndiKey = this._validateResourceJndiNames(JNDI, jndiType, target, new HashSet(cellKeys), this.inScopeResources, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "JNDI Key: " + jndiKey);
                    }
                    boolean outOfScope = false;
                    if (jndiKey == null) {
                        Tr.debug(tc, "JNDI Key was not found in scope");
                        String[] nodesArray = new String[]{};
                        try {
                            jndiKey = this._locateOutOfScopeResourceTargets(target, JNDI, jndiType);
                            Tr.debug(tc, "Found out of scope jndi key: " + jndiKey);
                            outOfScope = true;
                            resInfoTable.put("OutOfScope", "true");
                        }
                        catch (Exception e) {
                            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "_validateTaskResources", "1007", this);
                            Tr.error(tc, "Error loading Resources: ", e);
                        }
                    }
                    if (jndiKey != null) {
                        String location = this._getEarliestLocation(jndiKey, target);
                        Properties jndi_props = this._getKeyProperties(jndiKey);
                        String misType = jndi_props.getProperty("mistype");
                        if (location != null) {
                            if (this._isValidTarget(target, location) && !outOfScope && misType == null) {
                                resInfoTable = new HashMap();
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Scope is valid, skipping");
                                continue;
                            }
                            resInfoTable.put("Scope", location);
                        } else {
                            resInfoTable.put("Scope", (String)this.JNDIKeys.get(jndiKey));
                        }
                        String resName = jndi_props.getProperty("name");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ResName: " + resName);
                        }
                        if (resName != null) {
                            resInfoTable.put("ResourceName", resName);
                        }
                        String resType = jndi_props.getProperty("type");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ResType: " + resType);
                        }
                        if (resName != null) {
                            resInfoTable.put("ResourceType", resType);
                        }
                        Tr.debug(tc, "misType " + misType);
                        if (misType != null) {
                            resInfoTable.put("MisType", misType);
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resInfoTable " + resInfoTable);
                }
                if (resInfoTable.size() <= 0) continue;
                ret.put(key, resInfoTable);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateTaskResources ", new Object[]{ret});
            }
        }
        return ret;
    }

    private String _locateOutOfScopeResourceTargets(String target, String jndiName, String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_locateOutOfScopeResourceTargets", new Object[]{target, jndiName, type});
        }
        String[] nodesArray = new String[]{};
        if (this._isClusterTarget(target)) {
            nodesArray = this._findOutOfScopeResourceTargets(null);
        } else if (this._isServerTarget(target)) {
            Properties serverProps = this._getKeyProperties(target);
            String node = serverProps.getProperty("node");
            nodesArray = this._findOutOfScopeResourceTargets(node);
        }
        this._loadOutOfScopeResourceTargets(nodesArray);
        Set outOfScope = this.outOfScopeResources.keySet();
        String key = this._findJNDIKey(outOfScope, jndiName, type, this.outOfScopeResources, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_locateOutOfScopeResourceTargets", key);
        }
        return key;
    }

    private void _loadOutOfScopeResourceTargets(String[] nodeArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_loadOutOfScopeResourceTargets", nodeArray);
        }
        String cellTarget = "WebSphere:cell=" + this.CELL_NAME;
        ArrayList celllist = this._getJNDINames(this.CELL_CONTEXT);
        this._addToJNDITable(celllist, this.JNDIKeys, cellTarget);
        this.outOfScopeResources.put(cellTarget, celllist);
        for (int a = 0; a < nodeArray.length; ++a) {
            String nodeTarget;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cell Context", this.CELL_CONTEXT);
            }
            if (this.outOfScopeResources.containsKey(nodeTarget = cellTarget + ",node=" + nodeArray[a])) continue;
            RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContext nodeContext = this.CELL_CONTEXT.getChild(metaData.getContextType("nodes"), nodeArray[a]);
            ArrayList list = this._getJNDINames(nodeContext);
            this._addToJNDITable(list, this.JNDIKeys, nodeTarget);
            this.outOfScopeResources.put(nodeTarget, list);
            Collection serverContexts = nodeContext.findContext(metaData.getContextType("servers"));
            for (RepositoryContext servCtx : serverContexts) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Context", servCtx);
                }
                String server_target = nodeTarget + ",server=" + servCtx.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Target" + server_target);
                }
                ArrayList list2 = this._getJNDINames(servCtx);
                this._addToJNDITable(list2, this.JNDIKeys, server_target);
                this.outOfScopeResources.put(server_target, list2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_loadOutOfScopeResourceTargets", new Object[]{this.outOfScopeResources});
        }
    }

    private String[] _findOutOfScopeResourceTargets(String node) throws CommandNotFoundException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_findOutOfScopeResourceTargets", node);
        }
        Session session = new Session();
        HashSet<String> nodeSet = new HashSet<String>();
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        if (node == null) {
            AdminCommand dngCmd = cmdMgr.createCommand("listNodes");
            dngCmd.setConfigSession(session);
            dngCmd.setParameter("nodeGroup", "DefaultNodeGroup");
            dngCmd.execute();
            CommandResult dngRes = dngCmd.getCommandResult();
            String[] nodes = (String[])dngRes.getResult();
            return nodes;
        }
        AdminCommand cmd = cmdMgr.createCommand("listNodeGroups");
        cmd.setConfigSession(session);
        cmd.setTargetObject(node);
        cmd.execute();
        CommandResult res = cmd.getCommandResult();
        String[] nodeGroups = (String[])res.getResult();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NodeGroups: ", nodeGroups);
        }
        for (int i = 0; i < nodeGroups.length; ++i) {
            AdminCommand cmd2 = cmdMgr.createCommand("listNodes");
            cmd2.setConfigSession(session);
            cmd2.setParameter("nodeGroup", nodeGroups[i]);
            cmd2.execute();
            CommandResult res2 = cmd2.getCommandResult();
            String[] nodes = (String[])res2.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nodes: ", nodeGroups);
            }
            for (int j = 0; j < nodes.length; ++j) {
                nodeSet.add(nodes[j]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NodeSet: ", nodeSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_findOutOfScopeResourceTargets", nodeSet);
        }
        return nodeSet.toArray(new String[0]);
    }

    private ArrayList _getJNDINames(RepositoryContext rc) {
        WorkSpaceQueryUtil wsUtil = WorkSpaceQueryUtilFactory.getUtil();
        ArrayList<String> newJndiList = new ArrayList<String>();
        for (int i = 0; i < resTypes.length; ++i) {
            ArrayList jndiList;
            block15: {
                Tr.debug(tc, "resTypes[i] " + resTypes[i]);
                jndiList = new ArrayList();
                try {
                    if (resTypes[i].equals("WAS40DataSource")) {
                        jndiList = (ArrayList)wsUtil.get40CMPResourceJNDINames(rc);
                        Tr.debug(tc, "jndiList for 40datasource " + jndiList);
                    } else if (resTypes[i].equals("WAS50DataSource")) {
                        jndiList = (ArrayList)wsUtil.get50DataSourceResourceJNDINames(rc);
                        Tr.debug(tc, "jndiList for 50datasource " + jndiList);
                    } else if (resTypes[i].equals("J2CAdminObject")) {
                        jndiList = (ArrayList)wsUtil.getJ2CAdminObjectsJNDINames(rc);
                        Tr.debug(tc, "jndiList for j2CAdminObject " + jndiList);
                    } else if (resTypes[i].equals("J2CActivationSpec")) {
                        jndiList = (ArrayList)wsUtil.getJ2CActivationSpecJNDINames(rc);
                        Tr.debug(tc, "jndiList for J2CActivationSpec " + jndiList);
                    } else if (resTypes[i].equals("J2CConnectionFactory")) {
                        jndiList = (ArrayList)wsUtil.getJ2CConnectionFactoryJNDINames(rc);
                        Tr.debug(tc, "jndiList for J2CConnectionFactory " + jndiList);
                    } else {
                        jndiList = (ArrayList)wsUtil.getResourceJNDINames(rc, resTypes[i]);
                        Tr.debug(tc, "jndiList for resources " + jndiList);
                    }
                }
                catch (Exception ex) {
                    RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "_findOutOfScopeResourceTargets", "1234", this);
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "Exception when getting jndi list: " + ex);
                }
            }
            for (int j = 0; j < jndiList.size(); ++j) {
                String key = new String();
                String jndi = (String)jndiList.get(j);
                String name = wsUtil.getResourceNameFromJNDI(rc, resTypes[i], jndi);
                String subType = wsUtil.getResourceTypeFromJNDI(rc, resTypes[i], jndi);
                key = "WebSphere:JNDI=" + jndi + ",type=" + resTypes[i] + ",name=" + name + ",subtype=" + subType;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JNDI Key: " + key);
                }
                newJndiList.add(key);
            }
        }
        Tr.debug(tc, "_getJNDINames List: " + newJndiList);
        return newJndiList;
    }

    private void _addToJNDITable(ArrayList list, Map table, String location) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_addToJNDITable", new Object[]{list, table, location});
        }
        for (int i = 0; i < list.size(); ++i) {
            String key = (String)list.get(i);
            if (table.get(key) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New List");
                }
                HashSet<String> set = new HashSet<String>();
                set.add(location);
                table.put(key, set);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Table already contains list");
            }
            HashSet set2 = (HashSet)table.get(key);
            set2.add(location);
            table.put(key, set2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_addToJNDITable", new Object[]{table});
        }
    }

    private String _getEarliestLocation(String jndiKey, String currentTarget) {
        HashSet set;
        Properties props;
        String mistype;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getEarliestLocation", new Object[]{jndiKey, currentTarget});
        }
        if ((mistype = (props = this._getKeyProperties(jndiKey)).getProperty("mistype")) != null) {
            int ind = jndiKey.lastIndexOf(",mistype=");
            jndiKey = jndiKey.substring(0, ind);
            Tr.debug(tc, "jndiKey " + jndiKey);
        }
        if ((set = (HashSet)this.JNDIKeys.get(jndiKey)).contains(currentTarget)) {
            String nodeKey = this._getPreviousLevel(jndiKey);
            if (set.contains(nodeKey)) {
                String cellKey = this._getPreviousLevel(nodeKey);
                if (set.contains(cellKey)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "_getEarliestLocation", new Object[]{cellKey});
                    }
                    return cellKey;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_getEarliestLocation", new Object[]{nodeKey});
                }
                return nodeKey;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_getEarliestLocation", new Object[]{currentTarget});
            }
            return currentTarget;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getEarliestLocation", new Object[]{null});
        }
        return null;
    }

    private String _validateResourceJndiNames(String jndiName, String type, String target, Set searchedKeys, Map keysToSearch, boolean strict) {
        String foundKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_validateResourceJndiNames ", new Object[]{jndiName, target, searchedKeys, keysToSearch, new Boolean(strict)});
        }
        ArrayList currentList = (ArrayList)keysToSearch.get(target);
        if (!searchedKeys.contains(target)) {
            return null;
        }
        searchedKeys.remove(target);
        if (currentList == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In Scope Resources ", this.inScopeResources);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_validateResourceJndiNames - no match", new Object[0]);
            }
            if (!this._isCellTarget(target)) {
                String previousKey = this._getPreviousLevel(target);
                return this._validateResourceJndiNames(jndiName, type, previousKey, searchedKeys, keysToSearch, strict);
            }
        }
        if ((foundKey = this._findJNDIKey(target, jndiName, type, keysToSearch, strict)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find Key");
            }
            if (!this._isCellTarget(target)) {
                String previousKey = this._getPreviousLevel(target);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Still not at cell level, go up: " + previousKey);
                }
                return this._validateResourceJndiNames(jndiName, type, previousKey, searchedKeys, keysToSearch, strict);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find Key, returning null");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_validateResourceJndiNames", foundKey);
        }
        return foundKey;
    }

    private String _findJNDIKey(Set locKeys, String jndiName, String type, Map mapToSearch, boolean strict) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_findJNDIKeyFromSet", new Object[]{locKeys, jndiName, type, mapToSearch});
        }
        Iterator it = locKeys.iterator();
        String found = null;
        while (it.hasNext()) {
            String target = (String)it.next();
            found = this._findJNDIKey(target, jndiName, type, mapToSearch, strict);
            if (found == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_findJNDIKeyFromSet", found);
            }
            return found;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_findJNDIKeyFromSet", found);
        }
        return found;
    }

    private String _findJNDIKey(String target, String jndiName, String type, Map mapToCheck, boolean strict) {
        ArrayList currentList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_findJNDIKey", new Object[]{target, jndiName, type, mapToCheck, new Boolean(strict)});
        }
        if ((currentList = (ArrayList)mapToCheck.get(target)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_findJNDIKey no list");
            }
            return null;
        }
        Iterator it2 = currentList.iterator();
        String foundKey = null;
        while (it2.hasNext()) {
            String jndiKey = (String)it2.next();
            Properties props = this._getKeyProperties(jndiKey);
            String newjndi = props.getProperty("JNDI");
            String newtype = props.getProperty("type");
            if (!newjndi.equals(jndiName) && !newjndi.equals("eis/" + jndiName + "_CMP")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Match name: " + newjndi);
            }
            if (strict) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Strict Match of Type: " + newtype);
                }
                if (type.equals(newtype)) {
                    foundKey = jndiKey;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "_findJNDIKey", new Object[]{foundKey});
                    }
                    return foundKey;
                }
                if (newtype.equals("J2CResourceAdapter") && (type.equals("JDBCProvider") || type.equals("JMS"))) {
                    foundKey = jndiKey;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "_findJNDIKey", new Object[]{foundKey});
                    }
                    return foundKey;
                }
                foundKey = jndiKey = jndiKey + ",mistype=" + type;
                continue;
            }
            foundKey = jndiKey;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_findJNDIKey", new Object[]{foundKey});
            }
            return foundKey;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_findJNDIKey", new Object[]{foundKey});
        }
        return foundKey;
    }

    private ArrayList _getEmbeddedRarJNDIs(AppDeploymentController controller) {
        Vector jndiV;
        AppDeploymentTask task;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "_getEmbeddedRarJNDIs", new Object[]{controller});
            }
            task = null;
            jndiV = new Vector();
            try {
                task = controller.getTaskByName("EmbeddedRar", false);
            }
            catch (AppDeploymentException ex) {
                RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "._getEmbeddedRarJNDIs", "1458", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception when calling getTaskByName: " + ex);
            }
        }
        ArrayList<String> globalJndiList = new ArrayList<String>();
        if (!task.isTaskEmpty()) {
            String[][] taskData = task.getTaskData();
            for (int i = 1; i < taskData.length; ++i) {
                if (taskData[i][5] == null || taskData[i][5].equals("")) continue;
                Tr.debug(tc, "j2c jndi " + taskData[i][5]);
                String type = taskData[i][2];
                String jndiName = taskData[i][5];
                String key = "WebSphere:JNDI=" + jndiName + ",type=" + type;
                globalJndiList.add(key);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getEmbeddedRarJNDIs", new Object[]{jndiV});
        }
        return globalJndiList;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/client/ResValidationHelper.java, WAS.admin.appmgmt.validation, WAS70.SERV1, cf050925.09, ver. 1.22");
        }
        CLASS_NAME = ResValidationHelper.class.getName();
        resTypes = new String[]{"J2CResourceAdapter", "J2CActivationSpec", "J2CAdminObject", "J2CConnectionFactory", "JDBCProvider", "WAS40DataSource", "WAS50DataSource", "JMSProvider", "MailProvider", "URLProvider", "ResourceEnvironmentProvider"};
        resTaskArray = new String[]{"DataSourceFor10CMPBeans", "DataSourceFor20CMPBeans", "DataSourceFor10EJBModules", "DataSourceFor20EJBModules", "MapResRefToEJB", "MapResEnvRefToRes", "MapMessageDestinationRefToEJB", "BindJndiForEJBMessageBinding", "ActSpecJNDI"};
        typeTranslation = new HashMap();
        typeTranslation.put("javax.sql.DataSource", "JDBCProvider");
        typeTranslation.put("javax.mail.Session", "mailSession");
        typeTranslation.put("java.net.URL", "URLProvider");
        typeTranslation.put("javax.jms.QueueConnectionFactory", "JMS");
        typeTranslation.put("javax.jms.TopicConnectionFactory", "JMS");
        typeTranslation.put("javax.jms.ConnectionFactory", "JMS");
        typeTranslation.put("javax.jms.Queue", "JMS");
        typeTranslation.put("javax.jms.Topic", "JMS");
        typeTranslation.put("javax.resource.cci.ConnectionFactory", "J2CResourceAdapter");
    }
}

