/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployUtil;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.dfltbndngs.BindEarCmd;
import com.ibm.ws.management.application.dfltbndngs.BindingError;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.configarchive.EnhancedEarConfigurator;
import com.ibm.ws.management.configarchive.EnhancedEarReader;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveDeploymentInfo
extends AppDeploymentInfo {
    private static final TraceComponent tc = Tr.register(ArchiveDeploymentInfo.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    public static final String destModPath = "ibm.update.mod.path";
    public static final String JAR_XML_EXT_URI = "META-INF/ibm-ejb-jar-ext.xml";
    public static final String JAR_XMI_BINDINGS_URI = "META-INF/ibm-ejb-jar-bnd.xmi";
    public static final String APP_XML_BINDINGS_URI = "META-INF/ibm-application-bnd.xml";
    public static final String APP_XMI_BINDINGS_URI = "META-INF/ibm-application-bnd.xmi";
    public static final String WAR_XMI_BINDINGS_URI = "WEB-INF/ibm-web-bnd.xmi";
    protected EARFile archive;
    protected String archivePath;
    protected Vector saveAsFileTempDirs;
    protected String j2ee12SecurityWarning;
    protected Hashtable moduleForDD;
    protected ApplicationDeployment appDepl;
    protected String modPath = null;
    protected List enhancedEarWorkspaces = new ArrayList();
    protected List enhancedEarConfigurators = new ArrayList();
    private static long saveAsTempDirBase;
    protected Resource deplResource;
    protected Resource enh_deplResource;
    private boolean _isEntitled = false;

    public ArchiveDeploymentInfo(EARFile ear) throws AppDeploymentException {
        this(ear, new Hashtable());
    }

    public ArchiveDeploymentInfo(EARFile ear, Hashtable prefs) throws AppDeploymentException {
        super(prefs);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ArchiveDeploymentInfo", new Object[]{"ear=" + ear.getURI(), "prefs=" + prefs});
        }
        this.archive = ear;
        this.j2ee12SecurityWarning = null;
        this.moduleForDD = null;
        this.modPath = (String)prefs.get(destModPath);
        this.setApplication(this.archive.getDeploymentDescriptor());
        this.setApplicationBindings(this.archive.getBindings());
        this.setApplicationExtensions(this.archive.getExtensions());
        if (this.appBinding == null) {
            throw new AppDeploymentException("Null application bindings. Possibly corrupt ear file.", null);
        }
        if (this.appExtension == null) {
            throw new AppDeploymentException("Null application extension. Possibly corrupt ear file.", null);
        }
        if (this.appBinding.getApplication() == null) {
            throw new AppDeploymentException("Application bindings file does not contain a reference to the deployment descriptor.  Corrupt ear file. Check if META-INF/ibm-application-bnd.xmi uri in the ear file contains a valid application href tag.", null);
        }
        if (this.appExtension.getApplication() == null) {
            throw new AppDeploymentException("Application extensions file does not contain a reference to the deployment descriptor.  Corrupt ear file. Check if META-INF/ibm-application-ext.xmi uri in the ear file contains a valid application href tag.", null);
        }
        String earURI = ear.getURI();
        if (new java.io.File(earURI).exists() && AppUtils.isEntitled()) {
            if (prefs.get("EditAppOnly") == null && prefs.get("EditModuleOnly") == null && !AppUtils.isAppEntitled(earURI)) {
                Tr.error(tc, "ADMA9006E", new Object[]{earURI, AppUtils.getProductName()});
                throw new AppDeploymentException("This application is not licensed to be installed in this server", null);
            }
            this._isEntitled = true;
        }
        ear.rollUpRoles();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ArchiveDeploymentInfo");
        }
    }

    @Override
    protected Vector createModuleConfig(String type) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createModuleConfig", new Object[]{"type=" + type});
        }
        if (this.archive == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createModuleConfig", "Archive is null.");
            }
            return null;
        }
        Vector<EObject> v = new Vector<EObject>();
        EList list = this.archive.getDeploymentDescriptor().getModules();
        for (Module module : list) {
            if (!(type.startsWith("JAR") && module.isEjbModule() || type.startsWith("EJB3JAR") && module.isEjbModule() || type.startsWith("WAR") && module.isWebModule() || type.startsWith("WEB25WAR") && module.isWebModule()) && (!type.startsWith("RAR") || !module.isConnectorModule())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing JAR/WAR/RAR module " + module.getUri());
            }
            try {
                WebApp web;
                EJBJar jar;
                String uri;
                if (type.endsWith("DD")) {
                    if (this.archive.getDeploymentDescriptor(module) != null) {
                        if (module.isEjbModule()) {
                            if (type.startsWith("JAR")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding " + module.getUri() + " DD into the return list");
                                }
                                v.addElement(this.archive.getDeploymentDescriptor(module));
                                continue;
                            }
                            if (!type.startsWith("EJB3JAR")) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "return ee5 jar only");
                            }
                            boolean isEE5Mod = AppDeploymentUtil.isEE5SchemaDD(module, this.archive);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "isEE5Mod: " + isEE5Mod);
                            }
                            if (isEE5Mod) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding " + module.getUri() + " DD into the return list");
                                }
                                v.addElement(this.archive.getDeploymentDescriptor(module));
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Skipping " + module.getUri());
                            continue;
                        }
                        if (module.isWebModule()) {
                            if (type.startsWith("WAR")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding " + module.getUri() + " DD into the return list");
                                }
                                v.addElement(this.archive.getDeploymentDescriptor(module));
                                continue;
                            }
                            if (!type.startsWith("WEB25WAR")) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "return ee5 war only");
                            }
                            boolean isEE5Mod = AppDeploymentUtil.isEE5SchemaDD(module, this.archive);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "isEE5Mod: " + isEE5Mod);
                            }
                            if (isEE5Mod) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding " + module.getUri() + " DD into the return list");
                                }
                                v.addElement(this.archive.getDeploymentDescriptor(module));
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Skipping " + module.getUri());
                            continue;
                        }
                        if (!module.isConnectorModule() || !type.startsWith("RAR")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding " + module.getUri() + " DD into the return list");
                        }
                        v.addElement(this.archive.getDeploymentDescriptor(module));
                        continue;
                    }
                    if (type.startsWith("EJB3JAR") || type.startsWith("WEB25WAR")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding ee5 module " + module.getUri() + " DD into the return list");
                        }
                        v.addElement(this.archive.getDeploymentDescriptor(module));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Skipping " + module.getUri());
                    continue;
                }
                if (type.endsWith("BND")) {
                    EObject obj = this.archive.getBindings(module);
                    uri = "";
                    if (obj != null) {
                        uri = obj.eResource().getURI().toString();
                    }
                    if (type.startsWith("JAR") || type.startsWith("EJB3JAR")) {
                        if (obj != null) {
                            jar = ((EJBJarBinding)obj).getEjbJar();
                            if (jar == null || jar.eIsProxy()) {
                                Tr.warning(tc, "ADMA0091E", new String[]{uri, uri, module.getUri(), "" + jar});
                                ((EJBJarBinding)obj).setEjbJar((EJBJar)this.archive.getDeploymentDescriptor(module));
                                jar = ((EJBJarBinding)obj).getEjbJar();
                            }
                            if (jar != null) {
                                if (type.startsWith("EJB3JAR")) {
                                    if (AppDeploymentUtil.isEE5SchemaDD(module, this.archive)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding EJB 3.0 jar binding for module " + module.getUri());
                                        }
                                        v.addElement(obj);
                                    }
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding jar binding for module " + module.getUri());
                                    }
                                    v.addElement(obj);
                                }
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ArchiveDeploymentInfo.createModuleConfig: archive.getBindings(module) was null, skipping adding module: " + module.getUri());
                        }
                    }
                    if (!type.equals("WAR_BND")) continue;
                    if (obj != null) {
                        web = ((WebAppBinding)obj).getWebapp();
                        if (web == null || web.eIsProxy()) {
                            Tr.warning(tc, "ADMA0091E", new String[]{uri, uri, module.getUri(), "" + web});
                            ((WebAppBinding)obj).setWebapp((WebApp)this.archive.getDeploymentDescriptor(module));
                        }
                        v.addElement(obj);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "ArchiveDeploymentInfo.createModuleConfig: archive.getBindings(module) was null, skipping adding module: " + module.getUri());
                    continue;
                }
                if (!type.endsWith("EXT") || type.startsWith("RAR")) continue;
                EObject obj = this.archive.getExtensions(module);
                uri = "";
                if (obj != null) {
                    uri = obj.eResource().getURI().toString();
                }
                if (type.equals("JAR_EXT")) {
                    if (obj != null) {
                        jar = ((EJBJarExtension)obj).getEjbJar();
                        if (jar == null || jar.eIsProxy()) {
                            Tr.warning(tc, "ADMA0091E", new String[]{uri, uri, module.getUri(), "" + jar});
                            ((EJBJarExtension)obj).setEjbJar((EJBJar)this.archive.getDeploymentDescriptor(module));
                            jar = ((EJBJarExtension)obj).getEjbJar();
                        }
                        if (jar != null && AppDeploymentUtil.isEE5SchemaDD(module, this.archive)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding EJB 3.0 jar extension for module " + module.getUri());
                            }
                            v.addElement(obj);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding jar extension for module " + module.getUri());
                            }
                            v.addElement(obj);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ArchiveDeploymentInfo.createModuleConfigarchive.getExtensions(module) was null, skipping adding module: " + module.getUri());
                    }
                }
                if (type.equals("WAR_EXT")) {
                    if (obj == null) continue;
                    web = ((WebAppExtension)obj).getWebApp();
                    if (web == null || web.eIsProxy()) {
                        Tr.warning(tc, "ADMA0091E", new String[]{uri, uri, module.getUri(), "" + web});
                        ((WebAppExtension)obj).setWebApp((WebApp)this.archive.getDeploymentDescriptor(module));
                    }
                    v.addElement(obj);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ArchiveDeploymentInfo.createModuleConfigarchive.getExtensions(module) was null, skipping adding module: " + module.getUri());
            }
            catch (Exception ex) {
                AppDeploymentException ade = new AppDeploymentException("Unexpected exception.", ex);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createModuleConfig", ade);
                }
                throw ade;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createModuleConfig", v);
        }
        return v;
    }

    @Override
    public Module getModuleForDD(EObject obj) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleForDD", "obj=" + obj);
        }
        Module theModule = null;
        if (this.moduleForDD == null) {
            this.moduleForDD = new Hashtable();
            EList list = this.archive.getDeploymentDescriptor().getModules();
            for (Module module : list) {
                if (module.isJavaModule()) continue;
                try {
                    if (this.archive.getDeploymentDescriptor(module) == null) continue;
                    this.moduleForDD.put(this.archive.getDeploymentDescriptor(module), module);
                }
                catch (Exception fex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got Exception in getting module dd " + module + " -- exc: " + fex);
                    }
                    throw new AppDeploymentException("", fex);
                }
            }
        }
        theModule = (Module)this.moduleForDD.get(obj);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleForDDLocal", theModule);
        }
        return theModule;
    }

    @Override
    public ModuleFile getModuleFileForDD(EObject obj) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleFileForDD", "obj=" + obj);
        }
        ModuleFile theModuleFile = null;
        Module theModule = this.getModuleForDD(obj);
        if (theModule != null) {
            try {
                theModuleFile = this.archive.getModuleRef(theModule).getModuleFile();
            }
            catch (Exception fex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got Exception in getting module file for module  " + theModule + " -- exc: " + fex);
                }
                throw new AppDeploymentException("", fex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleFileForDD", theModuleFile);
        }
        return theModuleFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close(boolean bSave) throws AppDeploymentException {
        int i;
        String earURI2222;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", Boolean.toString(bSave));
        }
        if (this.archive == null) {
            Tr.warning(tc, "ADMA0142W", "Trying to close the archive that is already closed.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close", "Null archive.");
            }
            return;
        }
        java.io.File f = new java.io.File(this.archive.getURI());
        try {
            try {
                boolean isDir;
                boolean bl = isDir = f.exists() && f.isDirectory();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isDir: " + isDir);
                }
                if (bSave) {
                    if (!isDir) {
                        this.archive.save();
                    } else {
                        this.archive.extractNoReopen(66);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "modPath=" + this.modPath);
                }
                if (!isDir && this.modPath != null) {
                    Application application;
                    EList modules;
                    Module module;
                    WebModule webModule;
                    String contextRoot;
                    List moduleFiles = this.archive.getModuleFiles();
                    ModuleFile moduleFile = (ModuleFile)moduleFiles.get(0);
                    moduleFile.saveAs(this.modPath);
                    if (moduleFile.isWARFile() && this.options.get("contextroot") == null && (contextRoot = (webModule = (WebModule)(module = (Module)(modules = (application = this.archive.getDeploymentDescriptor()).getModules()).get(0))).getContextRoot()) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "close", "contextRoot=" + contextRoot);
                        }
                        this.options.put("contextroot", contextRoot);
                    }
                }
                if (this.deplResource != null) {
                    this.deplResource.unload();
                }
                if (this.enh_deplResource != null) {
                    this.enh_deplResource.unload();
                }
            }
            catch (Throwable th) {
                AppDeploymentException ade = new AppDeploymentException("Unexpected exception processing archive file.", th);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "close", ade);
                }
                throw ade;
            }
            Object var12_14 = null;
            earURI2222 = this.getURI();
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            String earURI2222 = this.getURI();
            this.archivePath = this.archive.getURI();
            this.archive.close();
            this.archive = null;
            if (this._isEntitled && bSave) {
                try {
                    if (!new java.io.File(earURI2222).isDirectory()) {
                        AppUtils.signEntitledApplication(earURI2222);
                    }
                    if (this.modPath != null && !new java.io.File(this.modPath).isDirectory()) {
                        AppUtils.signEntitledApplication(this.modPath);
                    }
                }
                catch (Exception e) {
                    AppDeploymentException ade = new AppDeploymentException("Error re-signing entitled application", e);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "close", ade);
                    }
                    throw ade;
                }
            }
            if (this.modPath != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting " + f.getPath());
                }
                f.delete();
            }
            throw throwable;
        }
        this.archivePath = this.archive.getURI();
        this.archive.close();
        this.archive = null;
        if (this._isEntitled && bSave) {
            try {}
            catch (Exception e) {
                AppDeploymentException ade = new AppDeploymentException("Error re-signing entitled application", e);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "close", ade);
                }
                throw ade;
            }
            if (!new java.io.File(earURI2222).isDirectory()) {
                AppUtils.signEntitledApplication(earURI2222);
            }
            if (this.modPath != null && !new java.io.File(this.modPath).isDirectory()) {
                AppUtils.signEntitledApplication(this.modPath);
            }
        }
        if (this.modPath != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deleting " + f.getPath());
            }
            f.delete();
        }
        this.moduleData.clear();
        if (this.saveAsFileTempDirs != null) {
            for (i = 0; i < this.saveAsFileTempDirs.size(); ++i) {
                try {
                    AppUtils.deleteDirTree((String)this.saveAsFileTempDirs.elementAt(i));
                    continue;
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Error deleting temp dir: " + (String)this.saveAsFileTempDirs.elementAt(i) + ", " + ex);
                }
            }
            this.saveAsFileTempDirs = null;
        }
        if (this.enhancedEarConfigurators != null) {
            for (i = 0; i < this.enhancedEarConfigurators.size(); ++i) {
                this.cleanUpEarConfigurator((EnhancedEarConfigurator)this.enhancedEarConfigurators.get(i));
            }
            this.enhancedEarConfigurators.clear();
        }
        if (this.enhancedEarWorkspaces != null) {
            for (i = 0; i < this.enhancedEarWorkspaces.size(); ++i) {
                this.cleanUpEarWorkSpace((WorkSpace)this.enhancedEarWorkspaces.get(i));
            }
            this.enhancedEarWorkspaces.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    @Override
    public Hashtable getSavedResults() {
        Hashtable tbl = new Hashtable();
        Enumeration vEnum = this.options.keys();
        while (vEnum.hasMoreElements()) {
            String key = (String)vEnum.nextElement();
            tbl.put(key, this.options.get(key));
        }
        if (this.archivePath != null) {
            tbl.put("original.ear.location", this.archivePath);
        }
        return tbl;
    }

    public void createDefaultBindings(Preferences prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDefaultBindings", "prefs=" + prefs);
        }
        try {
            Vector jarBnds = this.getModuleConfig("JAR_BND");
            Vector warBnds = this.getModuleConfig("WAR_BND");
            Vector jarExts = this.getModuleConfig("JAR_EXT");
            Vector warExts = this.getModuleConfig("WAR_EXT");
            BindEarCmd binder = null;
            binder = prefs != null ? new BindEarCmd(this.archive, prefs) : new BindEarCmd(this.archive, true);
            binder.bind();
        }
        catch (BindingError err) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during creation of default bindings: " + err);
            }
            Throwable t = this.getRootError(err);
            AppDeploymentException ade = new AppDeploymentException(err.toString(), t);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDefaultBindings", ade);
            }
            throw ade;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultBindings");
        }
    }

    @Override
    public String getSecurityPolicyData(ResourceBundle resBundle) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityPolicyData");
        }
        String retVal = null;
        InputStream inStream = null;
        if (this.archive != null) {
            try {
                try {
                    inStream = this.archive.getResourceInputStream("META-INF/was.policy");
                }
                catch (FileNotFoundException ex) {
                    inStream = null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Input stream: " + inStream);
                }
                if (inStream == null) {
                    String appVersion = this.getJ2EEAppVersion();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "App Version: " + appVersion);
                    }
                    if (appVersion != null && appVersion.equals(AppConstants.APPDEPL_APP_VERSION_1_2)) {
                        ClassLoader loader = this.getClass().getClassLoader();
                        inStream = loader.getResourceAsStream("was.policy");
                        if (inStream != null) {
                            this.saveAsFile(null, "META-INF/was.policy", inStream);
                            this.j2ee12SecurityWarning = AppUtils.getMessage(resBundle, "ADMA0080W");
                            Tr.warning(tc, "ADMA0080W");
                            try {
                                inStream = this.archive.getResourceInputStream("META-INF/was.policy");
                            }
                            catch (FileNotFoundException ex) {
                                inStream = null;
                            }
                        } else {
                            this.j2ee12SecurityWarning = AppUtils.getMessage(resBundle, "ADMA0081W");
                            Tr.warning(tc, "ADMA0081W");
                        }
                    }
                }
                if (inStream != null) {
                    byte[] bar;
                    int bRead;
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    int avail = inStream.available();
                    while (avail > 0 && (bRead = inStream.read(bar = new byte[avail])) != -1) {
                        bo.write(bar, 0, bRead);
                        avail = inStream.available();
                    }
                    bo.flush();
                    retVal = bo.toString();
                    bo.close();
                    inStream.close();
                }
            }
            catch (Exception ex) {
                AppUtils.dbg(tc, "Unexpected exception caught while: " + ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityPolicyData", retVal);
        }
        return retVal;
    }

    @Override
    public String getSecurityPolicyWarning() {
        return this.j2ee12SecurityWarning;
    }

    @Override
    public void saveAsFile(String moduleUri, String fileUriInModule, InputStream in) throws AppDeploymentException {
        String tempDir = ArchiveDeploymentInfo.saveAsFile(this.archive, moduleUri, fileUriInModule, in);
        if (tempDir != null) {
            if (this.saveAsFileTempDirs == null) {
                this.saveAsFileTempDirs = new Vector();
            }
            this.saveAsFileTempDirs.addElement(tempDir);
        }
    }

    public static String saveAsFile(EARFile archive, String moduleUri, String fileUriInModule, InputStream in) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveAsFile", new Object[]{"archive=" + archive.getURI(), "moduleUri=" + moduleUri, "fileUri=" + fileUriInModule, "in=" + in});
        }
        String tempDir = null;
        if (in == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "inputStream is null");
            }
        } else {
            if (archive == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "saveAsFile", "Null archive.");
                }
                return null;
            }
            Archive foundArchive = null;
            if (moduleUri == null || moduleUri.trim().equals("")) {
                foundArchive = archive;
            } else {
                Iterator allArchiveFiles = archive.getArchiveFiles().iterator();
                while (allArchiveFiles.hasNext() && !(foundArchive = (Archive)allArchiveFiles.next()).getURI().equals(moduleUri)) {
                    foundArchive = null;
                }
            }
            if (foundArchive != null) {
                Exception error;
                block43: {
                    FileOutputStream out;
                    block42: {
                        java.io.File dir;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "found matching archive: " + foundArchive);
                        }
                        ArchiveInit.init();
                        CommonarchiveFactory archiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                        error = null;
                        String saveAsTempDir = AppUtils.getTempDir();
                        while ((dir = new java.io.File(tempDir = saveAsTempDir + "save_" + String.valueOf(++saveAsTempDirBase))).exists()) {
                        }
                        dir.mkdirs();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "temp dirname: " + tempDir);
                        }
                        String fileUri = tempDir;
                        if (fileUriInModule != null && !fileUriInModule.equals("")) {
                            fileUri = fileUri + java.io.File.separator + fileUriInModule;
                        }
                        dir = new java.io.File(fileUri);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "save file location: " + fileUri);
                        }
                        dir = new java.io.File(dir.getParent());
                        out = null;
                        try {
                            if (dir.exists()) {
                                AppUtils.deleteDirTree(dir);
                            }
                            dir.mkdirs();
                            out = new FileOutputStream(fileUri);
                            if (out != null) {
                                int byte_read = 0;
                                byte[] buffer = new byte[1024];
                                while ((byte_read = in.read(buffer)) != -1) {
                                    out.write(buffer, 0, byte_read);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "out: " + out);
                                }
                                out.close();
                                out = null;
                                ReadOnlyDirectory readDir = archiveFactory.openReadOnlyDirectory(tempDir);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "readDir abs path: " + readDir.getAbsolutePath());
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "file : " + readDir.getAbsolutePath() + java.io.File.separator + fileUriInModule);
                                }
                                File file = null;
                                String uri = fileUriInModule.replace('\\', '/');
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "look for " + uri + " in readOnly directory");
                                }
                                try {
                                    file = readDir.getFileInSelfOrSubdirectory(uri);
                                }
                                catch (Throwable fnf) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "exception received: " + fnf.toString());
                                    }
                                    fnf.printStackTrace();
                                    file = null;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "file in readDir: " + file);
                                }
                                if (file != null && foundArchive.isDuplicate(fileUriInModule)) {
                                    FileIterator iter = foundArchive.getFilesForSave();
                                    while (iter.hasNext()) {
                                        File removeFile = iter.next();
                                        if (!removeFile.getURI().equals(fileUriInModule)) continue;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, ".... Removing existing file");
                                        }
                                        foundArchive.remove(removeFile);
                                        break;
                                    }
                                }
                                if (file != null) {
                                    foundArchive.addCopy(file);
                                }
                                break block42;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Not able to create the input stream as a file");
                            }
                        }
                        catch (Exception ex) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "File IO exception: " + ex);
                            }
                            error = ex;
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ex) {
                            if (!tc.isDebugEnabled()) break block43;
                            Tr.debug(tc, "Error closing save file: " + out + ", " + ex);
                        }
                    }
                }
                if (error != null) {
                    AppDeploymentException ade = new AppDeploymentException("Unexpected exception.", error);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "saveAsFile", ade);
                    }
                    throw ade;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not able to find matching module: " + moduleUri);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveAsFile", tempDir);
        }
        return tempDir;
    }

    @Override
    public String getAppDisplayName() {
        Object o = this.options.get("appname");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "app name from options " + o);
        }
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return AppInstallHelper.getAppDisplayName(this.archive, this.options);
    }

    public String getURI() {
        return this.archive.getURI();
    }

    private Throwable getRootError(BindingError err) {
        Throwable rootErr;
        for (rootErr = err; rootErr != null && rootErr instanceof BindingError && rootErr.getChainedEx() != null; rootErr = rootErr.getChainedEx()) {
        }
        return rootErr;
    }

    public Resource getResource(String modUri, String uri, String resURI) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", new Object[]{"modUri=" + modUri, "uri=" + uri, "resURI=" + resURI});
        }
        Resource res = null;
        if (this.archive.containsFile(uri)) {
            InputStream is = this.archive.getInputStream(uri);
            WASResourceSetImpl resourceSet = new WASResourceSetImpl();
            URI fileURI = URI.createURI(resURI);
            res = resourceSet.createResource(fileURI);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res is: " + res);
            }
            HashMap options = new HashMap();
            res.load(is, options);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", res);
        }
        return res;
    }

    @Override
    public Resource getAppDeploymentResource(boolean processEmbeddedCfg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentResoource", new Object[]{"processEmbeddedCfg=" + Boolean.toString(processEmbeddedCfg)});
        }
        Resource res = super.getAppDeploymentResource(processEmbeddedCfg);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deplres in memory: " + res);
        }
        if (res != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentResource", res);
            }
            return res;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deplResource: " + this.deplResource);
        }
        if (this.deplResource != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentResource", this.deplResource);
            }
            return this.deplResource;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enh_deplResource: " + this.enh_deplResource);
        }
        if (processEmbeddedCfg && this.enh_deplResource != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentResource", this.enh_deplResource);
            }
            return this.enh_deplResource;
        }
        try {
            this.deplResource = this.getResource(null, "deployment.xml", "deployment.xml");
            if (this.deplResource == null && EnhancedEarReader.isEnhancedEar(this.archive)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null root deployment.xml. Get deployment.xml from enhanced ear");
                }
                this.enh_deplResource = EnhancedEarReader.getDeployment(this.archive);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getAppDeploymentResource", this.enh_deplResource);
                }
                return this.enh_deplResource;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentResource", this.deplResource);
            }
            return this.deplResource;
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring exception loading depl resource:", th);
            }
            RasUtils.logException(th, tc, CLASS_NAME, "getAppDeploymentResource", "1099", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentResource", null);
            }
            return null;
        }
    }

    public ApplicationDeployment getAppDeploymentObject(boolean processEmbeddedCfg) {
        ApplicationDeployment appDeployment = null;
        Resource res = this.getAppDeploymentResource(processEmbeddedCfg);
        if (res != null) {
            Deployment deployment = (Deployment)res.getContents().get(0);
            appDeployment = (ApplicationDeployment)deployment.getDeployedObject();
        }
        return appDeployment;
    }

    public boolean checkIfEarDeployed() {
        boolean earDeployed;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkIfEarDeployed");
            }
            earDeployed = true;
            try {
                try {
                    Class.forName("com.ibm.etools.ejbdeploy.EJBDeploymentException");
                }
                catch (ClassNotFoundException ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "com.ibm.etools.ejbdeploy.EJBDeploymentException is not packaged in the install");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfEarDeployed", earDeployed);
                    }
                    return earDeployed;
                }
                List ejbJarList = this.archive.getEJBJarFiles();
                for (int i = 0; i < ejbJarList.size(); ++i) {
                    EJBJarFile ejbJarFile = (EJBJarFile)ejbJarList.get(i);
                    EJBJar ejbJarDD = ejbJarFile.getDeploymentDescriptor();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CMP size: " + ejbJarDD.getContainerManagedBeans().size());
                    }
                    if (AppDeploymentUtil.isEE5SchemaDD(ejbJarFile) && (ejbJarDD == null || ejbJarDD.getContainerManagedBeans().size() <= 0)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checking if " + ejbJarFile.getURI() + " has been EJBDeployed");
                    }
                    if (DeployUtil.isEJBJarDeployed(ejbJarFile)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EJB jar not deployed. Defaulting to run EJBDeploy.");
                    }
                    earDeployed = false;
                    break;
                }
            }
            catch (Throwable th) {
                Tr.warning(tc, "ADMA0143W", new Object[]{th});
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "checkIfEarDeployed", new Object[]{"Ignoring exception:", th});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfEarDeployed", Boolean.toString(earDeployed));
        }
        return earDeployed;
    }

    public boolean checkIfEnhancedEar() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfEnhancedEar");
        }
        boolean flag = true;
        try {
            flag = EnhancedEarReader.isEnhancedEar(this.archive);
            if (flag) {
                this.enh_deplResource = EnhancedEarReader.getDeployment(this.archive);
            }
        }
        catch (Throwable th) {
            Tr.warning(tc, "ADMA0104W", th);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkIfEnhancedEar", new Object[]{"Ignoring exception:", th});
            }
            flag = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfEnhancedEar", Boolean.toString(flag));
        }
        return flag;
    }

    @Override
    public boolean isStandaloneDeployment() {
        if (this.archive == null) {
            return false;
        }
        return this.archive.containsFile("META-INF/was.ejbmodule") || this.archive.containsFile("META-INF/was.webmodule");
    }

    @Override
    public InputStream getInputStream(String moduleURI, String fileURI) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream", new Object[]{"moduleURI=" + moduleURI, "fileURI=" + fileURI});
        }
        InputStream is = null;
        try {
            if (moduleURI == null) {
                is = this.archive.getInputStream(fileURI);
            } else {
                List f = this.archive.getModuleFiles();
                for (int i = 0; i < f.size(); ++i) {
                    ModuleFile mod = (ModuleFile)f.get(i);
                    if (!mod.getURI().equals(moduleURI)) continue;
                    is = mod.getInputStream(fileURI);
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInputStream", is);
            }
            return is;
        }
        catch (IOException ioex) {
            AppDeploymentException ade = new AppDeploymentException("Unexpected exception.", ioex);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInputStream", ade);
            }
            throw ade;
        }
    }

    @Override
    public boolean containsURI(String moduleURI, String fileURI) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsURI", new Object[]{"moduleURI=" + moduleURI, "fileURI=" + fileURI});
        }
        boolean uriMatch = false;
        if (moduleURI == null) {
            uriMatch = this.archive.containsFile(fileURI);
        } else {
            List modFileList = this.archive.getModuleFiles();
            for (int i = 0; i < modFileList.size(); ++i) {
                ModuleFile mod = (ModuleFile)modFileList.get(i);
                if (!mod.getURI().equals(moduleURI)) continue;
                uriMatch = mod.containsFile(fileURI);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsURI", Boolean.toString(uriMatch));
        }
        return uriMatch;
    }

    public Class loadClass(EObject obj, String className, String type) {
        Class cls;
        block14: {
            ArchiveFileDynamicClassLoader racl;
            ClassLoader ecl;
            ModuleFile mf;
            block13: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "loadClass", new Object[]{"obj=" + obj, "className=" + className, "type=" + type});
                }
                ResourcesPackage respkg = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
                ResourcesFactory resFact = respkg.getResourcesFactory();
                cls = null;
                mf = null;
                try {
                    mf = this.getModuleFileForDD(obj);
                }
                catch (AppDeploymentException e1) {
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "Failed to get DD" + e1);
                }
            }
            if (mf == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadClass", "Null module file for DD.");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadClass", "module=" + mf);
            }
            if ((ecl = ExtClassLoader.getInstance()) == null) {
                ecl = ArchiveDeploymentInfo.class.getClassLoader();
            }
            if ((racl = new ArchiveFileDynamicClassLoader(mf, ecl, null)) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadClass", "Null archive file dynamic class loader.");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadClass", "classLoader=" + racl);
            }
            try {
                cls = J2CAppUtils.getDefinedClass((String)className, (ClassLoader)racl);
            }
            catch (AdminException e) {
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug(tc, "loadClass", new Object[]{"Failed to get defined class.", e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadClass", "class=" + cls);
        }
        return cls;
    }

    public static Hashtable loadJCAProps(org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile earFile) {
        Hashtable<String, String> tbl;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadJCAProps", "earFile=" + earFile.getName());
            }
            tbl = null;
            try {
                File f = earFile.getFile("META-INF/ibm-jcajndi.props");
                InputStream is = f.getInputStream();
                tbl = new Hashtable<String, String>();
                ArchiveDeploymentInfo.loadJcaProps(is, tbl);
            }
            catch (FileNotFoundException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadJCAProps", new Object[]{"Ignoring exception:", e});
                }
            }
            catch (IOException e) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "loadJCAProps", new Object[]{"Ignoring exception:", e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadJCAProps", tbl);
        }
        return tbl;
    }

    private static void loadJcaProps(InputStream is, Hashtable<String, String> tbl) {
        block3: {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    int indx = line.indexOf("=");
                    if (indx == -1) continue;
                    String key = line.substring(0, indx);
                    String value = line.substring(indx + 1);
                    tbl.put(key, value);
                }
            }
            catch (IOException e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "loadJcaProps", new Object[]{"Ignoring exception:", e});
            }
        }
    }

    public ArchiveManifest getEarManifest() {
        return this.archive.getManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getEnhancedEarDeploymentResource(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnhancedEarDeploymentResource", new Object[]{resourceName});
        }
        EnhancedEarConfigurator enhConfig = null;
        WorkSpace enhWs = null;
        Resource res = null;
        try {
            block14: {
                try {
                    enhWs = ConfigRepoHelper.getWorkSpace(null);
                    enhConfig = new EnhancedEarConfigurator(enhWs, this.archive, true, "default", "appName", "appName.ear_");
                    if (enhConfig.isEnhancedEar()) {
                        res = enhConfig.getDeploymentResource(resourceName);
                        if (res != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getEnhancedEarDeploymentResource", "Adding enhanced ear workspace " + enhWs + " to list to be deleted");
                            }
                            this.enhancedEarWorkspaces.add(enhWs);
                            this.enhancedEarConfigurators.add(enhConfig);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getEnhancedEarDeploymentResource", "No Deployment resource.");
                        }
                        break block14;
                    }
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "getEnhancedEarDeploymentResource", "Not an enhanced ear.");
                }
                catch (Throwable e) {
                    Tr.warning(tc, "ADMA0104W", e);
                    Object var7_6 = null;
                    if (res == null) {
                        this.cleanUpEarWorkSpace(enhWs);
                        this.cleanUpEarConfigurator(enhConfig);
                    }
                }
            }
            Object var7_5 = null;
            if (res == null) {
                this.cleanUpEarWorkSpace(enhWs);
                this.cleanUpEarConfigurator(enhConfig);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (res == null) {
                this.cleanUpEarWorkSpace(enhWs);
                this.cleanUpEarConfigurator(enhConfig);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnhancedEarDeploymentResource", new Object[]{res});
        }
        return res;
    }

    private boolean isEE5Module(Module module, EObject xmlDD) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEE5Module", new Object[]{"module=" + module, "xmlDD=" + xmlDD});
        }
        boolean ret = false;
        if (AppDeploymentUtil.isEE5SchemaDD(module, this.archive) || this.isMetadataIncomplete(module)) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEE5Module", Boolean.toString(ret));
        }
        return ret;
    }

    private boolean isMetadataIncomplete(Module module) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMetadataIncomplete", new Object[]{"module=" + module});
        }
        boolean ret = true;
        ModuleFile theModuleFile = this.archive.getModuleRef(module).getModuleFile();
        if (theModuleFile != null) {
            try {
                InputStream is = theModuleFile.getInputStream(JAR_XML_EXT_URI);
            }
            catch (IOException ioe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "io exception - setting return to false");
                }
                ret = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMetadataIncomplete", Boolean.toString(ret));
        }
        return ret;
    }

    private void cleanUpEarWorkSpace(WorkSpace workSpace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanUpEarWorkSpace", "workSpace=" + workSpace);
        }
        try {
            if (workSpace != null) {
                ConfigRepoHelper.removeWorkSpace(false, workSpace);
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, CLASS_NAME + ".cleanUpEarWorkSpace", "1496", this);
            Tr.warning(tc, "ADMA0077W", th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanUpEarWorkSpace");
        }
    }

    private void cleanUpEarConfigurator(EnhancedEarConfigurator configurator) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanUpEarConfigurator", "configurator=" + configurator);
            }
            try {
                if (configurator != null) {
                    configurator.cleanup();
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException(th, CLASS_NAME + ".cleanUpEarConfigurator", "1510", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "checkIfEnhancedEar", new Object[]{"Wrote FFDC for exception:", th});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanUpEarConfigurator");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/client/ArchiveDeploymentInfo.java, WAS.admin.appmgmt.client, WAS70.SERV1, cf050925.09, ver. 1.55.5.1");
        }
        CLASS_NAME = ArchiveDeploymentInfo.class.getName();
        saveAsTempDirBase = System.currentTimeMillis();
    }
}

