/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentProfile;
import com.ibm.ws.management.application.client.util;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public abstract class AppDeploymentInfo
implements AppConstants {
    public static final String JAR = "JAR";
    public static final String WAR = "WAR";
    public static final String RAR = "RAR";
    public static final String EJB3JAR = "EJB3JAR";
    public static final String WEB25WAR = "WEB25WAR";
    public static final String DD = "DD";
    public static final String BND = "BND";
    public static final String EXT = "EXT";
    public static final String JAR_DD = "JAR_DD";
    public static final String JAR_BND = "JAR_BND";
    public static final String JAR_EXT = "JAR_EXT";
    public static final String EJB3JAR_DD = "EJB3JAR_DD";
    public static final String EJB3JAR_BND = "EJB3JAR_BND";
    public static final String WAR_DD = "WAR_DD";
    public static final String WAR_BND = "WAR_BND";
    public static final String WAR_EXT = "WAR_EXT";
    public static final String WEB25WAR_DD = "WEB25WAR_DD";
    public static final String RAR_DD = "RAR_DD";
    public static final String RAR_BND = "RAR_BND";
    public static final String DEPL_RES = "edit.deplresource";
    protected Hashtable options;
    protected transient Hashtable moduleData;
    protected transient Application app;
    protected transient ApplicationBinding appBinding;
    protected transient ApplicationExtension appExtension;
    private static TraceComponent tc = Tr.register(AppDeploymentInfo.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentInfo() {
        this(new Hashtable());
    }

    public AppDeploymentInfo(Hashtable prefs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppDeploymentInfo");
        }
        this.options = new Hashtable();
        this.populateOptions(prefs);
        this.moduleData = new Hashtable();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Options are: " + this.options);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppDeploymentInfo");
        }
    }

    private void populateOptions(Hashtable prefs) {
        if (this.options.get("deployejb.options") == null) {
            this.options.put("deployejb.options", AppDeploymentInfo.createDefaultDeployEJBOptions());
        }
        if (this.options.get("deployws.options") == null) {
            this.options.put("deployws.options", AppDeploymentInfo.createDefaultDeployWSOptions());
        }
    }

    public static Hashtable createDefaultDeployEJBOptions() {
        Hashtable<String, Object> deployOptions = new Hashtable<String, Object>();
        Vector v = AppDeploymentProfile.getDeployEJBProfile();
        for (int i = 0; i < v.size(); ++i) {
            AppDeploymentProfile.DeplOption opt = (AppDeploymentProfile.DeplOption)v.elementAt(i);
            deployOptions.put(opt.name, opt.defaultVal);
        }
        return deployOptions;
    }

    public static Hashtable createDefaultDeployWSOptions() {
        Hashtable<String, Object> deployOptions = new Hashtable<String, Object>();
        Vector v = AppDeploymentProfile.getDeployWSProfile();
        for (int i = 0; i < v.size(); ++i) {
            AppDeploymentProfile.DeplOption opt = (AppDeploymentProfile.DeplOption)v.elementAt(i);
            deployOptions.put(opt.name, opt.defaultVal);
        }
        return deployOptions;
    }

    public Hashtable getAppOptions() {
        return this.options;
    }

    public void setAppOptions(Hashtable h) {
        this.options = h;
    }

    public Application getApplication() {
        return this.app;
    }

    public void setApplication(Application a) {
        this.app = a;
    }

    public ApplicationBinding getApplicationBindings() {
        return this.appBinding;
    }

    public void setApplicationBindings(ApplicationBinding a) {
        this.appBinding = a;
    }

    public ApplicationExtension getApplicationExtensions() {
        return this.appExtension;
    }

    public void setApplicationExtensions(ApplicationExtension a) {
        this.appExtension = a;
    }

    public Vector getModuleConfig(String configType) throws AppDeploymentException {
        Vector ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleConfig");
        }
        if ((ret = (Vector)this.moduleData.get(configType)) == null) {
            ret = this.createModuleConfig(configType);
            this.setModuleConfig(configType, ret);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning from getModuleConfig: " + ret);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleConfig");
        }
        return ret;
    }

    public void setModuleConfig(String configType, Vector val) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setModuleConfig");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "The val is: " + val);
        }
        if (val != null) {
            this.moduleData.put(configType, val);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setModuleConfig");
        }
    }

    protected abstract Vector createModuleConfig(String var1) throws AppDeploymentException;

    public abstract void close(boolean var1) throws AppDeploymentException;

    public abstract Hashtable getSavedResults();

    public abstract Module getModuleForDD(EObject var1) throws AppDeploymentException;

    public abstract ModuleFile getModuleFileForDD(EObject var1) throws AppDeploymentException;

    public abstract String getSecurityPolicyData(ResourceBundle var1) throws AppDeploymentException;

    public abstract String getSecurityPolicyWarning();

    public abstract String getAppDisplayName();

    public abstract boolean isStandaloneDeployment();

    public abstract InputStream getInputStream(String var1, String var2) throws AppDeploymentException;

    public abstract boolean containsURI(String var1, String var2) throws AppDeploymentException;

    public Vector getAllURIStrings() throws AppDeploymentException {
        int i;
        Vector<String> v = new Vector<String>();
        Vector conf = this.getModuleConfig(JAR_DD);
        for (i = 0; i < conf.size(); ++i) {
            v.addElement(util.formUriString(this, (EObject)conf.elementAt(i)));
        }
        conf = this.getModuleConfig(EJB3JAR_DD);
        for (i = 0; i < conf.size(); ++i) {
            v.addElement(util.formUriString(this, (EObject)conf.elementAt(i)));
        }
        conf = this.getModuleConfig(WAR_DD);
        for (i = 0; i < conf.size(); ++i) {
            v.addElement(util.formUriString(this, (EObject)conf.elementAt(i)));
        }
        conf = this.getModuleConfig(RAR_DD);
        for (i = 0; i < conf.size(); ++i) {
            v.addElement(util.formUriString(this, (EObject)conf.elementAt(i)));
        }
        return v;
    }

    public void printAppInfo(PrintStream out) {
        try {
            out.println();
            if (this.getApplication() == null) {
                out.println("Application not set.");
            } else {
                Application app = this.getApplication();
                out.println("Application DisplayName: " + app.getDisplayName());
                EList list = app.getSecurityRoles();
                Iterator iter = list.iterator();
                boolean i = true;
                while (iter.hasNext()) {
                    SecurityRole secRole = (SecurityRole)iter.next();
                }
            }
            out.println();
            out.println("For EJB Jars --> ");
            out.println();
            Vector jars = this.getModuleConfig(JAR_DD);
            for (int i = 0; i < jars.size(); ++i) {
                out.println("Jar[" + (i + 1) + "] " + ((EJBJar)jars.elementAt(i)).getDisplayName());
                out.println("DD: " + jars.elementAt(i));
                out.println("Bindings: " + this.getModuleConfig(JAR_BND).elementAt(i));
                out.println("Extensions: " + this.getModuleConfig(JAR_EXT).elementAt(i));
                out.println();
            }
            out.println("End of EJB Jars --> ");
            out.println();
            out.println("For Web Apps --> ");
            out.println();
            Vector wars = this.getModuleConfig(WAR_DD);
            for (int i = 0; i < wars.size(); ++i) {
                out.println("War[" + (i + 1) + "] " + ((WebApp)wars.elementAt(i)).getDisplayName());
                out.println("DD: " + wars.elementAt(i));
                out.println("Bindings: " + this.getModuleConfig(WAR_BND).elementAt(i));
                out.println("Extensions: " + this.getModuleConfig(WAR_EXT).elementAt(i));
                out.println();
            }
            out.println("End of Web Apps --> ");
            out.println();
        }
        catch (Throwable th) {
            out.println("Exception thrown in printing the AppDeploymentInfo " + th);
        }
    }

    public void saveAsFile(String moduleUri, String fileUriInModule, InputStream inputStream) throws AppDeploymentException {
    }

    public String getJ2EEAppVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2EEAppVersion");
        }
        String ret = "";
        if (this.app == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null Application DD");
            }
        } else {
            XMLResource xmlResource = (XMLResource)this.app.eResource();
            if (xmlResource == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AppDD has no XML Resource: " + this.app);
                }
            } else {
                String strPublicId = xmlResource.getPublicId();
                if (strPublicId == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AppDD has no XML Resource Id: " + this.app);
                    }
                } else if (strPublicId.equalsIgnoreCase("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN")) {
                    ret = AppConstants.APPDEPL_APP_VERSION_1_2;
                } else if (strPublicId.equalsIgnoreCase("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN")) {
                    ret = AppConstants.APPDEPL_APP_VERSION_1_3;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Return J2EE version: " + ret);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2EEAppVersion");
        }
        return ret;
    }

    public static String getLocalHost() {
        String host;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLocalHost");
            }
            host = null;
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception in getting local host name: " + ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalHost");
        }
        return host;
    }

    public Resource getAppDeploymentResource(boolean processEmbeddedCfg) {
        return (Resource)this.options.get(DEPL_RES);
    }
}

