/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.EditionInfo;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class EditionHelper {
    private static TraceComponent tc = Tr.register(EditionHelper.class, "AppEditions", "com.ibm.websphere.management.applications");
    private static final String CLASS_NAME = EditionHelper.class.getName();
    private static final String XD_CLASS = "com.ibm.ws.xd.util.XD";
    private static final String XD_METHOD = "isEnabledOO";
    public static final String ED = "-edition";
    public static final String EDITION_PROP_FILE = "ibm-edition-metadata.props";
    public static final String EDITION_PROP_DELIM = "-";
    public static final String BASE_EDITION = "BASE";
    public static final String DEFAULT_EDITION = "DEFAULT";
    public static final String ACTIVE_EDITION_PROP = "config.active";
    public static final String DEFAULT_EDITION_PROP = "config.default";
    public static final String STATE_EDITION_PROP = "config.state";
    public static final String Edition_INACTIVE = "INACTIVE";
    public static final String Edition_ACTIVE = "ACTIVE";
    public static final String Edition_VALIDATE = "VALIDATE";
    public static final String EDITION_PROP_HEADER = "File contains metadata for all editions of the application";
    public static final String DESC_EDITION_PROP = "edition.desc";
    private static Boolean _editionSupportIsEnabled = null;
    private static Boolean _xdIsInstalled = null;
    private static Class _xdClass = null;
    private static Boolean _xdIsAugmented = null;

    public static String[] getAppAndEdition(String mangledName) {
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppAndEdition", mangledName);
        }
        if ((index = mangledName.indexOf(ED)) == -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppAndEdition", new Object[]{mangledName, ""});
            }
            return new String[]{mangledName, ""};
        }
        String app = mangledName.substring(0, index);
        String ed = mangledName.substring(index + ED.length());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppAndEdition", new Object[]{app, ed});
        }
        return new String[]{app, ed};
    }

    public static String[] getAppAndEdition(String mangledName, Hashtable props) {
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppAndEdition", new Object[]{mangledName, props});
        }
        if ((index = mangledName.indexOf(ED)) == -1) {
            String editionName;
            String string = editionName = props != null ? (String)props.get("edition") : "";
            if (editionName == null) {
                editionName = "";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppAndEdition", new String[]{mangledName, editionName});
            }
            return new String[]{mangledName, editionName};
        }
        String app = mangledName.substring(0, index);
        String ed = mangledName.substring(index + ED.length());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppAndEdition", new String[]{app, ed});
        }
        return new String[]{app, ed};
    }

    public static String getCompositeName(String appName, String edition) {
        if (EditionHelper.isEmpty(edition)) {
            return appName;
        }
        if (edition.equalsIgnoreCase(BASE_EDITION)) {
            return appName;
        }
        if (appName.indexOf(ED) != -1) {
            return appName;
        }
        return appName + ED + edition;
    }

    public static String getCompositeName(String appName, Hashtable props) {
        if (props == null) {
            return appName;
        }
        if (appName.indexOf(ED) != -1) {
            return appName;
        }
        return EditionHelper.getCompositeName(appName, (String)props.get("edition"));
    }

    public static String getAppEarName(String appName, String edition) {
        String a = appName;
        String e = edition;
        if (appName.indexOf(ED) != -1) {
            String[] ar = EditionHelper.getAppAndEdition(appName);
            a = ar[0];
            e = ar[1];
        }
        return a + (EditionHelper.isEmpty(e) ? "" : ED + e) + ".ear";
    }

    public static String getAppEarName(String appName, Hashtable props) {
        if (appName.indexOf(ED) != -1) {
            return EditionHelper.getAppEarName(appName, (String)null);
        }
        return EditionHelper.getAppEarName(appName, (String)props.get("edition"));
    }

    public static String getEditionDescPropName(String mangledName) {
        String[] ar = EditionHelper.getAppAndEdition(mangledName);
        if (EditionHelper.isEmpty(ar[1])) {
            ar[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(DESC_EDITION_PROP, ar[1]);
    }

    public static String getActiveEditionPropName(String mangledName) {
        String[] ar = EditionHelper.getAppAndEdition(mangledName);
        if (EditionHelper.isEmpty(ar[1])) {
            ar[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(ACTIVE_EDITION_PROP, ar[1]);
    }

    public static String getDefaultEditionPropName(String mangledName) {
        String[] ar = EditionHelper.getAppAndEdition(mangledName);
        if (EditionHelper.isEmpty(ar[1])) {
            ar[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(DEFAULT_EDITION_PROP, ar[1]);
    }

    public static String getEditionPropSuffix(String mangledName) {
        String[] ar = EditionHelper.getAppAndEdition(mangledName);
        if (EditionHelper.isEmpty(ar[1])) {
            ar[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName("", ar[1]);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static synchronized boolean isEditionSupportEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEditionSupportEnabled");
        }
        if (_editionSupportIsEnabled == null) {
            boolean isEnabled = false;
            isEnabled = EditionHelper.isXDAugmented() ? true : Boolean.getBoolean("edition.enable");
            _editionSupportIsEnabled = isEnabled;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEditionSupportEnabled", _editionSupportIsEnabled);
        }
        return _editionSupportIsEnabled;
    }

    public static synchronized boolean isXDAugmented() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isXDAugmented");
        }
        if (_xdIsAugmented == null) {
            block11: {
                try {
                    if (EditionHelper.isXDInstalled()) {
                        Method isEnabled = _xdClass.getMethod(XD_METHOD, new Class[0]);
                        Object retVal = isEnabled.invoke(null, new Object[0]);
                        if (retVal instanceof Boolean) {
                            _xdIsAugmented = (Boolean)retVal;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "XD method return value: " + _xdIsAugmented);
                            }
                        } else {
                            String msg = retVal != null ? "Invocation on method isEnabledOO did not return a Boolean.  Returned type: " + retVal.getClass().getName() + "." : "Invocation on method isEnabledOO returned null value.";
                            Exception ex = new Exception(msg);
                            Manager.Ffdc.log(ex, EditionHelper.class, CLASS_NAME + ".isXDAugmented", "365");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Could not obtain augumentation status from XD.", ex);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "Unexpected error.", e);
                }
            }
            if (_xdIsAugmented == null) {
                _xdIsAugmented = Boolean.FALSE;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isXDAugmented", _xdIsAugmented);
        }
        return _xdIsAugmented;
    }

    public static synchronized boolean isXDInstalled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isXDInstalled");
        }
        if (_xdIsInstalled == null) {
            boolean result;
            block9: {
                result = false;
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    _xdClass = classLoader.loadClass(XD_CLASS);
                    if (_xdClass != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "XD class com.ibm.ws.xd.util.XD loaded.");
                        }
                        result = true;
                    }
                }
                catch (Exception e) {
                    if (e instanceof ClassNotFoundException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "XD class com.ibm.ws.xd.util.XD not found.");
                        }
                    }
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "Unexpected error loading XD class com.ibm.ws.xd.util.XD", e);
                }
            }
            _xdIsInstalled = result;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isXDInstalled", _xdIsInstalled);
        }
        return _xdIsInstalled;
    }

    public static boolean checkIfEditionValid(String edition) {
        boolean b = true;
        if (edition == null || edition.trim().length() == 0) {
            b = true;
        } else if (edition.indexOf("]]>") != -1) {
            b = false;
        } else if (edition.endsWith(" ") || edition.startsWith(" ")) {
            b = false;
        } else {
            StringTokenizer strTok = new StringTokenizer(edition, "\\/,:;\"*?<>|=+&%'");
            if (strTok.hasMoreTokens() && !strTok.nextToken().equals(edition)) {
                b = false;
            }
        }
        return b;
    }

    static boolean isSystemApp(String appName) {
        boolean bRet = false;
        if (appName != null && appName.length() > 0) {
            String earPath = System.getProperty("was.install.root") + File.separator + "systemApps" + File.separator + appName + ".ear";
            File f = new File(earPath);
            if (appName.equals("isclite") || appName.equals("adminconsole") || appName.equals("filetransfer") || appName.equals("ManagementEJB") || f.exists() && f.isDirectory() && new File(earPath + "/" + "META-INF/ibm-application-sa.props").exists()) {
                bRet = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isSystemApp = " + bRet);
                }
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EditionInfo[] getApplicationEditions(String appName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationEditions", appName);
        }
        ConfigRepository theRepository = ConfigRepositoryFactory.getConfigRepository();
        String cellName = AdminServiceFactory.getAdminService().getCellName();
        String appContext = "cells/" + cellName + "/applications/" + appName + ".ear/";
        EditionInfo[] eInfoObject = null;
        try {
            DocumentContentSource theDocSource = theRepository.extract(appContext + EDITION_PROP_FILE);
            Properties eProps = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = theDocSource.getSource();
                eProps.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        Manager.Ffdc.log(e, EditionHelper.class, CLASS_NAME + ".getApplicationEditions", "501");
                    }
                }
            }
            Enumeration<?> propNames = eProps.propertyNames();
            Hashtable<String, EditionInfo> eTable = new Hashtable<String, EditionInfo>();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String edition = null;
                String editionDesc = null;
                String state = null;
                if (!propName.startsWith(STATE_EDITION_PROP)) continue;
                if (propName.startsWith("config.state-")) {
                    edition = propName.substring(STATE_EDITION_PROP.length() + ED.length());
                    editionDesc = eProps.getProperty("edition.desc-edition" + edition);
                    state = eProps.getProperty("config.state-edition" + edition);
                } else {
                    edition = propName.substring(STATE_EDITION_PROP.length());
                    editionDesc = eProps.getProperty(DESC_EDITION_PROP);
                    state = eProps.getProperty(STATE_EDITION_PROP);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Edition = " + edition + ";Desc = " + editionDesc + ";State = " + state);
                }
                EditionInfo anEI = new EditionInfo(EditionHelper.getCompositeName(appName, edition), cellName);
                anEI.setDescription(editionDesc);
                anEI.setEditionState(state);
                eTable.put(edition, anEI);
            }
            eInfoObject = eTable.values().toArray(new EditionInfo[eTable.size()]);
        }
        catch (RepositoryException re2) {
            if (re2 instanceof DocumentNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "Failed to retrieve the edition meta-data from the Repository.");
                }
                if (EditionHelper.isSystemApp(appName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.info(tc, appName + " is a System Application.");
                    }
                    EditionInfo anEI = new EditionInfo(EditionHelper.getCompositeName(appName, ""), cellName);
                    anEI.setDescription("");
                    anEI.setEditionState(Edition_ACTIVE);
                    eInfoObject = new EditionInfo[]{anEI};
                }
                String[] resourceNames = theRepository.listResourceNames(appContext, 255, Integer.MAX_VALUE);
                if (resourceNames != null && resourceNames.length > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.info(tc, "Assume only Base edition available for " + appName + " and it is always ACTIVE.");
                    }
                    EditionInfo anEI = new EditionInfo(EditionHelper.getCompositeName(appName, ""), cellName);
                    anEI.setDescription("");
                    anEI.setEditionState(Edition_ACTIVE);
                    eInfoObject = new EditionInfo[]{anEI};
                } else {
                    Tr.error(tc, "Unexpected Error: " + appName + " -- The Application's Directory in the Repository is EMPTY.");
                    throw re2;
                }
            }
            Manager.Ffdc.log(re2, EditionHelper.class, CLASS_NAME + ".getApplicationEditions", "575");
            Tr.error(tc, "Failed to read the edition meta-data for the application, " + appName + ", due to RepositoryException.");
            eInfoObject = null;
        }
        catch (IOException ioe) {
            Manager.Ffdc.log(ioe, EditionHelper.class, CLASS_NAME + ".getApplicationEditions", "580");
            Tr.error(tc, "Failed to read the edition meta-data for the application, " + appName + ", due to IOException.");
            eInfoObject = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationEditions", eInfoObject);
        }
        return eInfoObject;
    }

    public static EditionInfo[] getApplicationEditions(String appName, AppManagement appMgmt_) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationEditions(appName, appManagement)");
        }
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "appName = " + appName);
        }
        EditionInfo[] eInfoObject = EditionHelper.getApplicationEditions(appName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationEditions(appName, appManagement)");
        }
        return eInfoObject;
    }

    public static String getActiveEditionOnServer(String appName, List applications) {
        String activeEdition = "";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveEditionOnServer");
            Tr.debug(tc, "appName " + appName + " List " + applications);
        }
        try {
            String foundActiveEdition = null;
            EditionInfo[] eInfo = EditionHelper.getApplicationEditions(appName);
            for (int i = 0; i < eInfo.length; ++i) {
                String editionState = eInfo[i].getEditionState();
                if (editionState.equalsIgnoreCase(Edition_ACTIVE)) {
                    String mangledName = EditionHelper.getCompositeName(eInfo[i].getAppName(), eInfo[i].getEdition());
                    for (int j = 0; j < applications.size(); ++j) {
                        String appDeploymentName = (String)applications.get(j);
                        if (!appDeploymentName.endsWith(mangledName)) continue;
                        foundActiveEdition = eInfo[i].getEdition();
                        break;
                    }
                }
                if (foundActiveEdition != null) break;
            }
            if (foundActiveEdition != null) {
                activeEdition = foundActiveEdition;
            }
        }
        catch (Exception e) {
            System.out.println("In getActiveEditionOnServer " + e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveEditionOnServer -> active Edition " + activeEdition);
        }
        return activeEdition;
    }

    public static String getEditionStatePropName(String mangledName) {
        String[] ar = EditionHelper.getAppAndEdition(mangledName);
        if (EditionHelper.isEmpty(ar[1])) {
            ar[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(STATE_EDITION_PROP, ar[1]);
    }

    public static boolean isAppActive(String mangledName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEditionActive " + mangledName);
        }
        boolean active = false;
        try {
            String state = EditionHelper.getEditionState(mangledName);
            active = state.equalsIgnoreCase(Edition_ACTIVE) || state.equalsIgnoreCase(Edition_VALIDATE);
        }
        catch (Exception e) {
            active = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isEditionActive(" + mangledName + ")=" + active);
        }
        return active;
    }

    public static String getEditionState(String mangledName) throws Exception {
        String state = Edition_INACTIVE;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEditionState");
        }
        String[] a = EditionHelper.getAppAndEdition(mangledName);
        AppManagement appMgmt_ = null;
        appMgmt_ = AppManagementProxy.getLocalProxy();
        EditionInfo eInfo = appMgmt_.getEditionInfo(a[0], a[1], null, null)[0];
        state = eInfo.getEditionState();
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getEditionState(" + mangledName + ")=" + state);
        }
        return state;
    }
}

